/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.graalvm.wasm.api.Vector128Ops;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;

@ExportLibrary(value=WasmMemoryLibrary.class)
final class ByteArrayWasmMemory
extends WasmMemory {
    private byte[] dynamicBuffer;
    public static final long MAX_ALLOWED_SIZE = 32767L;

    @CompilerDirectives.TruffleBoundary
    private ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, false);
        this.dynamicBuffer = ByteArrayWasmMemory.allocateBuffer(initialSize * 65536L);
    }

    @CompilerDirectives.TruffleBoundary
    ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, boolean indexType64) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, Math.min(declaredMaxSize, 32767L), indexType64);
    }

    private byte[] buffer() {
        return this.dynamicBuffer;
    }

    @ExportMessage
    public long size() {
        return this.byteSize() / 65536L;
    }

    @ExportMessage
    public long byteSize() {
        return this.buffer().length;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize()) <= 0 && Long.compareUnsigned(previousSize + extraPageSize, this.maxAllowedSize()) <= 0) {
            byte[] newBuffer;
            long targetPageSize = Math.addExact(previousSize, extraPageSize);
            long targetByteSize = Math.multiplyExact(targetPageSize, 65536);
            byte[] currentBuffer = this.buffer();
            try {
                newBuffer = ByteArrayWasmMemory.allocateBuffer(targetByteSize);
            }
            catch (WasmException oome) {
                return -1L;
            }
            System.arraycopy(currentBuffer, 0, newBuffer, 0, currentBuffer.length);
            this.dynamicBuffer = newBuffer;
            this.currentMinSize = targetPageSize;
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void reset() {
        this.dynamicBuffer = ByteArrayWasmMemory.allocateBuffer(this.declaredMinSize * 65536L);
        this.currentMinSize = this.declaredMinSize;
    }

    private void validateAddress(Node node, long address, long length) {
        ByteArrayWasmMemory.validateAddress(node, address, length, this.byteSize());
    }

    private WasmException trapOutOfBounds(Node node, long address, long length) {
        return ByteArrayWasmMemory.trapOutOfBounds(node, address, length, this.byteSize());
    }

    @ExportMessage
    public int load_i32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long load_i64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getLong(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public float load_f32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getFloat(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public double load_f64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getDouble(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int load_i32_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int load_i32_8u(Node node, long address) {
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int load_i32_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int load_i32_16u(Node node, long address) {
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long load_i64_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long load_i64_8u(Node node, long address) {
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long load_i64_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long load_i64_16u(Node node, long address) {
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long load_i64_32s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long load_i64_32u(Node node, long address) {
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public Object load_i128(Node node, long address) {
        if (ByteArraySupport.littleEndian().inBounds(this.buffer(), address, 16L)) {
            return Vector128Ops.SINGLETON_IMPLEMENTATION.fromArray(this.buffer(), (int)address);
        }
        throw this.trapOutOfBounds(node, address, 16L);
    }

    @ExportMessage
    public void store_i32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public void store_i64(Node node, long address, long value) {
        try {
            ByteArraySupport.littleEndian().putLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public void store_f32(Node node, long address, float value) {
        try {
            ByteArraySupport.littleEndian().putFloat(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public void store_f64(Node node, long address, double value) {
        try {
            ByteArraySupport.littleEndian().putDouble(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public void store_i32_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public void store_i32_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public void store_i64_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public void store_i64_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public void store_i64_32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public void store_i128(Node node, long address, Object value) {
        if (!ByteArraySupport.littleEndian().inBounds(this.buffer(), address, 16L)) {
            throw this.trapOutOfBounds(node, address, 16L);
        }
        Vector128Ops.SINGLETON_IMPLEMENTATION.intoArray(Vector128Ops.cast(value), this.buffer(), (int)address);
    }

    @ExportMessage
    public int atomic_load_i32(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getIntVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_load_i64(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getLongVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_load_i32_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByteVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_load_i32_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShortVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_load_i64_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByteVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_load_i64_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShortVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_load_i64_32u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getIntVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public void atomic_store_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public void atomic_store_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            ByteArraySupport.littleEndian().putLongVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public void atomic_store_i32_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public void atomic_store_i32_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public void atomic_store_i64_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public void atomic_store_i64_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public void atomic_store_i64_32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndSetByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndSetShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndSetInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndSetByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndSetShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndSetInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndSetLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().compareAndExchangeByte(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().compareAndExchangeShort(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeInt(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeByte(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1L);
        }
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeShort(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2L);
        }
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeInt(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4L);
        }
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeLong(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8L);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        this.validateAddress(node, address, 4L);
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        this.validateAddress(node, address, 4L);
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            throw ByteArrayWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        ByteArrayWasmMemory.validateAddress(node, address, 4L, 8L);
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        if (!this.isShared()) {
            throw ByteArrayWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @ExportMessage
    public void initialize(Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
        ByteArrayWasmMemory.validateLength(node, length);
        this.validateAddress(node, destinationOffset, length);
        if (sourceOffset < 0 || sourceOffset > source.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ByteArrayWasmMemory.trapOutOfBoundsBuffer(node, sourceOffset, length, source.length);
        }
        System.arraycopy(source, sourceOffset, this.buffer(), (int)destinationOffset, length);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void fill(Node node, long offset, long length, byte value) {
        ByteArrayWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        Arrays.fill(this.buffer(), (int)offset, (int)(offset + length), value);
    }

    @ExportMessage
    public void copyFrom(Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof ByteArrayWasmMemory);
        ByteArrayWasmMemory s = (ByteArrayWasmMemory)source;
        ByteArrayWasmMemory.validateLength(node, length);
        s.validateAddress(node, sourceOffset, length);
        this.validateAddress(node, destinationOffset, length);
        System.arraycopy(s.buffer(), (int)sourceOffset, this.buffer(), (int)destinationOffset, (int)length);
    }

    @ExportMessage
    public WasmMemory duplicate() {
        ByteArrayWasmMemory other = new ByteArrayWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size(), this.maxAllowedSize, this.indexType64);
        System.arraycopy(this.buffer(), 0, other.buffer(), 0, (int)this.byteSize());
        return other;
    }

    @ExportMessage
    public void close() {
        this.dynamicBuffer = null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        ByteArrayWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        return stream.read(this.buffer(), offset, length);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        ByteArrayWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        stream.write(this.buffer(), offset, length);
    }

    @ExportMessage
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        ByteArrayWasmMemory.validateLength(node, length);
        this.validateAddress(node, srcOffset, length);
        if (dstOffset < 0 || dstOffset > dst.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ByteArrayWasmMemory.trapOutOfBoundsBuffer(node, dstOffset, length, dst.length);
        }
        System.arraycopy(this.buffer(), (int)srcOffset, dst, dstOffset, length);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] allocateBuffer(long byteSize) {
        try {
            return new byte[Math.toIntExact(byteSize)];
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }

    @ExportMessage
    public static boolean freed(ByteArrayWasmMemory memory) {
        return true;
    }
}

