/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmNamesObject;
import org.graalvm.wasm.api.ValueType;
import org.graalvm.wasm.api.Vector128;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmGlobal
extends EmbedderDataHolder
implements TruffleObject {
    private final ValueType valueType;
    private final boolean mutable;
    private long globalValue;
    private Object globalObjectValue;
    public static final String VALUE_MEMBER = "value";

    private WasmGlobal(ValueType valueType, boolean mutable) {
        this.valueType = valueType;
        this.mutable = mutable;
    }

    public WasmGlobal(ValueType valueType, boolean mutable, int value) {
        this(valueType, mutable, (long)value);
    }

    public WasmGlobal(ValueType valueType, boolean mutable, long value) {
        this(valueType, mutable);
        assert (ValueType.isNumberType(this.getValueType()));
        this.globalValue = value;
    }

    public WasmGlobal(ValueType valueType, boolean mutable, Object value) {
        this(valueType, mutable);
        this.globalValue = switch (valueType) {
            case ValueType.i32 -> ((Integer)value).intValue();
            case ValueType.i64 -> (Long)value;
            case ValueType.f32 -> Float.floatToRawIntBits(((Float)value).floatValue());
            case ValueType.f64 -> Double.doubleToRawLongBits((Double)value);
            default -> 0L;
        };
        this.globalObjectValue = switch (valueType) {
            case ValueType.v128, ValueType.anyfunc, ValueType.externref -> value;
            default -> null;
        };
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public byte getMutability() {
        return this.mutable ? (byte)1 : 0;
    }

    public int loadAsInt() {
        assert (ValueType.isNumberType(this.getValueType()));
        return (int)this.globalValue;
    }

    public long loadAsLong() {
        assert (ValueType.isNumberType(this.getValueType()));
        return this.globalValue;
    }

    public Vector128 loadAsVector128() {
        assert (ValueType.isVectorType(this.getValueType()));
        assert (this.globalObjectValue != null);
        return (Vector128)this.globalObjectValue;
    }

    public Object loadAsReference() {
        assert (ValueType.isReferenceType(this.getValueType()));
        assert (this.globalObjectValue != null);
        return this.globalObjectValue;
    }

    public void storeInt(int value) {
        assert (ValueType.isNumberType(this.getValueType()));
        this.globalValue = value;
    }

    public void storeLong(long value) {
        assert (ValueType.isNumberType(this.getValueType()));
        this.globalValue = value;
    }

    public void storeVector128(Vector128 value) {
        assert (ValueType.isVectorType(this.getValueType()));
        this.globalObjectValue = value;
    }

    public void storeReference(Object value) {
        assert (ValueType.isReferenceType(this.getValueType()));
        this.globalObjectValue = value;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return VALUE_MEMBER.equals(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        assert (VALUE_MEMBER.equals(member)) : member;
        return switch (this.getValueType()) {
            default -> throw new IncompatibleClassChangeError();
            case ValueType.i32 -> this.loadAsInt();
            case ValueType.i64 -> this.loadAsLong();
            case ValueType.f32 -> Float.valueOf(Float.intBitsToFloat(this.loadAsInt()));
            case ValueType.f64 -> Double.longBitsToDouble(this.loadAsLong());
            case ValueType.v128 -> this.loadAsVector128();
            case ValueType.anyfunc, ValueType.externref -> this.loadAsReference();
        };
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberModifiable(String member) {
        return VALUE_MEMBER.equals(member) && this.isMutable();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(limit="5") InteropLibrary valueLibrary) throws UnknownIdentifierException, UnsupportedMessageException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        if (!this.mutable) {
            throw UnsupportedMessageException.create();
        }
        switch (this.getValueType()) {
            case i32: {
                this.storeInt(valueLibrary.asInt(value));
                break;
            }
            case i64: {
                this.storeLong(valueLibrary.asLong(value));
                break;
            }
            case f32: {
                this.storeInt(Float.floatToRawIntBits(valueLibrary.asFloat(value)));
                break;
            }
            case f64: {
                this.storeLong(Double.doubleToRawLongBits(valueLibrary.asDouble(value)));
                break;
            }
            case v128: {
                if (value instanceof Vector128) {
                    Vector128 vector = (Vector128)value;
                    this.storeVector128(vector);
                }
                throw UnsupportedMessageException.create();
            }
            case anyfunc: {
                if (value == WasmConstant.NULL || value instanceof WasmFunctionInstance) {
                    this.storeReference(value);
                }
                throw UnsupportedMessageException.create();
            }
            case externref: {
                if (value instanceof TruffleObject) {
                    this.storeReference(value);
                }
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new WasmNamesObject(new String[]{VALUE_MEMBER});
    }
}

