/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.math.BigInteger;
import org.graalvm.wasm.debugging.representation.DebugPrimitiveValue;

@GeneratedBy(value=DebugPrimitiveValue.class)
public final class DebugPrimitiveValueGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private DebugPrimitiveValueGen() {
    }

    static {
        LibraryExport.register(DebugPrimitiveValue.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=DebugPrimitiveValue.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, DebugPrimitiveValue.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof DebugPrimitiveValue);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof DebugPrimitiveValue);
            return new Cached(receiver);
        }

        @GeneratedBy(value=DebugPrimitiveValue.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends DebugPrimitiveValue> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((DebugPrimitiveValue)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).isBoolean();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asBoolean();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).isNumber();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInByte();
            }

            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asByte();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInShort();
            }

            @CompilerDirectives.TruffleBoundary
            public short asShort(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asShort();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInInt();
            }

            @CompilerDirectives.TruffleBoundary
            public int asInt(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asInt();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInLong();
            }

            @CompilerDirectives.TruffleBoundary
            public long asLong(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asLong();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInFloat();
            }

            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asFloat();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInDouble();
            }

            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asDouble();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInBigInteger(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).fitsInBigInteger();
            }

            @CompilerDirectives.TruffleBoundary
            public BigInteger asBigInteger(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asBigInteger();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).isString();
            }

            @CompilerDirectives.TruffleBoundary
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)receiver).asString();
            }
        }

        @GeneratedBy(value=DebugPrimitiveValue.class)
        public static class Cached
        extends InteropLibrary {
            private final Class<? extends DebugPrimitiveValue> receiverClass_;

            protected Cached(Object receiver) {
                DebugPrimitiveValue castReceiver = (DebugPrimitiveValue)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isBoolean();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asBoolean();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isNumber();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInByte();
            }

            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asByte();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInShort();
            }

            @CompilerDirectives.TruffleBoundary
            public short asShort(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asShort();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInInt();
            }

            @CompilerDirectives.TruffleBoundary
            public int asInt(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asInt();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInLong();
            }

            @CompilerDirectives.TruffleBoundary
            public long asLong(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asLong();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInFloat();
            }

            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asFloat();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInDouble();
            }

            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asDouble();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean fitsInBigInteger(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).fitsInBigInteger();
            }

            @CompilerDirectives.TruffleBoundary
            public BigInteger asBigInteger(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asBigInteger();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isString();
            }

            @CompilerDirectives.TruffleBoundary
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DebugPrimitiveValue)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asString();
            }
        }
    }
}

