/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import com.oracle.truffle.api.interop.InteropLibrary;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;

public abstract class DebugBinding
extends DebugObject {
    private final DebugType type;

    protected DebugBinding(DebugType type) {
        assert (type != null) : "the type of a debug binding (variable, member, ...) must not be null";
        this.type = type;
    }

    @Override
    public int valueLength() {
        return this.type.valueLength();
    }

    @Override
    public boolean isValue() {
        return this.type.isValue();
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        return this.type.asValue(context, location);
    }

    @Override
    public boolean isModifiableValue() {
        return this.type.isModifiableValue();
    }

    @Override
    public void setValue(DebugContext context, DebugLocation location, Object value, InteropLibrary lib) {
        this.type.setValue(context, location, value, lib);
    }

    @Override
    public boolean isDebugObject() {
        return this.type.isDebugObject();
    }

    @Override
    public DebugObject asDebugObject(DebugContext context, DebugLocation location) {
        return this.type.asDebugObject(context, location);
    }

    @Override
    public boolean isLocation() {
        return this.type.isLocation();
    }

    @Override
    public DebugLocation asLocation(DebugContext context, DebugLocation location) {
        return this.type.asLocation(context, location);
    }

    @Override
    public boolean fitsIntoInt() {
        return this.type.fitsIntoInt();
    }

    @Override
    public int asInt(DebugContext context, DebugLocation location) {
        return this.type.asInt(context, location);
    }

    @Override
    public boolean fitsIntoLong() {
        return this.type.fitsIntoLong();
    }

    @Override
    public long asLong(DebugContext context, DebugLocation location) {
        return this.type.asLong(context, location);
    }

    @Override
    public boolean hasMembers() {
        return this.type.hasMembers();
    }

    @Override
    public int memberCount() {
        return this.type.memberCount();
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        return this.type.readMember(context, location, index);
    }

    @Override
    public boolean hasArrayElements() {
        return this.type.hasArrayElements();
    }

    @Override
    public int arrayDimensionCount() {
        return this.type.arrayDimensionCount();
    }

    @Override
    public int arrayDimensionSize(int dimension) {
        return this.type.arrayDimensionSize(dimension);
    }

    @Override
    public DebugObject readArrayElement(DebugContext context, DebugLocation location, int index) {
        return this.type.readArrayElement(context, location, index);
    }

    @Override
    public String asTypeName() {
        return this.type.asTypeName();
    }
}

