/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging;

import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.Objects;
import org.graalvm.wasm.debugging.data.DebugAddressSize;
import org.graalvm.wasm.debugging.parser.DebugParser;
import org.graalvm.wasm.nodes.WasmDataAccess;

public final class DebugLocation {
    private static final byte LOCAL = 1;
    private static final byte GLOBAL = 2;
    private static final byte STACK = 3;
    private static final byte MEMORY = 4;
    private final MaterializedFrame frame;
    private final WasmDataAccess dataAccess;
    private final long address;
    private final byte type;
    private final DebugLocation frameBase;
    private final DebugAddressSize addressSize;

    private DebugLocation(long address, byte type, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugAddressSize addressSize) {
        this.address = address;
        this.type = type;
        this.frame = frame;
        this.dataAccess = dataAccess;
        this.frameBase = frameBase;
        this.addressSize = addressSize;
    }

    public static DebugLocation createFrameBaseOrNull(MaterializedFrame frame, WasmDataAccess dataAccess, byte[] frameBaseExpression) {
        DebugLocation location = DebugParser.readFrameBaseExpressionOrNull(frameBaseExpression, frame, dataAccess, DebugAddressSize.I32);
        if (location == null) {
            return null;
        }
        return new DebugLocation(location.address, location.type, location.frame, location.dataAccess, location.loadAsLocation(), location.addressSize);
    }

    public static DebugLocation createLocalAccess(int address, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugAddressSize addressSize) {
        return new DebugLocation(address, 1, frame, dataAccess, frameBase, addressSize);
    }

    public static DebugLocation createGlobalAccess(int address, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugAddressSize addressSize) {
        return new DebugLocation(address, 2, frame, dataAccess, frameBase, addressSize);
    }

    public static DebugLocation createStackAccess(int address, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugAddressSize addressSize) {
        return new DebugLocation(address, 3, frame, dataAccess, frameBase, addressSize);
    }

    public static DebugLocation createMemoryAccess(long address, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugAddressSize addressSize) {
        return new DebugLocation(address, 4, frame, dataAccess, frameBase, addressSize);
    }

    private static DebugLocation createInvalid(DebugLocation frameBase, MaterializedFrame frame, WasmDataAccess dataAccess, DebugAddressSize addressSize) {
        return new DebugLocation(-1L, 4, frame, dataAccess, frameBase, addressSize);
    }

    public MaterializedFrame frame() {
        return this.frame;
    }

    public WasmDataAccess dataAccess() {
        return this.dataAccess;
    }

    public DebugLocation frameBase() {
        return this.frameBase;
    }

    public DebugAddressSize addressSize() {
        return this.addressSize;
    }

    private boolean isLocal() {
        return this.type == 1;
    }

    private boolean isGlobal() {
        return this.type == 2;
    }

    private boolean isStack() {
        return this.type == 3;
    }

    private boolean isMemory() {
        return this.type == 4;
    }

    public DebugLocation nextByte() {
        return this.addOffset(1L);
    }

    public DebugLocation nextShort() {
        return this.addOffset(2L);
    }

    public DebugLocation nextInt() {
        return this.addOffset(4L);
    }

    public DebugLocation nextLong() {
        return this.addOffset(8L);
    }

    public DebugLocation addOffset(long offset) {
        if (this.isInvalid()) {
            return this;
        }
        if (this.isMemory()) {
            return new DebugLocation(this.address + offset, this.type, this.frame, this.dataAccess, Objects.requireNonNullElse(this.frameBase, this), this.addressSize);
        }
        if (this.frameBase == null) {
            DebugLocation location = this.loadAsLocation();
            return new DebugLocation(location.address + offset, location.type, location.frame, location.dataAccess, location, location.addressSize);
        }
        return this.loadAsLocation().addOffset(offset);
    }

    public boolean isInvalid() {
        return this.address < 0L || (this.isStack() || this.isLocal() || this.isGlobal()) && !this.isIntAddress();
    }

    private static int shiftInt(int value, int bitSize, int bitOffset) {
        return value << bitOffset >> 32 - bitSize;
    }

    private static int shiftUnsignedInt(int value, int bitSize, int bitOffset) {
        return value << bitOffset >>> 32 - bitSize;
    }

    private static long shiftLong(long value, int bitSize, int bitOffset) {
        return value << bitOffset >> 64 - bitSize;
    }

    private static long shiftUnsignedLong(long value, int bitSize, int bitOffset) {
        return value << bitOffset >>> 64 - bitSize;
    }

    private static int doubleShiftUnsignedInt(int value, int left, int right) {
        return value << left >>> right;
    }

    private static int doubleShiftInt(int value, int left, int right) {
        return value << left >> right;
    }

    private static long doubleShiftUnsignedLong(long value, int left, int right) {
        return value << left >>> right;
    }

    private static long doubleShiftLong(long value, int left, int right) {
        return value << left >> right;
    }

    private boolean isIntAddress() {
        return this.address < Integer.MAX_VALUE;
    }

    private boolean isValidLocation(int valueLength) {
        int index = (int)this.address;
        return this.isStack() && this.isIntAddress() && this.dataAccess.isValidStackIndex(this.frame, index) || this.isLocal() && this.isIntAddress() && this.dataAccess.isValidLocalIndex(this.frame, index) || this.isGlobal() && this.isIntAddress() && this.dataAccess.isValidGlobalIndex(index) || this.isMemory() && this.dataAccess.isValidMemoryAddress(this.frame, this.address, valueLength);
    }

    public byte loadI8() {
        if (!this.isValidLocation(1)) {
            return 0;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return (byte)this.dataAccess.loadI32FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return (byte)this.dataAccess.loadI32FromLocals(this.frame, index);
        }
        if (this.isGlobal()) {
            return (byte)this.dataAccess.loadI32FromGlobals(this.frame, index);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadI8FromMemory(this.frame, this.address);
        }
        return 0;
    }

    public byte loadI8(int bitSize, int bitOffset) {
        byte value = this.loadI8();
        if (bitSize >= 0) {
            if (bitOffset < 0) {
                byte upper = this.nextByte().loadI8();
                int upperValue = DebugLocation.doubleShiftInt(upper, 32 + bitOffset, bitSize + bitOffset + 24);
                int lowerValue = value >>> 8 - (bitSize + bitOffset);
                return (byte)(upperValue | lowerValue);
            }
            return (byte)DebugLocation.shiftInt(value, bitSize, bitOffset + 24);
        }
        return value;
    }

    public int loadU8(int bitSize, int bitOffset) {
        byte value = this.loadI8();
        if (bitSize < 0) {
            return value & 0xFF;
        }
        if (bitOffset < 0) {
            byte upper = this.nextByte().loadI8();
            int upperValue = DebugLocation.doubleShiftUnsignedInt(upper, 32 + bitOffset, 32 - bitSize);
            int lowerValue = (value & 0xFF) >>> 8 - (bitSize + bitOffset);
            return (upperValue | lowerValue) & 0xFF;
        }
        return DebugLocation.shiftUnsignedInt(value, bitSize, bitOffset + 24) & 0xFF;
    }

    public int loadU8() {
        return this.loadU8(-1, 0);
    }

    public void store8(int bitSize, byte value) {
        if (!this.isValidLocation(1) || bitSize >= 0) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeI32IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeI32IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeI32IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeI8IntoMemory(this.frame, this.address, value);
        }
    }

    public short loadI16() {
        if (!this.isValidLocation(2)) {
            return 0;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return (short)this.dataAccess.loadI32FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return (short)this.dataAccess.loadI32FromLocals(this.frame, (int)this.address);
        }
        if (this.isGlobal()) {
            return (short)this.dataAccess.loadI32FromGlobals(this.frame, (int)this.address);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadI16FromMemory(this.frame, this.address);
        }
        return 0;
    }

    public short loadI16(int bitSize, int bitOffset) {
        short value = this.loadI16();
        if (bitSize < 0) {
            return value;
        }
        if (bitOffset < 0) {
            short upper = this.nextShort().loadI16();
            int upperValue = DebugLocation.doubleShiftInt(upper, 32 + bitOffset, 32 - bitSize);
            int lowerValue = value >>> 16 - (bitSize + bitOffset);
            return (short)(upperValue | lowerValue);
        }
        return (short)DebugLocation.shiftInt(value, bitSize, bitOffset + 16);
    }

    public int loadU16(int bitSize, int bitOffset) {
        short value = this.loadI16();
        if (bitSize < 0) {
            return value & 0xFFFF;
        }
        if (bitOffset < 0) {
            short upper = this.nextShort().loadI16();
            int upperValue = DebugLocation.doubleShiftUnsignedInt(upper, 32 + bitOffset, 32 - bitSize);
            int lowerValue = (value & 0xFFFF) >>> 16 - (bitSize + bitOffset);
            return (upperValue | lowerValue) & 0xFFFF;
        }
        return DebugLocation.shiftUnsignedInt(value, bitSize, bitOffset + 16) & 0xFFFF;
    }

    public void store16(int bitSize, short value) {
        if (!this.isValidLocation(1) || bitSize >= 0) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeI32IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeI32IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeI32IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeI16IntoMemory(this.frame, this.address, value);
        }
    }

    private int loadI32() {
        if (!this.isValidLocation(4)) {
            return 0;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return this.dataAccess.loadI32FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return this.dataAccess.loadI32FromLocals(this.frame, index);
        }
        if (this.isGlobal()) {
            return this.dataAccess.loadI32FromGlobals(this.frame, index);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadI32FromMemory(this.frame, this.address);
        }
        return 0;
    }

    public int loadI32(int bitSize, int bitOffset) {
        int value = this.loadI32();
        if (bitSize < 0) {
            return value;
        }
        if (bitOffset < 0) {
            int upper = this.nextInt().loadI32();
            int upperValue = DebugLocation.doubleShiftInt(upper, 32 + bitOffset, 32 - bitSize);
            int lowerValue = value >>> 32 - (bitSize + bitOffset);
            return upperValue | lowerValue;
        }
        return DebugLocation.shiftInt(value, bitSize, bitOffset);
    }

    public long loadU32(int bitSize, int bitOffset) {
        int value = this.loadI32();
        if (bitSize < 0) {
            return Integer.toUnsignedLong(value);
        }
        if (bitOffset < 0) {
            int upper = this.nextInt().loadI32();
            int upperValue = DebugLocation.doubleShiftUnsignedInt(upper, 32 + bitOffset, 32 - bitSize);
            int lowerValue = value >>> 32 - (bitSize + bitOffset);
            return Integer.toUnsignedLong(upperValue | lowerValue);
        }
        return Integer.toUnsignedLong(DebugLocation.shiftUnsignedInt(value, bitSize, bitOffset));
    }

    public long loadU32() {
        return this.loadU32(-1, 0);
    }

    public void store32(int bitSize, int value) {
        if (!this.isValidLocation(1) || bitSize >= 0) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeI32IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeI32IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeI32IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeI32IntoMemory(this.frame, this.address, value);
        }
    }

    private long loadI64() {
        if (!this.isValidLocation(8)) {
            return 0L;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return this.dataAccess.loadI64FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return this.dataAccess.loadI64FromLocals(this.frame, index);
        }
        if (this.isGlobal()) {
            return this.dataAccess.loadI64FromGlobals(this.frame, index);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadI64FromMemory(this.frame, this.address);
        }
        return 0L;
    }

    public long loadI64(int bitSize, int bitOffset) {
        long value = this.loadI64();
        if (bitSize < 0) {
            return value;
        }
        if (bitOffset < 0) {
            long upper = this.nextLong().loadI64();
            long upperValue = DebugLocation.doubleShiftLong(upper, 64 + bitOffset, 64 - bitSize);
            long lowerValue = value >>> 64 - (bitSize + bitOffset);
            return upperValue | lowerValue;
        }
        return DebugLocation.shiftLong(value, bitSize, bitOffset);
    }

    public String loadU64(int bitSize, int bitOffset) {
        long value = this.loadI64();
        if (bitSize < 0) {
            return Long.toUnsignedString(value);
        }
        if (bitOffset < 0) {
            long upper = this.nextLong().loadI64();
            long upperValue = DebugLocation.doubleShiftUnsignedLong(upper, 64 + bitOffset, 64 - bitSize);
            long lowerValue = value >>> 64 - (bitSize + bitOffset);
            return Long.toUnsignedString(upperValue | lowerValue);
        }
        return Long.toUnsignedString(DebugLocation.shiftUnsignedLong(value, bitSize, bitOffset));
    }

    public void store64(int bitSize, long value) {
        if (!this.isValidLocation(1) || bitSize >= 0) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeI64IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeI64IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeI64IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeI64IntoMemory(this.frame, this.address, value);
        }
    }

    public float loadF32() {
        if (!this.isValidLocation(4)) {
            return 0.0f;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return this.dataAccess.loadF32FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return this.dataAccess.loadF32FromLocals(this.frame, index);
        }
        if (this.isGlobal()) {
            return this.dataAccess.loadF32FromGlobals(this.frame, index);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadF32FromMemory(this.frame, this.address);
        }
        return 0.0f;
    }

    public void storeF32(float value) {
        if (!this.isValidLocation(4)) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeF32IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeF32IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeF32IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeF32IntoMemory(this.frame, this.address, value);
        }
    }

    public double loadF64() {
        if (!this.isValidLocation(8)) {
            return 0.0;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            return this.dataAccess.loadF64FromStack(this.frame, index);
        }
        if (this.isLocal()) {
            return this.dataAccess.loadF64FromLocals(this.frame, index);
        }
        if (this.isGlobal()) {
            return this.dataAccess.loadF64FromGlobals(this.frame, index);
        }
        if (this.isMemory()) {
            return this.dataAccess.loadF64FromMemory(this.frame, this.address);
        }
        return 0.0;
    }

    public void storeF64(double value) {
        if (!this.isValidLocation(8)) {
            return;
        }
        int index = (int)this.address;
        if (this.isStack()) {
            this.dataAccess.storeF64IntoStack(this.frame, index, value);
        }
        if (this.isLocal()) {
            this.dataAccess.storeF64IntoLocals(this.frame, index, value);
        }
        if (this.isGlobal()) {
            this.dataAccess.storeF64IntoGlobals(this.frame, index, value);
        }
        if (this.isMemory()) {
            this.dataAccess.storeF64IntoMemory(this.frame, this.address, value);
        }
    }

    public String loadString(int length) {
        if (!this.isValidLocation(length)) {
            return "";
        }
        return this.addOffset(0L).loadStringFromMemory(length);
    }

    private String loadStringFromMemory(int length) {
        if (this.isMemory()) {
            return this.dataAccess.loadStringFromMemory(this.frame, this.address, length);
        }
        return "";
    }

    public DebugLocation loadAsLocation() {
        if (this.isInvalid()) {
            return this;
        }
        if (this.addressSize == DebugAddressSize.I32 && this.isValidLocation(4)) {
            return DebugLocation.createMemoryAccess(this.loadI32(), this.frame, this.dataAccess, this.frameBase, this.addressSize);
        }
        if (this.addressSize == DebugAddressSize.I64 && this.isValidLocation(8)) {
            return DebugLocation.createMemoryAccess(this.loadI64(), this.frame, this.dataAccess, this.frameBase, this.addressSize);
        }
        return DebugLocation.createInvalid(this.frameBase, this.frame, this.dataAccess, this.addressSize);
    }

    public DebugLocation invalidate() {
        return DebugLocation.createInvalid(this.frameBase, this.frame, this.dataAccess, this.addressSize);
    }

    public boolean isZero() {
        return this.address == 0L;
    }

    public String toString() {
        if (this.isStack()) {
            return "operand stack value " + this.address;
        }
        if (this.isLocal()) {
            return "local " + this.address;
        }
        if (this.isGlobal()) {
            return "global " + this.address;
        }
        return "0x" + Long.toHexString(this.address);
    }
}

