/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging;

import java.nio.file.Path;
import java.util.TreeMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.wasm.debugging.DebugLineSection;

public final class DebugLineMap {
    private final Path filePath;
    private final TreeMap<Integer, Integer> sourceOffsetToLineMap;
    private final TreeMap<Integer, Integer> lineToSourceOffsetMap;

    public DebugLineMap(Path filePath) {
        this.filePath = filePath;
        this.sourceOffsetToLineMap = new TreeMap();
        this.lineToSourceOffsetMap = new TreeMap();
    }

    public void add(int sourceOffset, int line) {
        if (line == 0) {
            return;
        }
        if (!this.lineToSourceOffsetMap.containsKey(line)) {
            this.lineToSourceOffsetMap.put(line, sourceOffset);
        }
        this.sourceOffsetToLineMap.put(sourceOffset, line);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public int getNextLine(int startOffset, int endOffset) {
        Integer location = this.sourceOffsetToLineMap.ceilingKey(startOffset);
        if (location == null) {
            return -1;
        }
        if (location <= endOffset) {
            return this.sourceOffsetToLineMap.get(location);
        }
        return -1;
    }

    public DebugLineSection getLineIndexMap(int startOffset, int endOffset) {
        Integer nextLocation;
        EconomicSet uniqueLines = EconomicSet.create();
        EconomicMap offsetToLineIndexMap = EconomicMap.create();
        EconomicMap lineToLineIndexMap = EconomicMap.create();
        int location = startOffset;
        while (location <= endOffset && (nextLocation = this.sourceOffsetToLineMap.ceilingKey(location)) != null) {
            int line = this.sourceOffsetToLineMap.get(nextLocation);
            if (!uniqueLines.contains((Object)line)) {
                uniqueLines.add((Object)line);
                lineToLineIndexMap.put((Object)line, (Object)lineToLineIndexMap.size());
            }
            int lineIndex = (Integer)lineToLineIndexMap.get((Object)line);
            offsetToLineIndexMap.put((Object)nextLocation, (Object)lineIndex);
            location = nextLocation + 1;
        }
        return new DebugLineSection((EconomicSet<Integer>)uniqueLines, (EconomicMap<Integer, Integer>)offsetToLineIndexMap);
    }

    public int getSourceOffset(int line) {
        Integer value = this.lineToSourceOffsetMap.get(line);
        if (value == null) {
            return -1;
        }
        return value;
    }
}

