/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.collection;

public final class BooleanArrayList {
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private boolean[] array = null;
    private int offset = 0;

    public void add(boolean b) {
        this.ensureSize();
        this.array[this.offset] = b;
        ++this.offset;
    }

    public boolean popBack() {
        --this.offset;
        return this.array[this.offset];
    }

    public boolean get(int index) {
        return this.array[index];
    }

    public int size() {
        return this.offset;
    }

    private void ensureSize() {
        if (this.array == null) {
            this.array = new boolean[4];
        } else if (this.offset == this.array.length) {
            boolean[] narray = new boolean[this.array.length * 2];
            System.arraycopy(this.array, 0, narray, 0, this.offset);
            this.array = narray;
        }
    }

    public boolean[] toArray() {
        boolean[] result = new boolean[this.offset];
        if (this.array != null) {
            System.arraycopy(this.array, 0, result, 0, this.offset);
            return result;
        }
        return EMPTY_BOOLEAN_ARRAY;
    }
}

