/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.nio.ByteOrder;

@ExportLibrary(value=InteropLibrary.class)
@CompilerDirectives.ValueType
public final class Vector128
implements TruffleObject {
    private static final ByteArraySupport byteArraySupport = ByteArraySupport.littleEndian();
    public static final Vector128 ZERO = new Vector128(new byte[16]);
    public static final int BYTES = 16;
    public static final int BYTE_LENGTH = 16;
    public static final int SHORT_LENGTH = 8;
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 2;
    public static final int FLOAT_LENGTH = 4;
    public static final int DOUBLE_LENGTH = 2;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] bytes;

    public Vector128(byte[] bytes) {
        assert (bytes.length == 16);
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public short[] toShorts() {
        return Vector128.fromBytesToShorts(this.bytes);
    }

    public static Vector128 fromShorts(short[] shorts) {
        return new Vector128(Vector128.fromShortsToBytes(shorts));
    }

    public int[] toInts() {
        return Vector128.fromBytesToInts(this.bytes);
    }

    public static Vector128 fromInts(int[] ints) {
        return new Vector128(Vector128.fromIntsToBytes(ints));
    }

    public long[] toLongs() {
        return Vector128.fromBytesToLongs(this.bytes);
    }

    public static Vector128 fromLongs(long[] longs) {
        return new Vector128(Vector128.fromLongsToBytes(longs));
    }

    public float[] toFloats() {
        return Vector128.fromBytesToFloats(this.bytes);
    }

    public static Vector128 fromFloats(float[] floats) {
        return new Vector128(Vector128.fromFloatsToBytes(floats));
    }

    public double[] toDoubles() {
        return Vector128.fromBytesToDoubles(this.bytes);
    }

    public static Vector128 fromDoubles(double[] doubles) {
        return new Vector128(Vector128.fromDoublesToBytes(doubles));
    }

    @ExplodeLoop
    public static short[] fromBytesToShorts(byte[] bytes) {
        assert (bytes.length == 16);
        short[] shorts = new short[8];
        for (int i = 0; i < 8; ++i) {
            shorts[i] = byteArraySupport.getShort(bytes, i * 2);
        }
        return shorts;
    }

    @ExplodeLoop
    public static int[] fromBytesToInts(byte[] bytes) {
        assert (bytes.length == 16);
        int[] ints = new int[4];
        for (int i = 0; i < 4; ++i) {
            ints[i] = byteArraySupport.getInt(bytes, i * 4);
        }
        return ints;
    }

    @ExplodeLoop
    public static long[] fromBytesToLongs(byte[] bytes) {
        assert (bytes.length == 16);
        long[] longs = new long[2];
        for (int i = 0; i < 2; ++i) {
            longs[i] = byteArraySupport.getLong(bytes, i * 8);
        }
        return longs;
    }

    @ExplodeLoop
    public static float[] fromBytesToFloats(byte[] bytes) {
        assert (bytes.length == 16);
        float[] floats = new float[4];
        for (int i = 0; i < 4; ++i) {
            floats[i] = byteArraySupport.getFloat(bytes, i * 4);
        }
        return floats;
    }

    @ExplodeLoop
    public static double[] fromBytesToDoubles(byte[] bytes) {
        assert (bytes.length == 16);
        double[] doubles = new double[2];
        for (int i = 0; i < 2; ++i) {
            doubles[i] = byteArraySupport.getDouble(bytes, i * 8);
        }
        return doubles;
    }

    @ExplodeLoop
    public static byte[] fromShortsToBytes(short[] shorts) {
        assert (shorts.length == 8);
        byte[] bytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byteArraySupport.putShort(bytes, i * 2, shorts[i]);
        }
        return bytes;
    }

    @ExplodeLoop
    public static byte[] fromIntsToBytes(int[] ints) {
        assert (ints.length == 4);
        byte[] bytes = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byteArraySupport.putInt(bytes, i * 4, ints[i]);
        }
        return bytes;
    }

    @ExplodeLoop
    public static byte[] fromLongsToBytes(long[] longs) {
        assert (longs.length == 2);
        byte[] bytes = new byte[16];
        for (int i = 0; i < 2; ++i) {
            byteArraySupport.putLong(bytes, i * 8, longs[i]);
        }
        return bytes;
    }

    @ExplodeLoop
    public static byte[] fromFloatsToBytes(float[] floats) {
        assert (floats.length == 4);
        byte[] bytes = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byteArraySupport.putFloat(bytes, i * 4, floats[i]);
        }
        return bytes;
    }

    @ExplodeLoop
    public static byte[] fromDoublesToBytes(double[] doubles) {
        assert (doubles.length == 2);
        byte[] bytes = new byte[16];
        for (int i = 0; i < 2; ++i) {
            byteArraySupport.putDouble(bytes, i * 8, doubles[i]);
        }
        return bytes;
    }

    private static ByteArraySupport byteArraySupportForByteOrder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian();
        }
        assert (byteOrder == ByteOrder.BIG_ENDIAN);
        return ByteArraySupport.bigEndian();
    }

    @ExportMessage
    protected static boolean hasBufferElements(Vector128 receiver) {
        return true;
    }

    @ExportMessage
    protected static int getBufferSize(Vector128 receiver) {
        return 16;
    }

    private void validateReadByteOffset(long byteOffset, int length) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || byteOffset > (long)(Vector128.getBufferSize(this) - length)) {
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
        }
    }

    @ExportMessage
    protected byte readBufferByte(long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 1);
        return this.bytes[(int)byteOffset];
    }

    @ExportMessage
    protected void readBuffer(long byteOffset, byte[] destination, int destinationOffset, int length) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, length);
        System.arraycopy(this.bytes, (int)byteOffset, destination, destinationOffset, length);
    }

    @ExportMessage
    protected short readBufferShort(ByteOrder byteOrder, long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 2);
        return Vector128.byteArraySupportForByteOrder(byteOrder).getShort(this.bytes, (int)byteOffset);
    }

    @ExportMessage
    protected int readBufferInt(ByteOrder byteOrder, long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 4);
        return Vector128.byteArraySupportForByteOrder(byteOrder).getInt(this.bytes, (int)byteOffset);
    }

    @ExportMessage
    protected long readBufferLong(ByteOrder byteOrder, long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 8);
        return Vector128.byteArraySupportForByteOrder(byteOrder).getLong(this.bytes, (int)byteOffset);
    }

    @ExportMessage
    protected float readBufferFloat(ByteOrder byteOrder, long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 4);
        return Vector128.byteArraySupportForByteOrder(byteOrder).getFloat(this.bytes, (int)byteOffset);
    }

    @ExportMessage
    protected double readBufferDouble(ByteOrder byteOrder, long byteOffset) throws InvalidBufferOffsetException {
        this.validateReadByteOffset(byteOffset, 8);
        return Vector128.byteArraySupportForByteOrder(byteOrder).getDouble(this.bytes, (int)byteOffset);
    }
}

