/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import java.util.Arrays;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.WasmConstant;

public final class WasmTable
extends EmbedderDataHolder
implements TruffleObject {
    private final int declaredMinSize;
    private final int declaredMaxSize;
    private final byte elemType;
    private int currentMinSize;
    private final int maxAllowedSize;
    private Object[] elements;

    @CompilerDirectives.TruffleBoundary
    private WasmTable(int declaredMinSize, int declaredMaxSize, int initialSize, int maxAllowedSize, byte elemType, Object initialValue) {
        assert (Integer.compareUnsigned(declaredMinSize, initialSize) <= 0);
        assert (Integer.compareUnsigned(initialSize, maxAllowedSize) <= 0);
        assert (Integer.compareUnsigned(maxAllowedSize, declaredMaxSize) <= 0);
        assert (Integer.compareUnsigned(maxAllowedSize, Integer.MAX_VALUE) <= 0);
        assert (Integer.compareUnsigned(declaredMaxSize, -1) <= 0);
        assert (elemType == 112 || elemType == 111);
        this.declaredMinSize = declaredMinSize;
        this.declaredMaxSize = declaredMaxSize;
        this.maxAllowedSize = maxAllowedSize;
        this.currentMinSize = declaredMinSize;
        this.elements = new Object[declaredMinSize];
        Arrays.fill(this.elements, initialValue);
        this.elemType = elemType;
    }

    public WasmTable(int declaredMinSize, int declaredMaxSize, int maxAllowedSize, byte elemType) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, maxAllowedSize, elemType, WasmConstant.NULL);
    }

    public WasmTable(int declaredMinSize, int declaredMaxSize, int maxAllowedSize, byte elemType, Object initialValue) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, maxAllowedSize, elemType, initialValue);
    }

    @CompilerDirectives.TruffleBoundary
    public void reset() {
        this.elements = new Object[this.declaredMinSize];
        Arrays.fill(this.elements, WasmConstant.NULL);
        this.currentMinSize = this.declaredMinSize;
    }

    public int size() {
        return this.elements.length;
    }

    public int declaredMinSize() {
        return this.declaredMinSize;
    }

    public int declaredMaxSize() {
        return this.declaredMaxSize;
    }

    public byte elemType() {
        return this.elemType;
    }

    public int minSize() {
        return this.currentMinSize;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object get(int index) {
        return this.elements[index];
    }

    public void set(int index, Object element) {
        this.elements[index] = element;
    }

    public void initialize(Object[] elemInstance, int sourceOffset, int destinationOffset, int length) {
        System.arraycopy(elemInstance, sourceOffset, this.elements, destinationOffset, length);
    }

    @CompilerDirectives.TruffleBoundary
    public void fill(int offset, int length, Object value) {
        assert (offset + length <= this.size());
        Arrays.fill(this.elements, offset, offset + length, value);
    }

    public void copyFrom(WasmTable source, int sourceOffset, int destinationOffset, int length) {
        System.arraycopy(source.elements, sourceOffset, this.elements, destinationOffset, length);
    }

    @CompilerDirectives.TruffleBoundary
    public int grow(int delta, Object value) {
        int size = this.size();
        int targetSize = size + delta;
        if (Integer.compareUnsigned(delta, this.maxAllowedSize) <= 0 && Integer.compareUnsigned(targetSize, this.maxAllowedSize) <= 0) {
            this.elements = Arrays.copyOf(this.elements, targetSize);
            Arrays.fill(this.elements, size, targetSize, value);
            this.currentMinSize += targetSize;
            return size;
        }
        return -1;
    }
}

