/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.graalvm.wasm.WasmFunction;

public final class WasmCodeEntry {
    private final WasmFunction function;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] bytecode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] localTypes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] resultTypes;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final int numLocals;
    private final int resultCount;
    private final boolean usesMemoryZero;

    public WasmCodeEntry(WasmFunction function, byte[] bytecode, byte[] localTypes, byte[] resultTypes, boolean usesMemoryZero) {
        this.function = function;
        this.bytecode = bytecode;
        this.localTypes = localTypes;
        this.numLocals = localTypes.length;
        this.resultTypes = resultTypes;
        this.resultCount = resultTypes.length;
        this.usesMemoryZero = usesMemoryZero;
    }

    public WasmFunction function() {
        return this.function;
    }

    public byte[] bytecode() {
        return this.bytecode;
    }

    public byte localType(int index) {
        return this.localTypes[index];
    }

    public int localCount() {
        return this.numLocals;
    }

    public int functionIndex() {
        return this.function.index();
    }

    public int resultCount() {
        return this.resultCount;
    }

    public byte resultType(int index) {
        return this.resultTypes[index];
    }

    public void errorBranch() {
        this.errorBranch.enter();
    }

    public boolean usesMemoryZero() {
        return this.usesMemoryZero;
    }

    public String toString() {
        return "wasm-code-entry:" + this.functionIndex();
    }
}

