/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ExceptionType;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.wasm.Assert;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmType;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.Vector128Shape;
import org.graalvm.wasm.collection.ByteArrayList;
import org.graalvm.wasm.constants.Bytecode;
import org.graalvm.wasm.constants.Section;
import org.graalvm.wasm.debugging.parser.DebugUtil;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.BytecodeGen;
import org.graalvm.wasm.parser.bytecode.BytecodeParser;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.ir.CallNode;
import org.graalvm.wasm.parser.ir.CodeEntry;
import org.graalvm.wasm.parser.validation.ParserState;

public class BinaryParser
extends BinaryStreamParser {
    private static final int MAGIC = 1836278016;
    private static final int VERSION = 1;
    private final WasmModule module;
    private final WasmContext wasmContext;
    private final int[] multiResult;
    private final long[] longMultiResult;
    private final boolean[] booleanMultiResult;
    private final boolean multiValue;
    private final boolean bulkMemoryAndRefTypes;
    private final boolean memory64;
    private final boolean multiMemory;
    private final boolean threads;
    private final boolean simd;

    @CompilerDirectives.TruffleBoundary
    public BinaryParser(WasmModule module, WasmContext context, byte[] data) {
        super(data);
        this.module = module;
        this.wasmContext = context;
        this.multiResult = new int[2];
        this.longMultiResult = new long[2];
        this.booleanMultiResult = new boolean[2];
        this.multiValue = context.getContextOptions().supportMultiValue();
        this.bulkMemoryAndRefTypes = context.getContextOptions().supportBulkMemoryAndRefTypes();
        this.memory64 = context.getContextOptions().supportMemory64();
        this.multiMemory = context.getContextOptions().supportMultiMemory();
        this.threads = context.getContextOptions().supportThreads();
        this.simd = context.getContextOptions().supportSIMD();
    }

    @CompilerDirectives.TruffleBoundary
    public void readModule() {
        this.module.limits().checkModuleSize(this.data.length);
        this.validateMagicNumberAndVersion();
        this.readSymbolSections();
    }

    private void validateMagicNumberAndVersion() {
        Assert.assertIntEqual(this.read4(), 1836278016, Failure.INVALID_MAGIC_NUMBER);
        Assert.assertIntEqual(this.read4(), 1, Failure.INVALID_VERSION_NUMBER);
    }

    private void readSymbolSections() {
        byte lastNonCustomSection = 0;
        int codeSectionOffset = -1;
        int codeSectionLength = 0;
        boolean dataSectionPresent = false;
        RuntimeBytecodeGen bytecode = new RuntimeBytecodeGen();
        BytecodeGen customData = new BytecodeGen();
        BytecodeGen functionDebugData = new BytecodeGen();
        while (!this.isEOF()) {
            byte sectionID = this.read1();
            if (sectionID != 0) {
                if (Section.isNextSectionOrderValid(sectionID, lastNonCustomSection)) {
                    if (Integer.compareUnsigned(sectionID, Section.LAST_SECTION_ID) > 0) {
                        Assert.fail(Failure.MALFORMED_SECTION_ID, "invalid section ID: " + sectionID);
                    }
                    lastNonCustomSection = sectionID;
                } else {
                    if (Integer.compareUnsigned(sectionID, Section.LAST_SECTION_ID) > 0 || lastNonCustomSection == sectionID) {
                        throw WasmException.create(Failure.UNEXPECTED_CONTENT_AFTER_LAST_SECTION);
                    }
                    throw WasmException.create(Failure.INVALID_SECTION_ORDER, "Section " + sectionID + " defined after section " + lastNonCustomSection);
                }
            }
            int size = this.readLength();
            int startOffset = this.offset;
            switch (sectionID) {
                case 0: {
                    this.readCustomSection(size, customData);
                    break;
                }
                case 1: {
                    this.readTypeSection();
                    break;
                }
                case 2: {
                    this.readImportSection();
                    break;
                }
                case 3: {
                    this.readFunctionSection();
                    break;
                }
                case 4: {
                    this.readTableSection();
                    break;
                }
                case 5: {
                    this.readMemorySection();
                    break;
                }
                case 6: {
                    this.readGlobalSection();
                    break;
                }
                case 7: {
                    this.readExportSection();
                    break;
                }
                case 8: {
                    this.readStartSection();
                    break;
                }
                case 9: {
                    this.readElementSection(bytecode);
                    break;
                }
                case 12: {
                    if (this.bulkMemoryAndRefTypes) {
                        this.readDataCountSection(size);
                        break;
                    }
                    Assert.fail(Failure.MALFORMED_SECTION_ID, "invalid section ID: " + sectionID);
                    break;
                }
                case 10: {
                    codeSectionOffset = this.offset;
                    this.readCodeSection(bytecode, functionDebugData);
                    codeSectionLength = size;
                    break;
                }
                case 11: {
                    dataSectionPresent = true;
                    this.readDataSection(bytecode);
                }
            }
            Assert.assertIntEqual(this.offset - startOffset, size, Failure.SECTION_SIZE_MISMATCH, "Declared section (0x%02X) size is incorrect", sectionID);
        }
        if (codeSectionOffset == -1) {
            Assert.assertIntEqual(this.module.numFunctions(), this.module.numImportedFunctions(), Failure.FUNCTIONS_CODE_INCONSISTENT_LENGTHS);
            codeSectionOffset = 0;
        }
        if (this.bulkMemoryAndRefTypes && !dataSectionPresent) {
            this.module.checkDataSegmentCount(0);
        }
        this.module.setBytecode(bytecode.toArray());
        this.module.finishSymbolTable();
        this.module.setCustomData(customData.toArray());
        if (this.module.hasDebugInfo()) {
            functionDebugData.add(codeSectionLength);
            byte[] codeSection = new byte[codeSectionLength + functionDebugData.location()];
            System.arraycopy(this.data, codeSectionOffset, codeSection, 0, codeSectionLength);
            System.arraycopy(functionDebugData.toArray(), 0, codeSection, codeSectionLength, functionDebugData.location());
            this.module.setCodeSection(codeSection);
        }
    }

    private void readCustomSection(int size, BytecodeGen customData) {
        int sectionEndOffset = this.offset + size;
        String name = this.readName();
        Assert.assertUnsignedIntLessOrEqual(sectionEndOffset, this.data.length, Failure.LENGTH_OUT_OF_BOUNDS);
        Assert.assertUnsignedIntLessOrEqual(this.offset, sectionEndOffset, Failure.UNEXPECTED_END);
        int customDataSection = customData.location();
        int sectionSize = sectionEndOffset - this.offset;
        customData.addBytes(this.data, this.offset, sectionSize);
        this.module.allocateCustomSection(name, customDataSection, sectionSize);
        if ("name".equals(name)) {
            try {
                this.readNameSection();
            }
            catch (WasmException ex) {
                assert (ex.getExceptionType() == ExceptionType.PARSE_ERROR);
            }
        } else {
            this.readDebugSection(name, customDataSection, sectionSize, customData);
        }
        this.offset = sectionEndOffset;
    }

    private void readDebugSection(String name, int sectionOffset, int size, BytecodeGen customData) {
        switch (name) {
            case ".debug_abbrev": {
                DebugUtil.setAbbrevOffset(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
                break;
            }
            case ".debug_info": {
                DebugUtil.setInfo(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
                break;
            }
            case ".debug_line": {
                DebugUtil.setLineOffset(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
                break;
            }
            case ".debug_loc": {
                DebugUtil.setLocOffset(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
                break;
            }
            case ".debug_ranges": {
                DebugUtil.setRangesOffset(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
                break;
            }
            case ".debug_str": {
                DebugUtil.setStrOffset(customData, this.allocateDebugOffsets(customData), sectionOffset, size);
            }
        }
    }

    private int allocateDebugOffsets(BytecodeGen customData) {
        if (this.module.hasDebugInfo()) {
            return this.module.debugInfoOffset();
        }
        int location = customData.location();
        customData.allocate(48);
        DebugUtil.initializeData(customData, location);
        this.module.setDebugInfoOffset(location);
        return location;
    }

    private void readNameSection() {
        if (!this.isEOF() && this.peek1() == 0) {
            this.readModuleName();
        }
        if (!this.isEOF() && this.peek1() == 1) {
            this.readFunctionNames();
        }
        if (!this.isEOF() && this.peek1() == 2) {
            this.readLocalNames();
        }
    }

    private void readModuleName() {
        byte subsectionId = this.read1();
        assert (subsectionId == 0);
        int size = this.readLength();
        this.offset += size;
    }

    private void readFunctionNames() {
        byte subsectionId = this.read1();
        assert (subsectionId == 1);
        int size = this.readLength();
        int startOffset = this.offset;
        int length = this.readLength();
        int maxFunctionIndex = this.module.numFunctions() - 1;
        for (int i = 0; i < length; ++i) {
            int functionIndex = this.readFunctionIndex();
            Assert.assertIntLessOrEqual(0, functionIndex, "Negative function index", Failure.UNSPECIFIED_MALFORMED);
            Assert.assertIntLessOrEqual(functionIndex, maxFunctionIndex, "Function index too large", Failure.UNSPECIFIED_MALFORMED);
            String functionName = this.readName();
            this.module.function(functionIndex).setDebugName(functionName);
        }
        Assert.assertIntEqual(this.offset - startOffset, size, Failure.SECTION_SIZE_MISMATCH);
    }

    private void readLocalNames() {
        byte subsectionId = this.read1();
        assert (subsectionId == 2);
        int size = this.readLength();
        this.offset += size;
    }

    private void readTypeSection() {
        int typeCount = this.readLength();
        this.module.limits().checkTypeCount(typeCount);
        for (int typeIndex = 0; typeIndex != typeCount; ++typeIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            byte type = this.read1();
            if (type == 96) {
                this.readFunctionType();
                continue;
            }
            Assert.fail(Failure.INTEGER_REPRESENTATION_TOO_LONG, "Only function types are supported in the type section");
        }
    }

    private void readImportSection() {
        Assert.assertIntEqual(this.module.symbolTable().numGlobals(), 0, Failure.UNSPECIFIED_INVALID, "The global index should be -1 when the import section is first read.");
        int importCount = this.readLength();
        this.module.limits().checkImportCount(importCount);
        block6: for (int importIndex = 0; importIndex != importCount; ++importIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            String moduleName = this.readName();
            String memberName = this.readName();
            byte importType = this.readImportType();
            switch (importType) {
                case 0: {
                    int typeIndex = this.readTypeIndex();
                    this.module.symbolTable().importFunction(moduleName, memberName, typeIndex);
                    continue block6;
                }
                case 1: {
                    byte elemType = this.readRefType();
                    if (!this.bulkMemoryAndRefTypes) {
                        Assert.assertByteEqual(elemType, (byte)112, "Invalid element type for table import", Failure.UNSPECIFIED_MALFORMED);
                    }
                    this.readTableLimits(this.multiResult);
                    int tableIndex = this.module.tableCount();
                    this.module.symbolTable().importTable(moduleName, memberName, tableIndex, this.multiResult[0], this.multiResult[1], elemType, this.bulkMemoryAndRefTypes);
                    continue block6;
                }
                case 2: {
                    this.readMemoryLimits(this.longMultiResult, this.booleanMultiResult);
                    int memoryIndex = this.module.memoryCount();
                    boolean is64Bit = this.booleanMultiResult[0];
                    boolean isShared = this.booleanMultiResult[1];
                    this.module.symbolTable().importMemory(moduleName, memberName, memoryIndex, this.longMultiResult[0], this.longMultiResult[1], is64Bit, isShared, this.multiMemory);
                    continue block6;
                }
                case 3: {
                    byte type = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
                    byte mutability = this.readMutability();
                    int index = this.module.symbolTable().numGlobals();
                    this.module.symbolTable().importGlobal(moduleName, memberName, index, type, mutability);
                    continue block6;
                }
                default: {
                    Assert.fail(Failure.MALFORMED_IMPORT_KIND, "Invalid import type identifier: 0x%02X", importType);
                }
            }
        }
    }

    private void readFunctionSection() {
        int functionCount = this.readLength();
        this.module.limits().checkFunctionCount(functionCount);
        for (int functionIndex = 0; functionIndex != functionCount; ++functionIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            int functionTypeIndex = this.readUnsignedInt32();
            this.module.symbolTable().declareFunction(functionTypeIndex);
        }
    }

    private void readTableSection() {
        int tableCount = this.readLength();
        int startingTableIndex = this.module.tableCount();
        this.module.limits().checkTableCount(startingTableIndex + tableCount);
        for (int tableIndex = startingTableIndex; tableIndex != startingTableIndex + tableCount; ++tableIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            byte elemType = this.readRefType();
            this.readTableLimits(this.multiResult);
            this.module.symbolTable().allocateTable(tableIndex, this.multiResult[0], this.multiResult[1], elemType, this.bulkMemoryAndRefTypes);
        }
    }

    private void readMemorySection() {
        int memoryCount = this.readLength();
        int startingMemoryIndex = this.module.memoryCount();
        this.module.limits().checkMemoryCount(startingMemoryIndex + memoryCount, this.multiMemory);
        for (int memoryIndex = startingMemoryIndex; memoryIndex != startingMemoryIndex + memoryCount; ++memoryIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            this.readMemoryLimits(this.longMultiResult, this.booleanMultiResult);
            boolean is64Bit = this.booleanMultiResult[0];
            boolean isShared = this.booleanMultiResult[1];
            boolean useUnsafeMemory = this.wasmContext.getContextOptions().useUnsafeMemory();
            boolean directByteBufferMemoryAccess = this.wasmContext.getContextOptions().directByteBufferMemoryAccess();
            this.module.symbolTable().allocateMemory(memoryIndex, this.longMultiResult[0], this.longMultiResult[1], is64Bit, isShared, this.multiMemory, useUnsafeMemory, directByteBufferMemoryAccess);
        }
    }

    private void readCodeSection(RuntimeBytecodeGen bytecode, BytecodeGen functionDebugData) {
        int codeSectionOffset = this.offset;
        int importedFunctionCount = this.module.numImportedFunctions();
        int codeEntryCount = this.readLength();
        int expectedCodeEntryCount = this.module.numFunctions() - importedFunctionCount;
        Assert.assertIntEqual(codeEntryCount, expectedCodeEntryCount, Failure.FUNCTIONS_CODE_INCONSISTENT_LENGTHS);
        CodeEntry[] codeEntries = new CodeEntry[codeEntryCount];
        for (int entryIndex = 0; entryIndex != codeEntryCount; ++entryIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            int codeEntrySize = this.readUnsignedInt32();
            int startOffset = this.offset;
            this.module.limits().checkFunctionSize(codeEntrySize);
            ByteArrayList locals = this.readCodeEntryLocals();
            int localCount = locals.size() + this.module.function(importedFunctionCount + entryIndex).paramCount();
            this.module.limits().checkLocalCount(localCount);
            functionDebugData.add(startOffset - codeSectionOffset);
            functionDebugData.add(this.offset - codeSectionOffset);
            codeEntries[entryIndex] = this.readCodeEntry(importedFunctionCount + entryIndex, locals, startOffset + codeEntrySize, entryIndex < codeEntryCount - 1, bytecode, entryIndex);
            functionDebugData.add(this.offset - codeSectionOffset);
            Assert.assertIntEqual(this.offset - startOffset, codeEntrySize, Failure.UNSPECIFIED_MALFORMED, "Code entry %d size is incorrect", entryIndex);
        }
        this.module.setCodeEntries(codeEntries);
    }

    private CodeEntry readCodeEntry(int functionIndex, ByteArrayList locals, int endOffset, boolean hasNextFunction, RuntimeBytecodeGen bytecode, int codeEntryIndex) {
        int index;
        WasmFunction function = this.module.symbolTable().function(functionIndex);
        int paramCount = function.paramCount();
        byte[] localTypes = new byte[function.paramCount() + locals.size()];
        for (index = 0; index != paramCount; ++index) {
            localTypes[index] = function.paramTypeAt(index);
        }
        for (index = 0; index != locals.size(); ++index) {
            localTypes[index + paramCount] = locals.get(index);
        }
        byte[] resultTypes = new byte[function.resultCount()];
        for (int index2 = 0; index2 != resultTypes.length; ++index2) {
            resultTypes[index2] = function.resultTypeAt(index2);
        }
        return this.readFunction(functionIndex, localTypes, resultTypes, endOffset, hasNextFunction, bytecode, codeEntryIndex, null);
    }

    private ByteArrayList readCodeEntryLocals() {
        int localsGroupCount = this.readLength();
        ByteArrayList localTypes = new ByteArrayList();
        int localsLength = 0;
        for (int localGroup = 0; localGroup != localsGroupCount; ++localGroup) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            int groupLength = this.readUnsignedInt32();
            this.module.limits().checkLocalCount(localsLength += groupLength);
            byte t = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
            for (int i = 0; i != groupLength; ++i) {
                localTypes.add(t);
            }
        }
        return localTypes;
    }

    private byte[] extractBlockParamTypes(int typeIndex) {
        int paramCount = this.module.functionTypeParamCount(typeIndex);
        byte[] params = new byte[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            params[i] = this.module.functionTypeParamTypeAt(typeIndex, i);
        }
        return params;
    }

    private byte[] extractBlockResultTypes(int typeIndex) {
        int resultCount = this.module.functionTypeResultCount(typeIndex);
        byte[] results = new byte[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            results[i] = this.module.functionTypeResultTypeAt(typeIndex, i);
        }
        return results;
    }

    private static byte[] encapsulateResultType(int type) {
        switch (type) {
            case 64: {
                return WasmType.VOID_TYPE_ARRAY;
            }
            case 127: {
                return WasmType.I32_TYPE_ARRAY;
            }
            case 126: {
                return WasmType.I64_TYPE_ARRAY;
            }
            case 125: {
                return WasmType.F32_TYPE_ARRAY;
            }
            case 124: {
                return WasmType.F64_TYPE_ARRAY;
            }
            case 123: {
                return WasmType.V128_TYPE_ARRAY;
            }
            case 112: {
                return WasmType.FUNCREF_TYPE_ARRAY;
            }
            case 111: {
                return WasmType.EXTERNREF_TYPE_ARRAY;
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL);
    }

    private CodeEntry readFunction(int functionIndex, byte[] locals, byte[] resultTypes, int sourceCodeEndOffset, boolean hasNextFunction, RuntimeBytecodeGen bytecode, int codeEntryIndex, EconomicMap<Integer, Integer> offsetToLineIndexMap) {
        ParserState state = new ParserState(bytecode);
        ArrayList<CallNode> callNodes = new ArrayList<CallNode>();
        int bytecodeStartOffset = bytecode.location();
        state.enterFunction(resultTypes);
        block50: while (this.offset < sourceCodeEndOffset) {
            Integer lineIndex;
            if (offsetToLineIndexMap != null && (lineIndex = (Integer)offsetToLineIndexMap.get((Object)this.offset)) != null) {
                bytecode.addNotify(lineIndex, this.offset);
            }
            int opcode = this.read1() & 0xFF;
            switch (opcode) {
                case 0: {
                    state.setUnreachable();
                    state.addInstruction(0);
                    continue block50;
                }
                case 1: {
                    state.addInstruction(1);
                    continue block50;
                }
                case 2: {
                    byte[] blockResultTypes;
                    byte[] blockParamTypes;
                    this.readBlockType(this.multiResult, this.bulkMemoryAndRefTypes, this.simd);
                    if (this.multiResult[1] == 0) {
                        blockParamTypes = WasmType.VOID_TYPE_ARRAY;
                        blockResultTypes = BinaryParser.encapsulateResultType(this.multiResult[0]);
                    } else if (this.multiValue) {
                        int typeIndex = this.multiResult[0];
                        state.checkFunctionTypeExists(typeIndex, this.module.typeCount());
                        blockParamTypes = this.extractBlockParamTypes(typeIndex);
                        blockResultTypes = this.extractBlockResultTypes(typeIndex);
                    } else {
                        throw WasmException.create(Failure.DISABLED_MULTI_VALUE);
                    }
                    state.popAll(blockParamTypes);
                    state.enterBlock(blockParamTypes, blockResultTypes);
                    continue block50;
                }
                case 3: {
                    byte[] loopResultTypes;
                    byte[] loopParamTypes;
                    this.readBlockType(this.multiResult, this.bulkMemoryAndRefTypes, this.simd);
                    if (this.multiResult[1] == 0) {
                        loopParamTypes = WasmType.VOID_TYPE_ARRAY;
                        loopResultTypes = BinaryParser.encapsulateResultType(this.multiResult[0]);
                    } else if (this.multiValue) {
                        int typeIndex = this.multiResult[0];
                        state.checkFunctionTypeExists(typeIndex, this.module.typeCount());
                        loopParamTypes = this.extractBlockParamTypes(typeIndex);
                        loopResultTypes = this.extractBlockResultTypes(typeIndex);
                    } else {
                        throw WasmException.create(Failure.DISABLED_MULTI_VALUE);
                    }
                    state.popAll(loopParamTypes);
                    state.enterLoop(loopParamTypes, loopResultTypes);
                    continue block50;
                }
                case 4: {
                    byte[] ifResultTypes;
                    byte[] ifParamTypes;
                    state.popChecked((byte)127);
                    this.readBlockType(this.multiResult, this.bulkMemoryAndRefTypes, this.simd);
                    if (this.multiResult[1] == 0) {
                        ifParamTypes = WasmType.VOID_TYPE_ARRAY;
                        ifResultTypes = BinaryParser.encapsulateResultType(this.multiResult[0]);
                    } else if (this.multiValue) {
                        int typeIndex = this.multiResult[0];
                        state.checkFunctionTypeExists(typeIndex, this.module.typeCount());
                        ifParamTypes = this.extractBlockParamTypes(typeIndex);
                        ifResultTypes = this.extractBlockResultTypes(typeIndex);
                    } else {
                        throw WasmException.create(Failure.DISABLED_MULTI_VALUE);
                    }
                    state.popAll(ifParamTypes);
                    state.enterIf(ifParamTypes, ifResultTypes);
                    continue block50;
                }
                case 11: {
                    state.exit(this.multiValue);
                    if (state.controlStackSize() != 0) continue block50;
                    break block50;
                }
                case 5: {
                    state.enterElse();
                    continue block50;
                }
                case 12: {
                    int branchLabel = this.readTargetOffset();
                    state.addUnconditionalBranch(branchLabel);
                    state.setUnreachable();
                    continue block50;
                }
                case 13: {
                    int branchLabel = this.readTargetOffset();
                    state.popChecked((byte)127);
                    state.addConditionalBranch(branchLabel);
                    continue block50;
                }
                case 14: {
                    state.popChecked((byte)127);
                    int length = this.readLength();
                    int[] branchTable = new int[length + 1];
                    for (int i = 0; i != length + 1; ++i) {
                        int branchLabel;
                        branchTable[i] = branchLabel = this.readTargetOffset();
                    }
                    state.addBranchTable(branchTable);
                    state.setUnreachable();
                    continue block50;
                }
                case 15: {
                    if (offsetToLineIndexMap != null) {
                        bytecode.addNotify(-1, -1);
                    }
                    state.addReturn(this.multiValue);
                    state.setUnreachable();
                    continue block50;
                }
                case 16: {
                    int callFunctionIndex = this.readDeclaredFunctionIndex();
                    WasmFunction function = this.module.function(callFunctionIndex);
                    byte[] params = new byte[function.paramCount()];
                    for (int i = function.paramCount() - 1; i >= 0; --i) {
                        params[i] = function.paramTypeAt(i);
                    }
                    state.checkParamTypes(params);
                    if (!this.multiValue) {
                        Assert.assertIntLessOrEqual(function.resultCount(), 1, Failure.INVALID_RESULT_ARITY);
                    }
                    state.pushAll(function.type().resultTypes());
                    state.addCall(callNodes.size(), callFunctionIndex);
                    callNodes.add(new CallNode(bytecode.location(), callFunctionIndex));
                    continue block50;
                }
                case 17: {
                    int expectedFunctionTypeIndex = this.readUnsignedInt32();
                    int tableIndex = this.readTableIndex();
                    state.popChecked((byte)127);
                    state.checkFunctionTypeExists(expectedFunctionTypeIndex, this.module.typeCount());
                    Assert.assertByteEqual((byte)112, this.module.tableElementType(tableIndex), Failure.TYPE_MISMATCH);
                    for (int i = this.module.functionTypeParamCount(expectedFunctionTypeIndex) - 1; i >= 0; --i) {
                        state.popChecked(this.module.functionTypeParamTypeAt(expectedFunctionTypeIndex, i));
                    }
                    int resultCount = this.module.functionTypeResultCount(expectedFunctionTypeIndex);
                    if (!this.multiValue) {
                        Assert.assertIntLessOrEqual(resultCount, 1, Failure.INVALID_RESULT_ARITY);
                    }
                    byte[] callResultTypes = new byte[resultCount];
                    for (int i = 0; i < resultCount; ++i) {
                        callResultTypes[i] = this.module.functionTypeResultTypeAt(expectedFunctionTypeIndex, i);
                    }
                    state.pushAll(callResultTypes);
                    state.addIndirectCall(callNodes.size(), expectedFunctionTypeIndex, tableIndex);
                    callNodes.add(new CallNode(bytecode.location()));
                    continue block50;
                }
                case 26: {
                    byte type = state.pop();
                    if (WasmType.isNumberType(type)) {
                        state.addInstruction(21);
                        continue block50;
                    }
                    state.addInstruction(22);
                    continue block50;
                }
                case 27: {
                    state.popChecked((byte)127);
                    byte t1 = state.pop();
                    byte t2 = state.pop();
                    Assert.assertTrue(!(!WasmType.isNumberType(t1) && !WasmType.isVectorType(t1) || !WasmType.isNumberType(t2) && !WasmType.isVectorType(t2)), Failure.TYPE_MISMATCH);
                    Assert.assertTrue(t1 == t2 || t1 == -1 || t2 == -1, Failure.TYPE_MISMATCH);
                    byte t = t1 == -1 ? t2 : t1;
                    state.push(t);
                    if (WasmType.isNumberType(t)) {
                        state.addSelectInstruction(23);
                        continue block50;
                    }
                    state.addSelectInstruction(24);
                    continue block50;
                }
                case 28: {
                    this.checkBulkMemoryAndRefTypesSupport(opcode);
                    int length = this.readLength();
                    Assert.assertIntEqual(length, 1, Failure.INVALID_RESULT_ARITY);
                    byte t = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
                    state.popChecked((byte)127);
                    state.popChecked(t);
                    state.popChecked(t);
                    state.push(t);
                    if (WasmType.isNumberType(t)) {
                        state.addSelectInstruction(23);
                        continue block50;
                    }
                    state.addSelectInstruction(24);
                    continue block50;
                }
                case 32: {
                    int localIndex = this.readLocalIndex();
                    Assert.assertUnsignedIntLess(localIndex, locals.length, Failure.UNKNOWN_LOCAL);
                    byte localType = locals[localIndex];
                    state.push(localType);
                    if (WasmType.isNumberType(localType)) {
                        state.addUnsignedInstruction(25, localIndex);
                        continue block50;
                    }
                    state.addUnsignedInstruction(27, localIndex);
                    continue block50;
                }
                case 33: {
                    int localIndex = this.readLocalIndex();
                    Assert.assertUnsignedIntLess(localIndex, locals.length, Failure.UNKNOWN_LOCAL);
                    byte localType = locals[localIndex];
                    state.popChecked(localType);
                    if (WasmType.isNumberType(localType)) {
                        state.addUnsignedInstruction(29, localIndex);
                        continue block50;
                    }
                    state.addUnsignedInstruction(31, localIndex);
                    continue block50;
                }
                case 34: {
                    int localIndex = this.readLocalIndex();
                    Assert.assertUnsignedIntLess(localIndex, locals.length, Failure.UNKNOWN_LOCAL);
                    byte localType = locals[localIndex];
                    state.popChecked(localType);
                    state.push(localType);
                    if (WasmType.isNumberType(localType)) {
                        state.addUnsignedInstruction(33, localIndex);
                        continue block50;
                    }
                    state.addUnsignedInstruction(35, localIndex);
                    continue block50;
                }
                case 35: {
                    int index = this.readGlobalIndex();
                    state.push(this.module.symbolTable().globalValueType(index));
                    state.addUnsignedInstruction(37, index);
                    continue block50;
                }
                case 36: {
                    int index = this.readGlobalIndex();
                    Assert.assertByteEqual(this.module.symbolTable().globalMutability(index), (byte)1, "Immutable globals cannot be set: " + index, Failure.IMMUTABLE_GLOBAL_WRITE);
                    state.popChecked(this.module.symbolTable().globalValueType(index));
                    state.addUnsignedInstruction(39, index);
                    continue block50;
                }
                case 37: {
                    this.checkBulkMemoryAndRefTypesSupport(opcode);
                    int index = this.readTableIndex();
                    byte elementType = this.module.tableElementType(index);
                    state.popChecked((byte)127);
                    state.push(elementType);
                    state.addInstruction(249, index);
                    continue block50;
                }
                case 38: {
                    this.checkBulkMemoryAndRefTypesSupport(opcode);
                    int index = this.readTableIndex();
                    byte elementType = this.module.tableElementType(index);
                    state.popChecked(elementType);
                    state.popChecked((byte)127);
                    state.addInstruction(250, index);
                    continue block50;
                }
                case 42: {
                    this.load(state, (byte)125, 32, this.longMultiResult);
                    state.addMemoryInstruction(47, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 43: {
                    this.load(state, (byte)124, 64, this.longMultiResult);
                    state.addMemoryInstruction(50, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 40: {
                    this.load(state, (byte)127, 32, this.longMultiResult);
                    state.addMemoryInstruction(41, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 44: {
                    this.load(state, (byte)127, 8, this.longMultiResult);
                    state.addMemoryInstruction(53, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 45: {
                    this.load(state, (byte)127, 8, this.longMultiResult);
                    state.addMemoryInstruction(56, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 46: {
                    this.load(state, (byte)127, 16, this.longMultiResult);
                    state.addMemoryInstruction(59, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 47: {
                    this.load(state, (byte)127, 16, this.longMultiResult);
                    state.addMemoryInstruction(62, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 41: {
                    this.load(state, (byte)126, 64, this.longMultiResult);
                    state.addMemoryInstruction(44, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 48: {
                    this.load(state, (byte)126, 8, this.longMultiResult);
                    state.addMemoryInstruction(65, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 49: {
                    this.load(state, (byte)126, 8, this.longMultiResult);
                    state.addMemoryInstruction(68, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 50: {
                    this.load(state, (byte)126, 16, this.longMultiResult);
                    state.addMemoryInstruction(71, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 51: {
                    this.load(state, (byte)126, 16, this.longMultiResult);
                    state.addMemoryInstruction(74, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 52: {
                    this.load(state, (byte)126, 32, this.longMultiResult);
                    state.addMemoryInstruction(77, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 53: {
                    this.load(state, (byte)126, 32, this.longMultiResult);
                    state.addMemoryInstruction(80, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 56: {
                    this.store(state, (byte)125, 32, this.longMultiResult);
                    state.addMemoryInstruction(89, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 57: {
                    this.store(state, (byte)124, 64, this.longMultiResult);
                    state.addMemoryInstruction(92, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 54: {
                    this.store(state, (byte)127, 32, this.longMultiResult);
                    state.addMemoryInstruction(83, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 58: {
                    this.store(state, (byte)127, 8, this.longMultiResult);
                    state.addMemoryInstruction(95, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 59: {
                    this.store(state, (byte)127, 16, this.longMultiResult);
                    state.addMemoryInstruction(98, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 55: {
                    this.store(state, (byte)126, 64, this.longMultiResult);
                    state.addMemoryInstruction(86, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 60: {
                    this.store(state, (byte)126, 8, this.longMultiResult);
                    state.addMemoryInstruction(101, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 61: {
                    this.store(state, (byte)126, 16, this.longMultiResult);
                    state.addMemoryInstruction(104, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 62: {
                    this.store(state, (byte)126, 32, this.longMultiResult);
                    state.addMemoryInstruction(107, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                    continue block50;
                }
                case 63: {
                    int memoryIndex;
                    if (this.multiMemory) {
                        memoryIndex = this.readMemoryIndex();
                    } else {
                        memoryIndex = this.read1();
                        Assert.assertIntEqual(memoryIndex, 0, Failure.ZERO_BYTE_EXPECTED);
                        this.checkMemoryIndex(0);
                    }
                    if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
                        state.push((byte)126);
                        state.addMiscFlag();
                        state.addInstruction(20, memoryIndex);
                        continue block50;
                    }
                    state.push((byte)127);
                    state.addInstruction(110, memoryIndex);
                    continue block50;
                }
                case 64: {
                    int memoryIndex;
                    if (this.multiMemory) {
                        memoryIndex = this.readMemoryIndex();
                    } else {
                        memoryIndex = this.read1();
                        Assert.assertIntEqual(memoryIndex, 0, Failure.ZERO_BYTE_EXPECTED);
                        this.checkMemoryIndex(0);
                    }
                    if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
                        state.popChecked((byte)126);
                        state.push((byte)126);
                        state.addMiscFlag();
                        state.addInstruction(21, memoryIndex);
                        continue block50;
                    }
                    state.popChecked((byte)127);
                    state.push((byte)127);
                    state.addInstruction(111, memoryIndex);
                    continue block50;
                }
                default: {
                    this.readNumericInstructions(state, opcode);
                    continue block50;
                }
            }
        }
        Assert.assertIntEqual(state.valueStackSize(), resultTypes.length, Failure.TYPE_MISMATCH, "Stack size must match the return type length at the function end");
        if (hasNextFunction) {
            Assert.assertIntEqual(state.controlStackSize(), 0, Failure.END_OPCODE_EXPECTED);
        } else if (state.controlStackSize() != 0) {
            this.peek1();
            Assert.fail(Failure.SECTION_SIZE_MISMATCH, "END opcode expected");
        }
        int bytecodeEndOffset = bytecode.location();
        if (offsetToLineIndexMap == null) {
            bytecode.addCodeEntry(functionIndex, state.maxStackSize(), bytecodeEndOffset - bytecodeStartOffset, locals.length, resultTypes.length);
            for (byte local : locals) {
                bytecode.addByte(local);
            }
            if (locals.length != 0) {
                bytecode.addByte((byte)0);
            }
            for (byte result : resultTypes) {
                bytecode.addByte(result);
            }
            if (resultTypes.length != 0) {
                bytecode.addByte((byte)0);
            }
            this.module.setCodeEntryOffset(codeEntryIndex, bytecodeEndOffset);
        } else {
            bytecode.addNotify(-1, -1);
        }
        return new CodeEntry(functionIndex, state.maxStackSize(), locals, resultTypes, callNodes, bytecodeStartOffset, bytecodeEndOffset, state.usesMemoryZero());
    }

    private void readNumericInstructions(ParserState state, int opcode) {
        block0 : switch (opcode) {
            case 65: {
                int value = this.readSignedInt32();
                state.push((byte)127);
                state.addSignedInstruction(112, value);
                break;
            }
            case 66: {
                long value = this.readSignedInt64();
                state.push((byte)126);
                state.addSignedInstruction(114, value);
                break;
            }
            case 67: {
                int value = this.read4();
                state.push((byte)125);
                state.addInstruction(116, value);
                break;
            }
            case 68: {
                long value = this.read8();
                state.push((byte)124);
                state.addInstruction(117, value);
                break;
            }
            case 69: {
                state.popChecked((byte)127);
                state.push((byte)127);
                state.addInstruction(118);
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                state.popChecked((byte)127);
                state.popChecked((byte)127);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 80: {
                state.popChecked((byte)126);
                state.push((byte)127);
                state.addInstruction(129);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                state.popChecked((byte)126);
                state.popChecked((byte)126);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                state.popChecked((byte)125);
                state.popChecked((byte)125);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                state.popChecked((byte)124);
                state.popChecked((byte)124);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                state.popChecked((byte)127);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                state.popChecked((byte)126);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                state.popChecked((byte)126);
                state.popChecked((byte)126);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                state.popChecked((byte)125);
                state.push((byte)125);
                state.addInstruction(opcode + 49);
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                state.popChecked((byte)125);
                state.popChecked((byte)125);
                state.push((byte)125);
                state.addInstruction(opcode + 49);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                state.popChecked((byte)124);
                state.push((byte)124);
                state.addInstruction(opcode + 49);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                state.popChecked((byte)124);
                state.popChecked((byte)124);
                state.push((byte)124);
                state.addInstruction(opcode + 49);
                break;
            }
            case 167: {
                state.popChecked((byte)126);
                state.push((byte)127);
                state.addInstruction(216);
                break;
            }
            case 168: 
            case 169: 
            case 188: {
                state.popChecked((byte)125);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 170: 
            case 171: {
                state.popChecked((byte)124);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 172: 
            case 173: {
                state.popChecked((byte)127);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 174: 
            case 175: {
                state.popChecked((byte)125);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 176: 
            case 177: 
            case 189: {
                state.popChecked((byte)124);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 178: 
            case 179: 
            case 190: {
                state.popChecked((byte)127);
                state.push((byte)125);
                state.addInstruction(opcode + 49);
                break;
            }
            case 180: 
            case 181: {
                state.popChecked((byte)126);
                state.push((byte)125);
                state.addInstruction(opcode + 49);
                break;
            }
            case 182: {
                state.popChecked((byte)124);
                state.push((byte)125);
                state.addInstruction(opcode + 49);
                break;
            }
            case 183: 
            case 184: {
                state.popChecked((byte)127);
                state.push((byte)124);
                state.addInstruction(opcode + 49);
                break;
            }
            case 185: 
            case 186: 
            case 191: {
                state.popChecked((byte)126);
                state.push((byte)124);
                state.addInstruction(opcode + 49);
                break;
            }
            case 187: {
                state.popChecked((byte)125);
                state.push((byte)124);
                state.addInstruction(opcode + 49);
                break;
            }
            case 252: {
                int miscOpcode = this.readUnsignedInt32();
                switch (miscOpcode) {
                    case 0: 
                    case 1: {
                        this.checkSaturatingFloatToIntSupport(miscOpcode);
                        state.popChecked((byte)125);
                        state.push((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(miscOpcode);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.checkSaturatingFloatToIntSupport(miscOpcode);
                        state.popChecked((byte)124);
                        state.push((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(miscOpcode);
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        this.checkSaturatingFloatToIntSupport(miscOpcode);
                        state.popChecked((byte)125);
                        state.push((byte)126);
                        state.addMiscFlag();
                        state.addInstruction(miscOpcode);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        this.checkSaturatingFloatToIntSupport(miscOpcode);
                        state.popChecked((byte)124);
                        state.push((byte)126);
                        state.addMiscFlag();
                        state.addInstruction(miscOpcode);
                        break block0;
                    }
                    case 8: {
                        int memoryIndex;
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int dataIndex = this.readUnsignedInt32();
                        if (this.multiMemory) {
                            memoryIndex = this.readMemoryIndex();
                        } else {
                            this.read1();
                            memoryIndex = 0;
                            this.checkMemoryIndex(0);
                        }
                        this.module.checkDataSegmentIndex(dataIndex);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
                            state.popChecked((byte)126);
                            state.addMiscFlag();
                            state.addInstruction(10, dataIndex, memoryIndex);
                            break block0;
                        }
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(8, dataIndex, memoryIndex);
                        break block0;
                    }
                    case 9: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int dataIndex = this.readUnsignedInt32();
                        this.module.checkDataSegmentIndex(dataIndex);
                        state.addMiscFlag();
                        state.addInstruction(12, dataIndex);
                        break block0;
                    }
                    case 10: {
                        int srcMemoryIndex;
                        int destMemoryIndex;
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        if (this.multiMemory) {
                            destMemoryIndex = this.readMemoryIndex();
                            srcMemoryIndex = this.readMemoryIndex();
                        } else {
                            this.read1();
                            this.read1();
                            destMemoryIndex = 0;
                            srcMemoryIndex = 0;
                            this.checkMemoryIndex(0);
                        }
                        if (this.module.memoryHasIndexType64(destMemoryIndex) && this.module.memoryHasIndexType64(srcMemoryIndex) && this.memory64) {
                            state.popChecked((byte)126);
                            state.popChecked((byte)126);
                            state.popChecked((byte)126);
                            state.addMiscFlag();
                            state.addInstruction(17, destMemoryIndex, srcMemoryIndex);
                            break block0;
                        }
                        if (this.module.memoryHasIndexType64(destMemoryIndex) && !this.module.memoryHasIndexType64(srcMemoryIndex) && this.memory64) {
                            state.popChecked((byte)127);
                            state.popChecked((byte)127);
                            state.popChecked((byte)126);
                            state.addMiscFlag();
                            state.addInstruction(16, destMemoryIndex, srcMemoryIndex);
                            break block0;
                        }
                        if (!this.module.memoryHasIndexType64(destMemoryIndex) && this.module.memoryHasIndexType64(srcMemoryIndex) && this.memory64) {
                            state.popChecked((byte)127);
                            state.popChecked((byte)126);
                            state.popChecked((byte)127);
                            state.addMiscFlag();
                            state.addInstruction(15, destMemoryIndex, srcMemoryIndex);
                            break block0;
                        }
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(14, destMemoryIndex, srcMemoryIndex);
                        break block0;
                    }
                    case 11: {
                        int memoryIndex;
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        if (this.multiMemory) {
                            memoryIndex = this.readMemoryIndex();
                        } else {
                            this.read1();
                            memoryIndex = 0;
                            this.checkMemoryIndex(0);
                        }
                        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
                            state.popChecked((byte)126);
                            state.popChecked((byte)127);
                            state.popChecked((byte)126);
                            state.addMiscFlag();
                            state.addInstruction(19, memoryIndex);
                            break block0;
                        }
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(18, memoryIndex);
                        break block0;
                    }
                    case 12: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int elementIndex = this.readUnsignedInt32();
                        int tableIndex = this.readTableIndex();
                        this.module.checkElemIndex(elementIndex);
                        byte elementType = this.module.tableElementType(tableIndex);
                        this.module.checkElemType(elementIndex, elementType);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(22, elementIndex, tableIndex);
                        break block0;
                    }
                    case 13: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int elementIndex = this.readUnsignedInt32();
                        this.module.checkElemIndex(elementIndex);
                        state.addMiscFlag();
                        state.addInstruction(23, elementIndex);
                        break block0;
                    }
                    case 14: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int destinationTableIndex = this.readTableIndex();
                        byte destinationElementType = this.module.tableElementType(destinationTableIndex);
                        int sourceTableIndex = this.readTableIndex();
                        byte sourceElementType = this.module.tableElementType(sourceTableIndex);
                        Assert.assertByteEqual(sourceElementType, destinationElementType, Failure.TYPE_MISMATCH);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(24, sourceTableIndex, destinationTableIndex);
                        break block0;
                    }
                    case 16: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int tableIndex = this.readTableIndex();
                        state.push((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(26, tableIndex);
                        break block0;
                    }
                    case 15: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int tableIndex = this.readTableIndex();
                        byte elementType = this.module.tableElementType(tableIndex);
                        state.popChecked((byte)127);
                        state.popChecked(elementType);
                        state.push((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(25, tableIndex);
                        break block0;
                    }
                    case 17: {
                        this.checkBulkMemoryAndRefTypesSupport(miscOpcode);
                        int tableIndex = this.readTableIndex();
                        byte elementType = this.module.tableElementType(tableIndex);
                        state.popChecked((byte)127);
                        state.popChecked(elementType);
                        state.popChecked((byte)127);
                        state.addMiscFlag();
                        state.addInstruction(27, tableIndex);
                        break block0;
                    }
                }
                Assert.fail(Failure.UNSPECIFIED_MALFORMED, "Unknown opcode: 0xFC 0x%02x", miscOpcode);
                break;
            }
            case 192: 
            case 193: {
                this.checkSignExtensionOpsSupport(opcode);
                state.popChecked((byte)127);
                state.push((byte)127);
                state.addInstruction(opcode + 49);
                break;
            }
            case 194: 
            case 195: 
            case 196: {
                this.checkSignExtensionOpsSupport(opcode);
                state.popChecked((byte)126);
                state.push((byte)126);
                state.addInstruction(opcode + 49);
                break;
            }
            case 208: {
                this.checkBulkMemoryAndRefTypesSupport(opcode);
                byte type = this.readRefType();
                state.push(type);
                state.addInstruction(246);
                break;
            }
            case 209: {
                this.checkBulkMemoryAndRefTypesSupport(opcode);
                state.popReferenceTypeChecked();
                state.push((byte)127);
                state.addInstruction(247);
                break;
            }
            case 210: {
                this.checkBulkMemoryAndRefTypesSupport(opcode);
                int functionIndex = this.readDeclaredFunctionIndex();
                this.module.checkFunctionReference(functionIndex);
                state.push((byte)112);
                state.addInstruction(248, functionIndex);
                break;
            }
            case 254: {
                this.checkThreadsSupport(opcode);
                int atomicOpcode = this.readUnsignedInt32();
                state.addAtomicFlag();
                switch (atomicOpcode) {
                    case 0: {
                        this.atomicNotify(state, this.longMultiResult);
                        state.addExtendedMemoryInstruction(64, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 1: {
                        this.atomicWait(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(65, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 2: {
                        this.atomicWait(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(66, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 3: {
                        this.read1();
                        state.addInstruction(63);
                        break block0;
                    }
                    case 16: {
                        this.atomicLoad(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(0, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 17: {
                        this.atomicLoad(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(1, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 18: {
                        this.atomicLoad(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(2, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 19: {
                        this.atomicLoad(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(3, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 20: {
                        this.atomicLoad(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(4, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 21: {
                        this.atomicLoad(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(5, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 22: {
                        this.atomicLoad(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(6, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 23: {
                        this.atomicStore(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(7, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 24: {
                        this.atomicStore(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(8, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 25: {
                        this.atomicStore(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(9, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 26: {
                        this.atomicStore(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(10, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 27: {
                        this.atomicStore(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(11, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 28: {
                        this.atomicStore(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(12, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 29: {
                        this.atomicStore(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(13, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 30: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(14, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 31: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(15, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 32: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(16, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 33: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(17, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 34: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(18, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 35: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(19, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 36: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(20, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 37: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(21, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 38: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(22, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 39: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(23, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 40: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(24, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 41: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(25, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 42: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(26, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 43: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(27, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 44: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(28, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 45: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(29, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 46: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(30, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 47: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(31, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 48: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(32, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 49: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(33, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 50: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(34, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 51: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(35, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 52: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(36, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 53: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(37, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 54: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(38, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 55: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(39, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 56: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(40, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 57: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(41, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 58: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(42, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 59: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(43, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 60: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(44, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 61: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(45, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 62: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(46, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 63: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(47, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 64: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(48, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 65: {
                        this.atomicReadModifyWrite(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(49, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 66: {
                        this.atomicReadModifyWrite(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(50, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 67: {
                        this.atomicReadModifyWrite(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(51, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 68: {
                        this.atomicReadModifyWrite(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(52, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 69: {
                        this.atomicReadModifyWrite(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(53, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 70: {
                        this.atomicReadModifyWrite(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(54, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 71: {
                        this.atomicReadModifyWrite(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(55, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 72: {
                        this.atomicCompareExchange(state, (byte)127, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(56, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 73: {
                        this.atomicCompareExchange(state, (byte)126, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(57, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 74: {
                        this.atomicCompareExchange(state, (byte)127, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(58, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 75: {
                        this.atomicCompareExchange(state, (byte)127, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(59, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 76: {
                        this.atomicCompareExchange(state, (byte)126, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(60, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 77: {
                        this.atomicCompareExchange(state, (byte)126, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(61, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 78: {
                        this.atomicCompareExchange(state, (byte)126, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(62, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                }
                Assert.fail(Failure.UNSPECIFIED_MALFORMED, "Unknown opcode: 0xFE 0x%02x", atomicOpcode);
                break;
            }
            case 253: {
                this.checkSIMDSupport();
                int vectorOpcode = this.readUnsignedInt32();
                state.addVectorFlag();
                if (vectorOpcode > 255) {
                    this.checkRelaxedSIMDSupport(vectorOpcode);
                }
                switch (vectorOpcode) {
                    case 0: {
                        this.load(state, (byte)123, 128, this.longMultiResult);
                        state.addExtendedMemoryInstruction(0, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.load(state, (byte)123, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode), (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 7: {
                        this.load(state, (byte)123, 8, this.longMultiResult);
                        state.addExtendedMemoryInstruction(7, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 8: {
                        this.load(state, (byte)123, 16, this.longMultiResult);
                        state.addExtendedMemoryInstruction(8, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 9: {
                        this.load(state, (byte)123, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(9, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 10: {
                        this.load(state, (byte)123, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(10, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 92: {
                        this.load(state, (byte)123, 32, this.longMultiResult);
                        state.addExtendedMemoryInstruction(92, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 93: {
                        this.load(state, (byte)123, 64, this.longMultiResult);
                        state.addExtendedMemoryInstruction(93, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 11: {
                        this.store(state, (byte)123, 128, this.longMultiResult);
                        state.addExtendedMemoryInstruction(11, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]));
                        break block0;
                    }
                    case 84: {
                        state.popChecked((byte)123);
                        this.load(state, (byte)123, 8, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 16) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.load8_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(84, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 85: {
                        state.popChecked((byte)123);
                        this.load(state, (byte)123, 16, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 8) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.load16_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(85, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 86: {
                        state.popChecked((byte)123);
                        this.load(state, (byte)123, 32, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 4) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.load32_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(86, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 87: {
                        state.popChecked((byte)123);
                        this.load(state, (byte)123, 64, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 2) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.load64_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(87, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 88: {
                        this.store(state, (byte)123, 8, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 16) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.store8_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(88, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 89: {
                        this.store(state, (byte)123, 16, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 8) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.store16_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(89, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 90: {
                        this.store(state, (byte)123, 32, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 4) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.store32_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(90, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 91: {
                        this.store(state, (byte)123, 64, this.longMultiResult);
                        byte laneIndex = this.read1();
                        if (Byte.toUnsignedInt(laneIndex) >= 2) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for v128.store64_lane", Byte.toUnsignedInt(laneIndex));
                        }
                        state.addVectorMemoryLaneInstruction(91, (int)this.longMultiResult[0], this.longMultiResult[1], this.module.memoryHasIndexType64((int)this.longMultiResult[0]), laneIndex);
                        break block0;
                    }
                    case 12: {
                        Vector128 value = this.readUnsignedInt128();
                        state.push((byte)123);
                        state.addInstruction(12, value);
                        break block0;
                    }
                    case 13: {
                        Vector128 indices = this.readUnsignedInt128();
                        for (byte index : indices.getBytes()) {
                            if (Byte.toUnsignedInt(index) < 32) continue;
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for i8x16.shuffle", Byte.toUnsignedInt(index));
                        }
                        state.popChecked((byte)123);
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addInstruction(13, indices);
                        break block0;
                    }
                    case 21: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 29: 
                    case 31: 
                    case 33: {
                        byte laneIndex = this.read1();
                        Vector128Shape shape = Vector128Shape.ofInstruction(vectorOpcode);
                        if (Byte.toUnsignedInt(laneIndex) >= shape.getDimension()) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for shape %s", Byte.toUnsignedInt(laneIndex), shape.toString());
                        }
                        state.popChecked((byte)123);
                        state.push(shape.getUnpackedType());
                        state.addVectorLaneInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode), laneIndex);
                        break block0;
                    }
                    case 23: 
                    case 26: 
                    case 28: 
                    case 30: 
                    case 32: 
                    case 34: {
                        byte laneIndex = this.read1();
                        Vector128Shape shape = Vector128Shape.ofInstruction(vectorOpcode);
                        if (Byte.toUnsignedInt(laneIndex) >= shape.getDimension()) {
                            Assert.fail(Failure.INVALID_LANE_INDEX, "Lane index %d out of bounds for shape %s", Byte.toUnsignedInt(laneIndex), shape.toString());
                        }
                        state.popChecked(shape.getUnpackedType());
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addVectorLaneInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode), laneIndex);
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        Vector128Shape shape = Vector128Shape.ofInstruction(vectorOpcode);
                        state.popChecked(shape.getUnpackedType());
                        state.push((byte)123);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                    case 83: 
                    case 99: 
                    case 100: 
                    case 131: 
                    case 132: 
                    case 163: 
                    case 164: 
                    case 195: 
                    case 196: {
                        state.popChecked((byte)123);
                        state.push((byte)127);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                    case 77: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 116: 
                    case 117: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 148: 
                    case 160: 
                    case 161: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 192: 
                    case 193: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 224: 
                    case 225: 
                    case 227: 
                    case 236: 
                    case 237: 
                    case 239: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: {
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                    case 14: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 101: 
                    case 102: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 123: 
                    case 130: 
                    case 133: 
                    case 134: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 174: 
                    case 177: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 206: 
                    case 209: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 256: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: {
                        state.popChecked((byte)123);
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                    case 107: 
                    case 108: 
                    case 109: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 203: 
                    case 204: 
                    case 205: {
                        state.popChecked((byte)127);
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                    case 82: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 275: {
                        state.popChecked((byte)123);
                        state.popChecked((byte)123);
                        state.popChecked((byte)123);
                        state.push((byte)123);
                        state.addInstruction(Bytecode.vectorOpcodeToBytecode(vectorOpcode));
                        break block0;
                    }
                }
                Assert.fail(Failure.UNSPECIFIED_MALFORMED, "Unknown opcode: 0xFD 0x%02x", vectorOpcode);
                break;
            }
            default: {
                Assert.fail(Failure.UNSPECIFIED_MALFORMED, "Unknown opcode: 0x%02x", opcode);
            }
        }
    }

    private static void checkContextOption(boolean option, String message, Object ... args) {
        if (!option) {
            Assert.fail(Failure.UNSPECIFIED_MALFORMED, message, args);
        }
    }

    private void checkSaturatingFloatToIntSupport(int opcode) {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportSaturatingFloatToInt(), "Saturating float-to-int conversion is not enabled (opcode: 0xFC 0x%02x)", opcode);
    }

    private void checkSignExtensionOpsSupport(int opcode) {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportSignExtensionOps(), "Sign-extension operators are not enabled (opcode: 0x%02x)", opcode);
    }

    private void checkBulkMemoryAndRefTypesSupport(int opcode) {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportBulkMemoryAndRefTypes(), "Bulk memory operations and reference types are not enabled (opcode: 0x%02x)", opcode);
    }

    private void checkThreadsSupport(int opcode) {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportThreads(), "Threads and atomics are not enabled (opcode: 0x%02x)", opcode);
    }

    private void checkSIMDSupport() {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportSIMD(), "Vector instructions are not enabled (opcode: 0x%02x)", 253);
    }

    private void checkRelaxedSIMDSupport(int vectorOpcode) {
        BinaryParser.checkContextOption(this.wasmContext.getContextOptions().supportRelaxedSIMD(), "Relaxed vector instructions are not enabled (opcode: 0x%02x 0x%x)", 253, vectorOpcode);
    }

    private void store(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked(type);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void load(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push(type);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicStore(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAtomicAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked(type);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicLoad(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAtomicAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push(type);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicReadModifyWrite(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAtomicAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked(type);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push(type);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicCompareExchange(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAtomicAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked(type);
        state.popChecked(type);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push(type);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicNotify(ParserState state, long[] result) {
        int alignHint = this.readAtomicAlignHint(32);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked((byte)127);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push((byte)127);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private void atomicWait(ParserState state, byte type, int n, long[] result) {
        int alignHint = this.readAtomicAlignHint(n);
        int memoryIndex = this.readMemoryIndexFromAlignHint(alignHint);
        long memoryOffset = this.readBaseMemoryOffset();
        state.popChecked((byte)126);
        state.popChecked(type);
        if (this.module.memoryHasIndexType64(memoryIndex) && this.memory64) {
            state.popChecked((byte)126);
        } else {
            state.popChecked((byte)127);
        }
        state.push((byte)127);
        result[0] = memoryIndex;
        result[1] = memoryOffset;
    }

    private Pair<Integer, byte[]> readOffsetExpression() {
        Pair<Object, byte[]> result = this.readConstantExpression((byte)127, true);
        if (result.getRight() == null) {
            return Pair.create((Object)((Integer)result.getLeft()), null);
        }
        return Pair.create((Object)-1, (Object)((byte[])result.getRight()));
    }

    private Pair<Long, byte[]> readLongOffsetExpression() {
        Pair<Object, byte[]> result = this.readConstantExpression((byte)126, true);
        if (result.getRight() == null) {
            return Pair.create((Object)((Long)result.getLeft()), null);
        }
        return Pair.create((Object)-1L, (Object)((byte[])result.getRight()));
    }

    private Pair<Object, byte[]> readConstantExpression(byte resultType, boolean onlyImportedGlobals) {
        int opcode;
        RuntimeBytecodeGen bytecode = new RuntimeBytecodeGen();
        ParserState state = new ParserState(bytecode);
        ArrayList<Object> stack = new ArrayList<Object>();
        boolean calculable = true;
        state.enterFunction(new byte[]{resultType});
        block25: while ((opcode = this.read1() & 0xFF) != 11) {
            switch (opcode) {
                case 65: {
                    int value = this.readSignedInt32();
                    state.push((byte)127);
                    state.addSignedInstruction(112, value);
                    if (!calculable) continue block25;
                    stack.add(value);
                    continue block25;
                }
                case 66: {
                    long value = this.readSignedInt64();
                    state.push((byte)126);
                    state.addSignedInstruction(114, value);
                    if (!calculable) continue block25;
                    stack.add(value);
                    continue block25;
                }
                case 67: {
                    int rawValue = this.readFloatAsInt32();
                    float value = Float.intBitsToFloat(rawValue);
                    state.push((byte)125);
                    state.addInstruction(116, rawValue);
                    if (!calculable) continue block25;
                    stack.add(Float.valueOf(value));
                    continue block25;
                }
                case 68: {
                    long rawValue = this.readFloatAsInt64();
                    double value = Double.longBitsToDouble(rawValue);
                    state.push((byte)124);
                    state.addInstruction(117, rawValue);
                    if (!calculable) continue block25;
                    stack.add(value);
                    continue block25;
                }
                case 208: {
                    this.checkBulkMemoryAndRefTypesSupport(opcode);
                    byte type = this.readRefType();
                    state.push(type);
                    state.addInstruction(246);
                    if (!calculable) continue block25;
                    stack.add(WasmConstant.NULL);
                    continue block25;
                }
                case 210: {
                    this.checkBulkMemoryAndRefTypesSupport(opcode);
                    int functionIndex = this.readDeclaredFunctionIndex();
                    this.module.addFunctionReference(functionIndex);
                    state.push((byte)112);
                    state.addInstruction(248, functionIndex);
                    calculable = false;
                    continue block25;
                }
                case 35: {
                    int index = this.readGlobalIndex();
                    if (onlyImportedGlobals) {
                        Assert.assertUnsignedIntLess(index, this.module.symbolTable().importedGlobals().size(), Failure.UNKNOWN_GLOBAL, "Constant expression in module '%s' refers to non-imported global %d.", this.module.name(), index);
                    }
                    Assert.assertIntEqual(this.module.globalMutability(index), 0, Failure.CONSTANT_EXPRESSION_REQUIRED);
                    state.push(this.module.symbolTable().globalValueType(index));
                    state.addUnsignedInstruction(37, index);
                    calculable = false;
                    continue block25;
                }
                case 106: 
                case 107: 
                case 108: {
                    if (!this.wasmContext.getContextOptions().supportExtendedConstExpressions()) {
                        Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid instruction for constant expression: 0x%02X", opcode);
                    }
                    state.popChecked((byte)127);
                    state.popChecked((byte)127);
                    state.push((byte)127);
                    state.addInstruction(opcode + 49);
                    if (!calculable) continue block25;
                    int x = (Integer)stack.removeLast();
                    int y = (Integer)stack.removeLast();
                    stack.add(switch (opcode) {
                        case 106 -> y + x;
                        case 107 -> y - x;
                        case 108 -> y * x;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    });
                    continue block25;
                }
                case 124: 
                case 125: 
                case 126: {
                    if (!this.wasmContext.getContextOptions().supportExtendedConstExpressions()) {
                        Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid instruction for constant expression: 0x%02X", opcode);
                    }
                    state.popChecked((byte)126);
                    state.popChecked((byte)126);
                    state.push((byte)126);
                    state.addInstruction(opcode + 49);
                    if (!calculable) continue block25;
                    long x = (Long)stack.removeLast();
                    long y = (Long)stack.removeLast();
                    stack.add(switch (opcode) {
                        case 124 -> y + x;
                        case 125 -> y - x;
                        case 126 -> y * x;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    });
                    continue block25;
                }
                case 253: {
                    this.checkSIMDSupport();
                    int vectorOpcode = this.read1() & 0xFF;
                    state.addVectorFlag();
                    switch (vectorOpcode) {
                        case 12: {
                            Vector128 value = this.readUnsignedInt128();
                            state.push((byte)123);
                            state.addInstruction(12, value);
                            if (!calculable) continue block25;
                            stack.add(value);
                            continue block25;
                        }
                    }
                    Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid instruction for constant expression: 0x%02X 0x%02X", opcode, vectorOpcode);
                    continue block25;
                }
            }
            Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid instruction for constant expression: 0x%02X", opcode);
        }
        Assert.assertIntEqual(state.valueStackSize(), 1, Failure.TYPE_MISMATCH, "Multiple results on stack at constant expression end");
        state.exit(this.multiValue);
        if (calculable) {
            return Pair.create(stack.removeLast(), null);
        }
        return Pair.create(null, (Object)bytecode.toArray());
    }

    private long[] readFunctionIndices() {
        int functionIndexCount = this.readLength();
        long[] functionIndices = new long[functionIndexCount];
        for (int index = 0; index != functionIndexCount; ++index) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            int functionIndex = this.readDeclaredFunctionIndex();
            this.module.addFunctionReference(functionIndex);
            functionIndices[index] = 0x7000000000L | (long)functionIndex;
        }
        return functionIndices;
    }

    private void checkElemKind() {
        byte elementKind = this.read1();
        if (elementKind != 0) {
            throw WasmException.format(Failure.TYPE_MISMATCH, "Invalid element kind: 0x%02X", elementKind);
        }
    }

    private long[] readElemExpressions(byte elemType) {
        int expressionCount = this.readLength();
        long[] functionIndices = new long[expressionCount];
        for (int index = 0; index != expressionCount; ++index) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            int opcode = this.read1() & 0xFF;
            switch (opcode) {
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    throw WasmException.format(Failure.TYPE_MISMATCH, "Invalid constant expression for table elem expression: 0x%02X", opcode);
                }
                case 106: 
                case 107: 
                case 108: 
                case 124: 
                case 125: 
                case 126: {
                    if (this.wasmContext.getContextOptions().supportExtendedConstExpressions()) {
                        throw WasmException.format(Failure.TYPE_MISMATCH, "Invalid constant expression for table elem expression: 0x%02X", opcode);
                    }
                    throw WasmException.format(Failure.ILLEGAL_OPCODE, "Illegal opcode for constant expression: 0x%02X", opcode);
                }
                case 208: {
                    byte type = this.readRefType();
                    if (this.bulkMemoryAndRefTypes && type != elemType) {
                        Assert.fail(Failure.TYPE_MISMATCH, "Invalid ref.null type: 0x%02X", type);
                    }
                    functionIndices[index] = 0L;
                    break;
                }
                case 210: {
                    if (elemType != 112) {
                        Assert.fail(Failure.TYPE_MISMATCH, "Invalid element type: 0x%02X", 112);
                    }
                    int functionIndex = this.readDeclaredFunctionIndex();
                    this.module.addFunctionReference(functionIndex);
                    functionIndices[index] = 0x7000000000L | (long)functionIndex;
                    break;
                }
                case 35: {
                    int globalIndex = this.readGlobalIndex();
                    Assert.assertIntEqual(this.module.globalMutability(globalIndex), 0, Failure.CONSTANT_EXPRESSION_REQUIRED);
                    byte valueType = this.module.globalValueType(globalIndex);
                    Assert.assertByteEqual(valueType, elemType, Failure.TYPE_MISMATCH);
                    functionIndices[index] = 0x7F00000000L | (long)globalIndex;
                    break;
                }
                case 253: {
                    this.checkSIMDSupport();
                    int vectorOpcode = this.read1() & 0xFF;
                    switch (vectorOpcode) {
                        case 12: {
                            throw WasmException.format(Failure.TYPE_MISMATCH, "Invalid constant expression for table elem expression: 0x%02X 0x%02X", opcode, vectorOpcode);
                        }
                    }
                    throw WasmException.format(Failure.ILLEGAL_OPCODE, "Illegal opcode for constant expression: 0x%02X 0x%02X", opcode, vectorOpcode);
                }
                default: {
                    throw WasmException.format(Failure.ILLEGAL_OPCODE, "Illegal opcode for constant expression: 0x%02X", opcode);
                }
            }
            this.readEnd();
        }
        return functionIndices;
    }

    private void readElementSection(RuntimeBytecodeGen bytecode) {
        int elemSegmentCount = this.readLength();
        this.module.limits().checkElementSegmentCount(elemSegmentCount);
        for (int elemSegmentIndex = 0; elemSegmentIndex != elemSegmentCount; ++elemSegmentIndex) {
            long[] elements;
            byte elemType;
            byte[] currentOffsetBytecode;
            int currentOffsetAddress;
            int tableIndex;
            int mode;
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            if (this.bulkMemoryAndRefTypes) {
                boolean useType;
                int sectionType = this.readUnsignedInt32();
                mode = sectionType & 1;
                boolean useTableIndex = (sectionType & 2) != 0;
                boolean useExpressions = (sectionType & 4) != 0;
                boolean bl = useType = (sectionType & 3) != 0;
                if (mode == 0) {
                    tableIndex = useTableIndex ? this.readTableIndex() : 0;
                    Pair<Integer, byte[]> offsetExpression = this.readOffsetExpression();
                    currentOffsetAddress = (Integer)offsetExpression.getLeft();
                    currentOffsetBytecode = (byte[])offsetExpression.getRight();
                } else {
                    mode = useTableIndex ? 2 : 1;
                    tableIndex = 0;
                    currentOffsetAddress = -1;
                    currentOffsetBytecode = null;
                }
                if (useExpressions) {
                    elemType = useType ? (byte)this.readRefType() : (byte)112;
                    elements = this.readElemExpressions(elemType);
                } else {
                    if (useType) {
                        this.checkElemKind();
                    }
                    elemType = 112;
                    elements = this.readFunctionIndices();
                }
            } else {
                mode = 0;
                tableIndex = this.readTableIndex();
                Pair<Integer, byte[]> offsetExpression = this.readOffsetExpression();
                currentOffsetAddress = (Integer)offsetExpression.getLeft();
                currentOffsetBytecode = (byte[])offsetExpression.getRight();
                elements = this.readFunctionIndices();
                elemType = 112;
            }
            int currentElemSegmentId = elemSegmentIndex;
            int elementCount = elements.length;
            int headerOffset = bytecode.location();
            int bytecodeOffset = bytecode.addElemHeader(mode, elementCount, elemType, tableIndex, currentOffsetBytecode, currentOffsetAddress);
            this.module.setElemInstance(currentElemSegmentId, headerOffset, elemType);
            if (mode == 0) {
                Assert.assertTrue(this.module.checkTableIndex(tableIndex), Failure.UNKNOWN_TABLE);
                this.module.checkElemType(currentElemSegmentId, this.module.tableElementType(tableIndex));
                this.module.addLinkAction((context, store, instance, imports) -> store.linker().resolveElemSegment(store, instance, tableIndex, currentElemSegmentId, currentOffsetAddress, currentOffsetBytecode, bytecodeOffset, elementCount));
            } else if (mode == 1) {
                this.module.addLinkAction((context, store, instance, imports) -> store.linker().resolvePassiveElemSegment(store, instance, currentElemSegmentId, bytecodeOffset, elementCount));
            }
            block6: for (long element : elements) {
                int initType = (int)(element >> 32);
                switch (initType) {
                    case 0: {
                        bytecode.addElemNull();
                        continue block6;
                    }
                    case 112: {
                        int functionIndex = (int)element;
                        bytecode.addElemFunctionIndex(functionIndex);
                        continue block6;
                    }
                    case 127: {
                        int globalIndex = (int)element;
                        bytecode.addElemGlobalIndex(globalIndex);
                    }
                }
            }
        }
    }

    private void readEnd() {
        byte instruction = this.read1();
        Assert.assertByteEqual(instruction, (byte)11, Failure.TYPE_MISMATCH);
    }

    private void readStartSection() {
        int startFunctionIndex = this.readDeclaredFunctionIndex();
        this.module.symbolTable().setStartFunction(startFunctionIndex);
    }

    private void readExportSection() {
        int exportsCount = this.readLength();
        this.module.limits().checkExportCount(exportsCount);
        block6: for (int exportIndex = 0; exportIndex != exportsCount; ++exportIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            String exportName = this.readName();
            byte exportType = this.readExportType();
            switch (exportType) {
                case 0: {
                    int functionIndex = this.readDeclaredFunctionIndex();
                    this.module.symbolTable().exportFunction(functionIndex, exportName);
                    this.module.addFunctionReference(functionIndex);
                    continue block6;
                }
                case 1: {
                    int tableIndex = this.readTableIndex();
                    this.module.symbolTable().exportTable(tableIndex, exportName);
                    continue block6;
                }
                case 2: {
                    int memoryIndex = this.readMemoryIndex();
                    this.module.symbolTable().exportMemory(memoryIndex, exportName);
                    continue block6;
                }
                case 3: {
                    int index = this.readGlobalIndex();
                    this.module.symbolTable().exportGlobal(exportName, index);
                    continue block6;
                }
                default: {
                    Assert.fail(Failure.UNSPECIFIED_MALFORMED, "Invalid export type identifier: 0x%02X", exportType);
                }
            }
        }
    }

    private void readGlobalSection() {
        int startingGlobalIndex;
        int globalCount = this.readLength();
        this.module.limits().checkGlobalCount(globalCount);
        for (int globalIndex = startingGlobalIndex = this.module.symbolTable().numGlobals(); globalIndex != startingGlobalIndex + globalCount; ++globalIndex) {
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            byte type = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
            byte mutability = this.readMutability();
            Pair<Object, byte[]> initExpression = this.readConstantExpression(type, true);
            Object initValue = initExpression.getLeft();
            byte[] initBytecode = (byte[])initExpression.getRight();
            boolean isInitialized = initBytecode == null;
            this.module.symbolTable().declareGlobal(globalIndex, type, mutability, isInitialized, initBytecode, initValue);
        }
    }

    private void readDataCountSection(int size) {
        if (size == 0) {
            this.module.setDataSegmentCount(0);
        } else {
            this.module.setDataSegmentCount(this.readUnsignedInt32());
        }
    }

    private void readDataSection(RuntimeBytecodeGen bytecode) {
        int dataSegmentCount = this.readLength();
        this.module.limits().checkDataSegmentCount(dataSegmentCount);
        if (this.bulkMemoryAndRefTypes) {
            this.module.checkDataSegmentCount(dataSegmentCount);
        }
        int droppedDataInstanceOffset = bytecode.location();
        this.module.setDroppedDataInstanceOffset(droppedDataInstanceOffset);
        bytecode.add(0);
        for (int dataSegmentIndex = 0; dataSegmentIndex != dataSegmentCount; ++dataSegmentIndex) {
            byte[] offsetBytecode;
            long offsetAddress;
            int memoryIndex;
            int mode;
            Assert.assertTrue(!this.isEOF(), Failure.LENGTH_OUT_OF_BOUNDS);
            if (this.bulkMemoryAndRefTypes) {
                boolean useMemoryIndex;
                int sectionType = this.readUnsignedInt32();
                mode = sectionType & 1;
                boolean bl = useMemoryIndex = (sectionType & 2) != 0;
                if (useMemoryIndex && this.multiMemory) {
                    memoryIndex = this.readMemoryIndex();
                } else if (useMemoryIndex) {
                    this.readMemoryIndex();
                    memoryIndex = 0;
                } else {
                    memoryIndex = 0;
                }
                if (mode == 0) {
                    this.checkMemoryIndex(memoryIndex);
                    if (this.module.memoryHasIndexType64(memoryIndex)) {
                        Pair<Long, byte[]> offsetExpression = this.readLongOffsetExpression();
                        offsetAddress = (Long)offsetExpression.getLeft();
                        offsetBytecode = (byte[])offsetExpression.getRight();
                    } else {
                        Pair<Integer, byte[]> offsetExpression = this.readOffsetExpression();
                        offsetAddress = ((Integer)offsetExpression.getLeft()).intValue();
                        offsetBytecode = (byte[])offsetExpression.getRight();
                    }
                } else {
                    offsetAddress = -1L;
                    offsetBytecode = null;
                }
            } else {
                mode = 0;
                if (this.multiMemory) {
                    memoryIndex = this.readMemoryIndex();
                } else {
                    this.readMemoryIndex();
                    memoryIndex = 0;
                }
                if (this.module.memoryHasIndexType64(memoryIndex)) {
                    Pair<Long, byte[]> offsetExpression = this.readLongOffsetExpression();
                    offsetAddress = (Long)offsetExpression.getLeft();
                    offsetBytecode = (byte[])offsetExpression.getRight();
                } else {
                    Pair<Integer, byte[]> offsetExpression = this.readOffsetExpression();
                    offsetAddress = ((Integer)offsetExpression.getLeft()).intValue();
                    offsetBytecode = (byte[])offsetExpression.getRight();
                }
            }
            int byteLength = this.readLength();
            int currentDataSegmentId = dataSegmentIndex;
            int headerOffset = bytecode.location();
            if (mode == 0) {
                this.checkMemoryIndex(memoryIndex);
                bytecode.addDataHeader(byteLength, offsetBytecode, offsetAddress, memoryIndex);
                long currentOffsetAddress = offsetAddress;
                int bytecodeOffset = bytecode.location();
                this.module.setDataInstance(currentDataSegmentId, headerOffset);
                this.module.addLinkAction((context, store, instance, imports) -> store.linker().resolveDataSegment(store, instance, currentDataSegmentId, memoryIndex, currentOffsetAddress, offsetBytecode, byteLength, bytecodeOffset, droppedDataInstanceOffset));
            } else {
                bytecode.addDataHeader(mode, byteLength);
                int bytecodeOffset = bytecode.location();
                bytecode.addDataRuntimeHeader(byteLength);
                this.module.setDataInstance(currentDataSegmentId, headerOffset);
                this.module.addLinkAction((context, store, instance, imports) -> store.linker().resolvePassiveDataSegment(store, instance, currentDataSegmentId, bytecodeOffset));
            }
            for (int i = 0; i < byteLength; ++i) {
                bytecode.addByte(this.read1());
            }
        }
    }

    private void readFunctionType() {
        int paramCount = this.readLength();
        long resultCountAndValue = BinaryParser.peekUnsignedInt32AndLength(this.data, this.offset + paramCount);
        int resultCount = BinaryParser.value(resultCountAndValue);
        resultCount = resultCount == 64 ? 0 : resultCount;
        this.module.limits().checkParamCount(paramCount);
        this.module.limits().checkResultCount(resultCount, this.multiValue);
        int idx = this.module.symbolTable().allocateFunctionType(paramCount, resultCount, this.multiValue);
        this.readParameterList(idx, paramCount);
        this.offset += BinaryParser.length(resultCountAndValue);
        this.readResultList(idx, resultCount);
    }

    private void readParameterList(int funcTypeIdx, int paramCount) {
        for (int paramIdx = 0; paramIdx != paramCount; ++paramIdx) {
            byte type = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
            this.module.symbolTable().registerFunctionTypeParameterType(funcTypeIdx, paramIdx, type);
        }
    }

    private void readResultList(int funcTypeIdx, int resultCount) {
        for (int resultIdx = 0; resultIdx != resultCount; ++resultIdx) {
            byte type = this.readValueType(this.bulkMemoryAndRefTypes, this.simd);
            this.module.symbolTable().registerFunctionTypeResultType(funcTypeIdx, resultIdx, type);
        }
    }

    private int readMemoryIndexFromAlignHint(int alignHint) {
        int memoryIndex;
        if (this.multiMemory && (alignHint & 0x40) != 0) {
            memoryIndex = this.readMemoryIndex();
        } else {
            memoryIndex = 0;
            this.checkMemoryIndex(0);
        }
        return memoryIndex;
    }

    private long readBaseMemoryOffset() {
        long memoryOffset = this.memory64 ? this.readUnsignedInt64() : Integer.toUnsignedLong(this.readUnsignedInt32());
        return memoryOffset;
    }

    private boolean isEOF() {
        return this.offset == this.data.length;
    }

    private int readDeclaredFunctionIndex() {
        int index = this.readUnsignedInt32();
        this.module.symbolTable().checkFunctionIndex(index);
        return index;
    }

    private int readTypeIndex() {
        int result = this.readUnsignedInt32();
        Assert.assertUnsignedIntLess(result, this.module.symbolTable().typeCount(), Failure.UNKNOWN_TYPE);
        return result;
    }

    private int readFunctionIndex() {
        return this.readUnsignedInt32();
    }

    private int readTableIndex() {
        int index = this.readUnsignedInt32();
        Assert.assertTrue(this.module.symbolTable().checkTableIndex(index), Failure.UNKNOWN_TABLE);
        return index;
    }

    private int readMemoryIndex() {
        return this.checkMemoryIndex(this.readUnsignedInt32());
    }

    private int checkMemoryIndex(int index) {
        Assert.assertUnsignedIntLess(index, this.module.symbolTable().memoryCount(), Failure.UNKNOWN_MEMORY);
        return index;
    }

    private int readGlobalIndex() {
        int index = this.readUnsignedInt32();
        Assert.assertUnsignedIntLess(index, this.module.symbolTable().numGlobals(), Failure.UNKNOWN_GLOBAL);
        return index;
    }

    private int readLocalIndex() {
        return this.readUnsignedInt32();
    }

    private int readTargetOffset() {
        return this.readUnsignedInt32();
    }

    private byte readExportType() {
        return this.read1();
    }

    private byte readImportType() {
        return this.read1();
    }

    private byte readRefType() {
        byte refType = this.read1();
        switch (refType) {
            case 111: 
            case 112: {
                break;
            }
            default: {
                Assert.fail(Failure.MALFORMED_REFERENCE_TYPE, "Unexpected reference type");
            }
        }
        return refType;
    }

    private void readTableLimits(int[] out) {
        this.readLimits(out, -1);
        Assert.assertUnsignedIntLessOrEqual(out[0], out[1], Failure.LIMIT_MINIMUM_GREATER_THAN_MAXIMUM);
    }

    private void readMemoryLimits(long[] longOut, boolean[] boolOut) {
        this.readLongLimits(longOut, boolOut, 65536, 0x1000000000000L);
        boolean is64Bit = boolOut[0];
        if (is64Bit) {
            Assert.assertUnsignedLongLessOrEqual(longOut[0], 0x1000000000000L, Failure.MEMORY_64_SIZE_LIMIT_EXCEEDED);
            Assert.assertUnsignedLongLessOrEqual(longOut[1], 0x1000000000000L, Failure.MEMORY_64_SIZE_LIMIT_EXCEEDED);
            Assert.assertUnsignedLongLessOrEqual(longOut[0], longOut[1], Failure.LIMIT_MINIMUM_GREATER_THAN_MAXIMUM);
        } else {
            Assert.assertUnsignedIntLessOrEqual((int)longOut[0], 65536, Failure.MEMORY_SIZE_LIMIT_EXCEEDED);
            Assert.assertUnsignedIntLessOrEqual((int)longOut[1], 65536, Failure.MEMORY_SIZE_LIMIT_EXCEEDED);
            Assert.assertUnsignedIntLessOrEqual((int)longOut[0], (int)longOut[1], Failure.LIMIT_MINIMUM_GREATER_THAN_MAXIMUM);
        }
    }

    private void readLimits(int[] out, int max) {
        byte limitsPrefix = this.readLimitsPrefix();
        switch (limitsPrefix) {
            case 0: {
                out[0] = this.readUnsignedInt32();
                out[1] = max;
                break;
            }
            case 1: {
                out[0] = this.readUnsignedInt32();
                out[1] = this.readUnsignedInt32();
                break;
            }
            default: {
                if (limitsPrefix < 0) {
                    Assert.fail(Failure.INTEGER_REPRESENTATION_TOO_LONG, "Invalid limits prefix (expected 0x00 or 0x01, got 0x%02X)", limitsPrefix);
                    break;
                }
                Assert.fail(Failure.INTEGER_TOO_LARGE, "Invalid limits prefix (expected 0x00 or 0x01, got 0x%02X)", limitsPrefix);
            }
        }
    }

    private void readLongLimits(long[] longOut, boolean[] boolOut, int max32Bit, long max64Bit) {
        byte limitsPrefix = this.readLimitsPrefix();
        block0 : switch (limitsPrefix) {
            case 0: {
                longOut[0] = this.readUnsignedInt32();
                longOut[1] = max32Bit;
                boolOut[0] = false;
                boolOut[1] = false;
                break;
            }
            case 1: {
                longOut[0] = this.readUnsignedInt32();
                longOut[1] = this.readUnsignedInt32();
                boolOut[0] = false;
                boolOut[1] = false;
                break;
            }
            case 4: {
                longOut[0] = this.readUnsignedInt64();
                longOut[1] = max64Bit;
                boolOut[0] = true;
                boolOut[1] = false;
                break;
            }
            case 5: {
                longOut[0] = this.readUnsignedInt64();
                longOut[1] = this.readUnsignedInt64();
                boolOut[0] = true;
                boolOut[1] = false;
                break;
            }
            default: {
                if (!this.threads) {
                    if (limitsPrefix < 0) {
                        Assert.fail(Failure.INTEGER_REPRESENTATION_TOO_LONG, "Invalid limits prefix (expected 0x00, 0x01, 0x04, or 0x05, got 0x%02X)", limitsPrefix);
                        break;
                    }
                    Assert.fail(Failure.INTEGER_TOO_LARGE, "Invalid limits prefix (expected 0x00, 0x01, 0x04, or 0x05, got 0x%02X)", limitsPrefix);
                    break;
                }
                switch (limitsPrefix) {
                    case 2: 
                    case 6: {
                        Assert.fail(Failure.SHARED_MEMORY_MUST_HAVE_MAXIMUM, "Limits prefix implies shared memory without meximum (got 0x%02X)", limitsPrefix);
                        break block0;
                    }
                    case 3: {
                        longOut[0] = this.readUnsignedInt32();
                        longOut[1] = this.readUnsignedInt32();
                        boolOut[0] = false;
                        boolOut[1] = true;
                        break block0;
                    }
                    case 7: {
                        longOut[0] = this.readUnsignedInt64();
                        longOut[1] = this.readUnsignedInt64();
                        boolOut[0] = true;
                        boolOut[1] = true;
                        break block0;
                    }
                }
                if (limitsPrefix < 0) {
                    Assert.fail(Failure.INTEGER_REPRESENTATION_TOO_LONG, "Invalid limits prefix (expected 0x00-0x07, got 0x%02X)", limitsPrefix);
                    break;
                }
                Assert.fail(Failure.INTEGER_TOO_LARGE, "Invalid limits prefix (expected 0x00-0x07, got 0x%02X)", limitsPrefix);
            }
        }
    }

    private byte readLimitsPrefix() {
        return this.read1();
    }

    private String readName() {
        CharBuffer result;
        int nameLength = this.readLength();
        Assert.assertUnsignedIntLessOrEqual(this.offset + nameLength, this.data.length, Failure.LENGTH_OUT_OF_BOUNDS);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            result = decoder.decode(ByteBuffer.wrap(this.data, this.offset, nameLength));
        }
        catch (CharacterCodingException ex) {
            throw WasmException.format(Failure.MALFORMED_UTF8, "Invalid UTF-8 encoding of the name at: %d", this.offset);
        }
        this.offset += nameLength;
        return result.toString();
    }

    protected int readLength() {
        int value = this.readUnsignedInt32();
        Assert.assertUnsignedIntLessOrEqual(value, this.data.length, Failure.LENGTH_OUT_OF_BOUNDS);
        return value;
    }

    protected int readAlignHint(int n) {
        int value = this.readUnsignedInt32();
        int align = this.multiMemory && (value & 0x40) != 0 ? value - 64 : value;
        Assert.assertUnsignedIntLess(align, 32, Failure.MALFORMED_MEMOP_FLAGS);
        Assert.assertUnsignedIntLessOrEqual(1 << align, n / 8, Failure.ALIGNMENT_LARGER_THAN_NATURAL);
        return value;
    }

    protected int readAtomicAlignHint(int n) {
        int value = this.readUnsignedInt32();
        int align = this.multiMemory && (value & 0x40) != 0 ? value - 64 : value;
        Assert.assertUnsignedIntLess(align, 32, Failure.MALFORMED_MEMOP_FLAGS);
        Assert.assertIntEqual(1 << align, n / 8, Failure.ATOMIC_ALIGNMENT_NOT_NATURAL);
        return value;
    }

    protected int readUnsignedInt32() {
        long valueLength = BinaryParser.peekUnsignedInt32AndLength(this.data, this.offset);
        this.offset += BinaryParser.length(valueLength);
        return BinaryParser.value(valueLength);
    }

    protected int readSignedInt32() {
        long valueLength = BinaryParser.peekSignedInt32AndLength(this.data, this.offset);
        this.offset += BinaryParser.length(valueLength);
        return BinaryParser.value(valueLength);
    }

    protected long readUnsignedInt64() {
        long value = BinaryParser.peekUnsignedInt64(this.data, this.offset, true);
        byte length = BinaryParser.peekLeb128Length(this.data, this.offset);
        this.offset += length;
        return value;
    }

    private long readSignedInt64() {
        long value = BinaryParser.peekSignedInt64(this.data, this.offset, true);
        byte length = BinaryParser.peekLeb128Length(this.data, this.offset);
        this.offset += length;
        return value;
    }

    private Vector128 readUnsignedInt128() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            bytes[i] = this.read1();
        }
        return new Vector128(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    public byte[] createFunctionDebugBytecode(int functionIndex, EconomicMap<Integer, Integer> offsetToLineIndexMap) {
        RuntimeBytecodeGen bytecode = new RuntimeBytecodeGen();
        int codeEntryIndex = functionIndex - this.module.numImportedFunctions();
        CodeEntry codeEntry = BytecodeParser.readCodeEntry(this.module, this.module.bytecode(), codeEntryIndex);
        this.offset = this.module.functionSourceCodeInstructionOffset(functionIndex);
        int endOffset = this.module.functionSourceCodeEndOffset(functionIndex);
        this.readFunction(functionIndex, codeEntry.localTypes(), codeEntry.resultTypes(), endOffset, true, bytecode, codeEntryIndex, offsetToLineIndexMap);
        return bytecode.toArray();
    }
}

