/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationSupport;
import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.compiler.hotspot.HotSpotTruffleCompiler;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.ModulesSupport;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.TruffleCallBoundary;
import com.oracle.truffle.runtime.hotspot.HotSpotFastThreadLocal;
import com.oracle.truffle.runtime.hotspot.HotSpotOptimizedCallTarget;
import com.oracle.truffle.runtime.hotspot.HotSpotThreadLocalHandshake;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilationSupport;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import sun.misc.Unsafe;

public final class HotSpotTruffleRuntime
extends OptimizedTruffleRuntime {
    static final int JAVA_SPEC = Runtime.version().feature();
    static final Unsafe UNSAFE = HotSpotTruffleRuntime.getUnsafe();
    private static final Accessor.JavaLangSupport JAVA_LANG_SUPPORT = ModulesSupport.getJavaLangSupport();
    private static final long THREAD_EETOP_OFFSET;
    private int pendingTransferToInterpreterOffset = -1;
    private volatile boolean traceTransferToInterpreter;
    private Boolean profilingEnabled;
    private volatile Lazy lazy;
    private volatile CompilationTask initializationTask;
    private volatile boolean truffleCompilerInitialized;
    private volatile Throwable truffleCompilerInitializationException;
    private final HotSpotVMConfigAccess vmConfigAccess;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lazy lazy() {
        if (this.lazy == null) {
            HotSpotTruffleRuntime hotSpotTruffleRuntime = this;
            synchronized (hotSpotTruffleRuntime) {
                if (this.lazy == null) {
                    this.lazy = new Lazy(this);
                }
            }
        }
        return this.lazy;
    }

    public HotSpotTruffleRuntime(TruffleCompilationSupport compilationSupport) {
        super(compilationSupport, Arrays.asList(HotSpotOptimizedCallTarget.class, InstalledCode.class, HotSpotThreadLocalHandshake.class, HotSpotTruffleRuntime.class));
        this.installCallBoundaryMethods(null);
        this.vmConfigAccess = new HotSpotVMConfigAccess(HotSpotJVMCIRuntime.runtime().getConfigStore());
        int jvmciReservedReference0Offset = (Integer)this.vmConfigAccess.getFieldOffset("JavaThread::_jvmci_reserved_oop0", Integer.class, "oop", (Object)-1);
        if (jvmciReservedReference0Offset == -1) {
            throw CompilerDirectives.shouldNotReachHere((String)"This JDK does not have JavaThread::_jvmci_reserved_oop0");
        }
        this.installReservedOopMethods(null);
    }

    @Override
    public ThreadLocalHandshake getThreadLocalHandshake() {
        return HotSpotThreadLocalHandshake.SINGLETON;
    }

    @Override
    protected StackIntrospection getStackIntrospection() {
        Lazy l = this.lazy();
        if (l.stackIntrospection == null) {
            l.stackIntrospection = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getStackIntrospection();
        }
        return l.stackIntrospection;
    }

    @Override
    public TruffleCompiler getTruffleCompiler(TruffleCompilable compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        if (this.truffleCompiler == null) {
            this.initializeTruffleCompiler(compilable);
            this.rethrowTruffleCompilerInitializationException();
            assert (this.truffleCompiler != null) : "TruffleCompiler must be non null";
        }
        return this.truffleCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(final OptimizedCallTarget firstCallTarget) {
        if (this.truffleCompilerInitialized) {
            return;
        }
        CompilationTask localTask = this.initializationTask;
        if (localTask == null) {
            HotSpotTruffleRuntime lock;
            HotSpotTruffleRuntime hotSpotTruffleRuntime = lock = this;
            synchronized (hotSpotTruffleRuntime) {
                localTask = this.initializationTask;
                if (localTask == null && !this.truffleCompilerInitialized) {
                    this.rethrowTruffleCompilerInitializationException();
                    this.initializationTask = localTask = this.getCompileQueue().submitInitialization(firstCallTarget, new Consumer<CompilationTask>(){
                        final /* synthetic */ HotSpotTruffleRuntime this$0;
                        {
                            this.this$0 = this$0;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(CompilationTask task) {
                            Object object = lock;
                            synchronized (object) {
                                this.this$0.initializeTruffleCompiler(firstCallTarget);
                                assert (this.this$0.truffleCompilerInitialized || this.this$0.truffleCompilerInitializationException != null);
                                assert (this.this$0.initializationTask != null);
                                this.this$0.initializationTask = null;
                            }
                        }
                    });
                }
            }
        }
        if (localTask != null) {
            firstCallTarget.maybeWaitForTask(localTask);
            this.rethrowTruffleCompilerInitializationException();
        } else assert (this.truffleCompilerInitialized || this.truffleCompilerInitializationException != null);
    }

    public void resetCompiler() {
        this.truffleCompiler = null;
        this.truffleCompilerInitialized = false;
        this.truffleCompilerInitializationException = null;
    }

    private synchronized void initializeTruffleCompiler(TruffleCompilable compilable) {
        if (!this.truffleCompilerInitialized) {
            this.rethrowTruffleCompilerInitializationException();
            try {
                OptimizedCallTarget callTarget = (OptimizedCallTarget)compilable;
                EngineData engine = callTarget.engine;
                OptimizedCallTarget initCallTarget = this.createInitializationCallTarget(engine);
                HotSpotTruffleCompiler compiler = (HotSpotTruffleCompiler)this.newTruffleCompiler();
                compiler.initialize((TruffleCompilable)initCallTarget, true);
                this.initializeCallTarget = initCallTarget;
                this.pendingTransferToInterpreterOffset = compiler.pendingTransferToInterpreterOffset((TruffleCompilable)callTarget);
                if (this.pendingTransferToInterpreterOffset == -1) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Invalid offset for JavaThread::_pending_transfer_to_interpreter");
                }
                this.installCallBoundaryMethods(compiler);
                this.installReservedOopMethods(compiler);
                this.truffleCompiler = compiler;
                this.truffleCompilerInitialized = true;
            }
            catch (Throwable e) {
                this.truffleCompilerInitializationException = e;
            }
        }
    }

    @Override
    protected void onEngineCreated(EngineData engine) {
        this.traceTransferToInterpreter = engine.traceTransferToInterpreter;
        this.profilingEnabled = engine.profilingEnabled;
        if (engine.traceTransferToInterpreter != StaticOptions.TRACE_TRANSFER_TO_INTERPRETER) {
            HotSpotTruffleRuntime.printStaticOptionWarning(engine, "engine.TraceTransferToInterpreter", StaticOptions.TRACE_TRANSFER_TO_INTERPRETER, this.traceTransferToInterpreter);
        }
    }

    private static void printStaticOptionWarning(EngineData engine, String optionName, Boolean oldValue, Boolean newValue) {
        engine.getEngineLogger().warning(String.format("The option '%s' was set to '%s', but it was previously initialized with '%s'. The option has therefore no effect. This option must be set to the same value for the first engine of a process to have an effect on HotSpot. It is recommended to use the -Dpolyglot.%s=true Java command line option to make sure it is set for all engines.", optionName, newValue.toString(), oldValue.toString(), optionName));
    }

    private void rethrowTruffleCompilerInitializationException() {
        if (this.truffleCompilerInitializationException != null) {
            throw HotSpotTruffleRuntime.sthrow(RuntimeException.class, this.truffleCompilerInitializationException);
        }
    }

    private static <T extends Throwable> T sthrow(Class<T> type, Throwable t) throws T {
        throw t;
    }

    @Override
    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        HotSpotOptimizedCallTarget target = new HotSpotOptimizedCallTarget(source, rootNode);
        this.ensureInitialized(target);
        return target;
    }

    @Override
    protected OptimizedCallTarget createInitializationCallTarget(EngineData engine) {
        return new HotSpotOptimizedCallTarget(engine);
    }

    public void onCodeInstallation(TruffleCompilable compilable, InstalledCode installedCode) {
        HotSpotOptimizedCallTarget callTarget = (HotSpotOptimizedCallTarget)compilable;
        callTarget.setInstalledCode(installedCode);
    }

    @Override
    public SpeculationLog createSpeculationLog() {
        return new HotSpotSpeculationLog();
    }

    public static void setDontInlineCallBoundaryMethod(List<ResolvedJavaMethod> callBoundaryMethods) {
        for (ResolvedJavaMethod method : callBoundaryMethods) {
            HotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    static MetaAccessProvider getMetaAccess() {
        return JVMCI.getRuntime().getHostJVMCIBackend().getMetaAccess();
    }

    private static void setNotInlinableOrCompilable(ResolvedJavaMethod method) {
        Method[] methods;
        for (Method m : methods = HotSpotResolvedJavaMethod.class.getMethods()) {
            if (!m.getName().equals("setNotInlineable") && !m.getName().equals("setNotInlinableOrCompilable") && !m.getName().equals("setNotInlineableOrCompileable")) continue;
            try {
                m.invoke((Object)method, new Object[0]);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        throw new InternalError(String.format("Could not find setNotInlineable, setNotInlinableOrCompilable or setNotInlineableOrCompileable in %s", HotSpotResolvedJavaMethod.class));
    }

    @Override
    public BackgroundCompileQueue getCompileQueue() {
        return this.lazy();
    }

    private boolean verifyCompilerConfiguration(String name) {
        String lazyName = this.getCompilerConfigurationName();
        if (!name.equals(lazyName)) {
            throw new AssertionError((Object)("Expected compiler configuration name " + name + " but was " + lazyName + "."));
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void bypassedInstalledCode(OptimizedCallTarget target) {
        if (!this.truffleCompilerInitialized) {
            return;
        }
        this.installCallBoundaryMethods((HotSpotTruffleCompiler)this.truffleCompiler);
    }

    public boolean bypassedReservedOop() {
        CompilationTask task = this.initializationTask;
        if (task != null) {
            return true;
        }
        if (!this.truffleCompilerInitialized) {
            if (this.truffleCompilerInitializationException != null) {
                throw new AssertionError("Compiler initialization failed cannot continue.", this.truffleCompilerInitializationException);
            }
            return false;
        }
        this.installReservedOopMethods((HotSpotTruffleCompiler)this.truffleCompiler);
        return true;
    }

    private void installCallBoundaryMethods(HotSpotTruffleCompiler compiler) {
        ResolvedJavaType type = HotSpotTruffleRuntime.getMetaAccess().lookupJavaType(OptimizedCallTarget.class);
        for (ResolvedJavaMethod method : type.getDeclaredMethods(false)) {
            if (method.getAnnotation(TruffleCallBoundary.class) == null) continue;
            if (compiler != null) {
                OptimizedCallTarget initCallTarget = this.initializeCallTarget;
                Objects.requireNonNull(initCallTarget);
                compiler.installTruffleCallBoundaryMethod(method, (TruffleCompilable)initCallTarget);
                continue;
            }
            HotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    private void installReservedOopMethods(HotSpotTruffleCompiler compiler) {
        ResolvedJavaType local = HotSpotTruffleRuntime.getMetaAccess().lookupJavaType(HotSpotFastThreadLocal.class);
        block7: for (ResolvedJavaMethod method : local.getDeclaredMethods(false)) {
            String name;
            switch (name = method.getName()) {
                case "set": 
                case "get": {
                    if (compiler != null) {
                        OptimizedCallTarget initCallTarget = this.initializeCallTarget;
                        Objects.requireNonNull(initCallTarget);
                        compiler.installTruffleReservedOopMethod(method, (TruffleCompilable)initCallTarget);
                        continue block7;
                    }
                    HotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
                }
            }
        }
    }

    @Override
    public OptimizedTruffleRuntime.KnownMethods getKnownMethods() {
        if (this.knownMethods == null) {
            this.knownMethods = new OptimizedTruffleRuntime.KnownMethods(HotSpotTruffleRuntime.getMetaAccess());
        }
        return this.knownMethods;
    }

    public void notifyTransferToInterpreter() {
        if (CompilerDirectives.inInterpreter() && StaticOptions.TRACE_TRANSFER_TO_INTERPRETER) {
            this.traceTransferToInterpreter();
        }
    }

    private void traceTransferToInterpreter() {
        boolean deoptimized;
        TruffleCompiler compiler = this.truffleCompiler;
        int offset = this.pendingTransferToInterpreterOffset;
        if (compiler == null || offset == -1) {
            return;
        }
        long threadStruct = UNSAFE.getLong(JAVA_LANG_SUPPORT.currentCarrierThread(), THREAD_EETOP_OFFSET);
        long pendingTransferToInterpreterAddress = threadStruct + (long)offset;
        boolean bl = deoptimized = UNSAFE.getByte(pendingTransferToInterpreterAddress) != 0;
        if (deoptimized) {
            this.logTransferToInterpreter(pendingTransferToInterpreterAddress);
        }
    }

    private void logTransferToInterpreter(long pendingTransferToInterpreterAddress) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)this.iterateFrames(FrameInstance::getCallTarget);
        if (callTarget == null) {
            return;
        }
        OptimizedTruffleRuntime.StackTraceHelper.logHostAndGuestStacktrace("transferToInterpreter", callTarget);
        UNSAFE.putByte(pendingTransferToInterpreterAddress, (byte)0);
    }

    public boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            return true;
        }
        return this.profilingEnabled;
    }

    @Override
    protected JavaConstant forObject(Object object) {
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getConstantReflection();
        return constantReflection.forObject(object);
    }

    @Override
    protected int getBaseInstanceSize(Class<?> type) {
        if (type.isArray() || type.isPrimitive()) {
            throw new IllegalArgumentException("Class " + type.getName() + " is a primitive type or an array class!");
        }
        HotSpotMetaAccessProvider meta = (HotSpotMetaAccessProvider)HotSpotTruffleRuntime.getMetaAccess();
        HotSpotResolvedObjectType resolvedType = (HotSpotResolvedObjectType)meta.lookupJavaType(type);
        return Math.abs(resolvedType.instanceSize());
    }

    private static boolean fieldIsNotEligible(Class<?> clazz, ResolvedJavaField f) {
        return Reference.class.isAssignableFrom(clazz) && f.getDeclaringClass().isAssignableFrom(HotSpotTruffleRuntime.getMetaAccess().lookupJavaType(Reference.class));
    }

    @Override
    protected int[] getFieldOffsets(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        if (type.isArray() || type.isPrimitive()) {
            throw new IllegalArgumentException("Class " + type.getName() + " is a primitive type or an array class!");
        }
        HotSpotMetaAccessProvider meta = (HotSpotMetaAccessProvider)HotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType javaType = meta.lookupJavaType(type);
        ResolvedJavaField[] fields = javaType.getInstanceFields(includeSuperclasses);
        int[] fieldOffsets = new int[fields.length];
        int fieldsCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            ResolvedJavaField f = fields[i];
            if (!includePrimitive && f.getJavaKind().isPrimitive() || HotSpotTruffleRuntime.fieldIsNotEligible(type, f)) continue;
            fieldOffsets[fieldsCount++] = f.getOffset();
        }
        return Arrays.copyOf(fieldOffsets, fieldsCount);
    }

    private <T> T getVMOptionValue(String name, Class<T> type) {
        try {
            return (T)this.vmConfigAccess.getFlag(name, type);
        }
        catch (JVMCIError jvmciError) {
            throw new IllegalArgumentException(jvmciError);
        }
    }

    @Override
    protected int getObjectAlignment() {
        return this.getVMOptionValue("ObjectAlignmentInBytes", Integer.class);
    }

    @Override
    protected int getArrayIndexScale(Class<?> componentType) {
        MetaAccessProvider meta = HotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType resolvedType = meta.lookupJavaType(componentType);
        return ((HotSpotJVMCIRuntime)JVMCI.getRuntime()).getArrayIndexScale(resolvedType.getJavaKind());
    }

    @Override
    protected int getArrayBaseOffset(Class<?> componentType) {
        MetaAccessProvider meta = HotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType resolvedType = meta.lookupJavaType(componentType);
        return ((HotSpotJVMCIRuntime)JVMCI.getRuntime()).getArrayBaseOffset(resolvedType.getJavaKind());
    }

    @Override
    public long getStackOverflowLimit() {
        int stackOverflowLimitOffset = (Integer)this.vmConfigAccess.getFieldOffset(JAVA_SPEC >= 16 ? "JavaThread::_stack_overflow_state._stack_overflow_limit" : "JavaThread::_stack_overflow_limit", Integer.class, "address");
        long eetop = UNSAFE.getLong(JAVA_LANG_SUPPORT.currentCarrierThread(), THREAD_EETOP_OFFSET);
        return UNSAFE.getLong(eetop + (long)stackOverflowLimitOffset);
    }

    static long getObjectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
        return (T)hsConstant.asObject(type);
    }

    @Override
    protected AbstractFastThreadLocal getFastThreadLocalImpl() {
        return HotSpotFastThreadLocal.SINGLETON;
    }

    public static HotSpotTruffleRuntime getRuntime() {
        return (HotSpotTruffleRuntime)OptimizedTruffleRuntime.getRuntime();
    }

    public boolean isLibGraalCompilationEnabled() {
        return this.compilationSupport instanceof LibGraalTruffleCompilationSupport;
    }

    static {
        try {
            THREAD_EETOP_OFFSET = HotSpotTruffleRuntime.getObjectFieldOffset(Thread.class.getDeclaredField("eetop"));
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    static final class Lazy
    extends BackgroundCompileQueue {
        StackIntrospection stackIntrospection;

        Lazy(HotSpotTruffleRuntime runtime) {
            super(runtime);
            runtime.installDefaultListeners();
        }

        @Override
        protected void notifyIdleCompilerThread() {
            TruffleCompiler compiler = ((HotSpotTruffleRuntime)this.runtime).truffleCompiler;
            if (compiler != null) {
                ((HotSpotTruffleCompiler)compiler).purgePartialEvaluationCaches();
            }
        }
    }

    static final class StaticOptions {
        static final boolean TRACE_TRANSFER_TO_INTERPRETER;

        StaticOptions() {
        }

        static {
            HotSpotTruffleRuntime runtime = (HotSpotTruffleRuntime)Truffle.getRuntime();
            boolean enabled = runtime.traceTransferToInterpreter;
            if (!enabled) {
                String property = System.getProperty("polyglot.engine.TraceTransferToInterpreter");
                enabled = property != null && property.equals("true");
            }
            TRACE_TRANSFER_TO_INTERPRETER = enabled;
        }
    }
}

