/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot;

import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleRuntimeAccess;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.compiler.TruffleCompilationSupport;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.runtime.ModulesSupport;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraal;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilationSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.home.Version;

public final class HotSpotTruffleRuntimeAccess
implements TruffleRuntimeAccess {
    public TruffleRuntime getRuntime() {
        return HotSpotTruffleRuntimeAccess.createRuntime();
    }

    public int getPriority() {
        return 0;
    }

    protected static TruffleRuntime createRuntime() {
        LibGraalTruffleCompilationSupport compilationSupport;
        String reason = ModulesSupport.exportJVMCI(HotSpotTruffleRuntimeAccess.class);
        if (reason != null) {
            return new DefaultTruffleRuntime(reason);
        }
        try {
            Services.initializeJVMCI();
        }
        catch (Error e) {
            if (e.getClass() == Error.class && e.getMessage().startsWith("The EnableJVMCI VM option must be true")) {
                return new DefaultTruffleRuntime("JVMCI is required to enable optimizations. Pass -XX:+EnableJVMCI as a virtual machine argument to the java executable to resolve this. This is necessary on JVMs that do not enable JVMCI by default.");
            }
            throw e;
        }
        HotSpotJVMCIRuntime hsRuntime = (HotSpotJVMCIRuntime)JVMCI.getRuntime();
        HotSpotVMConfigAccess config = new HotSpotVMConfigAccess(hsRuntime.getConfigStore());
        boolean useCompiler = (Boolean)config.getFlag("UseCompiler", Boolean.class);
        if (!useCompiler) {
            return new DefaultTruffleRuntime("JVMCI compilation was disabled on this JVM. Pass -XX:+EnableJVMCI as a virtual machine argument to the java executable to resolve this.");
        }
        Module runtimeModule = HotSpotTruffleRuntimeAccess.class.getModule();
        ModuleLayer layer = runtimeModule.isNamed() ? runtimeModule.getLayer() : ModuleLayer.boot();
        Module truffleCompilerModule = layer.findModule("org.graalvm.truffle.compiler").orElse(null);
        if (truffleCompilerModule != null) {
            ModulesSupport.exportJVMCI(truffleCompilerModule);
            for (String pack : truffleCompilerModule.getPackages()) {
                ModulesSupport.addExports(truffleCompilerModule, pack, runtimeModule);
            }
        }
        if (LibGraal.isAvailable()) {
            compilationSupport = new LibGraalTruffleCompilationSupport();
            if (!Boolean.getBoolean("polyglotimpl.DisableVersionChecks")) {
                Version truffleVersion = HotSpotTruffleRuntimeAccess.getTruffleVersion();
                if (truffleVersion.compareTo(OptimizedTruffleRuntime.NEXT_VERSION_UPDATE) >= 0) {
                    throw new AssertionError((Object)"MIN_COMPILER_VERSION, MIN_JDK_VERSION and MAX_JDK_VERSION must be updated!");
                }
                Version truffleMajorMinorVersion = HotSpotTruffleRuntimeAccess.stripUpdateVersion(truffleVersion);
                Version compilerVersion = HotSpotTruffleRuntimeAccess.getCompilerVersion(compilationSupport);
                Version compilerMajorMinorVersion = HotSpotTruffleRuntimeAccess.stripUpdateVersion(compilerVersion);
                int jdkFeatureVersion = Runtime.version().feature();
                if (jdkFeatureVersion < 21 || jdkFeatureVersion >= 25) {
                    return new DefaultTruffleRuntime(HotSpotTruffleRuntimeAccess.formatVersionWarningMessage("Your Java runtime '%s' with compiler version '%s' is incompatible with polyglot version '%s'.\nThe Java runtime version must be greater or equal to JDK '%d' and smaller than JDK '%d'.\nUpdate your Java runtime to resolve this.\n", Runtime.version(), compilerVersion, truffleVersion, 21, 25));
                }
                if (compilerMajorMinorVersion.compareTo(truffleMajorMinorVersion) > 0) {
                    return new DefaultTruffleRuntime(HotSpotTruffleRuntimeAccess.formatVersionWarningMessage("Your Java runtime '%s' with compiler version '%s' is incompatible with polyglot version '%s'.\nUpdate the org.graalvm.polyglot versions to at least '%s' to resolve this.\n", Runtime.version(), compilerVersion, truffleVersion, compilerVersion));
                }
                if (compilerVersion.compareTo(OptimizedTruffleRuntime.MIN_COMPILER_VERSION) < 0) {
                    return new DefaultTruffleRuntime(HotSpotTruffleRuntimeAccess.formatVersionWarningMessage("Your Java runtime '%s' with compiler version '%s' is incompatible with polyglot version '%s'.\nUpdate the Java runtime to the latest update release of JDK '%d'.\n", Runtime.version(), compilerVersion, truffleVersion, jdkFeatureVersion));
                }
            }
        } else {
            try {
                Module compilerModule = layer.findModule("jdk.internal.vm.compiler").orElse(null);
                if (compilerModule == null) {
                    return new DefaultTruffleRuntime("Libgraal compilation is not available on this JVM. Alternatively, the org.graalvm.compiler:compiler module can be put on the --upgrade-module-path.");
                }
                ModulesSupport.addExports(compilerModule, "org.graalvm.compiler.truffle.compiler.hotspot", runtimeModule);
                Class<?> hotspotCompilationSupport = Class.forName(compilerModule, "org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilationSupport");
                compilationSupport = (TruffleCompilationSupport)hotspotCompilationSupport.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!Boolean.getBoolean("polyglotimpl.DisableVersionChecks")) {
                    Version truffleVersion = HotSpotTruffleRuntimeAccess.getTruffleVersion();
                    Version truffleMajorMinorVersion = HotSpotTruffleRuntimeAccess.stripUpdateVersion(truffleVersion);
                    Version compilerVersion = HotSpotTruffleRuntimeAccess.getCompilerVersion(compilationSupport);
                    Version compilerMajorMinorVersion = HotSpotTruffleRuntimeAccess.stripUpdateVersion(compilerVersion);
                    if (!compilerMajorMinorVersion.equals((Object)truffleMajorMinorVersion)) {
                        return new DefaultTruffleRuntime(HotSpotTruffleRuntimeAccess.formatVersionWarningMessage("The Graal compiler version '%s' is incompatible with polyglot version '%s'.\nUpdate the compiler version to '%s' to resolve this.\n", compilerVersion, truffleVersion, truffleVersion));
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError(e);
            }
        }
        HotSpotTruffleRuntime rt = new HotSpotTruffleRuntime(compilationSupport);
        compilationSupport.registerRuntime(rt);
        return rt;
    }

    private static Version stripUpdateVersion(Version version) {
        int major = version.getComponent(0);
        int minor = version.getComponent(1);
        if (major == 0 && minor == 0) {
            return version;
        }
        return Version.create((int[])new int[]{major, minor});
    }

    private static String formatVersionWarningMessage(String errorFormat, Object ... args) {
        StringBuilder errorMessage = new StringBuilder("Version check failed.\n");
        errorMessage.append(String.format(errorFormat, args));
        errorMessage.append("To disable this version check the '-Dpolyglotimpl.DisableVersionChecks=true' system property can be used.\nIt is not recommended to disable version checks.\n");
        return errorMessage.toString();
    }

    private static Version getTruffleVersion() {
        try {
            Field versionField = PolyglotImpl.class.getDeclaredField("TRUFFLE_VERSION");
            versionField.setAccessible(true);
            return Version.parse((String)((String)versionField.get(null)));
        }
        catch (NoSuchFieldException nf) {
            return Version.create((int[])new int[]{23, 1, 1});
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    private static Version getCompilerVersion(TruffleCompilationSupport compilationSupport) {
        String compilerVersionString = null;
        try {
            Method getCompilerVersion = compilationSupport.getClass().getMethod("getCompilerVersion", new Class[0]);
            compilerVersionString = (String)getCompilerVersion.invoke((Object)compilationSupport, new Object[0]);
        }
        catch (NoSuchMethodException getCompilerVersion) {
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
        return compilerVersionString != null ? Version.parse(compilerVersionString) : Version.create((int[])new int[]{23, 1, 1});
    }
}

