/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.verify;

import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.CompilerDirectives.CompilationFinal"})
public class VerifyCompilationFinalProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        try (ProcessorContext context = ProcessorContext.enter(this.processingEnv);){
            TruffleTypes types = context.getTypes();
            for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.CompilerDirectives_CompilationFinal))) {
                if (!element.getKind().isField()) {
                    this.emitError(element, String.format("Only fields can be annotated with %s.", types.CompilerDirectives_CompilationFinal.asElement().getSimpleName().toString()));
                    continue;
                }
                if (!this.checkDimensions((VariableElement)element)) continue;
                this.assertNoErrorExpected(element);
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean checkDimensions(VariableElement field) {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        AnnotationMirror compFin = ElementUtils.findAnnotationMirror((Element)field, (TypeMirror)types.CompilerDirectives_CompilationFinal);
        if (compFin != null) {
            int compFinDimensions = ElementUtils.getAnnotationValue(Integer.class, compFin, "dimensions");
            int fieldDimensions = VerifyCompilationFinalProcessor.dimension(field.asType());
            if (compFinDimensions < -1) {
                this.emitError(field, "@CompilationFinal.dimensions cannot be negative.");
                return false;
            }
            if (compFinDimensions == -1 && fieldDimensions > 0) {
                SuppressWarnings suppressWarnings = field.getAnnotation(SuppressWarnings.class);
                if (suppressWarnings != null) {
                    for (String warning : suppressWarnings.value()) {
                        if (!"VerifyCompilationFinal".equals(warning)) continue;
                        return true;
                    }
                }
                this.emitWarning(field, "@CompilationFinal.dimensions should be given for an array type.");
                return false;
            }
            if (compFinDimensions > fieldDimensions) {
                if (fieldDimensions == 0) {
                    this.emitError(field, String.format("Positive @CompilationFinal.dimensions (%d) not allowed for non array type.", compFinDimensions));
                } else {
                    this.emitError(field, String.format("@CompilationFinal.dimensions (%d) cannot exceed the array's dimensions (%d).", compFinDimensions, fieldDimensions));
                }
                return false;
            }
        }
        return true;
    }

    void assertNoErrorExpected(Element originatingElm) {
        ExpectError.assertNoErrorExpected(originatingElm);
    }

    private void emitError(Element originatingElm, String message) {
        if (ExpectError.isExpectedError(originatingElm, message)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, originatingElm);
    }

    private void emitWarning(Element originatingElm, String message) {
        if (ExpectError.isExpectedError(originatingElm, message)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, originatingElm);
    }

    private static int dimension(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return 1 + VerifyCompilationFinalProcessor.dimension(((ArrayType)type).getComponentType());
        }
        return 0;
    }
}

