/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLBuiltins;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.DynamicOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.PrettyPrintable;
import com.oracle.truffle.dsl.processor.bytecode.model.ShortCircuitInstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.Signature;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class BytecodeDSLModel
extends Template
implements PrettyPrintable {
    private final ProcessorContext context;
    public final TypeElement templateType;
    public final String modelName;
    public final TypeMirror abstractBuilderType;
    private int operationId = 1;
    private final LinkedHashMap<String, OperationModel> operations = new LinkedHashMap();
    private final HashMap<TypeElement, CustomOperationModel> customRegularOperations = new HashMap();
    private final List<CustomOperationModel> customShortCircuitOperations = new ArrayList<CustomOperationModel>();
    private final HashMap<OperationModel, CustomOperationModel> operationsToCustomOperations = new HashMap();
    private LinkedHashMap<String, InstructionModel> instructions = new LinkedHashMap();
    public InstructionModel[] invalidateInstructions;
    public DeclaredType languageClass;
    public boolean enableUncachedInterpreter;
    public String defaultUncachedThreshold;
    public DSLExpression defaultUncachedThresholdExpression;
    public boolean enableSerialization;
    public boolean enableQuickening;
    public boolean allowUnsafe;
    public boolean enableYield;
    public boolean enableMaterializedLocalAccesses;
    public boolean storeBciInFrame;
    public boolean bytecodeDebugListener;
    public boolean additionalAssertions;
    public boolean enableSpecializationIntrospection;
    public boolean enableTagInstrumentation;
    public boolean enableRootTagging;
    public boolean enableRootBodyTagging;
    public boolean enableBlockScoping;
    public String defaultLocalValue;
    public DSLExpression defaultLocalValueExpression;
    public String variadicStackLimit;
    public DSLExpression variadicStackLimitExpression;
    public ExecutableElement fdConstructor;
    public ExecutableElement fdBuilderConstructor;
    public ExecutableElement interceptControlFlowException;
    public ExecutableElement interceptInternalException;
    public ExecutableElement interceptTruffleException;
    public TypeSystemData typeSystem;
    public Set<TypeMirror> boxingEliminatedTypes = Set.of();
    public List<VariableElement> serializedFields;
    public OperationModel blockOperation;
    public OperationModel rootOperation;
    public OperationModel conditionalOperation;
    public OperationModel whileOperation;
    public OperationModel tryCatchOperation;
    public OperationModel tryFinallyOperation;
    public OperationModel tryCatchOtherwiseOperation;
    public OperationModel finallyHandlerOperation;
    public OperationModel loadConstantOperation;
    public OperationModel loadNullOperation;
    public OperationModel loadLocalOperation;
    public OperationModel loadLocalMaterializedOperation;
    public OperationModel tagOperation;
    public OperationModel storeLocalOperation;
    public OperationModel storeLocalMaterializedOperation;
    public OperationModel ifThenOperation;
    public OperationModel ifThenElseOperation;
    public OperationModel returnOperation;
    public OperationModel sourceSectionPrefixOperation;
    public OperationModel sourceSectionSuffixOperation;
    public OperationModel sourceOperation;
    public CustomOperationModel prolog = null;
    public CustomOperationModel epilogReturn = null;
    public CustomOperationModel epilogExceptional = null;
    public InstructionModel nullInstruction;
    public InstructionModel popInstruction;
    public InstructionModel dupInstruction;
    public InstructionModel returnInstruction;
    public InstructionModel branchInstruction;
    public InstructionModel branchBackwardInstruction;
    public InstructionModel branchFalseInstruction;
    public InstructionModel storeLocalInstruction;
    public InstructionModel throwInstruction;
    public InstructionModel loadConstantInstruction;
    public InstructionModel loadNullInstruction;
    public InstructionModel yieldInstruction;
    public InstructionModel loadVariadicInstruction;
    public InstructionModel splatVariadicInstruction;
    public InstructionModel createVariadicInstruction;
    public InstructionModel emptyVariadicInstruction;
    public InstructionModel tagEnterInstruction;
    public InstructionModel tagLeaveValueInstruction;
    public InstructionModel tagLeaveVoidInstruction;
    public InstructionModel tagYieldInstruction;
    public InstructionModel tagResumeInstruction;
    public InstructionModel clearLocalInstruction;
    public final List<CustomOperationModel> instrumentations = new ArrayList<CustomOperationModel>();
    public ExportsData tagTreeNodeLibrary;
    public boolean hasCustomVariadic;
    public int maximumVariadicOffset;
    public boolean hasVariadicReturn;
    private List<TypeMirror> providedTags;
    private Set<String> providedTagsSet;

    public BytecodeDSLModel(ProcessorContext context, TypeElement templateType, AnnotationMirror mirror, String name, TypeMirror abstractBuilderType) {
        super(context, templateType, mirror);
        this.context = context;
        this.templateType = templateType;
        this.modelName = name;
        this.abstractBuilderType = abstractBuilderType;
    }

    public String getName() {
        return this.modelName;
    }

    public List<TypeMirror> getProvidedTags() {
        if (this.providedTags == null) {
            AnnotationMirror mirror = ElementUtils.findAnnotationMirror((Element)ElementUtils.castTypeElement(this.languageClass), (TypeMirror)this.types.ProvidedTags);
            this.providedTags = mirror == null ? Collections.emptyList() : ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "value");
        }
        return this.providedTags;
    }

    public boolean isTagProvided(TypeMirror tagClass) {
        if (this.providedTagsSet == null) {
            this.providedTagsSet = this.getProvidedTags().stream().map(ElementUtils::getUniqueIdentifier).distinct().collect(Collectors.toSet());
        }
        return this.providedTagsSet.contains(ElementUtils.getUniqueIdentifier(tagClass));
    }

    public Signature signature(Class<?> returnType, Class<?> ... argumentTypes) {
        TypeMirror[] arguments = new TypeMirror[argumentTypes.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.context.getType(argumentTypes[i]);
        }
        return new Signature(this.context.getType(returnType), List.of(arguments));
    }

    public TypeMirror findProvidedTag(TypeMirror searchTag) {
        if (!this.enableTagInstrumentation) {
            return null;
        }
        for (TypeMirror tag : this.getProvidedTags()) {
            if (!ElementUtils.typeEquals(tag, searchTag)) continue;
            return tag;
        }
        return null;
    }

    public TypeMirror getProvidedRootTag() {
        return this.findProvidedTag(this.types.StandardTags_RootTag);
    }

    public TypeMirror getProvidedRootBodyTag() {
        return this.findProvidedTag(this.types.StandardTags_RootBodyTag);
    }

    public boolean isBytecodeUpdatable() {
        return !this.getInstrumentations().isEmpty() || !this.getProvidedTags().isEmpty();
    }

    public InstructionModel getInvalidateInstruction(int length) {
        if (this.invalidateInstructions == null) {
            return null;
        }
        assert (length % 2 == 0);
        return this.invalidateInstructions[(length - 2) / 2];
    }

    public InstructionModel[] getInvalidateInstructions() {
        return this.invalidateInstructions;
    }

    public OperationModel operation(OperationModel.OperationKind kind, String name, String javadoc) {
        return this.operation(kind, name, javadoc, name);
    }

    public OperationModel operation(OperationModel.OperationKind kind, String name, String javadoc, String builderName) {
        if (this.operations.containsKey(name)) {
            this.addError("Multiple operations declared with name %s. Operation names must be distinct.", name);
            return null;
        }
        OperationModel op = new OperationModel(this, this.operationId++, kind, name, builderName, javadoc);
        this.operations.put(name, op);
        return op;
    }

    public List<CustomOperationModel> getInstrumentations() {
        return this.instrumentations;
    }

    public CustomOperationModel customRegularOperation(OperationModel.OperationKind kind, String name, String javadoc, TypeElement typeElement, AnnotationMirror mirror) {
        OperationModel op = this.operation(kind, name, javadoc);
        if (op == null) {
            return null;
        }
        CustomOperationModel operation = new CustomOperationModel(this.context, this, typeElement, mirror, op);
        if (this.customRegularOperations.containsKey(typeElement)) {
            throw new AssertionError((Object)String.format("Type element %s was used to instantiate more than one operation. This is a bug.", typeElement));
        }
        this.customRegularOperations.put(typeElement, operation);
        this.operationsToCustomOperations.put(op, operation);
        if (kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) {
            op.setInstrumentationIndex(this.instrumentations.size());
            this.instrumentations.add(operation);
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.Prolog)) {
            op.setInternal();
            if (this.prolog != null) {
                this.addError(typeElement, "%s is already annotated with @%s. A Bytecode DSL class can only declare one prolog.", ElementUtils.getSimpleName(this.prolog.getTemplateType()), ElementUtils.getSimpleName(this.types.Prolog));
                return null;
            }
            this.prolog = operation;
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.EpilogReturn)) {
            op.setInternal();
            op.setTransparent(true);
            op.setDynamicOperands(new DynamicOperandModel(List.of("value"), true, false));
            if (this.epilogReturn != null) {
                this.addError(typeElement, "%s is already annotated with @%s. A Bytecode DSL class can only declare one return epilog.", ElementUtils.getSimpleName(this.epilogReturn.getTemplateType()), ElementUtils.getSimpleName(this.types.EpilogReturn));
                return null;
            }
            this.epilogReturn = operation;
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.EpilogExceptional)) {
            op.setInternal();
            if (this.epilogExceptional != null) {
                this.addError(typeElement, "%s is already annotated with @%s. A Bytecode DSL class can only declare one exceptional epilog.", ElementUtils.getSimpleName(this.epilogExceptional.getTemplateType()), ElementUtils.getSimpleName(this.types.EpilogExceptional));
                return null;
            }
            this.epilogExceptional = operation;
        }
        return operation;
    }

    public CustomOperationModel customShortCircuitOperation(String name, String javadoc, AnnotationMirror mirror) {
        OperationModel op = this.operation(OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT, name, javadoc);
        if (op == null) {
            return null;
        }
        CustomOperationModel customOp = new CustomOperationModel(this.context, this, null, mirror, op);
        this.customShortCircuitOperations.add(customOp);
        this.operationsToCustomOperations.put(op, customOp);
        return customOp;
    }

    public CustomOperationModel getCustomOperationForType(TypeElement typeElement) {
        return this.customRegularOperations.get(typeElement);
    }

    public InstructionModel quickenInstruction(InstructionModel base, Signature signature, String specializationName) {
        InstructionModel model = this.instruction(base.kind, base.name + "$" + specializationName, signature, specializationName);
        for (InstructionModel.InstructionImmediate imm : base.getImmediates()) {
            model.addImmediate(imm.kind(), imm.name());
        }
        model.filteredSpecializations = base.filteredSpecializations;
        model.nodeData = base.nodeData;
        model.nodeType = base.nodeType;
        model.quickeningBase = base;
        model.operation = base.operation;
        model.shortCircuitModel = base.shortCircuitModel;
        base.quickenedInstructions.add(model);
        return model;
    }

    public boolean overridesBytecodeDebugListenerMethod(String methodName) {
        if (!this.bytecodeDebugListener) {
            return false;
        }
        ExecutableElement e = ElementUtils.findMethod(this.types.BytecodeDebugListener, methodName);
        if (e == null) {
            throw new IllegalArgumentException("Method with name " + methodName + " not found.");
        }
        TypeElement type = this.getTemplateType();
        while (type != null) {
            if (ElementUtils.findOverride(type, e) != null) {
                return true;
            }
            type = ElementUtils.castTypeElement(type.getSuperclass());
        }
        return false;
    }

    private InstructionModel instruction(InstructionModel.InstructionKind kind, String name, Signature signature, String quickeningName) {
        if (this.instructions.containsKey(name)) {
            throw new AssertionError((Object)String.format("Multiple instructions declared with name %s. Instruction names must be distinct.", name));
        }
        InstructionModel instr = new InstructionModel(kind, name, signature, quickeningName);
        this.instructions.put(name, instr);
        return instr;
    }

    public InstructionModel instruction(InstructionModel.InstructionKind kind, String name, Signature signature) {
        return this.instruction(kind, name, signature, null);
    }

    public InstructionModel shortCircuitInstruction(String name, ShortCircuitInstructionModel shortCircuitModel) {
        if (this.instructions.containsKey(name)) {
            throw new AssertionError((Object)String.format("Multiple instructions declared with name %s. Instruction names must be distinct.", name));
        }
        Signature signature = this.signature(shortCircuitModel.producesBoolean() ? Boolean.TYPE : Object.class, Boolean.TYPE, Boolean.TYPE);
        InstructionModel instr = this.instruction(InstructionModel.InstructionKind.CUSTOM_SHORT_CIRCUIT, name, signature);
        instr.shortCircuitModel = shortCircuitModel;
        InstructionModel booleanConverterInstruction = shortCircuitModel.booleanConverterInstruction();
        if (booleanConverterInstruction != null) {
            booleanConverterInstruction.shortCircuitInstructions.add(instr);
        }
        return instr;
    }

    @Override
    public Element getMessageElement() {
        return this.templateType;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.getTemplateTypeAnnotation();
    }

    public void finalizeInstructions() {
        BytecodeDSLBuiltins.addBuiltinsOnFinalize(this);
        LinkedHashMap<String, InstructionModel> newInstructions = new LinkedHashMap<String, InstructionModel>();
        for (Map.Entry<String, InstructionModel> entry : this.instructions.entrySet()) {
            String name = entry.getKey();
            InstructionModel instruction = entry.getValue();
            if (instruction.isQuickening()) continue;
            newInstructions.put(name, instruction);
            for (InstructionModel derivedInstruction : instruction.getFlattenedQuickenedInstructions()) {
                newInstructions.put(derivedInstruction.name, derivedInstruction);
            }
        }
        short currentId = 1;
        for (InstructionModel m : newInstructions.values()) {
            InstructionModel root;
            short s = currentId;
            currentId = (short)(currentId + 1);
            m.setId(s);
            m.validateAlignment();
            if (m.isQuickening() && (root = m.getQuickeningRoot()).getInstructionLength() != m.getInstructionLength()) {
                throw new AssertionError((Object)String.format("All quickenings must have the same instruction length as the root instruction. Invalid instruction length %s for instruction %s. Expected length %s from root %s.", m.getInstructionLength(), m.name, root.getInstructionLength(), root.name));
            }
        }
        this.instructions = newInstructions;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<CustomOperationModel> result = new ArrayList<CustomOperationModel>(this.customRegularOperations.values());
        result.addAll(this.customShortCircuitOperations);
        for (InstructionModel model : this.instructions.values()) {
            if (model.nodeData == null) continue;
            result.add((CustomOperationModel)((Object)model.nodeData));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean usesBoxingElimination() {
        return !this.boxingEliminatedTypes.isEmpty();
    }

    public boolean isBoxingEliminated(TypeMirror mirror) {
        if (!ElementUtils.isPrimitive(mirror)) {
            return false;
        }
        if (ElementUtils.isVoid(mirror)) {
            return false;
        }
        return this.boxingEliminatedTypes.contains(mirror);
    }

    public OperationModel getOperationByName(String name) {
        return this.operations.get(name);
    }

    public Collection<OperationModel> getOperations() {
        return this.operations.values();
    }

    public Collection<OperationModel> getOperationsWithChildren() {
        ArrayList<OperationModel> result = new ArrayList<OperationModel>();
        for (OperationModel operation : this.operations.values()) {
            if (!operation.hasChildren()) continue;
            result.add(operation);
        }
        return result;
    }

    public Collection<OperationModel> getUserOperations() {
        ArrayList<OperationModel> result = new ArrayList<OperationModel>();
        for (OperationModel operation : this.operations.values()) {
            if (operation.isInternal) continue;
            result.add(operation);
        }
        return result;
    }

    public Collection<InstructionModel> getInstructions() {
        return this.instructions.values();
    }

    public InstructionModel getInstructionByName(String name) {
        return this.instructions.get(name);
    }

    public CustomOperationModel getCustomOperationForOperation(OperationModel op) {
        return this.operationsToCustomOperations.get(op);
    }

    public boolean needsBciSlot() {
        return this.enableUncachedInterpreter || this.storeBciInFrame;
    }

    public boolean localAccessesNeedLocalIndex() {
        return this.enableBlockScoping && this.usesBoxingElimination();
    }

    public boolean materializedLocalAccessesNeedLocalIndex() {
        return this.enableMaterializedLocalAccesses && this.enableBlockScoping && (this.usesBoxingElimination() || this.storeBciInFrame);
    }

    public boolean canValidateMaterializedLocalLiveness() {
        return this.enableBlockScoping && this.storeBciInFrame;
    }

    @Override
    public void pp(PrettyPrintable.PrettyPrinter printer) {
        printer.field("operations", this.operations.values());
        printer.field("instructions", this.instructions.values());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public OperationModel findOperation(OperationModel.OperationKind kind) {
        OperationModel found = null;
        for (OperationModel o : this.getOperations()) {
            if (o.kind != kind) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple operations of kind found.");
            }
            found = o;
        }
        return found;
    }

    public void sortInstructionsByKind() {
        List<InstructionModel> sortedInstructions = this.instructions.values().stream().sorted((o1, o2) -> Integer.compare(o1.kind.ordinal(), o2.kind.ordinal())).toList();
        this.instructions.clear();
        for (InstructionModel instr : sortedInstructions) {
            this.instructions.put(instr.name, instr);
        }
    }
}

