/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeRootNodeElement;
import com.oracle.truffle.dsl.processor.bytecode.generator.ElementHelpers;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class BytecodeRootNodeErrorElement
extends CodeTypeElement {
    private final ProcessorContext context = ProcessorContext.getInstance();
    private final TruffleTypes types = this.context.getTypes();
    private final BytecodeDSLModel model;
    private final DeclaredType languageClass;
    private final BuilderElement builder;
    private final DeclaredType builderType;
    private final TypeMirror parserType;

    BytecodeRootNodeErrorElement(BytecodeDSLModel model) {
        super(Set.of(Modifier.PUBLIC, Modifier.FINAL), ElementKind.CLASS, ElementUtils.findPackageElement(model.getTemplateType()), model.getName());
        this.model = model;
        this.languageClass = model.languageClass == null ? ElementHelpers.generic((TypeMirror)this.types.TruffleLanguage, new TypeMirror[0]) : model.languageClass;
        this.setSuperClass(model.templateType.asType());
        GeneratorUtils.addGeneratedBy(this.context, this, model.templateType);
        this.builder = this.add(new BuilderElement());
        this.builderType = new GeneratedTypeMirror("", this.builder.getSimpleName().toString(), this.builder.asType());
        this.parserType = ElementHelpers.generic((TypeMirror)this.types.BytecodeParser, (TypeMirror)this.builderType);
        this.add(this.createExecute());
        this.add(this.createConstructor());
        this.add(this.createCreate());
        if (model.enableSerialization) {
            this.add(this.createSerialize());
            this.add(this.createDeserialize());
        }
        this.add(this.createNewConfigBuilder());
    }

    private CodeExecutableElement createExecute() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "execute", new String[]{"frame"}, new TypeMirror[]{this.types.VirtualFrame});
        CodeTreeBuilder b = ex.createBuilder();
        this.emitThrowNotImplemented(b);
        return ex;
    }

    private CodeExecutableElement createConstructor() {
        CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
        ctor.addParameter(new CodeVariableElement(this.languageClass, "language"));
        ctor.addParameter(new CodeVariableElement(this.types.FrameDescriptor_Builder, "builder"));
        CodeTreeBuilder b = ctor.getBuilder();
        b.startStatement().startCall("super");
        b.string("language");
        if (this.model.fdBuilderConstructor != null) {
            b.string("builder");
        } else {
            b.string("builder.build()");
        }
        b.end(2);
        this.emitThrowNotImplemented(b);
        return ctor;
    }

    private CodeExecutableElement createCreate() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, this.model.templateType.asType()), "create", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.languageClass, "language"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeConfig, "config"));
        method.addParameter(new CodeVariableElement(ElementHelpers.generic((TypeMirror)this.types.BytecodeParser, this.builder.asType()), "generator"));
        CodeTreeBuilder b = method.getBuilder();
        this.emitThrowNotImplemented(b);
        return method;
    }

    private CodeExecutableElement createSerialize() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), this.type(Void.TYPE), "serialize", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.type(DataOutput.class), "buffer"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeSerializer, "callback"));
        method.addParameter(new CodeVariableElement(this.parserType, "parser"));
        method.addThrownType(this.type(IOException.class));
        CodeTreeBuilder b = method.createBuilder();
        this.emitThrowNotImplemented(b);
        return method;
    }

    private CodeExecutableElement createDeserialize() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, this.model.getTemplateType().asType()), "deserialize", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.languageClass, "language"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeConfig, "config"));
        method.addParameter(new CodeVariableElement(ElementHelpers.generic(Supplier.class, DataInput.class), "input"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeDeserializer, "callback"));
        method.addThrownType(this.type(IOException.class));
        CodeTreeBuilder b = method.createBuilder();
        this.emitThrowNotImplemented(b);
        return method;
    }

    private CodeExecutableElement createNewConfigBuilder() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), this.types.BytecodeConfig_Builder, "newConfigBuilder", new CodeVariableElement[0]);
        CodeTreeBuilder b = method.createBuilder();
        this.emitThrowNotImplemented(b);
        return method;
    }

    private void emitThrowNotImplemented(CodeTreeBuilder b) {
        b.startThrow().startNew(this.type(AbstractMethodError.class));
        b.string("\"There are error(s) with the operation node specification. Please resolve the error(s) and recompile.\"");
        b.end(2);
    }

    TypeMirror type(Class<?> c) {
        return this.context.getType(c);
    }

    private final class BuilderElement
    extends CodeTypeElement {
        BuilderElement() {
            super(Set.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "Builder");
            this.setSuperClass(BytecodeRootNodeErrorElement.this.types.BytecodeBuilder);
            GeneratorUtils.mergeSuppressWarnings(this, "all");
            this.add(this.createMethodStub("createLocal", BytecodeRootNodeErrorElement.this.types.BytecodeLocal));
            this.add(this.createMethodStub("createLabel", BytecodeRootNodeErrorElement.this.types.BytecodeLabel));
            this.add(this.createMethodStub("beginSourceSectionUnavailable", BytecodeRootNodeErrorElement.this.type(Void.TYPE)));
            this.add(this.createMethodStub("endSourceSectionUnavailable", BytecodeRootNodeErrorElement.this.type(Void.TYPE)));
            block5: for (OperationModel operation : BytecodeRootNodeErrorElement.this.model.getOperations()) {
                switch (operation.kind) {
                    case ROOT: {
                        this.add(this.createBegin(operation));
                        CodeExecutableElement end = this.createEnd(operation);
                        end.setReturnType(BytecodeRootNodeErrorElement.this.model.templateType.asType());
                        this.add(end);
                        continue block5;
                    }
                    case TRY_FINALLY: 
                    case TRY_CATCH_OTHERWISE: {
                        CodeExecutableElement begin = this.createBegin(operation);
                        begin.getParameters().set(0, new CodeVariableElement(BytecodeRootNodeErrorElement.this.context.getDeclaredType(Runnable.class), "finallyParser"));
                        begin.setVarArgs(false);
                        this.add(begin);
                        this.add(this.createEnd(operation));
                        continue block5;
                    }
                    case TAG: {
                        ArrayType tagsType = ElementHelpers.arrayOf(BytecodeRootNodeErrorElement.this.context.getDeclaredType(Class.class));
                        CodeExecutableElement begin = this.createBegin(operation);
                        begin.getParameters().set(0, new CodeVariableElement(tagsType, "tags"));
                        this.add(begin);
                        CodeExecutableElement end = this.createEnd(operation);
                        end.getParameters().set(0, new CodeVariableElement(tagsType, "tags"));
                        this.add(end);
                        continue block5;
                    }
                }
                this.add(this.createBegin(operation));
                this.add(this.createEnd(operation));
                this.add(this.createEmit(operation));
            }
            this.add(this.createConstructor());
        }

        private CodeExecutableElement createMethodStub(String name, TypeMirror returnType) {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), returnType, name, new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeErrorElement.this.context.getDeclaredType(Object.class), "args"));
            ex.setVarArgs(true);
            BytecodeRootNodeErrorElement.this.emitThrowNotImplemented(ex.createBuilder());
            return ex;
        }

        private CodeExecutableElement createBegin(OperationModel operation) {
            return this.createMethodStub("begin" + operation.name, BytecodeRootNodeErrorElement.this.type(Void.TYPE));
        }

        private CodeExecutableElement createEnd(OperationModel operation) {
            return this.createMethodStub("end" + operation.name, BytecodeRootNodeErrorElement.this.type(Void.TYPE));
        }

        private CodeExecutableElement createEmit(OperationModel operation) {
            return this.createMethodStub("emit" + operation.name, BytecodeRootNodeErrorElement.this.type(Void.TYPE));
        }

        private CodeExecutableElement createConstructor() {
            CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
            CodeTreeBuilder b = ctor.getBuilder();
            b.startStatement().startCall("super").string("null").end(2);
            return ctor;
        }
    }
}

