/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeRootNodeElement;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.parser.SpecializationSignatureParser;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.NodeGeneratorPlugs;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class BytecodeDSLNodeGeneratorPlugs
implements NodeGeneratorPlugs {
    private final ProcessorContext context;
    private final TypeMirror nodeType;
    private final BytecodeDSLModel model;
    private final BytecodeRootNodeElement rootNode;
    private InstructionModel instruction;
    private CodeExecutableElement quickenMethod;

    public BytecodeDSLNodeGeneratorPlugs(BytecodeRootNodeElement rootNode, InstructionModel instr) {
        this.rootNode = rootNode;
        this.model = rootNode.getModel();
        this.context = rootNode.getContext();
        this.nodeType = rootNode.getAbstractBytecodeNode().asType();
        this.instruction = instr;
    }

    public void setInstruction(InstructionModel instr) {
        this.instruction = instr;
    }

    @Override
    public List<? extends VariableElement> additionalArguments() {
        ArrayList<CodeVariableElement> result = new ArrayList<CodeVariableElement>();
        if (this.model.enableYield) {
            result.add(new CodeVariableElement(this.context.getTypes().VirtualFrame, "$stackFrame"));
        }
        result.addAll(List.of(new CodeVariableElement(this.nodeType, "$bytecode"), new CodeVariableElement(this.context.getType(byte[].class), "$bc"), new CodeVariableElement(this.context.getType(Integer.TYPE), "$bci"), new CodeVariableElement(this.context.getType(Integer.TYPE), "$sp")));
        return result;
    }

    @Override
    public FlatNodeGenFactory.ChildExecutionResult createExecuteChild(FlatNodeGenFactory factory, CodeTreeBuilder builder, FlatNodeGenFactory.FrameState originalFrameState, FlatNodeGenFactory.FrameState frameState, NodeExecutionData execution, FlatNodeGenFactory.LocalVariable targetValue) {
        CodeTreeBuilder b = builder.create();
        b.string(targetValue.getName(), " = ");
        int index = execution.getIndex();
        boolean throwsUnexpectedResult = this.buildChildExecution(b, frameState, this.stackFrame(), index);
        return new FlatNodeGenFactory.ChildExecutionResult(b.build(), throwsUnexpectedResult);
    }

    @Override
    public boolean canBoxingEliminateType(NodeExecutionData currentExecution, TypeMirror type) {
        return this.model.isBoxingEliminated(type);
    }

    private boolean buildChildExecution(CodeTreeBuilder b, FlatNodeGenFactory.FrameState frameState, String frame, int specializationIndex) {
        if (specializationIndex < this.instruction.signature.constantOperandsBeforeCount) {
            TypeMirror constantOperandType = this.instruction.operation.constantOperands.before().get(specializationIndex).type();
            List<InstructionModel.InstructionImmediate> imms = this.instruction.getImmediates(InstructionModel.ImmediateKind.CONSTANT);
            InstructionModel.InstructionImmediate imm = imms.get(specializationIndex);
            b.tree(this.rootNode.readConstFastPath(BytecodeRootNodeElement.readImmediate("$bc", "$bci", imm), "$bytecode.constants", constantOperandType));
            return false;
        }
        int operandIndex = specializationIndex - this.instruction.signature.constantOperandsBeforeCount;
        int operandCount = this.instruction.signature.dynamicOperandCount;
        if (operandIndex < operandCount) {
            TypeMirror specializationTargetType;
            TypeMirror expectedType;
            TypeMirror specializedType = this.instruction.signature.getSpecializedType(operandIndex);
            TypeMirror genericType = this.instruction.signature.getGenericType(operandIndex);
            TypeMirror typeMirror = expectedType = this.instruction.isQuickening() ? specializedType : genericType;
            if (this.instruction.isQuickening()) {
                specializationTargetType = this.instruction.filteredSpecializations != null ? this.instruction.getSpecializationSignature().signature().getDynamicOperandTypes().get(operandIndex) : specializedType;
                expectedType = specializedType;
            } else {
                specializationTargetType = genericType;
                expectedType = genericType;
            }
            String stackIndex = "$sp - " + (operandCount - operandIndex);
            ImplicitCastData cast = this.instruction.nodeData.getTypeSystem().lookupCast(expectedType, specializationTargetType);
            if (this.instruction.getQuickeningRoot().needsBoxingElimination(this.model, operandIndex)) {
                if (frameState.getMode().isFastPath()) {
                    b.startStatement();
                    if (!ElementUtils.typeEquals(expectedType, specializedType)) {
                        b.startStaticCall(this.rootNode.lookupExpectMethod(expectedType, specializedType));
                    }
                    if (cast != null) {
                        b.startStaticCall(cast.getMethod());
                    }
                    BytecodeRootNodeElement.startExpectFrameUnsafe(b, frame, expectedType);
                    b.string(stackIndex);
                    b.end();
                    if (cast != null) {
                        b.end();
                    }
                    if (!ElementUtils.typeEquals(expectedType, specializedType)) {
                        b.end();
                    }
                    b.end();
                    return true;
                }
                if (!ElementUtils.isObject(genericType)) {
                    b.cast(specializedType);
                }
                BytecodeRootNodeElement.startGetFrameUnsafe(b, frame, null);
                b.string(stackIndex);
                b.end();
                return false;
            }
            if (!ElementUtils.isObject(genericType)) {
                b.cast(expectedType);
            }
            b.string(BytecodeRootNodeElement.uncheckedGetFrameObject(frame, stackIndex));
            return false;
        }
        int constantOperandAfterIndex = specializationIndex - this.instruction.signature.constantOperandsBeforeCount - this.instruction.signature.dynamicOperandCount;
        int constantOperandAfterCount = this.instruction.signature.constantOperandsAfterCount;
        if (constantOperandAfterIndex < constantOperandAfterCount) {
            TypeMirror constantOperandType = this.instruction.operation.constantOperands.after().get(constantOperandAfterIndex).type();
            List<InstructionModel.InstructionImmediate> imms = this.instruction.getImmediates(InstructionModel.ImmediateKind.CONSTANT);
            InstructionModel.InstructionImmediate imm = imms.get(this.instruction.signature.constantOperandsBeforeCount + constantOperandAfterIndex);
            b.tree(this.rootNode.readConstFastPath(BytecodeRootNodeElement.readImmediate("$bc", "$bci", imm), "$bytecode.constants", constantOperandType));
            return false;
        }
        throw new AssertionError((Object)("index=" + specializationIndex + ", signature=" + String.valueOf(this.instruction.signature)));
    }

    public CodeExecutableElement getQuickenMethod() {
        return this.quickenMethod;
    }

    @Override
    public void notifySpecialize(FlatNodeGenFactory nodeFactory, CodeTreeBuilder builder, FlatNodeGenFactory.FrameState frameState, SpecializationData specialization) {
        if (this.model.bytecodeDebugListener) {
            this.rootNode.emitOnSpecialize(builder, "$bytecode", "$bci", BytecodeRootNodeElement.readInstruction("$bc", "$bci"), specialization.getNode().getNodeId() + "$" + specialization.getId());
        }
        if (this.instruction.getQuickeningRoot().hasSpecializedQuickenings()) {
            if (this.quickenMethod == null) {
                this.quickenMethod = this.createQuickenMethod(nodeFactory, frameState);
            }
            nodeFactory.loadQuickeningStateBitSets(builder, frameState, this.instruction.nodeData.getReachableSpecializations());
            builder.startStatement();
            builder.startCall("quicken");
            for (VariableElement var : this.quickenMethod.getParameters()) {
                builder.string(var.getSimpleName().toString());
            }
            builder.end();
            builder.end();
        }
    }

    @Override
    public CodeTree bindExpressionValue(FlatNodeGenFactory.FrameState frameState, DSLExpression.Variable variable) {
        switch (variable.getName()) {
            case "this": 
            case "$node": {
                if (frameState.getMode().isUncached()) {
                    return CodeTreeBuilder.singleString("$bytecode");
                }
                return null;
            }
            case "$bytecodeNode": {
                return CodeTreeBuilder.singleString("$bytecode");
            }
            case "$rootNode": {
                return CodeTreeBuilder.singleString("$bytecode.getRoot()");
            }
            case "$bytecodeIndex": {
                return CodeTreeBuilder.singleString("$bci");
            }
        }
        return null;
    }

    private CodeExecutableElement createQuickenMethod(FlatNodeGenFactory factory, FlatNodeGenFactory.FrameState frameState) {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.context.getType(Void.TYPE), "quicken", new CodeVariableElement[0]);
        factory.addQuickeningStateParametersTo(method, frameState, this.instruction.nodeData.getReachableSpecializations());
        if (this.model.bytecodeDebugListener) {
            method.addParameter(new CodeVariableElement(this.rootNode.getAbstractBytecodeNode().asType(), "$bytecode"));
        }
        method.addParameter(new CodeVariableElement(this.context.getType(byte[].class), "$bc"));
        method.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "$bci"));
        CodeTreeBuilder b = method.createBuilder();
        b.declaration(this.context.getType(Short.TYPE), "newInstruction");
        TreeSet<Integer> boxingEliminated = new TreeSet<Integer>();
        List<InstructionModel> relevantQuickenings = this.instruction.quickenedInstructions.stream().filter(q -> !q.isReturnTypeQuickening() && q.filteredSpecializations != null).toList();
        for (InstructionModel quickening : relevantQuickenings) {
            for (int index = 0; index < quickening.signature.dynamicOperandCount; ++index) {
                if (!this.model.isBoxingEliminated(quickening.signature.getSpecializedType(index))) continue;
                boxingEliminated.add(index);
            }
        }
        Iterator<InstructionModel> iterator = boxingEliminated.iterator();
        while (iterator.hasNext()) {
            int valueIndex = (Integer)((Object)iterator.next());
            InstructionModel.InstructionImmediate immediate = this.instruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "child" + valueIndex);
            b.startStatement();
            b.string("int oldOperandIndex" + valueIndex);
            b.string(" = ");
            b.tree(BytecodeRootNodeElement.readImmediate("$bc", "$bci", immediate));
            b.end();
            if (this.instruction.isShortCircuitConverter() || this.instruction.isEpilogReturn()) {
                b.declaration(this.context.getType(Short.TYPE), "oldOperand" + valueIndex);
                b.startIf().string("oldOperandIndex" + valueIndex).string(" != -1").end().startBlock();
                b.startStatement();
                b.string("oldOperand" + valueIndex);
                b.string(" = ");
                b.tree(BytecodeRootNodeElement.readInstruction("$bc", "oldOperandIndex" + valueIndex));
                b.end();
                b.end().startElseBlock();
                b.startStatement();
                b.string("oldOperand" + valueIndex);
                b.string(" = ");
                b.string("-1");
                b.end();
                b.end();
            } else {
                b.startStatement();
                b.string("short oldOperand" + valueIndex);
                b.string(" = ");
                b.tree(BytecodeRootNodeElement.readInstruction("$bc", "oldOperandIndex" + valueIndex));
                b.end();
            }
            b.declaration(this.context.getType(Short.TYPE), "newOperand" + valueIndex);
        }
        boolean elseIf = false;
        for (InstructionModel quickening : relevantQuickenings) {
            TypeMirror specializedType;
            int valueIndex;
            elseIf = b.startIf(elseIf);
            CodeTree activeCheck = factory.createOnlyActive(frameState, quickening.filteredSpecializations, this.instruction.nodeData.getReachableSpecializations());
            b.tree(activeCheck);
            String sep = activeCheck.isEmpty() ? "" : " && ";
            SpecializationSignatureParser.SpecializationSignature specializationSignature = quickening.operation.getSpecializationSignature(quickening.filteredSpecializations);
            List<TypeMirror> dynamicOperandTypes = specializationSignature.signature().getDynamicOperandTypes();
            Iterator iterator2 = boxingEliminated.iterator();
            while (iterator2.hasNext()) {
                TypeMirror specializationTargetType;
                valueIndex = (Integer)iterator2.next();
                specializedType = quickening.signature.getSpecializedType(valueIndex);
                CodeTree check = factory.createIsImplicitTypeStateCheck(frameState, specializedType, specializationTargetType = dynamicOperandTypes.get(valueIndex), valueIndex + specializationSignature.signature().constantOperandsBeforeCount);
                if (check == null) continue;
                b.newLine().string("  ", sep, "(");
                sep = " && ";
                b.tree(check);
                b.string(")");
            }
            iterator2 = boxingEliminated.iterator();
            while (iterator2.hasNext()) {
                valueIndex = (Integer)iterator2.next();
                specializedType = quickening.signature.getSpecializedType(valueIndex);
                if (!this.model.isBoxingEliminated(specializedType)) continue;
                b.newLine().string("  ", sep, "(");
                b.string("newOperand" + valueIndex);
                b.string(" = ");
                b.startCall(BytecodeRootNodeElement.createApplyQuickeningName(specializedType)).string("oldOperand" + valueIndex).end();
                b.string(") != -1");
                sep = " && ";
            }
            b.end().startBlock();
            iterator2 = boxingEliminated.iterator();
            while (iterator2.hasNext()) {
                valueIndex = (Integer)iterator2.next();
                specializedType = quickening.signature.getSpecializedType(valueIndex);
                if (this.model.isBoxingEliminated(specializedType)) continue;
                b.startStatement();
                b.string("newOperand" + valueIndex, " = undoQuickening(oldOperand" + valueIndex + ")");
                b.end();
            }
            List<InstructionModel> returnTypeQuickenings = BytecodeDSLNodeGeneratorPlugs.findReturnTypeQuickenings(quickening);
            if (!returnTypeQuickenings.isEmpty()) {
                elseIf = false;
                for (InstructionModel returnTypeQuickening : returnTypeQuickenings) {
                    elseIf = b.startIf(elseIf);
                    b.startCall(BytecodeRootNodeElement.createIsQuickeningName(returnTypeQuickening.signature.returnType)).tree(BytecodeRootNodeElement.readInstruction("$bc", "$bci")).end();
                    b.end().startBlock();
                    b.startStatement();
                    b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(returnTypeQuickening));
                    b.end();
                    b.end();
                }
                b.startElseBlock();
                b.startStatement();
                b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(quickening));
                b.end();
                b.end();
            } else {
                b.startStatement();
                b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(quickening));
                b.end();
            }
            b.end();
        }
        b.startElseBlock(elseIf);
        Iterator<InstructionModel> valueIndex = boxingEliminated.iterator();
        while (valueIndex.hasNext()) {
            int valueIndex2 = (Integer)((Object)valueIndex.next());
            b.startStatement();
            b.string("newOperand" + valueIndex2, " = undoQuickening(oldOperand" + valueIndex2 + ")");
            b.end();
        }
        List<InstructionModel> returnTypeQuickenings = BytecodeDSLNodeGeneratorPlugs.findReturnTypeQuickenings(this.instruction);
        if (!returnTypeQuickenings.isEmpty()) {
            elseIf = false;
            for (InstructionModel returnTypeQuickening : returnTypeQuickenings) {
                elseIf = b.startIf(elseIf);
                b.startCall(BytecodeRootNodeElement.createIsQuickeningName(returnTypeQuickening.signature.returnType)).tree(BytecodeRootNodeElement.readInstruction("$bc", "$bci")).end();
                b.end().startBlock();
                b.startStatement();
                b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(returnTypeQuickening));
                b.end();
                b.end();
            }
            b.startElseBlock();
            b.startStatement();
            b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(this.instruction));
            b.end();
            b.end();
        } else {
            b.startStatement();
            b.string("newInstruction = ").tree(this.rootNode.createInstructionConstant(this.instruction));
            b.end();
        }
        b.end();
        Iterator iterator3 = boxingEliminated.iterator();
        while (iterator3.hasNext()) {
            int valueIndex3 = (Integer)iterator3.next();
            if (this.instruction.isShortCircuitConverter()) {
                b.startIf().string("newOperand" + valueIndex3).string(" != -1").end().startBlock();
                this.rootNode.emitQuickeningOperand(b, "$bytecode", "$bc", "$bci", null, valueIndex3, "oldOperandIndex" + valueIndex3, "oldOperand" + valueIndex3, "newOperand" + valueIndex3);
                b.end();
                continue;
            }
            this.rootNode.emitQuickeningOperand(b, "$bytecode", "$bc", "$bci", null, valueIndex3, "oldOperandIndex" + valueIndex3, "oldOperand" + valueIndex3, "newOperand" + valueIndex3);
        }
        this.rootNode.emitQuickening(b, "$bytecode", "$bc", "$bci", null, "newInstruction");
        return method;
    }

    private static List<InstructionModel> findReturnTypeQuickenings(InstructionModel quickening) throws AssertionError {
        ArrayList<InstructionModel> returnTypeQuickenings = new ArrayList<InstructionModel>();
        for (InstructionModel returnType : quickening.quickenedInstructions) {
            if (!returnType.isReturnTypeQuickening()) continue;
            returnTypeQuickenings.add(returnType);
        }
        return returnTypeQuickenings;
    }

    @Override
    public String createNodeChildReferenceForException(FlatNodeGenFactory flatNodeGenFactory, FlatNodeGenFactory.FrameState frameState, NodeExecutionData execution, NodeChildData child) {
        return "null";
    }

    private String stackFrame() {
        return this.model.enableYield ? "$stackFrame" : "frameValue";
    }
}

