/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public final class TruffleSuppressedWarnings {
    public static final String ALL = "all";
    public static final String TRUFFLE = "truffle";
    public static final String STATIC_METHOD = "truffle-static-method";
    public static final String UNEXPECTED_RESULT_REWRITE = "truffle-unexpected-result-rewrite";
    public static final String LIMIT = "truffle-limit";
    public static final String UNUSED = "truffle-unused";
    public static final String NEVERDEFAULT = "truffle-neverdefault";
    public static final String INLINING_RECOMMENDATION = "truffle-inlining";
    public static final String SHARING_RECOMMENDATION = "truffle-sharing";
    public static final String SPLITTING = "truffle-splitting";
    public static final String ABSTRACT_LIBRARY_EXPORT = "truffle-abstract-export";
    public static final String ASSUMPTION = "truffle-assumption";
    public static final String GUARD = "truffle-guard";
    public static final String DEPRECATION = "deprecation";
    public static final String INTERPRETED_PERFORMANCE = "truffle-interpreted-performance";
    public static final String FORCE_CACHED = "truffle-force-cached";
    public static final List<String> ALL_KEYS = List.of("all", "truffle", "truffle-static-method", "truffle-unexpected-result-rewrite", "truffle-limit", "truffle-unused", "truffle-neverdefault", "truffle-inlining", "truffle-sharing", "truffle-abstract-export", "deprecation", "truffle-interpreted-performance", "truffle-force-cached");

    private TruffleSuppressedWarnings() {
    }

    public static Set<String> getWarnings(Element element) {
        List<String> currentValues;
        AnnotationMirror currentWarnings = ElementUtils.findAnnotationMirror(element, SuppressWarnings.class);
        LinkedHashSet<String> warnings = null;
        if (currentWarnings != null && (currentValues = ElementUtils.getAnnotationValueList(String.class, currentWarnings, "value")) != null && !currentValues.isEmpty()) {
            if (warnings == null) {
                warnings = new LinkedHashSet<String>();
            }
            warnings.addAll(currentValues);
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            List<String> currentValues2;
            TruffleTypes types = ProcessorContext.getInstance().getTypes();
            AnnotationMirror packageWarnings = ElementUtils.findAnnotationMirror(element, (TypeMirror)types.SuppressPackageWarnings);
            if (packageWarnings != null && (currentValues2 = ElementUtils.getAnnotationValueList(String.class, packageWarnings, "value")) != null && !currentValues2.isEmpty()) {
                if (warnings == null) {
                    warnings = new LinkedHashSet();
                }
                warnings.addAll(currentValues2);
            }
        }
        return warnings == null ? Collections.emptySet() : warnings;
    }

    public static boolean isSuppressed(Element element, String ... warningKind) {
        Element e = element;
        do {
            Set<String> warnings;
            if (!(warnings = TruffleSuppressedWarnings.getWarnings(e)).contains(ALL) && !warnings.contains(TRUFFLE) && !warnings.stream().anyMatch(s -> Arrays.asList(warningKind).contains(s))) continue;
            return true;
        } while ((e = e.getEnclosingElement()) != null);
        return false;
    }
}

