/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class InlineFieldData {
    final Element sourceElement;
    final String name;
    final Integer bits;
    final TypeMirror type;
    final TypeMirror fieldType;
    final int dimensions;

    public InlineFieldData(Element sourceElement, String name, TypeMirror fieldType, Integer bits, TypeMirror type, int dimensions) {
        this.sourceElement = sourceElement;
        this.name = name;
        this.fieldType = fieldType;
        this.bits = bits;
        this.dimensions = dimensions;
        this.type = this.isPrimitive() ? InlineFieldData.resolvePrimitiveValueType(fieldType) : type;
    }

    public static TypeMirror resolvePrimitiveFieldType(TypeMirror valueType) {
        ProcessorContext context = ProcessorContext.getInstance();
        if (ElementUtils.typeEquals(valueType, context.getType(Boolean.TYPE))) {
            return ProcessorContext.types().InlineSupport_BooleanField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Byte.TYPE))) {
            return ProcessorContext.types().InlineSupport_ByteField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Short.TYPE))) {
            return ProcessorContext.types().InlineSupport_ShortField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Character.TYPE))) {
            return ProcessorContext.types().InlineSupport_CharField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Integer.TYPE))) {
            return ProcessorContext.types().InlineSupport_IntField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Float.TYPE))) {
            return ProcessorContext.types().InlineSupport_FloatField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Long.TYPE))) {
            return ProcessorContext.types().InlineSupport_LongField;
        }
        if (ElementUtils.typeEquals(valueType, context.getType(Double.TYPE))) {
            return ProcessorContext.types().InlineSupport_DoubleField;
        }
        throw new AssertionError((Object)"Invalid primitive field type.");
    }

    private static TypeMirror resolvePrimitiveValueType(TypeMirror fieldType) {
        ProcessorContext context = ProcessorContext.getInstance();
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_BooleanField)) {
            return context.getType(Boolean.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_ByteField)) {
            return context.getType(Byte.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_ShortField)) {
            return context.getType(Short.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_CharField)) {
            return context.getType(Character.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_IntField)) {
            return context.getType(Integer.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_FloatField)) {
            return context.getType(Float.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_LongField)) {
            return context.getType(Long.TYPE);
        }
        if (ElementUtils.typeEquals(fieldType, ProcessorContext.types().InlineSupport_DoubleField)) {
            return context.getType(Double.TYPE);
        }
        throw new AssertionError((Object)"Invalid primitive field type.");
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String getName() {
        return this.name;
    }

    public Element getSourceElement() {
        return this.sourceElement;
    }

    public TypeMirror getFieldType() {
        if (this.isReference()) {
            return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementUtils.castTypeElement(this.fieldType), Arrays.asList(this.getType()));
        }
        return this.fieldType;
    }

    public boolean isState() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return ElementUtils.typeEquals(this.fieldType, types.InlineSupport_StateField);
    }

    public boolean isPrimitive() {
        return !this.isState() && !this.isReference();
    }

    public boolean isReference() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return ElementUtils.typeEquals(this.fieldType, types.InlineSupport_ReferenceField);
    }

    public boolean hasBits() {
        return this.bits != null;
    }

    public int getBits() {
        return this.bits;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public InlineFieldData copy() {
        return new InlineFieldData(this.sourceElement, this.name, this.fieldType, this.bits, this.type, this.dimensions);
    }

    public boolean isCompatibleWith(InlineFieldData declared) {
        if (!ElementUtils.typeEquals(this.fieldType, declared.fieldType)) {
            return false;
        }
        if (!ElementUtils.typeEquals(this.type, declared.type)) {
            return false;
        }
        if (this.dimensions != declared.dimensions) {
            return false;
        }
        if (declared.bits == null ^ this.bits == null) {
            return false;
        }
        return declared.bits == null || declared.bits >= this.bits;
    }
}

