/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public final class Signature {
    public final ProcessorContext context = ProcessorContext.getInstance();
    public final TypeMirror returnType;
    public final List<TypeMirror> operandTypes;
    public final boolean isVariadic;
    public final boolean isVoid;
    public final int constantOperandsBeforeCount;
    public final int dynamicOperandCount;
    public final int constantOperandsAfterCount;

    public Signature(TypeMirror returnType, List<TypeMirror> types) {
        this(returnType, types, false, 0, 0);
    }

    public Signature(TypeMirror returnType, List<TypeMirror> types, boolean isVariadic, int constantOperandsBeforeCount, int constantOperandsAfterCount) {
        this.returnType = returnType;
        this.operandTypes = Collections.unmodifiableList(types);
        this.isVariadic = isVariadic;
        this.isVoid = ElementUtils.isVoid(returnType);
        this.constantOperandsBeforeCount = constantOperandsBeforeCount;
        this.dynamicOperandCount = this.operandTypes.size() - constantOperandsBeforeCount - constantOperandsAfterCount;
        this.constantOperandsAfterCount = constantOperandsAfterCount;
    }

    private Signature(Signature copy, List<TypeMirror> operandTypes, TypeMirror returnType) {
        if (operandTypes.size() != copy.operandTypes.size()) {
            throw new IllegalArgumentException();
        }
        this.returnType = returnType;
        this.operandTypes = operandTypes;
        this.isVariadic = copy.isVariadic;
        this.isVoid = copy.isVoid;
        this.constantOperandsBeforeCount = copy.constantOperandsBeforeCount;
        this.dynamicOperandCount = copy.dynamicOperandCount;
        this.constantOperandsAfterCount = copy.constantOperandsAfterCount;
    }

    public List<TypeMirror> getDynamicOperandTypes() {
        return this.operandTypes.subList(this.constantOperandsBeforeCount, this.constantOperandsBeforeCount + this.dynamicOperandCount);
    }

    public Signature specializeReturnType(TypeMirror newReturnType) {
        return new Signature(this, this.operandTypes, newReturnType);
    }

    public Signature specializeOperandType(int dynamicOperandIndex, TypeMirror newType) {
        if (dynamicOperandIndex < 0 || dynamicOperandIndex >= this.dynamicOperandCount) {
            throw new IllegalArgumentException("Invalid operand index " + dynamicOperandIndex);
        }
        TypeMirror type = this.getSpecializedType(dynamicOperandIndex);
        if (ElementUtils.typeEquals(type, newType)) {
            return this;
        }
        ArrayList<TypeMirror> newOperandTypes = new ArrayList<TypeMirror>(this.operandTypes);
        newOperandTypes.set(dynamicOperandIndex, newType);
        return new Signature(this, newOperandTypes, this.returnType);
    }

    public TypeMirror getGenericType(int dynamicOperandIndex) {
        if (dynamicOperandIndex < 0 || dynamicOperandIndex >= this.dynamicOperandCount) {
            throw new IllegalArgumentException("Invalid operand index " + dynamicOperandIndex);
        }
        if (this.isVariadicParameter(dynamicOperandIndex)) {
            return this.context.getType(Object[].class);
        }
        return this.context.getType(Object.class);
    }

    public TypeMirror getGenericReturnType() {
        if (this.isVoid) {
            return this.context.getType(Void.TYPE);
        }
        return this.context.getType(Object.class);
    }

    public TypeMirror getSpecializedType(int dynamicOperandIndex) {
        if (dynamicOperandIndex < 0 && dynamicOperandIndex >= this.dynamicOperandCount) {
            throw new IllegalArgumentException("Invalid operand index " + dynamicOperandIndex);
        }
        if (this.isVariadicParameter(dynamicOperandIndex)) {
            return this.context.getType(Object[].class);
        }
        return this.operandTypes.get(this.constantOperandsBeforeCount + dynamicOperandIndex);
    }

    public boolean isVariadicParameter(int i) {
        return this.isVariadic && i == this.dynamicOperandCount - 1;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(ElementUtils.getSimpleName(this.returnType)).append(" ");
        sb.append("(");
        for (int i2 = 0; i2 < this.constantOperandsBeforeCount; ++i2) {
            sb.append(ElementUtils.getSimpleName(this.operandTypes.get(i2)));
            sb.append(", ");
        }
        int offset = this.constantOperandsBeforeCount;
        for (i = 0; i < this.dynamicOperandCount; ++i) {
            sb.append(ElementUtils.getSimpleName(this.operandTypes.get(offset + i)));
            if (this.isVariadic && i == this.dynamicOperandCount - 1) {
                sb.append("...");
            }
            sb.append(", ");
        }
        offset += this.dynamicOperandCount;
        for (i = 0; i < this.constantOperandsAfterCount; ++i) {
            sb.append(ElementUtils.getSimpleName(this.operandTypes.get(offset + i)));
            sb.append(", ");
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(')');
        return sb.toString();
    }
}

