/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public class OptimizationDecisionsModel {

    public record ResolvedQuickenDecision(OperationModel operation, List<SpecializationData> specializations, List<TypeMirror> types) {
    }

    public record QuickenDecision(String operation, Set<String> specializations, List<String> types) {
        public QuickenDecision(OperationModel operationModel, Collection<SpecializationData> specializations) {
            this(operationModel, specializations, null);
        }

        public QuickenDecision(OperationModel operationModel, Collection<SpecializationData> specializations, List<TypeMirror> types) {
            this(operationModel.name, QuickenDecision.translateSpecializations(specializations), QuickenDecision.translateTypes(types));
        }

        private static List<String> translateTypes(List<TypeMirror> types) {
            if (types == null) {
                return null;
            }
            return types.stream().map(e -> ElementUtils.getQualifiedName(e)).toList();
        }

        private static Set<String> translateSpecializations(Collection<SpecializationData> specializations) {
            List<String> allIds = specializations.stream().filter(s -> s.getMethod() != null).map(s -> s.getMethodName()).toList();
            HashSet<String> allIdsSet = new HashSet<String>(allIds);
            return allIdsSet;
        }

        public ResolvedQuickenDecision resolve(BytecodeDSLModel model) {
            List<TypeMirror> parameterTypes;
            OperationModel operationModel = model.getOperationByName(this.operation);
            List<SpecializationData> specializationModels = operationModel.instruction.nodeData.findSpecializationsByName(this.specializations);
            ProcessorContext c = ProcessorContext.getInstance();
            if (this.types == null) {
                parameterTypes = null;
                for (SpecializationData specializationData : specializationModels) {
                    List<TypeMirror> specializationTypes = operationModel.getSpecializationSignature(specializationData).signature().getDynamicOperandTypes();
                    if (parameterTypes == null) {
                        parameterTypes = new ArrayList<TypeMirror>(specializationTypes);
                        continue;
                    }
                    for (int i = 0; i < specializationTypes.size(); ++i) {
                        TypeMirror type2;
                        TypeMirror type1 = specializationTypes.get(i);
                        if (ElementUtils.typeEquals(type1, type2 = parameterTypes.get(i))) continue;
                        parameterTypes.set(i, c.getType(Object.class));
                    }
                }
            } else {
                parameterTypes = this.types.stream().map(typeName -> ElementUtils.fromQualifiedName(typeName)).toList();
            }
            return new ResolvedQuickenDecision(operationModel, specializationModels, parameterTypes);
        }
    }
}

