/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TypeCastData;
import com.oracle.truffle.dsl.processor.model.TypeCheckData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class TypeSystemData
extends Template {
    private final List<ImplicitCastData> implicitCasts = new ArrayList<ImplicitCastData>();
    private final List<TypeCastData> casts = new ArrayList<TypeCastData>();
    private final List<TypeCheckData> checks = new ArrayList<TypeCheckData>();
    private final List<TypeMirror> legacyTypes = new ArrayList<TypeMirror>();
    private Set<String> legacyTypeIds;
    private final boolean isDefault;

    public TypeSystemData(ProcessorContext context, TypeElement templateType, AnnotationMirror annotation, boolean isDefault) {
        super(context, templateType, annotation);
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TypeSystemData getTypeSystem() {
        return this;
    }

    public List<TypeMirror> getLegacyTypes() {
        return this.legacyTypes;
    }

    public TypeCastData getCast(TypeMirror targetType) {
        for (TypeCastData cast : this.casts) {
            if (!ElementUtils.typeEquals(cast.getTargetType(), targetType)) continue;
            return cast;
        }
        return null;
    }

    public TypeCheckData getCheck(TypeMirror type) {
        for (TypeCheckData check : this.checks) {
            if (!ElementUtils.typeEquals(check.getCheckedType(), type)) continue;
            return check;
        }
        return null;
    }

    public List<ImplicitCastData> getImplicitCasts() {
        return this.implicitCasts;
    }

    public List<TypeCastData> getCasts() {
        return this.casts;
    }

    public List<TypeCheckData> getChecks() {
        return this.checks;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<MessageContainer> sinks = new ArrayList<MessageContainer>();
        if (this.checks != null) {
            sinks.addAll(this.checks);
        }
        if (this.casts != null) {
            sinks.addAll(this.casts);
        }
        if (this.implicitCasts != null) {
            sinks.addAll(this.implicitCasts);
        }
        return sinks;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[template = " + ElementUtils.getSimpleName(this.getTemplateType()) + "]";
    }

    public List<ImplicitCastData> lookupByTargetType(TypeMirror targetType) {
        if (this.getImplicitCasts() == null) {
            return List.of();
        }
        ArrayList<ImplicitCastData> foundCasts = new ArrayList<ImplicitCastData>();
        for (ImplicitCastData cast : this.getImplicitCasts()) {
            if (!ElementUtils.typeEquals(cast.getTargetType(), targetType)) continue;
            foundCasts.add(cast);
        }
        return foundCasts;
    }

    public ImplicitCastData lookupCast(TypeMirror sourceType, TypeMirror targetType) {
        if (this.getImplicitCasts() == null) {
            return null;
        }
        for (ImplicitCastData cast : this.getImplicitCasts()) {
            if (!ElementUtils.typeEquals(cast.getSourceType(), sourceType) || !ElementUtils.typeEquals(cast.getTargetType(), targetType)) continue;
            return cast;
        }
        return null;
    }

    public boolean hasImplicitSourceTypes(TypeMirror targetType) {
        if (this.getImplicitCasts() == null) {
            return false;
        }
        for (ImplicitCastData cast : this.getImplicitCasts()) {
            if (!ElementUtils.typeEquals(cast.getTargetType(), targetType)) continue;
            return true;
        }
        return false;
    }

    public Collection<TypeMirror> lookupTargetTypes() {
        ArrayList<TypeMirror> sourceTypes = new ArrayList<TypeMirror>();
        for (ImplicitCastData cast : this.getImplicitCasts()) {
            sourceTypes.add(cast.getTargetType());
        }
        return ElementUtils.uniqueTypes(sourceTypes);
    }

    public Collection<TypeMirror> lookupSourceTypes(TypeMirror targetType) {
        ArrayList<TypeMirror> sourceTypes = new ArrayList<TypeMirror>();
        sourceTypes.add(targetType);
        for (ImplicitCastData cast : this.getImplicitCasts()) {
            if (!ElementUtils.typeEquals(cast.getTargetType(), targetType)) continue;
            sourceTypes.add(cast.getSourceType());
        }
        return ElementUtils.uniqueTypes(sourceTypes);
    }

    public boolean isImplicitSubtypeOf(TypeMirror source, TypeMirror target) {
        List<ImplicitCastData> targetCasts = this.lookupByTargetType(target);
        for (ImplicitCastData cast : targetCasts) {
            if (!ElementUtils.isSubtype(this.boxType(source), this.boxType(cast.getSourceType()))) continue;
            return true;
        }
        return ElementUtils.isSubtype(this.boxType(source), this.boxType(target));
    }

    public TypeMirror boxType(TypeMirror type) {
        return ElementUtils.boxType(this.getContext(), type);
    }

    public boolean hasType(TypeMirror type) {
        if (this.legacyTypeIds == null) {
            this.legacyTypeIds = new HashSet<String>();
            for (TypeMirror legacyType : this.legacyTypes) {
                this.legacyTypeIds.add(ElementUtils.getTypeSimpleId(legacyType));
            }
        }
        return this.legacyTypeIds.contains(ElementUtils.getTypeSimpleId(type));
    }
}

