/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.TypeCastData;
import com.oracle.truffle.dsl.processor.model.TypeCheckData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public class TypeSystemCodeGenerator
extends CodeTypeElementFactory<TypeSystemData> {
    private static final String LOCAL_VALUE = "value";

    public static CodeTree implicitCastFlat(TypeSystemData typeSystem, TypeMirror type, CodeTree value, CodeTree state) {
        return TypeSystemCodeGenerator.callImplictMethodFlat(typeSystem, type, TypeSystemCodeGenerator.asImplicitTypeMethodName(typeSystem, type), value, state);
    }

    public static CodeTree implicitCheckFlat(TypeSystemData typeSystem, TypeMirror type, CodeTree value, CodeTree state) {
        return TypeSystemCodeGenerator.callImplictMethodFlat(typeSystem, type, TypeSystemCodeGenerator.isImplicitTypeMethodName(typeSystem, type), value, state);
    }

    public static CodeTree implicitSpecializeFlat(TypeSystemData typeSystem, TypeMirror type, CodeTree value) {
        return TypeSystemCodeGenerator.callImplictMethodFlat(typeSystem, type, TypeSystemCodeGenerator.specializeImplicitTypeMethodName(typeSystem, type), value, null);
    }

    private static CodeTree callImplictMethodFlat(TypeSystemData typeSystem, TypeMirror type, String methodName, CodeTree value, CodeTree state) {
        if (ElementUtils.isObject(type)) {
            return value;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startStaticCall(TypeSystemCodeGenerator.createTypeSystemGen(typeSystem), methodName);
        if (state != null) {
            builder.tree(state);
        }
        builder.tree(value);
        builder.end();
        return builder.build();
    }

    public static CodeTree implicitExpectFlat(TypeSystemData typeSystem, TypeMirror type, CodeTree value, CodeTree state) {
        return TypeSystemCodeGenerator.callImplictMethodFlat(typeSystem, type, TypeSystemCodeGenerator.expectImplicitTypeMethodName(typeSystem, type), value, state);
    }

    public static CodeTree cast(TypeSystemData typeSystem, TypeMirror type, String content) {
        return TypeSystemCodeGenerator.cast(typeSystem, type, CodeTreeBuilder.singleString(content));
    }

    public static CodeTree cast(TypeSystemData typeSystem, TypeMirror type, CodeTree content) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        TypeCastData cast = typeSystem.getCast(type);
        if (cast == null) {
            builder.cast(ElementUtils.fillInGenericWildcards(type), content);
        } else {
            builder.startStaticCall(typeSystem.getTemplateType().asType(), cast.getMethodName()).tree(content).end();
        }
        return builder.build();
    }

    public static CodeTree expect(TypeSystemData typeSystem, TypeMirror type, CodeTree content) {
        if (ElementUtils.isObject(type) || ElementUtils.isVoid(type)) {
            return content;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (typeSystem.hasType(type)) {
            builder.startStaticCall(TypeSystemCodeGenerator.createTypeSystemGen(typeSystem), TypeSystemCodeGenerator.expectTypeMethodName(typeSystem, type)).tree(content).end();
        } else {
            builder.startCall(TypeSystemCodeGenerator.expectTypeMethodName(typeSystem, type)).tree(content).end();
        }
        return builder.build();
    }

    public static CodeExecutableElement createExpectMethod(Modifier visibility, TypeSystemData typeSystem, TypeMirror sourceTypeOriginal, TypeMirror expectedTypeOriginal) {
        TypeMirror expectedType = ElementUtils.fillInGenericWildcards(expectedTypeOriginal);
        TypeMirror sourceType = ElementUtils.fillInGenericWildcards(sourceTypeOriginal);
        if (ElementUtils.isObject(expectedType) || ElementUtils.isVoid(expectedType)) {
            return null;
        }
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.STATIC), expectedType, TypeSystemCodeGenerator.expectTypeMethodName(typeSystem, expectedType), new CodeVariableElement[0]);
        method.setVisibility(visibility);
        method.addParameter(new CodeVariableElement(sourceType, LOCAL_VALUE));
        method.addThrownType(typeSystem.getContext().getTypes().UnexpectedResultException);
        CodeTreeBuilder body = method.createBuilder();
        body.startIf().tree(TypeSystemCodeGenerator.check(typeSystem, expectedType, LOCAL_VALUE)).end().startBlock();
        body.startReturn().tree(TypeSystemCodeGenerator.cast(typeSystem, expectedType, LOCAL_VALUE)).end();
        body.end();
        body.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        body.startThrow().startNew(typeSystem.getContext().getTypes().UnexpectedResultException).string(LOCAL_VALUE).end().end();
        return method;
    }

    private static CodeTypeMirror createTypeSystemGen(TypeSystemData typeSystem) {
        return new GeneratedTypeMirror(ElementUtils.getPackageName(typeSystem.getTemplateType()), TypeSystemCodeGenerator.typeName(typeSystem));
    }

    private static CodeTree check(TypeSystemData typeSystem, TypeMirror type, String content) {
        return TypeSystemCodeGenerator.check(typeSystem, type, CodeTreeBuilder.singleString(content));
    }

    static CodeTree check(TypeSystemData typeSystem, TypeMirror type, CodeTree content) {
        if (ElementUtils.isObject(type)) {
            return content;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        TypeCheckData check = typeSystem.getCheck(type);
        if (check == null) {
            builder.instanceOf(content, ElementUtils.boxType(typeSystem.getContext(), type));
        } else {
            builder.startStaticCall(typeSystem.getTemplateType().asType(), check.getMethodName()).tree(content).end();
        }
        return builder.build();
    }

    private static String isTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "is" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String getTypeSimpleId(TypeSystemData typeSystem, TypeMirror type) {
        return ElementUtils.getTypeSimpleId(typeSystem.boxType(type));
    }

    private static String isImplicitTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "isImplicit" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String asTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "as" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String asImplicitTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "asImplicit" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String specializeImplicitTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "specializeImplicit" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String expectImplicitTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "expectImplicit" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    private static String expectTypeMethodName(TypeSystemData typeSystem, TypeMirror type) {
        return "expect" + TypeSystemCodeGenerator.getTypeSimpleId(typeSystem, type);
    }

    static String typeName(TypeSystemData typeSystem) {
        String name = ElementUtils.getSimpleName(typeSystem.getTemplateType());
        return name + "Gen";
    }

    @Override
    public List<CodeTypeElement> create(ProcessorContext context, AnnotationProcessor<?> processor, TypeSystemData typeSystem) {
        CodeTypeElement clazz = new TypeClassFactory(context, typeSystem).create();
        return Arrays.asList(clazz);
    }

    private static class TypeClassFactory {
        private final ProcessorContext context;
        private final TypeSystemData typeSystem;

        TypeClassFactory(ProcessorContext context, TypeSystemData typeSystem) {
            this.context = context;
            this.typeSystem = typeSystem;
        }

        public CodeTypeElement create() {
            String name = TypeSystemCodeGenerator.typeName(this.typeSystem);
            CodeTypeElement clazz = GeneratorUtils.createClass(this.typeSystem, null, ElementUtils.modifiers(Modifier.PUBLIC, Modifier.FINAL), name, this.typeSystem.getTemplateType().asType());
            clazz.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(Modifier.PROTECTED), clazz));
            for (TypeMirror type : this.typeSystem.getLegacyTypes()) {
                if (ElementUtils.isVoid(type) || ElementUtils.isObject(type)) continue;
                clazz.addOptional(this.createIsTypeMethod(type));
                clazz.addOptional(this.createAsTypeMethod(type));
                clazz.addOptional(this.createExpectTypeMethod(type, this.context.getType(Object.class)));
            }
            Collection<TypeMirror> lookupTargetTypes = this.typeSystem.lookupTargetTypes();
            for (TypeMirror type : lookupTargetTypes) {
                clazz.add(this.createExpectImplicitTypeMethodFlat(type));
                clazz.add(this.createIsImplicitTypeMethodFlat(type, true));
                clazz.add(this.createIsImplicitTypeMethodFlat(type, false));
                clazz.add(this.createAsImplicitTypeMethodFlat(type, true));
                clazz.add(this.createAsImplicitTypeMethodFlat(type, false));
                clazz.add(this.createSpecializeImplictTypeMethodFlat(type));
            }
            return clazz;
        }

        private CodeExecutableElement createSpecializeImplictTypeMethodFlat(TypeMirror type) {
            String name = TypeSystemCodeGenerator.specializeImplicitTypeMethodName(this.typeSystem, type);
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), this.context.getType(Integer.TYPE), name, new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            Collection<TypeMirror> sourceTypes = this.typeSystem.lookupSourceTypes(type);
            CodeTreeBuilder builder = method.createBuilder();
            boolean elseIf = false;
            int mask = 1;
            for (TypeMirror sourceType : sourceTypes) {
                elseIf = builder.startIf(elseIf);
                builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                builder.end().startBlock();
                builder.startReturn();
                builder.string("0b", Integer.toBinaryString(mask));
                builder.end();
                builder.end();
                mask <<= 1;
            }
            builder.startElseBlock();
            builder.startReturn().string("0").end();
            builder.end();
            return method;
        }

        private CodeExecutableElement createExpectImplicitTypeMethodFlat(TypeMirror type) {
            String name = TypeSystemCodeGenerator.expectImplicitTypeMethodName(this.typeSystem, type);
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), type, name, new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "state"));
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            method.getThrownTypes().add(this.context.getTypes().UnexpectedResultException);
            Collection<TypeMirror> sourceTypes = this.typeSystem.lookupSourceTypes(type);
            CodeTreeBuilder builder = method.createBuilder();
            boolean elseIf = false;
            int mask = 1;
            for (TypeMirror sourceType : sourceTypes) {
                elseIf = builder.startIf(elseIf);
                builder.string("(state & 0b").string(Integer.toBinaryString(mask)).string(") != 0 && ");
                builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                builder.end().startBlock();
                builder.startReturn();
                ImplicitCastData cast = this.typeSystem.lookupCast(sourceType, type);
                if (cast != null) {
                    builder.startCall(cast.getMethodName());
                }
                builder.tree(TypeSystemCodeGenerator.cast(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE)).end();
                if (cast != null) {
                    builder.end();
                }
                builder.end();
                builder.end();
                mask <<= 1;
            }
            builder.startElseBlock();
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.startThrow().startNew(this.context.getTypes().UnexpectedResultException).string(TypeSystemCodeGenerator.LOCAL_VALUE).end().end();
            builder.end();
            return method;
        }

        private CodeExecutableElement createAsImplicitTypeMethodFlat(TypeMirror type, boolean cachedVersion) {
            String name = TypeSystemCodeGenerator.asImplicitTypeMethodName(this.typeSystem, type);
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), type, name, new CodeVariableElement[0]);
            if (cachedVersion) {
                method.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "state"));
            }
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            Collection<TypeMirror> sourceTypes = this.typeSystem.lookupSourceTypes(type);
            CodeTreeBuilder builder = method.createBuilder();
            TruffleTypes types = this.context.getTypes();
            if (cachedVersion) {
                builder.startIf().startStaticCall(types.HostCompilerDirectives, "inInterpreterFastPath").end().end().startBlock();
                builder.startReturn().startCall(name).string(TypeSystemCodeGenerator.LOCAL_VALUE).end().end();
                builder.end();
            }
            boolean elseIf = false;
            int mask = 1;
            for (TypeMirror sourceType : sourceTypes) {
                elseIf = builder.startIf(elseIf);
                if (cachedVersion) {
                    builder.string("(state & 0b").string(Integer.toBinaryString(mask)).string(") != 0 && ");
                    builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                } else {
                    builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                }
                builder.end().startBlock();
                builder.startReturn();
                ImplicitCastData cast = this.typeSystem.lookupCast(sourceType, type);
                if (cast != null) {
                    builder.startCall(cast.getMethodName());
                }
                builder.tree(TypeSystemCodeGenerator.cast(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE)).end();
                if (cast != null) {
                    builder.end();
                }
                builder.end();
                builder.end();
                mask <<= 1;
            }
            builder.startElseBlock();
            if (cachedVersion) {
                builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            }
            builder.startThrow().startNew(this.context.getType(IllegalArgumentException.class)).doubleQuote("Illegal implicit source type.").end().end();
            builder.end();
            return method;
        }

        private CodeExecutableElement createIsImplicitTypeMethodFlat(TypeMirror type, boolean cachedVersion) {
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), this.context.getType(Boolean.TYPE), TypeSystemCodeGenerator.isImplicitTypeMethodName(this.typeSystem, type), new CodeVariableElement[0]);
            if (cachedVersion) {
                method.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "state"));
            }
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            CodeTreeBuilder builder = method.createBuilder();
            ArrayList<TypeMirror> sourceTypes = new ArrayList<TypeMirror>(this.typeSystem.lookupSourceTypes(type));
            builder.startReturn();
            String sep = "";
            int mask = 1;
            for (TypeMirror sourceType : sourceTypes) {
                builder.string(sep);
                if (cachedVersion) {
                    builder.string("((state & 0b").string(Integer.toBinaryString(mask)).string(") != 0 && ");
                    builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                    builder.string(")");
                } else {
                    builder.tree(TypeSystemCodeGenerator.check(this.typeSystem, sourceType, TypeSystemCodeGenerator.LOCAL_VALUE));
                }
                if (sourceTypes.lastIndexOf(sourceType) != sourceTypes.size() - 1) {
                    builder.newLine();
                }
                if (sep.equals("")) {
                    builder.startIndention();
                }
                sep = " || ";
                mask <<= 1;
            }
            builder.end();
            builder.end();
            return method;
        }

        private CodeExecutableElement createIsTypeMethod(TypeMirror type) {
            if (this.typeSystem.getCheck(type) != null) {
                return null;
            }
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), this.context.getType(Boolean.TYPE), TypeSystemCodeGenerator.isTypeMethodName(this.typeSystem, type), new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            CodeTreeBuilder body = method.createBuilder();
            body.startReturn().tree(TypeSystemCodeGenerator.check(this.typeSystem, type, TypeSystemCodeGenerator.LOCAL_VALUE)).end();
            return method;
        }

        private CodeExecutableElement createAsTypeMethod(TypeMirror type) {
            if (this.typeSystem.getCast(type) != null) {
                return null;
            }
            CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), type, TypeSystemCodeGenerator.asTypeMethodName(this.typeSystem, type), new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(this.context.getType(Object.class), TypeSystemCodeGenerator.LOCAL_VALUE));
            CodeTreeBuilder body = method.createBuilder();
            String assertMessage = TypeSystemCodeGenerator.typeName(this.typeSystem) + "." + TypeSystemCodeGenerator.asTypeMethodName(this.typeSystem, type) + ": " + ElementUtils.getSimpleName(type) + " expected";
            body.startAssert().tree(TypeSystemCodeGenerator.check(this.typeSystem, type, TypeSystemCodeGenerator.LOCAL_VALUE)).string(" : ").doubleQuote(assertMessage).end();
            body.startReturn().tree(TypeSystemCodeGenerator.cast(this.typeSystem, type, TypeSystemCodeGenerator.LOCAL_VALUE)).end();
            return method;
        }

        private CodeExecutableElement createExpectTypeMethod(TypeMirror expectedType, TypeMirror sourceType) {
            return TypeSystemCodeGenerator.createExpectMethod(Modifier.PUBLIC, this.typeSystem, sourceType, expectedType);
        }
    }
}

