/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public interface PrettyPrintable {
    default public List<String> pp() {
        PrettyPrinter printer = new PrettyPrinter();
        this.pp(printer);
        return printer.lines;
    }

    public void pp(PrettyPrinter var1);

    public static final class PrettyPrinter {
        private String nextIndent = "";
        private String indent = "";
        private final List<String> lines = new ArrayList<String>();

        public void print(String text) {
            this.lines.add(this.nextIndent + text.replace("\n", "\n" + this.indent));
            this.nextIndent = this.indent;
        }

        public void print(String format, Object ... args) {
            this.print(String.format(format, args));
        }

        public void print(Object obj) {
            if (obj instanceof PrettyPrintable) {
                ((PrettyPrintable)obj).pp(this);
            } else if (obj instanceof Collection) {
                for (Object elem : (Collection)obj) {
                    this.nextIndent = this.nextIndent + "  - ";
                    String old = this.indent;
                    this.indent = this.indent + "    ";
                    this.print(elem);
                    this.indent = old;
                }
            } else {
                this.print(Objects.toString(obj));
            }
        }

        public void field(String fieldName, Object fieldValue) {
            if (fieldValue instanceof PrettyPrintable) {
                PrettyPrintable field = (PrettyPrintable)fieldValue;
                this.print("%s:", fieldName);
                String old = this.indent;
                this.indent = this.indent + "  ";
                field.pp(this);
                this.indent = old;
            } else if (fieldValue instanceof Collection) {
                Collection collection = (Collection)fieldValue;
                this.print("%s:", fieldName);
                for (Object obj : collection) {
                    this.nextIndent = this.nextIndent + "  - ";
                    String old = this.indent;
                    this.indent = this.indent + "    ";
                    this.print(obj);
                    this.nextIndent = this.indent = old;
                }
            } else {
                this.print("%s: %s", fieldName, fieldValue);
            }
        }
    }
}

