/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.SuppressFBWarnings;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeDSLNodeGeneratorPlugs;
import com.oracle.truffle.dsl.processor.bytecode.generator.ElementHelpers;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ConstantOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.DynamicOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ShortCircuitInstructionModel;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.generator.NodeConstants;
import com.oracle.truffle.dsl.processor.generator.StaticConstants;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeParameterElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class BytecodeRootNodeElement
extends CodeTypeElement {
    private static final String USER_LOCALS_START_INDEX = "USER_LOCALS_START_INDEX";
    private static final String BCI_INDEX = "BCI_INDEX";
    private static final String COROUTINE_FRAME_INDEX = "COROUTINE_FRAME_INDEX";
    private static final String EMPTY_INT_ARRAY = "EMPTY_INT_ARRAY";
    private static final int MAX_TAGS = 32;
    private static final int TAG_OFFSET = 32;
    private static final int MAX_INSTRUMENTATIONS = 31;
    private static final int INSTRUMENTATION_OFFSET = 1;
    private static final int ESTIMATED_CUSTOM_INSTRUCTION_SIZE = 34;
    private static final int ESTIMATED_EXTRACTED_INSTRUCTION_SIZE = 18;
    private static final int GROUP_DISPATCH_SIZE = 20;
    private static final int ESTIMATED_BYTECODE_FOOTPRINT = 2000;
    private static final int JAVA_JIT_BYTECODE_LIMIT = 8000;
    private final ProcessorContext context = ProcessorContext.getInstance();
    private final TruffleTypes types = this.context.getTypes();
    private final BytecodeDSLModel model;
    private final BuilderElement builder = new BuilderElement();
    private final TypeMirror bytecodeBuilderType;
    private final TypeMirror parserType;
    private final CodeVariableElement emptyObjectArray;
    private final CodeVariableElement fastAccess;
    private final CodeVariableElement byteArraySupport;
    private final CodeVariableElement frameExtensions;
    private final ContinuationRootNodeImplElement continuationRootNodeImpl;
    private final ContinuationLocationElement continuationLocation;
    private final BytecodeRootNodesImplElement bytecodeRootNodesImpl = new BytecodeRootNodesImplElement();
    private final InstructionConstantsElement instructionsElement = new InstructionConstantsElement();
    private final OperationConstantsElement operationsElement = new OperationConstantsElement();
    private final FrameTagConstantsElement frameTagsElement;
    private final CodeTypeElement loopCounter = new CodeTypeElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementKind.CLASS, null, "LoopCounter");
    private CodeTypeElement configEncoder;
    private AbstractBytecodeNodeElement abstractBytecodeNode;
    private TagNodeElement tagNode;
    private TagRootNodeElement tagRootNode;
    private InstructionImplElement instructionImpl;
    private BuilderElement.SerializationRootNodeElement serializationRootNode;
    private Map<TypeMirror, CodeExecutableElement> expectMethods = new HashMap<TypeMirror, CodeExecutableElement>();
    private static final String RETURN_BCI = "0xFFFFFFFF";

    BytecodeRootNodeElement(BytecodeDSLModel model) {
        super(Set.of(Modifier.PUBLIC, Modifier.FINAL), ElementKind.CLASS, ElementUtils.findPackageElement(model.getTemplateType()), model.getName());
        CodeTypeElement initialBytecodeNode;
        if (model.hasErrors()) {
            throw new IllegalArgumentException("Models with errors are not supported.");
        }
        this.model = model;
        this.bytecodeBuilderType = this.builder.asType();
        this.parserType = ElementHelpers.generic((TypeMirror)this.types.BytecodeParser, this.bytecodeBuilderType);
        this.setSuperClass(model.getTemplateType().asType());
        ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), int[].class, EMPTY_INT_ARRAY, "new int[0]");
        this.emptyObjectArray = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Object[].class, "EMPTY_ARRAY", "new Object[0]");
        this.fastAccess = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.types.BytecodeDSLAccess, "ACCESS");
        this.fastAccess.setInit(this.createFastAccessFieldInitializer(model.allowUnsafe));
        this.byteArraySupport = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.types.ByteArraySupport, "BYTES");
        this.byteArraySupport.createInitBuilder().startCall("ACCESS.getByteArraySupport").end();
        this.frameExtensions = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.types.FrameExtensions, "FRAMES");
        this.frameExtensions.createInitBuilder().startCall("ACCESS.getFrameExtensions").end();
        this.createDocBuilder().startDoc().lines(model.pp()).end();
        GeneratorUtils.mergeSuppressWarnings(this, "static-method");
        if (model.enableYield) {
            this.continuationRootNodeImpl = new ContinuationRootNodeImplElement();
            this.continuationLocation = new ContinuationLocationElement();
        } else {
            this.continuationRootNodeImpl = null;
            this.continuationLocation = null;
        }
        this.addAll(this.createFrameLayoutConstants());
        this.frameTagsElement = model.usesBoxingElimination() ? new FrameTagConstantsElement() : null;
        this.instructionImpl = this.add(new InstructionImplElement());
        if (model.enableTagInstrumentation) {
            this.tagNode = this.add(new TagNodeElement());
            this.tagRootNode = this.add(new TagRootNodeElement());
        }
        this.abstractBytecodeNode = this.add(new AbstractBytecodeNodeElement());
        if (model.enableTagInstrumentation) {
            this.tagNode.lazyInit();
        }
        CodeVariableElement bytecodeNode = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.VOLATILE), this.abstractBytecodeNode.asType(), "bytecode");
        this.add(this.child(bytecodeNode));
        this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), this.bytecodeRootNodesImpl.asType(), "nodes"));
        BytecodeRootNodeElement.addJavadoc((CodeElement)this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), this.type(Integer.TYPE), "maxLocals")), "The number of frame slots required for locals.");
        if (model.usesBoxingElimination()) {
            BytecodeRootNodeElement.addJavadoc((CodeElement)this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), this.type(Integer.TYPE), "numLocals")), "The total number of locals created.");
        }
        this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), this.type(Integer.TYPE), "buildIndex"));
        this.add(this.createBytecodeUpdater());
        CodeTreeBuilder frameType = this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementHelpers.generic(Class.class, (TypeMirror)new CodeTypeMirror.WildcardTypeMirror(this.types.VirtualFrame, null)), "FRAME_TYPE")).createInitBuilder();
        frameType.startStaticCall(this.types.Truffle, "getRuntime").end().startCall(".createVirtualFrame");
        frameType.string(this.emptyObjectArray.getSimpleName().toString());
        frameType.startGroup().startStaticCall(this.types.FrameDescriptor, "newBuilder").end().startCall(".build").end().end();
        frameType.end();
        frameType.string(".getClass()");
        BytecodeNodeElement cachedBytecodeNode = this.add(new BytecodeNodeElement(InterpreterTier.CACHED));
        this.abstractBytecodeNode.getPermittedSubclasses().add(cachedBytecodeNode.asType());
        if (model.enableUncachedInterpreter) {
            CodeTypeElement uncachedBytecodeNode = this.add(new BytecodeNodeElement(InterpreterTier.UNCACHED));
            this.abstractBytecodeNode.getPermittedSubclasses().add(uncachedBytecodeNode.asType());
            initialBytecodeNode = uncachedBytecodeNode;
        } else {
            CodeTypeElement uninitializedBytecodeNode = this.add(new BytecodeNodeElement(InterpreterTier.UNINITIALIZED));
            this.abstractBytecodeNode.getPermittedSubclasses().add(uninitializedBytecodeNode.asType());
            initialBytecodeNode = uninitializedBytecodeNode;
        }
        this.builder.lazyInit();
        this.add(this.builder);
        this.instructionImpl.lazyInit();
        this.configEncoder = this.add(this.createBytecodeConfigEncoderClass());
        CodeExecutableElement newConfigBuilder = this.add(new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), this.types.BytecodeConfig_Builder, "newConfigBuilder", new CodeVariableElement[0]));
        newConfigBuilder.createBuilder().startReturn().startStaticCall(this.types.BytecodeConfig, "newBuilder").staticReference(this.configEncoder.asType(), "INSTANCE").end().end();
        this.bytecodeRootNodesImpl.lazyInit();
        this.add(this.bytecodeRootNodesImpl);
        this.instructionsElement.lazyInit();
        this.add(this.instructionsElement);
        this.operationsElement.lazyInit();
        this.add(this.operationsElement);
        if (model.usesBoxingElimination()) {
            this.add(this.frameTagsElement);
        }
        this.add(new ExceptionHandlerImplElement());
        this.add(new ExceptionHandlerListElement());
        this.add(new SourceInformationImplElement());
        this.add(new SourceInformationListElement());
        this.add(new SourceInformationTreeImplElement());
        this.add(new LocalVariableImplElement());
        this.add(new LocalVariableListElement());
        if (model.enableYield) {
            this.continuationRootNodeImpl.lazyInit();
            this.add(this.continuationRootNodeImpl);
            this.add(this.continuationLocation);
        }
        int numHandlerKinds = 0;
        this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.type(Integer.TYPE), "HANDLER_CUSTOM")).createInitBuilder().string(String.valueOf(numHandlerKinds++));
        if (model.epilogExceptional != null) {
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.type(Integer.TYPE), "HANDLER_EPILOG_EXCEPTIONAL")).createInitBuilder().string(String.valueOf(numHandlerKinds++));
        }
        if (model.enableTagInstrumentation) {
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.type(Integer.TYPE), "HANDLER_TAG_EXCEPTIONAL")).createInitBuilder().string(String.valueOf(numHandlerKinds++));
        }
        if (model.defaultLocalValueExpression != null) {
            CodeVariableElement var = this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.type(Object.class), "DEFAULT_LOCAL_VALUE"));
            var.createInitBuilder().tree(DSLExpressionGenerator.write(model.defaultLocalValueExpression, null, Map.of()));
        }
        this.add(this.createConstructor(initialBytecodeNode));
        this.add(this.createExecute());
        this.add(this.createContinueAt());
        this.add(this.createTransitionToCached());
        this.add(this.createUpdateBytecode());
        this.add(this.createIsInstrumentable());
        this.addOptional(this.createPrepareForInstrumentation());
        this.addOptional(this.createPrepareForCompilation());
        this.add(this.createEncodeTags());
        if (model.enableTagInstrumentation) {
            this.add(this.createFindInstrumentableCallNode());
        }
        this.add(this.createLoopCounter());
        this.add(this.createCreate());
        if (model.enableSerialization) {
            this.add(this.createSerialize());
            this.add(this.createDoSerialize());
            this.add(this.createDeserialize());
        }
        if (!model.getProvidedTags().isEmpty()) {
            CodeVariableElement classToTag = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementHelpers.generic(ConcurrentHashMap.class, this.type(Integer.class), ElementHelpers.arrayOf(ElementHelpers.generic((TypeMirror)this.context.getDeclaredType(Class.class), ElementHelpers.wildcard(this.types.Tag, null)))), "TAG_MASK_TO_TAGS");
            classToTag.createInitBuilder().string("new ConcurrentHashMap<>()");
            this.add(classToTag);
            CodeExecutableElement classToTagMethod = this.createMapTagMaskToTagsArray();
            this.add(classToTagMethod);
            CodeExecutableElement initializeTagIndexToClass = this.add(this.createInitializeTagIndexToClass());
            CodeVariableElement tagToClass = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementHelpers.generic((TypeMirror)this.context.getDeclaredType(ClassValue.class), this.type(Integer.class)), "CLASS_TO_TAG_MASK");
            tagToClass.createInitBuilder().startStaticCall(initializeTagIndexToClass).end();
            this.add(tagToClass);
        }
        this.add(this.createSneakyThrow());
        this.add(this.createAssertionFailed());
        this.addOptional(this.createIsCloningAllowed());
        this.addOptional(this.createCloneUninitializedSupported());
        this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.generic((TypeMirror)this.types.BytecodeSupport_CloneReferenceList, this.asType()), "clones"));
        this.addOptional(this.createCloneUninitialized());
        this.add(this.createFindBytecodeIndex());
        this.add(this.createIsCaptureFramesForTrace());
        this.add(this.createReadVariadic());
        this.add(this.createMergeVariadic());
        this.add(this.createGetBytecodeNode());
        this.add(this.createGetBytecodeNodeImpl());
        this.add(this.createGetBytecodeRootNode());
        this.add(this.createGetRootNodes());
        this.addOptional(this.createCountTowardsStackTraceLimit());
        this.add(this.createGetSourceSection());
        CodeExecutableElement translateStackTraceElement = this.addOptional(this.createTranslateStackTraceElement());
        if (translateStackTraceElement != null) {
            this.abstractBytecodeNode.add(this.createCreateStackTraceElement());
        }
        this.add(this.createComputeSize());
        StaticConstants consts = new StaticConstants();
        for (InstructionModel instr : model.getInstructions()) {
            if (instr.nodeData == null || instr.quickeningBase != null) continue;
            this.add(this.createCachedDataClass(instr, consts));
        }
        if (model.epilogExceptional != null) {
            this.add(this.createCachedDataClass(model.epilogExceptional.operation.instruction, consts));
        }
        consts.addElementsTo(this);
        if (model.usesBoxingElimination()) {
            for (TypeMirror boxingEliminatedType : model.boxingEliminatedTypes) {
                this.add(this.createApplyQuickening(boxingEliminatedType));
                this.add(this.createIsQuickening(boxingEliminatedType));
            }
            this.add(this.createUndoQuickening());
        }
        if (model.isBytecodeUpdatable()) {
            this.abstractBytecodeNode.add(new CodeVariableElement(Set.of(Modifier.VOLATILE), ElementHelpers.arrayOf(this.type(Byte.TYPE)), "oldBytecodes"));
        }
        if (model.enableSerialization) {
            this.addMethodStubsToSerializationRootNode();
        }
    }

    private CodeExecutableElement createConstructor(CodeTypeElement initialBytecodeNode) {
        CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
        ctor.addParameter(new CodeVariableElement(this.model.languageClass, "language"));
        ctor.addParameter(new CodeVariableElement(this.types.FrameDescriptor_Builder, "builder"));
        ctor.addParameter(new CodeVariableElement(this.bytecodeRootNodesImpl.asType(), "nodes"));
        ctor.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "maxLocals"));
        if (this.model.usesBoxingElimination()) {
            ctor.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "numLocals"));
        }
        ctor.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "buildIndex"));
        for (VariableElement var : ElementFilter.fieldsIn(this.abstractBytecodeNode.getEnclosedElements())) {
            ctor.addParameter(new CodeVariableElement(var.asType(), var.getSimpleName().toString()));
        }
        CodeTreeBuilder b = ctor.getBuilder();
        b.startStatement().startCall("super");
        b.string("language");
        if (this.model.fdBuilderConstructor != null) {
            b.string("builder");
        } else {
            b.string("builder.build()");
        }
        b.end(2);
        b.statement("this.nodes = nodes");
        b.statement("this.maxLocals = maxLocals");
        if (this.model.usesBoxingElimination()) {
            b.statement("this.numLocals = numLocals");
        }
        b.statement("this.buildIndex = buildIndex");
        b.startStatement();
        b.string("this.bytecode = ");
        b.startCall("insert");
        b.startNew(initialBytecodeNode.asType());
        for (VariableElement var : ElementFilter.fieldsIn(this.abstractBytecodeNode.getEnclosedElements())) {
            b.string(var.getSimpleName().toString());
        }
        b.end();
        b.end();
        b.end();
        return ctor;
    }

    private CodeExecutableElement createExecute() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "execute", new String[]{"frame"});
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().startCall("continueAt");
        b.string("bytecode");
        b.string("0");
        b.string("maxLocals");
        b.string("frame");
        if (this.model.enableYield) {
            b.string("frame");
            b.string("null");
        }
        b.end(2);
        return ex;
    }

    private CodeTypeElement createCachedDataClass(InstructionModel instr, StaticConstants consts) {
        NodeConstants nodeConsts = new NodeConstants();
        BytecodeDSLNodeGeneratorPlugs plugs = new BytecodeDSLNodeGeneratorPlugs(this, instr);
        FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, FlatNodeGenFactory.GeneratorMode.DEFAULT, instr.nodeData, consts, nodeConsts, plugs);
        String className = BytecodeRootNodeElement.cachedDataClassName(instr);
        CodeTypeElement el = new CodeTypeElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, className);
        el.setSuperClass(this.types.Node);
        factory.create(el);
        ArrayList<ExecutableElement> cachedExecuteMethods = new ArrayList<ExecutableElement>();
        cachedExecuteMethods.add(this.createCachedExecute(plugs, factory, el, instr));
        for (InstructionModel quickening : instr.getFlattenedQuickenedInstructions()) {
            cachedExecuteMethods.add(this.createCachedExecute(plugs, factory, el, quickening));
        }
        this.processCachedNode(el);
        el.getEnclosedElements().addAll(0, cachedExecuteMethods);
        CodeExecutableElement quicken = plugs.getQuickenMethod();
        if (quicken != null) {
            el.getEnclosedElements().add(quicken);
        }
        nodeConsts.addToClass(el);
        if (instr.canUseNodeSingleton()) {
            el.addAnnotationMirror(new CodeAnnotationMirror(this.types.DenyReplace));
            CodeVariableElement singleton = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), el.asType(), "SINGLETON");
            singleton.createInitBuilder().startNew(className).end();
            el.add(singleton);
            CodeExecutableElement isAdoptable = GeneratorUtils.override(this.types.Node, "isAdoptable");
            isAdoptable.createBuilder().startReturn().string("false").end();
            el.add(isAdoptable);
        }
        return el;
    }

    private String encodeState(String bci, String sp, String useContinuationFrame) {
        Object result = "";
        if (useContinuationFrame != null) {
            if (!this.model.enableYield) {
                throw new AssertionError();
            }
            result = (String)result + String.format("((%s ? 1L : 0L) << 48) | ", useContinuationFrame);
        }
        if (sp != null) {
            result = (String)result + String.format("((%s & 0xFFFFL) << 32) | ", sp);
        }
        result = (String)result + String.format("(%s & 0xFFFFFFFFL)", bci);
        return result;
    }

    private String encodeState(String bci, String sp) {
        return this.encodeState(bci, sp, null);
    }

    private static String encodeReturnState(String sp) {
        return String.format("((%s & 0xFFFFL) << 32) | %sL", sp, RETURN_BCI);
    }

    private static String encodeNewBci(String bci, String state) {
        return String.format("(%s & 0xFFFF00000000L) | (%s & 0xFFFFFFFFL)", state, bci);
    }

    private static String decodeBci(String state) {
        return String.format("(int) %s", state);
    }

    private static String decodeSp(String state) {
        return String.format("(short) (%s >>> 32)", state);
    }

    private String decodeUseContinuationFrame(String state) {
        if (!this.model.enableYield) {
            throw new AssertionError();
        }
        return String.format("(%s & (1L << 48)) != 0", state);
    }

    private String clearUseContinuationFrame(String target) {
        if (!this.model.enableYield) {
            throw new AssertionError();
        }
        return String.format("(%s & ~(1L << 48))", target);
    }

    private CodeExecutableElement createContinueAt() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.type(Object.class), "continueAt", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.abstractBytecodeNode.asType(), "bc"));
        ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "bci"));
        ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "sp"));
        ex.addParameter(new CodeVariableElement(this.types.VirtualFrame, "frame"));
        if (this.model.enableYield) {
            ex.addParameter(new CodeVariableElement(this.types.VirtualFrame, "localFrame"));
            ex.addParameter(new CodeVariableElement(this.continuationRootNodeImpl.asType(), "continuationRootNode"));
        }
        CodeTreeBuilder b = ex.createBuilder();
        if (this.model.overridesBytecodeDebugListenerMethod("beforeRootExecute")) {
            b.startStatement();
            b.startCall("beforeRootExecute");
            this.emitParseInstruction(b, "bc", "bci", CodeTreeBuilder.singleString("bc.readValidBytecode(bc.bytecodes, bci)"));
            b.end();
            b.end();
        }
        b.statement("long state = ", this.encodeState("bci", "sp"));
        b.startWhile().string("true").end().startBlock();
        b.startAssign("state");
        b.startCall("bc", "continueAt");
        b.string("this");
        b.string("frame");
        if (this.model.enableYield) {
            b.string("localFrame");
        }
        b.string("state");
        b.end();
        b.end();
        b.startIf().string(BytecodeRootNodeElement.decodeBci("state"), " == ", RETURN_BCI).end().startBlock();
        b.statement("break");
        b.end().startElseBlock();
        b.lineComment("Bytecode or tier changed");
        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        if (this.model.isBytecodeUpdatable()) {
            b.declaration(this.abstractBytecodeNode.asType(), "oldBytecode", "bc");
            b.statement("bc = this.bytecode");
            b.startAssign("state").startCall("oldBytecode.transitionState");
            b.string("bc");
            b.string("state");
            if (this.model.enableYield) {
                b.string("continuationRootNode");
            }
            b.end(2);
        } else {
            b.statement("bc = this.bytecode");
        }
        b.end();
        b.end();
        String returnValue = BytecodeRootNodeElement.uncheckedGetFrameObject(BytecodeRootNodeElement.decodeSp("state"));
        b.startReturn().string(returnValue).end();
        GeneratorUtils.mergeSuppressWarnings(ex, "all");
        return ex;
    }

    private Element createIsCaptureFramesForTrace() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "isCaptureFramesForTrace", new String[]{"compiled"}, new TypeMirror[]{this.type(Boolean.TYPE)});
        CodeTreeBuilder b = ex.createBuilder();
        if (this.model.storeBciInFrame) {
            b.statement("return true");
        } else {
            b.statement("return !compiled");
        }
        return ex;
    }

    private Element createFindBytecodeIndex() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "findBytecodeIndex", new String[]{"node", "frame"});
        GeneratorUtils.mergeSuppressWarnings(ex, "hiding");
        CodeTreeBuilder b = ex.createBuilder();
        if (this.model.storeBciInFrame) {
            b.startIf().string("node == null").end().startBlock();
            b.statement("return -1");
            b.end();
            b.startAssert();
            b.startStaticCall(this.types.BytecodeNode, "get").string("node").end().instanceOf(this.abstractBytecodeNode.asType()).string(" : ").doubleQuote("invalid bytecode node passed");
            b.end();
            b.startReturn();
            b.startCall("frame.getInt").string(BCI_INDEX).end();
            b.end();
        } else {
            b.declaration(this.abstractBytecodeNode.asType(), "bytecode", "null");
            b.declaration((TypeMirror)this.types.Node, "prev", "node");
            b.declaration((TypeMirror)this.types.Node, "current", "node");
            b.startWhile().string("current != null").end().startBlock();
            b.startIf().string("current ").instanceOf(this.abstractBytecodeNode.asType()).string(" b").end().startBlock();
            b.statement("bytecode = b");
            b.statement("break");
            b.end();
            b.statement("prev = current");
            b.statement("current = prev.getParent()");
            b.end();
            b.startIf().string("bytecode == null").end().startBlock();
            b.statement("return -1");
            b.end();
            b.statement("return bytecode.findBytecodeIndex(frame, prev)");
        }
        return ex;
    }

    private CodeExecutableElement createFindInstrumentableCallNode() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "findInstrumentableCallNode", new String[]{"callNode", "frame", "bytecodeIndex"});
        ex.getModifiers().remove((Object)Modifier.ABSTRACT);
        ex.getModifiers().add(Modifier.FINAL);
        CodeTreeBuilder b = ex.createBuilder();
        b.startDeclaration(this.types.BytecodeNode, "bc").startStaticCall(this.types.BytecodeNode, "get").string("callNode").end().end();
        b.startIf().string("bc == null || !(bc instanceof AbstractBytecodeNode bytecodeNode)").end().startBlock();
        b.startReturn().string("super.findInstrumentableCallNode(callNode, frame, bytecodeIndex)").end();
        b.end();
        b.statement("return bytecodeNode.findInstrumentableCallNode(bytecodeIndex)");
        return ex;
    }

    private CodeVariableElement createBytecodeUpdater() {
        DeclaredType updaterType = ElementHelpers.generic(this.type(AtomicReferenceFieldUpdater.class), this.asType(), this.abstractBytecodeNode.asType());
        CodeVariableElement bytecodeUpdater = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), updaterType, "BYTECODE_UPDATER");
        bytecodeUpdater.createInitBuilder().startStaticCall(this.type(AtomicReferenceFieldUpdater.class), "newUpdater").typeLiteral(this.asType()).typeLiteral(this.abstractBytecodeNode.asType()).doubleQuote("bytecode").end();
        return bytecodeUpdater;
    }

    private CodeExecutableElement createUndoQuickening() {
        CodeExecutableElement executable = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Short.TYPE), "undoQuickening", new CodeVariableElement(this.type(Short.TYPE), "$operand"));
        CodeTreeBuilder b = executable.createBuilder();
        b.startSwitch().string("$operand").end().startBlock();
        for (InstructionModel instruction : this.model.getInstructions()) {
            if (!instruction.isReturnTypeQuickening()) continue;
            b.startCase().tree(this.createInstructionConstant(instruction)).end();
            b.startCaseBlock();
            b.startReturn().tree(this.createInstructionConstant(instruction.quickeningBase)).end();
            b.end();
        }
        b.caseDefault();
        b.startCaseBlock();
        b.statement("return $operand");
        b.end();
        b.end();
        return executable;
    }

    private CodeExecutableElement createApplyQuickening(TypeMirror type) {
        CodeExecutableElement executable = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Short.TYPE), BytecodeRootNodeElement.createApplyQuickeningName(type), new CodeVariableElement(this.type(Short.TYPE), "$operand"));
        CodeTreeBuilder b = executable.createBuilder();
        b.startSwitch().string("$operand").end().startBlock();
        for (InstructionModel instruction : this.model.getInstructions()) {
            if (!instruction.isReturnTypeQuickening() || !ElementUtils.typeEquals(instruction.signature.returnType, type)) continue;
            b.startCase().tree(this.createInstructionConstant(instruction.quickeningBase)).end();
            b.startCase().tree(this.createInstructionConstant(instruction)).end();
            b.startCaseBlock();
            b.startReturn().tree(this.createInstructionConstant(instruction)).end();
            b.end();
        }
        b.caseDefault();
        b.startCaseBlock();
        b.statement("return -1");
        b.end();
        b.end();
        return executable;
    }

    private CodeExecutableElement createIsQuickening(TypeMirror type) {
        CodeExecutableElement executable = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Boolean.TYPE), BytecodeRootNodeElement.createIsQuickeningName(type), new CodeVariableElement(this.type(Short.TYPE), "operand"));
        CodeTreeBuilder b = executable.createBuilder();
        List<InstructionModel> returnQuickenings = this.model.getInstructions().stream().filter(i -> i.isReturnTypeQuickening() && ElementUtils.typeEquals(i.signature.returnType, type)).toList();
        if (returnQuickenings.isEmpty()) {
            b.returnFalse();
        } else {
            b.startSwitch().string("operand").end().startBlock();
            for (InstructionModel instruction : returnQuickenings) {
                b.startCase().tree(this.createInstructionConstant(instruction)).end();
            }
            b.startCaseBlock();
            b.returnTrue();
            b.end();
            b.caseDefault();
            b.startCaseBlock();
            b.returnFalse();
            b.end();
            b.end();
        }
        return executable;
    }

    private CodeExecutableElement createMapTagMaskToTagsArray() {
        DeclaredType tagClass = ElementHelpers.generic((TypeMirror)this.context.getDeclaredType(Class.class), ElementHelpers.wildcard(this.types.Tag, null));
        CodeExecutableElement classToTagMethod = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementHelpers.arrayOf(ElementHelpers.generic((TypeMirror)this.context.getDeclaredType(Class.class), ElementHelpers.wildcard(this.types.Tag, null))), "mapTagMaskToTagsArray", new CodeVariableElement[0]);
        classToTagMethod.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "tagMask"));
        GeneratorUtils.mergeSuppressWarnings(classToTagMethod, "unchecked", "rawtypes");
        CodeTreeBuilder b = classToTagMethod.createBuilder();
        b.startStatement().type(ElementHelpers.generic(ArrayList.class, (TypeMirror)tagClass)).string(" tags = ").startNew("ArrayList<>").end().end();
        int index = 0;
        for (TypeMirror tag : this.model.getProvidedTags()) {
            b.startIf().string("(tagMask & ").string(1 << index).string(") != 0").end().startBlock();
            b.startStatement().startCall("tags", "add").typeLiteral(tag).end().end();
            b.end();
            ++index;
        }
        b.statement("return tags.toArray(new Class[tags.size()])");
        return classToTagMethod;
    }

    private List<CodeVariableElement> createFrameLayoutConstants() {
        ArrayList<CodeVariableElement> result = new ArrayList<CodeVariableElement>();
        int reserved = 0;
        if (this.model.needsBciSlot()) {
            result.add(ElementHelpers.createInitializedVariable(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Integer.TYPE, BCI_INDEX, "" + reserved++));
        }
        if (this.model.enableYield) {
            result.add(ElementHelpers.createInitializedVariable(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Integer.TYPE, COROUTINE_FRAME_INDEX, "" + reserved++));
        }
        result.add(ElementHelpers.createInitializedVariable(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Integer.TYPE, USER_LOCALS_START_INDEX, "" + reserved));
        return result;
    }

    private CodeTree createFastAccessFieldInitializer(boolean allowUnsafe) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startStaticCall(this.types.BytecodeDSLAccess, "lookup").string("BytecodeRootNodesImpl.VISIBLE_TOKEN").string(Boolean.toString(allowUnsafe)).end();
        return b.build();
    }

    private CodeExecutableElement createIsCloningAllowed() {
        ExecutableElement executable = ElementUtils.findOverride(ElementUtils.findMethod(this.types.RootNode, "isCloningAllowed"), this.model.templateType);
        if (executable != null) {
            return null;
        }
        CodeExecutableElement ex = GeneratorUtils.override(this.types.RootNode, "isCloningAllowed");
        ex.createBuilder().returnTrue();
        return ex;
    }

    private CodeExecutableElement createCloneUninitializedSupported() {
        ExecutableElement executable = ElementUtils.findOverride(ElementUtils.findMethod(this.types.RootNode, "isCloneUninitializedSupported"), this.model.templateType);
        if (executable != null && executable.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        CodeExecutableElement ex = GeneratorUtils.override(this.types.RootNode, "isCloneUninitializedSupported");
        ex.createBuilder().returnTrue();
        return ex;
    }

    private CodeExecutableElement createCloneUninitialized() {
        ExecutableElement executable = ElementUtils.findOverride(ElementUtils.findMethod(this.types.RootNode, "cloneUninitialized"), this.model.templateType);
        if (executable != null && executable.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        CodeExecutableElement ex = GeneratorUtils.override(this.types.RootNode, "cloneUninitialized");
        CodeTreeBuilder b = ex.createBuilder();
        b.declaration(this.asType(), "clone");
        b.startSynchronized("nodes");
        b.startAssign("clone").cast(this.asType()).string("this.copy()").end();
        b.statement("clone.clones = null");
        b.statement("clone.bytecode = insert(this.bytecode.cloneUninitialized())");
        b.declaration((TypeMirror)ElementHelpers.generic((TypeMirror)this.types.BytecodeSupport_CloneReferenceList, this.asType()), "localClones", "this.clones");
        b.startIf().string("localClones == null").end().startBlock();
        b.startStatement().string("this.clones = localClones = ").startNew(ElementHelpers.generic((TypeMirror)this.types.BytecodeSupport_CloneReferenceList, this.asType())).end().end();
        b.end();
        b.statement("localClones.add(clone)");
        b.end();
        this.emitFence(b);
        b.startReturn().string("clone").end();
        return ex;
    }

    private CodeExecutableElement createTranslateStackTraceElement() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "translateStackTraceElement", new String[]{"stackTraceElement"});
        if (ex.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn();
        b.startStaticCall(this.abstractBytecodeNode.asType(), "createStackTraceElement");
        b.string("stackTraceElement");
        b.end();
        b.end();
        return ex;
    }

    private CodeExecutableElement createCreateStackTraceElement() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Object.class), "createStackTraceElement", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.types.TruffleStackTraceElement, "stackTraceElement"));
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn();
        b.startCall("createDefaultStackTraceElement");
        b.string("stackTraceElement");
        b.end();
        b.end();
        return ex;
    }

    private CodeExecutableElement createCountTowardsStackTraceLimit() {
        ExecutableElement executable = ElementUtils.findOverride(ElementUtils.findMethod(this.types.RootNode, "countsTowardsStackTraceLimit"), this.model.templateType);
        if (executable != null) {
            return null;
        }
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "countsTowardsStackTraceLimit");
        if (ex.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        ex.getModifiers().remove((Object)Modifier.ABSTRACT);
        ex.getModifiers().add(Modifier.FINAL);
        CodeTreeBuilder b = ex.createBuilder();
        b.returnTrue();
        return ex;
    }

    private CodeExecutableElement createGetSourceSection() {
        CodeExecutableElement ex = GeneratorUtils.override(this.types.Node, "getSourceSection");
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().string("bytecode.getSourceSection()").end();
        return ex;
    }

    private CodeExecutableElement createComputeSize() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "computeSize");
        Collection<InstructionModel> instructions = this.model.getInstructions();
        int[] lengths = instructions.stream().mapToInt(InstructionModel::getInstructionLength).sorted().toArray();
        int midpoint = lengths.length / 2;
        int median = lengths.length % 2 == 0 ? (lengths[midpoint - 1] + lengths[midpoint]) / 2 : lengths[midpoint];
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn();
        b.string("bytecode.bytecodes.length / ", Integer.toString(median), " /* median instruction length */");
        b.end();
        return ex;
    }

    private CodeExecutableElement createSneakyThrow() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(RuntimeException.class), "sneakyThrow", new CodeVariableElement[0]);
        TypeMirror throwable = this.type(Throwable.class);
        CodeVariableElement param = new CodeVariableElement(throwable, "e");
        ex.addParameter(param);
        CodeTypeParameterElement tpE = new CodeTypeParameterElement(CodeNames.of("E"), throwable);
        ex.getTypeParameters().add(tpE);
        ex.addThrownType(tpE.asType());
        GeneratorUtils.mergeSuppressWarnings(ex, "unchecked");
        CodeTreeBuilder b = ex.createBuilder();
        b.startThrow();
        b.cast(tpE.asType()).variable(param);
        b.end();
        return ex;
    }

    private CodeExecutableElement createAssertionFailed() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(AssertionError.class), "assertionFailed", new CodeVariableElement[0]);
        CodeVariableElement param = new CodeVariableElement(this.type(String.class), "message");
        ex.addParameter(param);
        CodeTreeBuilder b = ex.createBuilder();
        b.startThrow().startNew(this.type(AssertionError.class));
        b.string("message");
        b.end(2);
        return this.withTruffleBoundary(ex);
    }

    private CodeExecutableElement withTruffleBoundary(CodeExecutableElement ex) {
        ex.addAnnotationMirror(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
        return ex;
    }

    private CodeTypeElement createLoopCounter() {
        ElementHelpers.addField(this.loopCounter, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Integer.TYPE, "REPORT_LOOP_STRIDE", "1 << 8");
        ElementHelpers.addField((CodeElement<? super Element>)this.loopCounter, Set.of(Modifier.PRIVATE), Integer.TYPE, "value");
        return this.loopCounter;
    }

    private CodeExecutableElement createCreate() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, this.model.templateType.asType()), "create", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.model.languageClass, "language"));
        ex.addParameter(new CodeVariableElement(this.types.BytecodeConfig, "config"));
        ex.addParameter(new CodeVariableElement(this.parserType, "parser"));
        BytecodeRootNodeElement.addJavadoc(ex, String.format("Creates one or more bytecode nodes. This is the entrypoint for creating new {@link %s} instances.\n\n@param language the Truffle language instance.\n@param config indicates whether to parse metadata (e.g., source information).\n@param parser the parser that invokes a series of builder instructions to generate bytecode.\n", this.model.getName()));
        CodeTreeBuilder b = ex.getBuilder();
        b.declaration("BytecodeRootNodesImpl", "nodes", "new BytecodeRootNodesImpl(parser, config)");
        b.startAssign("Builder builder").startNew(this.builder.getSimpleName().toString());
        b.string("language");
        b.string("nodes");
        b.string("config");
        b.end(2);
        b.startStatement().startCall("parser", "parse");
        b.string("builder");
        b.end(2);
        b.startStatement().startCall("builder", "finish").end(2);
        b.startReturn().string("nodes").end();
        return ex;
    }

    private CodeExecutableElement createInitializeTagIndexToClass() {
        DeclaredType classValue = this.context.getDeclaredType(ClassValue.class);
        DeclaredType classValueType = ElementHelpers.generic((TypeMirror)classValue, this.type(Integer.class));
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), classValueType, "initializeTagMaskToClass", new CodeVariableElement[0]);
        CodeTreeBuilder b = method.createBuilder();
        b.startStatement();
        b.string("return new ClassValue<>()").startBlock();
        b.string("protected Integer computeValue(Class<?> type) ").startBlock();
        boolean elseIf = false;
        int index = 0;
        for (TypeMirror tagClass : this.model.getProvidedTags()) {
            elseIf = b.startIf(elseIf);
            b.string("type == ").typeLiteral(tagClass);
            b.end().startBlock();
            b.startReturn().string(1 << index).end();
            b.end();
            ++index;
        }
        this.createFailInvalidTag(b, "type");
        b.end();
        b.end();
        b.end();
        return method;
    }

    private void createFailInvalidTag(CodeTreeBuilder b, String tagLocal) {
        b.startThrow().startNew(this.type(IllegalArgumentException.class)).startCall("String.format").doubleQuote("Invalid tag specified. Tag '%s' not provided by language '" + ElementUtils.getQualifiedName(this.model.languageClass) + "'.").string(tagLocal, ".getName()").end().end().end();
    }

    private CodeExecutableElement createSerialize() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), this.type(Void.TYPE), "serialize", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.type(DataOutput.class), "buffer"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeSerializer, "callback"));
        method.addParameter(new CodeVariableElement(this.parserType, "parser"));
        method.addThrownType(this.type(IOException.class));
        BytecodeRootNodeElement.addJavadoc(method, "Serializes the bytecode nodes parsed by the {@code parser}.\nAll metadata (e.g., source info) is serialized (even if it has not yet been parsed).\n<p>\nUnlike {@link BytecodeRootNodes#serialize}, this method does not use already-constructed root nodes,\nso it cannot serialize field values that get set outside of the parser.\n\n@param buffer the buffer to write the byte output to.\n@param callback the language-specific serializer for constants in the bytecode.\n@param parser the parser.\n");
        CodeTreeBuilder init = CodeTreeBuilder.createBuilder();
        init.startNew("Builder");
        init.string("null");
        init.startGroup();
        init.startNew(this.bytecodeRootNodesImpl.asType());
        init.string("parser");
        init.staticReference(this.types.BytecodeConfig, "COMPLETE");
        init.end(2);
        init.staticReference(this.types.BytecodeConfig, "COMPLETE");
        init.end();
        CodeTreeBuilder b = method.createBuilder();
        b.declaration("Builder", "builder", init.build());
        b.startStatement();
        b.startCall("doSerialize");
        b.string("buffer");
        b.string("callback");
        b.string("builder");
        b.string("null");
        b.end(2);
        return this.withTruffleBoundary(method);
    }

    private CodeExecutableElement createDoSerialize() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Void.TYPE), "doSerialize", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.type(DataOutput.class), "buffer"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeSerializer, "callback"));
        method.addParameter(new CodeVariableElement(this.bytecodeBuilderType, "builder"));
        method.addParameter(new CodeVariableElement(ElementHelpers.generic(List.class, this.model.getTemplateType().asType()), "existingNodes"));
        method.addThrownType(this.type(IOException.class));
        CodeTreeBuilder b = method.createBuilder();
        b.startTryBlock();
        b.startStatement().startCall("builder", "serialize");
        b.string("buffer");
        b.string("callback");
        b.string("existingNodes");
        b.end().end();
        b.end().startCatchBlock(this.type(IOError.class), "e");
        b.startThrow().cast(this.type(IOException.class), "e.getCause()").end();
        b.end();
        return this.withTruffleBoundary(method);
    }

    private CodeExecutableElement createDeserialize() {
        CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, this.model.getTemplateType().asType()), "deserialize", new CodeVariableElement[0]);
        method.addParameter(new CodeVariableElement(this.model.languageClass, "language"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeConfig, "config"));
        method.addParameter(new CodeVariableElement(ElementHelpers.generic(Supplier.class, DataInput.class), "input"));
        method.addParameter(new CodeVariableElement(this.types.BytecodeDeserializer, "callback"));
        method.addThrownType(this.type(IOException.class));
        BytecodeRootNodeElement.addJavadoc(method, "Deserializes a byte sequence to bytecode nodes. The bytes must have been produced by a previous call to {@link #serialize}.\").newLine()\n\n@param language the language instance.\n@param config indicates whether to deserialize metadata (e.g., source information).\n@param input A function that supplies the bytes to deserialize. This supplier must produce a new {@link DataInput} each time, since the bytes may be processed multiple times for reparsing.\n@param callback The language-specific deserializer for constants in the bytecode. This callback must perform the inverse of the callback that was used to {@link #serialize} the nodes to bytes.\n");
        CodeTreeBuilder b = method.createBuilder();
        b.startTryBlock();
        b.statement("return create(language, config, (b) -> b.deserialize(input, callback, null))");
        b.end().startCatchBlock(this.type(IOError.class), "e");
        b.startThrow().cast(this.type(IOException.class), "e.getCause()").end();
        b.end();
        return this.withTruffleBoundary(method);
    }

    private CodeExecutableElement createReadVariadic() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Object[].class), "readVariadic", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.types.VirtualFrame, "frame"));
        ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "sp"));
        ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "variadicCount"));
        ex.addAnnotationMirror(this.createExplodeLoopAnnotation(null));
        CodeTreeBuilder b = ex.createBuilder();
        b.statement("Object[] result = new Object[variadicCount]");
        b.startFor().string("int i = 0; i < variadicCount; i++").end().startBlock();
        b.statement("int index = sp - variadicCount + i");
        b.statement("result[i] = " + BytecodeRootNodeElement.uncheckedGetFrameObject("index"));
        b.statement(BytecodeRootNodeElement.clearFrame("frame", "index"));
        b.end();
        b.statement("return result");
        return ex;
    }

    private CodeExecutableElement createMergeVariadic() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Object[].class), "mergeVariadic", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.type(Object[].class), "array"));
        CodeTreeBuilder b = ex.createBuilder();
        b.statement("Object[] current = array");
        b.statement("int length = 0");
        b.startDoBlock();
        b.statement("int currentLength = current.length - 1");
        b.statement("length += currentLength");
        b.statement("current = (Object[]) current[currentLength]");
        b.end().startDoWhile().string("current != null").end();
        b.statement("Object[] newArray = new Object[length]");
        b.statement("current = array");
        b.statement("int index = 0");
        b.startDoBlock();
        b.statement("int currentLength = current.length - 1");
        b.statement("System.arraycopy(current, 0, newArray, index, currentLength)");
        b.statement("index += currentLength");
        b.statement("current = (Object[]) current[currentLength]");
        b.end().startDoWhile().string("current != null").end();
        b.startReturn().string("newArray").end();
        return ex;
    }

    private CodeExecutableElement createGetBytecodeNode() {
        CodeExecutableElement ex = GeneratorUtils.override(this.types.BytecodeRootNode, "getBytecodeNode");
        ex.getModifiers().remove((Object)Modifier.DEFAULT);
        ex.getModifiers().add(Modifier.FINAL);
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().string("bytecode").end();
        return ex;
    }

    private CodeExecutableElement createGetBytecodeNodeImpl() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.abstractBytecodeNode.asType(), "getBytecodeNodeImpl", new CodeVariableElement[0]);
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().string("bytecode").end();
        return ex;
    }

    private CodeExecutableElement createGetBytecodeRootNode() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.asType(), "getBytecodeRootNodeImpl", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "index"));
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().cast(this.asType()).string("this.nodes.getNode(index)").end();
        return ex;
    }

    private CodeExecutableElement createGetRootNodes() {
        CodeExecutableElement ex = GeneratorUtils.override(this.types.BytecodeRootNode, "getRootNodes");
        ex.setReturnType(ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, this.model.templateType.asType()));
        ex.getModifiers().remove((Object)Modifier.DEFAULT);
        ex.getModifiers().add(Modifier.FINAL);
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().string("this.nodes").end();
        return ex;
    }

    private CodeExecutableElement createTransitionToCached() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.type(Void.TYPE), "transitionToCached", new CodeVariableElement[0]);
        if (this.model.enableUncachedInterpreter) {
            ex.addParameter(new CodeVariableElement(this.types.Frame, "frame"));
            ex.addParameter(new CodeVariableElement(this.type(Integer.TYPE), "bci"));
        }
        CodeTreeBuilder b = ex.createBuilder();
        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        b.declaration(this.abstractBytecodeNode.asType(), "oldBytecode");
        b.declaration(this.abstractBytecodeNode.asType(), "newBytecode");
        b.startDoBlock();
        b.statement("oldBytecode = this.bytecode");
        b.startAssign("newBytecode").startCall("insert").startCall("oldBytecode.toCached");
        if (this.model.usesBoxingElimination()) {
            b.string("this.numLocals");
        }
        b.end(3);
        if (this.model.enableUncachedInterpreter) {
            b.startIf().string("bci > 0").end().startBlock();
            b.lineComment("initialize local tags");
            b.declaration(this.type(Integer.TYPE), "localCount", "newBytecode.getLocalCount(bci)");
            b.startFor().string("int localOffset = 0; localOffset < localCount; localOffset++").end().startBlock();
            b.statement("newBytecode.setLocalValue(bci, frame, localOffset, newBytecode.getLocalValue(bci, frame, localOffset))");
            b.end();
            b.end();
        }
        this.emitFence(b);
        b.startIf().string("oldBytecode == newBytecode").end().startBlock();
        b.returnStatement();
        b.end();
        b.end().startDoWhile().startCall("!BYTECODE_UPDATER", "compareAndSet").string("this").string("oldBytecode").string("newBytecode").end().end();
        return ex;
    }

    private CodeExecutableElement createUpdateBytecode() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.abstractBytecodeNode.asType(), "updateBytecode", new CodeVariableElement[0]);
        for (VariableElement e : ElementFilter.fieldsIn(this.abstractBytecodeNode.getEnclosedElements())) {
            ex.addParameter(new CodeVariableElement(e.asType(), e.getSimpleName().toString() + "_"));
        }
        ex.addParameter(new CodeVariableElement(this.type(CharSequence.class), "reason"));
        if (this.model.enableYield) {
            ex.addParameter(new CodeVariableElement(ElementHelpers.generic(ArrayList.class, this.continuationLocation.asType()), "continuationLocations"));
        }
        CodeTreeBuilder b = ex.createBuilder();
        b.tree(GeneratorUtils.createNeverPartOfCompilation());
        b.declaration(this.abstractBytecodeNode.asType(), "oldBytecode");
        b.declaration(this.abstractBytecodeNode.asType(), "newBytecode");
        b.startDoBlock();
        b.statement("oldBytecode = this.bytecode");
        b.startStatement();
        b.string("newBytecode = ").startCall("insert").startCall("oldBytecode", "update");
        for (VariableElement e : ElementFilter.fieldsIn(this.abstractBytecodeNode.getEnclosedElements())) {
            b.string(e.getSimpleName().toString() + "_");
        }
        b.end().end();
        b.end();
        b.startIf().string("bytecodes_ == null").end().startBlock();
        b.lineComment("When bytecode doesn't change, nodes are reused and should be re-adopted.");
        b.statement("newBytecode.adoptNodesAfterUpdate()");
        b.end();
        this.emitFence(b);
        b.end().startDoWhile().startCall("!BYTECODE_UPDATER", "compareAndSet").string("this").string("oldBytecode").string("newBytecode").end().end();
        b.newLine();
        if (this.model.isBytecodeUpdatable()) {
            b.startIf().string("bytecodes_ != null").end().startBlock();
            b.startStatement().startCall("oldBytecode.invalidate");
            b.string("newBytecode");
            b.string("reason");
            b.end(2);
            b.end();
            if (this.model.enableYield) {
                b.startStatement().startCall("oldBytecode.updateContinuationRootNodes");
                b.string("newBytecode");
                b.string("reason");
                b.string("continuationLocations");
                b.string("bytecodes_ != null");
                b.end(2);
            }
        }
        b.startAssert().startStaticCall(this.type(Thread.class), "holdsLock").string("this.nodes").end().end();
        b.statement("var cloneReferences = this.clones");
        b.startIf().string("cloneReferences != null").end().startBlock();
        b.startStatement();
        b.string("cloneReferences.forEach((clone) -> ").startBlock();
        b.declaration(this.abstractBytecodeNode.asType(), "cloneOldBytecode");
        b.declaration(this.abstractBytecodeNode.asType(), "cloneNewBytecode");
        b.startDoBlock();
        b.statement("cloneOldBytecode = clone.bytecode");
        b.statement("cloneNewBytecode = clone.insert(this.bytecode.cloneUninitialized())");
        b.startIf().string("bytecodes_ == null").end().startBlock();
        b.lineComment("When bytecode doesn't change, nodes are reused and should be re-adopted.");
        b.statement("cloneNewBytecode.adoptNodesAfterUpdate()");
        b.end();
        this.emitFence(b);
        b.end().startDoWhile().startCall("!BYTECODE_UPDATER", "compareAndSet").string("clone").string("cloneOldBytecode").string("cloneNewBytecode").end().end();
        b.newLine();
        if (this.model.isBytecodeUpdatable()) {
            b.startIf().string("bytecodes_ != null").end().startBlock();
            b.startStatement().startCall("cloneOldBytecode.invalidate");
            b.string("cloneNewBytecode");
            b.string("reason");
            b.end(2);
            b.end();
            if (this.model.enableYield) {
                b.startStatement().startCall("cloneOldBytecode.updateContinuationRootNodes");
                b.string("cloneNewBytecode");
                b.string("reason");
                b.string("continuationLocations");
                b.string("bytecodes_ != null");
                b.end(2);
            }
        }
        b.end();
        b.end();
        b.string(")");
        b.end();
        b.end();
        b.startReturn().string("newBytecode").end();
        return ex;
    }

    private CodeTypeElement createBytecodeConfigEncoderClass() {
        CodeTypeElement type = new CodeTypeElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "BytecodeConfigEncoderImpl");
        type.setSuperClass(this.types.BytecodeConfigEncoder);
        CodeExecutableElement constructor = type.add(new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, type.getSimpleName().toString(), new CodeVariableElement[0]));
        CodeTreeBuilder b = constructor.createBuilder();
        b.startStatement().startSuperCall().staticReference(this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
        type.add(this.createEncodeInstrumentation());
        type.add(this.createDecode1());
        type.add(this.createDecode2(type));
        CodeExecutableElement encodeTag = GeneratorUtils.override(this.types.BytecodeConfigEncoder, "encodeTag", new String[]{"c"});
        b = encodeTag.createBuilder();
        if (this.model.getProvidedTags().isEmpty()) {
            this.createFailInvalidTag(b, "c");
        } else {
            b.startReturn().string("((long) CLASS_TO_TAG_MASK.get(c)) << 32").end().build();
        }
        type.add(encodeTag);
        CodeVariableElement configEncoderVar = type.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), type.asType(), "INSTANCE"));
        configEncoderVar.createInitBuilder().startNew(type.asType()).end();
        return type;
    }

    private CodeExecutableElement createDecode1() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Long.TYPE), "decode", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.types.BytecodeConfig, "config"));
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn();
        b.startCall("decode").string("getEncoder(config)").string("getEncoding(config)").end();
        b.end();
        return ex;
    }

    @SuppressFBWarnings(value={"BSHIFT_WRONG_ADD_PRIORITY"}, justification="the shift priority is expected. FindBugs false positive.")
    private CodeExecutableElement createDecode2(CodeTypeElement type) {
        int i;
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Long.TYPE), "decode", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.types.BytecodeConfigEncoder, "encoder"));
        ex.addParameter(new CodeVariableElement(this.type(Long.TYPE), "encoding"));
        CodeTreeBuilder b = ex.createBuilder();
        b.startIf().string("encoder != null && encoder  != ").staticReference(type.asType(), "INSTANCE").end().startBlock();
        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        b.startThrow().startNew(this.type(IllegalArgumentException.class)).doubleQuote("Encoded config is not compatible with this bytecode node.").end().end();
        b.end();
        long mask = 1L;
        if (this.model.getInstrumentations().size() > 31) {
            throw new AssertionError((Object)"Unsupported instrumentation size.");
        }
        if (this.model.getProvidedTags().size() > 32) {
            throw new AssertionError((Object)"Unsupported instrumentation size.");
        }
        for (i = 0; i < this.model.getInstrumentations().size(); ++i) {
            mask |= 1L << 1 + i;
        }
        for (i = 0; i < this.model.getProvidedTags().size(); ++i) {
            mask |= 1L << 32 + i;
        }
        b.startReturn().string("(encoding & 0x" + Long.toHexString(mask) + "L)").end();
        return ex;
    }

    private CodeExecutableElement createEncodeInstrumentation() {
        CodeExecutableElement encodeInstrumentation = GeneratorUtils.override(this.types.BytecodeConfigEncoder, "encodeInstrumentation", new String[]{"c"});
        CodeTreeBuilder b = encodeInstrumentation.createBuilder();
        if (!this.model.getInstrumentations().isEmpty()) {
            b.declaration("long", "encoding", "0L");
            boolean elseIf = false;
            for (CustomOperationModel customOperation : this.model.getInstrumentations()) {
                elseIf = b.startIf(elseIf);
                b.string("c == ").typeLiteral(customOperation.operation.instruction.nodeType.asType());
                b.end().startBlock();
                b.statement("encoding |= 0x" + Integer.toHexString(1 << customOperation.operation.instrumentationIndex));
                b.end();
            }
            b.startElseBlock();
        }
        b.startThrow().startNew(this.type(IllegalArgumentException.class)).startCall("String.format").doubleQuote("Invalid instrumentation specified. Instrumentation '%s' does not exist or is not an instrumentation for '" + ElementUtils.getQualifiedName(this.model.templateType) + "'. Instrumentations can be specified using the @Instrumentation annotation.").string("c.getName()").end().end().end();
        if (!this.model.getInstrumentations().isEmpty()) {
            b.end();
            b.startReturn().string("encoding << 1").end();
        }
        return encodeInstrumentation;
    }

    private CodeExecutableElement createIsInstrumentable() {
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "isInstrumentable");
        CodeTreeBuilder b = ex.createBuilder();
        if (this.model.enableTagInstrumentation) {
            b.statement("return true");
        } else {
            b.statement("return false");
        }
        return ex;
    }

    private CodeExecutableElement createPrepareForInstrumentation() {
        if (!this.model.enableTagInstrumentation) {
            return null;
        }
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "prepareForInstrumentation", new String[]{"materializedTags"});
        GeneratorUtils.mergeSuppressWarnings(ex, "unchecked");
        CodeTreeBuilder b = ex.createBuilder();
        b.declaration((TypeMirror)this.types.BytecodeConfig_Builder, "b", "newConfigBuilder()");
        b.lineComment("Sources are always needed for instrumentation.");
        b.statement("b.addSource()");
        b.startFor().type(this.type(Class.class)).string(" tag : materializedTags").end().startBlock();
        b.statement("b.addTag((Class<? extends Tag>) tag)");
        b.end();
        b.statement("getRootNodes().update(b.build())");
        return ex;
    }

    private CodeExecutableElement createPrepareForCompilation() {
        if (!this.model.enableUncachedInterpreter) {
            return null;
        }
        CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(this.model, "prepareForCompilation", new String[]{"rootCompilation", "compilationTier", "lastTier"});
        CodeTreeBuilder b = ex.createBuilder();
        b.startReturn().string("bytecode.getTier() != ").staticReference(this.types.BytecodeTier, "UNCACHED").end();
        return ex;
    }

    private CodeExecutableElement createEncodeTags() {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), this.type(Integer.TYPE), "encodeTags", new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(this.type(Class.class)), "tags"));
        ex.setVarArgs(true);
        CodeTreeBuilder b = ex.createBuilder();
        b.startIf().string("tags == null").end().startBlock();
        b.statement("return 0");
        b.end();
        if (this.model.getProvidedTags().isEmpty()) {
            b.startIf().string("tags.length != 0").end().startBlock();
            this.createFailInvalidTag(b, "tags[0]");
            b.end();
            b.startReturn().string("0").end();
        } else {
            b.statement("int tagMask = 0");
            b.startFor().string("Class<?> tag : tags").end().startBlock();
            b.statement("tagMask |= CLASS_TO_TAG_MASK.get(tag)");
            b.end();
            b.startReturn().string("tagMask").end();
        }
        return ex;
    }

    static String createApplyQuickeningName(TypeMirror type) {
        return "applyQuickening" + ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(type));
    }

    static String createIsQuickeningName(TypeMirror type) {
        return "isQuickening" + ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(type));
    }

    BytecodeDSLModel getModel() {
        return this.model;
    }

    ProcessorContext getContext() {
        return this.context;
    }

    CodeTypeElement getAbstractBytecodeNode() {
        return this.abstractBytecodeNode;
    }

    private ExecutableElement createCachedExecute(BytecodeDSLNodeGeneratorPlugs plugs, FlatNodeGenFactory factory, CodeTypeElement el, InstructionModel instruction) {
        boolean skipStateChecks;
        List<SpecializationData> specializations;
        plugs.setInstruction(instruction);
        TypeMirror returnType = instruction.signature.returnType;
        CodeExecutableElement executable = new CodeExecutableElement(Set.of(Modifier.PRIVATE), returnType, BytecodeRootNodeElement.executeMethodName(instruction), new CodeVariableElement(this.types.VirtualFrame, "frameValue"));
        if (instruction.isEpilogExceptional()) {
            executable.addParameter(new CodeVariableElement(this.types.AbstractTruffleException, "ex"));
        }
        if (BytecodeRootNodeElement.hasUnexpectedExecuteValue(instruction)) {
            executable.getThrownTypes().add(this.types.UnexpectedResultException);
            this.lookupExpectMethod(instruction.getQuickeningRoot().signature.returnType, returnType);
        }
        if (instruction.filteredSpecializations == null) {
            specializations = instruction.nodeData.getReachableSpecializations();
            skipStateChecks = false;
        } else {
            specializations = instruction.filteredSpecializations;
            skipStateChecks = specializations.size() == 1;
        }
        return factory.createExecuteMethod(el, executable, specializations, skipStateChecks && instruction.isQuickening());
    }

    CodeExecutableElement lookupExpectMethod(TypeMirror currentType, TypeMirror targetType) {
        if (ElementUtils.isVoid(targetType) || ElementUtils.isVoid(currentType)) {
            throw new AssertionError((Object)("Invalid target type " + String.valueOf(targetType)));
        }
        CodeExecutableElement expectMethod = this.expectMethods.get(targetType);
        if (expectMethod == null) {
            expectMethod = TypeSystemCodeGenerator.createExpectMethod(Modifier.PRIVATE, this.model.typeSystem, currentType, targetType);
            this.add(expectMethod);
            this.expectMethods.put(targetType, expectMethod);
        }
        return expectMethod;
    }

    private TypeMirror type(Class<?> c) {
        return this.context.getType(c);
    }

    private DeclaredType declaredType(Class<?> t) {
        return this.context.getDeclaredType(t);
    }

    private static String executeMethodName(InstructionModel instruction) {
        return "execute" + instruction.getQualifiedQuickeningName();
    }

    private void serializationWrapException(CodeTreeBuilder b, Runnable r) {
        b.startTryBlock();
        r.run();
        b.end().startCatchBlock(this.type(IOException.class), "ex");
        b.startThrow().startNew(this.type(IOError.class)).string("ex").end(2);
        b.end();
    }

    static CodeExecutableElement overrideImplementRootNodeMethod(BytecodeDSLModel model, String name) {
        return BytecodeRootNodeElement.overrideImplementRootNodeMethod(model, name, new String[0]);
    }

    private static CodeExecutableElement overrideImplementRootNodeMethod(BytecodeDSLModel model, String name, String[] parameterNames) {
        return BytecodeRootNodeElement.overrideImplementRootNodeMethod(model, name, parameterNames, new TypeMirror[parameterNames.length]);
    }

    static CodeExecutableElement overrideImplementRootNodeMethod(BytecodeDSLModel model, String name, String[] parameterNames, TypeMirror[] parameterTypes) {
        TruffleTypes types = model.getContext().getTypes();
        CodeExecutableElement result = GeneratorUtils.override(types.RootNode, name, parameterNames, parameterTypes);
        if (result == null) {
            throw new IllegalArgumentException("Method with name " + name + " and types " + Arrays.toString(parameterTypes) + " not found.");
        }
        if (ElementUtils.getVisibility(result.getModifiers()) == Modifier.PUBLIC) {
            return result;
        }
        if (ElementUtils.getVisibility(result.getModifiers()) != Modifier.PROTECTED) {
            throw new AssertionError((Object)"Unexpected visibility of root node override.");
        }
        ExecutableElement override = ElementUtils.findInstanceMethod(model.templateType, name, parameterTypes);
        if (override != null && ElementUtils.getVisibility(override.getModifiers()) == Modifier.PUBLIC) {
            result.setVisibility(Modifier.PUBLIC);
            return result;
        }
        for (TypeElement parent : ElementUtils.getSuperTypes(model.templateType)) {
            override = ElementUtils.findInstanceMethod(parent, name, parameterTypes);
            if (override == null || ElementUtils.getVisibility(override.getModifiers()) != Modifier.PUBLIC) continue;
            result.setVisibility(Modifier.PUBLIC);
            return result;
        }
        return result;
    }

    private void addMethodStubsToSerializationRootNode() {
        for (ExecutableElement method : ElementUtils.getOverridableMethods(this)) {
            CodeExecutableElement stub = CodeExecutableElement.cloneNoAnnotations(method);
            GeneratorUtils.addOverride(stub);
            CodeTreeBuilder b = stub.createBuilder();
            BytecodeRootNodeElement.emitThrowIllegalStateException(stub, b, "method should not be called");
            b.end(2);
            this.serializationRootNode.add(stub);
        }
    }

    private static boolean needsCachedInitialization(InstructionModel instruction, InstructionModel.InstructionImmediate immediate) {
        return switch (immediate.kind()) {
            case InstructionModel.ImmediateKind.NODE_PROFILE -> true;
            case InstructionModel.ImmediateKind.BRANCH_PROFILE -> {
                if (instruction.kind != InstructionModel.InstructionKind.BRANCH_BACKWARD) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    void emitQuickening(CodeTreeBuilder b, String node, String bc, String bci, CodeTree oldInstruction, CodeTree newInstruction) {
        boolean overridesOnQuicken = this.model.overridesBytecodeDebugListenerMethod("onQuicken");
        if (overridesOnQuicken && oldInstruction == null) {
            b.startBlock();
            b.startDeclaration(this.instructionImpl.asType(), "oldInstruction");
            this.emitParseInstruction(b, node, bci, BytecodeRootNodeElement.readInstruction(bc, bci));
            b.end();
        }
        b.statement(BytecodeRootNodeElement.writeInstruction(bc, bci, newInstruction));
        if (overridesOnQuicken) {
            b.startStatement();
            b.startCall(node, "getRoot().onQuicken");
            if (oldInstruction == null) {
                b.string("oldInstruction");
            } else {
                this.emitParseInstruction(b, node, bci, oldInstruction);
            }
            this.emitParseInstruction(b, node, bci, newInstruction);
            b.end().end();
            if (oldInstruction == null) {
                b.end();
            }
        }
    }

    void emitInvalidateInstruction(CodeTreeBuilder b, String node, String bc, String bci, CodeTree oldInstruction, CodeTree newInstruction) {
        boolean overridesOnInvalidateInstruction = this.model.overridesBytecodeDebugListenerMethod("onInvalidateInstruction");
        if (overridesOnInvalidateInstruction && oldInstruction == null) {
            b.startBlock();
            b.startDeclaration(this.instructionImpl.asType(), "oldInstruction");
            this.emitParseInstruction(b, node, bci, BytecodeRootNodeElement.readInstruction(bc, bci));
            b.end();
        }
        b.statement(BytecodeRootNodeElement.writeInstruction(bc, bci, newInstruction));
        if (overridesOnInvalidateInstruction) {
            b.startStatement();
            b.startCall(node, "getRoot().onInvalidateInstruction");
            if (oldInstruction == null) {
                b.string("oldInstruction");
            } else {
                this.emitParseInstruction(b, node, bci, oldInstruction);
            }
            this.emitParseInstruction(b, node, bci, newInstruction);
            b.end().end();
            if (oldInstruction == null) {
                b.end();
            }
        }
    }

    void emitQuickening(CodeTreeBuilder b, String node, String bc, String bci, String oldInstruction, String newInstruction) {
        this.emitQuickening(b, node, bc, bci, oldInstruction != null ? CodeTreeBuilder.singleString(oldInstruction) : null, CodeTreeBuilder.singleString(newInstruction));
    }

    void emitQuickeningOperand(CodeTreeBuilder b, String node, String bc, String baseBci, String baseInstruction, int operandIndex, String operandBci, String oldInstruction, String newInstruction) {
        boolean overridesOnQuickenOperand = this.model.overridesBytecodeDebugListenerMethod("onQuickenOperand");
        if (overridesOnQuickenOperand && oldInstruction == null) {
            b.startBlock();
            b.startDeclaration(this.instructionImpl.asType(), "oldInstruction");
            this.emitParseInstruction(b, node, operandBci, BytecodeRootNodeElement.readInstruction(bc, operandBci));
            b.end();
        }
        b.statement(BytecodeRootNodeElement.writeInstruction(bc, operandBci, newInstruction));
        if (overridesOnQuickenOperand) {
            b.startStatement();
            b.startCall(node, "getRoot().onQuickenOperand");
            CodeTree base = baseInstruction == null ? BytecodeRootNodeElement.readInstruction(bc, baseBci) : CodeTreeBuilder.singleString(baseInstruction);
            this.emitParseInstruction(b, node, baseBci, base);
            b.string(operandIndex);
            if (oldInstruction == null) {
                b.string("oldInstruction");
            } else {
                this.emitParseInstruction(b, node, operandBci, CodeTreeBuilder.singleString(oldInstruction));
            }
            this.emitParseInstruction(b, node, operandBci, CodeTreeBuilder.singleString(newInstruction));
            b.end().end();
            if (oldInstruction == null) {
                b.end();
            }
        }
    }

    void emitOnSpecialize(CodeTreeBuilder b, String node, String bci, CodeTree operand, String specializationName) {
        if (this.model.overridesBytecodeDebugListenerMethod("onSpecialize")) {
            b.startStatement().startCall(node, "getRoot().onSpecialize");
            this.emitParseInstruction(b, node, bci, operand);
            b.doubleQuote(specializationName);
            b.end().end();
        }
    }

    CodeTreeBuilder emitParseInstruction(CodeTreeBuilder b, String node, String bci, CodeTree operand) {
        b.startNew(this.instructionImpl.asType()).string(node).string(bci).tree(operand).end();
        return b;
    }

    private static boolean hasUnexpectedExecuteValue(InstructionModel instr) {
        return ElementUtils.needsCastTo(instr.getQuickeningRoot().signature.returnType, instr.signature.returnType);
    }

    private static Collection<List<InstructionModel>> groupInstructionsByLength(Collection<InstructionModel> models) {
        return models.stream().sorted(Comparator.comparingInt(i -> i.getInstructionLength())).collect(BytecodeRootNodeElement.deterministicGroupingBy(m -> m.getInstructionLength())).values();
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> deterministicGroupingBy(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, LinkedHashMap::new, Collectors.toList());
    }

    private void processCachedNode(CodeTypeElement el) {
        for (VariableElement variableElement : ElementFilter.fieldsIn(el.getEnclosedElements())) {
            if (!ElementUtils.getQualifiedName(variableElement.asType()).equals("C")) continue;
            el.getEnclosedElements().remove(variableElement);
        }
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(el.getEnclosedElements())) {
            el.getEnclosedElements().remove(executableElement);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(el.getEnclosedElements())) {
            String name = executableElement.getSimpleName().toString();
            if (name.equals("executeAndSpecialize") || !name.startsWith("execute")) continue;
            el.getEnclosedElements().remove(executableElement);
        }
        if (this.model.enableUncachedInterpreter) {
            for (CodeTypeElement codeTypeElement : ElementFilter.typesIn(el.getEnclosedElements())) {
                if (!codeTypeElement.getSimpleName().toString().equals("Uncached")) continue;
                codeTypeElement.setSuperClass(this.types.Node);
                for (ExecutableElement ctor : ElementFilter.methodsIn(codeTypeElement.getEnclosedElements())) {
                    String name = ctor.getSimpleName().toString();
                    if (!name.startsWith("execute") || name.equals("executeUncached")) continue;
                    codeTypeElement.getEnclosedElements().remove(ctor);
                }
            }
        }
    }

    private CodeVariableElement compFinal(CodeVariableElement fld) {
        return this.compFinal(-1, fld);
    }

    private CodeVariableElement compFinal(int dims, CodeVariableElement fld) {
        CodeAnnotationMirror mir = new CodeAnnotationMirror(this.types.CompilerDirectives_CompilationFinal);
        if (dims != -1) {
            mir.setElementValue("dimensions", (AnnotationValue)new CodeAnnotationValue(dims));
        }
        fld.addAnnotationMirror(mir);
        return fld;
    }

    private CodeVariableElement child(CodeVariableElement fld) {
        CodeAnnotationMirror mir = new CodeAnnotationMirror(fld.asType().getKind() == TypeKind.ARRAY ? this.types.Node_Children : this.types.Node_Child);
        fld.addAnnotationMirror(mir);
        return fld;
    }

    private void emitFence(CodeTreeBuilder b) {
        b.startStatement().startStaticCall(this.type(VarHandle.class), "storeStoreFence").end(2);
    }

    private static void emitThrowAssertionError(CodeTreeBuilder b, String reason) {
        b.startThrow().startCall("assertionFailed").string(reason).end(2);
    }

    private void emitThrowEncodingException(CodeTreeBuilder b, String reason) {
        b.startThrow().startStaticCall(this.types.BytecodeEncodingException, "create");
        b.string(reason);
        b.end(2);
    }

    private static void emitThrowIllegalArgumentException(CodeTreeBuilder b, String reasonString) {
        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        b.startThrow().startNew(ProcessorContext.getInstance().getType(IllegalArgumentException.class));
        if (reasonString != null) {
            b.doubleQuote(reasonString);
        }
        b.end(2);
    }

    private static void emitThrowIllegalStateException(CodeExecutableElement method, CodeTreeBuilder b, String reasonString) {
        GeneratorUtils.addBoundaryOrTransferToInterpreter(method, b);
        b.startThrow().startNew(ProcessorContext.getInstance().getType(IllegalStateException.class));
        if (reasonString != null) {
            b.doubleQuote(reasonString);
        }
        b.end(2);
    }

    private static void addJavadoc(CodeElement<?> element, String contents) {
        BytecodeRootNodeElement.addJavadoc(element, Arrays.asList(contents.split("\n")));
    }

    private static void addJavadoc(CodeElement<?> element, List<String> lines) {
        CodeTreeBuilder b = element.createDocBuilder();
        b.startJavadoc();
        for (String line : lines) {
            if (line.isBlank()) {
                b.string(" ");
            } else {
                b.string(line);
            }
            b.newLine();
        }
        b.end();
    }

    private CodeAnnotationMirror createExplodeLoopAnnotation(String kind) {
        CodeAnnotationMirror explodeLoop = new CodeAnnotationMirror(this.types.ExplodeLoop);
        if (kind != null) {
            TypeElement loopExplosionKind = ElementUtils.castTypeElement(this.types.ExplodeLoop_LoopExplosionKind);
            Optional<Element> enumValue = ElementUtils.getEnumValues(loopExplosionKind).stream().filter(value -> value.getSimpleName().contentEquals(kind)).findFirst();
            if (enumValue.isEmpty()) {
                throw new IllegalArgumentException(String.format("Unknown enum value for %s: %s", loopExplosionKind.getSimpleName(), kind));
            }
            CodeAnnotationValue value2 = new CodeAnnotationValue(enumValue.get());
            explodeLoop.setElementValue("kind", (AnnotationValue)value2);
        }
        return explodeLoop;
    }

    CodeTree createInstructionConstant(InstructionModel instr) {
        return CodeTreeBuilder.createBuilder().staticReference(this.instructionsElement.asType(), instr.getConstantName()).build();
    }

    private CodeTree createOperationConstant(OperationModel op) {
        return CodeTreeBuilder.createBuilder().staticReference(this.operationsElement.asType(), op.getConstantName()).build();
    }

    private static String safeCastShort(String value) {
        return String.format("safeCastShort(%s)", value);
    }

    private String localFrame() {
        return this.model.enableYield ? "localFrame" : "frame";
    }

    static CodeTree readInstruction(String bc, String bci) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("BYTES", "getShort");
        b.string(bc);
        b.string(bci);
        b.end();
        return b.build();
    }

    private static CodeTree writeInstruction(String bc, String bci, String value) {
        return BytecodeRootNodeElement.writeInstruction(bc, bci, CodeTreeBuilder.singleString(value));
    }

    private static CodeTree writeInstruction(String bc, String bci, CodeTree value) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("BYTES", "putShort");
        b.string(bc);
        b.string(bci);
        b.tree(value);
        b.end();
        return b.build();
    }

    static CodeTree readImmediate(String bc, String bci, InstructionModel.InstructionImmediate immediate) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        String accessor = switch (immediate.kind().width) {
            default -> throw new IncompatibleClassChangeError();
            case InstructionModel.ImmediateWidth.BYTE -> "getByte";
            case InstructionModel.ImmediateWidth.SHORT -> "getShort";
            case InstructionModel.ImmediateWidth.INT -> "getIntUnaligned";
        };
        b.startCall("BYTES", accessor);
        b.string(bc);
        b.startGroup();
        b.string(bci).string(" + ").string(immediate.offset()).string(" ");
        b.startComment().string(" imm ", immediate.name(), " ").end();
        b.end();
        b.end();
        return b.build();
    }

    private static CodeTree writeImmediate(String bc, String bci, String value, InstructionModel.InstructionImmediate immediate) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        String accessor = switch (immediate.kind().width) {
            default -> throw new IncompatibleClassChangeError();
            case InstructionModel.ImmediateWidth.BYTE -> "putByte";
            case InstructionModel.ImmediateWidth.SHORT -> "putShort";
            case InstructionModel.ImmediateWidth.INT -> "putInt";
        };
        b.startCall("BYTES", accessor);
        b.string(bc);
        b.startGroup();
        b.string(bci).string(" + ").string(immediate.offset()).string(" ");
        b.startComment().string(" imm ", immediate.name(), " ").end();
        b.end();
        b.string(value);
        b.end();
        return b.build();
    }

    private static String readInt(String array, String index) {
        return String.format("BYTES.getInt(%s, %s)", array, index);
    }

    private static String writeInt(String array, String index, String value) {
        return String.format("BYTES.putInt(%s, %s, %s)", array, index, value);
    }

    private static String readByte(String array, String index) {
        return String.format("BYTES.getByte(%s, %s)", array, index);
    }

    private static String writeByte(String array, String index, String value) {
        return String.format("BYTES.putByte(%s, %s, %s)", array, index, value);
    }

    static CodeTree readConstFastPath(CodeTree index) {
        return BytecodeRootNodeElement.readConst(index, "consts", null);
    }

    static CodeTree readConstFastPath(CodeTree index, TypeMirror knownType) {
        return BytecodeRootNodeElement.readConst(index, "consts", knownType);
    }

    static CodeTree readConst(String index, String constants) {
        return BytecodeRootNodeElement.readConst(CodeTreeBuilder.singleString(index), constants, null);
    }

    static CodeTree readConst(CodeTree index, String constants, TypeMirror knownType) {
        boolean needsCast;
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        boolean bl = needsCast = knownType != null && !ElementUtils.isObject(knownType);
        if (needsCast) {
            b.startCall("ACCESS.uncheckedCast");
        }
        b.startCall("ACCESS.readObject");
        b.string(constants);
        b.tree(index);
        b.end();
        if (needsCast) {
            b.typeLiteral(ElementUtils.boxType(knownType));
            b.end();
        }
        return b.build();
    }

    private static CodeTree readIntArray(String array, String index) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("ACCESS.readInt");
        b.string(array);
        b.string(index);
        b.end();
        return b.build();
    }

    private static CodeTree writeIntArray(String array, String index, String value) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("ACCESS.writeInt");
        b.string(array);
        b.string(index);
        b.string(value);
        b.end();
        return b.build();
    }

    private static CodeTree readTagNode(TypeMirror expectedType, CodeTree index) {
        return BytecodeRootNodeElement.readTagNode(expectedType, "tagRoot.tagNodes", index);
    }

    private static CodeTree readTagNode(TypeMirror expectedType, String tagNodes, CodeTree index) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("ACCESS.uncheckedCast");
        b.startCall("ACCESS.readObject");
        b.string(tagNodes);
        b.tree(index);
        b.end();
        b.typeLiteral(expectedType);
        b.end();
        return b.build();
    }

    private static CodeTree readTagNodeSafe(CodeTree index) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.string("tagRoot.tagNodes[" + String.valueOf(index) + "]");
        b.end();
        return b.build();
    }

    private static CodeTree readNodeProfile(TypeMirror expectedType, CodeTree index) {
        CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
        b.startCall("ACCESS.uncheckedCast");
        b.startCall("ACCESS.readObject");
        b.string("cachedNodes");
        b.tree(index);
        b.end();
        b.typeLiteral(expectedType);
        b.end();
        return b.build();
    }

    static String uncheckedGetFrameObject(String index) {
        return BytecodeRootNodeElement.uncheckedGetFrameObject("frame", index);
    }

    static String uncheckedGetFrameObject(String frame, String index) {
        return String.format("FRAMES.uncheckedGetObject(%s, %s)", frame, index);
    }

    private static CodeTreeBuilder startRequireFrame(CodeTreeBuilder b, TypeMirror type) {
        b.startCall("FRAMES", switch (type.getKind()) {
            case TypeKind.BOOLEAN -> "requireBoolean";
            case TypeKind.BYTE -> "requireByte";
            case TypeKind.INT -> "requireInt";
            case TypeKind.LONG -> "requireLong";
            case TypeKind.FLOAT -> "requireFloat";
            case TypeKind.DOUBLE -> "requireDouble";
            default -> "requireObject";
        });
        return b;
    }

    static CodeTreeBuilder startExpectFrameUnsafe(CodeTreeBuilder b, String frame, TypeMirror type) {
        return BytecodeRootNodeElement.startExpectFrame(b, frame, type, true);
    }

    static CodeTreeBuilder startExpectFrame(CodeTreeBuilder b, String frame, TypeMirror type, boolean unsafe) {
        String methodName = switch (type.getKind()) {
            case TypeKind.BOOLEAN -> "expectBoolean";
            case TypeKind.BYTE -> "expectByte";
            case TypeKind.INT -> "expectInt";
            case TypeKind.LONG -> "expectLong";
            case TypeKind.FLOAT -> "expectFloat";
            case TypeKind.DOUBLE -> "expectDouble";
            default -> "expectObject";
        };
        if (unsafe) {
            b.startCall("FRAMES", methodName);
            b.string(frame);
        } else {
            b.startCall(frame, methodName);
        }
        return b;
    }

    static CodeTreeBuilder startGetFrameUnsafe(CodeTreeBuilder b, String frame, TypeMirror type) {
        return BytecodeRootNodeElement.startGetFrame(b, frame, type, true);
    }

    static CodeTreeBuilder startGetFrame(CodeTreeBuilder b, String frame, TypeMirror type, boolean unsafe) {
        String methodName;
        if (type == null) {
            methodName = "getValue";
        } else {
            switch (type.getKind()) {
                case BOOLEAN: {
                    methodName = "getBoolean";
                    break;
                }
                case BYTE: {
                    methodName = "getByte";
                    break;
                }
                case INT: {
                    methodName = "getInt";
                    break;
                }
                case LONG: {
                    methodName = "getLong";
                    break;
                }
                case FLOAT: {
                    methodName = "getFloat";
                    break;
                }
                case DOUBLE: {
                    methodName = "getDouble";
                    break;
                }
                default: {
                    methodName = "getObject";
                }
            }
        }
        if (unsafe) {
            b.startCall("FRAMES", methodName);
            b.string(frame);
        } else {
            b.startCall(frame, methodName);
        }
        return b;
    }

    static String getSetMethod(TypeMirror type) {
        if (type == null) {
            return "setValue";
        }
        return switch (type.getKind()) {
            case TypeKind.BOOLEAN -> "setBoolean";
            case TypeKind.BYTE -> "setByte";
            case TypeKind.INT -> "setInt";
            case TypeKind.LONG -> "setLong";
            case TypeKind.FLOAT -> "setFloat";
            case TypeKind.DOUBLE -> "setDouble";
            default -> "setObject";
        };
    }

    static CodeTreeBuilder startSetFrame(CodeTreeBuilder b, TypeMirror type) {
        String methodName = BytecodeRootNodeElement.getSetMethod(type);
        b.startCall("FRAMES", methodName);
        return b;
    }

    private static String setFrameObject(String index, String value) {
        return BytecodeRootNodeElement.setFrameObject("frame", index, value);
    }

    private static String setFrameObject(String frame, String index, String value) {
        return String.format("FRAMES.setObject(%s, %s, %s)", frame, index, value);
    }

    private static String clearFrame(String frame, String index) {
        return String.format("FRAMES.clear(%s, %s)", frame, index);
    }

    private static String copyFrameSlot(String src, String dst) {
        return String.format("FRAMES.copy(frame, %s, %s)", src, dst);
    }

    private static String copyFrameTo(String srcFrame, String srcOffset, String dstFrame, String dstOffset, String length) {
        return String.format("FRAMES.copyTo(%s, %s, %s, %s, %s)", srcFrame, srcOffset, dstFrame, dstOffset, length);
    }

    private static String cachedDataClassName(InstructionModel instr) {
        if (!instr.hasNodeImmediate() && !instr.canUseNodeSingleton()) {
            return null;
        }
        if (instr.quickeningBase != null) {
            return BytecodeRootNodeElement.cachedDataClassName(instr.quickeningBase);
        }
        return instr.getInternalName() + "Node";
    }

    private static String childString(int numChildren) {
        return numChildren + (numChildren == 1 ? " child" : " children");
    }

    final class BuilderElement
    extends CodeTypeElement {
        private static final String UNINIT = "UNINITIALIZED";
        private final CodeVariableElement uninitialized;
        private final SavedStateElement savedState;
        private final OperationStackEntryElement operationStackEntry;
        private final ConstantPoolElement constantPool;
        private final BytecodeLocalImplElement bytecodeLocalImpl;
        private final BytecodeLabelImplElement bytecodeLabelImpl;
        private final TypeMirror unresolvedLabelsType;
        private final Map<InstructionModel.InstructionEncoding, CodeExecutableElement> doEmitInstructionMethods;
        private final Map<OperationModel, CodeTypeElement> dataClasses;
        private OperationDataClassesFactory.ScopeDataElement scopeDataType;
        private List<CodeVariableElement> builderState;
        private SerializationLocalElement serializationLocal;
        private SerializationLabelElement serializationLabel;
        private SerializationStateElement serializationElements;
        private DeserializationStateElement deserializationElement;
        private CodeVariableElement serialization;
        private CodeExecutableElement validateLocalScope;
        private CodeExecutableElement validateMaterializedLocalScope;

        BuilderElement() {
            super(Set.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "Builder");
            this.uninitialized = this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Byte.TYPE), UNINIT));
            this.savedState = this.add(new SavedStateElement());
            this.operationStackEntry = this.add(new OperationStackEntryElement());
            this.constantPool = this.add(new ConstantPoolElement());
            this.bytecodeLocalImpl = this.add(new BytecodeLocalImplElement());
            this.bytecodeLabelImpl = this.add(new BytecodeLabelImplElement());
            this.unresolvedLabelsType = ElementHelpers.generic(HashMap.class, BytecodeRootNodeElement.this.types.BytecodeLabel, ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(ArrayList.class), (TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(Integer.class)));
            this.doEmitInstructionMethods = new TreeMap<InstructionModel.InstructionEncoding, CodeExecutableElement>();
            this.dataClasses = new HashMap<OperationModel, CodeTypeElement>();
        }

        void lazyInit() {
            BytecodeRootNodeElement.addJavadoc(this, "Builder class to generate bytecode. An interpreter can invoke this class with its {@link com.oracle.truffle.api.bytecode.BytecodeParser} to generate bytecode.\n");
            this.setSuperClass(BytecodeRootNodeElement.this.model.abstractBuilderType);
            this.setEnclosingElement(BytecodeRootNodeElement.this);
            this.builderState = this.createBuilderState();
            this.savedState.lazyInit(this.builderState);
            this.addAll(this.builderState);
            this.uninitialized.createInitBuilder().string(-1).end();
            this.add(this.createOperationNames());
            this.addAll(new OperationDataClassesFactory().create());
            this.operationStackEntry.lazyInit();
            this.bytecodeLocalImpl.lazyInit();
            this.bytecodeLabelImpl.lazyInit();
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.model.languageClass, "language"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "nodes"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(CharSequence.class), "reparseReason"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "parseBytecodes"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "tags"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "instrumentations"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "parseSources"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.asType()), "builtNodes"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numRoots"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, (TypeMirror)BytecodeRootNodeElement.this.types.Source), "sources"));
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                BytecodeRootNodeElement.this.serializationRootNode = this.add(new SerializationRootNodeElement());
                this.serializationLocal = this.add(new SerializationLocalElement());
                this.serializationLabel = this.add(new SerializationLabelElement());
                this.serializationElements = this.add(new SerializationStateElement());
                this.deserializationElement = this.add(new DeserializationStateElement());
                this.serialization = this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), this.serializationElements.asType(), "serialization"));
            }
            this.add(this.createParseConstructor());
            this.add(this.createReparseConstructor());
            this.add(this.createCreateLocal());
            this.add(this.createCreateLocalAllParameters());
            this.add(this.createCreateLabel());
            this.addAll(this.createSourceSectionUnavailableHelpers());
            this.add(this.createRegisterUnresolvedLabel());
            this.add(this.createResolveUnresolvedLabel());
            for (OperationModel operation : BytecodeRootNodeElement.this.model.getOperations()) {
                if (this.omitBuilderMethods(operation)) continue;
                if (operation.hasChildren()) {
                    this.add(this.createBegin(operation));
                    this.add(this.createEnd(operation));
                    continue;
                }
                this.add(this.createEmit(operation));
            }
            this.add(this.createMarkReachable());
            this.add(this.createUpdateReachable());
            this.add(this.createBeginOperation());
            this.add(this.createEndOperation());
            this.add(this.createValidateRootOperationBegin());
            this.add(this.createGetCurrentRootOperationData());
            this.add(this.createBeforeChild());
            this.add(this.createAfterChild());
            this.add(this.createSafeCastShort());
            this.add(this.createCheckOverflowShort());
            this.add(this.createCheckOverflowInt());
            this.add(this.createCheckBci());
            this.add(this.createUpdateMaxStackHeight());
            this.add(this.createEnsureBytecodeCapacity());
            this.add(this.createDoEmitVariadic());
            this.add(this.createDoEmitFinallyHandler());
            this.add(this.createDoCreateExceptionHandler());
            this.add(this.createDoEmitSourceInfo());
            this.add(this.createFinish());
            this.add(this.createBeforeEmitBranch());
            this.add(this.createBeforeEmitReturn());
            this.add(this.createPatchHandlerTable());
            this.add(this.createDoEmitRoot());
            this.add(this.createAllocateNode());
            this.add(this.createAllocateBytecodeLocal());
            this.add(this.createAllocateBranchProfile());
            if (BytecodeRootNodeElement.this.model.enableYield) {
                this.add(this.createAllocateContinuationConstant());
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    this.add(this.createDoEmitTagYield());
                    this.add(this.createDoEmitTagResume());
                }
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                this.add(this.createGetCurrentScope());
            }
            this.add(this.createDoEmitLocal());
            this.add(this.createDoEmitLocalConstantIndices());
            this.add(this.createAllocateLocalsTableEntry());
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                this.add(this.createSerialize());
                this.add(this.createSerializeFinallyGenerator());
                this.add(this.createDeserialize());
            }
            this.add(this.createToString());
            this.add(this.createFailState());
            this.add(this.createFailArgument());
            this.add(this.createDumpAt());
            this.addAll(this.doEmitInstructionMethods.values());
        }

        private List<CodeVariableElement> createBuilderState() {
            ArrayList<CodeVariableElement> list = new ArrayList<CodeVariableElement>();
            list.addAll(List.of(new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "operationSequenceNumber"), new CodeVariableElement(Set.of(Modifier.PRIVATE), new CodeTypeMirror.ArrayCodeTypeMirror(this.operationStackEntry.asType()), "operationStack"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "operationSp"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "rootOperationSp"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numLocals"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numLabels"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numNodes"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numHandlers"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "numConditionalBranches"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "currentStackHeight"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "maxStackHeight"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(int[].class), "sourceInfo"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceInfoIndex"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(int[].class), "handlerTable"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerTableSize"), new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "locals"), new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "localsTableIndex"), new CodeVariableElement(Set.of(Modifier.PRIVATE), this.unresolvedLabelsType, "unresolvedLabels"), new CodeVariableElement(Set.of(Modifier.PRIVATE), this.constantPool.asType(), "constantPool")));
            CodeVariableElement reachable = new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Boolean.TYPE), "reachable");
            reachable.createInitBuilder().string("true");
            list.add(reachable);
            if (BytecodeRootNodeElement.this.model.enableYield) {
                list.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.continuationLocation.asType()), "continuationLocations"));
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                list.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "maxLocals"));
            }
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                list.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.generic(BytecodeRootNodeElement.this.type(List.class), BytecodeRootNodeElement.this.tagNode.asType()), "tagRoots"));
                list.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.generic(BytecodeRootNodeElement.this.type(List.class), BytecodeRootNodeElement.this.tagNode.asType()), "tagNodes"));
            }
            list.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), this.savedState.asType(), "savedState"));
            return list;
        }

        private String getDataClassName(OperationModel operation) {
            switch (operation.kind) {
                case STORE_LOCAL: 
                case STORE_LOCAL_MATERIALIZED: {
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) break;
                    return ElementUtils.getSimpleName(this.bytecodeLocalImpl);
                }
                case LOAD_LOCAL_MATERIALIZED: 
                case LOAD_LOCAL: {
                    return ElementUtils.getSimpleName(this.bytecodeLocalImpl);
                }
            }
            CodeTypeElement type = this.dataClasses.get(operation);
            if (type == null) {
                return null;
            }
            return type.getSimpleName().toString();
        }

        private CodeExecutableElement createReparseConstructor() {
            CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, "Builder", new CodeVariableElement[0]);
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "nodes"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "parseBytecodes"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "tags"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "instrumentations"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "parseSources"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(CharSequence.class), "reparseReason"));
            CodeTreeBuilder javadoc = ctor.createDocBuilder();
            javadoc.startJavadoc();
            javadoc.string("Constructor for reparsing.");
            javadoc.newLine();
            javadoc.end();
            CodeTreeBuilder b = ctor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.statement("this.language = nodes.getLanguage()");
            b.statement("this.nodes = nodes");
            b.statement("this.reparseReason = reparseReason");
            b.statement("this.parseBytecodes = parseBytecodes");
            b.statement("this.tags = tags");
            b.statement("this.instrumentations = instrumentations");
            b.statement("this.parseSources = parseSources");
            b.statement("this.sources = parseSources ? new ArrayList<>(4) : null");
            b.statement("this.builtNodes = new ArrayList<>()");
            b.statement("this.operationStack = new OperationStackEntry[8]");
            b.statement("this.rootOperationSp = -1");
            return ctor;
        }

        private CodeExecutableElement createParseConstructor() {
            CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, "Builder", new CodeVariableElement[0]);
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.model.languageClass, "language"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "nodes"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeConfig, "config"));
            CodeTreeBuilder javadoc = ctor.createDocBuilder();
            javadoc.startJavadoc();
            javadoc.string("Constructor for initial parses.");
            javadoc.newLine();
            javadoc.end();
            CodeTreeBuilder b = ctor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.statement("this.language = language");
            b.statement("this.nodes = nodes");
            b.statement("this.reparseReason = null");
            b.statement("long encoding = BytecodeConfigEncoderImpl.decode(config)");
            b.statement("this.tags = (int)((encoding >> 32) & 0xFFFF_FFFF)");
            b.statement("this.instrumentations = (int)((encoding >> 1) & 0x7FFF_FFFF)");
            b.statement("this.parseSources = (encoding & 0x1) != 0");
            b.statement("this.parseBytecodes = true");
            b.statement("this.sources = parseSources ? new ArrayList<>(4) : null");
            b.statement("this.builtNodes = new ArrayList<>()");
            b.statement("this.operationStack = new OperationStackEntry[8]");
            b.statement("this.rootOperationSp = -1");
            return ctor;
        }

        private boolean omitBuilderMethods(OperationModel operation) {
            return BytecodeRootNodeElement.this.model.prolog != null && BytecodeRootNodeElement.this.model.prolog.operation == operation || BytecodeRootNodeElement.this.model.epilogExceptional != null && BytecodeRootNodeElement.this.model.epilogExceptional.operation == operation;
        }

        private CodeExecutableElement createMarkReachable() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "markReachable", new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "newReachable"));
            CodeTreeBuilder b = method.createBuilder();
            b.statement("this.reachable = newReachable");
            b.startTryBlock();
            this.buildOperationStackWalk(b, () -> {
                b.declaration(this.operationStackEntry.asType(), "operation", "operationStack[i]");
                b.startSwitch().string("operation.operation").end().startBlock();
                for (OperationModel op : BytecodeRootNodeElement.this.model.getOperations()) {
                    switch (op.kind) {
                        case ROOT: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.statement("operationData.reachable = newReachable");
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case IF_THEN: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.lineComment("Unreachable condition branch makes the if and parent block unreachable.");
                            b.statement("operationData.thenReachable = newReachable");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("operationData.thenReachable = newReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case IF_THEN_ELSE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.lineComment("Unreachable condition branch makes the if, then and parent block unreachable.");
                            b.statement("operationData.thenReachable = newReachable");
                            b.statement("operationData.elseReachable = newReachable");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("operationData.thenReachable = newReachable");
                            b.end().startElseIf().string("operation.childCount == 2").end().startBlock();
                            b.statement("operationData.elseReachable = newReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case CONDITIONAL: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.lineComment("Unreachable condition branch makes the if, then and parent block unreachable.");
                            b.statement("operationData.thenReachable = newReachable");
                            b.statement("operationData.elseReachable = newReachable");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("operationData.thenReachable = newReachable");
                            b.end().startElseIf().string("operation.childCount == 2").end().startBlock();
                            b.statement("operationData.elseReachable = newReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case TRY_CATCH: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("operationData.tryReachable = newReachable");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("operationData.catchReachable = newReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case WHILE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("operationData.bodyReachable = newReachable");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("operationData.bodyReachable = newReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                            break;
                        }
                        case TRY_FINALLY: 
                        case TRY_CATCH_OTHERWISE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("operationData.tryReachable = newReachable");
                            if (op.kind == OperationModel.OperationKind.TRY_CATCH_OTHERWISE) {
                                b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                                b.statement("operationData.catchReachable = newReachable");
                            }
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return");
                            b.end();
                        }
                    }
                }
                b.end();
            });
            b.end().startFinallyBlock();
            b.startAssert().string("updateReachable() == this.reachable : ").doubleQuote("Inconsistent reachability detected.").end();
            b.end();
            return method;
        }

        private CodeExecutableElement createUpdateReachable() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Boolean.TYPE), "updateReachable", new CodeVariableElement[0]);
            CodeTreeBuilder doc = method.createDocBuilder();
            doc.startJavadoc();
            doc.string("Updates the reachable field from the current operation. Typically invoked when the operation ended or the child is changing.");
            doc.newLine();
            doc.end();
            CodeTreeBuilder b = method.createBuilder();
            b.statement("boolean oldReachable = reachable");
            this.buildOperationStackWalk(b, () -> {
                b.declaration(this.operationStackEntry.asType(), "operation", "operationStack[i]");
                b.startSwitch().string("operation.operation").end().startBlock();
                for (OperationModel op : BytecodeRootNodeElement.this.model.getOperations()) {
                    switch (op.kind) {
                        case ROOT: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.statement("this.reachable = operationData.reachable");
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case IF_THEN: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("this.reachable = operationData.thenReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case IF_THEN_ELSE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.lineComment("Unreachable condition branch makes the if, then and parent block unreachable.");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("this.reachable = operationData.thenReachable");
                            b.end().startElseIf().string("operation.childCount == 2").end().startBlock();
                            b.statement("this.reachable = operationData.elseReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case CONDITIONAL: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.lineComment("Unreachable condition branch makes the if, then and parent block unreachable.");
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("this.reachable = operationData.thenReachable");
                            b.end().startElseIf().string("operation.childCount == 2").end().startBlock();
                            b.statement("this.reachable = operationData.elseReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case TRY_CATCH: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("this.reachable = operationData.tryReachable");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("this.reachable = operationData.catchReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case WHILE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("continue");
                            b.end().startElseIf().string("operation.childCount == 1").end().startBlock();
                            b.statement("this.reachable = operationData.bodyReachable");
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                            break;
                        }
                        case TRY_FINALLY: 
                        case TRY_CATCH_OTHERWISE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            this.emitCastOperationData(b, op, "i");
                            b.startIf().string("operation.childCount == 0").end().startBlock();
                            b.statement("this.reachable = operationData.tryReachable");
                            if (op.kind == OperationModel.OperationKind.TRY_CATCH_OTHERWISE) {
                                b.end().startElseIf().string("operation.childCount == 2").end().startBlock();
                                b.statement("this.reachable = operationData.catchReachable");
                            }
                            b.end().startElseBlock();
                            b.lineComment("Invalid child index, but we will fail in the end method.");
                            b.end();
                            b.statement("return oldReachable");
                            b.end();
                        }
                    }
                }
                b.end();
            });
            b.statement("return oldReachable");
            return method;
        }

        private CodeExecutableElement createSerialize() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "serialize", new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(DataOutput.class), "buffer"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeSerializer, "callback"));
            DeclaredType nodeList = ElementHelpers.generic(List.class, BytecodeRootNodeElement.this.model.getTemplateType().asType());
            CodeVariableElement existingNodes = new CodeVariableElement(nodeList, "existingNodes");
            method.addParameter(existingNodes);
            method.addThrownType(BytecodeRootNodeElement.this.type(IOException.class));
            CodeTreeBuilder b = method.createBuilder();
            b.statement("this.serialization = new SerializationState(buffer, callback)");
            b.startTryBlock();
            if (BytecodeRootNodeElement.this.model.serializedFields.size() == 0) {
                b.startStatement().startCall("nodes.getParserImpl()", "parse").string("this").end(2);
                this.serializationElements.writeShort(b, this.serializationElements.codeEndSerialize);
            } else {
                int i;
                b.lineComment("1. Serialize the root nodes and their constants.");
                b.startStatement().startCall("nodes.getParserImpl()", "parse").string("this").end(2);
                b.lineComment("2. Serialize the fields stored on each root node. If existingNodes is provided, serialize those fields instead of the new root nodes' fields.");
                b.declaration((TypeMirror)nodeList, "nodesToSerialize", "existingNodes != null ? existingNodes : serialization.builtNodes");
                b.statement("int[][] nodeFields = new int[nodesToSerialize.size()][]");
                b.startFor().string("int i = 0; i < nodeFields.length; i ++").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.model.getTemplateType().asType(), "node", "nodesToSerialize.get(i)");
                b.statement("int[] fields = nodeFields[i] = new int[" + BytecodeRootNodeElement.this.model.serializedFields.size() + "]");
                for (i = 0; i < BytecodeRootNodeElement.this.model.serializedFields.size(); ++i) {
                    VariableElement var = BytecodeRootNodeElement.this.model.serializedFields.get(i);
                    b.startStatement();
                    b.string("fields[").string(i).string("] = ");
                    b.startCall("serialization.serializeObject");
                    b.startGroup();
                    b.string("node.").string(var.getSimpleName().toString());
                    b.end();
                    b.end();
                    b.end();
                }
                b.end();
                this.serializationElements.writeShort(b, this.serializationElements.codeEndSerialize);
                b.lineComment("3. Encode the constant pool indices for each root node's fields.");
                b.startFor().string("int i = 0; i < nodeFields.length; i++").end().startBlock();
                b.statement("int[] fields = nodeFields[i]");
                for (i = 0; i < BytecodeRootNodeElement.this.model.serializedFields.size(); ++i) {
                    this.serializationElements.writeInt(b, "fields[" + i + "]");
                }
                b.end();
            }
            b.end().startFinallyBlock();
            b.statement("this.serialization = null");
            b.end();
            return method;
        }

        private CodeExecutableElement createSerializeFinallyGenerator() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Short.TYPE), "serializeFinallyGenerator", new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.declaredType(Runnable.class), "finallyGenerator"));
            method.addThrownType(BytecodeRootNodeElement.this.declaredType(IOException.class));
            CodeTreeBuilder b = method.getBuilder();
            b.startDeclaration(BytecodeRootNodeElement.this.declaredType(ByteArrayOutputStream.class), "baos");
            b.startNew(BytecodeRootNodeElement.this.declaredType(ByteArrayOutputStream.class)).end();
            b.end();
            b.declaration(this.serializationElements.asType(), "outerSerialization", "serialization");
            b.startTryBlock();
            b.startAssign("serialization").startNew(this.serializationElements.asType());
            b.startNew(BytecodeRootNodeElement.this.declaredType(DataOutputStream.class)).string("baos").end();
            b.string("serialization");
            b.end(2);
            b.statement("finallyGenerator.run()");
            this.serializationElements.writeShort(b, this.serializationElements.codeEndFinallyGenerator);
            b.end();
            b.startFinallyBlock();
            b.statement("serialization = outerSerialization");
            b.end();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bytes", "baos.toByteArray()");
            this.serializationElements.writeShort(b, this.serializationElements.codeCreateFinallyGenerator);
            this.serializationElements.writeInt(b, "bytes.length");
            this.serializationElements.writeBytes(b, "bytes");
            b.startReturn().string(BytecodeRootNodeElement.safeCastShort("serialization.finallyGeneratorCount++")).end();
            return method;
        }

        private CodeExecutableElement createDeserialize() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "deserialize", new CodeVariableElement[0]);
            GeneratorUtils.mergeSuppressWarnings(method, "hiding");
            method.addParameter(new CodeVariableElement(ElementHelpers.generic(Supplier.class, DataInput.class), "bufferSupplier"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeDeserializer, "callback"));
            method.addParameter(new CodeVariableElement(this.deserializationElement.asType(), "outerContext"));
            CodeTreeBuilder b = method.createBuilder();
            b.startTryBlock();
            b.startDeclaration(this.deserializationElement.asType(), "context");
            b.startNew(this.deserializationElement.asType()).string("outerContext").end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(DataInput.class), "buffer", "bufferSupplier.get()");
            b.startWhile().string("true").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "code", "buffer.readShort()");
            b.startSwitch().string("code").end().startBlock();
            b.startCase().staticReference(this.serializationElements.codeCreateLabel).end().startBlock();
            b.statement("context.labels.add(createLabel())");
            b.statement("break");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeCreateLocal).end().startBlock();
            b.statement("int nameId = buffer.readInt()");
            b.statement("Object name = null");
            b.startIf().string("nameId != -1").end().startBlock();
            b.statement("name = context.consts.get(nameId)");
            b.end();
            b.statement("int infoId = buffer.readInt()");
            b.statement("Object info = null");
            b.startIf().string("infoId != -1").end().startBlock();
            b.statement("info = context.consts.get(infoId)");
            b.end();
            b.statement("context.locals.add(createLocal(name, info))");
            b.statement("break");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeCreateNull).end().startBlock();
            b.startStatement();
            b.startCall("context.consts.add");
            b.string("null");
            b.end();
            b.end();
            b.statement("break");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeCreateObject).end().startBlock();
            b.startStatement();
            b.startCall("context.consts.add");
            b.startStaticCall(BytecodeRootNodeElement.this.type(Objects.class), "requireNonNull");
            b.string("callback.deserialize(context, buffer)");
            b.end();
            b.end();
            b.end();
            b.statement("break");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeCreateFinallyGenerator).end().startBlock();
            b.statement("byte[] finallyGeneratorBytes = new byte[buffer.readInt()]");
            b.statement("buffer.readFully(finallyGeneratorBytes)");
            b.startStatement().startCall("context.finallyGenerators.add");
            b.startGroup().string("() -> ").startCall("deserialize");
            b.startGroup().string("() -> ").startStaticCall(BytecodeRootNodeElement.this.types.SerializationUtils, "createDataInput");
            b.startStaticCall(BytecodeRootNodeElement.this.declaredType(ByteBuffer.class), "wrap").string("finallyGeneratorBytes").end();
            b.end(2);
            b.string("callback");
            b.string("context");
            b.end(2);
            b.end(2);
            b.statement("break");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeEndFinallyGenerator).end().startBlock();
            b.statement("return");
            b.end();
            b.startCase().staticReference(this.serializationElements.codeEndSerialize).end().startBlock();
            if (BytecodeRootNodeElement.this.model.serializedFields.size() != 0) {
                b.startFor().string("int i = 0; i < this.builtNodes.size(); i++").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.asType(), "node", "this.builtNodes.get(i)");
                for (int i = 0; i < BytecodeRootNodeElement.this.model.serializedFields.size(); ++i) {
                    VariableElement var = BytecodeRootNodeElement.this.model.serializedFields.get(i);
                    b.startStatement();
                    b.string("node.").string(var.getSimpleName().toString());
                    b.string(" = ");
                    if (ElementUtils.needsCastTo(BytecodeRootNodeElement.this.type(Object.class), var.asType())) {
                        b.cast(var.asType());
                    }
                    b.string("context.consts.get(buffer.readInt())");
                    b.end();
                }
                b.end();
            }
            b.returnStatement();
            b.end();
            boolean hasTags = !BytecodeRootNodeElement.this.model.getProvidedTags().isEmpty();
            for (OperationModel operation : BytecodeRootNodeElement.this.model.getUserOperations()) {
                b.startCase().staticReference(this.serializationElements.codeBegin[operation.id]).end().startBlock();
                if (operation.kind == OperationModel.OperationKind.TAG && !hasTags) {
                    b.startThrow().startNew(BytecodeRootNodeElement.this.type(IllegalStateException.class));
                    b.doubleQuote(String.format("Cannot deserialize instrument tag. The language does not specify any tags with a @%s annotation.", ElementUtils.getSimpleName(BytecodeRootNodeElement.this.types.ProvidedTags)));
                    b.end().end();
                    b.end();
                    continue;
                }
                if (operation.kind == OperationModel.OperationKind.ROOT) {
                    b.statement("context.builtNodes.add(null)");
                }
                for (OperationModel.OperationArgument beginArgument : operation.operationBeginArguments) {
                    this.buildDeserializeOperationArgument(b, beginArgument);
                }
                b.startStatement();
                if (operation.hasChildren()) {
                    b.startCall("begin" + operation.name);
                } else {
                    b.startCall("emit" + operation.name);
                }
                for (int i = 0; i < operation.operationBeginArguments.length; ++i) {
                    b.string(operation.getOperationBeginArgumentName(i));
                }
                b.end(2);
                b.statement("break");
                b.end();
                if (!operation.hasChildren()) continue;
                b.startCase().staticReference(this.serializationElements.codeEnd[operation.id]).end().startBlock();
                for (OperationModel.OperationArgument endArgument : operation.operationEndArguments) {
                    this.buildDeserializeOperationArgument(b, endArgument);
                }
                if (operation.kind == OperationModel.OperationKind.ROOT) {
                    b.startStatement();
                    b.type(BytecodeRootNodeElement.this.asType()).string(" node = ").cast(BytecodeRootNodeElement.this.asType()).string("end" + operation.name + "()");
                    b.end();
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "serializedContextDepth", "buffer.readInt()");
                    b.startIf().string("context.").variable(this.deserializationElement.depth).string(" != serializedContextDepth").end().startBlock();
                    b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class));
                    b.startGroup();
                    b.doubleQuote("Invalid context depth. Expected ").string(" + context.").variable(this.deserializationElement.depth).string(" + ");
                    b.doubleQuote(" but got ").string(" + serializedContextDepth");
                    b.end();
                    b.end(2);
                    b.end();
                    b.startStatement().startCall("context.builtNodes.set").string("buffer.readInt()").string("node").end().end();
                } else {
                    b.startStatement().startCall("end" + operation.name);
                    for (int i = 0; i < operation.operationEndArguments.length; ++i) {
                        b.string(operation.getOperationEndArgumentName(i));
                    }
                    b.end(2);
                }
                b.statement("break");
                b.end();
            }
            b.caseDefault().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class));
            b.startGroup();
            b.doubleQuote("Unknown operation code ").string(" + code");
            b.end();
            b.end().end();
            b.end();
            b.end();
            b.end();
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.type(IOException.class), "ex");
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IOError.class)).string("ex").end(2);
            b.end();
            return method;
        }

        private void buildSerializeOperationArgument(CodeTreeBuilder before, CodeTreeBuilder after, OperationModel.OperationArgument argument) {
            String argumentName = argument.name();
            switch (argument.kind()) {
                case LANGUAGE: {
                    before.statement("serialization.language = language");
                    break;
                }
                case LOCAL: {
                    String serializationLocalCls = this.serializationLocal.getSimpleName().toString();
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort(String.format("((%s) %s).contextDepth", serializationLocalCls, argumentName)));
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort(String.format("((%s) %s).localIndex", serializationLocalCls, argumentName)));
                    break;
                }
                case LOCAL_ARRAY: {
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort(argumentName + ".length"));
                    String depth = argumentName + "Depth";
                    after.startIf().string(argumentName, ".length > 0").end().startBlock();
                    after.startDeclaration(BytecodeRootNodeElement.this.type(Short.TYPE), depth);
                    after.startCall("safeCastShort");
                    after.startGroup();
                    after.startParantheses().cast(this.serializationLocal.asType()).string(argumentName, "[0]").end();
                    after.string(".contextDepth");
                    after.end(3);
                    this.serializationElements.writeShort(after, depth);
                    after.startFor().string("int i = 0; i < " + argumentName + ".length; i++").end().startBlock();
                    after.startDeclaration(this.serializationLocal.asType(), "localImpl");
                    after.cast(this.serializationLocal.asType()).string(argumentName, "[i]");
                    after.end();
                    after.startAssert().string(depth, " == ", BytecodeRootNodeElement.safeCastShort("localImpl.contextDepth")).end();
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort("localImpl.localIndex"));
                    after.end();
                    after.end();
                    break;
                }
                case LABEL: {
                    String serializationLabelCls = this.serializationLabel.getSimpleName().toString();
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort(String.format("((%s) %s).contextDepth", serializationLabelCls, argumentName)));
                    this.serializationElements.writeShort(after, BytecodeRootNodeElement.safeCastShort(String.format("((%s) %s).labelIndex", serializationLabelCls, argumentName)));
                    break;
                }
                case TAGS: {
                    this.serializationElements.writeInt(after, "encodedTags");
                    break;
                }
                case SHORT: {
                    this.serializationElements.writeShort(after, argumentName);
                    break;
                }
                case INTEGER: {
                    this.serializationElements.writeInt(after, argumentName);
                    break;
                }
                case OBJECT: {
                    String index = argumentName + "_index";
                    before.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), index);
                    before.startCall("serialization.serializeObject").string(argumentName).end();
                    before.end();
                    this.serializationElements.writeInt(after, index);
                    break;
                }
                case FINALLY_GENERATOR: {
                    String index = "finallyGeneratorIndex";
                    before.startDeclaration(BytecodeRootNodeElement.this.type(Short.TYPE), index);
                    before.startCall("serializeFinallyGenerator");
                    before.string(argumentName);
                    before.end(2);
                    this.serializationElements.writeShort(after, "serialization.depth");
                    this.serializationElements.writeShort(after, index);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected argument kind " + String.valueOf((Object)argument.kind())));
                }
            }
        }

        private void buildDeserializeOperationArgument(CodeTreeBuilder b, OperationModel.OperationArgument argument) {
            TypeMirror argType = argument.builderType();
            String argumentName = argument.name();
            switch (argument.kind()) {
                case LANGUAGE: {
                    break;
                }
                case LOCAL: {
                    b.declaration(argType, argumentName, "context.getContext(buffer.readShort()).locals.get(buffer.readShort())");
                    break;
                }
                case LABEL: {
                    b.declaration(argType, argumentName, "context.getContext(buffer.readShort()).labels.get(buffer.readShort())");
                    break;
                }
                case TAGS: {
                    b.declaration(argType, argumentName, "TAG_MASK_TO_TAGS.computeIfAbsent(buffer.readInt(), (v) -> mapTagMaskToTagsArray(v))");
                    break;
                }
                case SHORT: {
                    b.declaration(argType, argumentName, "buffer.readShort()");
                    break;
                }
                case INTEGER: {
                    b.declaration(argType, argumentName, "buffer.readInt()");
                    break;
                }
                case LOCAL_ARRAY: {
                    b.startDeclaration(argType, argumentName).startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.BytecodeLocal), CodeTreeBuilder.singleString("buffer.readShort()")).end().end();
                    b.startIf().string(argumentName, ".length != 0").end().startBlock();
                    b.declaration(this.deserializationElement.asType(), "setterContext", "context.getContext(buffer.readShort())");
                    b.startFor().string("int i = 0; i < ", argumentName, ".length; i++").end().startBlock();
                    b.statement(argumentName, "[i] = setterContext.locals.get(buffer.readShort())");
                    b.end();
                    b.end();
                    break;
                }
                case OBJECT: {
                    b.startDeclaration(argType, argumentName);
                    if (!ElementUtils.isObject(argType)) {
                        b.cast(argType);
                    }
                    b.string("context.consts.get(buffer.readInt())");
                    b.end();
                    break;
                }
                case FINALLY_GENERATOR: {
                    b.startDeclaration(argType, argumentName);
                    b.string("context.getContext(buffer.readShort()).finallyGenerators.get(buffer.readShort())");
                    b.end();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected argument kind " + String.valueOf((Object)argument.kind())));
                }
            }
        }

        private CodeExecutableElement createFinish() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "finish", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("operationSp != 0").end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("Unexpected parser end - there are still operations on the stack. Did you forget to end them?").end().end();
            b.end();
            b.startIf().string("reparseReason == null").end().startBlock();
            b.startStatement().string("nodes.setNodes(builtNodes.toArray(new ").type(BytecodeRootNodeElement.this.asType()).string("[0]))").end();
            b.end();
            b.statement("assert nodes.validate()");
            return ex;
        }

        private CodeExecutableElement createCreateLocal() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.types.BytecodeLocal, "createLocal", new CodeVariableElement[0]);
            BytecodeRootNodeElement.addJavadoc(ex, "Creates a new local. Uses default values for the local's metadata.");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startCall("createLocal");
            b.string("null");
            b.string("null");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createCreateLocalAllParameters() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.types.BytecodeLocal, "createLocal", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "name"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "info"));
            BytecodeRootNodeElement.addJavadoc(ex, "Creates a new local. Uses the given {@code name} and {@code info} in its local metadata.\n\n@param name the name assigned to the local's slot.\n@param info the info assigned to the local's slot.\n@see BytecodeNode#getLocalNames\n@see BytecodeNode#getLocalInfos\n");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                b.startIf().string("serialization != null").end().startBlock();
                BytecodeRootNodeElement.this.serializationWrapException(b, () -> {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId");
                    b.startIf().string("name != null").end().startBlock();
                    b.statement("nameId = serialization.serializeObject(name)");
                    b.end().startElseBlock();
                    b.statement("nameId = -1");
                    b.end();
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId");
                    b.startIf().string("info != null").end().startBlock();
                    b.statement("infoId = serialization.serializeObject(info)");
                    b.end().startElseBlock();
                    b.statement("infoId = -1");
                    b.end();
                    this.serializationElements.writeShort(b, this.serializationElements.codeCreateLocal);
                    this.serializationElements.writeInt(b, "nameId");
                    this.serializationElements.writeInt(b, "infoId");
                });
                b.startReturn().startNew(this.serializationLocal.asType());
                b.string("serialization.depth");
                b.string("serialization.localCount++");
                b.end(2);
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                TypeMirror scopeType = this.scopeDataType.asType();
                b.declaration(scopeType, "scope", "getCurrentScope()");
                b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "localIndex", "allocateBytecodeLocal() /* unique global index */");
                b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "frameIndex", BytecodeRootNodeElement.safeCastShort("USER_LOCALS_START_INDEX + scope.frameOffset + scope.numLocals") + " /* location in frame */");
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableIndex", "doEmitLocal(localIndex, frameIndex, name, info) /* index in global table */");
                b.statement("scope.registerLocal(tableIndex)");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "localIndex", "allocateBytecodeLocal() /* unique global index */");
                b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "frameIndex", BytecodeRootNodeElement.safeCastShort("USER_LOCALS_START_INDEX + localIndex") + " /* location in frame */");
                b.statement("doEmitLocal(name, info)");
            }
            b.startDeclaration(this.bytecodeLocalImpl.asType(), "local");
            b.startNew(this.bytecodeLocalImpl.asType()).string("frameIndex");
            b.string("localIndex");
            b.string("((RootData) operationStack[this.rootOperationSp].data).index");
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.string("scope");
            }
            b.end();
            b.end();
            b.startReturn().string("local").end();
            return ex;
        }

        private CodeExecutableElement createGetCurrentScope() {
            TypeMirror scopeType = this.scopeDataType.asType();
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), scopeType, "getCurrentScope", new CodeVariableElement[0]);
            CodeTreeBuilder b = method.createBuilder();
            this.buildOperationStackWalk(b, () -> {
                b.startIf().string("operationStack[i].data instanceof ").type(scopeType).string(" e").end().startBlock();
                b.statement("return e");
                b.end();
            });
            b.startThrow().startCall("failState").doubleQuote("Invalid scope for local variable.").end().end();
            return method;
        }

        private CodeExecutableElement createCreateLabel() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.types.BytecodeLabel, "createLabel", new CodeVariableElement[0]);
            BytecodeRootNodeElement.addJavadoc(ex, "Creates a new label. The result should be {@link #emitLabel emitted} and can be {@link #emitBranch branched to}.");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                b.startIf().string("serialization != null").end().startBlock();
                BytecodeRootNodeElement.this.serializationWrapException(b, () -> this.serializationElements.writeShort(b, this.serializationElements.codeCreateLabel));
                b.startReturn().startNew(this.serializationLabel.asType());
                b.string(this.serialization.getName(), ".", this.serializationElements.depth.getName());
                b.string(this.serialization.getName(), ".", this.serializationElements.labelCount.getName(), "++");
                b.end(2);
                b.end();
            }
            b.startIf();
            b.string("operationSp == 0 || (operationStack[operationSp - 1].operation != ").tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.blockOperation));
            b.string(" && operationStack[operationSp - 1].operation != ").tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.rootOperation)).string(")");
            b.end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("Labels must be created inside either Block or Root operations.").end().end();
            b.end();
            b.startAssign("BytecodeLabel result").startNew(this.bytecodeLabelImpl.asType());
            b.string("numLabels++");
            b.string(UNINIT);
            b.string("operationStack[operationSp - 1].sequenceNumber");
            b.end(2);
            b.statement("operationStack[operationSp - 1].addDeclaredLabel(result)");
            b.startReturn().string("result").end();
            return ex;
        }

        private List<CodeExecutableElement> createSourceSectionUnavailableHelpers() {
            CodeExecutableElement begin = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "beginSourceSectionUnavailable", new CodeVariableElement[0]);
            BytecodeRootNodeElement.addJavadoc(begin, "Begins a built-in SourceSection operation with an unavailable source section.\n\n@see #beginSourceSection(int, int)\n@see #endSourceSectionUnavailable()\n");
            begin.createBuilder().statement("beginSourceSection(-1, -1)");
            CodeExecutableElement end = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "endSourceSectionUnavailable", new CodeVariableElement[0]);
            BytecodeRootNodeElement.addJavadoc(end, "Ends a built-in SourceSection operation with an unavailable source section.\n\n@see #endSourceSection()\n@see #beginSourceSectionUnavailable()\n");
            end.createBuilder().statement("endSourceSection()");
            return List.of(begin, end);
        }

        private CodeExecutableElement createRegisterUnresolvedLabel() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "registerUnresolvedLabel", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLabel, "label"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "immediateBci"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(ArrayList.class), (TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(Integer.class)), "locations", "unresolvedLabels.computeIfAbsent(label, k -> new ArrayList<>())");
            b.startStatement().startCall("locations.add");
            b.string("immediateBci");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createResolveUnresolvedLabel() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "resolveUnresolvedLabel", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLabel, "label"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "stackHeight"));
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("BytecodeLabelImpl impl = (BytecodeLabelImpl) label");
            b.statement("assert !impl.isDefined()");
            b.statement("impl.bci = bci");
            b.declaration((TypeMirror)ElementHelpers.generic(List.class, (TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(Integer.class)), "sites", "unresolvedLabels.remove(impl)");
            b.startIf().string("sites != null").end().startBlock();
            b.startFor().startGroup().type(BytecodeRootNodeElement.this.context.getDeclaredType(Integer.class)).string(" site : sites").end(2).startBlock();
            b.statement(BytecodeRootNodeElement.writeInt("bc", "site", "impl.bci"));
            b.end(2);
            return ex;
        }

        private CodeVariableElement createOperationNames() {
            CodeVariableElement fld = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(String[].class), "OPERATION_NAMES");
            CodeTreeBuilder b = fld.createInitBuilder();
            b.startNewArray((ArrayType)BytecodeRootNodeElement.this.type(String[].class), null);
            b.string("null");
            int i = 1;
            for (OperationModel op : BytecodeRootNodeElement.this.model.getOperations()) {
                if (op.id != i) {
                    throw new AssertionError();
                }
                ++i;
                b.doubleQuote(op.name);
            }
            b.end();
            return fld;
        }

        private CodeExecutableElement createBeginOperation() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "beginOperation", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "id"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "data"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("operationSp == operationStack.length").end().startBlock();
            b.startAssign("operationStack").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
            b.string("operationStack");
            b.string("operationStack.length * 2");
            b.end(2);
            b.end();
            b.startAssign("operationStack[operationSp++]").startNew(this.operationStackEntry.asType());
            b.string("id");
            b.string("data");
            b.string("operationSequenceNumber++");
            b.end(2);
            return ex;
        }

        private static String getBuilderMethodJavadocHeader(String action, OperationModel operation) {
            StringBuilder sb;
            block5: {
                block4: {
                    sb = new StringBuilder(action);
                    if (!operation.isCustom()) break block4;
                    sb.append(" a custom ");
                    switch (operation.kind) {
                        case CUSTOM: 
                        case CUSTOM_INSTRUMENTATION: {
                            CustomOperationModel customOp = operation.parent.getCustomOperationForOperation(operation);
                            sb.append("{@link ");
                            sb.append(customOp.getTemplateType().getQualifiedName());
                            sb.append(" ");
                            sb.append(operation.name);
                            sb.append("}");
                            break block5;
                        }
                        case CUSTOM_SHORT_CIRCUIT: {
                            sb.append(operation.name);
                            break block5;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected operation kind for operation " + String.valueOf(operation)));
                        }
                    }
                }
                sb.append(" a built-in ");
                sb.append(operation.name);
            }
            sb.append(" operation.");
            return sb.toString();
        }

        private static String getOperationSignatureJavadoc(OperationModel operation) {
            StringBuilder result = new StringBuilder();
            result.append("Signature: ");
            result.append(operation.name);
            result.append("(");
            boolean first = true;
            for (DynamicOperandModel dynamicOperand : operation.dynamicOperands) {
                if (!first) {
                    result.append(", ");
                }
                first = false;
                boolean firstOperandName = true;
                for (String operandName : dynamicOperand.names()) {
                    if (!firstOperandName) {
                        result.append("|");
                    }
                    firstOperandName = false;
                    result.append(operandName);
                }
                if (!dynamicOperand.isVariadic()) continue;
                result.append("...");
            }
            result.append(")");
            if (operation.kind != OperationModel.OperationKind.ROOT) {
                if (operation.isTransparent) {
                    result.append(" -> void/Object");
                } else if (operation.isVoid || operation.kind == OperationModel.OperationKind.RETURN) {
                    result.append(" -> void");
                } else if (operation.isCustom()) {
                    result.append(" -> ");
                    result.append(ElementUtils.getSimpleName(operation.instruction.signature.returnType));
                } else {
                    result.append(" -> Object");
                }
            }
            return result.toString();
        }

        private void addBeginOrEmitOperationDoc(OperationModel operation, CodeExecutableElement ex) {
            ArrayList<String> lines = new ArrayList<String>(1);
            if (operation.hasChildren()) {
                lines.add(BuilderElement.getBuilderMethodJavadocHeader("Begins", operation));
            } else {
                lines.add(BuilderElement.getBuilderMethodJavadocHeader("Emits", operation));
            }
            lines.add("<p>");
            lines.add(BuilderElement.getOperationSignatureJavadoc(operation));
            if (operation.javadoc != null && !operation.javadoc.isBlank()) {
                lines.add("<p>");
                for (String line : operation.javadoc.strip().split("\n")) {
                    lines.add(line);
                }
            }
            if (operation.hasChildren()) {
                lines.add("<p>");
                lines.add("A corresponding call to {@link #end" + operation.name + "} is required to end the operation.");
            }
            if (operation.operationBeginArguments.length != 0) {
                lines.add(" ");
                for (OperationModel.OperationArgument argument : operation.operationBeginArguments) {
                    lines.add(argument.toJavadocParam());
                }
            }
            BytecodeRootNodeElement.addJavadoc(ex, lines);
        }

        private void addEndOperationDoc(OperationModel operation, CodeExecutableElement ex) {
            if (!operation.hasChildren()) {
                throw new AssertionError((Object)"tried generating end method for operation with no children");
            }
            ArrayList<String> lines = new ArrayList<String>(1);
            lines.add(BuilderElement.getBuilderMethodJavadocHeader("Ends", operation));
            lines.add("<p>");
            lines.add(BuilderElement.getOperationSignatureJavadoc(operation));
            if (operation.kind == OperationModel.OperationKind.TAG) {
                lines.add("<p>");
                lines.add("The tags passed to this method should match the ones used in the corresponding {@link #beginTag} call.");
            }
            lines.add(" ");
            if (operation.operationEndArguments.length != 0) {
                for (OperationModel.OperationArgument argument : operation.operationEndArguments) {
                    lines.add(argument.toJavadocParam());
                }
            }
            lines.add("@see #begin" + operation.name);
            BytecodeRootNodeElement.addJavadoc(ex, lines);
        }

        private void addBeginRootOperationDoc(OperationModel rootOperation, CodeExecutableElement ex) {
            if (rootOperation.kind != OperationModel.OperationKind.ROOT) {
                throw new AssertionError((Object)"tried generating beginRoot doc for non-root operation");
            }
            ArrayList<String> lines = new ArrayList<String>(2);
            lines.add("Begins a new root node.");
            lines.add("<p>");
            lines.add(BuilderElement.getOperationSignatureJavadoc(rootOperation));
            lines.add("<p>");
            for (String string : rootOperation.javadoc.strip().split("\n")) {
                lines.add(string);
            }
            lines.add(" ");
            for (OperationModel.OperationArgument operationArgument : rootOperation.operationBeginArguments) {
                lines.add(operationArgument.toJavadocParam());
            }
            if (BytecodeRootNodeElement.this.model.prolog != null && BytecodeRootNodeElement.this.model.prolog.operation.operationBeginArguments.length != 0) {
                for (OperationModel.OperationArgument operationArgument : BytecodeRootNodeElement.this.model.prolog.operation.operationBeginArguments) {
                    lines.add(operationArgument.toJavadocParam());
                }
            }
            BytecodeRootNodeElement.addJavadoc(ex, lines);
        }

        private CodeExecutableElement createBegin(OperationModel operation) {
            CodeTree operationData;
            VariableElement tagConstants;
            if (operation.kind == OperationModel.OperationKind.ROOT) {
                return this.createBeginRoot(operation);
            }
            Modifier visibility = operation.isInternal ? Modifier.PRIVATE : Modifier.PUBLIC;
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(visibility), BytecodeRootNodeElement.this.type(Void.TYPE), "begin" + operation.name, new CodeVariableElement[0]);
            for (OperationModel.OperationArgument arg : operation.operationBeginArguments) {
                ex.addParameter(arg.toVariableElement());
            }
            ex.setVarArgs(operation.operationBeginArgumentVarArgs);
            this.addBeginOrEmitOperationDoc(operation, ex);
            CodeTreeBuilder b = ex.createBuilder();
            if (operation.kind == OperationModel.OperationKind.TAG) {
                b.startIf().string("newTags.length == 0").end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("The tags parameter for beginTag must not be empty. Please specify at least one tag.").end().end();
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "encodedTags", "encodeTags(newTags)");
                b.startIf().string("(encodedTags & this.tags) == 0").end().startBlock();
                b.returnStatement();
                b.end();
            } else if (operation.isSourceOnly()) {
                b.startIf().string("!parseSources").end().startBlock();
                b.returnStatement();
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.enableSerialization && !operation.isInternal) {
                b.startIf().string("serialization != null").end().startBlock();
                this.createSerializeBegin(operation, b);
                b.statement("return");
                b.end();
            }
            if (operation.requiresRootOperation()) {
                b.startStatement().startCall("validateRootOperationBegin").end(2);
            }
            if (operation.constantOperands != null && operation.constantOperands.hasConstantOperands()) {
                int index = 0;
                for (ConstantOperandModel operand : operation.constantOperands.before()) {
                    this.buildConstantOperandValidation(b, operand.type(), operation.getOperationBeginArgumentName(index++));
                }
            }
            List<String> constantOperandIndices = this.emitConstantBeginOperands(b, operation);
            if (operation.kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) {
                int mask = 1 << operation.instrumentationIndex;
                b.startIf().string("(instrumentations & ").string("0x", Integer.toHexString(mask)).string(") == 0").end().startBlock();
                b.returnStatement();
                b.end();
            }
            if (operation.isCustom() && !operation.customModel.implicitTags.isEmpty() && (tagConstants = this.lookupTagConstant(operation.customModel.implicitTags)) != null) {
                this.buildBegin(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants.getSimpleName().toString());
            }
            if (operation.kind == OperationModel.OperationKind.TAG) {
                b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "node", "new TagNode(encodedTags & this.tags, bci)");
                b.startIf().string("tagNodes == null").end().startBlock();
                b.statement("tagNodes = new ArrayList<>()");
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeId", "tagNodes.size()");
                b.statement("tagNodes.add(node)");
            }
            switch (operation.kind) {
                case ROOT: 
                case BLOCK: {
                    if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                    b.declaration(this.scopeDataType.asType(), "parentScope", "getCurrentScope()");
                    break;
                }
                case STORE_LOCAL: 
                case STORE_LOCAL_MATERIALIZED: 
                case LOAD_LOCAL_MATERIALIZED: {
                    this.emitValidateLocalScope(b, operation);
                }
            }
            if (operation.kind != OperationModel.OperationKind.FINALLY_HANDLER) {
                b.startStatement().startCall("beforeChild").end(2);
            }
            if ((operationData = this.createOperationBeginData(b, operation, constantOperandIndices)) != null) {
                String dataClassName = this.getDataClassName(operation);
                b.declaration(dataClassName, "operationData", operationData);
                b.startStatement().startCall("beginOperation");
                b.tree(BytecodeRootNodeElement.this.createOperationConstant(operation));
                b.string("operationData");
                b.end(2);
            } else {
                b.startStatement().startCall("beginOperation");
                b.tree(BytecodeRootNodeElement.this.createOperationConstant(operation));
                b.string("null");
                b.end(2);
            }
            switch (operation.kind) {
                case BLOCK: {
                    if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                    b.statement("operationData.frameOffset = parentScope.frameOffset + parentScope.numLocals");
                    break;
                }
                case TAG: {
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagEnterInstruction, "nodeId");
                    break;
                }
            }
            return ex;
        }

        private CodeExecutableElement getValidateLocalScope(boolean materialized) {
            if (materialized) {
                if (this.validateMaterializedLocalScope == null) {
                    this.validateMaterializedLocalScope = this.createValidateLocalScope(true);
                    this.add(this.validateMaterializedLocalScope);
                }
                return this.validateMaterializedLocalScope;
            }
            if (this.validateLocalScope == null) {
                this.validateLocalScope = this.createValidateLocalScope(false);
                this.add(this.validateLocalScope);
            }
            return this.validateLocalScope;
        }

        private CodeExecutableElement createValidateLocalScope(boolean materialized) {
            String name = materialized ? "validateMaterializedLocalScope" : "validateLocalScope";
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), name, new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLocal, "local"));
            CodeTreeBuilder b = method.createBuilder();
            b.startDeclaration(this.bytecodeLocalImpl.asType(), "localImpl");
            b.cast(this.bytecodeLocalImpl.asType()).string("local");
            b.end();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.startIf().string("!localImpl.scope.valid").end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("Local variable scope of this local is no longer valid.").end().end();
                b.end();
            }
            if (materialized) {
                if (!BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    this.buildOperationStackWalk(b, "0", () -> {
                        b.startSwitch().string("operationStack[i].operation").end().startBlock();
                        b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.rootOperation)).end();
                        b.startCaseBlock();
                        this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.rootOperation, "i", "rootOperationData");
                        b.startIf().string("rootOperationData.index == localImpl.rootIndex").end().startBlock();
                        b.lineComment("root node found");
                        b.statement("return");
                        b.end();
                        b.end();
                        b.end();
                    });
                    b.startThrow().startCall("failArgument").doubleQuote("Local variables used in materialized accesses must belong to the current root node or an outer root node.").end().end();
                }
            } else {
                b.declaration(this.dataClasses.get(BytecodeRootNodeElement.this.model.rootOperation).asType(), "rootOperationData", "getCurrentRootOperationData()");
                b.startIf().string("rootOperationData.index != localImpl.rootIndex").end().startBlock();
                Object materializedAccessAdvice = "Consider using materialized local accesses (i.e., LoadLocalMaterialized/StoreLocalMaterialized or MaterializedLocalAccessor) to access locals from an outer root node.";
                if (!BytecodeRootNodeElement.this.model.enableMaterializedLocalAccesses) {
                    materializedAccessAdvice = (String)materializedAccessAdvice + " Materialized local accesses are currently disabled and can be enabled using the enableMaterializedLocalAccesses field of @GenerateBytecode.";
                }
                b.startThrow().startCall("failArgument").doubleQuote("Local variable must belong to the current root node. " + (String)materializedAccessAdvice).end().end();
                b.end();
            }
            return method;
        }

        private void emitValidateLocalScope(CodeTreeBuilder b, OperationModel operation) {
            boolean materialized = operation.instruction.kind.isLocalVariableMaterializedAccess();
            this.emitValidateLocalScope(b, materialized, operation.getOperationBeginArgumentName(0));
        }

        private void emitValidateLocalScope(CodeTreeBuilder b, boolean materialized, String localName) {
            b.startStatement().startCall(this.getValidateLocalScope(materialized).getSimpleName().toString()).string(localName).end().end();
        }

        private CodeExecutableElement createBeginRoot(OperationModel rootOperation) {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "beginRoot", new CodeVariableElement[0]);
            if (BytecodeRootNodeElement.this.model.prolog != null && BytecodeRootNodeElement.this.model.prolog.operation.operationBeginArguments.length != 0) {
                for (OperationModel.OperationArgument operationArgument : BytecodeRootNodeElement.this.model.prolog.operation.operationBeginArguments) {
                    ex.addParameter(operationArgument.toVariableElement());
                }
            }
            this.addBeginRootOperationDoc(rootOperation, ex);
            CodeTreeBuilder b = ex.getBuilder();
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                b.startIf().string("serialization != null").end().startBlock();
                this.createSerializeBegin(rootOperation, b);
                b.statement("return");
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.prolog != null) {
                for (OperationModel.OperationArgument operationArgument : BytecodeRootNodeElement.this.model.prolog.operation.operationBeginArguments) {
                    this.buildConstantOperandValidation(b, operationArgument.builderType(), operationArgument.name());
                }
            }
            b.startIf().string("bc != null").end().startBlock();
            b.startAssign("savedState").startNew(this.savedState.asType());
            b.variables(this.builderState);
            b.end(2);
            b.end();
            b.statement("operationSequenceNumber = 0");
            b.statement("rootOperationSp = operationSp");
            b.statement("reachable = true");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.statement("tagRoots = null");
                b.statement("tagNodes = null");
            }
            b.statement("numLocals = 0");
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("maxLocals = numLocals");
            }
            b.statement("numLabels = 0");
            b.statement("numNodes = 0");
            b.statement("numHandlers = 0");
            b.statement("numConditionalBranches = 0");
            b.statement("constantPool = new ConstantPool()");
            b.statement("bc = new byte[32]");
            b.statement("bci = 0");
            b.statement("currentStackHeight = 0");
            b.statement("maxStackHeight = 0");
            b.statement("handlerTable = new int[2 * EXCEPTION_HANDLER_LENGTH]");
            b.statement("handlerTableSize = 0");
            b.statement("locals = null");
            b.statement("localsTableIndex = 0");
            b.statement("unresolvedLabels = new HashMap<>()");
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.statement("continuationLocations = new ArrayList<>()");
            }
            b.startIf().string("parseSources").end().startBlock();
            b.statement("sourceInfo = new int[3 * SOURCE_INFO_LENGTH]");
            b.statement("sourceInfoIndex = 0");
            b.end();
            b.startStatement().string("RootData operationData = ");
            b.tree(this.createOperationData("RootData", BytecodeRootNodeElement.safeCastShort("numRoots++")));
            b.end();
            b.startIf().string("reparseReason == null").end().startBlock();
            b.statement("builtNodes.add(null)");
            b.startIf().string("builtNodes.size() > Short.MAX_VALUE").end().startBlock();
            BytecodeRootNodeElement.this.emitThrowEncodingException(b, "\"Root node count exceeded maximum value.\"");
            b.end();
            b.end();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("operationData.frameOffset = numLocals");
            }
            b.startStatement().startCall("beginOperation");
            b.tree(BytecodeRootNodeElement.this.createOperationConstant(rootOperation));
            b.string("operationData");
            b.end(2);
            if (BytecodeRootNodeElement.this.model.prolog != null || BytecodeRootNodeElement.this.model.epilogExceptional != null || BytecodeRootNodeElement.this.model.epilogReturn != null) {
                if (BytecodeRootNodeElement.this.model.enableRootTagging) {
                    this.buildBegin(b, BytecodeRootNodeElement.this.model.tagOperation, this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootTag).getSimpleName().toString());
                }
                if (BytecodeRootNodeElement.this.model.prolog != null) {
                    if (BytecodeRootNodeElement.this.model.prolog.operation.operationEndArguments.length != 0) {
                        b.statement("operationData.prologBci = bci");
                    }
                    List<String> constantOperandIndices = this.emitConstantOperands(b, BytecodeRootNodeElement.this.model.prolog.operation);
                    this.buildEmitOperationInstruction(b, BytecodeRootNodeElement.this.model.prolog.operation, constantOperandIndices);
                }
                if (BytecodeRootNodeElement.this.model.epilogReturn != null) {
                    this.buildBegin(b, BytecodeRootNodeElement.this.model.epilogReturn.operation, new String[0]);
                }
                if (BytecodeRootNodeElement.this.model.enableRootBodyTagging) {
                    this.buildBegin(b, BytecodeRootNodeElement.this.model.tagOperation, this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootBodyTag).getSimpleName().toString());
                }
            } else {
                VariableElement tagConstants = this.getAllRootTagConstants();
                if (tagConstants != null) {
                    this.buildBegin(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants.getSimpleName().toString());
                }
            }
            if (this.needsRootBlock()) {
                this.buildBegin(b, BytecodeRootNodeElement.this.model.blockOperation, new String[0]);
            }
            return ex;
        }

        private boolean needsRootBlock() {
            return BytecodeRootNodeElement.this.model.enableRootTagging || BytecodeRootNodeElement.this.model.enableRootBodyTagging || BytecodeRootNodeElement.this.model.epilogExceptional != null || BytecodeRootNodeElement.this.model.epilogReturn != null;
        }

        private VariableElement getAllRootTagConstants() {
            if (BytecodeRootNodeElement.this.model.enableRootTagging && BytecodeRootNodeElement.this.model.enableRootBodyTagging) {
                return this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootTag, BytecodeRootNodeElement.this.types.StandardTags_RootBodyTag);
            }
            if (BytecodeRootNodeElement.this.model.enableRootTagging) {
                return this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootTag);
            }
            if (BytecodeRootNodeElement.this.model.enableRootBodyTagging) {
                return this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootBodyTag);
            }
            return null;
        }

        private VariableElement lookupTagConstant(TypeMirror ... tags) {
            return this.lookupTagConstant(List.of(tags));
        }

        private VariableElement lookupTagConstant(List<TypeMirror> tags) {
            Object name = "TAGS";
            for (TypeMirror type : tags) {
                name = (String)name + "_" + ElementUtils.createConstantName(ElementUtils.getSimpleName(type));
            }
            VariableElement existing = this.findField((String)name);
            if (existing != null) {
                return existing;
            }
            CodeVariableElement newVariable = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Class.class)), (String)name);
            CodeTreeBuilder b = newVariable.createInitBuilder();
            b.string("new Class<?>[]{").startCommaGroup();
            for (TypeMirror type : tags) {
                b.typeLiteral(type);
            }
            b.end().string("}");
            this.add(newVariable);
            return newVariable;
        }

        private void createSerializeBegin(OperationModel operation, CodeTreeBuilder b) {
            BytecodeRootNodeElement.this.serializationWrapException(b, () -> {
                if (operation.kind == OperationModel.OperationKind.ROOT) {
                    b.startDeclaration(BytecodeRootNodeElement.this.serializationRootNode.asType(), "node");
                    b.startNew(BytecodeRootNodeElement.this.serializationRootNode.asType());
                    b.startStaticCall(BytecodeRootNodeElement.this.types.FrameDescriptor, "newBuilder").end();
                    b.string("serialization.depth");
                    b.startCall("checkOverflowShort").string("serialization.rootCount++").doubleQuote("Root node count").end();
                    b.end();
                    b.end();
                    b.statement("serialization.rootStack.push(node)");
                    b.statement("serialization.builtNodes.add(node)");
                }
                CodeTreeBuilder afterOperation = CodeTreeBuilder.createBuilder();
                for (OperationModel.OperationArgument argument : operation.operationBeginArguments) {
                    this.buildSerializeOperationArgument(b, afterOperation, argument);
                }
                this.serializationElements.writeShort(b, this.serializationElements.codeBegin[operation.id]);
                b.tree(afterOperation.build());
            });
        }

        private CodeTree createOperationBeginData(CodeTreeBuilder b, OperationModel operation, List<String> constantOperandIndices) {
            String className = this.getDataClassName(operation);
            return switch (operation.kind) {
                case OperationModel.OperationKind.STORE_LOCAL, OperationModel.OperationKind.STORE_LOCAL_MATERIALIZED -> {
                    String local = "(BytecodeLocalImpl)" + operation.getOperationBeginArgumentName(0);
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        yield this.createOperationData(className, local);
                    }
                    yield CodeTreeBuilder.singleString(local);
                }
                case OperationModel.OperationKind.LOAD_LOCAL_MATERIALIZED, OperationModel.OperationKind.LOAD_LOCAL -> CodeTreeBuilder.singleString("(BytecodeLocalImpl)" + operation.getOperationBeginArgumentName(0));
                case OperationModel.OperationKind.IF_THEN -> this.createOperationData(className, "this.reachable");
                case OperationModel.OperationKind.IF_THEN_ELSE -> this.createOperationData(className, "this.reachable", "this.reachable");
                case OperationModel.OperationKind.CONDITIONAL -> this.createOperationData(className, "this.reachable", "this.reachable");
                case OperationModel.OperationKind.WHILE -> this.createOperationData(className, "bci", "this.reachable");
                case OperationModel.OperationKind.TRY_CATCH -> this.createOperationData(className, "++numHandlers", BytecodeRootNodeElement.safeCastShort("currentStackHeight"), "bci", "this.reachable", "this.reachable", "this.reachable");
                case OperationModel.OperationKind.TRY_FINALLY -> this.createOperationData(className, "++numHandlers", BytecodeRootNodeElement.safeCastShort("currentStackHeight"), operation.getOperationBeginArgumentName(0), "bci", "this.reachable", "this.reachable", "false");
                case OperationModel.OperationKind.TRY_CATCH_OTHERWISE -> this.createOperationData(className, "++numHandlers", BytecodeRootNodeElement.safeCastShort("currentStackHeight"), operation.getOperationBeginArgumentName(0), "bci", "this.reachable", "this.reachable", "this.reachable");
                case OperationModel.OperationKind.FINALLY_HANDLER -> this.createOperationData(className, "finallyOperationSp");
                case OperationModel.OperationKind.CUSTOM, OperationModel.OperationKind.CUSTOM_INSTRUMENTATION -> {
                    if (operation.isTransparent) {
                        yield this.createOperationData(className, new String[0]);
                    }
                    String[] args = new String[2];
                    CodeTreeBuilder childBciArrayBuilder = CodeTreeBuilder.createBuilder();
                    int numChildBcis = operation.instruction.getImmediates(InstructionModel.ImmediateKind.BYTECODE_INDEX).size();
                    if (numChildBcis == 0) {
                        args[0] = BytecodeRootNodeElement.EMPTY_INT_ARRAY;
                    } else {
                        childBciArrayBuilder.startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), null);
                        for (int i = 0; i < numChildBcis; ++i) {
                            childBciArrayBuilder.string(UNINIT);
                        }
                        childBciArrayBuilder.end();
                        args[0] = childBciArrayBuilder.toString();
                    }
                    CodeTreeBuilder constantsArrayBuilder = CodeTreeBuilder.createBuilder();
                    if (constantOperandIndices == null || constantOperandIndices.size() == 0) {
                        args[1] = BytecodeRootNodeElement.EMPTY_INT_ARRAY;
                    } else {
                        constantsArrayBuilder.startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), null);
                        for (String constantIndex : constantOperandIndices) {
                            constantsArrayBuilder.string(constantIndex);
                        }
                        constantsArrayBuilder.end();
                        args[1] = constantsArrayBuilder.toString();
                    }
                    yield this.createOperationData(className, args);
                }
                case OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT -> this.createOperationData(className, new String[0]);
                case OperationModel.OperationKind.TAG -> this.createOperationData(className, "nodeId", "this.reachable", "this.currentStackHeight", "node");
                case OperationModel.OperationKind.RETURN -> this.createOperationData(className, new String[0]);
                case OperationModel.OperationKind.BLOCK -> this.createOperationData(className, "this.currentStackHeight");
                case OperationModel.OperationKind.SOURCE -> {
                    b.startIf().string(operation.getOperationBeginArgumentName(0) + ".hasBytes()").end().startBlock();
                    b.startThrow().startCall("failArgument").doubleQuote("Byte-based sources are not supported.").end(2);
                    b.end();
                    b.statement("int index = sources.indexOf(" + operation.getOperationBeginArgumentName(0) + ")");
                    b.startIf().string("index == -1").end().startBlock();
                    b.statement("index = sources.size()");
                    b.statement("sources.add(" + operation.getOperationBeginArgumentName(0) + ")");
                    b.end();
                    yield this.createOperationData(className, "index");
                }
                case OperationModel.OperationKind.SOURCE_SECTION -> {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "foundSourceIndex", "-1");
                    b.string("loop: ");
                    this.buildOperationStackWalk(b, "0", () -> {
                        b.startSwitch().string("operationStack[i].operation").end().startBlock();
                        b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.sourceOperation)).end();
                        b.startCaseBlock();
                        this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.sourceOperation, "i", "sourceData");
                        b.statement("foundSourceIndex = sourceData.sourceIndex");
                        b.statement("break loop");
                        b.end();
                        b.end();
                    });
                    b.startIf().string("foundSourceIndex == -1").end().startBlock();
                    b.startThrow().startCall("failState").doubleQuote("No enclosing Source operation found - each SourceSection must be enclosed in a Source operation.").end().end();
                    b.end();
                    String index = operation.getOperationBeginArgumentName(0);
                    String length = operation.getOperationBeginArgumentName(1);
                    b.startAssert().string("(", index, " == -1 && ", length, " == -1) || (", index, " >= 0 && ", length, " >= 0)").end();
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci");
                    b.startIf().string("rootOperationSp == -1").end().startBlock();
                    b.lineComment("not in a root yet");
                    b.statement("startBci = 0");
                    b.end().startElseBlock();
                    b.statement("startBci = bci");
                    b.end();
                    yield this.createOperationData(className, "foundSourceIndex", "startBci", index, length);
                }
                default -> operation.isTransparent ? this.createOperationData(className, new String[0]) : null;
            };
        }

        private CodeTree createOperationData(String dataClassName, String ... args) {
            CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
            b.startNew(dataClassName);
            for (String arg : args) {
                b.string(arg);
            }
            b.end();
            return b.build();
        }

        private CodeExecutableElement createEndOperation() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.operationStackEntry.asType(), "endOperation", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "id"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("operationSp == 0").end().startBlock();
            b.startThrow().startCall("failState");
            b.doubleQuote("Unexpected operation end - there are no operations on the stack. Did you forget a beginRoot()?");
            b.end(2);
            b.end();
            b.statement("OperationStackEntry entry = operationStack[operationSp - 1]");
            b.startIf().string("entry.operation != id").end().startBlock();
            b.startThrow().startCall("failState");
            b.startGroup().doubleQuote("Unexpected operation end, expected end").string(" + OPERATION_NAMES[entry.operation] + ").doubleQuote(", but got end").string(" +  OPERATION_NAMES[id]").end();
            b.end(2);
            b.end();
            b.startIf().string("entry.declaredLabels != null").end().startBlock();
            b.startFor().string("BytecodeLabel label : entry.declaredLabels").end().startBlock();
            b.statement("BytecodeLabelImpl impl = (BytecodeLabelImpl) label");
            b.startIf().string("!impl.isDefined()").end().startBlock();
            b.startThrow().startCall("failState");
            b.string("\"Operation \" + OPERATION_NAMES[id] + \" ended without emitting one or more declared labels.\"");
            b.end(2);
            b.end(3);
            b.statement("operationStack[operationSp - 1] = null");
            b.statement("operationSp -= 1");
            b.statement("return entry");
            return ex;
        }

        private CodeExecutableElement createEnd(OperationModel operation) {
            VariableElement tagConstants;
            if (operation.kind == OperationModel.OperationKind.ROOT) {
                return this.createEndRoot(operation);
            }
            Modifier visibility = operation.isInternal ? Modifier.PRIVATE : Modifier.PUBLIC;
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(visibility), BytecodeRootNodeElement.this.type(Void.TYPE), "end" + operation.name, new CodeVariableElement[0]);
            if (operation.kind == OperationModel.OperationKind.TAG) {
                ex.setVarArgs(true);
                ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.context.getDeclaredType(Class.class)), "newTags"));
            } else {
                for (OperationModel.OperationArgument arg : operation.operationEndArguments) {
                    ex.addParameter(arg.toVariableElement());
                }
            }
            this.addEndOperationDoc(operation, ex);
            CodeTreeBuilder b = ex.createBuilder();
            if (operation.kind == OperationModel.OperationKind.TAG) {
                b.startIf().string("newTags.length == 0").end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("The tags parameter for beginTag must not be empty. Please specify at least one tag.").end().end();
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "encodedTags", "encodeTags(newTags)");
                b.startIf().string("(encodedTags & this.tags) == 0").end().startBlock();
                b.returnStatement();
                b.end();
            } else if (operation.isSourceOnly()) {
                b.startIf().string("!parseSources").end().startBlock();
                b.returnStatement();
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.enableSerialization && !operation.isInternal) {
                b.startIf().string("serialization != null").end().startBlock();
                this.createSerializeEnd(operation, b);
                b.statement("return");
                b.end();
            }
            if (operation.constantOperands != null && operation.constantOperands.hasConstantOperands()) {
                int index = 0;
                for (ConstantOperandModel operand : operation.constantOperands.after()) {
                    this.buildConstantOperandValidation(b, operand.type(), operation.getOperationEndArgumentName(index++));
                }
            }
            List<String> constantOperandIndices = this.emitConstantOperands(b, operation);
            if (operation.kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) {
                int mask = 1 << operation.instrumentationIndex;
                b.startIf().string("(instrumentations & ").string("0x", Integer.toHexString(mask)).string(") == 0").end().startBlock();
                b.returnStatement();
                b.end();
            }
            if (operation.kind == OperationModel.OperationKind.FINALLY_HANDLER) {
                b.startStatement().startCall("endOperation");
                b.tree(BytecodeRootNodeElement.this.createOperationConstant(operation));
                b.end(2);
                return ex;
            }
            b.startDeclaration(this.operationStackEntry.asType(), "operation").startCall("endOperation");
            b.tree(BytecodeRootNodeElement.this.createOperationConstant(operation));
            b.end(2);
            if (operation.kind == OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT) {
                b.startIf().string("operation.childCount == 0").end().startBlock();
                b.startThrow().startCall("failState").string("\"Operation " + operation.name + " expected at least " + BytecodeRootNodeElement.childString(1) + ", but \" + operation.childCount + \" provided. This is probably a bug in the parser.\"").end().end();
                b.end();
            } else if (operation.isVariadic && operation.numDynamicOperands() > 1) {
                b.startIf().string("operation.childCount < " + (operation.numDynamicOperands() - 1)).end().startBlock();
                b.startThrow().startCall("failState").string("\"Operation " + operation.name + " expected at least " + BytecodeRootNodeElement.childString(operation.numDynamicOperands() - 1) + ", but \" + operation.childCount + \" provided. This is probably a bug in the parser.\"").end().end();
                b.end();
            } else if (!operation.isVariadic) {
                b.startIf().string("operation.childCount != " + operation.numDynamicOperands()).end().startBlock();
                b.startThrow().startCall("failState").string("\"Operation " + operation.name + " expected exactly " + BytecodeRootNodeElement.childString(operation.numDynamicOperands()) + ", but \" + operation.childCount + \" provided. This is probably a bug in the parser.\"").end().end();
                b.end();
            }
            if (operation.isTransparent) {
                this.emitCastCurrentOperationData(b, operation);
            }
            switch (operation.kind) {
                case CUSTOM_SHORT_CIRCUIT: {
                    InstructionModel shortCircuitInstruction = operation.instruction;
                    this.emitCastCurrentOperationData(b, operation);
                    if (shortCircuitInstruction.shortCircuitModel.returnConvertedBoolean()) {
                        this.buildEmitBooleanConverterInstruction(b, shortCircuitInstruction);
                    }
                    b.startFor().string("int site : operationData.branchFixupBcis").end().startBlock();
                    b.statement(BytecodeRootNodeElement.writeInt("bc", "site", "bci"));
                    b.end();
                    break;
                }
                case SOURCE_SECTION: {
                    b.startStatement().startCall("doEmitSourceInfo");
                    b.string("operationData.sourceIndex");
                    b.string("operationData.startBci");
                    b.string("bci");
                    b.string("operationData.start");
                    b.string("operationData.length");
                    b.end(2);
                    break;
                }
                case SOURCE: {
                    break;
                }
                case IF_THEN_ELSE: {
                    this.emitCastCurrentOperationData(b, operation);
                    b.statement("markReachable(operationData.thenReachable || operationData.elseReachable)");
                    break;
                }
                case IF_THEN: 
                case WHILE: {
                    b.statement("updateReachable()");
                    break;
                }
                case CONDITIONAL: {
                    this.emitCastCurrentOperationData(b, operation);
                    b.statement("markReachable(operationData.thenReachable || operationData.elseReachable)");
                    if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) break;
                    this.buildEmitInstruction(b, operation.instruction, this.emitMergeConditionalArguments(operation.instruction));
                    break;
                }
                case TRY_CATCH: {
                    this.emitCastCurrentOperationData(b, operation);
                    b.statement("markReachable(operationData.tryReachable || operationData.catchReachable)");
                    break;
                }
                case TRY_FINALLY: {
                    this.emitCastCurrentOperationData(b, operation);
                    this.emitFinallyHandlersAfterTry(b, operation, "operationSp");
                    this.emitFixFinallyBranchBci(b);
                    b.statement("markReachable(operationData.tryReachable)");
                    break;
                }
                case TRY_CATCH_OTHERWISE: {
                    this.emitCastCurrentOperationData(b, operation);
                    b.statement("markReachable(operationData.tryReachable || operationData.catchReachable)").end();
                    break;
                }
                case YIELD: {
                    if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                        b.statement("doEmitTagYield()");
                    }
                    this.buildEmitOperationInstruction(b, operation, null);
                    if (!BytecodeRootNodeElement.this.model.enableTagInstrumentation) break;
                    b.statement("doEmitTagResume()");
                    break;
                }
                case RETURN: {
                    this.emitCastCurrentOperationData(b, operation);
                    b.statement("beforeEmitReturn(operationData.childBci)");
                    this.buildEmitOperationInstruction(b, operation, null);
                    b.statement("markReachable(false)");
                    break;
                }
                case TAG: {
                    b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode", "operationData.node");
                    b.startIf().string("(encodedTags & this.tags) != tagNode.tags").end().startBlock();
                    BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "The tags provided to endTag do not match the tags provided to the corresponding beginTag call.");
                    b.end();
                    b.lineComment("If this tag operation is nested in another, add it to the outer tag tree. Otherwise, it becomes a tag root.");
                    b.declaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "outerTagFound", "false");
                    this.buildOperationStackWalk(b, () -> {
                        b.startIf().string("operationStack[i].data instanceof TagOperationData t").end().startBlock();
                        b.startIf().string("t.children == null").end().startBlock();
                        b.statement("t.children = new ArrayList<>(3)");
                        b.end();
                        b.statement("t.children.add(tagNode)");
                        b.statement("outerTagFound = true");
                        b.statement("break");
                        b.end();
                    });
                    b.startIf().string("!outerTagFound").end().startBlock();
                    b.startIf().string("tagRoots == null").end().startBlock();
                    b.statement("tagRoots = new ArrayList<>(3)");
                    b.end();
                    b.statement("tagRoots.add(tagNode)");
                    b.end();
                    b.declaration(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "children");
                    b.declaration((TypeMirror)ElementHelpers.generic(BytecodeRootNodeElement.this.type(List.class), BytecodeRootNodeElement.this.tagNode.asType()), "operationChildren", "operationData.children");
                    b.startIf().string("operationChildren == null").end().startBlock();
                    b.statement("children = TagNode.EMPTY_ARRAY");
                    b.end().startElseBlock();
                    b.statement("children = new TagNode[operationChildren.size()]");
                    b.startFor().string("int i = 0; i < children.length; i++").end().startBlock();
                    b.statement("children[i] = tagNode.insert(operationChildren.get(i))");
                    b.end();
                    b.end();
                    b.statement("tagNode.children = children");
                    b.statement("tagNode.returnBci = bci");
                    b.startIf().string("operationData.producedValue").end().startBlock();
                    InstructionModel.InstructionImmediate imm = operation.instruction.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX);
                    String[] args = imm == null ? new String[]{"operationData.nodeId"} : new String[]{"operationData.nodeId", "operationData.childBci"};
                    b.startIf().string("operationData.operationReachable").end().startBlock();
                    b.statement("markReachable(true)");
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveValueInstruction, args);
                    b.statement("doCreateExceptionHandler(operationData.handlerStartBci, bci, HANDLER_TAG_EXCEPTIONAL, operationData.nodeId, operationData.startStackHeight)");
                    b.end().startElseBlock();
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveValueInstruction, args);
                    b.end();
                    b.startStatement().startCall("afterChild");
                    b.string("true");
                    b.string("bci - " + BytecodeRootNodeElement.this.model.tagLeaveValueInstruction.getInstructionLength());
                    b.end(2);
                    b.end().startElseBlock();
                    b.startIf().string("operationData.operationReachable").end().startBlock();
                    b.statement("markReachable(true)");
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveVoidInstruction, "operationData.nodeId");
                    b.statement("doCreateExceptionHandler(operationData.handlerStartBci, bci, HANDLER_TAG_EXCEPTIONAL, operationData.nodeId, operationData.startStackHeight)");
                    b.end().startElseBlock();
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveVoidInstruction, "operationData.nodeId");
                    b.end();
                    b.startStatement().startCall("afterChild");
                    b.string("false");
                    b.string("-1");
                    b.end(2);
                    b.end();
                    break;
                }
                case BLOCK: {
                    if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                    this.createEndLocalsBlock(b, false);
                    break;
                }
                default: {
                    if (operation.instruction == null) break;
                    this.buildEmitOperationInstruction(b, operation, constantOperandIndices);
                }
            }
            if (operation.kind != OperationModel.OperationKind.TAG) {
                if (operation.isTransparent) {
                    b.startStatement().startCall("afterChild");
                    b.string("operationData.producedValue");
                    b.string("operationData.childBci");
                    b.end(2);
                } else if (operation.kind == OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nextBci");
                    b.startIf().string("operation.childCount <= 1").end().startBlock();
                    b.lineComment("Single child -> boxing elimination possible");
                    b.startStatement().string("nextBci = ");
                    ShortCircuitInstructionModel shortCircuitModel = operation.instruction.shortCircuitModel;
                    if (shortCircuitModel.returnConvertedBoolean()) {
                        b.string("bci - " + shortCircuitModel.booleanConverterInstruction().getInstructionLength());
                    } else {
                        b.string("operationData.childBci");
                    }
                    b.end();
                    b.end();
                    b.startElseBlock();
                    b.lineComment("Multi child -> boxing elimination not possible use short-circuit bci to disable it.");
                    b.statement("nextBci = operationData.shortCircuitBci");
                    b.end();
                    b.startStatement().startCall("afterChild");
                    b.string("true").string("nextBci");
                    b.end(2);
                } else {
                    b.startStatement().startCall("afterChild");
                    b.string(Boolean.toString(!operation.isVoid));
                    if (operation.instruction != null) {
                        b.string("bci - " + operation.instruction.getInstructionLength());
                    } else {
                        b.string("-1");
                    }
                    b.end(2);
                }
            }
            if (operation.isCustom() && !operation.customModel.implicitTags.isEmpty() && (tagConstants = this.lookupTagConstant(operation.customModel.implicitTags)) != null) {
                this.buildEnd(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants.getSimpleName().toString());
            }
            return ex;
        }

        private void createSerializeEnd(OperationModel operation, CodeTreeBuilder b) {
            BytecodeRootNodeElement.this.serializationWrapException(b, () -> {
                CodeTreeBuilder afterCode = CodeTreeBuilder.createBuilder();
                for (OperationModel.OperationArgument argument : operation.operationEndArguments) {
                    this.buildSerializeOperationArgument(b, afterCode, argument);
                }
                this.serializationElements.writeShort(b, this.serializationElements.codeEnd[operation.id]);
                b.tree(afterCode.build());
            });
        }

        private void createEndLocalsBlock(CodeTreeBuilder b, boolean isRoot) {
            b.startIf().string("operationData.numLocals > 0").end().startBlock();
            b.statement("maxLocals = Math.max(maxLocals, operationData.frameOffset + operationData.numLocals)");
            b.startFor().string("int index = 0; index < operationData.numLocals; index++").end().startBlock();
            b.statement("locals[operationData.locals[index] + LOCALS_OFFSET_END_BCI] = bci");
            if (!isRoot) {
                this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.clearLocalInstruction, BytecodeRootNodeElement.safeCastShort("locals[operationData.locals[index] + LOCALS_OFFSET_FRAME_INDEX]"));
            }
            b.end();
            b.end();
            b.statement("operationData.valid = false");
        }

        private CodeExecutableElement createEndRoot(OperationModel rootOperation) {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.model.templateType.asType(), "endRoot", new CodeVariableElement[0]);
            Object javadoc = "Finishes generating bytecode for the current root node.\n<p>\n";
            javadoc = (String)javadoc + BuilderElement.getOperationSignatureJavadoc(rootOperation) + "\n\n";
            if (BytecodeRootNodeElement.this.model.prolog != null) {
                for (OperationModel.OperationArgument operationArgument : BytecodeRootNodeElement.this.model.prolog.operation.operationEndArguments) {
                    ex.addParameter(operationArgument.toVariableElement());
                    javadoc = (String)javadoc + operationArgument.toJavadocParam() + "\n";
                }
            }
            javadoc = (String)javadoc + "@returns the root node with generated bytecode.\n";
            BytecodeRootNodeElement.addJavadoc(ex, (String)javadoc);
            CodeTreeBuilder b = ex.getBuilder();
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                b.startIf().string("serialization != null").end().startBlock();
                BytecodeRootNodeElement.this.serializationWrapException(b, () -> {
                    this.serializationElements.writeShort(b, this.serializationElements.codeEnd[rootOperation.id]);
                    b.startDeclaration(BytecodeRootNodeElement.this.serializationRootNode.asType(), "result");
                    b.string("serialization.", this.serializationElements.rootStack.getSimpleName().toString(), ".pop()");
                    b.end();
                    this.serializationElements.writeInt(b, CodeTreeBuilder.singleString("result.contextDepth"));
                    this.serializationElements.writeInt(b, CodeTreeBuilder.singleString("result.rootIndex"));
                    b.statement("return result");
                });
                b.end();
            }
            if (this.needsRootBlock()) {
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.blockOperation, "operationSp - 1", "blockOperation");
                b.startIf().string("!blockOperation.producedValue").end().startBlock();
                this.buildEmit(b, BytecodeRootNodeElement.this.model.loadNullOperation, new String[0]);
                b.end();
                this.buildEnd(b, BytecodeRootNodeElement.this.model.blockOperation, new String[0]);
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.rootOperation, "rootOperationSp");
            } else {
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.rootOperation, "rootOperationSp");
                b.startIf().string("!operationData.producedValue").end().startBlock();
                this.buildEmit(b, BytecodeRootNodeElement.this.model.loadNullOperation, new String[0]);
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.prolog != null || BytecodeRootNodeElement.this.model.epilogExceptional != null || BytecodeRootNodeElement.this.model.epilogReturn != null) {
                if (BytecodeRootNodeElement.this.model.prolog != null) {
                    OperationModel prologOperation = BytecodeRootNodeElement.this.model.prolog.operation;
                    List<InstructionModel.InstructionImmediate> constantOperands = prologOperation.instruction.getImmediates(InstructionModel.ImmediateKind.CONSTANT);
                    int endConstantsOffset = prologOperation.constantOperands.before().size();
                    for (OperationModel.OperationArgument operationArgument : BytecodeRootNodeElement.this.model.prolog.operation.operationEndArguments) {
                        this.buildConstantOperandValidation(b, operationArgument.builderType(), operationArgument.name());
                    }
                    for (int i = 0; i < prologOperation.operationEndArguments.length; ++i) {
                        InstructionModel.InstructionImmediate immediate = constantOperands.get(endConstantsOffset + i);
                        b.statement(BytecodeRootNodeElement.writeImmediate("bc", "operationData.prologBci", "constantPool.addConstant(" + prologOperation.operationEndArguments[i].name() + ")", immediate));
                    }
                }
                if (BytecodeRootNodeElement.this.model.enableRootBodyTagging) {
                    this.buildEnd(b, BytecodeRootNodeElement.this.model.tagOperation, this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootBodyTag).getSimpleName().toString());
                }
                if (BytecodeRootNodeElement.this.model.epilogReturn != null) {
                    this.buildEnd(b, BytecodeRootNodeElement.this.model.epilogReturn.operation, new String[0]);
                }
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    b.lineComment("Emit epilog special exception handler");
                    b.statement("doCreateExceptionHandler(0, bci, HANDLER_EPILOG_EXCEPTIONAL, -1, -1)");
                }
                if (BytecodeRootNodeElement.this.model.enableRootTagging) {
                    this.buildEnd(b, BytecodeRootNodeElement.this.model.tagOperation, this.lookupTagConstant(BytecodeRootNodeElement.this.types.StandardTags_RootTag).getSimpleName().toString());
                }
            } else {
                VariableElement tagConstants = this.getAllRootTagConstants();
                if (tagConstants != null) {
                    this.buildEnd(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants.getSimpleName().toString());
                }
            }
            this.buildEmitOperationInstruction(b, BytecodeRootNodeElement.this.model.returnOperation, null);
            b.startStatement().startCall("endOperation");
            b.tree(BytecodeRootNodeElement.this.createOperationConstant(rootOperation));
            b.end(2);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                this.createEndLocalsBlock(b, true);
            }
            for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                b.defaultDeclaration(e.asType(), e.getSimpleName().toString() + "_");
            }
            b.statement("doEmitRoot()");
            b.startIf().string("parseSources").end().startBlock();
            CodeTree copyOf = CodeTreeBuilder.createBuilder().startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("sourceInfo").string("sourceInfoIndex").end().build();
            b.startAssign("sourceInfo_").tree(copyOf).end();
            b.startAssign("sources_").string("sources").end();
            b.end();
            b.startIf().string("parseBytecodes").end().startBlock();
            b.startAssign("bytecodes_").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("bc").string("bci").end().end();
            b.startAssign("constants_").string("constantPool.toArray()").end();
            b.startAssign("handlers_").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("handlerTable").string("handlerTableSize").end().end();
            b.startAssign("sources_").string("sources").end();
            b.startAssign("numNodes_").string("numNodes").end();
            b.startAssign("locals_").string("locals == null ? EMPTY_INT_ARRAY : ").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("locals").string("localsTableIndex").end().end();
            b.end();
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startIf().string("tags != 0 && this.tagNodes != null").end().startBlock();
                b.startDeclaration(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "tagNodes_").string("this.tagNodes.toArray(TagNode[]::new)").end();
                b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagTree_");
                b.startAssert().string("!this.tagRoots.isEmpty()").end();
                b.startIf().string("this.tagRoots.size() == 1").end().startBlock();
                b.startAssign("tagTree_").string("this.tagRoots.get(0)").end();
                b.end().startElseBlock();
                b.startAssign("tagTree_").startNew(BytecodeRootNodeElement.this.tagNode.asType());
                b.string("0").string("-1");
                b.end().end();
                b.statement("tagTree_.children = tagTree_.insert(this.tagRoots.toArray(TagNode[]::new))");
                b.end();
                b.startAssign("tagRoot_");
                b.startNew(BytecodeRootNodeElement.this.tagRootNode.asType());
                b.string("tagTree_");
                b.string("tagNodes_");
                b.end();
                b.end();
                b.end();
            }
            b.declaration(BytecodeRootNodeElement.this.asType(), "result", (CodeTree)null);
            b.startIf().string("reparseReason != null").end().startBlock();
            b.statement("result = builtNodes.get(operationData.index)");
            b.startIf().string("parseBytecodes").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "oldBytecodeNode", "result.bytecode");
            b.statement("assert result.maxLocals == " + this.maxLocals());
            b.statement("assert result.nodes == this.nodes");
            b.statement("assert constants_.length == oldBytecodeNode.constants.length");
            b.startAssert();
            b.string("result.getFrameDescriptor().getNumberOfSlots() == ");
            this.buildFrameSize(b);
            b.end();
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.startFor().type(BytecodeRootNodeElement.this.continuationLocation.asType()).string(" continuationLocation : continuationLocations").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "constantPoolIndex", "continuationLocation.constantPoolIndex");
                b.startDeclaration(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType(), "continuationRootNode");
                b.cast(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType()).string("oldBytecodeNode.constants[constantPoolIndex]");
                b.end();
                b.startStatement().startCall("ACCESS.writeObject");
                b.string("constants_");
                b.string("constantPoolIndex");
                b.string("continuationRootNode");
                b.end(2);
                b.end();
            }
            b.end();
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.startDeclaration(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecodeNode");
            } else {
                b.startStatement();
            }
            b.startCall("result", "updateBytecode");
            for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                b.string(e.getSimpleName().toString() + "_");
            }
            b.string("this.reparseReason");
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.string("continuationLocations");
            }
            b.end();
            b.end();
            b.startAssert().string("result.buildIndex == operationData.index").end();
            b.end().startElseBlock();
            b.startDeclaration(BytecodeRootNodeElement.this.types.FrameDescriptor_Builder, "frameDescriptorBuilder").startStaticCall(BytecodeRootNodeElement.this.types.FrameDescriptor, "newBuilder").end().end();
            if (BytecodeRootNodeElement.this.model.defaultLocalValueExpression != null) {
                b.statement("frameDescriptorBuilder.defaultValue(DEFAULT_LOCAL_VALUE)");
            } else {
                b.statement("frameDescriptorBuilder.defaultValueIllegal()");
            }
            b.statement("frameDescriptorBuilder.useSlotKinds(false)");
            b.startStatement().startCall("frameDescriptorBuilder.addSlots");
            b.startGroup();
            this.buildFrameSize(b);
            b.end();
            b.end().end();
            b.startAssign("result").startNew(BytecodeRootNodeElement.this.asType());
            b.string("language");
            b.string("frameDescriptorBuilder");
            b.string("nodes");
            b.string(this.maxLocals());
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.string("numLocals");
            }
            b.string("operationData.index");
            for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                b.string(e.getSimpleName().toString() + "_");
            }
            b.end(2);
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.BytecodeNode, "bytecodeNode", "result.getBytecodeNode()");
                b.startFor().type(BytecodeRootNodeElement.this.continuationLocation.asType()).string(" continuationLocation : continuationLocations").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "constantPoolIndex", "continuationLocation.constantPoolIndex");
                b.declaration(BytecodeRootNodeElement.this.types.BytecodeLocation, "location");
                b.startIf().string("continuationLocation.bci == -1").end().startBlock();
                b.statement("location = null");
                b.end().startElseBlock();
                b.startAssign("location").string("bytecodeNode.getBytecodeLocation(continuationLocation.bci)").end();
                b.end();
                b.startDeclaration(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType(), "continuationRootNode").startNew(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType());
                b.string("language");
                b.string("result.getFrameDescriptor()");
                b.string("result");
                b.string("continuationLocation.sp");
                b.string("location");
                b.end(2);
                b.startStatement().startCall("ACCESS.writeObject");
                b.string("constants_");
                b.string("constantPoolIndex");
                b.string("continuationRootNode");
                b.end(2);
                b.end();
            }
            b.startAssert().string("operationData.index <= numRoots").end();
            b.statement("builtNodes.set(operationData.index, result)");
            b.end();
            b.statement("rootOperationSp = -1");
            b.startIf().string("savedState == null").end().startBlock();
            b.lineComment("invariant: bc is null when no root node is being built");
            b.statement("bc = null");
            b.end().startElseBlock();
            for (CodeVariableElement state : this.builderState) {
                if (state == null) continue;
                b.startAssign("this." + state.getName()).string("savedState." + state.getName()).end();
            }
            b.end();
            b.startReturn().string("result").end();
            return ex;
        }

        private void buildFrameSize(CodeTreeBuilder b) {
            b.string("maxStackHeight + ").string(this.maxLocals());
        }

        private String maxLocals() {
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                return "maxLocals + USER_LOCALS_START_INDEX";
            }
            return "numLocals + USER_LOCALS_START_INDEX";
        }

        private void buildBegin(CodeTreeBuilder b, OperationModel operation, String ... args) {
            b.startStatement().startCall("begin" + operation.name);
            for (String arg : args) {
                b.string(arg);
            }
            b.end(2);
        }

        private void buildEnd(CodeTreeBuilder b, OperationModel operation, String ... args) {
            b.startStatement().startCall("end" + operation.name);
            for (String arg : args) {
                b.string(arg);
            }
            b.end(2);
        }

        private void buildEmit(CodeTreeBuilder b, OperationModel operation, String ... args) {
            b.startStatement().startCall("emit" + operation.name);
            for (String arg : args) {
                b.string(arg);
            }
            b.end(2);
        }

        private void buildOperationStackWalk(CodeTreeBuilder b, String lowerLimit, Runnable r) {
            b.startFor().string("int i = operationSp - 1; i >= ", lowerLimit, "; i--").end().startBlock();
            b.startIf().string("operationStack[i].operation == ").tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.finallyHandlerOperation)).end().startBlock();
            b.startAssign("i").startParantheses();
            this.emitCastOperationDataUnchecked(b, BytecodeRootNodeElement.this.model.finallyHandlerOperation, "i");
            b.end();
            b.string(".finallyOperationSp");
            b.end();
            b.statement("continue");
            b.end();
            r.run();
            b.end();
        }

        private void buildOperationStackWalk(CodeTreeBuilder b, Runnable r) {
            this.buildOperationStackWalk(b, "rootOperationSp", r);
        }

        private void buildOperationStackWalkFromBottom(CodeTreeBuilder b, String lowerLimit, Runnable r) {
            b.startFor().string("int i = ", lowerLimit, "; i < operationSp; i++").end().startBlock();
            b.startIf();
            b.string("operationStack[i].operation == ").tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tryFinallyOperation));
            b.string(" || operationStack[i].operation == ").tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tryCatchOtherwiseOperation));
            b.end().startBlock();
            if (!this.getDataClassName(BytecodeRootNodeElement.this.model.tryFinallyOperation).equals(this.getDataClassName(BytecodeRootNodeElement.this.model.tryCatchOtherwiseOperation))) {
                throw new AssertionError((Object)"TryFinally and TryCatchOtherwise operations have different data classes.");
            }
            b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "finallyHandlerSp");
            b.startParantheses();
            this.emitCastOperationDataUnchecked(b, BytecodeRootNodeElement.this.model.tryFinallyOperation, "i");
            b.end();
            b.string(".finallyHandlerSp");
            b.end();
            b.startIf().string("finallyHandlerSp != ", UNINIT).end().startBlock();
            b.statement("i = finallyHandlerSp - 1");
            b.statement("continue");
            b.end();
            b.end();
            r.run();
            b.end();
        }

        private void emitCastOperationData(CodeTreeBuilder b, OperationModel operation, String sp) {
            this.emitCastOperationData(b, operation, sp, "operationData");
        }

        private void emitCastOperationData(CodeTreeBuilder b, OperationModel operation, String sp, String localName) {
            b.startIf();
            b.string("!(operationStack[" + sp + "].data instanceof ");
            String dataClassName = this.getDataClassName(operation);
            b.string(dataClassName);
            b.string(" ").string(localName).string(")");
            b.end().startBlock();
            BytecodeRootNodeElement.emitThrowAssertionError(b, "\"Data class " + dataClassName + " expected, but was \" + operationStack[" + sp + "].data");
            b.end();
        }

        private void emitCastCurrentOperationData(CodeTreeBuilder b, OperationModel operation) {
            b.startIf();
            b.string("!(operation.data instanceof ");
            String dataClassName = this.getDataClassName(operation);
            b.string(dataClassName);
            b.string(" ").string("operationData").string(")");
            b.end().startBlock();
            BytecodeRootNodeElement.emitThrowAssertionError(b, "\"Data class " + dataClassName + " expected, but was \" + operation.data");
            b.end();
        }

        private void emitCastOperationDataUnchecked(CodeTreeBuilder b, OperationModel operation, String sp) {
            String dataClassName = this.getDataClassName(operation);
            b.string("(", dataClassName, ") operationStack[", sp, "].data");
        }

        private void emitFinallyHandlersAfterTry(CodeTreeBuilder b, OperationModel op, String finallyHandlerSp) {
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerSp", "currentStackHeight + 1 /* reserve space for the exception */");
            b.statement("updateMaxStackHeight(handlerSp)");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "exHandlerIndex", UNINIT);
            b.startIf().string("operationData.operationReachable").end().startBlock();
            b.lineComment("register exception table entry");
            b.statement("exHandlerIndex = doCreateExceptionHandler(operationData.tryStartBci, bci, HANDLER_CUSTOM, -operationData.handlerId, handlerSp)");
            b.end();
            b.lineComment("emit handler for normal completion case");
            b.statement("doEmitFinallyHandler(operationData, ", finallyHandlerSp, ")");
            b.lineComment("the operation was popped, so manually update reachability. try is reachable if neither it nor the finally handler exited early.");
            b.statement("operationData.tryReachable = operationData.tryReachable && this.reachable");
            b.startIf().string("this.reachable").end().startBlock();
            b.statement("operationData.endBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchInstruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").offset());
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchInstruction, UNINIT);
            b.end();
            b.startIf().string("operationData.operationReachable").end().startBlock();
            b.lineComment("update exception table; force handler code to be reachable");
            b.statement("this.reachable = true");
            b.startStatement().startCall("patchHandlerTable");
            b.string("operationData.extraTableEntriesStart");
            b.string("operationData.extraTableEntriesEnd");
            b.string("operationData.handlerId");
            b.string("bci");
            b.string("handlerSp");
            b.end(2);
            b.startIf().string("exHandlerIndex != ", UNINIT).end().startBlock();
            b.statement("handlerTable[exHandlerIndex + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI] = bci");
            b.end();
            b.end();
            if (op.kind != OperationModel.OperationKind.TRY_CATCH_OTHERWISE) {
                b.lineComment("emit handler for exceptional case");
                b.statement("currentStackHeight = handlerSp");
                b.statement("doEmitFinallyHandler(operationData, " + finallyHandlerSp + ")");
                this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.throwInstruction, new String[0]);
            }
        }

        private void emitFixFinallyBranchBci(CodeTreeBuilder b) {
            b.startIf().string("operationData.endBranchFixupBci != ", UNINIT).end().startBlock();
            b.statement(BytecodeRootNodeElement.writeInt("bc", "operationData.endBranchFixupBci", "bci"));
            b.end();
        }

        private void buildEmitOperationInstruction(CodeTreeBuilder b, OperationModel operation, List<String> constantOperandIndices) {
            this.buildEmitOperationInstruction(b, operation, null, "operationSp", constantOperandIndices);
        }

        private void buildEmitOperationInstruction(CodeTreeBuilder b, OperationModel operation, String customChildBci, String sp, List<String> constantOperandIndices) {
            String[] stringArray;
            switch (operation.kind) {
                case LOAD_LOCAL: {
                    ArrayList<Object> immediates = new ArrayList<Object>();
                    immediates.add("((BytecodeLocalImpl) " + operation.getOperationBeginArgumentName(0) + ").frameIndex");
                    if (BytecodeRootNodeElement.this.model.localAccessesNeedLocalIndex()) {
                        immediates.add("((BytecodeLocalImpl) " + operation.getOperationBeginArgumentName(0) + ").localIndex");
                    }
                    stringArray = (String[])immediates.toArray(String[]::new);
                    break;
                }
                case STORE_LOCAL: {
                    this.emitCastCurrentOperationData(b, operation);
                    String local = BytecodeRootNodeElement.this.model.usesBoxingElimination() ? "operationData.local" : "operationData";
                    ArrayList<Object> immediates = new ArrayList<Object>();
                    immediates.add(local + ".frameIndex");
                    if (BytecodeRootNodeElement.this.model.localAccessesNeedLocalIndex()) {
                        immediates.add(local + ".localIndex");
                    }
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        immediates.add("operationData.childBci");
                    }
                    stringArray = (String[])immediates.toArray(String[]::new);
                    break;
                }
                case STORE_LOCAL_MATERIALIZED: {
                    this.emitCastCurrentOperationData(b, operation);
                    String local = BytecodeRootNodeElement.this.model.usesBoxingElimination() ? "operationData.local" : "operationData";
                    ArrayList<Object> immediates = new ArrayList();
                    immediates.add(local + ".frameIndex");
                    immediates.add(local + ".rootIndex");
                    if (BytecodeRootNodeElement.this.model.materializedLocalAccessesNeedLocalIndex()) {
                        immediates.add(local + ".localIndex");
                    }
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        immediates.add("operationData.childBci");
                    }
                    stringArray = (String[])immediates.toArray(String[]::new);
                    break;
                }
                case LOAD_LOCAL_MATERIALIZED: {
                    this.emitCastCurrentOperationData(b, operation);
                    ArrayList<Object> immediates = new ArrayList();
                    immediates.add("operationData.frameIndex");
                    immediates.add("operationData.rootIndex");
                    if (BytecodeRootNodeElement.this.model.materializedLocalAccessesNeedLocalIndex()) {
                        immediates.add("operationData.localIndex");
                    }
                    stringArray = (String[])immediates.toArray(String[]::new);
                    break;
                }
                case RETURN: 
                case LOAD_NULL: {
                    stringArray = new String[]{};
                    break;
                }
                case LOAD_ARGUMENT: {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = BytecodeRootNodeElement.safeCastShort(operation.getOperationBeginArgumentName(0));
                    break;
                }
                case LOAD_CONSTANT: {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "constantPool.addConstant(" + operation.getOperationBeginArgumentName(0) + ")";
                    break;
                }
                case YIELD: {
                    b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "constantPoolIndex", "allocateContinuationConstant()");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "continuationBci");
                    b.startIf().string("reachable").end().startBlock();
                    b.statement("continuationBci = bci + " + operation.instruction.getInstructionLength());
                    b.end().startElseBlock();
                    b.statement("continuationBci = -1");
                    b.end();
                    b.startStatement().startCall("continuationLocations.add");
                    b.startNew(BytecodeRootNodeElement.this.continuationLocation.asType()).string("constantPoolIndex").string("continuationBci").string("currentStackHeight").end();
                    b.end(2);
                    b.end();
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = "constantPoolIndex";
                    break;
                }
                case CUSTOM: 
                case CUSTOM_INSTRUMENTATION: {
                    stringArray = this.buildCustomInitializer(b, operation, operation.instruction, customChildBci, sp, constantOperandIndices);
                    break;
                }
                case CUSTOM_SHORT_CIRCUIT: {
                    throw new AssertionError((Object)"Tried to emit a short circuit instruction directly. These operations should only be emitted implicitly.");
                }
                default: {
                    throw new AssertionError((Object)("Reached an operation " + operation.name + " that cannot be initialized. This is a bug in the Bytecode DSL processor."));
                }
            }
            String[] args = stringArray;
            this.buildEmitInstruction(b, operation.instruction, args);
        }

        private void buildEmitLabel(CodeTreeBuilder b, OperationModel operation) {
            b.startAssign("BytecodeLabelImpl labelImpl").string("(BytecodeLabelImpl) " + operation.getOperationBeginArgumentName(0)).end();
            b.startIf().string("labelImpl.isDefined()").end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("BytecodeLabel already emitted. Each label must be emitted exactly once.").end().end();
            b.end();
            b.startIf().string("labelImpl.declaringOp != operationStack[operationSp - 1].sequenceNumber").end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("BytecodeLabel must be emitted inside the same operation it was created in.").end().end();
            b.end();
            b.startIf().string("operationStack[operationSp - 1].data instanceof " + this.getDataClassName(BytecodeRootNodeElement.this.model.blockOperation) + " blockData").end().startBlock();
            b.startAssert().string("this.currentStackHeight == blockData.startStackHeight").end();
            b.end().startElseBlock();
            b.startAssert().string("operationStack[operationSp - 1].data instanceof " + this.getDataClassName(BytecodeRootNodeElement.this.model.rootOperation)).end();
            b.startAssert().string("this.currentStackHeight == 0").end();
            b.end();
            b.startStatement().startCall("resolveUnresolvedLabel");
            b.string("labelImpl");
            b.string("currentStackHeight");
            b.end(2);
        }

        private void buildEmitBranch(CodeTreeBuilder b, OperationModel operation) {
            b.startAssign("BytecodeLabelImpl labelImpl").string("(BytecodeLabelImpl) " + operation.getOperationBeginArgumentName(0)).end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "declaringOperationSp", UNINIT);
            this.buildOperationStackWalk(b, () -> {
                b.startIf().string("operationStack[i].sequenceNumber == labelImpl.declaringOp").end().startBlock();
                b.statement("declaringOperationSp = i");
                b.statement("break");
                b.end();
            });
            b.startIf().string("declaringOperationSp == ", UNINIT).end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("Branch must be targeting a label that is declared in an enclosing operation of the current root. Jumps into other operations are not permitted.").end().end();
            b.end();
            b.startIf().string("labelImpl.isDefined()").end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("Backward branches are unsupported. Use a While operation to model backward control flow.").end().end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "targetStackHeight");
            b.startIf().string("operationStack[declaringOperationSp].data instanceof " + this.getDataClassName(BytecodeRootNodeElement.this.model.blockOperation) + " blockData").end().startBlock();
            b.startAssign("targetStackHeight").string("blockData.startStackHeight").end();
            b.end().startElseBlock();
            b.startAssert().string("operationStack[declaringOperationSp].data instanceof " + this.getDataClassName(BytecodeRootNodeElement.this.model.rootOperation)).end();
            b.startAssign("targetStackHeight").string("0").end();
            b.end();
            b.statement("beforeEmitBranch(declaringOperationSp)");
            b.lineComment("Pop any extra values off the stack before branching.");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "stackHeightBeforeBranch", "currentStackHeight");
            b.startWhile().string("targetStackHeight != currentStackHeight").end().startBlock();
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("-1"));
            b.end();
            b.lineComment("If the branch is not taken (e.g., control branches over it) the values are still on the stack.");
            b.statement("currentStackHeight = stackHeightBeforeBranch");
            b.startIf().string("this.reachable").end().startBlock();
            b.startStatement().startCall("registerUnresolvedLabel");
            b.string("labelImpl");
            b.string("bci + " + BytecodeRootNodeElement.this.model.branchInstruction.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX).offset());
            b.end(2);
            b.end();
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchInstruction, UNINIT);
        }

        private void buildEmitLoadException(CodeTreeBuilder b, OperationModel operation) {
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "exceptionStackHeight", UNINIT);
            b.string("loop: ");
            this.buildOperationStackWalk(b, () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tryCatchOperation)).end();
                b.startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryCatchOperation, "i");
                b.startIf().string("operationStack[i].childCount == 1").end().startBlock();
                b.statement("exceptionStackHeight = operationData.stackHeight");
                b.statement("break loop");
                b.end();
                b.statement("break");
                b.end();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tryCatchOtherwiseOperation)).end();
                b.startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryCatchOtherwiseOperation, "i");
                b.startIf().string("operationStack[i].childCount == 1").end().startBlock();
                b.statement("exceptionStackHeight = operationData.stackHeight");
                b.statement("break loop");
                b.end();
                b.statement("break");
                b.end();
                b.end();
            });
            b.startIf().string("exceptionStackHeight == ", UNINIT).end().startBlock();
            b.startThrow().startCall("failState").doubleQuote("LoadException can only be used in the catch operation of a TryCatch/TryCatchOtherwise operation in the current root.").end().end();
            b.end();
            this.buildEmitInstruction(b, operation.instruction, "exceptionStackHeight");
        }

        private CodeExecutableElement createValidateRootOperationBegin() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "validateRootOperationBegin", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("rootOperationSp == -1").end().startBlock();
            b.startThrow().startCall("failState");
            b.doubleQuote("Unexpected operation emit - no root operation present. Did you forget a beginRoot()?");
            b.end(2);
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetCurrentRootOperationData() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.dataClasses.get(BytecodeRootNodeElement.this.model.rootOperation).asType(), "getCurrentRootOperationData", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startStatement().startCall("validateRootOperationBegin").end(2);
            this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.rootOperation, "rootOperationSp", "rootOperationData");
            b.startReturn().string("rootOperationData").end();
            return ex;
        }

        private CodeExecutableElement createEmit(OperationModel operation) {
            VariableElement tagConstants;
            VariableElement tagConstants2;
            Modifier visibility = operation.isInternal ? Modifier.PRIVATE : Modifier.PUBLIC;
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(visibility), BytecodeRootNodeElement.this.type(Void.TYPE), "emit" + operation.name, new CodeVariableElement[0]);
            ex.setVarArgs(operation.operationBeginArgumentVarArgs);
            for (OperationModel.OperationArgument arg : operation.operationBeginArguments) {
                ex.addParameter(arg.toVariableElement());
            }
            if (operation.operationEndArguments.length != 0) {
                throw new AssertionError((Object)"operation with no children has end arguments. they should all be at the beginning");
            }
            this.addBeginOrEmitOperationDoc(operation, ex);
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableSerialization && !operation.isInternal) {
                b.startIf().string("serialization != null").end().startBlock();
                this.createSerializeBegin(operation, b);
                b.statement("return");
                b.end();
            }
            if (operation.requiresRootOperation()) {
                b.startStatement().startCall("validateRootOperationBegin").end(2);
            }
            if (operation.kind == OperationModel.OperationKind.LOAD_CONSTANT) {
                String constantArgument = operation.operationBeginArguments[0].name();
                b.startIf().string(constantArgument, " == null").end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("The " + constantArgument + " parameter must not be null. Use emitLoadNull() instead for null values.").end().end();
                b.end();
                b.startIf();
                b.instanceOf(constantArgument, (TypeMirror)BytecodeRootNodeElement.this.types.Node).string(" && ");
                b.string("!").startParantheses().instanceOf(constantArgument, (TypeMirror)BytecodeRootNodeElement.this.types.RootNode).end();
                b.end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("Nodes cannot be used as constants.").end().end();
                b.end();
            }
            if (operation.constantOperands != null && operation.constantOperands.hasConstantOperands()) {
                int index = 0;
                for (ConstantOperandModel operand : operation.constantOperands.before()) {
                    this.buildConstantOperandValidation(b, operand.type(), operation.getOperationBeginArgumentName(index++));
                }
                index = 0;
                for (ConstantOperandModel operand : operation.constantOperands.after()) {
                    this.buildConstantOperandValidation(b, operand.type(), operation.getOperationEndArgumentName(index++));
                }
            }
            List<String> constantOperandIndices = this.emitConstantOperands(b, operation);
            if (operation.kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) {
                int mask = 1 << operation.instrumentationIndex;
                b.startIf().string("(instrumentations & ").string("0x", Integer.toHexString(mask)).string(") == 0").end().startBlock();
                b.returnStatement();
                b.end();
            }
            if (operation.isCustom() && !operation.customModel.implicitTags.isEmpty() && (tagConstants2 = this.lookupTagConstant(operation.customModel.implicitTags)) != null) {
                this.buildBegin(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants2.getSimpleName().toString());
            }
            b.startStatement().startCall("beforeChild").end(2);
            if (operation.kind == OperationModel.OperationKind.LOAD_LOCAL) {
                this.emitValidateLocalScope(b, operation);
            }
            switch (operation.kind) {
                case LABEL: {
                    this.buildEmitLabel(b, operation);
                    break;
                }
                case BRANCH: {
                    this.buildEmitBranch(b, operation);
                    break;
                }
                case LOAD_EXCEPTION: {
                    this.buildEmitLoadException(b, operation);
                    break;
                }
                default: {
                    if (operation.instruction == null) {
                        throw new AssertionError((Object)"operation did not have instruction");
                    }
                    this.buildEmitOperationInstruction(b, operation, constantOperandIndices);
                }
            }
            switch (operation.kind) {
                case BRANCH: {
                    b.statement("markReachable(false)");
                    break;
                }
                case LABEL: {
                    b.statement("markReachable(true)");
                }
            }
            b.startStatement().startCall("afterChild");
            b.string("" + !operation.isVoid);
            b.string((String)(operation.instruction != null ? "bci - " + operation.instruction.getInstructionLength() : "-1"));
            b.end(2);
            if (operation.isCustom() && !operation.customModel.implicitTags.isEmpty() && (tagConstants = this.lookupTagConstant(operation.customModel.implicitTags)) != null) {
                this.buildEnd(b, BytecodeRootNodeElement.this.model.tagOperation, tagConstants.getSimpleName().toString());
            }
            return ex;
        }

        private void buildConstantOperandValidation(CodeTreeBuilder b, TypeMirror type, String name) {
            if (!ElementUtils.isPrimitive(type)) {
                b.startIf().string(name, " == null").end().startBlock();
                b.startThrow().startCall("failArgument").doubleQuote("The " + name + " parameter must not be null. Constant operands do not permit null values.").end().end();
                b.end();
            }
            if (ElementUtils.typeEquals(type, BytecodeRootNodeElement.this.types.LocalAccessor)) {
                this.emitValidateLocalScope(b, false, name);
            } else if (ElementUtils.typeEquals(type, BytecodeRootNodeElement.this.types.LocalRangeAccessor)) {
                String element = name + "Element";
                b.startFor().type(BytecodeRootNodeElement.this.types.BytecodeLocal).string(" " + element + " : " + name).end().startBlock();
                this.emitValidateLocalScope(b, false, element);
                b.end();
            } else if (ElementUtils.typeEquals(type, BytecodeRootNodeElement.this.types.MaterializedLocalAccessor)) {
                this.emitValidateLocalScope(b, true, name);
            }
        }

        private List<String> emitConstantBeginOperands(CodeTreeBuilder b, OperationModel operation) {
            InstructionModel instruction = operation.instruction;
            if (instruction == null) {
                return List.of();
            }
            int numConstantOperands = operation.numConstantOperandsBefore();
            if (numConstantOperands == 0) {
                return List.of();
            }
            ArrayList<String> result = new ArrayList<String>(numConstantOperands);
            for (int i = 0; i < numConstantOperands; ++i) {
                String constantPoolIndex = operation.getConstantOperandBeforeName(i) + "Index";
                b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), constantPoolIndex);
                this.buildAddArgumentConstant(b, operation.operationBeginArguments[i]);
                b.end();
                result.add(constantPoolIndex);
            }
            return result;
        }

        private List<String> emitConstantOperands(CodeTreeBuilder b, OperationModel operation) {
            String variable;
            int i;
            int numConstantOperandsAfter;
            InstructionModel instruction = operation.instruction;
            if (instruction == null) {
                return List.of();
            }
            int numConstantOperandsBefore = operation.numConstantOperandsBefore();
            int numConstantOperands = numConstantOperandsBefore + (numConstantOperandsAfter = operation.numConstantOperandsAfter());
            if (numConstantOperands == 0) {
                return List.of();
            }
            boolean inEmit = !operation.hasChildren();
            ArrayList<String> result = new ArrayList<String>(numConstantOperands);
            for (i = 0; i < numConstantOperandsBefore; ++i) {
                if (inEmit) {
                    variable = operation.getConstantOperandBeforeName(i) + "Index";
                    b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), variable);
                    this.buildAddArgumentConstant(b, operation.operationBeginArguments[i]);
                    b.end();
                    result.add(variable);
                    continue;
                }
                result.add("operationData.constants[" + i + "]");
            }
            for (i = 0; i < numConstantOperandsAfter; ++i) {
                if (BytecodeRootNodeElement.this.model.prolog != null && operation == BytecodeRootNodeElement.this.model.prolog.operation) {
                    result.add(UNINIT);
                    continue;
                }
                variable = operation.getConstantOperandAfterName(i) + "Index";
                b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), variable);
                this.buildAddArgumentConstant(b, operation.operationEndArguments[i]);
                b.end();
                result.add(variable);
            }
            return result;
        }

        private String[] buildCustomInitializer(CodeTreeBuilder b, OperationModel operation, InstructionModel instruction, String customChildBci, String sp, List<String> constantOperandIndices) {
            boolean inEmit;
            if (operation.kind == OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT) {
                throw new AssertionError((Object)"short circuit operations should not be emitted directly.");
            }
            if (instruction.signature.isVariadic) {
                b.statement("doEmitVariadic(operation.childCount - " + (instruction.signature.dynamicOperandCount - 1) + ")");
            }
            if (customChildBci != null && operation.numDynamicOperands() > 1) {
                throw new AssertionError((Object)"customChildBci can only be used with a single child.");
            }
            boolean bl = inEmit = !operation.hasChildren();
            if (!inEmit && !operation.isTransparent()) {
                if (sp.equals("operationSp")) {
                    this.emitCastCurrentOperationData(b, operation);
                } else {
                    this.emitCastOperationData(b, operation, sp);
                }
            }
            List<InstructionModel.InstructionImmediate> immediates = instruction.getImmediates();
            String[] args = new String[immediates.size()];
            int childBciIndex = 0;
            int constantIndex = 0;
            for (int i = 0; i < immediates.size(); ++i) {
                InstructionModel.InstructionImmediate immediate = immediates.get(i);
                args[i] = switch (immediate.kind()) {
                    default -> throw new IncompatibleClassChangeError();
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> {
                        if (customChildBci != null) {
                            yield customChildBci;
                        }
                        if (operation.isTransparent) {
                            if (childBciIndex != 0) {
                                throw new AssertionError((Object)"Unexpected transparent child.");
                            }
                            ++childBciIndex;
                            yield "operationData.childBci";
                        }
                        String childBci = "childBci" + childBciIndex;
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), childBci, "operationData.childBcis[" + childBciIndex + "]");
                        ++childBciIndex;
                        yield childBci;
                    }
                    case InstructionModel.ImmediateKind.CONSTANT -> constantOperandIndices.get(constantIndex++);
                    case InstructionModel.ImmediateKind.NODE_PROFILE -> "allocateNode()";
                    case InstructionModel.ImmediateKind.TAG_NODE -> "node";
                    case InstructionModel.ImmediateKind.BRANCH_PROFILE, InstructionModel.ImmediateKind.FRAME_INDEX, InstructionModel.ImmediateKind.LOCAL_INDEX, InstructionModel.ImmediateKind.LOCAL_ROOT, InstructionModel.ImmediateKind.SHORT, InstructionModel.ImmediateKind.STACK_POINTER -> throw new AssertionError((Object)("Operation " + operation.name + " takes an immediate " + immediate.name() + " with unexpected kind " + String.valueOf((Object)immediate.kind()) + ". This is a bug in the Bytecode DSL processor."));
                };
            }
            return args;
        }

        private void buildAddArgumentConstant(CodeTreeBuilder b, OperationModel.OperationArgument argument) {
            b.startCall("constantPool.addConstant");
            if (ElementUtils.typeEquals(argument.builderType(), argument.constantType())) {
                b.string(argument.name());
            } else {
                b.startStaticCall(argument.constantType(), "constantOf");
                if (ElementUtils.typeEquals(argument.constantType(), BytecodeRootNodeElement.this.types.MaterializedLocalAccessor)) {
                    b.startGroup();
                    b.startParantheses().cast(this.bytecodeLocalImpl.asType()).string(argument.name()).end();
                    b.string(".rootIndex");
                    b.end();
                }
                b.string(argument.name());
                b.end();
            }
            b.end();
        }

        private CodeExecutableElement createBeforeChild() {
            List<OperationModel> exceptionHandlerOperations;
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "beforeChild", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("operationSp == 0").end().startBlock();
            b.statement("return");
            b.end();
            b.statement("int childIndex = operationStack[operationSp - 1].childCount");
            b.startSwitch().string("operationStack[operationSp - 1].operation").end().startBlock();
            static enum BeforeChildKind {
                TRANSPARENT,
                SHORT_CIRCUIT,
                UPDATE_REACHABLE,
                EXCEPTION_HANDLER,
                DEFAULT;

            }
            Map<BeforeChildKind, List<OperationModel>> groupedOperations = BytecodeRootNodeElement.this.model.getOperations().stream().filter(OperationModel::hasChildren).collect(BytecodeRootNodeElement.deterministicGroupingBy(op -> {
                if (op.isTransparent && (op.isVariadic || op.numDynamicOperands() > 1)) {
                    return BeforeChildKind.TRANSPARENT;
                }
                if (op.kind == OperationModel.OperationKind.CUSTOM_SHORT_CIRCUIT) {
                    return BeforeChildKind.SHORT_CIRCUIT;
                }
                if (op.kind == OperationModel.OperationKind.IF_THEN_ELSE || op.kind == OperationModel.OperationKind.IF_THEN || op.kind == OperationModel.OperationKind.CONDITIONAL || op.kind == OperationModel.OperationKind.TRY_FINALLY) {
                    return BeforeChildKind.UPDATE_REACHABLE;
                }
                if (op.kind == OperationModel.OperationKind.TRY_CATCH || op.kind == OperationModel.OperationKind.TRY_CATCH_OTHERWISE) {
                    return BeforeChildKind.EXCEPTION_HANDLER;
                }
                return BeforeChildKind.DEFAULT;
            }));
            if (groupedOperations.containsKey((Object)BeforeChildKind.TRANSPARENT)) {
                Iterator<OperationModel> models = groupedOperations.get((Object)BeforeChildKind.TRANSPARENT);
                for (List<OperationModel> grouped : this.groupByDataClass((List<OperationModel>)((Object)models))) {
                    for (OperationModel op2 : grouped) {
                        b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op2)).end();
                    }
                    b.startBlock();
                    this.emitCastOperationData(b, grouped.get(0), "operationSp - 1");
                    b.startIf().string("operationData.producedValue").end().startBlock();
                    this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("operationData.childBci"));
                    b.end();
                    b.statement("break");
                    b.end();
                }
            }
            if (groupedOperations.containsKey((Object)BeforeChildKind.SHORT_CIRCUIT)) {
                for (OperationModel op3 : groupedOperations.get((Object)BeforeChildKind.SHORT_CIRCUIT)) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op3)).end().startBlock();
                    ShortCircuitInstructionModel shortCircuitModel = op3.instruction.shortCircuitModel;
                    this.emitCastOperationData(b, op3, "operationSp - 1");
                    b.startIf().string("childIndex != 0").end().startBlock();
                    if (shortCircuitModel.convertsOperands()) {
                        if (shortCircuitModel.duplicatesOperandOnStack()) {
                            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.dupInstruction, new String[0]);
                        }
                        this.buildEmitBooleanConverterInstruction(b, op3.instruction);
                    }
                    b.startIf().string("this.reachable").end().startBlock();
                    b.statement("operationData.branchFixupBcis.add(bci + " + op3.instruction.getImmediate("branch_target").offset() + ")");
                    b.end();
                    b.statement("operationData.shortCircuitBci = bci");
                    this.buildEmitInstruction(b, op3.instruction, this.emitShortCircuitArguments(op3.instruction));
                    b.end();
                    b.statement("break");
                    b.end();
                }
            }
            if (groupedOperations.containsKey((Object)BeforeChildKind.UPDATE_REACHABLE)) {
                for (OperationModel op3 : groupedOperations.get((Object)BeforeChildKind.UPDATE_REACHABLE)) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op3)).end();
                }
                b.startCaseBlock();
                b.startIf().string("childIndex >= 1").end().startBlock();
                b.statement("updateReachable()");
                b.end();
                b.statement("break");
                b.end();
            }
            if ((exceptionHandlerOperations = groupedOperations.get((Object)BeforeChildKind.EXCEPTION_HANDLER)) == null || exceptionHandlerOperations.size() != 2) {
                throw new AssertionError((Object)"Expected exactly 2 exception handler operations, but a different number was found.");
            }
            for (OperationModel op4 : exceptionHandlerOperations) {
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op4)).end();
                b.startBlock();
                this.emitCastOperationData(b, op4, "operationSp - 1");
                b.startIf().string("childIndex == 1").end().startBlock();
                b.statement("updateReachable()");
                b.lineComment("The exception dispatch logic pushes the exception onto the stack.");
                b.statement("currentStackHeight = currentStackHeight + 1");
                b.statement("updateMaxStackHeight(currentStackHeight)");
                b.end();
                b.statement("break");
                b.end();
            }
            if (groupedOperations.containsKey((Object)BeforeChildKind.DEFAULT)) {
                for (OperationModel op4 : groupedOperations.get((Object)BeforeChildKind.DEFAULT)) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op4)).end();
                }
                b.startCaseBlock();
                b.statement("break");
                b.end();
            }
            b.caseDefault();
            b.startCaseBlock();
            BytecodeRootNodeElement.emitThrowAssertionError(b, "\"beforeChild should not be called on an operation with no children.\"");
            b.end();
            b.end();
            return ex;
        }

        private Collection<List<OperationModel>> groupByDataClass(List<OperationModel> models) {
            return models.stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(m -> this.getDataClassName((OperationModel)m))).values();
        }

        private void buildEmitBooleanConverterInstruction(CodeTreeBuilder b, InstructionModel shortCircuitInstruction) {
            InstructionModel booleanConverter = shortCircuitInstruction.shortCircuitModel.booleanConverterInstruction();
            List<InstructionModel.InstructionImmediate> immediates = booleanConverter.getImmediates();
            String[] args = new String[immediates.size()];
            for (int i = 0; i < args.length; ++i) {
                InstructionModel.InstructionImmediate immediate = immediates.get(i);
                args[i] = switch (immediate.kind()) {
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> {
                        if (shortCircuitInstruction.shortCircuitModel.producesBoolean()) {
                            b.statement("int childBci = operationData.childBci");
                            b.startAssert();
                            b.string("childBci != UNINITIALIZED");
                            b.end();
                        } else {
                            b.lineComment("Boxing elimination not supported for converter operations if the value is returned.");
                            b.statement("int childBci = -1");
                        }
                        yield "childBci";
                    }
                    case InstructionModel.ImmediateKind.NODE_PROFILE -> "allocateNode()";
                    default -> throw new AssertionError((Object)String.format("Boolean converter instruction had unexpected encoding: %s", immediates));
                };
            }
            this.buildEmitInstruction(b, booleanConverter, args);
        }

        private CodeExecutableElement createAfterChild() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "afterChild", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("operationSp == 0").end().startBlock();
            b.statement("return");
            b.end();
            b.statement("int childIndex = operationStack[operationSp - 1].childCount");
            b.startSwitch().string("operationStack[operationSp - 1].operation").end().startBlock();
            Map<Boolean, List<OperationModel>> operationsByTransparency = BytecodeRootNodeElement.this.model.getOperations().stream().filter(OperationModel::hasChildren).collect(Collectors.partitioningBy(OperationModel::isTransparent));
            for (List<OperationModel> operations : this.groupByDataClass(operationsByTransparency.get(true))) {
                for (OperationModel op : operations) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end();
                }
                b.startBlock();
                this.emitCastOperationData(b, operations.get(0), "operationSp - 1");
                b.statement("operationData.producedValue = producedValue");
                b.statement("operationData.childBci = childBci");
                b.statement("break");
                b.end();
            }
            for (OperationModel op : operationsByTransparency.get(false)) {
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                if (op.requiresStackBalancing()) {
                    int i;
                    ArrayList<Integer> valueChildren = new ArrayList<Integer>();
                    ArrayList<Integer> nonValueChildren = new ArrayList<Integer>();
                    for (i = 0; i < op.dynamicOperands.length; ++i) {
                        if (!op.dynamicOperands[i].voidAllowed()) {
                            valueChildren.add(i);
                            continue;
                        }
                        nonValueChildren.add(i);
                    }
                    if (nonValueChildren.isEmpty()) {
                        b.startIf().string("!producedValue").end().startBlock();
                        b.startThrow().startCall("failState");
                        b.string("\"Operation " + op.name + " expected a value-producing child at position \"", " + childIndex + ", "\", but a void one was provided.\"");
                        b.end(3);
                    } else if (valueChildren.isEmpty()) {
                        b.startIf().string("producedValue").end().startBlock();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("childBci"));
                        b.end();
                    } else {
                        String operator;
                        b.startIf();
                        b.string("(");
                        for (i = 0; i < valueChildren.size(); ++i) {
                            if (i != 0) {
                                b.string(" || ");
                            }
                            operator = op.isVariadic && (Integer)valueChildren.get(i) == op.dynamicOperands.length - 1 ? ">=" : "==";
                            b.string("childIndex " + operator + " " + String.valueOf(valueChildren.get(i)));
                        }
                        b.string(") && !producedValue");
                        b.end().startBlock();
                        b.startThrow().startCall("failState");
                        b.string("\"Operation " + op.name + " expected a value-producing child at position \"", " + childIndex + ", "\", but a void one was provided.\"");
                        b.end(3);
                        b.startElseIf();
                        b.string("(");
                        for (i = 0; i < nonValueChildren.size(); ++i) {
                            if (i != 0) {
                                b.string(" || ");
                            }
                            operator = op.isVariadic && (Integer)nonValueChildren.get(i) == op.dynamicOperands.length - 1 ? ">=" : "==";
                            b.string("childIndex " + operator + " " + String.valueOf(nonValueChildren.get(i)));
                        }
                        b.string(") && producedValue");
                        b.end().startBlock();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("childBci"));
                        b.end();
                    }
                }
                switch (op.kind) {
                    case ROOT: {
                        break;
                    }
                    case TAG: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.statement("operationData.producedValue = producedValue");
                        b.statement("operationData.childBci = childBci");
                        break;
                    }
                    case RETURN: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.statement("operationData.producedValue = producedValue");
                        b.statement("operationData.childBci = childBci");
                        break;
                    }
                    case IF_THEN: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.falseBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchFalseInstruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").offset());
                        b.end();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchFalseInstruction, this.emitBranchFalseArguments(BytecodeRootNodeElement.this.model.branchFalseInstruction));
                        b.end().startElseBlock();
                        b.statement("int toUpdate = operationData.falseBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end();
                        break;
                    }
                    case IF_THEN_ELSE: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.falseBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchFalseInstruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").offset());
                        b.end();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchFalseInstruction, this.emitBranchFalseArguments(BytecodeRootNodeElement.this.model.branchFalseInstruction));
                        b.end().startElseIf().string("childIndex == 1").end().startBlock();
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.endBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchInstruction.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX).offset());
                        b.end();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchInstruction, UNINIT);
                        b.statement("int toUpdate = operationData.falseBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end().startElseBlock();
                        b.statement("int toUpdate = operationData.endBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end();
                        break;
                    }
                    case CONDITIONAL: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.dupInstruction, new String[0]);
                        }
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.falseBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchFalseInstruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").offset());
                        b.end();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchFalseInstruction, this.emitBranchFalseArguments(BytecodeRootNodeElement.this.model.branchFalseInstruction));
                        b.end().startElseIf().string("childIndex == 1").end().startBlock();
                        if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                            b.statement("operationData.child0Bci = childBci");
                        }
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.endBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchInstruction.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX).offset());
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchInstruction, UNINIT);
                        b.end();
                        b.statement("currentStackHeight -= 1");
                        b.statement("int toUpdate = operationData.falseBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end().startElseBlock();
                        if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                            b.statement("operationData.child1Bci = childBci");
                        }
                        b.statement("int toUpdate = operationData.endBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end();
                        break;
                    }
                    case WHILE: {
                        InstructionModel.InstructionImmediate branchTarget = BytecodeRootNodeElement.this.model.branchFalseInstruction.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target");
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        b.startIf().string("reachable").end().startBlock();
                        b.statement("operationData.endBranchFixupBci = bci + " + branchTarget.offset());
                        b.end();
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchFalseInstruction, this.emitBranchFalseArguments(BytecodeRootNodeElement.this.model.branchFalseInstruction));
                        b.end().startElseBlock();
                        b.statement("int toUpdate = operationData.endBranchFixupBci");
                        b.startIf().string("toUpdate != ", UNINIT).end().startBlock();
                        InstructionModel.InstructionImmediate branchProfile = BytecodeRootNodeElement.this.model.branchFalseInstruction.findImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE, "branch_profile");
                        int offset = branchProfile.offset() - branchTarget.offset();
                        if (InstructionModel.ImmediateKind.BRANCH_PROFILE.width != InstructionModel.ImmediateWidth.INT) {
                            throw new AssertionError((Object)"branch profile width changed");
                        }
                        String readBranchProfile = BytecodeRootNodeElement.readInt("bc", "toUpdate + " + offset + " /* loop branch profile */");
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchBackwardInstruction, "operationData.whileStartBci", readBranchProfile);
                        b.statement(BytecodeRootNodeElement.writeInt("bc", "toUpdate", "bci"));
                        b.end();
                        b.end();
                        break;
                    }
                    case TRY_CATCH: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        b.startIf().string("operationData.operationReachable").end().startBlock();
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "tryEndBci", "bci");
                        b.startIf().string("operationData.tryReachable").end().startBlock();
                        b.statement("operationData.endBranchFixupBci = bci + " + BytecodeRootNodeElement.this.model.branchInstruction.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX).offset());
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.branchInstruction, UNINIT);
                        b.end();
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerSp", "currentStackHeight + 1");
                        b.startStatement().startCall("patchHandlerTable");
                        b.string("operationData.extraTableEntriesStart");
                        b.string("operationData.extraTableEntriesEnd");
                        b.string("operationData.handlerId");
                        b.string("bci");
                        b.string("handlerSp");
                        b.end(2);
                        b.statement("doCreateExceptionHandler(operationData.tryStartBci, tryEndBci, HANDLER_CUSTOM, bci, handlerSp)");
                        b.end();
                        b.end();
                        b.startElseIf().string("childIndex == 1").end().startBlock();
                        b.lineComment("pop the exception");
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("-1"));
                        this.emitFixFinallyBranchBci(b);
                        b.end();
                        break;
                    }
                    case TRY_FINALLY: {
                        break;
                    }
                    case TRY_CATCH_OTHERWISE: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.startIf().string("childIndex == 0").end().startBlock();
                        this.emitFinallyHandlersAfterTry(b, op, "operationSp - 1");
                        b.end().startElseBlock();
                        b.lineComment("pop the exception");
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.popInstruction, this.emitPopArguments("-1"));
                        this.emitFixFinallyBranchBci(b);
                        b.end();
                        break;
                    }
                    case STORE_LOCAL: 
                    case STORE_LOCAL_MATERIALIZED: {
                        if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) break;
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.statement("operationData.childBci = childBci");
                        break;
                    }
                    case CUSTOM: 
                    case CUSTOM_INSTRUMENTATION: {
                        int immediateIndex = 0;
                        boolean elseIf = false;
                        boolean operationDataEmitted = false;
                        for (int valueIndex = 0; valueIndex < op.instruction.signature.dynamicOperandCount; ++valueIndex) {
                            if (!op.instruction.needsBoxingElimination(BytecodeRootNodeElement.this.model, valueIndex)) continue;
                            if (!operationDataEmitted) {
                                this.emitCastOperationData(b, op, "operationSp - 1");
                                operationDataEmitted = true;
                            }
                            elseIf = b.startIf(elseIf);
                            b.string("childIndex == " + valueIndex).end().startBlock();
                            b.statement("operationData.childBcis[" + immediateIndex++ + "] = childBci");
                            b.end();
                        }
                        break;
                    }
                    case CUSTOM_SHORT_CIRCUIT: {
                        this.emitCastOperationData(b, op, "operationSp - 1");
                        b.statement("operationData.childBci = childBci");
                    }
                }
                b.statement("break");
                b.end();
            }
            b.end();
            b.statement("operationStack[operationSp - 1].childCount = childIndex + 1");
            return ex;
        }

        private String[] emitShortCircuitArguments(InstructionModel instruction) {
            List<InstructionModel.InstructionImmediate> immedates = instruction.getImmediates();
            String[] branchArguments = new String[immedates.size()];
            for (int index = 0; index < branchArguments.length; ++index) {
                InstructionModel.InstructionImmediate immediate = immedates.get(index);
                branchArguments[index] = switch (immediate.kind()) {
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> UNINIT;
                    case InstructionModel.ImmediateKind.BRANCH_PROFILE -> "allocateBranchProfile()";
                    default -> throw new AssertionError((Object)("Unexpected immediate: " + String.valueOf(immediate)));
                };
            }
            return branchArguments;
        }

        private String[] emitBranchFalseArguments(InstructionModel instruction) {
            List<InstructionModel.InstructionImmediate> immediates = instruction.getImmediates();
            String[] branchArguments = new String[immediates.size()];
            for (int index = 0; index < branchArguments.length; ++index) {
                InstructionModel.InstructionImmediate immediate = immediates.get(index);
                branchArguments[index] = switch (immediate.kind()) {
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> {
                        if (index == 0) {
                            yield UNINIT;
                        }
                        yield "childBci";
                    }
                    case InstructionModel.ImmediateKind.BRANCH_PROFILE -> "allocateBranchProfile()";
                    default -> throw new AssertionError((Object)("Unexpected immediate: " + String.valueOf(immediate)));
                };
            }
            return branchArguments;
        }

        private String[] emitMergeConditionalArguments(InstructionModel instr) {
            List<InstructionModel.InstructionImmediate> immediates = instr.getImmediates();
            String[] branchArguments = new String[immediates.size()];
            for (int index = 0; index < branchArguments.length; ++index) {
                InstructionModel.InstructionImmediate immediate = immediates.get(index);
                branchArguments[index] = switch (immediate.kind()) {
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> {
                        if (index == 0) {
                            yield "operationData.thenReachable ? operationData.child0Bci : -1";
                        }
                        yield "operationData.elseReachable ? operationData.child1Bci : -1";
                    }
                    default -> throw new AssertionError((Object)("Unexpected immediate: " + String.valueOf(immediate)));
                };
            }
            return branchArguments;
        }

        private String[] emitPopArguments(String childBciName) {
            List<InstructionModel.InstructionImmediate> immediates = BytecodeRootNodeElement.this.model.popInstruction.getImmediates();
            String[] branchArguments = new String[immediates.size()];
            for (int index = 0; index < branchArguments.length; ++index) {
                InstructionModel.InstructionImmediate immediate = immediates.get(index);
                switch (immediate.kind()) {
                    case BYTECODE_INDEX: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected immediate: " + String.valueOf(immediate)));
                    }
                }
                branchArguments[index] = childBciName;
            }
            return branchArguments;
        }

        private CodeExecutableElement createDoEmitLocal() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "doEmitLocal", new CodeVariableElement[0]);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex"));
            }
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "name"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "info"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameIndex", "-1");
            b.startIf().string("name != null").end().startBlock();
            b.statement("nameIndex = constantPool.addConstant(name)");
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoIndex", "-1");
            b.startIf().string("info != null").end().startBlock();
            b.statement("infoIndex = constantPool.addConstant(info)");
            b.end();
            b.startReturn().startCall("doEmitLocal");
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.string("localIndex");
                b.string("frameIndex");
            }
            b.string("nameIndex");
            b.string("infoIndex");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createDoEmitLocalConstantIndices() {
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_START_BCI")).createInitBuilder().string("0");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_END_BCI")).createInitBuilder().string("1");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_LOCAL_INDEX")).createInitBuilder().string("2");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_FRAME_INDEX")).createInitBuilder().string("3");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_NAME")).createInitBuilder().string("4");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_INFO")).createInitBuilder().string("5");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_LENGTH")).createInitBuilder().string("6");
            } else {
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_NAME")).createInitBuilder().string("0");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_OFFSET_INFO")).createInitBuilder().string("1");
                BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "LOCALS_LENGTH")).createInitBuilder().string("2");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "doEmitLocal", new CodeVariableElement[0]);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex"));
            }
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoIndex"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableIndex", "allocateLocalsTableEntry()");
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("assert frameIndex - USER_LOCALS_START_INDEX >= 0");
                b.statement("locals[tableIndex + LOCALS_OFFSET_START_BCI] = bci");
                b.lineComment("will be patched later at the end of the block");
                b.statement("locals[tableIndex + LOCALS_OFFSET_END_BCI] = -1");
                b.statement("locals[tableIndex + LOCALS_OFFSET_LOCAL_INDEX] = localIndex");
                b.statement("locals[tableIndex + LOCALS_OFFSET_FRAME_INDEX] = frameIndex");
            }
            b.statement("locals[tableIndex + LOCALS_OFFSET_NAME] = nameIndex");
            b.statement("locals[tableIndex + LOCALS_OFFSET_INFO] = infoIndex");
            b.statement("return tableIndex");
            return ex;
        }

        private CodeExecutableElement createAllocateLocalsTableEntry() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "allocateLocalsTableEntry", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("int result = localsTableIndex");
            b.startIf().string("locals == null").end().startBlock();
            b.startAssert().string("result == 0").end();
            b.startAssign("locals").startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), CodeTreeBuilder.singleString("LOCALS_LENGTH * 8")).end().end();
            b.end().startElseIf().string("result + LOCALS_LENGTH > locals.length").end().startBlock();
            b.startAssign("locals").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
            b.string("locals");
            b.string("Math.max(result + LOCALS_LENGTH, locals.length * 2)");
            b.end(2);
            b.end();
            b.statement("localsTableIndex += LOCALS_LENGTH");
            b.statement("return result");
            return ex;
        }

        private CodeExecutableElement ensureDoEmitInstructionCreated(InstructionModel instruction) {
            InstructionModel.InstructionEncoding encoding = instruction.getInstructionEncoding();
            return this.doEmitInstructionMethods.computeIfAbsent(encoding, length -> this.createDoEmitInstruction(instruction));
        }

        private CodeExecutableElement createDoEmitInstruction(InstructionModel representativeInstruction) {
            StringBuilder methodName = new StringBuilder("doEmitInstruction");
            for (InstructionModel.InstructionImmediate immediate : representativeInstruction.immediates) {
                methodName.append(switch (immediate.kind().width) {
                    default -> throw new IncompatibleClassChangeError();
                    case InstructionModel.ImmediateWidth.BYTE -> "B";
                    case InstructionModel.ImmediateWidth.SHORT -> "S";
                    case InstructionModel.ImmediateWidth.INT -> "I";
                });
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Boolean.TYPE), methodName.toString(), new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Short.TYPE), "instruction"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "stackEffect"));
            for (int i = 0; i < representativeInstruction.immediates.size(); ++i) {
                ex.addParameter(new CodeVariableElement(representativeInstruction.immediates.get((int)i).kind().width.toType(BytecodeRootNodeElement.this.context), "data" + i));
            }
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("stackEffect != 0").end().startBlock();
            b.statement("currentStackHeight += stackEffect");
            b.startAssert().string("currentStackHeight >= 0").end();
            b.end();
            b.startIf().string("stackEffect > 0").end().startBlock();
            b.statement("updateMaxStackHeight(currentStackHeight)");
            b.end();
            b.startIf().string("!reachable").end().startBlock();
            b.statement("return false");
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBci", "checkBci(bci + " + representativeInstruction.getInstructionLength() + ")");
            b.startIf().string("newBci > bc.length").end().startBlock();
            b.statement("ensureBytecodeCapacity(newBci)");
            b.end();
            b.end();
            b.statement(BytecodeRootNodeElement.writeInstruction("bc", "bci + 0", "instruction"));
            for (int i = 0; i < representativeInstruction.immediates.size(); ++i) {
                InstructionModel.InstructionImmediate immediate = representativeInstruction.immediates.get(i);
                InstructionModel.InstructionImmediate representativeImmediate = new InstructionModel.InstructionImmediate(immediate.offset(), immediate.kind(), Integer.toString(i));
                b.statement(BytecodeRootNodeElement.writeImmediate("bc", "bci", "data" + i, representativeImmediate));
            }
            b.statement("bci = newBci");
            b.statement("return true");
            return ex;
        }

        private CodeExecutableElement createSafeCastShort() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Short.TYPE), "safeCastShort", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "num"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("Short.MIN_VALUE <= num && num <= Short.MAX_VALUE").end().startBlock();
            b.startReturn().string("(short) num").end();
            b.end();
            BytecodeRootNodeElement.this.emitThrowEncodingException(b, "\"Value \" + num + \" cannot be encoded as a short.\"");
            return ex;
        }

        private CodeExecutableElement createCheckOverflowShort() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Short.TYPE), "checkOverflowShort", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Short.TYPE), "num"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.context.getDeclaredType(String.class), "valueName"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("num < 0").end().startBlock();
            BytecodeRootNodeElement.this.emitThrowEncodingException(b, "valueName + \" overflowed.\"");
            b.end();
            b.statement("return num");
            return ex;
        }

        private CodeExecutableElement createCheckOverflowInt() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "checkOverflowInt", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "num"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.context.getDeclaredType(String.class), "valueName"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("num < 0").end().startBlock();
            BytecodeRootNodeElement.this.emitThrowEncodingException(b, "valueName + \" overflowed.\"");
            b.end();
            b.statement("return num");
            return ex;
        }

        private CodeExecutableElement createCheckBci() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "checkBci", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBci"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startCall("checkOverflowInt");
            b.string("newBci");
            b.doubleQuote("Bytecode index");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createUpdateMaxStackHeight() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "updateMaxStackHeight", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "stackHeight"));
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("maxStackHeight = Math.max(maxStackHeight, stackHeight)");
            b.startIf().string("maxStackHeight > Short.MAX_VALUE").end().startBlock();
            BytecodeRootNodeElement.this.emitThrowEncodingException(b, "\"Maximum stack height exceeded.\"");
            b.end();
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createEnsureBytecodeCapacity() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "ensureBytecodeCapacity", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "size"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("size > bc.length").end().startBlock();
            b.startAssign("bc").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
            b.string("bc");
            b.string("Math.max(size, bc.length * 2)");
            b.end(2);
            b.end();
            return ex;
        }

        private CodeExecutableElement createDoEmitVariadic() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitVariadic", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "count"));
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("currentStackHeight -= count - 1");
            b.startIf().string("!reachable").end().startBlock();
            b.statement("return");
            b.end();
            int variadicCount = BytecodeRootNodeElement.this.model.loadVariadicInstruction.length - 1;
            b.startIf().string("count <= ").string(variadicCount).end().startBlock();
            InstructionModel.InstructionEncoding loadVariadicEncoding = BytecodeRootNodeElement.this.model.loadVariadicInstruction[0].getInstructionEncoding();
            for (int i = 1; i < BytecodeRootNodeElement.this.model.loadVariadicInstruction.length; ++i) {
                if (!loadVariadicEncoding.equals(BytecodeRootNodeElement.this.model.loadVariadicInstruction[i].getInstructionEncoding())) {
                    throw new AssertionError((Object)"load.variadic instruction did not match expected encoding.");
                }
            }
            b.startStatement().startCall(this.ensureDoEmitInstructionCreated(BytecodeRootNodeElement.this.model.loadVariadicInstruction[0]).getSimpleName().toString());
            b.startCall("safeCastShort").startGroup().tree(BytecodeRootNodeElement.this.createInstructionConstant(BytecodeRootNodeElement.this.model.loadVariadicInstruction[0])).string(" + count").end(2);
            b.string("0");
            b.end(2);
            b.end().startElseBlock();
            b.statement("updateMaxStackHeight(currentStackHeight + count)");
            b.statement("int elementCount = count + 1");
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.storeNullInstruction, new String[0]);
            b.startWhile().string("elementCount > 8").end().startBlock();
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.loadVariadicInstruction[variadicCount], new String[0]);
            b.statement("elementCount -= 7");
            b.end();
            b.startIf().string("elementCount > 0").end().startBlock();
            b.startStatement().startCall(this.ensureDoEmitInstructionCreated(BytecodeRootNodeElement.this.model.loadVariadicInstruction[0]).getSimpleName().toString());
            b.startCall("safeCastShort").startGroup().tree(BytecodeRootNodeElement.this.createInstructionConstant(BytecodeRootNodeElement.this.model.loadVariadicInstruction[0])).string(" + elementCount").end(2);
            b.string("0");
            b.end(2);
            b.end();
            this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.mergeVariadicInstruction, new String[0]);
            b.end();
            b.startIf().string("count == 0").end().startBlock();
            b.lineComment("pushed empty array");
            b.statement("updateMaxStackHeight(currentStackHeight)");
            b.end();
            return ex;
        }

        private void buildEmitInstruction(CodeTreeBuilder b, InstructionModel instr, String ... arguments) {
            int argumentsLength;
            int stackEffect = switch (instr.kind) {
                case InstructionModel.InstructionKind.BRANCH, InstructionModel.InstructionKind.BRANCH_BACKWARD, InstructionModel.InstructionKind.TAG_ENTER, InstructionModel.InstructionKind.TAG_LEAVE, InstructionModel.InstructionKind.TAG_LEAVE_VOID, InstructionModel.InstructionKind.TAG_RESUME, InstructionModel.InstructionKind.TAG_YIELD, InstructionModel.InstructionKind.LOAD_LOCAL_MATERIALIZED, InstructionModel.InstructionKind.CLEAR_LOCAL, InstructionModel.InstructionKind.YIELD -> 0;
                case InstructionModel.InstructionKind.STORE_NULL, InstructionModel.InstructionKind.LOAD_VARIADIC, InstructionModel.InstructionKind.MERGE_VARIADIC -> 0;
                case InstructionModel.InstructionKind.DUP, InstructionModel.InstructionKind.LOAD_ARGUMENT, InstructionModel.InstructionKind.LOAD_CONSTANT, InstructionModel.InstructionKind.LOAD_NULL, InstructionModel.InstructionKind.LOAD_LOCAL, InstructionModel.InstructionKind.LOAD_EXCEPTION -> 1;
                case InstructionModel.InstructionKind.RETURN, InstructionModel.InstructionKind.THROW, InstructionModel.InstructionKind.BRANCH_FALSE, InstructionModel.InstructionKind.POP, InstructionModel.InstructionKind.STORE_LOCAL, InstructionModel.InstructionKind.MERGE_CONDITIONAL -> -1;
                case InstructionModel.InstructionKind.STORE_LOCAL_MATERIALIZED -> -2;
                case InstructionModel.InstructionKind.CUSTOM -> (instr.signature.isVoid ? 0 : 1) - instr.signature.dynamicOperandCount;
                case InstructionModel.InstructionKind.CUSTOM_SHORT_CIRCUIT -> {
                    ShortCircuitInstructionModel shortCircuitInstruction = instr.shortCircuitModel;
                    if (shortCircuitInstruction.duplicatesOperandOnStack()) {
                        yield -2;
                    }
                    yield -1;
                }
                default -> throw new UnsupportedOperationException();
            };
            CodeExecutableElement doEmitInstruction = this.ensureDoEmitInstructionCreated(instr);
            b.startStatement().startCall(doEmitInstruction.getSimpleName().toString());
            b.tree(BytecodeRootNodeElement.this.createInstructionConstant(instr));
            b.string(stackEffect);
            int n = argumentsLength = arguments != null ? arguments.length : 0;
            if (argumentsLength != instr.immediates.size()) {
                throw new AssertionError((Object)("Invalid number of immediates for instruction " + instr.name + ". Expected " + instr.immediates.size() + " but got " + argumentsLength + ". Immediates" + String.valueOf(instr.getImmediates())));
            }
            if (arguments != null) {
                for (String argument : arguments) {
                    b.string(argument);
                }
            }
            b.end(2);
        }

        private CodeExecutableElement createDoEmitSourceInfo() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitSourceInfo", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "start"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "length"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startAssert().string("parseSources").end();
            b.startIf().string("rootOperationSp == -1").end().startBlock();
            b.returnStatement();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", "sourceInfoIndex");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "prevIndex", "index - SOURCE_INFO_LENGTH");
            b.startIf();
            b.string("prevIndex >= 0").newLine().startIndention();
            b.string(" && (sourceInfo[prevIndex + SOURCE_INFO_OFFSET_SOURCE]) == sourceIndex").newLine();
            b.string(" && (sourceInfo[prevIndex + SOURCE_INFO_OFFSET_START]) == start").newLine();
            b.string(" && (sourceInfo[prevIndex + SOURCE_INFO_OFFSET_LENGTH]) == length");
            b.end(2).startBlock();
            b.startIf().string("(sourceInfo[prevIndex + SOURCE_INFO_OFFSET_START_BCI]) == startBci").newLine().startIndention();
            b.string(" && (sourceInfo[prevIndex + SOURCE_INFO_OFFSET_END_BCI]) == endBci");
            b.end(2).startBlock();
            b.lineComment("duplicate entry");
            b.statement("return");
            b.end();
            b.startElseIf().string("(sourceInfo[prevIndex + SOURCE_INFO_OFFSET_END_BCI]) == startBci").end().startBlock();
            b.lineComment("contiguous entry");
            b.statement("sourceInfo[prevIndex + SOURCE_INFO_OFFSET_END_BCI] = endBci");
            b.statement("return");
            b.end();
            b.end();
            b.startIf().string("index >= sourceInfo.length").end().startBlock();
            b.statement("sourceInfo = Arrays.copyOf(sourceInfo, sourceInfo.length * 2)");
            b.end();
            b.statement("sourceInfo[index + SOURCE_INFO_OFFSET_START_BCI] = startBci");
            b.statement("sourceInfo[index + SOURCE_INFO_OFFSET_END_BCI] = endBci");
            b.statement("sourceInfo[index + SOURCE_INFO_OFFSET_SOURCE] = sourceIndex");
            b.statement("sourceInfo[index + SOURCE_INFO_OFFSET_START] = start");
            b.statement("sourceInfo[index + SOURCE_INFO_OFFSET_LENGTH] = length");
            b.statement("sourceInfoIndex = index + SOURCE_INFO_LENGTH");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_OFFSET_START_BCI")).createInitBuilder().string("0");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_OFFSET_END_BCI")).createInitBuilder().string("1");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_OFFSET_SOURCE")).createInitBuilder().string("2");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_OFFSET_START")).createInitBuilder().string("3");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_OFFSET_LENGTH")).createInitBuilder().string("4");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "SOURCE_INFO_LENGTH")).createInitBuilder().string("5");
            return ex;
        }

        private CodeExecutableElement createDoEmitFinallyHandler() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitFinallyHandler", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(this.dataClasses.get(BytecodeRootNodeElement.this.model.tryFinallyOperation).asType(), "TryFinallyData"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "finallyOperationSp"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startAssert().string("TryFinallyData.finallyHandlerSp == ", UNINIT).end();
            b.startTryBlock();
            b.statement("TryFinallyData.finallyHandlerSp = operationSp");
            this.buildBegin(b, BytecodeRootNodeElement.this.model.finallyHandlerOperation, BytecodeRootNodeElement.safeCastShort("finallyOperationSp"));
            b.statement("TryFinallyData.finallyGenerator.run()");
            this.buildEnd(b, BytecodeRootNodeElement.this.model.finallyHandlerOperation, new String[0]);
            b.end().startFinallyBlock();
            b.statement("TryFinallyData.finallyHandlerSp = ", UNINIT);
            b.end();
            return ex;
        }

        private CodeExecutableElement createDoCreateExceptionHandler() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "doCreateExceptionHandler", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerKind"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerSp"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startAssert().string("startBci <= endBci").end();
            b.lineComment("Don't create empty handler ranges.");
            b.startIf().string("startBci == endBci").end().startBlock();
            b.startReturn().string(UNINIT).end();
            b.end();
            b.lineComment("If the previous entry is for the same handler and the ranges are contiguous, combine them.");
            b.startIf().string("handlerTableSize > 0").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "previousEntry", "handlerTableSize - EXCEPTION_HANDLER_LENGTH");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "previousEndBci", "handlerTable[previousEntry + EXCEPTION_HANDLER_OFFSET_END_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "previousKind", "handlerTable[previousEntry + EXCEPTION_HANDLER_OFFSET_KIND]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "previousHandlerBci", "handlerTable[previousEntry + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
            b.startIf().string("previousEndBci == startBci && previousKind == handlerKind && previousHandlerBci == handlerBci").end().startBlock();
            b.statement("handlerTable[previousEntry + EXCEPTION_HANDLER_OFFSET_END_BCI] = endBci");
            b.startReturn().string(UNINIT).end();
            b.end();
            b.end();
            b.startIf().string("handlerTable.length <= handlerTableSize + EXCEPTION_HANDLER_LENGTH").end().startBlock();
            b.statement("handlerTable = Arrays.copyOf(handlerTable, handlerTable.length * 2)");
            b.end();
            b.statement("int result = handlerTableSize");
            b.statement("handlerTable[handlerTableSize + EXCEPTION_HANDLER_OFFSET_START_BCI] = startBci");
            b.statement("handlerTable[handlerTableSize + EXCEPTION_HANDLER_OFFSET_END_BCI] = endBci");
            b.statement("handlerTable[handlerTableSize + EXCEPTION_HANDLER_OFFSET_KIND] = handlerKind");
            b.statement("handlerTable[handlerTableSize + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI] = handlerBci");
            b.statement("handlerTable[handlerTableSize + EXCEPTION_HANDLER_OFFSET_HANDLER_SP] = handlerSp");
            b.statement("handlerTableSize += EXCEPTION_HANDLER_LENGTH");
            b.statement("return result");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_OFFSET_START_BCI")).createInitBuilder().string("0");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_OFFSET_END_BCI")).createInitBuilder().string("1");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_OFFSET_KIND")).createInitBuilder().string("2");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_OFFSET_HANDLER_BCI")).createInitBuilder().string("3");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_OFFSET_HANDLER_SP")).createInitBuilder().string("4");
            BytecodeRootNodeElement.this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "EXCEPTION_HANDLER_LENGTH")).createInitBuilder().string("5");
            return ex;
        }

        private CodeExecutableElement createFailState() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(RuntimeException.class), "failState", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(String.class), "message"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IllegalStateException.class));
            b.startGroup();
            b.doubleQuote("Invalid builder usage: ");
            b.string(" + ").string("message").string(" + ").doubleQuote(" Operation stack: ").string(" + dumpAt()");
            b.end().end().end();
            return ex;
        }

        private CodeExecutableElement createFailArgument() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(RuntimeException.class), "failArgument", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(String.class), "message"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IllegalArgumentException.class));
            b.startGroup();
            b.doubleQuote("Invalid builder operation argument: ");
            b.string(" + ").string("message").string(" + ").doubleQuote(" Operation stack: ").string(" + dumpAt()");
            b.end().end().end();
            return ex;
        }

        private CodeExecutableElement createDumpAt() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(String.class), "dumpAt", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startTryBlock();
            b.startDeclaration(BytecodeRootNodeElement.this.type(StringBuilder.class), "b").startNew(BytecodeRootNodeElement.this.type(StringBuilder.class)).end().end();
            b.startFor().string("int i = 0; i < operationSp; i++").end().startBlock();
            b.startStatement().startCall("b.append").doubleQuote("(").end().end();
            b.startStatement().startCall("b.append").string("operationStack[i].toString(this)").end().end();
            b.end();
            b.startFor().string("int i = 0; i < operationSp; i++").end().startBlock();
            b.startStatement().startCall("b.append").doubleQuote(")").end().end();
            b.end();
            b.statement("return b.toString()");
            b.end().startCatchBlock(BytecodeRootNodeElement.this.type(Exception.class), "e");
            b.startReturn().doubleQuote("<invalid-location>").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createToString() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(Object.class), "toString");
            CodeTreeBuilder b = ex.createBuilder();
            b.startDeclaration(BytecodeRootNodeElement.this.type(StringBuilder.class), "b").startNew(BytecodeRootNodeElement.this.type(StringBuilder.class)).end().end();
            b.startStatement().startCall("b.append").startGroup().typeLiteral(BytecodeRootNodeElement.this.asType()).string(".getSimpleName()").end().end().end();
            b.statement("b.append('.')");
            b.startStatement().startCall("b.append").startGroup().typeLiteral(this.asType()).string(".getSimpleName()").end().end().end();
            b.startStatement().startCall("b.append").doubleQuote("[").end().end();
            b.startStatement().startCall("b.append").doubleQuote("at=").end().end();
            b.startFor().string("int i = 0; i < operationSp; i++").end().startBlock();
            b.startStatement().startCall("b.append").doubleQuote("(").end().end();
            b.startStatement().startCall("b.append").string("operationStack[i].toString(this)").end().end();
            b.end();
            b.startFor().string("int i = 0; i < operationSp; i++").end().startBlock();
            b.startStatement().startCall("b.append").doubleQuote(")").end().end();
            b.end();
            b.startStatement().startCall("b.append").doubleQuote(", mode=").end().end();
            boolean elseIf = false;
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                b.startIf().string("serialization != null").end().startBlock();
                b.startStatement().startCall("b.append").doubleQuote("serializing").end().end();
                b.end();
                elseIf = true;
            }
            elseIf = b.startIf(elseIf);
            b.string("reparseReason != null").end().startBlock();
            b.startStatement().startCall("b.append").doubleQuote("reparsing").end().end();
            b.end();
            b.startElseBlock();
            b.startStatement().startCall("b.append").doubleQuote("default").end().end();
            b.end();
            b.startStatement().startCall("b.append").doubleQuote(", bytecodeIndex=").end().startCall(".append").string("bci").end().end();
            b.startStatement().startCall("b.append").doubleQuote(", stackPointer=").end().startCall(".append").string("currentStackHeight").end().end();
            b.startStatement().startCall("b.append").doubleQuote(", bytecodes=").end().startCall(".append").string("parseBytecodes").end().end();
            b.startStatement().startCall("b.append").doubleQuote(", sources=").end().startCall(".append").string("parseSources").end().end();
            if (!BytecodeRootNodeElement.this.model.instrumentations.isEmpty()) {
                b.startStatement().startCall("b.append").doubleQuote(", instruments=[").end().end();
                b.declaration(BytecodeRootNodeElement.this.type(String.class), "sep", "\"\"");
                for (CustomOperationModel customOp : BytecodeRootNodeElement.this.model.getInstrumentations()) {
                    OperationModel operation = customOp.operation;
                    int mask = 1 << operation.instrumentationIndex;
                    b.startIf();
                    b.string("(instrumentations & ").string("0x", Integer.toHexString(mask)).string(") != 0").end().startBlock();
                    b.startStatement().startCall("b.append").string("sep").end().end();
                    b.startStatement().startCall("b.append").doubleQuote(operation.name).end().end();
                    b.startAssign("sep").doubleQuote(",").end();
                    b.end();
                }
                b.startStatement().startCall("b.append").doubleQuote("]").end().end();
            }
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startStatement().startCall("b.append").doubleQuote(", tags=").end().end();
                b.declaration(BytecodeRootNodeElement.this.type(String.class), "sepTag", "\"\"");
                for (TypeMirror tag : BytecodeRootNodeElement.this.model.getProvidedTags()) {
                    b.startIf().string("(tags & CLASS_TO_TAG_MASK.get(").typeLiteral(tag).string(")) != 0").end().startBlock();
                    b.startStatement().startCall("b.append").string("sepTag").end().end();
                    b.startStatement().startCall("b.append").startStaticCall(BytecodeRootNodeElement.this.types.Tag, "getIdentifier").typeLiteral(tag).end().end().end();
                    b.startAssign("sepTag").doubleQuote(",").end();
                    b.end();
                }
            }
            b.startStatement().startCall("b.append").doubleQuote("]").end().end();
            b.statement("return b.toString()");
            return ex;
        }

        private CodeExecutableElement createDoEmitRoot() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitRoot", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("!parseSources").end().startBlock();
            b.lineComment("Nothing to do here without sources");
            b.statement("return");
            b.end();
            this.buildOperationStackWalk(b, "0", () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.sourceSectionOperation)).end();
                b.startCaseBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.sourceSectionOperation, "i");
                b.startStatement().startCall("doEmitSourceInfo");
                b.string("operationData.sourceIndex");
                b.string("0");
                b.string("bci");
                b.string("operationData.start");
                b.string("operationData.length");
                b.end(2);
                b.statement("break");
                b.end();
                b.end();
            });
            return ex;
        }

        private CodeExecutableElement createBeforeEmitBranch() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "beforeEmitBranch", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "declaringOperationSp"));
            this.emitStackWalksBeforeEarlyExit(ex, OperationModel.OperationKind.BRANCH, "branch", "declaringOperationSp + 1");
            return ex;
        }

        private CodeExecutableElement createBeforeEmitReturn() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "beforeEmitReturn", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "parentBci"));
            this.emitStackWalksBeforeEarlyExit(ex, OperationModel.OperationKind.RETURN, "return", "rootOperationSp + 1");
            return ex;
        }

        private CodeExecutableElement createDoEmitTagYield() {
            if (!BytecodeRootNodeElement.this.model.enableTagInstrumentation || !BytecodeRootNodeElement.this.model.enableYield) {
                throw new AssertionError((Object)"cannot produce method");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitTagYield", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("tags == 0").end().startBlock();
            b.returnDefault();
            b.end();
            this.buildOperationStackWalk(b, () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                OperationModel op = BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TAG);
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end();
                b.startBlock();
                this.emitCastOperationData(b, op, "i");
                this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagYieldInstruction, "operationData.nodeId");
                b.statement("break");
                b.end();
                b.end();
            });
            return ex;
        }

        private CodeExecutableElement createDoEmitTagResume() {
            if (!BytecodeRootNodeElement.this.model.enableTagInstrumentation || !BytecodeRootNodeElement.this.model.enableYield) {
                throw new AssertionError((Object)"cannot produce method");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEmitTagResume", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("tags == 0").end().startBlock();
            b.returnDefault();
            b.end();
            this.buildOperationStackWalkFromBottom(b, "rootOperationSp", () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                OperationModel op = BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TAG);
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end();
                b.startBlock();
                this.emitCastOperationData(b, op, "i");
                this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagResumeInstruction, "operationData.nodeId");
                b.statement("break");
                b.end();
                b.end();
            });
            return ex;
        }

        private CodeExecutableElement createPatchHandlerTable() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "patchHandlerTable", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableStart"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableEnd"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerId"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerBci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerSp"));
            BytecodeRootNodeElement.addJavadoc(ex, "Iterates the handler table, searching for unresolved entries corresponding to the given handlerId.\nPatches them with the handlerBci and handlerSp now that those values are known.\n");
            CodeTreeBuilder b = ex.createBuilder();
            b.startFor().string("int i = tableStart; i < tableEnd; i += EXCEPTION_HANDLER_LENGTH").end().startBlock();
            b.startIf().string("handlerTable[i + EXCEPTION_HANDLER_OFFSET_KIND] != HANDLER_CUSTOM").end().startBlock();
            b.statement("continue");
            b.end();
            b.startIf().string("handlerTable[i + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI] != -handlerId").end().startBlock();
            b.statement("continue");
            b.end();
            b.statement("handlerTable[i + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI] = handlerBci");
            b.statement("handlerTable[i + EXCEPTION_HANDLER_OFFSET_HANDLER_SP] = handlerSp");
            b.end();
            return ex;
        }

        private void emitStackWalksBeforeEarlyExit(CodeExecutableElement ex, OperationModel.OperationKind operationKind, String friendlyInstructionName, String lowestOperationIndex) {
            BytecodeRootNodeElement.addJavadoc(ex, "Walks the operation stack, emitting instructions for any operations that need to complete before the " + friendlyInstructionName + " (and fixing up bytecode ranges to exclude these instructions).");
            CodeTreeBuilder b = ex.createBuilder();
            this.emitUnwindBeforeEarlyExit(b, operationKind, lowestOperationIndex);
            this.emitRewindBeforeEarlyExit(b, operationKind, lowestOperationIndex);
        }

        private void emitUnwindBeforeEarlyExit(CodeTreeBuilder b, OperationModel.OperationKind operationKind, String lowestOperationIndex) {
            b.startJavadoc();
            b.string("Emit \"exit\" instructions for any pending operations, and close any bytecode ranges that should not apply to the emitted instructions.").newLine();
            b.end();
            if (operationKind == OperationModel.OperationKind.RETURN) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci", "parentBci");
            }
            b.declaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "needsRewind", "false");
            this.buildOperationStackWalk(b, lowestOperationIndex, () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tagOperation)).end();
                    b.startBlock();
                    this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tagOperation, "i");
                    b.startIf().string("reachable").end().startBlock();
                    if (operationKind == OperationModel.OperationKind.RETURN) {
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveValueInstruction, this.buildTagLeaveArguments(BytecodeRootNodeElement.this.model.tagLeaveValueInstruction));
                        b.statement("childBci = bci - " + BytecodeRootNodeElement.this.model.tagLeaveValueInstruction.getInstructionLength());
                    } else {
                        if (operationKind != OperationModel.OperationKind.BRANCH) {
                            throw new AssertionError((Object)"unexpected operation kind used for unwind code generation.");
                        }
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.tagLeaveVoidInstruction, "operationData.nodeId");
                    }
                    b.statement("doCreateExceptionHandler(operationData.handlerStartBci, bci, HANDLER_TAG_EXCEPTIONAL, operationData.nodeId, operationData.startStackHeight)");
                    b.statement("needsRewind = true");
                    b.end();
                    b.statement("break");
                    b.end();
                }
                if (operationKind == OperationModel.OperationKind.RETURN && BytecodeRootNodeElement.this.model.epilogReturn != null) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.epilogReturn.operation)).end();
                    b.startBlock();
                    this.buildEmitOperationInstruction(b, BytecodeRootNodeElement.this.model.epilogReturn.operation, "childBci", "i", null);
                    b.statement("childBci = bci - " + BytecodeRootNodeElement.this.model.epilogReturn.operation.instruction.getInstructionLength());
                    b.statement("break");
                    b.end();
                }
                for (OperationModel.OperationKind finallyOpKind : List.of(OperationModel.OperationKind.TRY_FINALLY, OperationModel.OperationKind.TRY_CATCH_OTHERWISE)) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.findOperation(finallyOpKind))).end();
                    b.startBlock();
                    this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryFinallyOperation, "i");
                    b.startIf().string("operationStack[i].childCount == 0 /* still in try */").end().startBlock();
                    b.startIf().string("reachable").end().startBlock();
                    this.emitExtraExceptionTableEntry(b);
                    b.statement("needsRewind = true");
                    b.end();
                    b.statement("doEmitFinallyHandler(operationData, i)");
                    b.end();
                    b.statement("break");
                    b.end();
                }
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TRY_CATCH))).end();
                b.startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryCatchOperation, "i");
                b.startIf().string("operationStack[i].childCount == 0 /* still in try */ && reachable").end().startBlock();
                this.emitExtraExceptionTableEntry(b);
                b.statement("needsRewind = true");
                b.end();
                b.statement("break");
                b.end();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.sourceSectionOperation)).end();
                b.startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.sourceSectionOperation, "i");
                b.startStatement().startCall("doEmitSourceInfo");
                b.string("operationData.sourceIndex");
                b.string("operationData.startBci");
                b.string("bci");
                b.string("operationData.start");
                b.string("operationData.length");
                b.end(2);
                b.statement("needsRewind = true");
                b.statement("break");
                b.end();
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.blockOperation)).end();
                    b.startBlock();
                    this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.blockOperation, "i");
                    b.startFor().string("int j = 0; j < operationData.numLocals; j++").end().startBlock();
                    b.statement("locals[operationData.locals[j] + LOCALS_OFFSET_END_BCI] = bci");
                    if (operationKind == OperationModel.OperationKind.BRANCH) {
                        this.buildEmitInstruction(b, BytecodeRootNodeElement.this.model.clearLocalInstruction, BytecodeRootNodeElement.safeCastShort("locals[operationData.locals[j] + LOCALS_OFFSET_FRAME_INDEX]"));
                    }
                    b.statement("needsRewind = true");
                    b.end();
                    b.statement("break");
                    b.end();
                }
                b.end();
            });
        }

        private void emitExtraExceptionTableEntry(CodeTreeBuilder b) {
            b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerTableIndex");
            b.string("doCreateExceptionHandler(operationData.tryStartBci, bci, HANDLER_CUSTOM, -operationData.handlerId, ", UNINIT, " /* stack height */)");
            b.end();
            b.startIf().string("handlerTableIndex != ", UNINIT).end().startBlock();
            b.startIf().string("operationData.extraTableEntriesStart == ", UNINIT).end().startBlock();
            b.statement("operationData.extraTableEntriesStart = handlerTableIndex");
            b.end();
            b.statement("operationData.extraTableEntriesEnd = handlerTableIndex + EXCEPTION_HANDLER_LENGTH");
            b.end();
        }

        private void emitRewindBeforeEarlyExit(CodeTreeBuilder b, OperationModel.OperationKind operationKind, String lowestOperationIndex) {
            b.startJavadoc();
            b.string("Now that all \"exit\" instructions have been emitted, reopen bytecode ranges.").newLine();
            b.end();
            b.startIf().string("needsRewind").end().startBlock();
            this.buildOperationStackWalkFromBottom(b, lowestOperationIndex, () -> {
                b.startSwitch().string("operationStack[i].operation").end().startBlock();
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.tagOperation)).end();
                    b.startBlock();
                    this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tagOperation, "i");
                    b.statement("operationData.handlerStartBci = bci");
                    b.statement("break");
                    b.end();
                }
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TRY_FINALLY))).end();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TRY_CATCH_OTHERWISE))).end();
                b.startCaseBlock();
                b.startIf().string("operationStack[i].childCount == 0 /* still in try */").end().startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryFinallyOperation, "i");
                b.statement("operationData.tryStartBci = bci");
                b.end();
                b.statement("break");
                b.end();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.findOperation(OperationModel.OperationKind.TRY_CATCH))).end();
                b.startCaseBlock();
                b.startIf().string("operationStack[i].childCount == 0 /* still in try */").end().startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.tryCatchOperation, "i");
                b.statement("operationData.tryStartBci = bci");
                b.end();
                b.statement("break");
                b.end();
                b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.sourceSectionOperation)).end();
                b.startBlock();
                this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.sourceSectionOperation, "i");
                b.statement("operationData.startBci = bci");
                b.statement("break");
                b.end();
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(BytecodeRootNodeElement.this.model.blockOperation)).end();
                    b.startBlock();
                    this.emitCastOperationData(b, BytecodeRootNodeElement.this.model.blockOperation, "i");
                    b.startFor().string("int j = 0; j < operationData.numLocals; j++").end().startBlock();
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "prevTableIndex", "operationData.locals[j]");
                    if (operationKind != OperationModel.OperationKind.BRANCH) {
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci", "locals[prevTableIndex + LOCALS_OFFSET_END_BCI]");
                        b.startIf().string("endBci == bci").end().startBlock();
                        b.lineComment("No need to split. Reuse the existing entry.");
                        b.statement("locals[prevTableIndex + LOCALS_OFFSET_END_BCI] = ", UNINIT);
                        b.statement("continue");
                        b.end();
                    }
                    b.lineComment("Create a new table entry with a new bytecode range and the same metadata.");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", "locals[prevTableIndex + LOCALS_OFFSET_LOCAL_INDEX]");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "locals[prevTableIndex + LOCALS_OFFSET_FRAME_INDEX]");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameIndex", "locals[prevTableIndex + LOCALS_OFFSET_NAME]");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoIndex", "locals[prevTableIndex + LOCALS_OFFSET_INFO]");
                    b.statement("operationData.locals[j] = doEmitLocal(localIndex, frameIndex, nameIndex, infoIndex)");
                    b.end();
                    b.end();
                }
                b.end();
            });
            b.end();
        }

        private String[] buildTagLeaveArguments(InstructionModel instr) {
            InstructionModel.InstructionImmediate operandIndex = instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX);
            String[] args = operandIndex == null ? new String[]{"operationData.nodeId"} : new String[]{"operationData.nodeId", "childBci"};
            return args;
        }

        private CodeExecutableElement createAllocateNode() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "allocateNode", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("!reachable").end().startBlock();
            b.statement("return -1");
            b.end();
            b.startReturn().startCall("checkOverflowInt");
            b.string("numNodes++");
            b.doubleQuote("Node counter");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createAllocateBytecodeLocal() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Short.TYPE), "allocateBytecodeLocal", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startCall("checkOverflowShort");
            b.string("(short) numLocals++");
            b.doubleQuote("Number of locals");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createAllocateBranchProfile() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "allocateBranchProfile", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("!reachable").end().startBlock();
            b.statement("return -1");
            b.end();
            b.startReturn().startCall("checkOverflowInt");
            b.string("numConditionalBranches++");
            b.doubleQuote("Number of branch profiles");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createAllocateContinuationConstant() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Short.TYPE), "allocateContinuationConstant", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.string("constantPool.allocateSlot()");
            b.end();
            return ex;
        }

        static final class SavedStateElement
        extends CodeTypeElement {
            SavedStateElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementKind.CLASS, null, "SavedState");
            }

            void lazyInit(List<CodeVariableElement> builderState) {
                this.addAll(builderState);
                this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            }
        }

        final class OperationStackEntryElement
        extends CodeTypeElement {
            OperationStackEntryElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementKind.CLASS, null, "OperationStackEntry");
            }

            private void lazyInit() {
                this.addAll(List.of(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "operation"), new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Object.class), "data"), new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "sequenceNumber")));
                CodeVariableElement childCount = new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "childCount");
                childCount.createInitBuilder().string("0").end();
                CodeVariableElement declaredLabels = new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(ArrayList.class), (TypeMirror)BytecodeRootNodeElement.this.types.BytecodeLabel), "declaredLabels");
                declaredLabels.createInitBuilder().string("null").end();
                this.add(childCount);
                this.add(declaredLabels);
                this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null, Set.of("childCount", "declaredLabels")));
                this.add(this.createAddDeclaredLabel());
                this.add(this.createToString0());
                this.add(this.createToString1());
            }

            private CodeExecutableElement createAddDeclaredLabel() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "addDeclaredLabel", new CodeVariableElement[0]);
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLabel, "label"));
                CodeTreeBuilder b = ex.createBuilder();
                b.startIf().string("declaredLabels == null").end().startBlock();
                b.statement("declaredLabels = new ArrayList<>(8)");
                b.end();
                b.statement("declaredLabels.add(label)");
                return ex;
            }

            private CodeExecutableElement createToString0() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.context.getDeclaredType(Object.class), "toString");
                CodeTreeBuilder b = ex.createBuilder();
                b.statement("return \"(\" + toString(null) + \")\"");
                return ex;
            }

            private CodeExecutableElement createToString1() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(String.class), "toString", new CodeVariableElement[0]);
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.bytecodeBuilderType, "builder"));
                CodeTreeBuilder b = ex.createBuilder();
                b.startDeclaration(BytecodeRootNodeElement.this.type(StringBuilder.class), "b").startNew(BytecodeRootNodeElement.this.type(StringBuilder.class)).end().end();
                b.startStatement().startCall("b.append").string("OPERATION_NAMES[operation]").end().end();
                b.startSwitch().string("operation").end().startBlock();
                for (OperationModel op : BytecodeRootNodeElement.this.model.getOperations()) {
                    switch (op.kind) {
                        case STORE_LOCAL: 
                        case STORE_LOCAL_MATERIALIZED: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(" ").end().end();
                            b.declaration(BuilderElement.this.getDataClassName(op), "operationData", "(" + BuilderElement.this.getDataClassName(op) + ") data");
                            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                                b.startStatement().startCall("b.append").string("operationData.local.frameIndex").end().end();
                            } else {
                                b.startStatement().startCall("b.append").string("operationData.frameIndex").end().end();
                            }
                            b.end();
                            b.statement("break");
                            break;
                        }
                        case SOURCE: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(" ").end().end();
                            b.declaration(BuilderElement.this.getDataClassName(op), "operationData", "(" + BuilderElement.this.getDataClassName(op) + ") data");
                            b.startStatement().startCall("b.append").string("operationData.sourceIndex").end().end();
                            b.startIf().string("builder != null").end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(":").end().end();
                            b.startStatement().startCall("b.append").string("builder.sources.get(operationData.sourceIndex).getName()").end().end();
                            b.end();
                            b.end();
                            b.statement("break");
                            break;
                        }
                        case SOURCE_SECTION: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(" ").end().end();
                            b.declaration(BuilderElement.this.getDataClassName(op), "operationData", "(" + BuilderElement.this.getDataClassName(op) + ") data");
                            b.startStatement().startCall("b.append").string("operationData.start").end().end();
                            b.startStatement().startCall("b.append").doubleQuote(":").end().end();
                            b.startStatement().startCall("b.append").string("operationData.length").end().end();
                            b.end();
                            b.statement("break");
                            break;
                        }
                        case TAG: {
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(" ").end().end();
                            b.declaration(BuilderElement.this.getDataClassName(op), "operationData", "(" + BuilderElement.this.getDataClassName(op) + ") data");
                            b.startStatement().startCall("b.append").string("operationData.node").end().end();
                            b.end();
                            b.statement("break");
                            break;
                        }
                        case ROOT: 
                        case BLOCK: {
                            if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                            b.startCase().tree(BytecodeRootNodeElement.this.createOperationConstant(op)).end().startBlock();
                            b.declaration(BuilderElement.this.getDataClassName(op), "operationData", "(" + BuilderElement.this.getDataClassName(op) + ") data");
                            b.startIf().string("operationData.numLocals > 0").end().startBlock();
                            b.startStatement().startCall("b.append").doubleQuote(" locals=").end().end();
                            b.startStatement().startCall("b.append").string("operationData.numLocals").end().end();
                            b.end();
                            b.end();
                            b.statement("break");
                        }
                    }
                }
                b.end();
                b.statement("return b.toString()");
                return ex;
            }
        }

        final class ConstantPoolElement
        extends CodeTypeElement {
            ConstantPoolElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementKind.CLASS, null, "ConstantPool");
                List<CodeVariableElement> fields = List.of(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.type(Object.class)), "constants"), new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(HashMap.class, BytecodeRootNodeElement.this.type(Object.class), BytecodeRootNodeElement.this.context.getDeclaredType(Integer.class)), "map"));
                this.addAll(fields);
                CodeExecutableElement ctor = GeneratorUtils.createConstructorUsingFields(Set.of(), this, null, Set.of("constants", "map"));
                CodeTreeBuilder b = ctor.appendBuilder();
                b.statement("constants = new ArrayList<>()");
                b.statement("map = new HashMap<>()");
                this.add(ctor);
                this.add(this.createAddConstant());
                this.add(this.createAllocateSlot());
                this.add(this.createToArray());
            }

            private CodeExecutableElement createAddConstant() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "addConstant", new CodeVariableElement[0]);
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "constant"));
                CodeTreeBuilder b = ex.createBuilder();
                b.startIf().string("map.containsKey(constant)").end().startBlock();
                b.startReturn().string("map.get(constant)").end();
                b.end();
                b.statement("int index = constants.size()");
                b.statement("constants.add(constant)");
                b.statement("map.put(constant, index)");
                b.startReturn().string("index").end();
                return ex;
            }

            private CodeExecutableElement createAllocateSlot() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Short.TYPE), "allocateSlot", new CodeVariableElement[0]);
                CodeTreeBuilder doc = ex.createDocBuilder();
                doc.startJavadoc();
                doc.string("Allocates a slot for a constant which will be manually added to the constant pool later.");
                doc.newLine();
                doc.end();
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "index", BytecodeRootNodeElement.safeCastShort("constants.size()"));
                b.statement("constants.add(null)");
                b.startReturn().string("index").end();
                return ex;
            }

            private CodeExecutableElement createToArray() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), new CodeTypeMirror.ArrayCodeTypeMirror(BytecodeRootNodeElement.this.type(Object.class)), "toArray", new CodeVariableElement[0]);
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn().string("constants.toArray()").end();
                return ex;
            }
        }

        final class BytecodeLocalImplElement
        extends CodeTypeElement {
            BytecodeLocalImplElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "BytecodeLocalImpl");
            }

            void lazyInit() {
                this.setSuperClass(BytecodeRootNodeElement.this.types.BytecodeLocal);
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Short.TYPE), "frameIndex"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Short.TYPE), "localIndex"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Short.TYPE), "rootIndex"));
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BuilderElement.this.scopeDataType.asType(), "scope"));
                }
                CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
                CodeTree tree = constructor.getBodyTree();
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
                b.tree(tree);
                this.add(this.createGetLocalOffset());
                this.add(this.createGetLocalIndex());
            }

            private CodeExecutableElement createGetLocalOffset() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeLocal, "getLocalOffset");
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn().string("frameIndex - USER_LOCALS_START_INDEX").end();
                return ex;
            }

            private CodeExecutableElement createGetLocalIndex() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeLocal, "getLocalIndex");
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn().string("localIndex").end();
                return ex;
            }
        }

        final class BytecodeLabelImplElement
        extends CodeTypeElement {
            BytecodeLabelImplElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "BytecodeLabelImpl");
            }

            void lazyInit() {
                this.setSuperClass(BytecodeRootNodeElement.this.types.BytecodeLabel);
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "id"));
                this.add(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "declaringOp"));
                CodeExecutableElement constructor = GeneratorUtils.createConstructorUsingFields(Set.of(), this, null);
                CodeTree tree = constructor.getBodyTree();
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
                b.tree(tree);
                this.add(constructor);
                this.add(this.createIsDefined());
                this.add(this.createEquals());
                this.add(this.createHashCode());
            }

            private CodeExecutableElement createIsDefined() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Boolean.TYPE), "isDefined", new CodeVariableElement[0]);
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn().string("bci != -1").end();
                return ex;
            }

            private CodeExecutableElement createEquals() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Boolean.TYPE), "equals", new CodeVariableElement[0]);
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "other"));
                CodeTreeBuilder b = ex.createBuilder();
                b.startIf().string("!(other instanceof BytecodeLabelImpl)").end().startBlock();
                b.returnFalse();
                b.end();
                b.startReturn().string("this.id == ((BytecodeLabelImpl) other).id").end();
                return ex;
            }

            private CodeExecutableElement createHashCode() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "hashCode", new CodeVariableElement[0]);
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn().string("this.id").end();
                return ex;
            }
        }

        class OperationDataClassesFactory {
            OperationDataClassesFactory() {
            }

            private Collection<CodeTypeElement> create() {
                ArrayList<CodeTypeElement> result = new ArrayList<CodeTypeElement>();
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    BuilderElement.this.scopeDataType = new ScopeDataElement();
                    result.add(BuilderElement.this.scopeDataType);
                }
                LinkedHashMap<String, CodeTypeElement> dataClassNames = new LinkedHashMap<String, CodeTypeElement>();
                for (OperationModel operation : BytecodeRootNodeElement.this.model.getOperations()) {
                    CodeTypeElement type = BuilderElement.this.dataClasses.get(operation);
                    if (type == null && (type = this.createDataClass(operation)) != null) {
                        String name = type.getSimpleName().toString();
                        CodeTypeElement typeSameName = (CodeTypeElement)dataClassNames.get(name);
                        if (typeSameName == null) {
                            dataClassNames.put(name, type);
                        } else {
                            type = typeSameName;
                        }
                    }
                    BuilderElement.this.dataClasses.put(operation, type);
                }
                result.addAll(dataClassNames.values());
                return result;
            }

            private CodeTypeElement createDataClass(OperationModel operation) {
                List<Object> fields;
                String name = null;
                TypeMirror superType = null;
                List methods = List.of();
                switch (operation.kind) {
                    case ROOT: {
                        name = "RootData";
                        fields = new ArrayList(5);
                        fields.addAll(List.of(this.field(BytecodeRootNodeElement.this.type(Short.TYPE), "index").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "reachable").withInitializer("true")));
                        if (BytecodeRootNodeElement.this.model.prolog != null && BytecodeRootNodeElement.this.model.prolog.operation.operationEndArguments.length != 0) {
                            fields.add(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "prologBci").withInitializer(BuilderElement.UNINIT));
                        }
                        if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                        superType = BuilderElement.this.scopeDataType.asType();
                        break;
                    }
                    case BLOCK: {
                        name = "BlockData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "startStackHeight").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                        if (!BytecodeRootNodeElement.this.model.enableBlockScoping) break;
                        superType = BuilderElement.this.scopeDataType.asType();
                        break;
                    }
                    case TAG: {
                        name = "TagOperationData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeId").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "operationReachable").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "startStackHeight").asFinal(), this.field(BytecodeRootNodeElement.this.tagNode.asType(), "node").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerStartBci").withInitializer("node.enterBci"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT), this.field(ElementHelpers.generic(BytecodeRootNodeElement.this.type(List.class), BytecodeRootNodeElement.this.tagNode.asType()), "children").withInitializer("null"));
                        break;
                    }
                    case SOURCE_SECTION: {
                        name = "SourceSectionData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceIndex").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "start").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "length").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case SOURCE: {
                        name = "SourceData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceIndex").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case RETURN: {
                        name = "ReturnOperationData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case STORE_LOCAL: 
                    case STORE_LOCAL_MATERIALIZED: {
                        if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                            name = "StoreLocalData";
                            fields = List.of(this.field(BuilderElement.this.bytecodeLocalImpl.asType(), "local"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                            break;
                        }
                        name = null;
                        fields = List.of();
                        break;
                    }
                    case IF_THEN: {
                        name = "IfThenData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "thenReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "falseBranchFixupBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case IF_THEN_ELSE: {
                        name = "IfThenElseData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "thenReachable"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "elseReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "falseBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case CONDITIONAL: {
                        name = "ConditionalData";
                        if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                            fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "thenReachable"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "elseReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "falseBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "child0Bci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "child1Bci").withInitializer(BuilderElement.UNINIT));
                            break;
                        }
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "thenReachable"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "elseReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "falseBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case WHILE: {
                        name = "WhileData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "whileStartBci").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "bodyReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case TRY_CATCH: {
                        name = "TryCatchData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerId").asFinal(), this.field(BytecodeRootNodeElement.this.type(Short.TYPE), "stackHeight").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "tryStartBci"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "operationReachable").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "tryReachable"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "catchReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "extraTableEntriesStart").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "extraTableEntriesEnd").withInitializer(BuilderElement.UNINIT));
                        break;
                    }
                    case TRY_FINALLY: 
                    case TRY_CATCH_OTHERWISE: {
                        name = "TryFinallyData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerId").asFinal(), this.field(BytecodeRootNodeElement.this.type(Short.TYPE), "stackHeight").asFinal(), this.field(BytecodeRootNodeElement.this.context.getDeclaredType(Runnable.class), "finallyGenerator").asFinal(), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "tryStartBci"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "operationReachable").asFinal(), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "tryReachable"), this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "catchReachable"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBranchFixupBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "extraTableEntriesStart").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "extraTableEntriesEnd").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "finallyHandlerSp").withInitializer(BuilderElement.UNINIT).withDoc("The index of the finally handler operation on the operation stack.\nThis value is uninitialized unless a finally handler is being emitted, and allows us to\nwalk the operation stack from bottom to top.\n"));
                        break;
                    }
                    case FINALLY_HANDLER: {
                        name = "FinallyHandlerData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "finallyOperationSp").asFinal().withDoc("The index of the finally operation (TryFinally/TryCatchOtherwise) on the operation stack.\nThis index should only be used to skip over the handler when walking the operation stack.\nIt should *not* be used to access the finally operation data, because a FinallyHandler is\nsometimes emitted after the finally operation has already been popped.\n"));
                        break;
                    }
                    case CUSTOM: 
                    case CUSTOM_INSTRUMENTATION: {
                        if (operation.isTransparent()) {
                            name = "TransparentData";
                            fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue").withInitializer("false"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT));
                            break;
                        }
                        name = "CustomOperationData";
                        fields = List.of(this.field(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "childBcis").asFinal(), this.field(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "constants").asFinal(), this.field(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.context.getDeclaredType(Object.class)), "locals").asFinal().asVarArgs());
                        break;
                    }
                    case CUSTOM_SHORT_CIRCUIT: {
                        name = "CustomShortCircuitOperationData";
                        fields = List.of(this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci").withInitializer(BuilderElement.UNINIT), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "shortCircuitBci").withInitializer(BuilderElement.UNINIT), this.field(ElementHelpers.generic(List.class, Integer.class), "branchFixupBcis").withInitializer("new ArrayList<>(4)"));
                        break;
                    }
                    default: {
                        if (operation.isTransparent()) {
                            name = "TransparentData";
                            fields = List.of(this.field(BytecodeRootNodeElement.this.type(Boolean.TYPE), "producedValue"), this.field(BytecodeRootNodeElement.this.type(Integer.TYPE), "childBci"));
                            break;
                        }
                        name = null;
                        fields = List.of();
                    }
                }
                if (name == null) {
                    return null;
                }
                CodeTypeElement result = new CodeTypeElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, name);
                if (superType != null) {
                    result.setSuperClass(superType);
                }
                result.getEnclosedElements().addAll(methods);
                HashSet<String> ignoreFields = new HashSet<String>();
                boolean isVarArgs = false;
                for (DataClassField dataClassField : fields) {
                    if (dataClassField.initializer != null) {
                        ignoreFields.add(dataClassField.name);
                    }
                    isVarArgs = isVarArgs || dataClassField.isVarArgs;
                    result.add(dataClassField.toCodeVariableElement());
                }
                CodeExecutableElement ctor = GeneratorUtils.createConstructorUsingFields(Set.of(), result, null, ignoreFields);
                CodeTreeBuilder codeTreeBuilder = ctor.appendBuilder();
                for (DataClassField dataClassField : fields) {
                    if (dataClassField.initializer == null) continue;
                    codeTreeBuilder.startAssign("this." + dataClassField.name);
                    codeTreeBuilder.string(dataClassField.initializer);
                    codeTreeBuilder.end();
                }
                ctor.setVarArgs(isVarArgs);
                result.add(ctor);
                return result;
            }

            private DataClassField field(TypeMirror type, String name) {
                return new DataClassField(type, name);
            }

            private CodeExecutableElement createRegisterLocal() {
                CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "registerLocal", new CodeVariableElement[0]);
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableIndex"));
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localTableIndex", "numLocals++");
                b.startIf().string("locals == null").end().startBlock();
                b.startAssign("locals").startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), CodeTreeBuilder.singleString("8")).end().end();
                b.end();
                b.startElseIf().string("localTableIndex >= locals.length").end().startBlock();
                b.startAssign("locals").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
                b.string("locals");
                b.string("locals.length * 2");
                b.end(2);
                b.end();
                b.statement("locals[localTableIndex] = tableIndex");
                return ex;
            }

            final class ScopeDataElement
            extends CodeTypeElement {
                ScopeDataElement() {
                    super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.ABSTRACT), ElementKind.CLASS, null, "ScopeData");
                    this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.type(Integer.TYPE), "frameOffset"));
                    CodeVariableElement locals = new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.type(int[].class), "locals");
                    locals.createInitBuilder().string("null");
                    BytecodeRootNodeElement.addJavadoc(locals, "The indices of this scope's locals in the global locals table. Used to patch in the end bci at the end of the scope.");
                    this.add(locals);
                    CodeVariableElement numLocals = new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.type(Integer.TYPE), "numLocals");
                    numLocals.createInitBuilder().string("0");
                    BytecodeRootNodeElement.addJavadoc(numLocals, "The number of locals allocated in the frame for this scope.");
                    this.add(numLocals);
                    this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.type(Boolean.TYPE), "valid")).createInitBuilder().string("true");
                    this.add(OperationDataClassesFactory.this.createRegisterLocal());
                }
            }

            private static final class DataClassField {
                final TypeMirror type;
                final String name;
                boolean isFinal;
                boolean isVarArgs;
                String initializer;
                String doc;

                DataClassField(TypeMirror type, String name) {
                    this.type = type;
                    this.name = name;
                }

                DataClassField asFinal() {
                    this.isFinal = true;
                    return this;
                }

                DataClassField asVarArgs() {
                    this.isVarArgs = true;
                    return this;
                }

                DataClassField withInitializer(String newInitializer) {
                    this.initializer = newInitializer;
                    return this;
                }

                DataClassField withDoc(String newDoc) {
                    this.doc = newDoc;
                    return this;
                }

                CodeVariableElement toCodeVariableElement() {
                    Set<Modifier> mods = this.isFinal ? Set.of(Modifier.FINAL) : Set.of();
                    CodeVariableElement result = new CodeVariableElement(mods, this.type, this.name);
                    if (this.doc != null) {
                        BytecodeRootNodeElement.addJavadoc(result, this.doc);
                    }
                    return result;
                }
            }
        }

        final class SerializationRootNodeElement
        extends CodeTypeElement {
            SerializationRootNodeElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SerializationRootNode");
                this.setSuperClass(BytecodeRootNodeElement.this.model.templateType.asType());
                List<CodeVariableElement> fields = List.of(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "contextDepth"), new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "rootIndex"));
                this.addAll(fields);
                this.add(this.createConstructor(this, fields));
            }

            private CodeExecutableElement createConstructor(CodeTypeElement serializationRoot, List<CodeVariableElement> fields) {
                CodeExecutableElement ctor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, serializationRoot.getSimpleName().toString(), new CodeVariableElement[0]);
                ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.FrameDescriptor_Builder, "builder"));
                for (CodeVariableElement field : fields) {
                    ctor.addParameter(new CodeVariableElement(field.asType(), field.getName().toString()));
                }
                CodeTreeBuilder b = ctor.getBuilder();
                b.startStatement().startCall("super");
                b.string("null");
                if (BytecodeRootNodeElement.this.model.fdBuilderConstructor != null) {
                    b.string("builder");
                } else {
                    b.string("builder.build()");
                }
                b.end(2);
                for (CodeVariableElement field : fields) {
                    b.startAssign("this", field).variable(field).end();
                }
                return ctor;
            }
        }

        final class SerializationLocalElement
        extends CodeTypeElement {
            SerializationLocalElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SerializationLocal");
                this.setSuperClass(BytecodeRootNodeElement.this.types.BytecodeLocal);
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "contextDepth"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
                CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
                CodeTree tree = constructor.getBodyTree();
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
                b.tree(tree);
                this.add(this.createGetLocalOffset());
                this.add(this.createGetLocalIndex());
            }

            private CodeExecutableElement createGetLocalOffset() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeLocal, "getLocalOffset");
                CodeTreeBuilder b = ex.createBuilder();
                BytecodeRootNodeElement.emitThrowIllegalStateException(ex, b, null);
                return ex;
            }

            private CodeExecutableElement createGetLocalIndex() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeLocal, "getLocalIndex");
                CodeTreeBuilder b = ex.createBuilder();
                BytecodeRootNodeElement.emitThrowIllegalStateException(ex, b, null);
                return ex;
            }
        }

        final class SerializationLabelElement
        extends CodeTypeElement {
            SerializationLabelElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SerializationLabel");
                this.setSuperClass(BytecodeRootNodeElement.this.types.BytecodeLabel);
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "contextDepth"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "labelIndex"));
                CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
                CodeTree tree = constructor.getBodyTree();
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
                b.tree(tree);
            }
        }

        final class SerializationStateElement
        extends CodeTypeElement
        implements ElementHelpers {
            private final CodeVariableElement codeCreateLabel;
            private final CodeVariableElement codeCreateLocal;
            private final CodeVariableElement codeCreateObject;
            private final CodeVariableElement codeCreateNull;
            private final CodeVariableElement codeCreateFinallyGenerator;
            private final CodeVariableElement codeEndFinallyGenerator;
            private final CodeVariableElement codeEndSerialize;
            private final CodeVariableElement buffer;
            private final CodeVariableElement callback;
            private final CodeVariableElement outer;
            private final CodeVariableElement depth;
            private final CodeVariableElement objects;
            private final CodeVariableElement builtNodes;
            private final CodeVariableElement rootStack;
            private final CodeVariableElement labelCount;
            private final CodeVariableElement[] codeBegin;
            private final CodeVariableElement[] codeEnd;

            SerializationStateElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementKind.CLASS, null, "SerializationState");
                this.codeCreateLabel = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$CREATE_LABEL", "-2");
                this.codeCreateLocal = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$CREATE_LOCAL", "-3");
                this.codeCreateObject = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$CREATE_OBJECT", "-4");
                this.codeCreateNull = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$CREATE_NULL", "-5");
                this.codeCreateFinallyGenerator = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$CREATE_FINALLY_GENERATOR", "-6");
                this.codeEndFinallyGenerator = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$END_FINALLY_GENERATOR", "-7");
                this.codeEndSerialize = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_$END", "-8");
                this.buffer = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), DataOutput.class, "buffer");
                this.callback = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.types.BytecodeSerializer, "callback");
                this.outer = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), this.asType(), "outer");
                this.depth = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "depth");
                this.objects = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(HashMap.class, Object.class, Integer.class), "objects");
                this.builtNodes = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.model.getTemplateType().asType()), "builtNodes");
                this.rootStack = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayDeque.class, BytecodeRootNodeElement.this.serializationRootNode.asType()), "rootStack");
                this.labelCount = ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE), Integer.TYPE, "labelCount");
                this.getImplements().add(BytecodeRootNodeElement.this.types.BytecodeSerializer_SerializerContext);
                this.objects.createInitBuilder().startNew("HashMap<>").end();
                this.builtNodes.createInitBuilder().startNew("ArrayList<>").end();
                this.rootStack.createInitBuilder().startNew("ArrayDeque<>").end();
                ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE), Integer.TYPE, "localCount");
                ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE), Short.TYPE, "rootCount");
                ElementHelpers.addField((CodeElement<? super Element>)this, Set.of(Modifier.PRIVATE), Integer.TYPE, "finallyGeneratorCount");
                this.codeBegin = new CodeVariableElement[BytecodeRootNodeElement.this.model.getOperations().size() + 1];
                this.codeEnd = new CodeVariableElement[BytecodeRootNodeElement.this.model.getOperations().size() + 1];
                for (OperationModel o : BytecodeRootNodeElement.this.model.getUserOperations()) {
                    if (o.hasChildren()) {
                        this.codeBegin[o.id] = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_BEGIN_" + ElementUtils.createConstantName(o.name), String.valueOf(o.id) + " << 1");
                        this.codeEnd[o.id] = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_END_" + ElementUtils.createConstantName(o.name), "(" + String.valueOf(o.id) + " << 1) | 0b1");
                        continue;
                    }
                    this.codeBegin[o.id] = ElementHelpers.addField(this, Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), Short.TYPE, "CODE_EMIT_" + ElementUtils.createConstantName(o.name), String.valueOf(o.id) + " << 1");
                }
                this.add(this.createConstructor());
                this.add(this.createPushConstructor());
                this.add(this.createSerializeObject());
                this.add(this.createWriteBytecodeNode());
            }

            private CodeExecutableElement createConstructor() {
                CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
                method.addParameter(new CodeVariableElement(this.buffer.getType(), this.buffer.getName()));
                method.addParameter(new CodeVariableElement(this.callback.getType(), this.callback.getName()));
                CodeTreeBuilder b = method.createBuilder();
                b.startAssign("this", this.buffer).variable(this.buffer).end();
                b.startAssign("this", this.callback).variable(this.callback).end();
                b.startAssign("this", this.outer).string("null").end();
                b.startAssign("this", this.depth).string("0").end();
                return method;
            }

            private CodeExecutableElement createPushConstructor() {
                CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
                method.addParameter(new CodeVariableElement(this.buffer.getType(), this.buffer.getName()));
                method.addParameter(new CodeVariableElement(this.asType(), this.outer.getName()));
                CodeTreeBuilder b = method.createBuilder();
                b.startAssign("this", this.buffer).variable(this.buffer).end();
                b.startAssign("this", this.callback).field(this.outer.getName(), this.callback).end();
                b.startAssign("this", this.outer).variable(this.outer).end();
                b.startAssign("this", this.depth).startCall("safeCastShort").startGroup().field(this.outer.getName(), this.depth).string(" + 1").end(3);
                return method;
            }

            private CodeExecutableElement createWriteBytecodeNode() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeSerializer_SerializerContext, "writeBytecodeNode", new String[]{"buffer", "node"});
                GeneratorUtils.mergeSuppressWarnings(ex, "hiding");
                CodeTreeBuilder b = ex.createBuilder();
                b.startDeclaration(BytecodeRootNodeElement.this.serializationRootNode.asType(), "serializationRoot");
                b.cast(BytecodeRootNodeElement.this.serializationRootNode.asType()).string("node");
                b.end();
                b.statement("buffer.writeInt(serializationRoot.contextDepth)");
                b.statement("buffer.writeInt(serializationRoot.rootIndex)");
                return ex;
            }

            private CodeExecutableElement createSerializeObject() {
                CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "serializeObject", new CodeVariableElement[0]);
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "object"));
                method.addThrownType(BytecodeRootNodeElement.this.type(IOException.class));
                CodeTreeBuilder b = method.createBuilder();
                String argumentName = "object";
                String index = "index";
                b.startDeclaration(BytecodeRootNodeElement.this.declaredType(Integer.class), index).startCall("objects.get").string(argumentName).end(2);
                b.startIf().string(index + " == null").end().startBlock();
                b.startAssign(index).string("objects.size()").end();
                b.startStatement().startCall("objects.put").string(argumentName).string(index).end(2);
                b.startIf().string("object == null").end().startBlock();
                b.startStatement();
                b.string(this.buffer.getName(), ".").startCall("writeShort").string(this.codeCreateNull.getName()).end();
                b.end();
                b.end().startElseBlock();
                b.startStatement();
                b.string(this.buffer.getName(), ".").startCall("writeShort").string(this.codeCreateObject.getName()).end();
                b.end();
                b.statement("callback.serialize(this, buffer, object)");
                b.end();
                b.end();
                b.statement("return ", index);
                return method;
            }

            void writeShort(CodeTreeBuilder b, CodeVariableElement label) {
                this.writeShort(b, b.create().staticReference(label).build());
            }

            void writeShort(CodeTreeBuilder b, String value) {
                this.writeShort(b, CodeTreeBuilder.singleString(value));
            }

            void writeShort(CodeTreeBuilder b, CodeTree value) {
                b.startStatement();
                b.string("serialization.", this.buffer.getName(), ".").startCall("writeShort");
                b.tree(value).end();
                b.end();
            }

            void writeInt(CodeTreeBuilder b, String value) {
                this.writeInt(b, CodeTreeBuilder.singleString(value));
            }

            void writeInt(CodeTreeBuilder b, CodeTree value) {
                b.startStatement();
                b.string("serialization.", this.buffer.getName(), ".").startCall("writeInt");
                b.tree(value).end();
                b.end();
            }

            void writeBytes(CodeTreeBuilder b, String value) {
                this.writeBytes(b, CodeTreeBuilder.singleString(value));
            }

            void writeBytes(CodeTreeBuilder b, CodeTree value) {
                b.startStatement();
                b.string("serialization.", this.buffer.getName(), ".").startCall("write");
                b.tree(value).end();
                b.end();
            }
        }

        final class DeserializationStateElement
        extends CodeTypeElement
        implements ElementHelpers {
            private final CodeVariableElement depth;

            DeserializationStateElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "DeserializationState");
                this.setEnclosingElement(BytecodeRootNodeElement.this);
                this.getImplements().add(BytecodeRootNodeElement.this.types.BytecodeDeserializer_DeserializerContext);
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), this.asType(), "outer"));
                this.depth = this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "depth"));
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, Object.class), "consts")).createInitBuilder().startNew("ArrayList<>").end();
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.asType()), "builtNodes")).createInitBuilder().startNew("ArrayList<>").end();
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(ArrayList.class), (TypeMirror)BytecodeRootNodeElement.this.types.BytecodeLabel), "labels")).createInitBuilder().startNew("ArrayList<>").end();
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(ArrayList.class), (TypeMirror)BytecodeRootNodeElement.this.types.BytecodeLocal), "locals")).createInitBuilder().startNew("ArrayList<>").end();
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.generic(ArrayList.class, Runnable.class), "finallyGenerators")).createInitBuilder().startNew("ArrayList<>").end();
                this.add(this.createConstructor());
                this.add(this.createReadBytecodeNode());
                this.add(this.createGetContext());
            }

            private CodeExecutableElement createConstructor() {
                CodeExecutableElement constructor = new CodeExecutableElement(Set.of(Modifier.PRIVATE), null, this.getSimpleName().toString(), new CodeVariableElement[0]);
                constructor.addParameter(new CodeVariableElement(this.asType(), "outer"));
                CodeTreeBuilder b = constructor.createBuilder();
                b.statement("this.outer = outer");
                b.statement("this.depth = (outer == null) ? 0 : outer.depth + 1");
                return constructor;
            }

            private CodeExecutableElement createReadBytecodeNode() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeDeserializer_DeserializerContext, "readBytecodeNode", new String[]{"buffer"});
                CodeTreeBuilder b = ex.createBuilder();
                b.statement("return getContext(buffer.readInt()).builtNodes.get(buffer.readInt())");
                return ex;
            }

            private CodeExecutableElement createGetContext() {
                CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), this.asType(), "getContext", new CodeVariableElement[0]);
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "targetDepth"));
                CodeTreeBuilder b = method.createBuilder();
                b.startAssert().string("targetDepth >= 0").end();
                b.declaration(this.asType(), "ctx", "this");
                b.startWhile().string("ctx.depth != targetDepth").end().startBlock();
                b.statement("ctx = ctx.outer");
                b.end();
                b.statement("return ctx");
                return method;
            }
        }
    }

    final class BytecodeRootNodesImplElement
    extends CodeTypeElement {
        private CodeTypeElement updateReason;

        BytecodeRootNodesImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "BytecodeRootNodesImpl");
        }

        void lazyInit() {
            this.setSuperClass(ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.types.BytecodeRootNodes, BytecodeRootNodeElement.this.model.templateType.asType()));
            this.setEnclosingElement(BytecodeRootNodeElement.this);
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Object.class), "VISIBLE_TOKEN")).createInitBuilder().string("TOKEN");
            this.add(BytecodeRootNodeElement.this.compFinal(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.VOLATILE), BytecodeRootNodeElement.this.type(Long.TYPE), "encoding")));
            this.updateReason = this.add(this.createUpdateReason());
            this.add(this.createConstructor());
            this.add(this.createReparseImpl());
            this.add(this.createPerformUpdate());
            this.add(this.createSetNodes());
            this.add(this.createGetParserImpl());
            this.add(this.createValidate());
            this.add(this.createGetLanguage());
            if (BytecodeRootNodeElement.this.model.enableSerialization) {
                this.add(this.createSerialize());
            }
        }

        private CodeTypeElement createUpdateReason() {
            DeclaredType charSequence = (DeclaredType)BytecodeRootNodeElement.this.type(CharSequence.class);
            CodeTypeElement reason = new CodeTypeElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "UpdateReason");
            reason.getImplements().add(charSequence);
            reason.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "newSources"));
            reason.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "newInstrumentations"));
            reason.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "newTags"));
            reason.add(GeneratorUtils.createConstructorUsingFields(Set.of(), reason));
            CodeExecutableElement length = reason.add(GeneratorUtils.override(charSequence, "length"));
            length.createBuilder().startReturn().string("toString().length()").end();
            CodeExecutableElement charAt = reason.add(GeneratorUtils.override(charSequence, "charAt", new String[]{"index"}));
            charAt.createBuilder().startReturn().string("toString().charAt(index)").end();
            CodeExecutableElement subSequence = reason.add(GeneratorUtils.override(charSequence, "subSequence", new String[]{"start", "end"}));
            subSequence.createBuilder().startReturn().string("toString().subSequence(start, end)").end();
            CodeExecutableElement toString = reason.add(GeneratorUtils.override(charSequence, "toString"));
            CodeTreeBuilder b = toString.createBuilder();
            b.startStatement().type(BytecodeRootNodeElement.this.type(StringBuilder.class)).string(" message = ").startNew(BytecodeRootNodeElement.this.type(StringBuilder.class)).end().end();
            String message = String.format("%s requested ", ElementUtils.getSimpleName(BytecodeRootNodeElement.this.model.getTemplateType()));
            b.startStatement().startCall("message", "append").doubleQuote(message).end().end();
            b.declaration(BytecodeRootNodeElement.this.type(String.class), "sep", "\"\"");
            b.startIf().string("newSources").end().startBlock();
            message = "SourceInformation";
            b.startStatement().startCall("message", "append").doubleQuote(message).end().end();
            b.startAssign("sep").doubleQuote(", ").end();
            b.end();
            if (!BytecodeRootNodeElement.this.model.getInstrumentations().isEmpty()) {
                b.startIf().string("newInstrumentations != 0").end().startBlock();
                for (CustomOperationModel instrumentation : BytecodeRootNodeElement.this.model.getInstrumentations()) {
                    int index = instrumentation.operation.instrumentationIndex;
                    b.startIf().string("(newInstrumentations & 0x").string(Integer.toHexString(1 << index)).string(") != 0").end().startBlock();
                    b.startStatement().startCall("message", "append").string("sep").end().end();
                    b.startStatement().startCall("message", "append").doubleQuote("Instrumentation[" + instrumentation.operation.name + "]").end().end();
                    b.startAssign("sep").doubleQuote(", ").end();
                    b.end();
                }
                b.end();
            }
            if (!BytecodeRootNodeElement.this.model.getProvidedTags().isEmpty()) {
                b.startIf().string("newTags != 0").end().startBlock();
                int index = 0;
                for (TypeMirror tag : BytecodeRootNodeElement.this.model.getProvidedTags()) {
                    b.startIf().string("(newTags & 0x").string(Integer.toHexString(1 << index)).string(") != 0").end().startBlock();
                    b.startStatement().startCall("message", "append").string("sep").end().end();
                    b.startStatement().startCall("message", "append").doubleQuote("Tag[" + ElementUtils.getSimpleName(tag) + "]").end().end();
                    b.startAssign("sep").doubleQuote(", ").end();
                    b.end();
                    ++index;
                }
                b.end();
            }
            b.startStatement().startCall("message", "append").doubleQuote(".").end().end();
            b.statement("return message.toString()");
            return reason;
        }

        private CodeExecutableElement createConstructor() {
            CodeExecutableElement ctor = new CodeExecutableElement(null, "BytecodeRootNodesImpl");
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.parserType, "generator"));
            ctor.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeConfig, "config"));
            CodeTreeBuilder b = ctor.createBuilder();
            b.statement("super(VISIBLE_TOKEN, generator)");
            b.startAssign("this.encoding");
            b.startStaticCall(BytecodeRootNodeElement.this.configEncoder.asType(), "decode").string("config").end();
            b.end();
            return ctor;
        }

        private CodeExecutableElement createReparseImpl() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeRootNodes, "updateImpl", new String[]{"encoder", "encoding"});
            GeneratorUtils.mergeSuppressWarnings(ex, "hiding");
            CodeTreeBuilder b = ex.createBuilder();
            b.startDeclaration(BytecodeRootNodeElement.this.type(Long.TYPE), "maskedEncoding");
            b.startStaticCall(BytecodeRootNodeElement.this.configEncoder.asType(), "decode").string("encoder").string("encoding").end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Long.TYPE), "oldEncoding", "this.encoding");
            b.declaration(BytecodeRootNodeElement.this.type(Long.TYPE), "newEncoding", "maskedEncoding | oldEncoding");
            b.startIf().string("(oldEncoding | newEncoding) == oldEncoding").end().startBlock();
            b.returnFalse();
            b.end();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.statement("return performUpdate(maskedEncoding)");
            return ex;
        }

        private CodeExecutableElement createPerformUpdate() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.SYNCHRONIZED), BytecodeRootNodeElement.this.type(Boolean.TYPE), "performUpdate", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Long.TYPE), "maskedEncoding"));
            ex.getModifiers().add(Modifier.SYNCHRONIZED);
            CodeTreeBuilder b = ex.createBuilder();
            b.tree(GeneratorUtils.createNeverPartOfCompilation());
            b.declaration(BytecodeRootNodeElement.this.type(Long.TYPE), "oldEncoding", "this.encoding");
            b.declaration(BytecodeRootNodeElement.this.type(Long.TYPE), "newEncoding", "maskedEncoding | oldEncoding");
            b.startIf().string("(oldEncoding | newEncoding) == oldEncoding").end().startBlock();
            b.lineComment("double checked locking");
            b.returnFalse();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "oldSources", "(oldEncoding & 0b1) != 0");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldInstrumentations", "(int)((oldEncoding >> 1) & 0x7FFF_FFFF)");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldTags", "(int)((oldEncoding >> 32) & 0xFFFF_FFFF)");
            b.declaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "newSources", "(newEncoding & 0b1) != 0");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newInstrumentations", "(int)((newEncoding >> 1) & 0x7FFF_FFFF)");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newTags", "(int)((newEncoding >> 32) & 0xFFFF_FFFF)");
            b.statement("boolean needsBytecodeReparse = newInstrumentations != oldInstrumentations || newTags != oldTags");
            b.statement("boolean needsSourceReparse = newSources != oldSources || (needsBytecodeReparse && newSources)");
            b.startIf().string("!needsBytecodeReparse && !needsSourceReparse").end().startBlock();
            b.statement("return false");
            b.end();
            b.declaration(BytecodeRootNodeElement.this.parserType, "parser", "getParserImpl()");
            b.startStatement().type(this.updateReason.asType()).string(" reason = ").startNew(this.updateReason.asType());
            b.string("oldSources != newSources");
            b.string("newInstrumentations & ~oldInstrumentations");
            b.string("newTags & ~oldTags");
            b.end().end();
            b.declaration(BytecodeRootNodeElement.this.builder.getSimpleName().toString(), "builder", b.create().startNew(BytecodeRootNodeElement.this.builder.getSimpleName().toString()).string("this").string("needsBytecodeReparse").string("newTags").string("newInstrumentations").string("needsSourceReparse").string("reason").end().build());
            b.startFor().type(BytecodeRootNodeElement.this.model.templateType.asType()).string(" node : nodes").end().startBlock();
            b.startStatement().startCall("builder.builtNodes.add");
            b.startGroup().cast(BytecodeRootNodeElement.this.asType()).string("node").end();
            b.end(2);
            b.end(2);
            b.startStatement().startCall("parser", "parse").string("builder").end(2);
            b.startStatement().startCall("builder", "finish").end(2);
            b.statement("this.encoding = newEncoding");
            b.statement("return true");
            return ex;
        }

        private CodeExecutableElement createSetNodes() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "setNodes", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.asType()), "nodes"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("this.nodes != null").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class)).end().end();
            b.end();
            b.statement("this.nodes = nodes");
            b.startFor().type(BytecodeRootNodeElement.this.asType()).string(" node : nodes").end().startBlock();
            b.startIf().string("node.getRootNodes() != this").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class)).end().end();
            b.end();
            b.startIf().string("node != nodes[node.buildIndex]").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class)).end().end();
            b.end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetParserImpl() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.parserType, "getParserImpl", new CodeVariableElement[0]);
            GeneratorUtils.mergeSuppressWarnings(ex, "unchecked");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.cast(BytecodeRootNodeElement.this.parserType);
            b.startCall("super.getParser");
            b.end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createValidate() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Boolean.TYPE), "validate", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startFor().type(BytecodeRootNodeElement.this.model.getTemplateType().asType()).string(" node : nodes").end().startBlock();
            b.startStatement().string("(").cast(BytecodeRootNodeElement.this.asType(), "node").string(")").string(".getBytecodeNodeImpl().validateBytecodes()").end();
            b.end();
            b.statement("return true");
            return ex;
        }

        private CodeExecutableElement createGetLanguage() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.model.languageClass, "getLanguage", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("nodes.length == 0").end().startBlock();
            b.startReturn().string("null").end();
            b.end();
            b.startReturn().startCall("nodes[0].getLanguage");
            b.typeLiteral(BytecodeRootNodeElement.this.model.languageClass);
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createSerialize() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeRootNodes, "serialize", new String[]{"buffer", "callback"});
            GeneratorUtils.mergeSuppressWarnings(ex, "cast");
            BytecodeRootNodeElement.addJavadoc(ex, "Serializes the given bytecode nodes\nAll metadata (e.g., source info) is serialized (even if it has not yet been parsed).\n<p>\nThis method serializes the root nodes with their current field values.\n\n@param buffer the buffer to write the byte output to.\n@param callback the language-specific serializer for constants in the bytecode.\n");
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.model.getTemplateType().asType()), "existingNodes", "new ArrayList<>(nodes.length)");
            b.startFor().string("int i = 0; i < nodes.length; i++").end().startBlock();
            b.startStatement().startCall("existingNodes", "add");
            b.startGroup().cast(BytecodeRootNodeElement.this.asType()).string("nodes[i]").end();
            b.end(2);
            b.end();
            b.startStatement();
            b.startStaticCall(BytecodeRootNodeElement.this.asType(), "doSerialize");
            b.string("buffer");
            b.string("callback");
            b.startNew("Builder");
            b.string("getLanguage()");
            b.string("this");
            b.staticReference(BytecodeRootNodeElement.this.types.BytecodeConfig, "COMPLETE");
            b.end();
            b.string("existingNodes");
            b.end(2);
            return ex;
        }
    }

    final class InstructionConstantsElement
    extends CodeTypeElement {
        InstructionConstantsElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "Instructions");
        }

        void lazyInit() {
            for (InstructionModel instruction : BytecodeRootNodeElement.this.model.getInstructions()) {
                CodeVariableElement fld = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Short.TYPE), instruction.getConstantName());
                fld.createInitBuilder().string(instruction.getId()).end();
                fld.createDocBuilder().startDoc().lines(instruction.pp()).end(2);
                this.add(fld);
            }
        }
    }

    final class OperationConstantsElement
    extends CodeTypeElement {
        OperationConstantsElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "Operations");
        }

        void lazyInit() {
            for (OperationModel operation : BytecodeRootNodeElement.this.model.getOperations()) {
                CodeVariableElement fld = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), operation.getConstantName());
                fld.createInitBuilder().string(operation.id).end();
                this.add(fld);
            }
        }
    }

    final class ContinuationRootNodeImplElement
    extends CodeTypeElement {
        ContinuationRootNodeImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "ContinuationRootNodeImpl");
            this.setEnclosingElement(BytecodeRootNodeElement.this);
            this.setSuperClass(BytecodeRootNodeElement.this.types.ContinuationRootNode);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.asType(), "root"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            this.add(BytecodeRootNodeElement.this.compFinal(new CodeVariableElement(Set.of(Modifier.VOLATILE), BytecodeRootNodeElement.this.types.BytecodeLocation, "location")));
        }

        void lazyInit() {
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, ElementFilter.constructorsIn(((TypeElement)BytecodeRootNodeElement.this.types.RootNode.asElement()).getEnclosedElements()).stream().filter(x -> x.getParameters().size() == 2).findFirst().get()));
            CodeTreeBuilder b = constructor.createBuilder();
            b.statement("super(BytecodeRootNodesImpl.VISIBLE_TOKEN, language, frameDescriptor)");
            b.statement("this.root = root");
            b.statement("this.sp = sp");
            b.statement("this.location = location");
            this.add(this.createExecute());
            this.add(this.createGetSourceRootNode());
            this.add(this.createGetLocation());
            this.add(this.createFindFrame());
            this.add(this.createUpdateBytecodeLocation());
            this.add(this.createUpdateBytecodeLocationWithoutInvalidate());
            this.add(this.createCreateContinuation());
            this.add(this.createToString());
            this.add(this.createIsCloningAllowed());
            this.add(this.createIsCloneUninitializedSupported());
            this.addOptional(this.createPrepareForCompilation());
            this.addAll(this.createRootNodeProxyMethods());
        }

        private CodeExecutableElement createExecute() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.RootNode, "execute", new String[]{"frame"});
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.BytecodeLocation, "bytecodeLocation", "location");
            b.startDeclaration(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecodeNode");
            b.startGroup().cast(BytecodeRootNodeElement.this.abstractBytecodeNode.asType()).string("bytecodeLocation.getBytecodeNode()").end();
            b.end();
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.startIf().string("!bytecodeNode.checkStableTagsAssumption()").end().startBlock();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.end();
            }
            b.statement("Object[] args = frame.getArguments()");
            b.startIf().string("args.length != 2").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Expected 2 arguments: (parentFrame, inputValue)");
            b.end();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.MaterializedFrame, "parentFrame", "(MaterializedFrame) args[0]");
            b.declaration(BytecodeRootNodeElement.this.type(Object.class), "inputValue", "args[1]");
            b.startIf().string("parentFrame.getFrameDescriptor() != frame.getFrameDescriptor()").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Invalid continuation parent frame passed");
            b.end();
            b.startIf().string("parentFrame.getClass() != FRAME_TYPE").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Unsupported frame type. Only default frames are supported for continuations.");
            b.end();
            b.lineComment("Copy any existing stack values (from numLocals to sp - 1) to the current frame, which will be used for stack accesses.");
            b.statement(BytecodeRootNodeElement.copyFrameTo("parentFrame", "root.maxLocals", "frame", "root.maxLocals", "sp - 1"));
            b.statement(BytecodeRootNodeElement.setFrameObject(BytecodeRootNodeElement.COROUTINE_FRAME_INDEX, "parentFrame"));
            b.statement(BytecodeRootNodeElement.setFrameObject("root.maxLocals + sp - 1", "inputValue"));
            b.startReturn();
            b.startCall("root.continueAt");
            b.string("bytecodeNode");
            b.string("bytecodeLocation.getBytecodeIndex()");
            b.string("sp + root.maxLocals");
            b.string("frame");
            b.string("parentFrame");
            b.string("this");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createGetSourceRootNode() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ContinuationRootNode, "getSourceRootNode");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("root").end();
            return ex;
        }

        private CodeExecutableElement createGetLocation() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ContinuationRootNode, "getLocation");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("location").end();
            return ex;
        }

        private CodeExecutableElement createFindFrame() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ContinuationRootNode, "findFrame", new String[]{"frame"});
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.cast(BytecodeRootNodeElement.this.types.Frame);
            BytecodeRootNodeElement.startGetFrame(b, "frame", BytecodeRootNodeElement.this.type(Object.class), false).string(BytecodeRootNodeElement.COROUTINE_FRAME_INDEX).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createUpdateBytecodeLocation() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "updateBytecodeLocation", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLocation, "newLocation"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeNode, "oldBytecode"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeNode, "newBytecode"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.context.getDeclaredType(CharSequence.class), "replaceReason"));
            CodeTreeBuilder b = ex.createBuilder();
            b.tree(GeneratorUtils.createNeverPartOfCompilation());
            b.statement("location = newLocation");
            b.startStatement().startCall("reportReplace");
            b.string("oldBytecode");
            b.string("newBytecode");
            b.string("replaceReason");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createUpdateBytecodeLocationWithoutInvalidate() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "updateBytecodeLocationWithoutInvalidate", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLocation, "newLocation"));
            BytecodeRootNodeElement.addJavadoc(ex, String.format("Updates the location without reporting replacement (i.e., without invalidating compiled code).\n<p>\nWe avoid reporting replacement when an update does not change the bytecode (e.g., a source reparse).\nAny code path that depends on observing an up-to-date BytecodeNode (e.g., location computations) should\nnot be compiled (it must be guarded by a {@link %s}).\n", ElementUtils.getSimpleName(BytecodeRootNodeElement.this.types.CompilerDirectives_TruffleBoundary)));
            CodeTreeBuilder b = ex.createBuilder();
            b.tree(GeneratorUtils.createNeverPartOfCompilation());
            b.statement("location = newLocation");
            return ex;
        }

        private CodeExecutableElement createCreateContinuation() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.types.ContinuationResult, "createContinuation", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "result"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startNew(BytecodeRootNodeElement.this.types.ContinuationResult);
            b.string("this");
            b.string("frame.materialize()");
            b.string("result");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createToString() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.context.getDeclaredType(Object.class), "toString");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.startStaticCall(BytecodeRootNodeElement.this.type(String.class), "format");
            b.doubleQuote("%s(resume_bci=%s)");
            b.string("root");
            b.string("location.getBytecodeIndex()");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createIsCloningAllowed() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.RootNode, "isCloningAllowed");
            CodeTreeBuilder b = ex.createBuilder();
            b.lineComment("Continuations are unique.");
            b.startReturn();
            b.string("false");
            b.end();
            return ex;
        }

        private CodeExecutableElement createIsCloneUninitializedSupported() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.RootNode, "isCloneUninitializedSupported");
            CodeTreeBuilder b = ex.createBuilder();
            b.lineComment("Continuations are unique.");
            b.startReturn();
            b.string("false");
            b.end();
            return ex;
        }

        private CodeExecutableElement createPrepareForCompilation() {
            if (!BytecodeRootNodeElement.this.model.enableUncachedInterpreter) {
                return null;
            }
            CodeExecutableElement ex = BytecodeRootNodeElement.overrideImplementRootNodeMethod(BytecodeRootNodeElement.this.model, "prepareForCompilation", new String[]{"rootCompilation", "compilationTier", "lastTier"});
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startCall("root.prepareForCompilation").string("rootCompilation").string("compilationTier").string("lastTier").end(2);
            return ex;
        }

        private List<CodeExecutableElement> createRootNodeProxyMethods() {
            ArrayList<CodeExecutableElement> result = new ArrayList<CodeExecutableElement>();
            List<ExecutableElement> existing = ElementFilter.methodsIn(BytecodeRootNodeElement.this.continuationRootNodeImpl.getEnclosedElements());
            List<ExecutableElement> excludes = List.of(ElementUtils.findMethod(BytecodeRootNodeElement.this.types.RootNode, "copy"), ElementUtils.findMethod(BytecodeRootNodeElement.this.types.RootNode, "cloneUninitialized"));
            block0: for (ExecutableElement rootNodeMethod : ElementUtils.getOverridableMethods((TypeElement)BytecodeRootNodeElement.this.types.RootNode.asElement())) {
                for (ExecutableElement implemented : existing) {
                    if (!ElementUtils.signatureEquals(implemented, rootNodeMethod)) continue;
                    continue block0;
                }
                for (ExecutableElement exclude : excludes) {
                    if (!ElementUtils.signatureEquals(exclude, rootNodeMethod)) continue;
                    continue block0;
                }
                ExecutableElement templateMethod = ElementUtils.findOverride(BytecodeRootNodeElement.this.model.templateType, rootNodeMethod);
                if (templateMethod == null) continue;
                CodeExecutableElement proxyMethod = GeneratorUtils.override(templateMethod);
                CodeTreeBuilder b = proxyMethod.createBuilder();
                boolean isVoid = ElementUtils.isVoid(proxyMethod.getReturnType());
                if (isVoid) {
                    b.startStatement();
                } else {
                    b.startReturn();
                }
                b.startCall("root", rootNodeMethod.getSimpleName().toString());
                for (VariableElement variableElement : rootNodeMethod.getParameters()) {
                    b.variable(variableElement);
                }
                b.end();
                b.end();
                result.add(proxyMethod);
            }
            return result;
        }
    }

    final class ContinuationLocationElement
    extends CodeTypeElement {
        ContinuationLocationElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "ContinuationLocation");
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "constantPoolIndex"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this));
        }
    }

    final class FrameTagConstantsElement
    extends CodeTypeElement {
        private final Map<TypeMirror, VariableElement> mapping;

        FrameTagConstantsElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "FrameTags");
            HashMap<String, TypeMirror> frameTypes = new HashMap<String, TypeMirror>();
            for (TypeMirror boxingEliminatedType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                frameTypes.put(ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxingEliminatedType)), boxingEliminatedType);
            }
            frameTypes.put("Object", BytecodeRootNodeElement.this.declaredType(Object.class));
            frameTypes.put("Illegal", null);
            HashMap<TypeMirror, VariableElement> result = new HashMap<TypeMirror, VariableElement>();
            TypeElement frameSlotKindType = ElementUtils.castTypeElement(BytecodeRootNodeElement.this.types.FrameSlotKind);
            int index = 0;
            for (VariableElement var : ElementFilter.fieldsIn(CompilerFactory.getCompiler(frameSlotKindType).getAllMembersInDeclarationOrder(BytecodeRootNodeElement.this.context.getEnvironment(), frameSlotKindType))) {
                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                String frameSlotKind = var.getSimpleName().toString();
                if (frameTypes.containsKey(frameSlotKind)) {
                    CodeVariableElement fld = new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Byte.TYPE), frameSlotKind.toUpperCase());
                    fld.createInitBuilder().string(index + " /* FrameSlotKind." + frameSlotKind + ".tag */");
                    this.add(fld);
                    result.put((TypeMirror)frameTypes.remove(frameSlotKind), fld);
                }
                ++index;
            }
            if (!frameTypes.isEmpty()) {
                throw new AssertionError((Object)String.format("Could not find a FrameSlotKind for some types: %s", frameTypes.keySet()));
            }
            this.mapping = result;
        }

        private VariableElement get(TypeMirror type) {
            return this.mapping.get(type);
        }

        private VariableElement getObject() {
            return this.mapping.get(BytecodeRootNodeElement.this.declaredType(Object.class));
        }

        private VariableElement getIllegal() {
            return this.mapping.get(null);
        }
    }

    final class InstructionImplElement
    extends CodeTypeElement {
        private CodeTypeElement abstractArgument;

        InstructionImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "InstructionImpl");
            this.setSuperClass(BytecodeRootNodeElement.this.types.Instruction);
        }

        void lazyInit() {
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "opcode"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            CodeTree tree = constructor.getBodyTree();
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.tree(tree);
            this.abstractArgument = this.add(new AbstractArgumentElement());
            this.add(this.createGetBytecodeIndex());
            this.add(this.createGetBytecodeNode());
            this.add(this.createGetOperationCode());
            this.add(this.createGetLength());
            this.add(this.createGetArguments());
            this.add(this.createGetName());
            this.add(this.createIsInstrumentation());
            this.add(this.createNext());
            HashSet<String> generated = new HashSet<String>();
            for (InstructionModel.ImmediateKind kind : InstructionModel.ImmediateKind.values()) {
                String className;
                if (kind == InstructionModel.ImmediateKind.LOCAL_INDEX && !BytecodeRootNodeElement.this.model.localAccessesNeedLocalIndex() && !BytecodeRootNodeElement.this.model.materializedLocalAccessesNeedLocalIndex() || generated.contains(className = InstructionImplElement.getImmediateClassName(kind)) || kind == InstructionModel.ImmediateKind.TAG_NODE && !BytecodeRootNodeElement.this.model.enableTagInstrumentation) continue;
                CodeTypeElement implType = this.add(new ArgumentElement(kind));
                this.abstractArgument.getPermittedSubclasses().add(implType.asType());
                generated.add(className);
            }
        }

        private CodeExecutableElement createGetBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bci");
            return ex;
        }

        private CodeExecutableElement createNext() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "next");
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nextBci", "getNextBytecodeIndex()");
            b.startIf().string("nextBci >= bytecode.bytecodes.length").end().startBlock();
            b.returnNull();
            b.end();
            b.startReturn().startNew(this.asType()).string("bytecode").string("nextBci").string("bytecode.readValidBytecode(bytecode.bytecodes, nextBci)").end().end();
            return ex;
        }

        private CodeExecutableElement createGetBytecodeNode() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getBytecodeNode");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode");
            return ex;
        }

        private CodeExecutableElement createGetName() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getName");
            CodeTreeBuilder b = ex.createBuilder();
            b.startSwitch().string("opcode").end().startBlock();
            for (InstructionModel instruction : BytecodeRootNodeElement.this.model.getInstructions()) {
                b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                b.startCaseBlock();
                b.startReturn().doubleQuote(instruction.name).end();
                b.end();
            }
            b.end();
            b.tree(GeneratorUtils.createShouldNotReachHere("Invalid opcode"));
            return ex;
        }

        private CodeExecutableElement createIsInstrumentation() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "isInstrumentation");
            CodeTreeBuilder b = ex.createBuilder();
            Map<Boolean, List<InstructionModel>> grouped = this.groupInstructionsByInstrumentation(BytecodeRootNodeElement.this.model.getInstructions());
            if (!grouped.containsKey(true)) {
                b.startReturn().string("false").end();
                return ex;
            }
            b.startSwitch().string("opcode").end().startBlock();
            for (Map.Entry<Boolean, List<InstructionModel>> entry : grouped.entrySet()) {
                for (InstructionModel instruction : entry.getValue()) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                b.startReturn().string(Boolean.toString(entry.getKey())).end();
                b.end();
            }
            b.end();
            b.tree(GeneratorUtils.createShouldNotReachHere("Invalid opcode"));
            return ex;
        }

        private CodeExecutableElement createGetLength() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getLength");
            CodeTreeBuilder b = ex.createBuilder();
            b.startSwitch().string("opcode").end().startBlock();
            for (List<InstructionModel> instructions : BytecodeRootNodeElement.groupInstructionsByLength(BytecodeRootNodeElement.this.model.getInstructions())) {
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                InstructionModel instruction = instructions.get(0);
                b.startCaseBlock();
                b.startReturn().string(instruction.getInstructionLength()).end();
                b.end();
            }
            b.end();
            b.tree(GeneratorUtils.createShouldNotReachHere("Invalid opcode"));
            return ex;
        }

        private CodeExecutableElement createGetArguments() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getArguments");
            CodeTreeBuilder b = ex.createBuilder();
            b.startSwitch().string("opcode").end().startBlock();
            for (List<InstructionModel> instructions : this.groupInstructionsByImmediates(BytecodeRootNodeElement.this.model.getInstructions())) {
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                InstructionModel instruction = instructions.get(0);
                b.startCaseBlock();
                b.startReturn().startStaticCall(BytecodeRootNodeElement.this.type(List.class), "of");
                for (InstructionModel.InstructionImmediate immediate : instruction.getImmediates()) {
                    b.startGroup();
                    b.newLine();
                    b.startIndention();
                    b.startNew(InstructionImplElement.getImmediateClassName(immediate.kind()));
                    b.string("bytecode");
                    b.doubleQuote(this.getIntrospectionArgumentName(immediate));
                    b.string("bci + " + immediate.offset());
                    for (String arg : InstructionImplElement.getImmediateArgumentArgs(immediate.kind())) {
                        b.string(arg);
                    }
                    b.end();
                    b.end();
                    b.end();
                }
                b.end().end();
                b.end();
            }
            b.end();
            b.tree(GeneratorUtils.createShouldNotReachHere("Invalid opcode"));
            return ex;
        }

        private String getIntrospectionArgumentName(InstructionModel.InstructionImmediate immediate) {
            if (immediate.kind() == InstructionModel.ImmediateKind.FRAME_INDEX) {
                return "local_offset";
            }
            return immediate.name();
        }

        private Map<Boolean, List<InstructionModel>> groupInstructionsByInstrumentation(Collection<InstructionModel> models) {
            return models.stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(InstructionModel::isInstrumentation));
        }

        private Collection<List<InstructionModel>> groupInstructionsByImmediates(Collection<InstructionModel> models) {
            return models.stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(m -> m.getImmediates())).values().stream().sorted(Comparator.comparingInt(i -> ((InstructionModel)i.get(0)).getId())).toList();
        }

        private CodeExecutableElement createGetOperationCode() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction, "getOperationCode");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("opcode").end();
            return ex;
        }

        private static String getImmediateClassName(InstructionModel.ImmediateKind kind) {
            switch (kind) {
                case BRANCH_PROFILE: {
                    return "BranchProfileArgument";
                }
                case BYTECODE_INDEX: {
                    return "BytecodeIndexArgument";
                }
                case CONSTANT: {
                    return "ConstantArgument";
                }
                case FRAME_INDEX: {
                    return "LocalOffsetArgument";
                }
                case LOCAL_INDEX: {
                    return "LocalIndexArgument";
                }
                case LOCAL_ROOT: 
                case SHORT: 
                case STACK_POINTER: {
                    return "IntegerArgument";
                }
                case NODE_PROFILE: {
                    return "NodeProfileArgument";
                }
                case TAG_NODE: {
                    return "TagNodeArgument";
                }
            }
            throw new AssertionError((Object)"invalid kind");
        }

        private List<Element> getArgumentFields(InstructionModel.ImmediateKind kind) {
            return switch (kind) {
                case InstructionModel.ImmediateKind.LOCAL_ROOT, InstructionModel.ImmediateKind.SHORT, InstructionModel.ImmediateKind.STACK_POINTER -> List.of(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "width"));
                default -> List.of();
            };
        }

        private static List<String> getImmediateArgumentArgs(InstructionModel.ImmediateKind kind) {
            return switch (kind) {
                case InstructionModel.ImmediateKind.LOCAL_ROOT, InstructionModel.ImmediateKind.SHORT, InstructionModel.ImmediateKind.STACK_POINTER -> List.of(Integer.toString(kind.width.byteSize));
                default -> List.of();
            };
        }

        final class AbstractArgumentElement
        extends CodeTypeElement {
            AbstractArgumentElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.SEALED, Modifier.STATIC, Modifier.ABSTRACT), ElementKind.CLASS, null, "AbstractArgument");
                this.setSuperClass(BytecodeRootNodeElement.this.types.Instruction_Argument);
                this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
                this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(String.class), "name"));
                this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
                CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
                CodeTree tree = constructor.getBodyTree();
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
                b.tree(tree);
                this.add(new CodeVariableElement(Set.of(Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.types.BytecodeDSLAccess, "SAFE_ACCESS")).createInitBuilder().tree(BytecodeRootNodeElement.this.createFastAccessFieldInitializer(false));
                this.add(new CodeVariableElement(Set.of(Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.types.ByteArraySupport, "SAFE_BYTES")).createInitBuilder().startCall("SAFE_ACCESS.getByteArraySupport").end();
                this.add(this.createGetName());
            }

            private CodeExecutableElement createGetName() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "getName");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.statement("return name");
                return ex;
            }
        }

        final class ArgumentElement
        extends CodeTypeElement {
            private InstructionModel.ImmediateKind immediateKind;

            ArgumentElement(InstructionModel.ImmediateKind immediateKind) {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, InstructionImplElement.getImmediateClassName(immediateKind));
                this.immediateKind = immediateKind;
                this.setSuperClass(InstructionImplElement.this.abstractArgument.asType());
                this.addAll(InstructionImplElement.this.getArgumentFields(immediateKind));
                this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this));
                this.add(this.createGetKind());
                switch (immediateKind) {
                    case BYTECODE_INDEX: {
                        this.add(this.createAsBytecodeIndex());
                        break;
                    }
                    case LOCAL_ROOT: 
                    case SHORT: 
                    case STACK_POINTER: {
                        this.add(this.createAsInteger());
                        break;
                    }
                    case FRAME_INDEX: {
                        this.add(this.createAsLocalOffset());
                        break;
                    }
                    case LOCAL_INDEX: {
                        this.add(this.createAsLocalIndex());
                        break;
                    }
                    case CONSTANT: {
                        this.add(this.createAsConstant());
                        break;
                    }
                    case NODE_PROFILE: {
                        this.add(this.createAsCachedNode());
                        break;
                    }
                    case BRANCH_PROFILE: {
                        this.add(this.createAsBranchProfile());
                        break;
                    }
                    case TAG_NODE: {
                        this.add(this.createAsTagNode());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected kind");
                    }
                }
            }

            private static String readByteSafe(String array, String index) {
                return String.format("SAFE_BYTES.getByte(%s, %s)", array, index);
            }

            private static String readShortSafe(String array, String index) {
                return String.format("SAFE_BYTES.getShort(%s, %s)", array, index);
            }

            private static String readIntSafe(String array, String index) {
                return String.format("SAFE_BYTES.getInt(%s, %s)", array, index);
            }

            private static String readConstSafe(String index) {
                return String.format("SAFE_ACCESS.readObject(constants, %s)", index);
            }

            private CodeExecutableElement createAsBytecodeIndex() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asBytecodeIndex");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.startReturn();
                b.string(ArgumentElement.readIntSafe("bc", "bci"));
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsInteger() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asInteger");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.startSwitch().string("width").end().startBlock();
                b.startCase().string("1").end();
                b.startCaseBlock().startReturn().string(ArgumentElement.readByteSafe("bc", "bci")).end(2);
                b.startCase().string("2").end();
                b.startCaseBlock().startReturn().string(ArgumentElement.readShortSafe("bc", "bci")).end(2);
                b.startCase().string("4").end();
                b.startCaseBlock().startReturn().string(ArgumentElement.readIntSafe("bc", "bci")).end(2);
                b.caseDefault().startCaseBlock();
                BytecodeRootNodeElement.emitThrowAssertionError(b, "\"Unexpected integer width \" + width");
                b.end();
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsLocalOffset() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asLocalOffset");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.startReturn();
                if (InstructionModel.ImmediateKind.FRAME_INDEX.width != InstructionModel.ImmediateWidth.SHORT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.string(ArgumentElement.readShortSafe("bc", "bci")).string(" - USER_LOCALS_START_INDEX");
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsLocalIndex() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asLocalIndex");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.startReturn();
                if (InstructionModel.ImmediateKind.LOCAL_INDEX.width != InstructionModel.ImmediateWidth.SHORT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.string(ArgumentElement.readShortSafe("bc", "bci"));
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsConstant() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asConstant");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.declaration(BytecodeRootNodeElement.this.type(Object[].class), "constants", "this.bytecode.constants");
                b.startReturn();
                if (InstructionModel.ImmediateKind.CONSTANT.width != InstructionModel.ImmediateWidth.INT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.string(ArgumentElement.readConstSafe(ArgumentElement.readIntSafe("bc", "bci")));
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsCachedNode() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asCachedNode");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "cachedNodes", "this.bytecode.getCachedNodes()");
                b.startIf().string("cachedNodes == null").end().startBlock();
                b.statement("return null");
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.startReturn();
                if (InstructionModel.ImmediateKind.NODE_PROFILE.width != InstructionModel.ImmediateWidth.INT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.string("cachedNodes[", ArgumentElement.readIntSafe("bc", "bci"), "]");
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsTagNode() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asTagNode");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                b.declaration(BytecodeRootNodeElement.this.tagRootNode.asType(), "tagRoot", "this.bytecode.tagRoot");
                b.startIf().string("tagRoot == null").end().startBlock();
                b.statement("return null");
                b.end();
                b.startReturn();
                if (InstructionModel.ImmediateKind.TAG_NODE.width != InstructionModel.ImmediateWidth.INT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.tree(BytecodeRootNodeElement.readTagNodeSafe(CodeTreeBuilder.singleString(ArgumentElement.readIntSafe("bc", "bci"))));
                b.end();
                return ex;
            }

            private CodeExecutableElement createAsBranchProfile() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "asBranchProfile");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecode.bytecodes");
                if (InstructionModel.ImmediateKind.BRANCH_PROFILE.width != InstructionModel.ImmediateWidth.INT) {
                    throw new AssertionError((Object)"encoding changed");
                }
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", ArgumentElement.readIntSafe("bc", "bci"));
                b.declaration(BytecodeRootNodeElement.this.type(int[].class), "profiles", "this.bytecode.getBranchProfiles()");
                b.startIf().string("profiles == null").end().startBlock();
                b.startReturn();
                b.startNew(BytecodeRootNodeElement.this.types.Instruction_Argument_BranchProfile);
                b.string("index");
                b.string("0");
                b.string("0");
                b.end();
                b.end();
                b.end();
                b.startReturn();
                b.startNew(BytecodeRootNodeElement.this.types.Instruction_Argument_BranchProfile);
                b.string("index");
                b.string("profiles[index * 2]");
                b.string("profiles[index * 2 + 1]");
                b.end();
                b.end();
                return ex;
            }

            private CodeExecutableElement createGetKind() {
                CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Instruction_Argument, "getKind");
                ex.getModifiers().add(Modifier.FINAL);
                CodeTreeBuilder b = ex.createBuilder();
                b.startReturn();
                String name = switch (this.immediateKind) {
                    default -> throw new IncompatibleClassChangeError();
                    case InstructionModel.ImmediateKind.BRANCH_PROFILE -> "BRANCH_PROFILE";
                    case InstructionModel.ImmediateKind.BYTECODE_INDEX -> "BYTECODE_INDEX";
                    case InstructionModel.ImmediateKind.CONSTANT -> "CONSTANT";
                    case InstructionModel.ImmediateKind.FRAME_INDEX -> "LOCAL_OFFSET";
                    case InstructionModel.ImmediateKind.LOCAL_INDEX -> "LOCAL_INDEX";
                    case InstructionModel.ImmediateKind.LOCAL_ROOT, InstructionModel.ImmediateKind.SHORT, InstructionModel.ImmediateKind.STACK_POINTER -> "INTEGER";
                    case InstructionModel.ImmediateKind.NODE_PROFILE -> "NODE_PROFILE";
                    case InstructionModel.ImmediateKind.TAG_NODE -> "TAG_NODE";
                };
                b.staticReference(BytecodeRootNodeElement.this.types.Instruction_Argument_Kind, name);
                b.end();
                return ex;
            }
        }
    }

    final class TagNodeElement
    extends CodeTypeElement {
        TagNodeElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "TagNode");
            this.setSuperClass(BytecodeRootNodeElement.this.types.TagTreeNode);
            this.getImplements().add(BytecodeRootNodeElement.this.types.InstrumentableNode);
            this.getImplements().add(BytecodeRootNodeElement.this.types.TagTree);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL, Modifier.STATIC), ElementHelpers.arrayOf(this.asType()), "EMPTY_ARRAY")).createInitBuilder().string("new TagNode[0]");
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "tags"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "enterBci"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.statement("this.tags = tags");
            b.statement("this.enterBci = enterBci");
            BytecodeRootNodeElement.this.compFinal(this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.type(Integer.TYPE), "returnBci")));
            BytecodeRootNodeElement.this.child(this.add(new CodeVariableElement(Set.of(), ElementHelpers.arrayOf(this.asType()), "children")));
            BytecodeRootNodeElement.this.child(this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.VOLATILE), BytecodeRootNodeElement.this.types.ProbeNode, "probe")));
            BytecodeRootNodeElement.this.compFinal(this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.VOLATILE), BytecodeRootNodeElement.this.types.SourceSection, "sourceSection")));
        }

        void lazyInit() {
            this.add(this.createCreateWrapper());
            this.add(this.createFindProbe());
            this.add(this.createIsInstrumentable());
            this.add(this.createHasTag());
            this.add(this.createCopy());
            this.add(this.createGetSourceSection());
            this.add(this.createGetSourceSections());
            this.add(this.createCreateSourceSection());
            this.add(this.createFindBytecodeNode());
            this.addOptional(this.createDispatch());
            this.add(this.createGetLanguage());
            this.add(this.createGetTreeChildren());
            this.add(this.createGetTags());
            this.add(this.createGetEnterBytecodeIndex());
            this.add(this.createGetReturnBytecodeIndex());
        }

        private CodeExecutableElement createGetTreeChildren() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTree, "getTreeChildren");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startStaticCall(BytecodeRootNodeElement.this.type(List.class), "of").string("this.children").end().end();
            return ex;
        }

        private CodeExecutableElement createGetTags() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTree, "getTags");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startStaticCall(BytecodeRootNodeElement.this.type(List.class), "of").string("mapTagMaskToTagsArray(this.tags)").end().end();
            return ex;
        }

        private CodeExecutableElement createGetEnterBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTree, "getEnterBytecodeIndex");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return this.enterBci");
            return ex;
        }

        private CodeExecutableElement createGetReturnBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTree, "getReturnBytecodeIndex");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return this.returnBci");
            return ex;
        }

        private CodeExecutableElement createCreateWrapper() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.InstrumentableNode, "createWrapper", new String[]{"p"});
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return null");
            return ex;
        }

        private CodeExecutableElement createFindProbe() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.InstrumentableNode, "findProbe");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.ProbeNode, "p", "this.probe");
            b.startIf().string("p == null").end().startBlock();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.statement("this.probe = p = insert(createProbe(getSourceSection()))");
            b.end();
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.CompilerAsserts, "partialEvaluationConstant").string("p").end().end();
            b.statement("return p");
            return ex;
        }

        private CodeExecutableElement createFindBytecodeNode() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "findBytecodeNode", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.Node, "current", "this");
            b.startWhile().string("!(").instanceOf("current", BytecodeRootNodeElement.this.abstractBytecodeNode.asType()).string(" bytecodeNode)").end().startBlock();
            b.statement("current = current.getParent()");
            b.end();
            b.startIf().string("bytecodeNode == null").end().startBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected disconnected node."));
            b.end();
            b.statement("return bytecodeNode");
            return BytecodeRootNodeElement.this.withTruffleBoundary(ex);
        }

        private CodeExecutableElement createGetLanguage() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTreeNode, "getLanguage");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            ex.setReturnType(ElementHelpers.generic(BytecodeRootNodeElement.this.type(Class.class), (TypeMirror)BytecodeRootNodeElement.this.model.languageClass));
            ex.getAnnotationMirrors().clear();
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().typeLiteral(BytecodeRootNodeElement.this.model.languageClass).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createDispatch() {
            if (ElementUtils.typeEquals(BytecodeRootNodeElement.this.model.tagTreeNodeLibrary.getTemplateType().asType(), BytecodeRootNodeElement.this.types.TagTreeNodeExports)) {
                return null;
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTreeNode, "dispatch");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            ex.getAnnotationMirrors().clear();
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().typeLiteral(BytecodeRootNodeElement.this.model.tagTreeNodeLibrary.getTemplateType().asType()).end();
            return ex;
        }

        private CodeExecutableElement createGetSourceSection() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Node, "getSourceSection");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.SourceSection, "section", "this.sourceSection");
            b.startIf().string("section == null").end().startBlock();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.statement("this.sourceSection = section = createSourceSection()");
            b.end();
            b.statement("return section");
            return ex;
        }

        private CodeExecutableElement createGetSourceSections() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.TagTree, "getSourceSections");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("findBytecodeNode().getSourceLocations(enterBci)").end();
            return ex;
        }

        private CodeExecutableElement createCreateSourceSection() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.types.SourceSection, "createSourceSection", new CodeVariableElement[0]);
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("enterBci == -1").end().startBlock();
            b.lineComment("only happens for synthetic instrumentable root nodes.");
            b.statement("return null");
            b.end();
            b.startReturn().string("findBytecodeNode().getSourceLocation(enterBci)").end();
            return ex;
        }

        private CodeExecutableElement createIsInstrumentable() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.InstrumentableNode, "isInstrumentable");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            ex.createBuilder().returnTrue();
            return ex;
        }

        private CodeExecutableElement createCopy() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Node, "copy");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startDeclaration(this.asType(), "copy").cast(this.asType()).string("super.copy()").end();
            b.statement("copy.probe = null");
            b.statement("return copy");
            return ex;
        }

        private CodeExecutableElement createHasTag() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.InstrumentableNode, "hasTag", new String[]{"tag"});
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            boolean elseIf = false;
            int index = 0;
            for (TypeMirror tag : BytecodeRootNodeElement.this.model.getProvidedTags()) {
                elseIf = b.startIf(elseIf);
                b.string("tag == ").typeLiteral(tag).end().startBlock();
                int mask = 1 << index;
                b.startReturn().string("(tags & 0x", Integer.toHexString(mask), ") != 0").end();
                b.end();
                ++index;
            }
            b.returnFalse();
            return ex;
        }
    }

    final class TagRootNodeElement
    extends CodeTypeElement {
        TagRootNodeElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "TagRootNode");
            this.setSuperClass(BytecodeRootNodeElement.this.types.Node);
            BytecodeRootNodeElement.this.child(this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.tagNode.asType(), "root")));
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "tagNodes")));
            this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this));
            BytecodeRootNodeElement.this.child(this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.types.ProbeNode, "probe")));
            CodeExecutableElement getProbe = this.add(new CodeExecutableElement(Set.of(), BytecodeRootNodeElement.this.types.ProbeNode, "getProbe", new CodeVariableElement[0]));
            CodeTreeBuilder b = getProbe.createBuilder();
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.ProbeNode, "localProbe", "this.probe");
            b.startIf().string("localProbe == null").end().startBlock();
            b.statement("this.probe = localProbe = insert(root.createProbe(null))");
            b.end();
            b.statement("return localProbe");
            this.add(this.createCopy());
        }

        private CodeExecutableElement createCopy() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Node, "copy");
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.startDeclaration(this.asType(), "copy").cast(this.asType()).string("super.copy()").end();
            b.statement("copy.probe = null");
            b.statement("return copy");
            return ex;
        }
    }

    final class AbstractBytecodeNodeElement
    extends CodeTypeElement {
        private final CodeExecutableElement continueAt;
        private final CodeExecutableElement getCachedLocalTagInternal;
        private final CodeExecutableElement setCachedLocalTagInternal;
        private final CodeExecutableElement checkStableTagsAssumption;

        AbstractBytecodeNodeElement() {
            Iterator<ExecutableElement> iterator;
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.ABSTRACT, Modifier.SEALED), ElementKind.CLASS, null, "AbstractBytecodeNode");
            this.setSuperClass(BytecodeRootNodeElement.this.types.BytecodeNode);
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bytecodes")));
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Object.class)), "constants")));
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "handlers")));
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(int[].class), "locals")));
            this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(int[].class), "sourceInfo")));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.generic(BytecodeRootNodeElement.this.type(List.class), (TypeMirror)BytecodeRootNodeElement.this.types.Source), "sources"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "numNodes"));
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                BytecodeRootNodeElement.this.child(this.add(new CodeVariableElement(Set.of(), BytecodeRootNodeElement.this.tagRootNode.asType(), "tagRoot")));
            }
            if ((iterator = ElementFilter.constructorsIn(ElementUtils.castTypeElement(BytecodeRootNodeElement.this.types.BytecodeNode).getEnclosedElements()).iterator()).hasNext()) {
                ExecutableElement superConstructor = iterator.next();
                CodeExecutableElement constructor = CodeExecutableElement.cloneNoAnnotations(superConstructor);
                constructor.setReturnType(null);
                constructor.setSimpleName(this.getSimpleName());
                constructor.getParameters().remove(0);
                for (VariableElement variableElement : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                    constructor.addParameter(new CodeVariableElement(variableElement.asType(), variableElement.getSimpleName().toString()));
                }
                CodeTreeBuilder b = constructor.createBuilder();
                b.startStatement().startSuperCall().string("BytecodeRootNodesImpl.VISIBLE_TOKEN").end().end();
                for (VariableElement var : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                    b.startStatement();
                    b.string("this.", var.getSimpleName().toString(), " = ", var.getSimpleName().toString());
                    b.end();
                }
                this.add(constructor);
            }
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                this.add(this.createFindInstrumentableCallNode());
            }
            this.add(this.createFindBytecodeIndex2());
            this.add(this.createReadValidBytecode());
            this.continueAt = this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), BytecodeRootNodeElement.this.type(Long.TYPE), "continueAt", new CodeVariableElement[0]));
            this.continueAt.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"));
            this.continueAt.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                this.continueAt.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            this.continueAt.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Long.TYPE), "startState"));
            CodeExecutableElement getRoot = this.add(new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.asType(), "getRoot", new CodeVariableElement[0]));
            CodeTreeBuilder b = getRoot.createBuilder();
            b.startReturn().cast(BytecodeRootNodeElement.this.asType()).string("getParent()").end();
            CodeExecutableElement findLocation = this.add(new CodeExecutableElement(Set.of(Modifier.STATIC), BytecodeRootNodeElement.this.types.BytecodeLocation, "findLocation", new CodeVariableElement[0]));
            findLocation.addParameter(new CodeVariableElement(this.asType(), "node"));
            findLocation.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            b = findLocation.createBuilder();
            b.startReturn().startCall("node.findLocation").string("bci").end().end();
            CodeExecutableElement toCached = this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), this.asType(), "toCached", new CodeVariableElement[0]));
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                toCached.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "numLocals"));
            }
            CodeExecutableElement codeExecutableElement = this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), this.asType(), "update", new CodeVariableElement[0]));
            for (VariableElement e : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                codeExecutableElement.addParameter(new CodeVariableElement(e.asType(), e.getSimpleName().toString() + "_"));
            }
            if (BytecodeRootNodeElement.this.model.isBytecodeUpdatable()) {
                this.add(this.createInvalidate());
                if (BytecodeRootNodeElement.this.model.enableYield) {
                    this.add(this.createUpdateContinuationRootNodes());
                }
            }
            this.add(this.createValidateBytecodes());
            this.add(this.createDumpInvalid());
            this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), this.asType(), "cloneUninitialized", new CodeVariableElement[0]));
            this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "getCachedNodes", new CodeVariableElement[0]));
            this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "getBranchProfiles", new CodeVariableElement[0]));
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                this.add(new CodeExecutableElement(Set.of(Modifier.ABSTRACT), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "getLocalTags", new CodeVariableElement[0]));
                this.getCachedLocalTagInternal = this.add(this.createGetCachedLocalTagInternal());
                this.setCachedLocalTagInternal = this.add(this.createSetCachedLocalTagInternal());
                this.checkStableTagsAssumption = BytecodeRootNodeElement.this.model.enableYield ? this.add(this.createCheckStableTagsAssumption()) : null;
            } else {
                this.getCachedLocalTagInternal = null;
                this.setCachedLocalTagInternal = null;
                this.checkStableTagsAssumption = null;
            }
            this.add(this.createGetSourceSection());
            this.add(this.createGetSourceLocation());
            this.add(this.createGetSourceLocations());
            this.add(this.createCreateSourceSection());
            this.add(this.createFindInstruction());
            this.add(this.createValidateBytecodeIndex());
            this.add(this.createGetSourceInformation());
            this.add(this.createHasSourceInformation());
            this.add(this.createGetSourceInformationTree());
            this.add(this.createGetExceptionHandlers());
            this.add(this.createGetTagTree());
            this.add(this.createGetLocalCount());
            this.add(this.createClearLocalValueInternal());
            this.add(this.createIsLocalClearedInternal());
            this.add(this.createGetLocalNameInternal());
            this.add(this.createGetLocalInfoInternal());
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                this.add(this.createGetLocalValue());
                this.add(this.createSetLocalValue());
                this.add(this.createGetLocalValueInternal());
                this.add(this.createSetLocalValueInternal());
            } else {
                this.add(this.createAbstractSetLocalValueInternal());
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                this.add(this.createLocalOffsetToTableIndex());
                this.add(this.createLocalOffsetToLocalIndex());
                this.add(this.createLocalIndexToAnyTableIndex());
            }
            if (BytecodeRootNodeElement.this.model.canValidateMaterializedLocalLiveness()) {
                this.add(this.createValidateMaterializedLocalLivenessInternal());
                this.add(this.createLocalIndexToTableIndex());
            }
            this.add(this.createGetLocalName());
            this.add(this.createGetLocalInfo());
            this.add(this.createGetLocals());
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                this.add(this.createGetTagNodes());
            }
            this.add(this.createTranslateBytecodeIndex());
            if (BytecodeRootNodeElement.this.model.isBytecodeUpdatable()) {
                this.add(this.createTransitionState());
                this.add(this.createToStableBytecodeIndex());
                this.add(this.createFromStableBytecodeIndex());
                this.add(this.createTransitionInstrumentationIndex());
                this.add(this.createComputeNewBci());
            }
            this.add(this.createAdoptNodesAfterUpdate());
        }

        private CodeExecutableElement createGetLocalCount() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalCount", new String[]{"bci"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            ex.getAnnotationMirrors().add(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.ExplodeLoop));
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.CompilerAsserts, "partialEvaluationConstant").string("bci").end().end();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "count", "0");
                b.startFor().string("int index = 0; index < locals.length; index += LOCALS_LENGTH").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startIndex", "locals[index + LOCALS_OFFSET_START_BCI]");
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endIndex", "locals[index + LOCALS_OFFSET_END_BCI]");
                b.startIf().string("bci >= startIndex && bci < endIndex").end().startBlock();
                b.statement("count++");
                b.end();
                b.end();
                b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.CompilerAsserts, "partialEvaluationConstant").string("count").end().end();
                b.statement("return count");
            } else {
                b.statement("return locals.length / LOCALS_LENGTH");
            }
            return ex;
        }

        private CodeExecutableElement createClearLocalValueInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "clearLocalValueInternal", new String[]{"frame", "localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            b.statement("frame.clear(frameIndex)");
            return ex;
        }

        private CodeExecutableElement createIsLocalClearedInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "isLocalClearedInternal", new String[]{"frame", "localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            b.startReturn();
            b.string("frame.getTag(frameIndex) == FrameSlotKind.Illegal.tag");
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocalValue() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalValue", new String[]{"bci", "frame", "localOffset"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, false);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            b.startIf().string("frame.isObject(frameIndex)").end().startBlock();
            b.startReturn().string("frame.getObject(frameIndex)").end();
            b.end();
            b.statement("return null");
            return ex;
        }

        private CodeExecutableElement createGetLocalValueInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalValueInternal", new String[]{"frame", "localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            b.startReturn().string("frame.getObject(frameIndex)").end();
            return ex;
        }

        private CodeExecutableElement createSetLocalValue() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setLocalValue", new String[]{"bci", "frame", "localOffset", "value"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, false);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            b.startStatement();
            b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("frameIndex").string("value").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createSetLocalValueInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setLocalValueInternal", new String[]{"frame", "localOffset", "localIndex", "value"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            b.startStatement();
            b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("USER_LOCALS_START_INDEX + localOffset").string("value").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createAbstractSetLocalValueInternal() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError();
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setLocalValueInternal", new String[]{"frame", "localOffset", "localIndex", "value"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            ex.getModifiers().add(Modifier.ABSTRACT);
            return ex;
        }

        private CodeExecutableElement createLocalOffsetToTableIndex() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PROTECTED, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffsetToTableIndex", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffset"));
            ex.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.ExplodeLoop));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "count", "0");
            b.startFor().string("int index = 0; index < locals.length; index += LOCALS_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startIndex", "locals[index + LOCALS_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endIndex", "locals[index + LOCALS_OFFSET_END_BCI]");
            b.startIf().string("bci >= startIndex && bci < endIndex").end().startBlock();
            b.startIf().string("count == localOffset").end().startBlock();
            b.startReturn().string("index").end();
            b.end();
            b.statement("count++");
            b.end();
            b.end();
            b.statement("return -1");
            return ex;
        }

        private CodeExecutableElement createLocalOffsetToLocalIndex() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PROTECTED, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffsetToLocalIndex", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffset"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "tableIndex", "localOffsetToTableIndex(bci, localOffset)");
            b.startAssert().string("locals[tableIndex + LOCALS_OFFSET_FRAME_INDEX] == localOffset + USER_LOCALS_START_INDEX : ").doubleQuote("Inconsistent indices.").end();
            b.startReturn().string("locals[tableIndex + LOCALS_OFFSET_LOCAL_INDEX]").end();
            return ex;
        }

        private CodeExecutableElement createLocalIndexToTableIndex() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PROTECTED, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndexToTableIndex", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            ex.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.ExplodeLoop));
            CodeTreeBuilder b = ex.createBuilder();
            b.startFor().string("int index = 0; index < locals.length; index += LOCALS_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startIndex", "locals[index + LOCALS_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endIndex", "locals[index + LOCALS_OFFSET_END_BCI]");
            b.startIf().string("bci >= startIndex && bci < endIndex").end().startBlock();
            b.startIf().string("locals[index + LOCALS_OFFSET_LOCAL_INDEX] == localIndex").end().startBlock();
            b.startReturn().string("index").end();
            b.end();
            b.end();
            b.end();
            b.statement("return -1");
            return ex;
        }

        private CodeExecutableElement createLocalIndexToAnyTableIndex() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PROTECTED, Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndexToAnyTableIndex", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            ex.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.ExplodeLoop));
            CodeTreeBuilder b = ex.createBuilder();
            b.startFor().string("int index = 0; index < locals.length; index += LOCALS_LENGTH").end().startBlock();
            b.startIf().string("locals[index + LOCALS_OFFSET_LOCAL_INDEX] == localIndex").end().startBlock();
            b.startReturn().string("index").end();
            b.end();
            b.end();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(AssertionError.class));
            b.doubleQuote("Local index not found in locals table");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createValidateMaterializedLocalLivenessInternal() {
            if (!BytecodeRootNodeElement.this.model.canValidateMaterializedLocalLiveness()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "validateLocalLivenessInternal", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "stackFrame"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "stackFrameBci"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci");
            b.startIf().string("frame == stackFrame").end().startBlock();
            b.lineComment("Loading a value from the current frame. Use the precise bci (the frame is only updated when control escapes).");
            b.statement("bci = stackFrameBci");
            b.end();
            b.end().startElseBlock();
            b.startAssign("bci");
            BytecodeRootNodeElement.startGetFrame(b, "frame", BytecodeRootNodeElement.this.type(Integer.TYPE), false).string(BytecodeRootNodeElement.BCI_INDEX).end();
            b.end();
            b.end();
            b.lineComment("Ensure the local we're trying to access is live at the current bci.");
            b.startIf().string("locals[localIndexToTableIndex(bci, localIndex) + LOCALS_OFFSET_FRAME_INDEX] != frameIndex").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Local is out of scope in the frame passed for a materialized local access.");
            b.end();
            b.returnTrue();
            return ex;
        }

        private CodeExecutableElement createGetCachedLocalTagInternal() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.ABSTRACT), BytecodeRootNodeElement.this.type(Byte.TYPE), "getCachedLocalTagInternal", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            return ex;
        }

        private CodeExecutableElement createSetCachedLocalTagInternal() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.ABSTRACT), BytecodeRootNodeElement.this.type(Void.TYPE), "setCachedLocalTagInternal", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag"));
            return ex;
        }

        private CodeExecutableElement createCheckStableTagsAssumption() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.ABSTRACT), BytecodeRootNodeElement.this.type(Boolean.TYPE), "checkStableTagsAssumption", new CodeVariableElement[0]);
            return ex;
        }

        static void buildVerifyLocalsIndex(CodeTreeBuilder b) {
            b.startStatement().startStaticCall(ProcessorContext.types().CompilerAsserts, "partialEvaluationConstant").string("bci").end().end();
            b.startStatement().startStaticCall(ProcessorContext.types().CompilerAsserts, "partialEvaluationConstant").string("localOffset").end().end();
            b.startAssert().string("localOffset >= 0 && localOffset < getLocalCount(bci) : ").doubleQuote("Invalid out-of-bounds local offset provided.").end();
        }

        static void buildVerifyFrameDescriptor(CodeTreeBuilder b, boolean trustFrame) {
            String errorMessage = "Invalid frame with invalid descriptor passed.";
            if (trustFrame) {
                b.startAssert();
                b.string("getRoot().getFrameDescriptor() == frame.getFrameDescriptor() : \"", errorMessage, "\"");
                b.end();
            } else {
                b.startIf().string("getRoot().getFrameDescriptor() != frame.getFrameDescriptor()").end().startBlock();
                BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, errorMessage);
                b.end();
            }
        }

        private CodeExecutableElement createGetLocalName() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalName", new String[]{"bci", "localOffset"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", "localOffsetToTableIndex(bci, localOffset)");
                b.startIf().string("index == -1").end().startBlock();
                b.returnNull();
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId", "locals[index + LOCALS_OFFSET_NAME]");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId", "locals[(localOffset * LOCALS_LENGTH) + LOCALS_OFFSET_NAME]");
            }
            b.startIf().string("nameId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("nameId", "this.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocalNameInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalNameInternal", new String[]{"localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", "localIndexToAnyTableIndex(localIndex)");
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId", "locals[index + LOCALS_OFFSET_NAME]");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId", "locals[(localOffset * LOCALS_LENGTH) + LOCALS_OFFSET_NAME]");
            }
            b.startIf().string("nameId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("nameId", "this.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocalInfo() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalInfo", new String[]{"bci", "localOffset"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", "localOffsetToTableIndex(bci, localOffset)");
                b.startIf().string("index == -1").end().startBlock();
                b.returnNull();
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId", "locals[index + LOCALS_OFFSET_INFO]");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId", "locals[(localOffset * LOCALS_LENGTH) + LOCALS_OFFSET_INFO]");
            }
            b.startIf().string("infoId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("infoId", "this.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocalInfoInternal() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalInfoInternal", new String[]{"localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "index", "localIndexToAnyTableIndex(localIndex)");
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId", "locals[index + LOCALS_OFFSET_INFO]");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId", "locals[(localOffset * LOCALS_LENGTH) + LOCALS_OFFSET_INFO]");
            }
            b.startIf().string("infoId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("infoId", "this.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocals() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocals");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().startNew("LocalVariableList").string("this").end().end();
            return ex;
        }

        private CodeExecutableElement createValidateBytecodes() {
            CodeExecutableElement validate = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "validateBytecodes", new CodeVariableElement[0]);
            CodeTreeBuilder b = validate.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.asType(), "root");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc", "this.bytecodes");
            b.startIf().string("bc == null").end().startBlock();
            b.lineComment("bc is null for serialization root nodes.");
            b.statement("return true");
            b.end();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "cachedNodes", "getCachedNodes()");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "branchProfiles", "getBranchProfiles()");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci", "0");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "tagNodes", "tagRoot != null ? tagRoot.tagNodes : null");
            }
            b.startIf().string("bc.length == 0").end().startBlock();
            b.tree(this.createValidationError("bytecode array must not be null"));
            b.end();
            b.startWhile().string("bci < bc.length").end().startBlock();
            b.startTryBlock();
            b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end().startBlock();
            Map<InstructionValidationGroup, List<InstructionModel>> groups = BytecodeRootNodeElement.this.model.getInstructions().stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(i -> new InstructionValidationGroup(BytecodeRootNodeElement.this.model, (InstructionModel)i)));
            for (Map.Entry<InstructionValidationGroup, List<InstructionModel>> entry : groups.entrySet()) {
                InstructionValidationGroup group = entry.getKey();
                List<InstructionModel> instructions = entry.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startBlock();
                boolean rootNodeAvailable = false;
                block14: for (InstructionModel.InstructionImmediate immediate : group.immediates()) {
                    String localName = immediate.name();
                    CodeTree declareImmediate = CodeTreeBuilder.createBuilder().startDeclaration(immediate.kind().toType(BytecodeRootNodeElement.this.context), localName).tree(BytecodeRootNodeElement.readImmediate("bc", "bci", immediate)).end().build();
                    switch (immediate.kind()) {
                        case BYTECODE_INDEX: {
                            b.tree(declareImmediate);
                            b.startIf();
                            if (group.allowNegativeChildBci()) {
                                b.string(localName, " < -1");
                            } else {
                                b.string(localName, " < 0");
                            }
                            b.string(" || ").string(localName).string(" >= bc.length").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("bytecode index is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case SHORT: {
                            continue block14;
                        }
                        case STACK_POINTER: {
                            b.tree(declareImmediate);
                            b.startAssign("root").string("this.getRoot()").end();
                            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "maxStackHeight", "root.getFrameDescriptor().getNumberOfSlots() - root.maxLocals");
                            b.startIf().string(localName, " < 0 || ", localName, " > maxStackHeight").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("stack pointer is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case FRAME_INDEX: {
                            b.tree(declareImmediate);
                            if (!rootNodeAvailable) {
                                rootNodeAvailable = this.tryEmitRootNodeForLocalInstruction(b, group);
                            }
                            b.startIf().string(localName).string(" < USER_LOCALS_START_INDEX");
                            if (rootNodeAvailable) {
                                b.string(" || ").string(localName).string(" >= root.maxLocals");
                            }
                            b.end().startBlock();
                            b.tree(this.createValidationErrorWithBci("local offset is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case LOCAL_INDEX: {
                            b.tree(declareImmediate);
                            boolean hasNumLocals = BytecodeRootNodeElement.this.model.usesBoxingElimination();
                            if (!rootNodeAvailable && hasNumLocals) {
                                rootNodeAvailable = this.tryEmitRootNodeForLocalInstruction(b, group);
                            }
                            b.startIf().string(localName).string(" < 0");
                            if (rootNodeAvailable && hasNumLocals) {
                                b.string(" || ").string(localName).string(" >= root.numLocals");
                            }
                            b.end().startBlock();
                            b.tree(this.createValidationErrorWithBci("local index is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case LOCAL_ROOT: {
                            continue block14;
                        }
                        case CONSTANT: {
                            b.tree(declareImmediate);
                            b.startIf().string(localName).string(" < 0 || ").string(localName).string(" >= constants.length").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("constant is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case NODE_PROFILE: {
                            b.tree(declareImmediate);
                            b.startIf().string(localName).string(" < 0 || ").string(localName).string(" >= numNodes").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("node profile is out of bounds"));
                            b.end();
                            continue block14;
                        }
                        case BRANCH_PROFILE: {
                            b.tree(declareImmediate);
                            b.startIf().string("branchProfiles != null").end().startBlock();
                            b.startIf().string(localName).string(" < 0 || ").string(localName).string(" >= branchProfiles.length").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("branch profile is out of bounds"));
                            b.end();
                            b.end();
                            continue block14;
                        }
                        case TAG_NODE: {
                            b.tree(declareImmediate);
                            b.startIf().string("tagNodes != null").end().startBlock();
                            b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "node", BytecodeRootNodeElement.readTagNodeSafe(CodeTreeBuilder.singleString(immediate.name())));
                            b.startIf().string("node == null").end().startBlock();
                            b.tree(this.createValidationErrorWithBci("tagNode is null"));
                            b.end();
                            b.end();
                            continue block14;
                        }
                    }
                    throw new AssertionError((Object)"Unexpected kind");
                }
                b.statement("bci = bci + " + group.instructionLength());
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere(b.create().doubleQuote("Invalid BCI at index: ").string(" + bci").build()));
            b.end();
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.type(AssertionError.class), "e");
            b.statement("throw e");
            b.end();
            b.startCatchBlock(BytecodeRootNodeElement.this.type(Throwable.class), "e");
            b.tree(this.createValidationError(null, "e", false));
            b.end();
            b.end();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "ex", "this.handlers");
            b.startIf().string("ex.length % EXCEPTION_HANDLER_LENGTH != 0").end().startBlock();
            b.tree(this.createValidationError("exception handler table size is incorrect"));
            b.end();
            b.startFor().string("int i = 0; i < ex.length; i = i + EXCEPTION_HANDLER_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci", "ex[i + EXCEPTION_HANDLER_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci", "ex[i + EXCEPTION_HANDLER_OFFSET_END_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerKind", "ex[i + EXCEPTION_HANDLER_OFFSET_KIND]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerBci", "ex[i + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerSp", "ex[i + EXCEPTION_HANDLER_OFFSET_HANDLER_SP]");
            b.startIf().string("startBci").string(" < 0 || ").string("startBci").string(" >= bc.length").end().startBlock();
            b.tree(this.createValidationError("exception handler startBci is out of bounds"));
            b.end();
            b.startIf().string("endBci").string(" < 0 || ").string("endBci").string(" > bc.length").end().startBlock();
            b.tree(this.createValidationError("exception handler endBci is out of bounds"));
            b.end();
            b.startIf().string("startBci > endBci").end().startBlock();
            b.tree(this.createValidationError("exception handler bci range is malformed"));
            b.end();
            b.startSwitch().string("handlerKind").end().startBlock();
            if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                b.startCase().string("HANDLER_EPILOG_EXCEPTIONAL").end().startCaseBlock();
                b.startIf().string("handlerBci").string(" != -1").end().startBlock();
                b.tree(this.createValidationError("exception handler handlerBci is invalid"));
                b.end();
                b.startIf().string("handlerSp").string(" != -1").end().startBlock();
                b.tree(this.createValidationError("exception handler handlerBci is invalid"));
                b.end();
                b.statement("break");
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startCase().string("HANDLER_TAG_EXCEPTIONAL").end().startCaseBlock();
                b.startIf().string("tagNodes != null").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "node", BytecodeRootNodeElement.readTagNodeSafe(CodeTreeBuilder.singleString("handlerBci")));
                b.startIf().string("node == null").end().startBlock();
                b.tree(this.createValidationError("tagNode is null"));
                b.end();
                b.end();
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.startIf().string("handlerKind != HANDLER_CUSTOM").end().startBlock();
            b.tree(this.createValidationError("unexpected handler kind"));
            b.end();
            b.startIf().string("handlerBci").string(" < 0 || ").string("handlerBci").string(" >= bc.length").end().startBlock();
            b.tree(this.createValidationError("exception handler handlerBci is out of bounds"));
            b.end();
            b.statement("break");
            b.end();
            b.end();
            b.end();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "info", "this.sourceInfo");
            b.declaration((TypeMirror)ElementHelpers.generic((TypeMirror)BytecodeRootNodeElement.this.declaredType(List.class), (TypeMirror)BytecodeRootNodeElement.this.types.Source), "localSources", "this.sources");
            b.startIf().string("info != null").end().startBlock();
            b.startFor().string("int i = 0; i < info.length; i += SOURCE_INFO_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci", "info[i + SOURCE_INFO_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci", "info[i + SOURCE_INFO_OFFSET_END_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceIndex", "info[i + SOURCE_INFO_OFFSET_SOURCE]");
            b.startIf().string("startBci > endBci").end().startBlock();
            b.tree(this.createValidationError("source bci range is malformed"));
            b.end().startElseIf().string("sourceIndex < 0 || sourceIndex > localSources.size()").end().startBlock();
            b.tree(this.createValidationError("source index is out of bounds"));
            b.end();
            b.end();
            b.end();
            b.startReturn().string("true").end();
            return validate;
        }

        private boolean tryEmitRootNodeForLocalInstruction(CodeTreeBuilder b, InstructionValidationGroup group) {
            if (group.localVar()) {
                b.startAssign("root").string("this.getRoot()").end();
                return true;
            }
            if (group.localVarMat()) {
                InstructionModel.InstructionImmediate rootImmediate = group.immediates.stream().filter(imm -> imm.kind() == InstructionModel.ImmediateKind.LOCAL_ROOT).findFirst().get();
                b.startAssign("root").startCall("this.getRoot().getBytecodeRootNodeImpl").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", rootImmediate)).end(2);
                return true;
            }
            return false;
        }

        private static boolean acceptsInvalidChildBci(BytecodeDSLModel model, InstructionModel instr) {
            if (!model.usesBoxingElimination()) {
                return false;
            }
            if (instr.isShortCircuitConverter() || instr.isEpilogReturn()) {
                return true;
            }
            return AbstractBytecodeNodeElement.isSameOrGenericQuickening(instr, model.popInstruction) || AbstractBytecodeNodeElement.isSameOrGenericQuickening(instr, model.storeLocalInstruction) || model.usesBoxingElimination() && AbstractBytecodeNodeElement.isSameOrGenericQuickening(instr, model.conditionalOperation.instruction);
        }

        private static boolean isSameOrGenericQuickening(InstructionModel instr, InstructionModel expected) {
            return instr == expected || instr.getQuickeningRoot() == expected && instr.specializedType == null;
        }

        private CodeExecutableElement createDumpInvalid() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(String.class), "dumpInvalid", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.BytecodeLocation, "highlightedLocation"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startTryBlock();
            b.startReturn();
            b.string("dump(highlightedLocation)");
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.context.getDeclaredType(Throwable.class), "t");
            b.startReturn();
            b.doubleQuote("<dump error>");
            b.end();
            b.end();
            return ex;
        }

        private CodeTree createValidationError(String message) {
            return this.createValidationError(message, null, false);
        }

        private CodeTree createValidationErrorWithBci(String message) {
            return this.createValidationError(message, null, true);
        }

        private CodeTree createValidationError(String message, String cause, boolean includeBci) {
            CodeTreeBuilder b = new CodeTreeBuilder(null);
            b.startThrow().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "shouldNotReachHere");
            b.startGroup();
            b.startStaticCall(BytecodeRootNodeElement.this.type(String.class), "format");
            b.startGroup().string("\"Bytecode validation error");
            if (includeBci) {
                b.string(" at index: %s.");
            } else {
                b.string(":");
            }
            if (message != null) {
                b.string(" " + message);
            }
            b.string("%n%s\"").end();
            if (includeBci) {
                b.string("bci");
            }
            b.string("dumpInvalid(findLocation(bci))");
            b.end();
            b.end();
            if (cause != null) {
                b.string(cause);
            }
            b.end().end();
            return b.build();
        }

        private CodeExecutableElement createFindInstrumentableCallNode() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.types.Node, "findInstrumentableCallNode", new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(int[].class), "localHandlers", "handlers");
            b.startFor().string("int i = 0; i < localHandlers.length; i += EXCEPTION_HANDLER_LENGTH").end().startBlock();
            b.startIf().string("localHandlers[i + EXCEPTION_HANDLER_OFFSET_START_BCI] > bci").end().startBlock().statement("continue").end();
            b.startIf().string("localHandlers[i + EXCEPTION_HANDLER_OFFSET_END_BCI] <= bci").end().startBlock().statement("continue").end();
            b.statement("int handlerKind = localHandlers[i + EXCEPTION_HANDLER_OFFSET_KIND]");
            b.startIf().string("handlerKind != HANDLER_TAG_EXCEPTIONAL").end().startBlock();
            b.statement("continue");
            b.end();
            b.statement("int nodeId = localHandlers[i + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
            b.statement("return tagRoot.tagNodes[nodeId]");
            b.end();
            b.statement("return null");
            return ex;
        }

        private CodeExecutableElement createFindBytecodeIndex2() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "findBytecodeIndex", new String[]{"frame", "operationNode"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.types.Node});
            ex.getModifiers().add(Modifier.ABSTRACT);
            return ex;
        }

        private CodeExecutableElement createReadValidBytecode() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "readValidBytecode", new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            CodeTreeBuilder b = method.createBuilder();
            if (BytecodeRootNodeElement.this.model.isBytecodeUpdatable()) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "op", BytecodeRootNodeElement.readInstruction("bc", "bci"));
                b.startSwitch().string("op").end().startBlock();
                for (InstructionModel instruction : BytecodeRootNodeElement.this.model.getInvalidateInstructions()) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                b.lineComment("While we were processing the exception handler the code invalidated.");
                b.lineComment("We need to re-read the op from the old bytecodes.");
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startReturn().tree(BytecodeRootNodeElement.readInstruction("oldBytecodes", "bci")).end();
                b.end();
                b.caseDefault().startCaseBlock();
                b.statement("return op");
                b.end();
                b.end();
            } else {
                b.lineComment("The bytecode is not updatable so the bytecode is always valid.");
                b.startReturn().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end();
            }
            return method;
        }

        private CodeExecutableElement createGetTagNodes() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "getTagNodes", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("tagRoot != null ? tagRoot.tagNodes : null").end();
            return ex;
        }

        private CodeExecutableElement createTranslateBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "translateBytecodeIndex", new String[]{"newNode", "bytecodeIndex"});
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.isBytecodeUpdatable()) {
                CodeTreeBuilder tb = CodeTreeBuilder.createBuilder();
                tb.startCall("transitionState");
                tb.startGroup();
                tb.cast(this.asType());
                tb.string("newNode");
                tb.end();
                tb.string(BytecodeRootNodeElement.this.encodeState("bytecodeIndex", null));
                if (BytecodeRootNodeElement.this.model.enableYield) {
                    tb.string("null");
                }
                tb.end();
                b.startReturn();
                b.string(BytecodeRootNodeElement.decodeBci(tb.build().toString()));
                b.end();
            } else {
                b.statement("return bytecodeIndex");
            }
            return ex;
        }

        private CodeExecutableElement createTransitionState() {
            CodeExecutableElement transitionState = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Long.TYPE), "transitionState", new CodeVariableElement[0]);
            transitionState.addParameter(new CodeVariableElement(this.asType(), "newBytecode"));
            transitionState.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Long.TYPE), "state"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                transitionState.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType(), "continuationRootNode"));
            }
            CodeTreeBuilder b = transitionState.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "oldBc", "this.oldBytecodes");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "newBc", "newBytecode.bytecodes");
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.startIf().string("continuationRootNode != null && oldBc == null").end().startBlock();
                b.lineComment("Transition continuationRootNode to cached.");
                b.startDeclaration(BytecodeRootNodeElement.this.types.BytecodeLocation, "newContinuationLocation");
                b.startCall("newBytecode.getBytecodeLocation");
                b.string("continuationRootNode.getLocation().getBytecodeIndex()");
                b.end(2);
                b.startStatement().startCall("continuationRootNode.updateBytecodeLocation");
                b.string("newContinuationLocation");
                b.string("this");
                b.string("newBytecode");
                b.doubleQuote("transition to cached");
                b.end(2);
                b.end();
            }
            b.startIf().string("oldBc == null || this == newBytecode || this.bytecodes == newBc").end().startBlock();
            b.lineComment("No change in bytecodes.");
            b.startReturn().string("state").end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBci", BytecodeRootNodeElement.decodeBci("state"));
            b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBci");
            b.startCall("computeNewBci").string("oldBci").string("oldBc").string("newBc");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.string("this.getTagNodes()");
                b.string("newBytecode.getTagNodes()");
            }
            b.end();
            b.end();
            if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("onBytecodeStackTransition")) {
                b.startStatement();
                b.startCall("getRoot().onBytecodeStackTransition");
                BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "oldBci", BytecodeRootNodeElement.readInstruction("oldBc", "oldBci"));
                BytecodeRootNodeElement.this.emitParseInstruction(b, "newBytecode", "newBci", BytecodeRootNodeElement.readInstruction("newBc", "newBci"));
                b.end().end();
            }
            b.startReturn().string(BytecodeRootNodeElement.encodeNewBci("newBci", "state")).end();
            return transitionState;
        }

        private CodeExecutableElement createTransitionInstrumentationIndex() {
            List<InstructionModel> instructions;
            record InstructionGroup(int instructionLength, boolean instrumentation, boolean tagInstrumentation, InstructionModel.InstructionImmediate tagNodeImmediate) implements Comparable<InstructionGroup>
            {
                InstructionGroup(InstructionModel instr) {
                    this(instr.getInstructionLength(), instr.isInstrumentation(), instr.isTagInstrumentation(), instr.isTagInstrumentation() ? instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE) : null);
                }

                @Override
                public int compareTo(InstructionGroup o) {
                    int compare = Boolean.compare(this.instrumentation, o.instrumentation);
                    if (compare != 0) {
                        return compare;
                    }
                    compare = Boolean.compare(this.tagInstrumentation, o.tagInstrumentation);
                    if (compare != 0) {
                        return compare;
                    }
                    if (this.tagInstrumentation && (compare = Integer.compare(this.tagNodeImmediate.offset(), o.tagNodeImmediate.offset())) != 0) {
                        return compare;
                    }
                    compare = Integer.compare(this.instructionLength, o.instructionLength);
                    if (compare != 0) {
                        return compare;
                    }
                    return 0;
                }
            }
            InstructionGroup group;
            CodeExecutableElement invalidate = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "transitionInstrumentationIndex", new CodeVariableElement[0]);
            invalidate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "oldBc"));
            invalidate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBciBase"));
            invalidate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBciTarget"));
            invalidate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "newBc"));
            invalidate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBciBase"));
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                invalidate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "oldTagNodes"));
                invalidate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "newTagNodes"));
            }
            CodeTreeBuilder b = invalidate.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBci", "oldBciBase");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBci", "newBciBase");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "searchOp", "-1");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "searchTags", "-1");
            }
            b.startWhile().string("oldBci < oldBciTarget").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "op", BytecodeRootNodeElement.readInstruction("oldBc", "oldBci"));
            b.statement("searchOp = op");
            b.startSwitch().string("op").end().startBlock();
            for (Map.Entry<InstructionGroup, List<InstructionModel>> groupEntry : this.groupInstructionsSortedBy(x$0 -> new InstructionGroup((InstructionModel)x$0))) {
                group = groupEntry.getKey();
                if (!group.instrumentation) continue;
                instructions = groupEntry.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    if (group.tagInstrumentation) {
                        b.startStatement();
                        b.string("searchTags = ");
                        b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), "oldTagNodes", BytecodeRootNodeElement.readImmediate("oldBc", "oldBci", group.tagNodeImmediate)));
                        b.string(".tags");
                        b.end();
                    } else {
                        b.statement("searchTags = -1");
                    }
                }
                b.statement("oldBci += " + group.instructionLength);
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected bytecode."));
            b.end();
            b.end();
            b.end();
            b.startAssert().string("searchOp != -1").end();
            b.startAssign("oldBci").string("oldBciBase").end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "opCounter", "0");
            b.startWhile().string("oldBci < oldBciTarget").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "op", BytecodeRootNodeElement.readInstruction("oldBc", "oldBci"));
            b.startSwitch().string("op").end().startBlock();
            for (Map.Entry<InstructionGroup, List<InstructionModel>> groupEntry : this.groupInstructionsSortedBy(x$0 -> new InstructionGroup((InstructionModel)x$0))) {
                group = groupEntry.getKey();
                if (!group.instrumentation) continue;
                instructions = groupEntry.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startBlock();
                if (group.tagInstrumentation) {
                    b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "opTags");
                    b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), "oldTagNodes", BytecodeRootNodeElement.readImmediate("oldBc", "oldBci", group.tagNodeImmediate)));
                    b.string(".tags");
                    b.end();
                    b.startIf().string("searchOp == op && searchTags == opTags").end().startBlock();
                    b.statement("opCounter++");
                    b.end();
                } else {
                    b.startIf().string("searchOp == op").end().startBlock();
                    b.statement("opCounter++");
                    b.end();
                }
                b.statement("oldBci += " + group.instructionLength);
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected bytecode."));
            b.end();
            b.end();
            b.end();
            b.startAssert().string("opCounter > 0").end();
            b.startWhile().string("opCounter > 0").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "op", BytecodeRootNodeElement.readInstruction("newBc", "newBci"));
            b.startSwitch().string("op").end().startBlock();
            for (Map.Entry<InstructionGroup, List<InstructionModel>> groupEntry : this.groupInstructionsSortedBy(x$0 -> new InstructionGroup((InstructionModel)x$0))) {
                group = groupEntry.getKey();
                if (!group.instrumentation) continue;
                instructions = groupEntry.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startBlock();
                if (group.tagInstrumentation) {
                    b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "opTags");
                    b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), "newTagNodes", BytecodeRootNodeElement.readImmediate("newBc", "newBci", group.tagNodeImmediate)));
                    b.string(".tags");
                    b.end();
                    b.startIf().string("searchOp == op && searchTags == opTags").end().startBlock();
                    b.statement("opCounter--");
                    b.end();
                } else {
                    b.startIf().string("searchOp == op").end().startBlock();
                    b.statement("opCounter--");
                    b.end();
                }
                b.statement("newBci += " + group.instructionLength);
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected bytecode."));
            b.end();
            b.end();
            b.end();
            b.startReturn().string("newBci").end();
            return invalidate;
        }

        private CodeExecutableElement createComputeNewBci() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "computeNewBci", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBci"));
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "oldBc"));
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "newBc"));
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "oldTagNodes"));
                ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.tagNode.asType()), "newTagNodes"));
            }
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "stableBci", "toStableBytecodeIndex(oldBc, oldBci)");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "newBci", "fromStableBytecodeIndex(newBc, stableBci)");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "oldBciBase", "fromStableBytecodeIndex(oldBc, stableBci)");
            b.startIf().string("oldBci != oldBciBase").end().startBlock();
            b.lineComment("Transition within an in instrumentation bytecode.");
            b.lineComment("Needs to compute exact location where to continue.");
            b.startAssign("newBci");
            b.startCall("transitionInstrumentationIndex").string("oldBc").string("oldBciBase").string("oldBci").string("newBc").string("newBci");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.string("oldTagNodes").string("newTagNodes");
            }
            b.end();
            b.end();
            b.end();
            b.startReturn().string("newBci").end();
            return ex;
        }

        private void emitStableBytecodeSearch(CodeTreeBuilder b, String targetVariable, String stableVariable, boolean toStableValue) {
            String searchVariable;
            String resultVariable;
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci", "0");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), stableVariable, "0");
            if (toStableValue) {
                resultVariable = stableVariable;
                searchVariable = "bci";
            } else {
                resultVariable = "bci";
                searchVariable = stableVariable;
            }
            b.startWhile().string(searchVariable, " != ", targetVariable, " && bci < bc.length").end().startBlock();
            b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end().startBlock();
            record InstructionGroup(int instructionLength, boolean instrumentation) implements Comparable<InstructionGroup>
            {
                InstructionGroup(InstructionModel instr) {
                    this(instr.getInstructionLength(), instr.isInstrumentation());
                }

                @Override
                public int compareTo(InstructionGroup o) {
                    int compare = Boolean.compare(this.instrumentation, o.instrumentation);
                    if (compare != 0) {
                        return compare;
                    }
                    compare = Integer.compare(this.instructionLength, o.instructionLength);
                    if (compare != 0) {
                        return compare;
                    }
                    return 0;
                }
            }
            for (Map.Entry<InstructionGroup, List<InstructionModel>> groupEntry : this.groupInstructionsSortedBy(x$0 -> new InstructionGroup((InstructionModel)x$0))) {
                InstructionGroup group = groupEntry.getKey();
                List<InstructionModel> instructions = groupEntry.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                if (group.instrumentation) {
                    b.statement("bci += " + group.instructionLength);
                } else {
                    b.statement("bci += " + group.instructionLength);
                    b.statement(stableVariable + " += " + group.instructionLength);
                }
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Invalid bytecode."));
            b.end();
            b.end();
            b.end();
            b.startIf().string("bci >= bc.length").end().startBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Could not translate bytecode index."));
            b.end();
            b.startReturn().string(resultVariable).end();
        }

        private <T extends Comparable<T>> List<Map.Entry<T, List<InstructionModel>>> groupInstructionsSortedBy(Function<InstructionModel, T> constructor) {
            return BytecodeRootNodeElement.this.model.getInstructions().stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(constructor)).entrySet().stream().sorted(Comparator.comparing(e -> (Comparable)e.getKey())).toList();
        }

        private CodeExecutableElement createToStableBytecodeIndex() {
            CodeExecutableElement translate = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "toStableBytecodeIndex", new CodeVariableElement[0]);
            translate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc"));
            translate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "searchBci"));
            this.emitStableBytecodeSearch(translate.createBuilder(), "searchBci", "stableBci", true);
            return translate;
        }

        private CodeExecutableElement createFromStableBytecodeIndex() {
            CodeExecutableElement translate = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "fromStableBytecodeIndex", new CodeVariableElement[0]);
            translate.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc"));
            translate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "stableSearchBci"));
            this.emitStableBytecodeSearch(translate.createBuilder(), "stableSearchBci", "stableBci", false);
            return translate;
        }

        private CodeExecutableElement createInvalidate() {
            CodeExecutableElement invalidate = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Void.TYPE), "invalidate", new CodeVariableElement[0]);
            invalidate.addParameter(new CodeVariableElement(this.asType(), "newNode"));
            invalidate.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(CharSequence.class), "reason"));
            CodeTreeBuilder b = invalidate.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc", "this.bytecodes");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci", "0");
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "continuationIndex", "0");
            }
            b.startAssign("this.oldBytecodes").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("bc").string("bc.length").end().end();
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.type(VarHandle.class), "loadLoadFence").end().end();
            b.startWhile().string("bci < bc.length").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "op", BytecodeRootNodeElement.readInstruction("bc", "bci"));
            b.startSwitch().string("op").end().startBlock();
            for (List<InstructionModel> instructions : BytecodeRootNodeElement.groupInstructionsByLength(BytecodeRootNodeElement.this.model.getInstructions())) {
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                int length = instructions.getFirst().getInstructionLength();
                InstructionModel invalidateInstruction = BytecodeRootNodeElement.this.model.getInvalidateInstruction(length);
                BytecodeRootNodeElement.this.emitInvalidateInstruction(b, "this", "bc", "bci", CodeTreeBuilder.singleString("op"), BytecodeRootNodeElement.this.createInstructionConstant(invalidateInstruction));
                b.statement("bci += " + length);
                b.statement("break");
                b.end();
            }
            b.end();
            b.end();
            b.end();
            b.statement("reportReplace(this, newNode, reason)");
            return invalidate;
        }

        private CodeExecutableElement createUpdateContinuationRootNodes() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Void.TYPE), "updateContinuationRootNodes", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(this.asType(), "newNode"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(CharSequence.class), "reason"));
            ex.addParameter(new CodeVariableElement(ElementHelpers.generic(ArrayList.class, BytecodeRootNodeElement.this.continuationLocation.asType()), "continuationLocations"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "bytecodeReparsed"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startFor().type(BytecodeRootNodeElement.this.continuationLocation.asType()).string(" continuationLocation : continuationLocations").end().startBlock();
            b.startDeclaration(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType(), "continuationRootNode");
            b.cast(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType());
            b.string("constants[continuationLocation.constantPoolIndex]");
            b.end();
            b.declaration(BytecodeRootNodeElement.this.types.BytecodeLocation, "newLocation");
            b.startIf().string("continuationLocation.bci == -1").end().startBlock();
            b.statement("newLocation = null");
            b.end().startElseBlock();
            b.startAssign("newLocation").string("newNode.getBytecodeLocation(continuationLocation.bci)").end();
            b.end();
            b.startIf().string("bytecodeReparsed").end().startBlock();
            b.startStatement().startCall("continuationRootNode", "updateBytecodeLocation");
            b.string("newLocation");
            b.string("this");
            b.string("newNode");
            b.string("reason");
            b.end(2);
            b.end().startElseBlock();
            b.startStatement().startCall("continuationRootNode", "updateBytecodeLocationWithoutInvalidate");
            b.string("newLocation");
            b.end(2);
            b.end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createAdoptNodesAfterUpdate() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC), BytecodeRootNodeElement.this.type(Void.TYPE), "adoptNodesAfterUpdate", new CodeVariableElement[0]);
            CodeTreeBuilder b = ex.createBuilder();
            b.lineComment("no nodes to adopt");
            return ex;
        }

        private CodeExecutableElement createGetSourceLocation() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getSourceLocation", new String[]{"bci"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "info", "this.sourceInfo");
            b.startIf().string("info == null").end().startBlock();
            b.startReturn().string("null").end();
            b.end();
            b.startFor().string("int i = 0; i < info.length; i += SOURCE_INFO_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci", "info[i + SOURCE_INFO_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci", "info[i + SOURCE_INFO_OFFSET_END_BCI]");
            b.startIf().string("startBci <= bci && bci < endBci").end().startBlock();
            b.startReturn().string("createSourceSection(sources, info, i)").end();
            b.end();
            b.end();
            b.startReturn().string("null").end();
            return ex;
        }

        private CodeExecutableElement createGetSourceLocations() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getSourceLocations", new String[]{"bci"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "info", "this.sourceInfo");
            b.startIf().string("info == null").end().startBlock();
            b.startReturn().string("null").end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "sectionIndex", "0");
            b.startDeclaration(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.SourceSection), "sections").startNewArray(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.SourceSection), CodeTreeBuilder.singleString("8")).end().end();
            b.startFor().string("int i = 0; i < info.length; i += SOURCE_INFO_LENGTH").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "startBci", "info[i + SOURCE_INFO_OFFSET_START_BCI]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "endBci", "info[i + SOURCE_INFO_OFFSET_END_BCI]");
            b.startIf().string("startBci <= bci && bci < endBci").end().startBlock();
            b.startIf().string("sectionIndex == sections.length").end().startBlock();
            b.startAssign("sections").startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
            b.string("sections");
            b.startStaticCall(BytecodeRootNodeElement.this.type(Math.class), "min").string("sections.length * 2").string("info.length / SOURCE_INFO_LENGTH").end();
            b.end(2);
            b.end();
            b.startStatement().string("sections[sectionIndex++] = createSourceSection(sources, info, i)").end();
            b.end();
            b.end();
            b.startReturn().startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf").string("sections").string("sectionIndex").end().end();
            return ex;
        }

        private CodeExecutableElement createCreateSourceSection() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.types.SourceSection, "createSourceSection", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(ElementHelpers.generic(List.class, (TypeMirror)BytecodeRootNodeElement.this.types.Source), "sources"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(int[].class), "info"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "index"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "sourceIndex", "info[index + SOURCE_INFO_OFFSET_SOURCE]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "start", "info[index + SOURCE_INFO_OFFSET_START]");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "length", "info[index + SOURCE_INFO_OFFSET_LENGTH]");
            b.startIf().string("start == -1 && length == -1").end().startBlock();
            b.startReturn().string("sources.get(sourceIndex).createUnavailableSection()").end();
            b.end();
            b.startAssert().string("start >= 0 : ").doubleQuote("invalid source start index").end();
            b.startAssert().string("length >= 0 : ").doubleQuote("invalid source length").end();
            b.startReturn().string("sources.get(sourceIndex).createSection(start, length)").end();
            return ex;
        }

        private CodeExecutableElement createGetSourceSection() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.Node, "getSourceSection");
            ex.getAnnotationMirrors().add(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.CompilerDirectives_TruffleBoundary));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "info", "this.sourceInfo");
            b.startIf().string("info == null").end().startBlock();
            b.startReturn().string("null").end();
            b.end();
            b.lineComment("The source table encodes a preorder traversal of a logical tree of source sections (with entries in reverse).");
            b.lineComment("The most specific source section corresponds to the \"lowest\" node in the tree that covers the whole bytecode range.");
            b.lineComment("We find this node by iterating the entries from the root until we hit a node that does not cover the bytecode range.");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "mostSpecific", "-1");
            b.startFor().string("int i = info.length - SOURCE_INFO_LENGTH; i >= 0; i -= SOURCE_INFO_LENGTH").end().startBlock();
            b.startIf();
            b.string("info[i + SOURCE_INFO_OFFSET_START_BCI] != 0 ||").startIndention().newLine();
            b.string("info[i + SOURCE_INFO_OFFSET_END_BCI] != bytecodes.length").end();
            b.end().startBlock();
            b.statement("break");
            b.end();
            b.statement("mostSpecific = i");
            b.end();
            b.startIf().string("mostSpecific != -1").end().startBlock();
            b.startReturn();
            b.string("createSourceSection(sources, info, mostSpecific)");
            b.end();
            b.end();
            b.startReturn().string("null").end();
            return ex;
        }

        private CodeExecutableElement createFindInstruction() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "findInstruction", new String[]{"bci"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.startNew(BytecodeRootNodeElement.this.instructionImpl.asType());
            b.string("this").string("bci").string("readValidBytecode(this.bytecodes, bci)");
            b.end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createValidateBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "validateBytecodeIndex", new String[]{"bci"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "bc", "this.bytecodes");
            b.startIf().string("bci < 0 || bci >= bc.length").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IllegalArgumentException.class)).startGroup().doubleQuote("Bytecode index out of range ").string(" + bci").end().end().end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "op", "readValidBytecode(bc, bci)");
            short maxId = BytecodeRootNodeElement.this.model.getInstructions().stream().max(Comparator.comparingInt(i -> i.getId())).get().getId();
            b.startIf().string("op < 0 || op > ").string(maxId).end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IllegalArgumentException.class)).startGroup().doubleQuote("Invalid op at bytecode index ").string(" + op").end().end().end();
            b.end();
            b.returnTrue();
            return ex;
        }

        private CodeExecutableElement createHasSourceInformation() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "hasSourceInformation");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return sourceInfo != null");
            return ex;
        }

        private CodeExecutableElement createGetSourceInformation() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getSourceInformation");
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("sourceInfo == null").end().startBlock();
            b.returnNull();
            b.end();
            b.startReturn();
            b.startNew("SourceInformationList").string("this").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetSourceInformationTree() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getSourceInformationTree");
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("sourceInfo == null").end().startBlock();
            b.returnNull();
            b.end();
            b.startReturn();
            b.string("SourceInformationTreeImpl.parse(this)");
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetExceptionHandlers() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getExceptionHandlers");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.startNew("ExceptionHandlerList").string("this").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetTagTree() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getTagTree");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startIf().string("this.tagRoot == null").end().startBlock();
                b.statement("return null");
                b.end();
                b.statement("return this.tagRoot.root");
            } else {
                b.statement("return null");
            }
            return ex;
        }

        record InstructionValidationGroup(List<InstructionModel.InstructionImmediate> immediates, int instructionLength, boolean allowNegativeChildBci, boolean localVar, boolean localVarMat) {
            InstructionValidationGroup(BytecodeDSLModel model, InstructionModel instruction) {
                this(instruction.getImmediates(), instruction.getInstructionLength(), AbstractBytecodeNodeElement.acceptsInvalidChildBci(model, instruction), instruction.kind.isLocalVariableAccess(), instruction.kind.isLocalVariableMaterializedAccess());
            }
        }
    }

    final class BytecodeNodeElement
    extends CodeTypeElement {
        private static final String METADATA_FIELD_NAME = "osrMetadata_";
        private static final String FORCE_UNCACHED_THRESHOLD = "Integer.MIN_VALUE";
        private final InterpreterTier tier;
        private final Map<InstructionModel, CodeExecutableElement> doInstructionMethods;

        BytecodeNodeElement(InterpreterTier tier) {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, tier.bytecodeClassName());
            this.doInstructionMethods = new LinkedHashMap<InstructionModel, CodeExecutableElement>();
            this.tier = tier;
            this.setSuperClass(BytecodeRootNodeElement.this.abstractBytecodeNode.asType());
            this.addAll(this.createContinueAt());
            this.getAnnotationMirrors().add(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.DenyReplace));
            if (tier.isUncached()) {
                this.add(this.createUncachedConstructor());
                this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "uncachedExecuteCount_"));
            } else if (tier.isCached()) {
                this.add(this.createCachedConstructor());
                this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.PRIVATE), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "cachedNodes_")));
                this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Boolean.TYPE)), "exceptionProfiles_")));
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    this.add(BytecodeRootNodeElement.this.child(new CodeVariableElement(Set.of(Modifier.PRIVATE), this.getCachedDataClassType(BytecodeRootNodeElement.this.model.epilogExceptional.operation.instruction), "epilogExceptionalNode_")));
                }
                if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                    this.add(BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags_")));
                    if (BytecodeRootNodeElement.this.model.enableYield) {
                        this.add(BytecodeRootNodeElement.this.compFinal(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.VOLATILE), BytecodeRootNodeElement.this.types.Assumption, "stableTagsAssumption_")));
                    }
                }
                this.add(this.createLoadConstantCompiled());
                this.add(this.createAdoptNodesAfterUpdate());
                this.addAll(this.createBranchProfileMembers());
                this.getImplements().add(BytecodeRootNodeElement.this.types.BytecodeOSRNode);
                this.add(this.createExecuteOSR());
                this.add(this.createPrepareOSR());
                this.add(this.createCopyIntoOSRFrame());
                this.addAll(this.createMetadataMembers());
                this.addAll(this.createStoreAndRestoreParentFrameMethods());
            } else if (tier.isUninitialized()) {
                this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this));
            } else {
                throw new AssertionError((Object)"invalid tier");
            }
            this.add(this.createSetUncachedThreshold());
            this.add(this.createGetTier());
            if (!tier.isUninitialized()) {
                this.add(this.createCopyConstructor());
                this.add(this.createResolveThrowable());
                this.add(this.createResolveHandler());
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    this.add(this.createDoEpilogExceptional());
                }
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    this.add(this.createDoTagExceptional());
                }
                if (BytecodeRootNodeElement.this.model.interceptControlFlowException != null) {
                    this.add(this.createResolveControlFlowException());
                }
            }
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                this.add(this.createGetLocalTags());
                this.add(this.createGetLocalValue());
                this.add(this.createSetLocalValue());
                this.add(this.createGetLocalValueInternal(BytecodeRootNodeElement.this.type(Object.class)));
                this.add(this.createSetLocalValueInternal(BytecodeRootNodeElement.this.type(Object.class)));
                for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                    this.add(this.createGetLocalValueInternal(boxingType));
                    this.add(this.createSetLocalValueInternal(boxingType));
                }
                if (tier.isCached()) {
                    this.add(this.createSetLocalValueImpl());
                    this.add(this.createSpecializeSlotTag());
                    this.add(this.createGetCachedLocalTag());
                    this.add(this.createSetCachedLocalTag());
                }
                this.add(this.createGetCachedLocalTagInternal());
                this.add(this.createSetCachedLocalTagInternal());
                if (BytecodeRootNodeElement.this.model.enableYield) {
                    this.add(this.createCheckStableTagsAssumption());
                }
            }
            this.add(this.createToCached());
            this.add(this.createUpdate());
            this.add(this.createCloneUninitialized());
            if (this.cloneUninitializedNeedsUnquickenedBytecode()) {
                this.add(this.createUnquickenBytecode());
            }
            this.add(this.createGetCachedNodes());
            this.add(this.createGetBranchProfiles());
            this.add(this.createFindBytecodeIndex1());
            this.add(this.createFindBytecodeIndex2());
            if (BytecodeRootNodeElement.this.model.storeBciInFrame) {
                this.add(this.createGetBytecodeIndex());
            } else {
                this.add(this.createFindBytecodeIndexOfOperationNode());
            }
            this.add(this.createToString());
        }

        private CodeExecutableElement createExecuteOSR() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "executeOSR", new String[]{"frame", "target", "unused"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.VirtualFrame, BytecodeRootNodeElement.this.type(Long.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            CodeTreeBuilder b = ex.getBuilder();
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.declaration(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame");
                b.startIf().string(BytecodeRootNodeElement.this.decodeUseContinuationFrame("target")).string(" /* use continuation frame */").end().startBlock();
                b.startAssign("localFrame");
                b.cast(BytecodeRootNodeElement.this.types.MaterializedFrame);
                BytecodeRootNodeElement.startGetFrame(b, "frame", BytecodeRootNodeElement.this.type(Object.class), false).string(BytecodeRootNodeElement.COROUTINE_FRAME_INDEX).end();
                b.end();
                b.end().startElseBlock();
                b.statement("localFrame = frame");
                b.end();
            }
            b.startReturn().startCall("continueAt");
            b.string("getRoot()");
            b.string("frame");
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.string("localFrame");
                b.string(BytecodeRootNodeElement.this.clearUseContinuationFrame("target"));
            } else {
                b.string("target");
            }
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createPrepareOSR() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "prepareOSR", new String[]{"target"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Long.TYPE)});
            CodeTreeBuilder b = ex.getBuilder();
            b.lineComment("do nothing");
            return ex;
        }

        private CodeExecutableElement createCopyIntoOSRFrame() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "copyIntoOSRFrame", new String[]{"osrFrame", "parentFrame", "target", "targetMetadata"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.VirtualFrame, BytecodeRootNodeElement.this.types.VirtualFrame, BytecodeRootNodeElement.this.type(Long.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            CodeTreeBuilder b = ex.getBuilder();
            b.startStatement().startCall("transferOSRFrame");
            b.string("osrFrame");
            b.string("parentFrame");
            b.string("target");
            b.string("targetMetadata");
            b.end(2);
            return ex;
        }

        private List<CodeElement<Element>> createMetadataMembers() {
            CodeVariableElement osrMetadataField = BytecodeRootNodeElement.this.compFinal(new CodeVariableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.context.getDeclaredType(Object.class), METADATA_FIELD_NAME));
            CodeExecutableElement getOSRMetadata = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "getOSRMetadata");
            getOSRMetadata.getBuilder().startReturn().string(METADATA_FIELD_NAME).end();
            CodeExecutableElement setOSRMetadata = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "setOSRMetadata", new String[]{"osrMetadata"});
            setOSRMetadata.getBuilder().startAssign(METADATA_FIELD_NAME).string("osrMetadata").end();
            return List.of(osrMetadataField, getOSRMetadata, setOSRMetadata);
        }

        private List<CodeExecutableElement> createStoreAndRestoreParentFrameMethods() {
            CodeExecutableElement storeParentFrameInArguments = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "storeParentFrameInArguments", new String[]{"parentFrame"});
            CodeTreeBuilder sb = storeParentFrameInArguments.getBuilder();
            sb.declaration(BytecodeRootNodeElement.this.type(Object[].class), "parentArgs", "parentFrame.getArguments()");
            sb.declaration(BytecodeRootNodeElement.this.type(Object[].class), "result", "Arrays.copyOf(parentArgs, parentArgs.length + 1)");
            sb.statement("result[result.length - 1] = parentFrame");
            sb.startReturn().string("result").end();
            CodeExecutableElement restoreParentFrameFromArguments = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "restoreParentFrameFromArguments", new String[]{"arguments"});
            CodeTreeBuilder rb = restoreParentFrameFromArguments.getBuilder();
            rb.startReturn().cast(BytecodeRootNodeElement.this.types.Frame).string("arguments[arguments.length - 1]").end();
            return List.of(storeParentFrameInArguments, restoreParentFrameFromArguments);
        }

        private boolean useOperationNodeForBytecodeIndex() {
            return !BytecodeRootNodeElement.this.model.storeBciInFrame && this.tier == InterpreterTier.CACHED;
        }

        private boolean useFrameForBytecodeIndex() {
            return BytecodeRootNodeElement.this.model.storeBciInFrame || this.tier == InterpreterTier.UNCACHED;
        }

        private CodeExecutableElement createGetLocalValue() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalValue", new String[]{"bci", "frame", "localOffset"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
            if (this.tier.isCached()) {
                b.startTryBlock();
                b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag");
                b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inInterpreter").end().end().startBlock();
                b.lineComment("Resolving the local index is expensive. Don't do it in the interpreter.");
                b.startAssign("tag");
                b.string("frame.getTag(frameIndex)");
                b.end();
                b.end().startElseBlock();
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", "localOffsetToLocalIndex(bci, localOffset)");
                    b.startAssign("tag").string("getCachedLocalTagInternal(this.localTags_, localIndex)").end();
                } else {
                    b.startAssign("tag").string("getCachedLocalTag(localOffset)").end();
                }
                b.end();
                b.startSwitch().string("tag").end().startBlock();
                for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                    b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                    b.startCaseBlock();
                    b.startReturn();
                    BytecodeRootNodeElement.startExpectFrame(b, "frame", boxingType, false).string("frameIndex").end();
                    b.end();
                    b.end();
                }
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                b.startCaseBlock();
                b.startReturn();
                BytecodeRootNodeElement.startExpectFrame(b, "frame", BytecodeRootNodeElement.this.type(Object.class), false).string("frameIndex").end();
                b.end();
                b.end();
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getIllegal()).end();
                b.startCaseBlock();
                b.startReturn();
                if (BytecodeRootNodeElement.this.model.defaultLocalValueExpression != null) {
                    b.string("DEFAULT_LOCAL_VALUE");
                } else {
                    b.string("null");
                }
                b.end();
                b.end();
                b.caseDefault().startCaseBlock();
                b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected tag"));
                b.end();
                b.end();
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.startReturn().string("ex.getResult()").end();
                b.end();
            } else {
                b.startIf().string("frame.isObject(frameIndex)").end().startBlock();
                b.startReturn().string("frame.getObject(frameIndex)").end();
                b.end();
                b.statement("return null");
            }
            return ex;
        }

        private CodeExecutableElement createSetLocalValue() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setLocalValue", new String[]{"bci", "frame", "localOffset", "value"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Object.class)});
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert validateBytecodeIndex(bci)");
            AbstractBytecodeNodeElement.buildVerifyLocalsIndex(b);
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination() && this.tier.isCached()) {
                b.startStatement().startCall("setLocalValueImpl");
                b.string("frame").string("localOffset").string("value");
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    b.string("bci");
                }
                b.end().end();
            } else {
                b.startStatement();
                b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("localOffset + USER_LOCALS_START_INDEX").string("value").end();
                b.end();
            }
            return ex;
        }

        private CodeExecutableElement createSetLocalValueImpl() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !this.tier.isCached()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "setLocalValueImpl", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffset"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "value"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "localOffset + USER_LOCALS_START_INDEX");
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", "localOffsetToLocalIndex(bci, localOffset)");
                b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "oldTag", "getCachedLocalTagInternal(this.localTags_, localIndex)");
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "oldTag", "getCachedLocalTag(localOffset)");
            }
            b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "newTag");
            b.startSwitch().string("oldTag").end().startBlock();
            for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                b.startCaseBlock();
                String primitiveValue = boxingType.toString().toLowerCase() + "Value";
                b.startIf().instanceOf("value", ElementUtils.boxType(boxingType), primitiveValue).end().startBlock();
                b.startStatement();
                b.startCall("frame", BytecodeRootNodeElement.getSetMethod(boxingType)).string("frameIndex").string(primitiveValue).end();
                b.end();
                b.statement("return");
                b.end();
                b.startElseBlock();
                b.startAssign("newTag").staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                b.end();
                b.statement("break");
                b.end();
            }
            b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
            b.startCaseBlock();
            b.startStatement();
            b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("frameIndex").string("value").end();
            b.end();
            b.statement("return");
            b.end();
            b.caseDefault().startCaseBlock();
            b.startAssign("newTag").string("specializeSlotTag(value)").end();
            b.statement("break");
            b.end();
            b.end();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("setCachedLocalTagInternal(this.localTags_, localIndex, newTag)");
                b.statement("setLocalValueImpl(frame, localOffset, value, bci)");
            } else {
                b.statement("setCachedLocalTagInternal(this.localTags_, localOffset, newTag)");
                b.statement("setLocalValueImpl(frame, localOffset, value)");
            }
            return ex;
        }

        private CodeExecutableElement createSetLocalValueInternal(TypeMirror specializedType) {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            boolean generic = ElementUtils.isObject(specializedType);
            String suffix = ElementUtils.isObject(specializedType) ? "" : ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(specializedType));
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setLocalValueInternal" + suffix, new String[]{"frame", "localOffset", "localIndex", "value"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE), specializedType});
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            if (this.tier.isCached()) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
                b.startDeclaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "oldTag");
                b.startCall("getCachedLocalTag");
                b.string("localIndex");
                b.end();
                b.end();
                b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "newTag");
                b.startSwitch().string("oldTag").end().startBlock();
                for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                    if (!generic && !ElementUtils.typeEquals(boxingType, specializedType)) continue;
                    b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                    b.startCaseBlock();
                    if (generic) {
                        String primitiveValue = boxingType.toString().toLowerCase() + "Value";
                        b.startIf().instanceOf("value", ElementUtils.boxType(boxingType), primitiveValue).end().startBlock();
                        b.startStatement();
                        b.startCall("frame", BytecodeRootNodeElement.getSetMethod(boxingType)).string("frameIndex").string(primitiveValue).end();
                        b.end();
                        b.statement("return");
                        b.end();
                        b.startElseBlock();
                        b.startAssign("newTag").staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                        b.end();
                        b.statement("break");
                    } else {
                        b.startStatement();
                        b.startCall("frame", BytecodeRootNodeElement.getSetMethod(boxingType)).string("frameIndex").string("value").end();
                        b.end();
                        b.statement("return");
                    }
                    b.end();
                }
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                b.startCaseBlock();
                b.startStatement();
                b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("frameIndex").string("value").end();
                b.end();
                b.statement("return");
                b.end();
                b.caseDefault().startCaseBlock();
                b.startAssign("newTag").string("specializeSlotTag(value)").end();
                b.statement("break");
                b.end();
                b.end();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startStatement().startCall("setCachedLocalTagInternal");
                b.string("this.localTags_");
                b.string("localIndex");
                b.string("newTag");
                b.end(2);
                b.statement("setLocalValueInternal(frame, localOffset, localIndex, value)");
            } else {
                b.startStatement();
                b.startCall("frame", BytecodeRootNodeElement.getSetMethod(BytecodeRootNodeElement.this.type(Object.class))).string("USER_LOCALS_START_INDEX + localOffset").string("value").end();
                b.end();
            }
            return ex;
        }

        private CodeExecutableElement createGetLocalValueInternal(TypeMirror specializedType) {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            boolean generic = ElementUtils.isObject(specializedType);
            String suffix = generic ? "" : ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(specializedType));
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getLocalValueInternal" + suffix, new String[]{"frame", "localOffset", "localIndex"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.type(Integer.TYPE), BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.getModifiers().add(Modifier.FINAL);
            CodeTreeBuilder b = ex.createBuilder();
            AbstractBytecodeNodeElement.buildVerifyFrameDescriptor(b, true);
            if (this.tier.isCached()) {
                if (generic) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "frameIndex", "USER_LOCALS_START_INDEX + localOffset");
                    b.startTryBlock();
                    b.startDeclaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag").startCall("getCachedLocalTag");
                    b.string("localIndex");
                    b.end(2);
                    b.startSwitch().string("tag").end().startBlock();
                    for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                        b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                        b.startCaseBlock();
                        b.startReturn();
                        BytecodeRootNodeElement.startExpectFrame(b, "frame", boxingType, false).string("frameIndex").end();
                        b.end();
                        b.end();
                    }
                    b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                    b.startCaseBlock();
                    b.startReturn();
                    BytecodeRootNodeElement.startExpectFrame(b, "frame", BytecodeRootNodeElement.this.type(Object.class), false).string("frameIndex").end();
                    b.end();
                    b.end();
                    b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getIllegal()).end();
                    b.startCaseBlock();
                    if (BytecodeRootNodeElement.this.model.defaultLocalValueExpression != null) {
                        b.startReturn();
                        b.string("DEFAULT_LOCAL_VALUE");
                        b.end();
                    } else {
                        b.startThrow().startNew(BytecodeRootNodeElement.this.types.FrameSlotTypeException).end().end();
                    }
                    b.end();
                    b.caseDefault().startCaseBlock();
                    b.tree(GeneratorUtils.createShouldNotReachHere("unexpected tag"));
                    b.end();
                    b.end();
                    b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                    b.startReturn().string("ex.getResult()").end();
                    b.end();
                } else {
                    b.startReturn();
                    BytecodeRootNodeElement.startExpectFrame(b, "frame", specializedType, false).string("USER_LOCALS_START_INDEX + localOffset").end();
                    b.end();
                }
            } else if (generic) {
                b.startReturn().string("frame.getObject(USER_LOCALS_START_INDEX + localOffset)").end();
            } else {
                b.declaration(BytecodeRootNodeElement.this.type(Object.class), "value", "frame.getObject(USER_LOCALS_START_INDEX + localOffset)");
                b.startIf().string("value instanceof ").type(ElementUtils.boxType(specializedType)).string(" castValue").end().startBlock();
                b.startReturn().string("castValue").end();
                b.end();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startThrow().startNew(BytecodeRootNodeElement.this.types.UnexpectedResultException).string("value").end().end();
            }
            return ex;
        }

        private CodeExecutableElement createSetCachedLocalTag() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !this.tier.isCached()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "setCachedLocalTag", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags", "this.localTags_");
            b.startIf().string("localIndex < 0 || localIndex >= localTags.length").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Invalid local offset");
            b.end();
            b.startStatement().startCall("setCachedLocalTagInternal");
            b.string("localTags");
            b.string("localIndex");
            b.string("tag");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createGetCachedLocalTag() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !this.tier.isCached()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Byte.TYPE), "getCachedLocalTag", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags", "this.localTags_");
            b.startIf().string("localIndex < 0 || localIndex >= localTags.length").end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Invalid local offset");
            b.end();
            b.startReturn().startCall("getCachedLocalTagInternal");
            b.string("localTags");
            b.string("localIndex");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createSetCachedLocalTagInternal() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.abstractBytecodeNode.setCachedLocalTagInternal);
            CodeTreeBuilder b = ex.createBuilder();
            if (this.tier.isCached()) {
                b.tree(GeneratorUtils.createNeverPartOfCompilation());
                b.statement(BytecodeRootNodeElement.writeByte("localTags", "localIndex", "tag"));
                b.startStatement().startCall("reportReplace");
                b.string("this").string("this").doubleQuote("local tags updated");
                b.end(2);
                if (BytecodeRootNodeElement.this.model.usesBoxingElimination() && BytecodeRootNodeElement.this.model.enableYield) {
                    b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.Assumption, "oldStableTagsAssumption", "this.stableTagsAssumption_");
                    b.startIf().string("oldStableTagsAssumption != null").end().startBlock();
                    b.startAssign("this.stableTagsAssumption_").startStaticCall(BytecodeRootNodeElement.this.types.Assumption, "create");
                    b.doubleQuote("Stable local tags");
                    b.end(2);
                    b.startStatement().startCall("oldStableTagsAssumption.invalidate").doubleQuote("local tags updated").end(2);
                    b.end();
                }
            }
            return ex;
        }

        private CodeExecutableElement createGetCachedLocalTagInternal() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.abstractBytecodeNode.getCachedLocalTagInternal);
            CodeTreeBuilder b = ex.createBuilder();
            if (this.tier.isCached()) {
                b.startReturn();
                b.string(BytecodeRootNodeElement.readByte("localTags", "localIndex"));
                b.end();
            } else {
                b.startReturn().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
            }
            return ex;
        }

        private CodeExecutableElement createCheckStableTagsAssumption() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !BytecodeRootNodeElement.this.model.enableYield) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.abstractBytecodeNode.checkStableTagsAssumption);
            CodeTreeBuilder b = ex.createBuilder();
            if (this.tier.isCached()) {
                b.startReturn().string("this.stableTagsAssumption_.isValid()").end();
            } else {
                b.startReturn().string("true").end();
            }
            return ex;
        }

        private CodeExecutableElement createSpecializeSlotTag() {
            if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !this.tier.isCached()) {
                throw new AssertionError((Object)"Not supported.");
            }
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Byte.TYPE), "specializeSlotTag", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "value"));
            CodeTreeBuilder b = ex.createBuilder();
            boolean elseIf = false;
            for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                elseIf = b.startIf(elseIf);
                b.string("value instanceof ").type(ElementUtils.boxType(boxingType)).end().startBlock();
                b.startReturn().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                b.end();
            }
            b.startElseBlock();
            b.startReturn().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createFindBytecodeIndex1() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "findBytecodeIndex", new String[]{"frameInstance"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.FrameInstance});
            CodeTreeBuilder b = ex.createBuilder();
            if (this.useOperationNodeForBytecodeIndex()) {
                b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.Node, "prev", "null");
                b.startFor().string("Node current = frameInstance.getCallNode(); current != null; current = current.getParent()").end().startBlock();
                b.startIf().string("current == this && prev != null").end().startBlock();
                b.statement("return findBytecodeIndexOfOperationNode(prev)");
                b.end();
                b.statement("prev = current");
                b.end();
                b.startReturn().string("-1").end();
            } else if (this.useFrameForBytecodeIndex()) {
                CodeTree getFrame = CodeTreeBuilder.createBuilder().startCall("frameInstance", "getFrame").staticReference(BytecodeRootNodeElement.this.types.FrameInstance_FrameAccess, "READ_ONLY").end().build();
                if (BytecodeRootNodeElement.this.model.enableYield) {
                    b.declaration((TypeMirror)BytecodeRootNodeElement.this.types.Frame, "frame", getFrame);
                    if (BytecodeRootNodeElement.this.model.defaultLocalValueExpression == null) {
                        b.startIf().string("frame.isObject(COROUTINE_FRAME_INDEX)").end().end().startBlock();
                        b.startAssign("frame").cast(BytecodeRootNodeElement.this.types.Frame).string("frame.getObject(COROUTINE_FRAME_INDEX)").end();
                        b.end();
                    } else {
                        b.declaration(BytecodeRootNodeElement.this.type(Object.class), "coroutineFrame", "frame.getObject(COROUTINE_FRAME_INDEX)");
                        b.startIf().string("coroutineFrame != DEFAULT_LOCAL_VALUE").end().end().startBlock();
                        b.startAssign("frame").cast(BytecodeRootNodeElement.this.types.Frame).string("coroutineFrame").end();
                        b.end();
                    }
                    b.startReturn();
                    b.startCall("frame", "getInt");
                    b.string(BytecodeRootNodeElement.BCI_INDEX);
                    b.end(2);
                } else {
                    b.startReturn();
                    b.startCall(getFrame, "getInt");
                    b.string(BytecodeRootNodeElement.BCI_INDEX);
                    b.end(2);
                }
            } else {
                b.startReturn().string("-1").end();
            }
            return BytecodeRootNodeElement.this.withTruffleBoundary(ex);
        }

        private CodeExecutableElement createFindBytecodeIndex2() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "findBytecodeIndex", new String[]{"frame", "node"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame, BytecodeRootNodeElement.this.types.Node});
            CodeTreeBuilder b = ex.createBuilder();
            if (this.useOperationNodeForBytecodeIndex()) {
                b.startIf().string("node != null").end().startBlock();
                b.statement("return findBytecodeIndexOfOperationNode(node)");
                b.end();
                b.startReturn().string("-1").end();
            } else if (this.useFrameForBytecodeIndex()) {
                b.startReturn().string("frame.getInt(BCI_INDEX)").end();
            } else {
                b.startReturn().string("-1").end();
            }
            return ex;
        }

        private CodeExecutableElement createGetBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getBytecodeIndex", new String[]{"frame"}, new TypeMirror[]{BytecodeRootNodeElement.this.types.Frame});
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("frame.getInt(BCI_INDEX)").end();
            return ex;
        }

        private CodeExecutableElement createGetLocalTags() {
            CodeExecutableElement ex = GeneratorUtils.override((DeclaredType)BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "getLocalTags");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            switch (this.tier.ordinal()) {
                case 0: 
                case 1: {
                    b.string("null");
                    break;
                }
                case 2: {
                    b.string("this.localTags_");
                }
            }
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetCachedNodes() {
            CodeExecutableElement ex = GeneratorUtils.override((DeclaredType)BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "getCachedNodes");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            switch (this.tier.ordinal()) {
                case 0: 
                case 1: {
                    b.string("null");
                    break;
                }
                case 2: {
                    b.string("this.cachedNodes_");
                }
            }
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetBranchProfiles() {
            CodeExecutableElement ex = GeneratorUtils.override((DeclaredType)BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "getBranchProfiles");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            switch (this.tier.ordinal()) {
                case 0: 
                case 1: {
                    b.string("null");
                    break;
                }
                case 2: {
                    b.string("this.branchProfiles_");
                }
            }
            b.end();
            return ex;
        }

        private boolean cloneUninitializedNeedsUnquickenedBytecode() {
            return (BytecodeRootNodeElement.this.model.usesBoxingElimination() || BytecodeRootNodeElement.this.model.enableQuickening) && this.tier.isCached();
        }

        private CodeExecutableElement createCloneUninitialized() {
            CodeExecutableElement ex = GeneratorUtils.override((DeclaredType)BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "cloneUninitialized");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn();
            b.startNew(this.tier.friendlyName + "BytecodeNode");
            for (VariableElement var : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                b.startGroup();
                if (var.getSimpleName().contentEquals("tagRoot")) {
                    b.string("tagRoot != null ? ").cast(BytecodeRootNodeElement.this.tagRootNode.asType()).string("tagRoot.deepCopy() : null");
                } else if (var.getSimpleName().contentEquals("bytecodes")) {
                    if (this.cloneUninitializedNeedsUnquickenedBytecode()) {
                        b.startCall("unquickenBytecode").string("this.bytecodes").end();
                    } else {
                        b.startStaticCall(BytecodeRootNodeElement.this.type(Arrays.class), "copyOf");
                        b.string("this.bytecodes").string("this.bytecodes.length");
                        b.end();
                    }
                } else {
                    b.string("this.", var.getSimpleName().toString());
                }
                b.end();
            }
            if (this.tier.isCached() && BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.string("this.localTags_.length");
            }
            b.end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createUnquickenBytecode() {
            List instructions;
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "unquickenBytecode", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "original"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "copy", "Arrays.copyOf(original, original.length)");
            Map<Boolean, List<InstructionModel>> partitionedByIsQuickening = BytecodeRootNodeElement.this.model.getInstructions().stream().sorted((e1, e2) -> e1.name.compareTo(e2.name)).collect(Collectors.partitioningBy(InstructionModel::isQuickening));
            List<Map.Entry> regularGroupedByLength = partitionedByIsQuickening.get(false).stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(InstructionModel::getInstructionLength)).entrySet().stream().sorted(Comparator.comparing(entry -> (Integer)entry.getKey())).toList();
            List<Map.Entry> quickenedGroupedByQuickeningRoot = partitionedByIsQuickening.get(true).stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(InstructionModel::getQuickeningRoot)).entrySet().stream().sorted(Comparator.comparing(entry -> {
                InstructionModel.InstructionKind kind = ((InstructionModel)entry.getKey()).kind;
                return kind == InstructionModel.InstructionKind.CUSTOM || kind == InstructionModel.InstructionKind.CUSTOM_SHORT_CIRCUIT;
            }).thenComparing(entry -> ((InstructionModel)entry.getKey()).getInstructionLength())).toList();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci", "0");
            b.startWhile().string("bci < copy.length").end().startBlock();
            b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("copy", "bci")).end().startBlock();
            for (Map.Entry quickenedGroup : quickenedGroupedByQuickeningRoot) {
                InstructionModel quickeningRoot = (InstructionModel)quickenedGroup.getKey();
                instructions = (List)quickenedGroup.getValue();
                int instructionLength = ((InstructionModel)instructions.get(0)).getInstructionLength();
                for (InstructionModel instruction : instructions) {
                    if (instruction.getInstructionLength() != instructionLength) {
                        throw new AssertionError((Object)"quickened group has multiple different instruction lengths");
                    }
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                b.statement(BytecodeRootNodeElement.writeInstruction("copy", "bci", BytecodeRootNodeElement.this.createInstructionConstant(quickeningRoot)));
                b.startStatement().string("bci += ").string(instructionLength).end();
                b.statement("break");
                b.end();
            }
            for (Map.Entry regularGroup : regularGroupedByLength) {
                int instructionLength = (Integer)regularGroup.getKey();
                instructions = (List)regularGroup.getValue();
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                b.startStatement().string("bci += ").string(instructionLength).end();
                b.statement("break");
                b.end();
            }
            b.end();
            b.end();
            b.startReturn();
            b.string("copy");
            b.end();
            return ex;
        }

        private CodeExecutableElement createToCached() {
            CodeExecutableElement ex = GeneratorUtils.override(ElementUtils.findInstanceMethod(BytecodeRootNodeElement.this.abstractBytecodeNode, "toCached", null));
            CodeTreeBuilder b = ex.createBuilder();
            switch (this.tier.ordinal()) {
                case 0: 
                case 1: {
                    b.startReturn();
                    b.startNew(InterpreterTier.CACHED.friendlyName + "BytecodeNode");
                    for (VariableElement var : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                        b.string("this.", var.getSimpleName().toString());
                    }
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.string("numLocals");
                    }
                    b.end();
                    b.end();
                    break;
                }
                case 2: {
                    b.startReturn().string("this").end();
                }
            }
            return ex;
        }

        private CodeExecutableElement createCopyConstructor() {
            String name;
            CodeExecutableElement ex = new CodeExecutableElement(null, this.getSimpleName().toString());
            CodeTreeBuilder b = ex.createBuilder();
            b.startStatement();
            b.startSuperCall();
            for (VariableElement var : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                name = var.getSimpleName().toString();
                ex.addParameter(new CodeVariableElement(var.asType(), name));
                b.string(name);
            }
            b.end();
            b.end();
            for (VariableElement var : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                if (var.getModifiers().contains((Object)Modifier.STATIC)) continue;
                name = var.getSimpleName().toString();
                ex.addParameter(new CodeVariableElement(var.asType(), name));
                b.statement("this.", name, " = ", name);
            }
            return ex;
        }

        private CodeExecutableElement createUpdate() {
            CodeExecutableElement ex = GeneratorUtils.override(ElementUtils.findInstanceMethod(BytecodeRootNodeElement.this.abstractBytecodeNode, "update", null));
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("assert bytecodes_ != null || sourceInfo_ != null");
            for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                if (e.getModifiers().contains((Object)Modifier.STATIC)) continue;
                b.declaration(e.asType(), e.getSimpleName().toString() + "__");
            }
            b.startIf().string("bytecodes_ != null").end().startBlock();
            if (BytecodeRootNodeElement.this.model.isBytecodeUpdatable()) {
                b.statement("bytecodes__ = bytecodes_");
                b.statement("constants__ = constants_");
                b.statement("handlers__ = handlers_");
                b.statement("numNodes__ = numNodes_");
                b.statement("locals__ = locals_");
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.statement("tagRoot__ = tagRoot_");
                }
            } else {
                b.tree(GeneratorUtils.createShouldNotReachHere("The bytecode is not updatable for this node."));
            }
            b.end().startElseBlock();
            b.statement("bytecodes__ = this.bytecodes");
            b.statement("constants__ = this.constants");
            b.statement("handlers__ = this.handlers");
            b.statement("numNodes__ = this.numNodes");
            b.statement("locals__ = this.locals");
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.statement("tagRoot__ = this.tagRoot");
            }
            b.end();
            b.startIf().string("sourceInfo_ != null").end().startBlock();
            b.statement("sourceInfo__ = sourceInfo_");
            b.statement("sources__ = sources_");
            b.end().startElseBlock();
            b.statement("sourceInfo__ = this.sourceInfo");
            b.statement("sources__ = this.sources");
            b.end();
            if (this.tier.isCached()) {
                b.startIf().string("bytecodes_ != null").end().startBlock();
                b.lineComment("Can't reuse profile if bytecodes are changed.");
                b.startReturn();
                b.startNew(this.asType());
                for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                    if (e.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    b.string(e.getSimpleName().toString() + "__");
                }
                if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                    b.string("this.localTags_.length");
                }
                b.end();
                b.end();
                b.end().startElseBlock();
                b.lineComment("Can reuse profile if bytecodes are unchanged.");
                b.startReturn();
                b.startNew(this.asType());
                for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                    if (e.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    b.string(e.getSimpleName().toString() + "__");
                }
                for (VariableElement e : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                    if (e.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    b.string("this.", e.getSimpleName().toString());
                }
                b.end();
                b.end();
            } else {
                b.startReturn();
                b.startNew(this.asType());
                for (VariableElement e : ElementFilter.fieldsIn(BytecodeRootNodeElement.this.abstractBytecodeNode.getEnclosedElements())) {
                    b.string(e.getSimpleName().toString() + "__");
                }
                for (VariableElement e : ElementFilter.fieldsIn(this.getEnclosedElements())) {
                    b.string("this.", e.getSimpleName().toString());
                }
                b.end();
                b.end();
            }
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetTier() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "getTier");
            CodeTreeBuilder b = ex.createBuilder();
            switch (this.tier.ordinal()) {
                case 0: 
                case 1: {
                    b.startReturn().staticReference(BytecodeRootNodeElement.this.types.BytecodeTier, "UNCACHED").end();
                    break;
                }
                case 2: {
                    b.startReturn().staticReference(BytecodeRootNodeElement.this.types.BytecodeTier, "CACHED").end();
                }
            }
            return ex;
        }

        private CodeExecutableElement createFindBytecodeIndexOfOperationNode() {
            CodeExecutableElement ex = new CodeExecutableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "findBytecodeIndexOfOperationNode");
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.Node, "operationNode"));
            CodeTreeBuilder b = ex.createBuilder();
            if (!this.tier.isCached()) {
                b.startReturn().string("-1").end();
                return ex;
            }
            boolean hasNodeImmediate = false;
            for (InstructionModel instr : BytecodeRootNodeElement.this.model.getInstructions()) {
                if (!instr.hasNodeImmediate()) continue;
                hasNodeImmediate = true;
                break;
            }
            if (!hasNodeImmediate) {
                b.lineComment("No operation node exposed.");
                b.startReturn().string("-1").end();
                return ex;
            }
            b.startAssert().string("operationNode.getParent() == this : ").doubleQuote("Passed node must be an operation node of the same bytecode node.").end();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "localNodes", "this.cachedNodes_");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc", "this.bytecodes");
            b.statement("int bci = 0");
            b.string("loop: ").startWhile().string("bci < bc.length").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "currentBci", "bci");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeIndex");
            b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end().startBlock();
            Map<Boolean, List<InstructionModel>> instructionsGroupedByHasNode = BytecodeRootNodeElement.this.model.getInstructions().stream().collect(Collectors.partitioningBy(InstructionModel::hasNodeImmediate));
            Map<Integer, List<InstructionModel>> nodelessGroupedByLength = instructionsGroupedByHasNode.get(false).stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(InstructionModel::getInstructionLength));
            record LengthAndNodeIndex(int length, int nodeIndex) {
            }
            Map<LengthAndNodeIndex, List<InstructionModel>> nodedGroupedByLengthAndNodeIndex = instructionsGroupedByHasNode.get(true).stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(insn -> new LengthAndNodeIndex(insn.getInstructionLength(), insn.getImmediate(InstructionModel.ImmediateKind.NODE_PROFILE).offset())));
            for (Map.Entry<Integer, List<InstructionModel>> entry : nodelessGroupedByLength.entrySet()) {
                for (InstructionModel instr : entry.getValue()) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instr)).end();
                }
                b.startBlock();
                b.statement("bci += " + String.valueOf(entry.getKey()));
                b.statement("continue loop");
                b.end();
            }
            for (Map.Entry<Object, List<InstructionModel>> entry : nodedGroupedByLengthAndNodeIndex.entrySet()) {
                for (InstructionModel instr : entry.getValue()) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instr)).end();
                }
                InstructionModel representativeInstruction = entry.getValue().get(0);
                InstructionModel.InstructionImmediate imm = representativeInstruction.getImmediate(InstructionModel.ImmediateKind.NODE_PROFILE);
                b.startBlock();
                b.startStatement().string("nodeIndex = ");
                b.tree(BytecodeRootNodeElement.readImmediate("bc", "bci", imm));
                b.end();
                b.statement("bci += " + representativeInstruction.getInstructionLength());
                b.statement("break");
                b.end();
            }
            b.caseDefault().startBlock();
            BytecodeRootNodeElement.emitThrowAssertionError(b, "\"Should not reach here\"");
            b.end();
            b.end();
            b.startIf().string("localNodes[nodeIndex] == operationNode").end().startBlock();
            b.startReturn().string("currentBci").end();
            b.end();
            b.end();
            b.startReturn().string("-1").end();
            return BytecodeRootNodeElement.this.withTruffleBoundary(ex);
        }

        private CodeExecutableElement createToString() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.context.getDeclaredType(Object.class), "toString");
            CodeTreeBuilder b = ex.createBuilder();
            String tierString = switch (this.tier.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> "uncached";
                case 0 -> "uninitialized";
                case 2 -> "cached";
            };
            b.startReturn();
            b.startStaticCall(BytecodeRootNodeElement.this.type(String.class), "format");
            b.doubleQuote(ElementUtils.getSimpleName(BytecodeRootNodeElement.this.types.BytecodeNode) + " [name=%s, sources=%s, tier=" + tierString + "]");
            b.string("((RootNode) getParent()).getQualifiedName()");
            b.string("this.sourceInfo != null");
            b.end(2);
            return ex;
        }

        private CodeExecutableElement createUncachedConstructor() {
            CodeExecutableElement ex = GeneratorUtils.createConstructorUsingFields(Set.of(), this);
            CodeTreeBuilder b = ex.appendBuilder();
            if (BytecodeRootNodeElement.this.model.defaultUncachedThresholdExpression.resolveConstant() != null) {
                Integer i;
                Object object = BytecodeRootNodeElement.this.model.defaultUncachedThresholdExpression.resolveConstant();
                if (!(object instanceof Integer) || (i = (Integer)object) < 0) {
                    throw new AssertionError();
                }
                b.statement("this.uncachedExecuteCount_ = ", BytecodeRootNodeElement.this.model.defaultUncachedThreshold);
            } else {
                b.startStatement().startCall("setUncachedThreshold").string(BytecodeRootNodeElement.this.model.defaultUncachedThreshold).end(2);
            }
            return ex;
        }

        private CodeExecutableElement createCachedConstructor() {
            CodeExecutableElement ex = GeneratorUtils.createConstructorUsingFields(Set.of(), this);
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "numLocals"));
            }
            CodeTypeMirror.ArrayCodeTypeMirror nodeArrayType = new CodeTypeMirror.ArrayCodeTypeMirror(BytecodeRootNodeElement.this.types.Node);
            CodeTreeBuilder b = ex.appendBuilder();
            b.tree(GeneratorUtils.createNeverPartOfCompilation());
            b.declaration((TypeMirror)nodeArrayType, "result", "new Node[this.numNodes]");
            b.statement("byte[] bc = bytecodes");
            b.statement("int bci = 0");
            b.statement("int numConditionalBranches = 0");
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination() && BytecodeRootNodeElement.this.model.enableYield) {
                b.statement("boolean hasContinuations = false");
            }
            b.string("loop: ").startWhile().string("bci < bc.length").end().startBlock();
            b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end().startBlock();
            record CachedInitializationKey(int instructionLength, List<InstructionModel.InstructionImmediate> immediates, String nodeName, boolean separateYield) implements Comparable<CachedInitializationKey>
            {
                CachedInitializationKey(InstructionModel instr, BytecodeDSLModel m) {
                    this(instr.getInstructionLength(), instr.getImmediates().stream().filter(i -> BytecodeRootNodeElement.needsCachedInitialization(instr, i)).toList(), BytecodeRootNodeElement.cachedDataClassName(instr), m.usesBoxingElimination() && instr.kind == InstructionModel.InstructionKind.YIELD);
                }

                @Override
                public int compareTo(CachedInitializationKey o) {
                    int compare = Boolean.compare(this.separateYield, o.separateYield);
                    if (compare != 0) {
                        return compare;
                    }
                    compare = Integer.compare(this.immediates.size(), o.immediates.size());
                    if (compare != 0) {
                        return compare;
                    }
                    for (int i = 0; i < this.immediates.size(); ++i) {
                        InstructionModel.ImmediateKind otherKind;
                        InstructionModel.ImmediateKind thisKind = this.immediates.get(i).kind();
                        compare = thisKind.compareTo(otherKind = o.immediates.get(i).kind());
                        if (compare == 0) continue;
                        return compare;
                    }
                    compare = Integer.compare(this.instructionLength, o.instructionLength);
                    if (compare != 0) {
                        return compare;
                    }
                    return 0;
                }
            }
            Map<CachedInitializationKey, List<InstructionModel>> grouped = BytecodeRootNodeElement.this.model.getInstructions().stream().filter(i -> !i.isQuickening()).collect(BytecodeRootNodeElement.deterministicGroupingBy(i -> new CachedInitializationKey((InstructionModel)i, BytecodeRootNodeElement.this.model)));
            List sortedKeys = grouped.keySet().stream().sorted().toList();
            for (CachedInitializationKey key : sortedKeys) {
                List<InstructionModel> instructions = grouped.get(key);
                for (InstructionModel instr : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instr)).end();
                    for (InstructionModel quick : instr.getFlattenedQuickenedInstructions()) {
                        b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(quick)).end();
                    }
                }
                b.startCaseBlock();
                for (InstructionModel.InstructionImmediate immediate : key.immediates()) {
                    switch (immediate.kind()) {
                        case BRANCH_PROFILE: {
                            b.statement("numConditionalBranches++");
                            break;
                        }
                        case NODE_PROFILE: {
                            b.startStatement().string("result[");
                            b.tree(BytecodeRootNodeElement.readImmediate("bc", "bci", immediate)).string("] = ");
                            b.string("insert(new " + key.nodeName() + "())");
                            b.end();
                            break;
                        }
                    }
                }
                if (key.separateYield) {
                    if (!BytecodeRootNodeElement.this.model.usesBoxingElimination() || !BytecodeRootNodeElement.this.model.enableYield) {
                        throw new AssertionError();
                    }
                    b.statement("hasContinuations = true");
                }
                b.statement("bci += " + key.instructionLength());
                b.statement("break");
                b.end();
            }
            b.caseDefault().startBlock();
            BytecodeRootNodeElement.emitThrowAssertionError(b, "\"Should not reach here\"");
            b.end();
            b.end();
            b.end();
            b.startAssert().string("bci == bc.length").end();
            b.startAssign("this.cachedNodes_").string("result").end();
            b.startAssign("this.branchProfiles_").startCall("allocateBranchProfiles").string("numConditionalBranches").end(2);
            b.startAssign("this.exceptionProfiles_").string("handlers.length == 0 ? EMPTY_EXCEPTION_PROFILES : new boolean[handlers.length / 5]").end();
            if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                b.startAssign("this.epilogExceptionalNode_").startCall("insert").startNew(this.getCachedDataClassType(BytecodeRootNodeElement.this.model.epilogExceptional.operation.instruction)).end().end().end();
            }
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "localTags", "new byte[numLocals]");
                b.statement("Arrays.fill(localTags, FrameSlotKind.Illegal.tag)");
                b.startAssign("this.localTags_").string("localTags").end();
                if (BytecodeRootNodeElement.this.model.enableYield) {
                    b.startAssign("this.stableTagsAssumption_");
                    b.string("hasContinuations ? ");
                    b.startStaticCall(BytecodeRootNodeElement.this.types.Assumption, "create").doubleQuote("Stable local tags").end();
                    b.string(" : null");
                    b.end();
                }
            }
            this.add(new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(boolean[].class), "EMPTY_EXCEPTION_PROFILES")).createInitBuilder().string("new boolean[0]");
            return ex;
        }

        private CodeExecutableElement createSetUncachedThreshold() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.BytecodeNode, "setUncachedThreshold", new String[]{"threshold"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ElementUtils.setVisibility(ex.getModifiers(), Modifier.PUBLIC);
            ex.getModifiers().remove((Object)Modifier.ABSTRACT);
            CodeTreeBuilder b = ex.createBuilder();
            if (this.tier.isUncached()) {
                b.tree(GeneratorUtils.createNeverPartOfCompilation());
                b.startIf().string("threshold < 0 && threshold != ", FORCE_UNCACHED_THRESHOLD).end().startBlock();
                BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "threshold cannot be a negative value other than Integer.MIN_VALUE");
                b.end();
                b.startAssign("uncachedExecuteCount_").string("threshold").end();
            }
            return ex;
        }

        /*
         * WARNING - void declaration
         */
        private List<CodeExecutableElement> createContinueAt() {
            boolean hasSpecialHandler;
            ArrayList<CodeExecutableElement> methods = new ArrayList<CodeExecutableElement>();
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Long.TYPE), "continueAt", new CodeVariableElement[0]);
            GeneratorUtils.addOverride(ex);
            ex.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_BytecodeInterpreterSwitch));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame_"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame_"));
            }
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Long.TYPE), "startState"));
            methods.add(ex);
            CodeTreeBuilder b = ex.createBuilder();
            if (this.tier.isUninitialized()) {
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.statement("$root.transitionToCached()");
                b.startReturn().string("startState").end();
                return methods;
            }
            b.startDeclaration(BytecodeRootNodeElement.this.types.VirtualFrame, "frame").startCall("ACCESS.uncheckedCast").string("frame_").string("FRAME_TYPE").end().end();
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.startDeclaration(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame").startCall("ACCESS.uncheckedCast").string("localFrame_").string("FRAME_TYPE").end().end();
            }
            if (this.tier.isUncached()) {
                b.startDeclaration(BytecodeRootNodeElement.this.types.EncapsulatingNodeReference, "encapsulatingNode").startStaticCall(BytecodeRootNodeElement.this.types.EncapsulatingNodeReference, "getCurrent").end().end();
                b.startDeclaration(BytecodeRootNodeElement.this.types.Node, "prev").startCall("encapsulatingNode", "set").string("this").end().end();
                b.startTryBlock();
                b.startIf().string("uncachedExecuteCount_ <= 1").end().startBlock();
                b.startIf().string("uncachedExecuteCount_ != Integer.MIN_VALUE").end().startBlock();
                b.statement("$root.transitionToCached(frame, 0)");
                b.startReturn().string("startState").end();
                b.end(2);
                b.startElseBlock();
                b.statement("uncachedExecuteCount_--");
                b.end();
            }
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "bc", "this.bytecodes");
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Object.class)), "consts", "this.constants");
            if (this.tier.isCached()) {
                b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.types.Node), "cachedNodes", "this.cachedNodes_");
                b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "branchProfiles", "this.branchProfiles_");
                ex.addAnnotationMirror(BytecodeRootNodeElement.this.createExplodeLoopAnnotation("MERGE_EXPLODE"));
                if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                    b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags", "this.localTags_");
                }
            }
            b.statement("int bci = ", BytecodeRootNodeElement.decodeBci("startState"));
            b.statement("int sp = ", BytecodeRootNodeElement.decodeSp("startState"));
            b.statement("int op");
            b.statement("long temp");
            if (this.tier.isCached()) {
                b.declaration(BytecodeRootNodeElement.this.loopCounter.asType(), "loopCounter", CodeTreeBuilder.createBuilder().startNew(BytecodeRootNodeElement.this.loopCounter.asType()).end());
            }
            if (BytecodeRootNodeElement.this.model.needsBciSlot() && !BytecodeRootNodeElement.this.model.storeBciInFrame && !this.tier.isUncached()) {
                b.statement("FRAMES.setInt(" + BytecodeRootNodeElement.this.localFrame() + ", BCI_INDEX, -1)");
            }
            b.string("loop: ").startWhile().string("true").end().startBlock();
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.CompilerAsserts, "partialEvaluationConstant").string("bci").end().end();
            List<InstructionModel> instructions = BytecodeRootNodeElement.this.model.getInstructions().stream().filter(i -> !this.tier.isUncached() || !i.isQuickening()).filter(i -> BytecodeNodeElement.isInstructionReachable(i)).toList();
            List<List<InstructionModel>> instructionPartitions = this.partitionInstructions(instructions);
            b.startAssign("op").tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end();
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.CompilerAsserts, "partialEvaluationConstant").string("op").end().end();
            if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("beforeInstructionExecute")) {
                b.startStatement();
                b.startCall("$root.beforeInstructionExecute");
                BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                b.end().end();
            }
            b.startTryBlock();
            b.startSwitch().string("op").end().startBlock();
            List<InstructionModel> topLevelInstructions = instructionPartitions.get(0);
            Map<Boolean, List<InstructionModel>> groupedInstructions = topLevelInstructions.stream().collect(BytecodeRootNodeElement.deterministicGroupingBy(i -> BytecodeNodeElement.isForceCached(this.tier, i)));
            List forceCachedInstructions = groupedInstructions.getOrDefault(Boolean.TRUE, List.of());
            List otherTopLevelInstructions = groupedInstructions.getOrDefault(Boolean.FALSE, List.of());
            for (InstructionModel instruction : otherTopLevelInstructions) {
                this.buildInstructionCaseBlock(b, instruction);
            }
            if (!forceCachedInstructions.isEmpty()) {
                if (!this.tier.isUncached()) {
                    throw new AssertionError();
                }
                for (InstructionModel forceCachedInstruction : forceCachedInstructions) {
                    this.buildInstructionCases(b, forceCachedInstruction);
                }
                b.startBlock();
                b.statement("$root.transitionToCached(frame, bci)");
                b.statement("return ", BytecodeRootNodeElement.this.encodeState("bci", "sp"));
                b.end();
            }
            if (instructionPartitions.size() > 1) {
                LinkedHashMap<InstructionGroup, Integer> groupIndices = new LinkedHashMap<InstructionGroup, Integer>();
                LinkedHashMap<InstructionGroup, List> instructionGroups = new LinkedHashMap<InstructionGroup, List>();
                AtomicInteger index = new AtomicInteger();
                CodeExecutableElement firstContinueAt = null;
                for (int partitionIndex = 1; partitionIndex < instructionPartitions.size(); ++partitionIndex) {
                    for (InstructionModel instruction : instructionPartitions.get(partitionIndex)) {
                        if (BytecodeNodeElement.isForceCached(this.tier, instruction)) {
                            throw new AssertionError((Object)"Force cached not supported in non top-level partion.");
                        }
                        InstructionGroup group = new InstructionGroup(instruction);
                        groupIndices.computeIfAbsent(group, k -> index.incrementAndGet());
                        instructionGroups.computeIfAbsent(group, k -> new ArrayList()).add(instruction);
                    }
                    boolean bl = partitionIndex + 1 < instructionPartitions.size();
                    CodeExecutableElement continueAt = this.createPartitionContinueAt(partitionIndex, instructionPartitions.get(partitionIndex), groupIndices, bl);
                    methods.add(continueAt);
                    if (firstContinueAt != null) continue;
                    firstContinueAt = continueAt;
                }
                b.caseDefault().startCaseBlock();
                b.lineComment("Due to a limit of 8000 bytecodes for Java JIT compilation");
                b.lineComment("we delegate further bytecodes into a separate method.");
                b.startSwitch().startCall(firstContinueAt.getSimpleName().toString());
                for (VariableElement variableElement : firstContinueAt.getParameters()) {
                    b.string(variableElement.getSimpleName().toString());
                }
                b.end().end().startBlock();
                for (Map.Entry entry : groupIndices.entrySet()) {
                    InstructionGroup group = (InstructionGroup)entry.getKey();
                    int groupIndex = (Integer)entry.getValue();
                    b.startCase().string(groupIndex).end().startCaseBlock();
                    this.emitCustomStackEffect(b, group.stackEffect());
                    b.statement("bci += " + group.instructionLength());
                    b.statement("break");
                    b.end();
                }
                b.end();
                b.statement("break");
                b.end();
            }
            b.end();
            if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("afterInstructionExecute")) {
                b.startStatement();
                b.startCall("$root.afterInstructionExecute");
                BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                b.string("null");
                b.end().end();
            }
            b.end();
            b.startCatchBlock(BytecodeRootNodeElement.this.type(Throwable.class), "throwable");
            this.storeBciInFrameIfNecessary(b);
            if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("afterInstructionExecute")) {
                b.startStatement();
                b.startCall("$root.afterInstructionExecute");
                BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                b.string("throwable");
                b.end().end();
            }
            if (BytecodeRootNodeElement.this.model.interceptControlFlowException != null) {
                b.startIf().string("throwable instanceof ").type(BytecodeRootNodeElement.this.types.ControlFlowException).end().startBlock();
                b.startTryBlock();
                b.startAssign("temp");
                b.startCall("resolveControlFlowException");
                b.string("$root").string(BytecodeRootNodeElement.this.localFrame()).string("bci").startGroup().cast(BytecodeRootNodeElement.this.types.ControlFlowException).string("throwable").end();
                b.end().end();
                this.emitBeforeReturnProfiling(b);
                b.statement("return temp");
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.ControlFlowException, "rethrownCfe");
                b.startThrow().string("rethrownCfe").end();
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.AbstractTruffleException, "t");
                b.statement("throwable = t");
                b.end().startCatchBlock(BytecodeRootNodeElement.this.type(Throwable.class), "t");
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.statement("throwable = t");
                b.end();
                b.end();
                b.startAssign("throwable").string("resolveThrowable($root, " + BytecodeRootNodeElement.this.localFrame() + ", bci, throwable)").end();
            } else {
                b.startAssign("throwable").string("resolveThrowable($root, " + BytecodeRootNodeElement.this.localFrame() + ", bci, throwable)").end();
            }
            b.startAssign("op").string("-EXCEPTION_HANDLER_LENGTH").end();
            b.startWhile().string("(op = resolveHandler(bci, op + EXCEPTION_HANDLER_LENGTH, this.handlers)) != -1").end().startBlock();
            boolean bl = hasSpecialHandler = BytecodeRootNodeElement.this.model.enableTagInstrumentation || BytecodeRootNodeElement.this.model.epilogExceptional != null;
            if (hasSpecialHandler) {
                b.startTryBlock();
                b.startSwitch().string("this.handlers[op + EXCEPTION_HANDLER_OFFSET_KIND]").end().startBlock();
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    b.startCase().string("HANDLER_EPILOG_EXCEPTIONAL").end().startCaseBlock();
                    b.startIf().string("throwable instanceof ").type(BytecodeRootNodeElement.this.type(ThreadDeath.class)).end().startBlock();
                    b.statement("continue");
                    b.end();
                    b.startStatement().startCall("doEpilogExceptional");
                    b.string("$root").string("frame");
                    if (BytecodeRootNodeElement.this.model.enableYield) {
                        b.string("localFrame");
                    }
                    b.string("bc").string("bci").string("sp");
                    b.startGroup().cast(BytecodeRootNodeElement.this.types.AbstractTruffleException);
                    b.string("throwable");
                    b.end();
                    b.string("this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
                    b.end().end();
                    b.statement("throw sneakyThrow(throwable)");
                    b.end();
                }
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.startCase().string("HANDLER_TAG_EXCEPTIONAL").end().startCaseBlock();
                    b.declaration(BytecodeRootNodeElement.this.tagNode.asType(), "node", "this.tagRoot.tagNodes[this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]]");
                    b.statement("Object result = doTagExceptional(frame, node, this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI], bc, bci, throwable)");
                    b.startIf().string("result == null").end().startBlock();
                    b.startThrow().string("throwable").end();
                    b.end();
                    b.statement("temp = this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_SP] + $root.maxLocals");
                    b.startIf().string("result == ").staticReference(BytecodeRootNodeElement.this.types.ProbeNode, "UNWIND_ACTION_REENTER").end().startBlock();
                    b.lineComment("Reenter by jumping to the begin bci.");
                    b.statement("bci = node.enterBci");
                    b.end().startElseBlock();
                    b.startSwitch().string("readValidBytecode(bc, node.returnBci)").end().startBlock();
                    for (Map.Entry<TypeMirror, List<InstructionModel>> entry : BytecodeRootNodeElement.this.model.getInstructions().stream().filter(i -> i.kind == InstructionModel.InstructionKind.TAG_LEAVE).collect(BytecodeRootNodeElement.deterministicGroupingBy(i -> {
                        if (i.isReturnTypeQuickening()) {
                            return i.signature.returnType;
                        }
                        return BytecodeRootNodeElement.this.type(Object.class);
                    })).entrySet()) {
                        void var15_25;
                        int length = -1;
                        for (InstructionModel instructionModel : entry.getValue()) {
                            b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instructionModel)).end();
                            if (length != -1 && instructionModel.getInstructionLength() != length) {
                                throw new AssertionError((Object)"Unexpected length.");
                            }
                            length = instructionModel.getInstructionLength();
                        }
                        TypeMirror targetType = entry.getKey();
                        b.startCaseBlock();
                        Object var15_23 = null;
                        if (!ElementUtils.isObject(targetType)) {
                            CodeExecutableElement codeExecutableElement = BytecodeRootNodeElement.this.lookupExpectMethod(BytecodeRootNodeElement.this.parserType, targetType);
                            b.startTryBlock();
                        }
                        b.startStatement();
                        BytecodeRootNodeElement.startSetFrame(b, targetType).string("frame").string("(int)temp");
                        if (var15_25 == null) {
                            b.string("result");
                        } else {
                            b.startStaticCall((ExecutableElement)var15_25);
                            b.string("result");
                            b.end();
                        }
                        b.end();
                        b.end();
                        if (!ElementUtils.isObject(targetType)) {
                            b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "e");
                            b.startStatement();
                            BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("(int)temp").string("e.getResult()").end();
                            b.end();
                            b.end();
                        }
                        b.statement("temp = temp + 1");
                        b.statement("bci = node.returnBci + " + length);
                        b.statement("break");
                        b.end();
                    }
                    for (InstructionModel instruction : BytecodeRootNodeElement.this.model.getInstructions().stream().filter(i -> i.kind == InstructionModel.InstructionKind.TAG_LEAVE_VOID).toList()) {
                        b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                        b.startCaseBlock();
                        b.statement("bci = node.returnBci + " + instruction.getInstructionLength());
                        b.lineComment("discard return value");
                        b.statement("break");
                        b.end();
                    }
                    b.caseDefault().startCaseBlock();
                    b.tree(GeneratorUtils.createShouldNotReachHere());
                    b.end();
                    b.end();
                    b.end();
                    b.statement("break");
                    b.end();
                }
                b.caseDefault().startCaseBlock();
            }
            b.startIf().string("throwable instanceof ").type(BytecodeRootNodeElement.this.type(ThreadDeath.class)).end().startBlock();
            b.statement("continue");
            b.end();
            b.startAssert().string("throwable instanceof ").type(BytecodeRootNodeElement.this.types.AbstractTruffleException).end();
            b.statement("bci = this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
            b.statement("temp = this.handlers[op + EXCEPTION_HANDLER_OFFSET_HANDLER_SP] + $root.maxLocals");
            b.statement(BytecodeRootNodeElement.setFrameObject("((int) temp) - 1", "throwable"));
            if (hasSpecialHandler) {
                b.statement("break");
                b.end();
                b.end();
                b.end();
                b.startCatchBlock(BytecodeRootNodeElement.this.type(Throwable.class), "t");
                b.startIf().string("t != throwable").end().startBlock();
                b.statement("throwable = resolveThrowable($root, " + BytecodeRootNodeElement.this.localFrame() + ", bci, t)");
                b.end();
                b.statement("continue");
                b.end();
            }
            b.statement("assert sp >= temp - 1");
            b.startWhile().string("sp > temp").end().startBlock();
            b.statement(BytecodeRootNodeElement.clearFrame("frame", "--sp"));
            b.end();
            b.statement("sp = (int) temp");
            b.statement("continue loop");
            b.end();
            this.emitBeforeReturnProfiling(b);
            if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("afterRootExecute")) {
                b.startStatement();
                b.startCall("$root.afterRootExecute");
                BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                b.string("null");
                b.string("throwable");
                b.end();
                b.end();
            }
            b.statement("throw sneakyThrow(throwable)");
            b.end();
            b.end();
            if (this.tier.isUncached()) {
                b.end().startFinallyBlock();
                b.startStatement();
                b.startCall("encapsulatingNode", "set").string("prev").end();
                b.end();
                b.end();
            }
            methods.addAll(this.doInstructionMethods.values());
            return methods;
        }

        private CodeExecutableElement createPartitionContinueAt(int partitionIndex, List<InstructionModel> instructionGroup, Map<InstructionGroup, Integer> groupIndices, boolean hasMorePartitions) {
            String methodName = "continueAt_" + partitionIndex;
            CodeExecutableElement continueAtMethod = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), methodName, new CodeVariableElement[0]);
            continueAtMethod.getAnnotationMirrors().add(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_BytecodeInterpreterSwitch));
            continueAtMethod.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                continueAtMethod.getParameters().add(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            List<CodeVariableElement> extraParams = this.createExtraParameters(instructionGroup.stream().anyMatch(i -> i.hasImmediate(InstructionModel.ImmediateKind.CONSTANT)));
            if (this.tier.isCached()) {
                continueAtMethod.getParameters().add(new CodeVariableElement(new CodeTypeMirror.ArrayCodeTypeMirror(BytecodeRootNodeElement.this.types.Node), "cachedNodes"));
            }
            continueAtMethod.getParameters().addAll(extraParams);
            continueAtMethod.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "op"));
            CodeTreeBuilder b = continueAtMethod.createBuilder();
            b.startSwitch().string("op").end().startBlock();
            for (InstructionModel instruction : instructionGroup) {
                int groupIndex = groupIndices.get(new InstructionGroup(instruction));
                this.buildInstructionCases(b, instruction);
                b.startCaseBlock();
                this.buildCustomInstructionExecute(b, instruction);
                b.startReturn().string(groupIndex).end();
                b.end();
            }
            if (hasMorePartitions) {
                b.caseDefault().startCaseBlock();
                b.startReturn();
                b.startCall("continueAt_" + (partitionIndex + 1));
                for (VariableElement var : continueAtMethod.getParameters()) {
                    b.string(var.getSimpleName().toString());
                }
                b.end();
                b.end();
                b.end();
            }
            b.end();
            if (!hasMorePartitions) {
                b.returnDefault();
            }
            return continueAtMethod;
        }

        private void buildInstructionCases(CodeTreeBuilder b, InstructionModel instruction) {
            b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
            if (this.tier.isUncached()) {
                for (InstructionModel quickendInstruction : instruction.getFlattenedQuickenedInstructions()) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(quickendInstruction)).end();
                }
            }
        }

        private void buildInstructionCaseBlock(CodeTreeBuilder b, InstructionModel instr) {
            this.buildInstructionCases(b, instr);
            b.startBlock();
            switch (instr.kind) {
                case BRANCH: {
                    b.statement("bci = " + String.valueOf(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX))));
                    b.statement("break");
                    break;
                }
                case BRANCH_BACKWARD: {
                    if (this.tier.isUncached()) {
                        b.statement("bci = " + String.valueOf(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX))));
                        b.startIf().string("uncachedExecuteCount_ <= 1").end().startBlock();
                        b.startIf().string("uncachedExecuteCount_ != ", FORCE_UNCACHED_THRESHOLD).end().startBlock();
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.statement("$root.transitionToCached(frame, bci)");
                        b.statement("return ", BytecodeRootNodeElement.this.encodeState("bci", "sp"));
                        b.end(2);
                        b.startElseBlock();
                        b.statement("uncachedExecuteCount_--");
                        b.end();
                    } else {
                        this.emitReportLoopCount(b, CodeTreeBuilder.createBuilder().string("++loopCounter.value >= ").staticReference(BytecodeRootNodeElement.this.loopCounter.asType(), "REPORT_LOOP_STRIDE").build(), true);
                        b.startAssign("temp");
                        b.startCall(this.lookupBranchBackward(instr).getSimpleName().toString());
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                        b.startIf().string("temp != -1").end().startBlock();
                        b.statement("return temp");
                        b.end();
                        b.statement("bci = " + String.valueOf(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX))));
                    }
                    b.statement("break");
                    break;
                }
                case BRANCH_FALSE: {
                    String booleanValue = "(boolean) " + BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 1");
                    b.startIf();
                    if (this.tier.isUncached()) {
                        b.string(booleanValue);
                    } else {
                        b.startCall("profileBranch");
                        b.string("branchProfiles");
                        b.tree(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE)));
                        if (BytecodeRootNodeElement.this.model.isBoxingEliminated(BytecodeRootNodeElement.this.type(Boolean.TYPE))) {
                            if (instr.isQuickening()) {
                                b.startCall(this.lookupDoBranch(instr).getSimpleName().toString());
                                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                                    b.string("this");
                                }
                                b.string("frame").string("bc").string("bci").string("sp");
                                b.end();
                            } else {
                                b.startCall(this.lookupDoSpecializeBranch(instr).getSimpleName().toString());
                                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                                    b.string("this");
                                }
                                b.string("frame").string("bc").string("bci").string("sp");
                                b.end();
                            }
                        } else {
                            b.string(booleanValue);
                        }
                        b.end();
                    }
                    b.end();
                    b.startBlock();
                    b.statement("sp -= 1");
                    b.statement("bci += " + instr.getInstructionLength());
                    b.statement("break");
                    b.end().startElseBlock();
                    b.statement("sp -= 1");
                    b.statement("bci = " + String.valueOf(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate("branch_target"))));
                    b.statement("break");
                    b.end();
                    break;
                }
                case CUSTOM_SHORT_CIRCUIT: {
                    ShortCircuitInstructionModel shortCircuitInstruction = instr.shortCircuitModel;
                    b.startIf();
                    if (this.tier.isCached()) {
                        b.startCall("profileBranch");
                        b.string("branchProfiles");
                        b.tree(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE)));
                        b.startGroup();
                    }
                    if (shortCircuitInstruction.continueWhen()) {
                        b.string("!");
                    }
                    b.string("(boolean) ").string(BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 1"));
                    if (this.tier.isCached()) {
                        b.end(2);
                    }
                    b.end().startBlock();
                    if (!shortCircuitInstruction.producesBoolean()) {
                        b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
                        b.statement("sp -= 1");
                    }
                    b.startAssign("bci").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX))).end();
                    b.statement("break");
                    b.end().startElseBlock();
                    if (shortCircuitInstruction.producesBoolean()) {
                        b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
                        b.statement("sp -= 1");
                    } else {
                        b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
                        b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 2"));
                        b.statement("sp -= 2");
                    }
                    b.statement("bci += " + instr.getInstructionLength());
                    b.statement("break");
                    b.end();
                    break;
                }
                case TAG_RESUME: {
                    b.startStatement();
                    b.startCall(this.lookupTagResume(instr).getSimpleName().toString());
                    b.string("frame");
                    b.string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case TAG_ENTER: {
                    b.startStatement();
                    b.startCall(this.lookupTagEnter(instr).getSimpleName().toString());
                    b.string("frame");
                    b.string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case TAG_YIELD: {
                    b.startStatement();
                    b.startCall(this.lookupTagYield(instr).getSimpleName().toString());
                    b.string("frame");
                    b.string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case TAG_LEAVE: {
                    if (this.tier.isUncached() || instr.isQuickening() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupTagLeave(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame");
                        b.string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                        break;
                    }
                    b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                    b.startStatement();
                    b.startCall(this.lookupSpecializeTagLeave(instr).getSimpleName().toString());
                    if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                        b.string("this");
                    }
                    b.string("frame");
                    b.string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case TAG_LEAVE_VOID: {
                    b.startStatement();
                    b.startCall(this.lookupTagLeaveVoid(instr).getSimpleName().toString());
                    b.string("frame");
                    b.string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case LOAD_ARGUMENT: {
                    if (instr.isReturnTypeQuickening()) {
                        b.startStatement();
                        b.startCall(this.lookupLoadArgument(instr).getSimpleName().toString());
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                    } else {
                        InstructionModel.InstructionImmediate argIndex = instr.getImmediate(InstructionModel.ImmediateKind.SHORT);
                        b.startStatement();
                        BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp");
                        b.startGroup();
                        b.string(BytecodeRootNodeElement.this.localFrame() + ".getArguments()[" + BytecodeRootNodeElement.readImmediate("bc", "bci", argIndex).toString() + "]");
                        b.end();
                        b.end();
                        b.end();
                    }
                    b.statement("sp += 1");
                    break;
                }
                case LOAD_CONSTANT: {
                    InstructionModel.InstructionImmediate constIndex = instr.getImmediate(InstructionModel.ImmediateKind.CONSTANT);
                    TypeMirror returnType = instr.signature.returnType;
                    if (this.tier.isUncached() || BytecodeRootNodeElement.this.model.usesBoxingElimination() && !ElementUtils.isObject(returnType)) {
                        b.startStatement();
                        BytecodeRootNodeElement.startSetFrame(b, returnType).string("frame").string("sp");
                        b.tree(BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", constIndex), returnType));
                        b.end();
                        b.end();
                    } else {
                        b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inCompiledCode").end(2).startBlock();
                        b.statement("loadConstantCompiled(frame, bc, bci, sp, consts)");
                        b.end().startElseBlock();
                        b.statement(BytecodeRootNodeElement.setFrameObject("sp", BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", constIndex)).toString()));
                        b.end();
                    }
                    b.statement("sp += 1");
                    break;
                }
                case LOAD_NULL: {
                    b.startStatement();
                    BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp");
                    b.string("null");
                    b.end();
                    b.end();
                    b.statement("sp += 1");
                    break;
                }
                case LOAD_EXCEPTION: {
                    InstructionModel.InstructionImmediate exceptionSp = instr.getImmediate(InstructionModel.ImmediateKind.STACK_POINTER);
                    b.startStatement();
                    BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp");
                    BytecodeRootNodeElement.startGetFrameUnsafe(b, "frame", BytecodeRootNodeElement.this.type(Object.class)).startGroup().string("$root.maxLocals + ").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", exceptionSp)).end(2);
                    b.end();
                    b.end();
                    b.statement("sp += 1");
                    break;
                }
                case POP: {
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoPop(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame");
                        b.string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                    } else {
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.startStatement();
                        b.startCall(this.lookupDoSpecializePop(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame");
                        b.string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                    }
                    b.statement("sp -= 1");
                    break;
                }
                case DUP: {
                    b.statement(BytecodeRootNodeElement.copyFrameSlot("sp - 1", "sp"));
                    b.statement("sp += 1");
                    break;
                }
                case RETURN: {
                    this.storeBciInFrameIfNecessary(b);
                    this.emitBeforeReturnProfiling(b);
                    if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("afterRootExecute")) {
                        b.startStatement();
                        b.startCall("$root.afterRootExecute");
                        BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                        BytecodeRootNodeElement.startGetFrameUnsafe(b, "frame", BytecodeRootNodeElement.this.type(Object.class)).string("(sp - 1)");
                        b.end();
                        b.string("null");
                        b.end();
                        b.end();
                    }
                    BytecodeNodeElement.emitReturnTopOfStack(b);
                    break;
                }
                case LOAD_LOCAL: {
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoLoadLocal(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        if (this.localAccessNeedsLocalTags(instr)) {
                            b.string("localTags");
                        }
                        b.end();
                        b.end();
                    } else {
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.startStatement();
                        b.startCall(this.lookupDoSpecializeLoadLocal(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        if (this.localAccessNeedsLocalTags(instr)) {
                            b.string("localTags");
                        }
                        b.end();
                        b.end();
                    }
                    b.statement("sp += 1");
                    break;
                }
                case LOAD_LOCAL_MATERIALIZED: {
                    String materializedFrame = "((VirtualFrame) " + BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 1)");
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoLoadLocal(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame").string(materializedFrame).string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                        break;
                    }
                    b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                    b.startStatement();
                    b.startCall(this.lookupDoSpecializeLoadLocal(instr).getSimpleName().toString());
                    if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                        b.string("this");
                    }
                    b.string("frame").string(materializedFrame).string("bc").string("bci").string("sp");
                    b.end();
                    b.end();
                    break;
                }
                case STORE_LOCAL: {
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoStoreLocal(instr).getSimpleName().toString());
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        if (this.localAccessNeedsLocalTags(instr)) {
                            b.string("localTags");
                        }
                        b.end();
                        b.end();
                    } else {
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.startStatement();
                        b.startCall(this.lookupDoSpecializeStoreLocal(instr).getSimpleName().toString());
                        b.string("frame");
                        if (BytecodeRootNodeElement.this.model.enableYield) {
                            b.string("localFrame");
                        }
                        b.string("bc").string("bci").string("sp");
                        BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp - 1").end();
                        if (this.localAccessNeedsLocalTags(instr)) {
                            b.string("localTags");
                        }
                        b.end();
                        b.end();
                    }
                    b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
                    b.statement("sp -= 1");
                    break;
                }
                case STORE_LOCAL_MATERIALIZED: {
                    String materializedFrame = "((VirtualFrame) " + BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 2)");
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoStoreLocal(instr).getSimpleName().toString());
                        b.string("frame").string(materializedFrame).string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                    } else {
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.startStatement();
                        b.startCall(this.lookupDoSpecializeStoreLocal(instr).getSimpleName().toString());
                        b.string("frame").string(materializedFrame).string("bc").string("bci").string("sp");
                        BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string(BytecodeRootNodeElement.this.localFrame()).string("sp - 1").end();
                        b.end();
                        b.end();
                    }
                    b.statement("sp -= 2");
                    break;
                }
                case MERGE_CONDITIONAL: {
                    if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        throw new AssertionError((Object)"Merge.conditional only supports boxing elimination enabled.");
                    }
                    if (instr.isQuickening() || this.tier.isUncached() || !BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.startStatement();
                        b.startCall(this.lookupDoMergeConditional(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame").string("bc").string("bci").string("sp");
                        b.end();
                        b.end();
                    } else {
                        b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                        b.startStatement();
                        b.startCall(this.lookupDoSpecializeMergeConditional(instr).getSimpleName().toString());
                        if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                            b.string("this");
                        }
                        b.string("frame").string("bc").string("bci").string("sp");
                        BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp - 1").end();
                        b.end();
                        b.end();
                    }
                    b.statement("sp -= 1");
                    break;
                }
                case THROW: {
                    b.statement("throw sneakyThrow((Throwable) " + BytecodeRootNodeElement.uncheckedGetFrameObject("frame", "sp - 1") + ")");
                    break;
                }
                case YIELD: {
                    this.storeBciInFrameIfNecessary(b);
                    this.emitBeforeReturnProfiling(b);
                    if (BytecodeRootNodeElement.this.model.overridesBytecodeDebugListenerMethod("afterRootExecute")) {
                        b.startStatement();
                        b.startCall("$root.afterRootExecute");
                        BytecodeRootNodeElement.this.emitParseInstruction(b, "this", "bci", CodeTreeBuilder.singleString("op"));
                        BytecodeRootNodeElement.startGetFrameUnsafe(b, "frame", BytecodeRootNodeElement.this.type(Object.class)).string("(sp - 1)");
                        b.end();
                        b.string("null");
                        b.end();
                        b.end();
                    }
                    b.startStatement();
                    b.startCall(this.lookupYield(instr).getSimpleName().toString());
                    b.string("frame");
                    if (BytecodeRootNodeElement.this.model.enableYield) {
                        b.string("localFrame");
                    }
                    b.string("bc").string("bci").string("sp").string("$root").string("consts");
                    b.end();
                    b.end();
                    BytecodeNodeElement.emitReturnTopOfStack(b);
                    break;
                }
                case STORE_NULL: {
                    b.statement(BytecodeRootNodeElement.setFrameObject("sp", "null"));
                    b.statement("sp += 1");
                    break;
                }
                case CLEAR_LOCAL: {
                    String index = BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.FRAME_INDEX)).toString();
                    if (BytecodeRootNodeElement.this.model.defaultLocalValueExpression != null) {
                        b.statement(BytecodeRootNodeElement.setFrameObject("frame", index, "DEFAULT_LOCAL_VALUE"));
                        break;
                    }
                    b.statement(BytecodeRootNodeElement.clearFrame("frame", index));
                    break;
                }
                case LOAD_VARIADIC: {
                    int effect = -instr.variadicPopCount + 1;
                    b.startStatement();
                    if (instr.variadicPopCount == 0) {
                        b.string(BytecodeRootNodeElement.setFrameObject("sp", BytecodeRootNodeElement.this.emptyObjectArray.getSimpleName().toString()));
                    } else {
                        b.string(BytecodeRootNodeElement.setFrameObject("sp - " + instr.variadicPopCount, "readVariadic(frame, sp, " + instr.variadicPopCount + ")"));
                    }
                    b.end();
                    if (effect == 0) break;
                    if (effect > 0) {
                        b.statement("sp += " + effect);
                        break;
                    }
                    b.statement("sp -= " + -effect);
                    break;
                }
                case MERGE_VARIADIC: {
                    b.statement(BytecodeRootNodeElement.setFrameObject("sp - 1", "mergeVariadic((Object[]) " + BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 1") + ")"));
                    break;
                }
                case CUSTOM: {
                    if (this.tier.isUncached() && instr.operation.customModel.forcesCached()) {
                        throw new AssertionError((Object)"forceCached instructions should be emitted separately");
                    }
                    this.buildCustomInstructionExecute(b, instr);
                    this.emitCustomStackEffect(b, BytecodeNodeElement.getStackEffect(instr));
                    break;
                }
                case SUPERINSTRUCTION: {
                    break;
                }
                case INVALIDATE: {
                    this.emitInvalidate(b);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not implemented: " + String.valueOf((Object)instr.kind));
                }
            }
            if (!instr.isControlFlow()) {
                b.statement("bci += " + instr.getInstructionLength());
                b.statement("break");
            }
            b.end();
        }

        private List<List<InstructionModel>> partitionInstructions(List<InstructionModel> originalInstructions) {
            int instructionCount = originalInstructions.size();
            int estimatedSize = 2000 + instructionCount * 34;
            if (estimatedSize > 8000) {
                ArrayList<InstructionModel> topLevelInstructions = new ArrayList<InstructionModel>();
                ArrayList<InstructionModel> partitionableInstructions = new ArrayList<InstructionModel>();
                for (InstructionModel instruction : originalInstructions) {
                    if (instruction.kind != InstructionModel.InstructionKind.CUSTOM || BytecodeNodeElement.isForceCached(this.tier, instruction)) {
                        topLevelInstructions.add(instruction);
                        continue;
                    }
                    partitionableInstructions.add(instruction);
                }
                int groupCount = (int)partitionableInstructions.stream().map(InstructionGroup::new).distinct().count();
                int instructionsPerPartition = 444;
                int spaceUsedForBuiltins = 2000 + 34 * topLevelInstructions.size();
                int spaceUsedForDispatching = 20 * groupCount;
                int spaceLeftForCustom = Math.max(0, 8000 - spaceUsedForBuiltins - spaceUsedForDispatching);
                int customInstructionsInTopLevelPartition = spaceLeftForCustom / 34;
                topLevelInstructions.addAll(partitionableInstructions.subList(0, Math.min(partitionableInstructions.size(), customInstructionsInTopLevelPartition)));
                List instructionsToPartition = partitionableInstructions.subList(customInstructionsInTopLevelPartition, partitionableInstructions.size());
                ArrayList<List<InstructionModel>> partitions = new ArrayList<List<InstructionModel>>();
                partitions.add(topLevelInstructions);
                for (int i = 0; i < instructionsToPartition.size(); i += instructionsPerPartition) {
                    partitions.add(instructionsToPartition.subList(i, Math.min(i + instructionsPerPartition, instructionsToPartition.size())));
                }
                return partitions;
            }
            return List.of(originalInstructions);
        }

        private static boolean isForceCached(InterpreterTier tier, InstructionModel instruction) {
            return tier.isUncached() && instruction.kind == InstructionModel.InstructionKind.CUSTOM && instruction.operation.customModel.forcesCached();
        }

        private static boolean isInstructionReachable(InstructionModel model) {
            return !model.isEpilogExceptional();
        }

        private void emitInvalidate(CodeTreeBuilder b) {
            if (this.tier.isCached()) {
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            }
            b.startReturn().string(BytecodeRootNodeElement.this.encodeState("bci", "sp")).end();
        }

        private CodeExecutableElement createResolveControlFlowException() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Long.TYPE), "resolveControlFlowException", new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.types.ControlFlowException, "cfe"));
            method.getThrownTypes().add(BytecodeRootNodeElement.this.type(Throwable.class));
            CodeTreeBuilder b = method.createBuilder();
            b.startAssign("Object result").startCall("$root", BytecodeRootNodeElement.this.model.interceptControlFlowException).string("cfe").string("frame").string("this").string("bci").end(2);
            b.statement(BytecodeRootNodeElement.setFrameObject("$root.maxLocals", "result"));
            b.startDeclaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp").string("$root.maxLocals + 1").end();
            BytecodeNodeElement.emitReturnTopOfStack(b);
            return method;
        }

        private CodeExecutableElement createResolveThrowable() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Throwable.class), "resolveThrowable", new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Throwable.class), "throwable"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_InliningCutoff));
            CodeTreeBuilder b = method.createBuilder();
            if (BytecodeRootNodeElement.this.model.interceptTruffleException == null) {
                b.startIf().startGroup().string("throwable instanceof ").type(BytecodeRootNodeElement.this.types.AbstractTruffleException).string(" ate").end(2).startBlock();
                b.startReturn().string("ate").end();
                b.end();
            } else {
                b.declaration(BytecodeRootNodeElement.this.types.AbstractTruffleException, "ex");
                b.startIf().startGroup().string("throwable instanceof ").type(BytecodeRootNodeElement.this.types.AbstractTruffleException).string(" ate").end(2).startBlock();
                b.startAssign("ex").string("ate").end();
                b.end();
            }
            b.startElseIf().startGroup().string("throwable instanceof ").type(BytecodeRootNodeElement.this.types.ControlFlowException).string(" cfe").end(2).startBlock();
            b.startThrow().string("cfe").end();
            b.end();
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startElseIf().startGroup().string("throwable instanceof ").type(BytecodeRootNodeElement.this.type(ThreadDeath.class)).string(" cfe").end(2).startBlock();
                b.startReturn().string("cfe").end();
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.interceptInternalException == null) {
                b.startElseBlock();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startThrow().string("sneakyThrow(throwable)").end();
                b.end();
            } else {
                b.startElseBlock();
                b.startTryBlock();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                if (BytecodeRootNodeElement.this.model.interceptInternalException != null) {
                    b.startAssign("throwable").startCall("$root", BytecodeRootNodeElement.this.model.interceptInternalException).string("throwable").string("frame").string("this").string("bci").end(2);
                }
                b.startThrow().startCall("sneakyThrow").string("throwable").end(2);
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.AbstractTruffleException, "ate");
                if (BytecodeRootNodeElement.this.model.interceptTruffleException == null) {
                    b.startReturn().string("ate").end();
                } else {
                    b.startAssign("ex").string("ate").end();
                }
                b.end();
                b.end();
            }
            if (BytecodeRootNodeElement.this.model.interceptTruffleException != null) {
                b.startReturn().startCall("$root", BytecodeRootNodeElement.this.model.interceptTruffleException).string("ex").string("frame").string("this").string("bci").end(2);
            }
            return method;
        }

        private CodeExecutableElement createResolveHandler() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Integer.TYPE), "resolveHandler", new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "handler"), new CodeVariableElement(BytecodeRootNodeElement.this.type(int[].class), "localHandlers"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.ExplodeLoop));
            if (!this.tier.isCached()) {
                method.getModifiers().add(Modifier.STATIC);
            }
            CodeTreeBuilder b = method.createBuilder();
            if (this.tier.isCached()) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "handlerEntryIndex", "Math.floorDiv(handler, EXCEPTION_HANDLER_LENGTH)");
            }
            if (this.tier.isCached()) {
                b.startFor().string("int i = handler; i < localHandlers.length; i += EXCEPTION_HANDLER_LENGTH, handlerEntryIndex++").end().startBlock();
            } else {
                b.startFor().string("int i = handler; i < localHandlers.length; i += EXCEPTION_HANDLER_LENGTH").end().startBlock();
            }
            b.startIf().string("localHandlers[i + EXCEPTION_HANDLER_OFFSET_START_BCI] > bci").end().startBlock().statement("continue").end();
            b.startIf().string("localHandlers[i + EXCEPTION_HANDLER_OFFSET_END_BCI] <= bci").end().startBlock().statement("continue").end();
            if (this.tier.isCached()) {
                b.startIf().string("!this.exceptionProfiles_[handlerEntryIndex]").end().startBlock();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.statement("this.exceptionProfiles_[handlerEntryIndex] = true");
                b.end();
            }
            b.statement("return i");
            b.end();
            b.statement("return -1");
            return method;
        }

        private Collection<List<InstructionModel>> groupInstructionsByKindAndImmediates(InstructionModel.InstructionKind ... kinds) {
            return BytecodeRootNodeElement.this.model.getInstructions().stream().filter(i -> {
                for (InstructionModel.InstructionKind kind : kinds) {
                    if (i.kind != kind) continue;
                    return true;
                }
                return false;
            }).collect(BytecodeRootNodeElement.deterministicGroupingBy(i -> i.getImmediates())).values();
        }

        private CodeExecutableElement createDoEpilogExceptional() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), "doEpilogExceptional", new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.AbstractTruffleException, "exception"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeId"));
            CodeTreeBuilder b = method.createBuilder();
            GeneratedTypeMirror cachedType = this.getCachedDataClassType(BytecodeRootNodeElement.this.model.epilogExceptional.operation.instruction);
            if (this.tier.isCached()) {
                b.declaration((TypeMirror)cachedType, "node", "this.epilogExceptionalNode_");
            }
            List<CodeVariableElement> extraParams = this.createExtraParameters(false);
            this.buildCallExecute(b, BytecodeRootNodeElement.this.model.epilogExceptional.operation.instruction, "exception", extraParams);
            return method;
        }

        private CodeExecutableElement createDoTagExceptional() {
            CodeExecutableElement method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Object.class), "doTagExceptional", new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.tagNode.asType(), "node"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeId"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Throwable.class), "exception"));
            method.getThrownTypes().add(BytecodeRootNodeElement.this.type(Throwable.class));
            Collection<List<InstructionModel>> groupedInstructions = this.groupInstructionsByKindAndImmediates(InstructionModel.InstructionKind.TAG_LEAVE, InstructionModel.InstructionKind.TAG_LEAVE_VOID);
            CodeTreeBuilder b = method.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "wasOnReturnExecuted");
            b.startSwitch().string("readValidBytecode(bc, bci)").end().startBlock();
            for (List<InstructionModel> instructions : groupedInstructions) {
                for (InstructionModel instruction : instructions) {
                    b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(instruction)).end();
                }
                b.startCaseBlock();
                InstructionModel.InstructionImmediate immediate = BytecodeRootNodeElement.this.model.tagLeaveValueInstruction.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
                b.startAssign("wasOnReturnExecuted").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", immediate)).string(" == nodeId").end();
                b.statement("break");
                b.end();
            }
            b.caseDefault().startCaseBlock();
            b.statement("wasOnReturnExecuted = false");
            b.statement("break");
            b.end();
            b.end();
            b.statement("return node.findProbe().onReturnExceptionalOrUnwind(frame, exception, wasOnReturnExecuted)");
            return method;
        }

        private CodeExecutableElement lookupTagResume(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_InliningCutoff));
            CodeTreeBuilder b = method.createBuilder();
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onResume(frame)");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupTagYield(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_InliningCutoff));
            CodeTreeBuilder b = method.createBuilder();
            b.startDeclaration(BytecodeRootNodeElement.this.type(Object.class), "returnValue");
            BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class));
            b.string("frame");
            b.string("sp - 1");
            b.end();
            b.end();
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onYield(frame, returnValue)");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupBranchBackward(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Long.TYPE), this.instructionMethodName(instr), new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            CodeTreeBuilder b = method.createBuilder();
            b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inInterpreter").end(1).string(" && ").startStaticCall(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "pollOSRBackEdge").string("this").end(2).startBlock();
            InstructionModel.InstructionImmediate branchProfile = BytecodeRootNodeElement.this.model.branchBackwardInstruction.findImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE, "loop_header_branch_profile");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "branchProfileIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", branchProfile));
            b.startStatement().startCall("ensureFalseProfile").string("branchProfiles_").string("branchProfileIndex").end(2);
            b.startAssign("Object osrResult");
            b.startStaticCall(BytecodeRootNodeElement.this.types.BytecodeOSRNode, "tryOSR");
            b.string("this");
            String bci = BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX)).toString();
            b.string(BytecodeRootNodeElement.this.encodeState(bci, "sp", BytecodeRootNodeElement.this.model.enableYield ? "frame != " + BytecodeRootNodeElement.this.localFrame() : null));
            b.string("null");
            b.string("null");
            b.string("frame");
            b.end(2);
            b.startIf().string("osrResult != null").end().startBlock();
            b.startReturn().cast(BytecodeRootNodeElement.this.type(Long.TYPE)).string("osrResult").end();
            b.end();
            b.end();
            b.statement("return -1");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupLoadArgument(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            InstructionModel.InstructionImmediate argIndex = instr.getImmediate(InstructionModel.ImmediateKind.SHORT);
            CodeTreeBuilder b = method.createBuilder();
            TypeMirror returnType = instr.signature.returnType;
            b.startTryBlock();
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, returnType).string("frame").string("sp");
            b.startGroup();
            b.startStaticCall(BytecodeRootNodeElement.this.lookupExpectMethod(BytecodeRootNodeElement.this.type(Object.class), returnType));
            b.string(BytecodeRootNodeElement.this.localFrame() + ".getArguments()[" + BytecodeRootNodeElement.readImmediate("bc", "bci", argIndex).toString() + "]");
            b.end();
            b.end();
            b.end();
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "e");
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            BytecodeRootNodeElement.this.emitQuickening(b, "this", "bc", "bci", null, b.create().tree(BytecodeRootNodeElement.this.createInstructionConstant(instr.getQuickeningRoot())).build());
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp");
            b.string("e.getResult()");
            b.end();
            b.end();
            b.end();
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupYield(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement[0]);
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.asType(), "$root"));
            method.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Object.class)), "consts"));
            CodeTreeBuilder b = method.createBuilder();
            InstructionModel.InstructionImmediate continuationIndex = instr.getImmediate(InstructionModel.ImmediateKind.CONSTANT);
            b.statement("int maxLocals = $root.maxLocals");
            b.statement(BytecodeRootNodeElement.copyFrameTo("frame", "maxLocals", "localFrame", "maxLocals", "(sp - 1 - maxLocals)"));
            b.startDeclaration(BytecodeRootNodeElement.this.continuationRootNodeImpl.asType(), "continuationRootNode");
            b.tree(BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", continuationIndex), BytecodeRootNodeElement.this.continuationRootNodeImpl.asType()));
            b.end();
            b.startDeclaration(BytecodeRootNodeElement.this.types.ContinuationResult, "continuationResult");
            b.startCall("continuationRootNode.createContinuation");
            b.string(BytecodeRootNodeElement.this.localFrame());
            b.string(BytecodeRootNodeElement.uncheckedGetFrameObject("sp - 1"));
            b.end(2);
            b.statement(BytecodeRootNodeElement.setFrameObject("sp - 1", "continuationResult"));
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupTagEnter(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_InliningCutoff));
            CodeTreeBuilder b = method.createBuilder();
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onEnter(frame)");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupTagLeaveVoid(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            method.addAnnotationMirror(new CodeAnnotationMirror(BytecodeRootNodeElement.this.types.HostCompilerDirectives_InliningCutoff));
            CodeTreeBuilder b = method.createBuilder();
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onReturnValue(frame, null)");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupTagLeave(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            CodeTreeBuilder b = method.createBuilder();
            TypeMirror inputType = instr.specializedType == null ? instr.signature.getSpecializedType(0) : instr.specializedType;
            TypeMirror returnType = instr.signature.returnType;
            boolean isSpecialized = instr.specializedType != null;
            b.declaration(inputType, "returnValue");
            if (isSpecialized) {
                b.startTryBlock();
            }
            b.startAssign("returnValue");
            if (isSpecialized) {
                BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", inputType);
            } else {
                BytecodeRootNodeElement.startRequireFrame(b, inputType);
                b.string("frame");
            }
            b.string("sp - 1");
            b.end();
            b.end();
            if (isSpecialized) {
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.startReturn().startCall(this.lookupSpecializeTagLeave(instr.getQuickeningRoot()).getSimpleName().toString());
                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                    b.string("$this");
                }
                b.string("frame").string("bc").string("bci").string("sp");
                b.end().end();
            }
            b.end();
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onReturnValue(frame, returnValue)");
            if (isSpecialized && !ElementUtils.typeEquals(inputType, returnType)) {
                b.startStatement();
                BytecodeRootNodeElement.startSetFrame(b, returnType).string("frame").string("sp - 1").string("returnValue").end();
                b.end();
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupSpecializeTagLeave(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(this.getSuperclass(), "$this"));
            }
            LinkedHashMap<TypeMirror, InstructionModel> typeToSpecialization = new LinkedHashMap<TypeMirror, InstructionModel>();
            List<InstructionModel> specializations = instr.quickenedInstructions;
            InstructionModel genericInstruction = null;
            for (InstructionModel specialization : specializations) {
                if (BytecodeRootNodeElement.this.model.isBoxingEliminated(specialization.specializedType)) {
                    typeToSpecialization.put(specialization.specializedType, specialization);
                    continue;
                }
                if (specialization.specializedType != null) continue;
                genericInstruction = specialization;
            }
            CodeTreeBuilder b = method.createBuilder();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "operandIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX)));
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "operand", BytecodeRootNodeElement.readInstruction("bc", "operandIndex"));
            b.startStatement();
            b.type(BytecodeRootNodeElement.this.type(Object.class)).string(" value = ");
            BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp - 1").end();
            b.end();
            boolean elseIf = false;
            for (Map.Entry entry : typeToSpecialization.entrySet()) {
                TypeMirror typeGroup = (TypeMirror)entry.getKey();
                elseIf = b.startIf(elseIf);
                b.string("value instanceof ").type(ElementUtils.boxType(typeGroup)).string(" && ");
                b.newLine().string("     (newOperand = ").startCall(BytecodeRootNodeElement.createApplyQuickeningName(typeGroup)).string("operand").end().string(") != -1");
                b.end().startBlock();
                InstructionModel specialization = (InstructionModel)entry.getValue();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(specialization)).end();
                b.end();
                b.end();
            }
            b.startElseBlock(elseIf);
            b.statement("newOperand = undoQuickening(operand)");
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "$this", "bc", "bci", null, 0, "operandIndex", "operand", "newOperand");
            BytecodeRootNodeElement.this.emitQuickening(b, "$this", "bc", "bci", null, "newInstruction");
            InstructionModel.InstructionImmediate imm = instr.getImmediate(InstructionModel.ImmediateKind.TAG_NODE);
            b.startDeclaration(BytecodeRootNodeElement.this.tagNode.asType(), "tagNode");
            b.tree(BytecodeRootNodeElement.readTagNode(BytecodeRootNodeElement.this.tagNode.asType(), BytecodeRootNodeElement.readImmediate("bc", "bci", imm)));
            b.end();
            b.statement("tagNode.findProbe().onReturnValue(frame, value)");
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoPop(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            CodeTreeBuilder b = method.createBuilder();
            TypeMirror inputType = instr.signature.getSpecializedType(0);
            boolean isGeneric = ElementUtils.isObject(inputType);
            if (!isGeneric) {
                b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inCompiledCode").end().end().startBlock();
                b.lineComment("Always clear in compiled code for liveness analysis");
                b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
                b.returnDefault();
                b.end();
                b.startIf().string("frame.getTag(sp - 1) != ").staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(inputType)).end().startBlock();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startStatement().startCall(this.lookupDoSpecializeBranch(instr.getQuickeningRoot()).getSimpleName().toString());
                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                    b.string("$this");
                }
                b.string("frame").string("bc").string("bci").string("sp");
                b.end().end();
                b.returnDefault();
                b.end();
            }
            if (isGeneric) {
                b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
            } else {
                b.lineComment("No need to clear for primitives in the interpreter");
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoSpecializePop(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(this.getSuperclass(), "$this"));
            }
            LinkedHashMap<TypeMirror, InstructionModel> typeToSpecialization = new LinkedHashMap<TypeMirror, InstructionModel>();
            List<InstructionModel> specializations = instr.quickenedInstructions;
            InstructionModel genericInstruction = null;
            for (InstructionModel specialization : specializations) {
                if (BytecodeRootNodeElement.this.model.isBoxingEliminated(specialization.specializedType)) {
                    typeToSpecialization.put(specialization.specializedType, specialization);
                    continue;
                }
                if (specialization.specializedType != null) continue;
                genericInstruction = specialization;
            }
            CodeTreeBuilder b = method.createBuilder();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "operandIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX)));
            b.startIf().string("operandIndex != -1").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "operand", BytecodeRootNodeElement.readInstruction("bc", "operandIndex"));
            b.startStatement();
            b.type(BytecodeRootNodeElement.this.type(Object.class)).string(" value = ");
            BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp - 1").end();
            b.end();
            boolean elseIf = false;
            for (Map.Entry entry : typeToSpecialization.entrySet()) {
                TypeMirror typeGroup = (TypeMirror)entry.getKey();
                elseIf = b.startIf(elseIf);
                b.string("value instanceof ").type(ElementUtils.boxType(typeGroup)).string(" && ");
                b.newLine().string("     (newOperand = ").startCall(BytecodeRootNodeElement.createApplyQuickeningName(typeGroup)).string("operand").end().string(") != -1");
                b.end().startBlock();
                InstructionModel specialization = (InstructionModel)entry.getValue();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(specialization)).end();
                b.end();
            }
            b.startElseBlock(elseIf);
            b.statement("newOperand = undoQuickening(operand)");
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "$this", "bc", "bci", null, 0, "operandIndex", "operand", "newOperand");
            b.end();
            b.startElseBlock();
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickening(b, "$this", "bc", "bci", null, "newInstruction");
            b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoBranch(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Boolean.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            CodeTreeBuilder b = method.createBuilder();
            TypeMirror inputType = instr.signature.getSpecializedType(0);
            b.startTryBlock();
            b.startReturn();
            if (ElementUtils.isObject(inputType)) {
                b.string("(boolean) ");
            }
            BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", inputType);
            b.string("sp - 1");
            b.end();
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
            b.startReturn().startCall(this.lookupDoSpecializeBranch(instr.getQuickeningRoot()).getSimpleName().toString());
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                b.string("$this");
            }
            b.string("frame").string("bc").string("bci").string("sp");
            b.end().end();
            b.end();
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoSpecializeBranch(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Boolean.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            TypeMirror boxingType = BytecodeRootNodeElement.this.type(Boolean.TYPE);
            if (instr.quickenedInstructions.size() != 2) {
                throw new AssertionError((Object)"Unexpected quickening count");
            }
            InstructionModel boxedInstruction = null;
            InstructionModel unboxedInstruction = null;
            for (InstructionModel quickening : instr.getFlattenedQuickenedInstructions()) {
                if (ElementUtils.isObject(quickening.signature.getSpecializedType(0))) {
                    boxedInstruction = quickening;
                    continue;
                }
                unboxedInstruction = quickening;
            }
            if (boxedInstruction == null || unboxedInstruction == null) {
                throw new AssertionError((Object)"Unexpected quickenings");
            }
            CodeTreeBuilder b = method.createBuilder();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.startStatement().string("boolean value = (boolean)");
            BytecodeRootNodeElement.startRequireFrame(b, BytecodeRootNodeElement.this.type(Object.class));
            b.string("frame").string("sp - 1");
            b.end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "operandIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.findImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "child0")));
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "operand", BytecodeRootNodeElement.readInstruction("bc", "operandIndex"));
            b.startIf().string("(newOperand = ").startCall(BytecodeRootNodeElement.createApplyQuickeningName(boxingType)).string("operand").end().string(") != -1").end().startBlock();
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(unboxedInstruction)).end();
            BytecodeRootNodeElement.this.emitOnSpecialize(b, "$this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "BranchFalse$" + unboxedInstruction.getQuickeningName());
            b.end().startElseBlock();
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction)).end();
            b.startStatement().string("newOperand = operand").end();
            BytecodeRootNodeElement.this.emitOnSpecialize(b, "$this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "BranchFalse$" + boxedInstruction.getQuickeningName());
            b.end();
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "$this", "bc", "bci", null, 0, "operandIndex", "operand", "newOperand");
            BytecodeRootNodeElement.this.emitQuickening(b, "$this", "bc", "bci", null, "newInstruction");
            b.startReturn().string("value").end();
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private boolean localAccessNeedsStackFrame(InstructionModel instr) {
            if (!instr.kind.isLocalVariableAccess() && !instr.kind.isLocalVariableMaterializedAccess()) {
                throw new AssertionError();
            }
            return instr.kind.isLocalVariableMaterializedAccess() || BytecodeRootNodeElement.this.model.enableYield;
        }

        private boolean localAccessNeedsLocalTags(InstructionModel instr) {
            return !instr.kind.isLocalVariableMaterializedAccess() && BytecodeRootNodeElement.this.model.usesBoxingElimination() && this.tier.isCached();
        }

        private CodeExecutableElement lookupDoLoadLocal(InstructionModel instr) {
            boolean generic;
            boolean needsLocalTags;
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            boolean materialized = instr.kind.isLocalVariableMaterializedAccess();
            boolean needsStackFrame = this.localAccessNeedsStackFrame(instr);
            if (needsStackFrame) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "stackFrame"));
            }
            if (needsLocalTags = this.localAccessNeedsLocalTags(instr)) {
                method.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            }
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            TypeMirror inputType = instr.signature.returnType;
            TypeMirror slotType = instr.specializedType != null ? instr.specializedType : BytecodeRootNodeElement.this.type(Object.class);
            CodeTreeBuilder b = method.createBuilder();
            CodeTree readSlot = BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.FRAME_INDEX));
            if (materialized) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "slot", readSlot);
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localRootIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT)));
                if (instr.hasImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)));
                }
                this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", null, "localIndex");
                readSlot = CodeTreeBuilder.singleString("slot");
            }
            if (!(generic = ElementUtils.typeEquals(BytecodeRootNodeElement.this.type(Object.class), slotType))) {
                b.startTryBlock();
            }
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, inputType).string(needsStackFrame ? "stackFrame" : "frame");
            if (materialized) {
                b.string("sp - 1");
            } else {
                b.string("sp");
            }
            if (generic) {
                BytecodeRootNodeElement.startRequireFrame(b, slotType).string("frame").tree(readSlot).end();
            } else {
                BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", slotType).tree(readSlot).end();
            }
            b.end();
            b.end();
            if (!generic) {
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    method.getModifiers().remove((Object)Modifier.STATIC);
                }
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.startStatement().startCall(this.lookupDoSpecializeLoadLocal(instr.getQuickeningRoot()).getSimpleName().toString());
                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                    b.string("$this");
                }
                if (needsStackFrame) {
                    b.string("stackFrame");
                }
                b.string("frame").string("bc").string("bci").string("sp");
                if (needsLocalTags) {
                    b.string("localTags");
                }
                b.end().end();
                b.end();
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoSpecializeLoadLocal(InstructionModel instr) {
            String bytecodeNode;
            String localIndex;
            boolean needsLocalTags;
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            boolean materialized = instr.kind.isLocalVariableMaterializedAccess();
            boolean needsStackFrame = this.localAccessNeedsStackFrame(instr);
            if (needsStackFrame) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "stackFrame"));
            }
            if (needsLocalTags = this.localAccessNeedsLocalTags(instr)) {
                method.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            }
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            CodeTreeBuilder b = method.createBuilder();
            String stackFrame = needsStackFrame ? "stackFrame" : "frame";
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "slot", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.FRAME_INDEX)));
            if (materialized) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localRootIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT)));
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)));
                localIndex = "localIndex";
            } else {
                localIndex = "slot - USER_LOCALS_START_INDEX";
            }
            if (materialized) {
                this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", "bytecodeNode", "localIndex");
                bytecodeNode = "bytecodeNode";
            } else {
                bytecodeNode = "this";
            }
            b.startDeclaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag");
            b.startCall(bytecodeNode, "getCachedLocalTagInternal");
            if (materialized) {
                b.startCall(bytecodeNode, "getLocalTags").end();
            } else {
                b.string("localTags");
            }
            b.string(localIndex);
            b.end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Object.class), "value");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            InstructionModel genericInstruction = instr.findGenericInstruction();
            b.startTryBlock();
            b.startSwitch().string("tag").end().startBlock();
            for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                InstructionModel boxedInstruction = instr.findSpecializedInstruction(boxingType);
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                b.startCaseBlock();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction)).end();
                BytecodeRootNodeElement.this.emitOnSpecialize(b, "$this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "LoadLocal$" + boxedInstruction.getQuickeningName());
                b.startStatement();
                b.string("value = ");
                BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", boxingType).string("slot").end();
                b.end();
                b.statement("break");
                b.end();
            }
            b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
            b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getIllegal()).end();
            b.startCaseBlock();
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            BytecodeRootNodeElement.this.emitOnSpecialize(b, "$this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "LoadLocal$" + genericInstruction.getQuickeningName());
            b.startStatement();
            b.string("value = ");
            BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", BytecodeRootNodeElement.this.type(Object.class)).string("slot").end();
            b.end();
            b.statement("break");
            b.end();
            b.caseDefault().startCaseBlock();
            b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected frame tag."));
            b.end();
            b.end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            BytecodeRootNodeElement.this.emitOnSpecialize(b, "$this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "LoadLocal$" + genericInstruction.getQuickeningName());
            b.startStatement();
            b.string("value = ex.getResult()");
            b.end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickening(b, "$this", "bc", "bci", null, "newInstruction");
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string(stackFrame);
            if (materialized) {
                b.string("sp - 1");
            } else {
                b.string("sp");
            }
            b.string("value").end();
            b.end();
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoMergeConditional(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            TypeMirror inputType = instr.signature.getSpecializedType(1);
            TypeMirror returnType = instr.signature.returnType;
            CodeTreeBuilder b = method.createBuilder();
            if (this.tier.isCached() && BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.declaration(inputType, "value");
                b.startTryBlock();
                b.startStatement();
                b.string("value = ");
                BytecodeRootNodeElement.startExpectFrameUnsafe(b, "frame", inputType).string("sp - 1").end();
                b.end();
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.startStatement().startCall(this.lookupDoSpecializeMergeConditional(instr.getQuickeningRoot()).getSimpleName().toString());
                if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                    b.string("$this");
                }
                b.string("frame").string("bc").string("bci").string("sp").string("ex.getResult()");
                b.end().end();
                b.returnDefault();
                b.end();
            } else {
                b.startDeclaration(inputType, "value");
                BytecodeRootNodeElement.startRequireFrame(b, inputType).string("frame").string("sp - 1").end();
                b.end();
            }
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, returnType).string("frame").string("sp - 2").string("value").end();
            b.end();
            if (!ElementUtils.isPrimitive(inputType)) {
                b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoSpecializeMergeConditional(InstructionModel instr) {
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "local"));
            if (BytecodeRootNodeElement.this.model.bytecodeDebugListener) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "$this"));
            }
            CodeTreeBuilder b = method.createBuilder();
            InstructionModel.InstructionImmediate operand0 = instr.getImmediates(InstructionModel.ImmediateKind.BYTECODE_INDEX).get(0);
            InstructionModel.InstructionImmediate operand1 = instr.getImmediates(InstructionModel.ImmediateKind.BYTECODE_INDEX).get(1);
            b.startDeclaration(BytecodeRootNodeElement.this.type(Boolean.TYPE), "condition");
            b.cast(BytecodeRootNodeElement.this.type(Boolean.TYPE));
            BytecodeRootNodeElement.startGetFrameUnsafe(b, "frame", null).string("sp - 2");
            b.end().end();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOtherOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "operandIndex");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "otherOperandIndex");
            b.startIf().string("condition").end().startBlock();
            b.startAssign("operandIndex").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", operand0)).end();
            b.startAssign("otherOperandIndex").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", operand1)).end();
            b.end().startElseBlock();
            b.startAssign("operandIndex").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", operand1)).end();
            b.startAssign("otherOperandIndex").tree(BytecodeRootNodeElement.readImmediate("bc", "bci", operand0)).end();
            b.end();
            b.startIf().string("operandIndex != -1 && otherOperandIndex != -1").end().startBlock();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "operand", BytecodeRootNodeElement.readInstruction("bc", "operandIndex"));
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "otherOperand", BytecodeRootNodeElement.readInstruction("bc", "otherOperandIndex"));
            InstructionModel genericInstruction = instr.findGenericInstruction();
            boolean elseIf = false;
            for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                elseIf = b.startIf(elseIf);
                b.string("local").instanceOf(ElementUtils.boxType(boxingType));
                b.newLine().string("   && (");
                b.string("(newOperand = ").startCall(BytecodeRootNodeElement.createApplyQuickeningName(boxingType)).string("operand").end().string(") != -1)");
                b.end().startBlock();
                InstructionModel boxedInstruction = instr.findSpecializedInstruction(boxingType);
                InstructionModel unboxedInstruction = boxedInstruction.quickenedInstructions.get(0);
                b.startSwitch().tree(BytecodeRootNodeElement.readInstruction("bc", "bci")).end().startBlock();
                b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction.getQuickeningRoot())).end();
                b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction)).end();
                b.startCaseBlock();
                b.statement("newOtherOperand = otherOperand");
                b.startAssign("newInstruction").tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction)).end();
                b.statement("break");
                b.end();
                b.startCase().tree(BytecodeRootNodeElement.this.createInstructionConstant(unboxedInstruction)).end();
                b.startCaseBlock();
                b.statement("newOtherOperand = otherOperand");
                b.startAssign("newInstruction").tree(BytecodeRootNodeElement.this.createInstructionConstant(unboxedInstruction)).end();
                b.statement("break");
                b.end();
                b.caseDefault();
                b.startCaseBlock();
                b.statement("newOtherOperand = undoQuickening(otherOperand)");
                b.startAssign("newInstruction").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
                b.statement("break");
                b.end();
                b.end();
                b.end();
            }
            b.startElseBlock(elseIf);
            b.statement("newOperand = operand");
            b.statement("newOtherOperand = undoQuickening(otherOperand)");
            b.startAssign("newInstruction").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "$this", "bc", "bci", null, 0, "operandIndex", "operand", "newOperand");
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "$this", "bc", "bci", null, 0, "otherOperandIndex", "otherOperand", "newOtherOperand");
            b.end();
            b.startElseBlock();
            b.startAssign("newInstruction").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.end();
            BytecodeRootNodeElement.this.emitQuickening(b, "$this", "bc", "bci", null, "newInstruction");
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("sp - 2").string("local").end();
            b.end();
            b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - 1"));
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoStoreLocal(InstructionModel instr) {
            String stackFrame;
            boolean needsLocalTags;
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            boolean materialized = instr.kind.isLocalVariableMaterializedAccess();
            boolean needsStackFrame = this.localAccessNeedsStackFrame(instr);
            if (needsStackFrame) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "stackFrame"));
            }
            if (needsLocalTags = this.localAccessNeedsLocalTags(instr)) {
                method.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            }
            TypeMirror inputType = instr.signature.getSpecializedType(0);
            TypeMirror slotType = instr.specializedType != null ? instr.specializedType : BytecodeRootNodeElement.this.type(Object.class);
            CodeTreeBuilder b = method.createBuilder();
            String string = stackFrame = needsStackFrame ? "stackFrame" : "frame";
            if (this.tier.isCached() && BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.declaration(inputType, "local");
                b.startTryBlock();
                b.startStatement().string("local = ");
                BytecodeRootNodeElement.startExpectFrameUnsafe(b, stackFrame, inputType).string("sp - 1").end();
                b.end();
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.startStatement().startCall(this.lookupDoSpecializeStoreLocal(instr.getQuickeningRoot()).getSimpleName().toString());
                if (needsStackFrame) {
                    b.string("stackFrame");
                }
                b.string("frame").string("bc").string("bci").string("sp").string("ex.getResult()");
                if (needsLocalTags) {
                    b.string("localTags");
                }
                b.end().end();
                b.returnDefault();
                b.end();
            } else {
                b.startDeclaration(inputType, "local");
                BytecodeRootNodeElement.startRequireFrame(b, inputType).string(stackFrame).string("sp - 1").end();
                b.end();
            }
            boolean generic = ElementUtils.typeEquals(BytecodeRootNodeElement.this.type(Object.class), inputType);
            CodeTree readSlot = BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.FRAME_INDEX));
            if (generic && !ElementUtils.needsCastTo(inputType, slotType)) {
                if (materialized) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "slot", readSlot);
                    readSlot = CodeTreeBuilder.singleString("slot");
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localRootIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT)));
                    if (instr.hasImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)) {
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)));
                    }
                    if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                        b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localOffset", "slot - USER_LOCALS_START_INDEX");
                        this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", "bytecodeNode", "localIndex");
                        b.startStatement().startCall("bytecodeNode.setLocalValueInternal");
                        b.string("frame");
                        b.string("localOffset");
                        if (instr.hasImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)) {
                            b.string("localIndex");
                        } else {
                            b.string("localOffset");
                        }
                        b.string("local");
                        b.end(2);
                    } else {
                        this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", null, "localIndex");
                        b.startStatement();
                        BytecodeRootNodeElement.startSetFrame(b, slotType).string("frame").tree(readSlot);
                        b.string("local");
                        b.end();
                        b.end();
                    }
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 1"));
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 2"));
                } else {
                    b.startStatement();
                    BytecodeRootNodeElement.startSetFrame(b, slotType).string("frame").tree(readSlot);
                    b.string("local");
                    b.end();
                    b.end();
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 1"));
                }
            } else {
                String bytecodeNode;
                String localIndex;
                if (!BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                    throw new AssertionError((Object)"Unexpected path.");
                }
                boolean needsCast = ElementUtils.needsCastTo(inputType, slotType);
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "slot", readSlot);
                if (materialized) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localRootIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT)));
                }
                if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                    b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)));
                    localIndex = "localIndex";
                } else {
                    localIndex = "slot - USER_LOCALS_START_INDEX";
                }
                if (materialized) {
                    this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", "bytecodeNode", "localIndex");
                    bytecodeNode = "bytecodeNode";
                } else {
                    bytecodeNode = "this";
                }
                b.startDeclaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "tag");
                b.startCall(bytecodeNode, "getCachedLocalTagInternal");
                if (materialized) {
                    b.startCall(bytecodeNode, "getLocalTags").end();
                } else {
                    b.string("localTags");
                }
                b.string(localIndex);
                b.end();
                b.end();
                b.startIf().string("tag == ").staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(slotType));
                b.end().startBlock();
                if (needsCast) {
                    b.startTryBlock();
                }
                b.startStatement();
                BytecodeRootNodeElement.startSetFrame(b, slotType).string("frame").string("slot");
                if (needsCast) {
                    b.startStaticCall(BytecodeRootNodeElement.this.lookupExpectMethod(inputType, slotType));
                    b.string("local");
                    b.end();
                } else {
                    b.string("local");
                }
                b.end();
                b.end();
                if (materialized) {
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 1"));
                    b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inCompiledCode").end().end().startBlock();
                    b.lineComment("Clear primitive for compiler liveness analysis");
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 2"));
                    b.end();
                } else {
                    b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "inCompiledCode").end().end().startBlock();
                    b.lineComment("Clear primitive for compiler liveness analysis");
                    b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 1"));
                    b.end();
                }
                b.returnDefault();
                if (needsCast) {
                    b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                    b.statement("local = ex.getResult()");
                    b.lineComment("fall through to slow-path");
                    b.end();
                }
                b.end();
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                b.startStatement().startCall(this.lookupDoSpecializeStoreLocal(instr.getQuickeningRoot()).getSimpleName().toString());
                if (needsStackFrame) {
                    b.string("stackFrame");
                }
                b.string("frame").string("bc").string("bci").string("sp").string("local");
                if (needsLocalTags) {
                    b.string("localTags");
                }
                b.end().end();
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private CodeExecutableElement lookupDoSpecializeStoreLocal(InstructionModel instr) {
            String bytecodeNode;
            String localIndex;
            boolean needsLocalTags;
            CodeExecutableElement method = this.doInstructionMethods.get(instr);
            if (method != null) {
                return method;
            }
            method = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Void.TYPE), this.instructionMethodName(instr), new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "frame"), new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Object.class), "local"));
            boolean materialized = instr.kind.isLocalVariableMaterializedAccess();
            boolean needsStackFrame = this.localAccessNeedsStackFrame(instr);
            if (needsStackFrame) {
                method.getParameters().add(0, new CodeVariableElement(BytecodeRootNodeElement.this.types.Frame, "stackFrame"));
            }
            if (needsLocalTags = this.localAccessNeedsLocalTags(instr)) {
                method.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Byte.TYPE)), "localTags"));
            }
            String stackFrame = needsStackFrame ? "stackFrame" : "frame";
            CodeTreeBuilder b = method.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newInstruction");
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "slot", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.FRAME_INDEX)));
            if (materialized) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localRootIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT)));
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "localIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX)));
                localIndex = "localIndex";
            } else {
                localIndex = "slot - USER_LOCALS_START_INDEX";
            }
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "operandIndex", BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX)));
            if (materialized) {
                this.emitValidateMaterializedAccess(b, "localRootIndex", "localRoot", "bytecodeNode", "localIndex");
                bytecodeNode = "bytecodeNode";
            } else {
                bytecodeNode = "this";
            }
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "newOperand");
            b.declaration(BytecodeRootNodeElement.this.type(Short.TYPE), "operand", BytecodeRootNodeElement.readInstruction("bc", "operandIndex"));
            b.startDeclaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "oldTag");
            b.startCall(bytecodeNode, "getCachedLocalTagInternal");
            if (materialized) {
                b.startCall(bytecodeNode, "getLocalTags").end();
            } else {
                b.string("localTags");
            }
            b.string(localIndex);
            b.end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Byte.TYPE), "newTag");
            InstructionModel genericInstruction = instr.findGenericInstruction();
            boolean elseIf = false;
            for (TypeMirror boxingType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                elseIf = b.startIf(elseIf);
                b.string("local").instanceOf(ElementUtils.boxType(boxingType)).end().startBlock();
                InstructionModel boxedInstruction = instr.findSpecializedInstruction(boxingType);
                InstructionModel unboxedInstruction = boxedInstruction.quickenedInstructions.get(0);
                b.startSwitch().string("oldTag").end().startBlock();
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getIllegal()).end();
                b.startCaseBlock();
                b.startIf().string("(newOperand = ").startCall(BytecodeRootNodeElement.createApplyQuickeningName(boxingType)).string("operand").end().string(") != -1").end().startBlock();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(unboxedInstruction)).end();
                b.end().startElseBlock();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(boxedInstruction)).end();
                b.startStatement().string("newOperand = operand").end();
                b.end();
                String kindName = ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxingType));
                BytecodeRootNodeElement.this.emitOnSpecialize(b, "this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "StoreLocal$" + kindName);
                b.startStatement().string("newTag = ").staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(boxingType)).end();
                b.startStatement();
                BytecodeRootNodeElement.startSetFrame(b, boxingType).string("frame").string("slot").startGroup().cast(boxingType).string("local").end().end();
                b.end();
                b.statement("break");
                b.end();
                for (TypeMirror otherType : BytecodeRootNodeElement.this.model.boxingEliminatedTypes) {
                    if (ElementUtils.typeEquals(otherType, boxingType)) continue;
                    b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.get(otherType)).end();
                }
                b.startCase().staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                b.startCaseBlock();
                b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
                b.startStatement().string("newOperand = ").startCall("undoQuickening").string("operand").end().end();
                b.startStatement().string("newTag = ").staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
                BytecodeRootNodeElement.this.emitOnSpecialize(b, "this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "StoreLocal$" + genericInstruction.getQualifiedQuickeningName());
                b.startStatement();
                BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("slot").string("local").end();
                b.end();
                b.statement("break");
                b.end();
                b.caseDefault().startCaseBlock();
                b.tree(GeneratorUtils.createShouldNotReachHere("Unexpected frame tag."));
                b.end();
                b.end();
                b.end();
            }
            b.startElseBlock(elseIf);
            b.startStatement().string("newInstruction = ").tree(BytecodeRootNodeElement.this.createInstructionConstant(genericInstruction)).end();
            b.startStatement().string("newOperand = ").startCall("undoQuickening").string("operand").end().end();
            b.startStatement().string("newTag = ").staticReference(BytecodeRootNodeElement.this.frameTagsElement.getObject()).end();
            BytecodeRootNodeElement.this.emitOnSpecialize(b, "this", "bci", BytecodeRootNodeElement.readInstruction("bc", "bci"), "StoreLocal$" + genericInstruction.getQualifiedQuickeningName());
            b.startStatement();
            BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class)).string("frame").string("slot").string("local").end();
            b.end();
            b.end();
            b.startIf().string("newTag != oldTag").end().startBlock();
            b.startStatement().startCall(bytecodeNode, "setCachedLocalTagInternal");
            if (materialized) {
                b.startCall(bytecodeNode, "getLocalTags").end();
            } else {
                b.string("localTags");
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.string("localIndex");
            } else {
                b.string("slot - USER_LOCALS_START_INDEX");
            }
            b.string("newTag");
            b.end(2);
            b.end();
            BytecodeRootNodeElement.this.emitQuickeningOperand(b, "this", "bc", "bci", null, 0, "operandIndex", "operand", "newOperand");
            BytecodeRootNodeElement.this.emitQuickening(b, "this", "bc", "bci", null, "newInstruction");
            b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 1"));
            if (instr.kind == InstructionModel.InstructionKind.STORE_LOCAL_MATERIALIZED) {
                b.statement(BytecodeRootNodeElement.clearFrame(stackFrame, "sp - 2"));
            }
            this.doInstructionMethods.put(instr, method);
            return method;
        }

        private void emitValidateMaterializedAccess(CodeTreeBuilder b, String localRootIndex, String localRootVariable, String bytecodeNodeVariable, String localIndex) {
            CodeTree getRoot = CodeTreeBuilder.createBuilder().startCall("this.getRoot().getBytecodeRootNodeImpl").string(localRootIndex).end().build();
            if (localRootVariable != null) {
                b.declaration(BytecodeRootNodeElement.this.asType(), localRootVariable, getRoot);
                getRoot = CodeTreeBuilder.singleString(localRootVariable);
            }
            b.startIf().tree(getRoot).string(".getFrameDescriptor() != frame.getFrameDescriptor()");
            b.end().startBlock();
            BytecodeRootNodeElement.emitThrowIllegalArgumentException(b, "Materialized frame belongs to the wrong root node.");
            b.end();
            CodeTree getBytecode = CodeTreeBuilder.createBuilder().tree(getRoot).string(".getBytecodeNodeImpl()").end().build();
            if (bytecodeNodeVariable != null) {
                b.declaration(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), bytecodeNodeVariable, getBytecode);
                getBytecode = CodeTreeBuilder.singleString(bytecodeNodeVariable);
            }
            if (BytecodeRootNodeElement.this.model.enableBlockScoping && BytecodeRootNodeElement.this.model.storeBciInFrame && localIndex != null) {
                b.startAssert().startCall(getBytecode, "validateLocalLivenessInternal");
                b.string("frame");
                b.string("slot");
                b.string(localIndex);
                b.string("stackFrame");
                b.string("bci");
                b.end(2);
            }
        }

        private CodeExecutableElement createLoadConstantCompiled() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Void.TYPE), "loadConstantCompiled", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"));
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
            ex.addParameter(new CodeVariableElement(ElementHelpers.arrayOf(BytecodeRootNodeElement.this.context.getDeclaredType(Object.class)), "consts"));
            CodeTreeBuilder b = ex.createBuilder();
            InstructionModel.InstructionImmediate constant = BytecodeRootNodeElement.this.model.loadConstantInstruction.getImmediate(InstructionModel.ImmediateKind.CONSTANT);
            b.declaration((TypeMirror)BytecodeRootNodeElement.this.context.getDeclaredType(Object.class), "constant", BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", constant)));
            Class[] boxedTypes = new Class[]{Boolean.class, Byte.class, Character.class, Float.class, Integer.class, Long.class, Short.class, Double.class};
            String[] getterMethods = new String[]{"booleanValue", "byteValue", "charValue", "floatValue", "intValue", "longValue", "shortValue", "doubleValue"};
            for (int i = 0; i < boxedTypes.length; ++i) {
                b.startIf(i != 0);
                String className = boxedTypes[i].getSimpleName();
                char boundVariable = className.toLowerCase().charAt(0);
                b.string("constant instanceof " + className + " " + boundVariable);
                b.end().startBlock();
                b.statement(BytecodeRootNodeElement.setFrameObject("sp", boundVariable + "." + getterMethods[i] + "()"));
                b.statement("return");
                b.end();
            }
            b.statement(BytecodeRootNodeElement.setFrameObject("sp", "constant"));
            return ex;
        }

        private CodeExecutableElement createAdoptNodesAfterUpdate() {
            CodeExecutableElement ex = GeneratorUtils.override((DeclaredType)BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "adoptNodesAfterUpdate");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("insert(this.cachedNodes_)");
            return ex;
        }

        private List<CodeElement<Element>> createBranchProfileMembers() {
            ArrayType branchProfilesType = ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE));
            CodeVariableElement branchProfilesField = BytecodeRootNodeElement.this.compFinal(1, new CodeVariableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), branchProfilesType, "branchProfiles_"));
            CodeExecutableElement allocateBranchProfiles = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), branchProfilesType, "allocateBranchProfiles", new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "numProfiles"));
            allocateBranchProfiles.getBuilder().lineComment("Encoding: [t1, f1, t2, f2, ..., tn, fn]").startReturn().startNewArray(branchProfilesType, CodeTreeBuilder.singleString("numProfiles * 2")).end(2);
            CodeExecutableElement profileBranch = this.createProfileBranch(branchProfilesType);
            CodeExecutableElement ensureFalseProfile = this.createEnsureFalseProfile(branchProfilesType);
            return List.of(branchProfilesField, allocateBranchProfiles, profileBranch, ensureFalseProfile);
        }

        private CodeExecutableElement createProfileBranch(TypeMirror branchProfilesType) {
            CodeExecutableElement allocateBranchProfiles = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "profileBranch", new CodeVariableElement(branchProfilesType, "branchProfiles"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "profileIndex"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Boolean.TYPE), "condition"));
            this.emitNewBranchProfile(allocateBranchProfiles);
            return allocateBranchProfiles;
        }

        private void emitNewBranchProfile(CodeExecutableElement allocateBranchProfiles) {
            CodeTreeBuilder b = allocateBranchProfiles.createBuilder();
            b.declaration("int", "t", (CodeTree)null);
            b.declaration("int", "f", (CodeTree)null);
            b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.HostCompilerDirectives, "inInterpreterFastPath").end().end().startBlock();
            b.startIf().string("condition").end().startBlock();
            this.emitNewProfileBranchCase(b, "t", "f", "profileIndex * 2", "profileIndex * 2 + 1");
            b.end().startElseBlock();
            this.emitNewProfileBranchCase(b, "f", "t", "profileIndex * 2 + 1", "profileIndex * 2");
            b.end();
            b.statement("return condition");
            b.end().startElseBlock();
            b.startAssign("t").tree(BytecodeRootNodeElement.readIntArray("branchProfiles", "profileIndex * 2")).end();
            b.startAssign("f").tree(BytecodeRootNodeElement.readIntArray("branchProfiles", "profileIndex * 2 + 1")).end();
            b.startIf().string("condition").end().startBlock();
            b.startIf().string("t == 0").end().startBlock();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.end();
            b.startIf().string("f == 0").end().startBlock();
            b.returnTrue();
            b.end();
            b.end().startElseBlock();
            b.startIf().string("f == 0").end().startBlock();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.end();
            b.startIf().string("t == 0").end().startBlock();
            b.returnFalse();
            b.end();
            b.end();
            b.startReturn().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "injectBranchProbability");
            b.string("(double) t / (double) (t + f)");
            b.string("condition");
            b.end(2);
            b.end();
        }

        private void emitNewProfileBranchCase(CodeTreeBuilder b, String count, String otherCount, String index, String otherIndex) {
            b.startAssign(count).tree(BytecodeRootNodeElement.readIntArray("branchProfiles", index)).end();
            b.startIf().string(count).string(" == 0").end().startBlock();
            b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            b.end();
            b.startTryBlock();
            b.startAssign(count).startStaticCall(BytecodeRootNodeElement.this.type(Math.class), "addExact").string(count).string("1").end().end();
            b.end().startCatchBlock(BytecodeRootNodeElement.this.type(ArithmeticException.class), "e");
            b.startAssign(otherCount).tree(BytecodeRootNodeElement.readIntArray("branchProfiles", otherIndex)).end();
            b.lineComment("shift count but never make it go to 0");
            b.startAssign(otherCount).string("(" + otherCount + " & 0x1) + (" + otherCount + " >> 1)").end();
            b.statement(BytecodeRootNodeElement.writeIntArray("branchProfiles", otherIndex, otherCount));
            b.startAssign(count).staticReference(BytecodeRootNodeElement.this.type(Integer.class), "MAX_VALUE").string(" >> 1").end();
            b.end();
            b.statement(BytecodeRootNodeElement.writeIntArray("branchProfiles", index, count));
        }

        private CodeExecutableElement createEnsureFalseProfile(TypeMirror branchProfilesType) {
            CodeExecutableElement ensureFalseProfile = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), BytecodeRootNodeElement.this.type(Void.TYPE), "ensureFalseProfile", new CodeVariableElement(branchProfilesType, "branchProfiles"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "profileIndex"));
            CodeTreeBuilder b = ensureFalseProfile.createBuilder();
            b.startIf().tree(BytecodeRootNodeElement.readIntArray("branchProfiles", "profileIndex * 2 + 1")).string(" == 0").end().startBlock();
            b.statement(BytecodeRootNodeElement.writeIntArray("branchProfiles", "profileIndex * 2 + 1", "1"));
            b.end();
            return ensureFalseProfile;
        }

        private void emitReportLoopCount(CodeTreeBuilder b, CodeTree condition, boolean clear) {
            b.startIf().startStaticCall(BytecodeRootNodeElement.this.types.CompilerDirectives, "hasNextTier").end().string(" && ").tree(condition).end().startBlock();
            b.startStatement().startStaticCall(BytecodeRootNodeElement.this.types.LoopNode, "reportLoopCount");
            b.string("this");
            b.string("loopCounter.value");
            b.end(2);
            if (clear) {
                b.statement("loopCounter.value = 0");
            }
            b.end();
        }

        private void buildCustomInstructionExecute(CodeTreeBuilder continueAtBuilder, InstructionModel instr) {
            boolean unexpectedValue;
            String methodName = this.instructionMethodName(instr);
            CodeExecutableElement helper = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.FINAL), BytecodeRootNodeElement.this.type(Void.TYPE), methodName, new CodeVariableElement[0]);
            CodeExecutableElement prev = this.doInstructionMethods.put(instr, helper);
            if (prev != null) {
                throw new AssertionError((Object)"Custom instruction already emitted.");
            }
            helper.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "frame"));
            if (BytecodeRootNodeElement.this.model.enableYield) {
                helper.getParameters().add(new CodeVariableElement(BytecodeRootNodeElement.this.types.VirtualFrame, "localFrame"));
            }
            List<CodeVariableElement> extraParams = this.createExtraParameters(instr.hasImmediate(InstructionModel.ImmediateKind.CONSTANT));
            if (this.tier.isCached()) {
                helper.getParameters().add(new CodeVariableElement(new CodeTypeMirror.ArrayCodeTypeMirror(BytecodeRootNodeElement.this.types.Node), "cachedNodes"));
            }
            helper.getParameters().addAll(extraParams);
            CodeTreeBuilder b = helper.createBuilder();
            int stackEffect = BytecodeNodeElement.getStackEffect(instr);
            if (this.customInstructionMayReadBci(instr)) {
                this.storeBciInFrameIfNecessary(b);
            }
            GeneratedTypeMirror cachedType = this.getCachedDataClassType(instr);
            if (this.tier.isCached()) {
                if (instr.canUseNodeSingleton()) {
                    b.startDeclaration(cachedType, "node").staticReference(cachedType, "SINGLETON").end();
                } else {
                    CodeTree nodeIndex = BytecodeRootNodeElement.readImmediate("bc", "bci", instr.getImmediate(InstructionModel.ImmediateKind.NODE_PROFILE));
                    CodeTree readNode = CodeTreeBuilder.createBuilder().tree(BytecodeRootNodeElement.readNodeProfile(cachedType, nodeIndex)).build();
                    b.declaration((TypeMirror)cachedType, "node", readNode);
                }
            }
            if (unexpectedValue = BytecodeRootNodeElement.hasUnexpectedExecuteValue(instr)) {
                b.startTryBlock();
            }
            this.buildCallExecute(b, instr, null, extraParams);
            if (!instr.signature.isVoid) {
                b.startStatement();
                if (instr.isReturnTypeQuickening()) {
                    BytecodeRootNodeElement.startSetFrame(b, instr.signature.returnType);
                } else {
                    BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class));
                }
                b.string("frame");
                if (stackEffect == 1) {
                    b.string("sp");
                } else {
                    b.string("sp - " + (1 - stackEffect));
                }
                b.string("result");
                b.end();
                b.end();
            }
            if (unexpectedValue) {
                b.end().startCatchBlock(BytecodeRootNodeElement.this.types.UnexpectedResultException, "ex");
                b.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
                if (this.isBoxingOverloadReturnTypeQuickening(instr)) {
                    InstructionModel generic = instr.quickeningBase.findGenericInstruction();
                    if (generic == instr) {
                        throw new AssertionError((Object)"Unexpected generic instruction.");
                    }
                    BytecodeRootNodeElement.this.emitQuickening(b, "this", "bc", "bci", null, BytecodeRootNodeElement.this.createInstructionConstant(generic));
                }
                if (!instr.signature.isVoid) {
                    b.startStatement();
                    BytecodeRootNodeElement.startSetFrame(b, BytecodeRootNodeElement.this.type(Object.class));
                    b.string("frame");
                    if (stackEffect == 1) {
                        b.string("sp");
                    } else {
                        b.string("sp - " + (1 - stackEffect));
                    }
                    b.string("ex.getResult()");
                    b.end();
                    b.end();
                }
                b.end();
            }
            for (int i = stackEffect; i < 0; ++i) {
                b.statement(BytecodeRootNodeElement.clearFrame("frame", "sp - " + -i));
            }
            continueAtBuilder.startStatement().startCall(methodName);
            continueAtBuilder.variables(helper.getParameters());
            continueAtBuilder.end(2);
        }

        private boolean isBoxingOverloadReturnTypeQuickening(InstructionModel instr) {
            if (!instr.isReturnTypeQuickening()) {
                return false;
            }
            SpecializationData specialization = instr.resolveSingleSpecialization();
            if (specialization == null) {
                return false;
            }
            return specialization.getBoxingOverloads().size() > 0;
        }

        private void emitCustomStackEffect(CodeTreeBuilder continueAtBuilder, int stackEffect) {
            if (stackEffect > 0) {
                continueAtBuilder.statement("sp += " + stackEffect);
            } else if (stackEffect < 0) {
                continueAtBuilder.statement("sp -= " + -stackEffect);
            }
        }

        private static int getStackEffect(InstructionModel instr) {
            return (instr.signature.isVoid ? 0 : 1) - instr.signature.dynamicOperandCount;
        }

        private GeneratedTypeMirror getCachedDataClassType(InstructionModel instr) {
            return new GeneratedTypeMirror("", BytecodeRootNodeElement.cachedDataClassName(instr));
        }

        private List<CodeVariableElement> createExtraParameters(boolean withConsts) {
            ArrayList<CodeVariableElement> extraParams = new ArrayList<CodeVariableElement>();
            extraParams.addAll(List.of(new CodeVariableElement(BytecodeRootNodeElement.this.type(byte[].class), "bc"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "bci"), new CodeVariableElement(BytecodeRootNodeElement.this.type(Integer.TYPE), "sp")));
            if (withConsts) {
                extraParams.add(new CodeVariableElement(new CodeTypeMirror.ArrayCodeTypeMirror(BytecodeRootNodeElement.this.type(Object.class)), "consts"));
            }
            return extraParams;
        }

        private void buildCallExecute(CodeTreeBuilder b, InstructionModel instr, String evaluatedArg, List<CodeVariableElement> extraParams) {
            boolean isVoid = instr.signature.isVoid;
            GeneratedTypeMirror cachedType = this.getCachedDataClassType(instr);
            b.startStatement();
            if (!isVoid) {
                b.type(instr.signature.returnType);
                b.string(" result = ");
            }
            if (this.tier.isUncached()) {
                b.staticReference(cachedType, "UNCACHED").startCall(".executeUncached");
            } else {
                b.startCall("node", BytecodeRootNodeElement.executeMethodName(instr));
            }
            b.string(BytecodeRootNodeElement.this.localFrame());
            if (evaluatedArg != null) {
                b.string(evaluatedArg);
            } else if (this.tier.isUncached()) {
                TypeMirror constantOperandType;
                int i;
                List<InstructionModel.InstructionImmediate> constants = instr.getImmediates(InstructionModel.ImmediateKind.CONSTANT);
                for (i = 0; i < instr.signature.constantOperandsBeforeCount; ++i) {
                    constantOperandType = instr.operation.constantOperands.before().get(i).type();
                    b.startGroup();
                    b.tree(BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", constants.get(i)), constantOperandType));
                    b.end();
                }
                for (i = 0; i < instr.signature.dynamicOperandCount; ++i) {
                    TypeMirror targetType = instr.signature.getGenericType(i);
                    b.startGroup();
                    if (!ElementUtils.isObject(targetType)) {
                        b.cast(targetType);
                    }
                    b.string(BytecodeRootNodeElement.uncheckedGetFrameObject("sp - " + (instr.signature.dynamicOperandCount - i)));
                    b.end();
                }
                for (i = 0; i < instr.signature.constantOperandsAfterCount; ++i) {
                    constantOperandType = instr.operation.constantOperands.after().get(i).type();
                    b.startGroup();
                    b.tree(BytecodeRootNodeElement.readConstFastPath(BytecodeRootNodeElement.readImmediate("bc", "bci", constants.get(i + instr.signature.constantOperandsBeforeCount)), constantOperandType));
                    b.end();
                }
            }
            if (BytecodeRootNodeElement.this.model.enableYield) {
                b.string("frame");
            }
            b.string("this");
            b.variables(extraParams);
            b.end();
            b.end();
        }

        private void storeBciInFrameIfNecessary(CodeTreeBuilder b) {
            if (this.tier.isUncached() || BytecodeRootNodeElement.this.model.storeBciInFrame) {
                b.statement("FRAMES.setInt(" + BytecodeRootNodeElement.this.localFrame() + ", BCI_INDEX, bci)");
            }
        }

        private static void emitReturnTopOfStack(CodeTreeBuilder b) {
            b.startReturn().string(BytecodeRootNodeElement.encodeReturnState("(sp - 1)")).end();
        }

        private void emitBeforeReturnProfiling(CodeTreeBuilder b) {
            if (this.tier.isCached()) {
                this.emitReportLoopCount(b, CodeTreeBuilder.singleString("loopCounter.value > 0"), false);
            }
        }

        private boolean customInstructionMayReadBci(InstructionModel instr) {
            for (SpecializationData spec : instr.nodeData.getSpecializations()) {
                if (spec.getCaches().isEmpty()) continue;
                return true;
            }
            return false;
        }

        private String instructionMethodName(InstructionModel instr) {
            return "do" + ElementUtils.firstLetterUpperCase(instr.getInternalName());
        }

        record InstructionGroup(int stackEffect, int instructionLength) {
            InstructionGroup(InstructionModel instr) {
                this(BytecodeNodeElement.getStackEffect(instr), instr.getInstructionLength());
            }
        }

        final class InterpreterStateElement
        extends CodeTypeElement {
            InterpreterStateElement() {
                super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "InterpreterState");
                if (!BytecodeRootNodeElement.this.model.enableYield) {
                    throw new AssertionError((Object)"A InterpreterState class should only be generated when continuations are enabled.");
                }
                this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Boolean.TYPE), "isContinuation"));
                this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "sp"));
                this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this));
            }
        }
    }

    static enum InterpreterTier {
        UNINITIALIZED("Uninitialized"),
        UNCACHED("Uncached"),
        CACHED("Cached");

        final String friendlyName;

        private InterpreterTier(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        boolean isUncached() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> false;
                case 1 -> true;
                case 2 -> false;
            };
        }

        boolean isCached() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> false;
                case 1 -> false;
                case 2 -> true;
            };
        }

        boolean isUninitialized() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> true;
                case 1 -> false;
                case 2 -> false;
            };
        }

        public String bytecodeClassName() {
            return this.friendlyName + "BytecodeNode";
        }
    }

    final class ExceptionHandlerImplElement
    extends CodeTypeElement {
        ExceptionHandlerImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "ExceptionHandlerImpl");
            this.setSuperClass(BytecodeRootNodeElement.this.types.ExceptionHandler);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            CodeTree tree = constructor.getBodyTree();
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.tree(tree);
            this.add(this.createGetKind());
            this.add(this.createGetStartBytecodeIndex());
            this.add(this.createGetEndBytecodeIndex());
            this.add(this.createGetHandlerBytecodeIndex());
            this.add(this.createGetTagTree());
        }

        private CodeExecutableElement createGetKind() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ExceptionHandler, "getKind");
            CodeTreeBuilder b = ex.createBuilder();
            if (this.hasSpecialHandlers()) {
                b.startSwitch();
                b.string("bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_KIND]");
                b.end().startBlock();
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.startCase().string("HANDLER_TAG_EXCEPTIONAL").end().startCaseBlock();
                    b.startReturn().staticReference(BytecodeRootNodeElement.this.types.ExceptionHandler_HandlerKind, "TAG").end();
                    b.end();
                }
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    b.startCase().string("HANDLER_EPILOG_EXCEPTIONAL").end().startCaseBlock();
                    b.startReturn().staticReference(BytecodeRootNodeElement.this.types.ExceptionHandler_HandlerKind, "EPILOG").end();
                    b.end();
                }
                b.caseDefault().startCaseBlock();
                b.startReturn().staticReference(BytecodeRootNodeElement.this.types.ExceptionHandler_HandlerKind, "CUSTOM").end();
                b.end();
                b.end();
            } else {
                b.startReturn().staticReference(BytecodeRootNodeElement.this.types.ExceptionHandler_HandlerKind, "CUSTOM").end();
            }
            return ex;
        }

        private boolean hasSpecialHandlers() {
            return BytecodeRootNodeElement.this.model.enableTagInstrumentation || BytecodeRootNodeElement.this.model.epilogExceptional != null;
        }

        private CodeExecutableElement createGetStartBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ExceptionHandler, "getStartBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_START_BCI]");
            return ex;
        }

        private CodeExecutableElement createGetEndBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ExceptionHandler, "getEndBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_END_BCI]");
            return ex;
        }

        private CodeExecutableElement createGetHandlerBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ExceptionHandler, "getHandlerBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            if (this.hasSpecialHandlers()) {
                b.startSwitch();
                b.string("getKind()");
                b.end().startBlock();
                if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                    b.startCase().string("TAG").end();
                }
                if (BytecodeRootNodeElement.this.model.epilogExceptional != null) {
                    b.startCase().string("EPILOG").end();
                }
                b.startCaseBlock();
                b.statement("return super.getHandlerBytecodeIndex()");
                b.end();
                b.caseDefault().startCaseBlock();
                b.statement("return bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
                b.end();
                b.end();
            } else {
                b.statement("return bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
            }
            return ex;
        }

        private CodeExecutableElement createGetTagTree() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.ExceptionHandler, "getTagTree");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableTagInstrumentation) {
                b.startIf().string("getKind() == ").staticReference(BytecodeRootNodeElement.this.types.ExceptionHandler_HandlerKind, "TAG").end().startBlock();
                b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nodeId", "bytecode.handlers[baseIndex + EXCEPTION_HANDLER_OFFSET_HANDLER_BCI]");
                b.statement("return bytecode.tagRoot.tagNodes[nodeId]");
                b.end().startElseBlock();
                b.statement("return super.getTagTree()");
                b.end();
            } else {
                b.statement("return super.getTagTree()");
            }
            return ex;
        }
    }

    final class ExceptionHandlerListElement
    extends CodeTypeElement {
        ExceptionHandlerListElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "ExceptionHandlerList");
            this.setSuperClass(ElementHelpers.generic(BytecodeRootNodeElement.this.type(AbstractList.class), (TypeMirror)BytecodeRootNodeElement.this.types.ExceptionHandler));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            this.add(this.createGet());
            this.add(this.createSize());
        }

        private CodeExecutableElement createGet() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "get", new String[]{"index"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.setReturnType(BytecodeRootNodeElement.this.types.ExceptionHandler);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex", "index * EXCEPTION_HANDLER_LENGTH");
            b.startIf().string("baseIndex < 0 || baseIndex >= bytecode.handlers.length").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IndexOutOfBoundsException.class)).string("String.valueOf(index)").end().end();
            b.end();
            b.startReturn();
            b.startNew("ExceptionHandlerImpl").string("bytecode").string("baseIndex").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createSize() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "size");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.handlers.length / EXCEPTION_HANDLER_LENGTH");
            return ex;
        }
    }

    final class SourceInformationImplElement
    extends CodeTypeElement {
        SourceInformationImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SourceInformationImpl");
            this.setSuperClass(BytecodeRootNodeElement.this.types.SourceInformation);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            CodeTree tree = constructor.getBodyTree();
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.tree(tree);
            this.add(this.createGetStartBytecodeIndex());
            this.add(this.createGetEndBytecodeIndex());
            this.add(this.createGetSourceSection());
        }

        private CodeExecutableElement createGetStartBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getStartBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("bytecode.sourceInfo[baseIndex + SOURCE_INFO_OFFSET_START_BCI]").end();
            return ex;
        }

        private CodeExecutableElement createGetEndBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getEndBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.startReturn().string("bytecode.sourceInfo[baseIndex + SOURCE_INFO_OFFSET_END_BCI]").end();
            return ex;
        }

        private CodeExecutableElement createGetSourceSection() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getSourceSection");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return AbstractBytecodeNode.createSourceSection(bytecode.sources, bytecode.sourceInfo, baseIndex)");
            return ex;
        }
    }

    final class SourceInformationListElement
    extends CodeTypeElement {
        SourceInformationListElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SourceInformationList");
            this.setSuperClass(ElementHelpers.generic(BytecodeRootNodeElement.this.type(AbstractList.class), (TypeMirror)BytecodeRootNodeElement.this.types.SourceInformation));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            this.add(this.createGet());
            this.add(this.createSize());
        }

        private CodeExecutableElement createGet() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "get", new String[]{"index"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.setReturnType(BytecodeRootNodeElement.this.types.SourceInformation);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex", "index * SOURCE_INFO_LENGTH");
            b.startIf().string("baseIndex < 0 || baseIndex >= bytecode.sourceInfo.length").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IndexOutOfBoundsException.class)).string("String.valueOf(index)").end().end();
            b.end();
            b.startReturn();
            b.startNew("SourceInformationImpl").string("bytecode").string("baseIndex").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createSize() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "size");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.sourceInfo.length / SOURCE_INFO_LENGTH");
            return ex;
        }
    }

    final class SourceInformationTreeImplElement
    extends CodeTypeElement {
        SourceInformationTreeImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "SourceInformationTreeImpl");
            this.setSuperClass(BytecodeRootNodeElement.this.types.SourceInformationTree);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL, Modifier.STATIC), BytecodeRootNodeElement.this.type(Integer.TYPE), "UNAVAILABLE_ROOT")).createInitBuilder().string("-1");
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), ElementHelpers.generic(List.class, (TypeMirror)BytecodeRootNodeElement.this.types.SourceInformationTree), "children"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null, Set.of("children")));
            CodeTree tree = constructor.getBodyTree();
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.tree(tree);
            b.startAssign("this.children").startNew(ElementHelpers.generic(BytecodeRootNodeElement.this.type(LinkedList.class), (TypeMirror)BytecodeRootNodeElement.this.types.SourceInformationTree)).end(2);
            this.add(this.createGetStartBytecodeIndex());
            this.add(this.createGetEndBytecodeIndex());
            this.add(this.createGetSourceSection());
            this.add(this.createGetChildren());
            this.add(this.createContains());
            this.add(this.createParse());
        }

        private CodeExecutableElement createGetStartBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getStartBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("baseIndex == UNAVAILABLE_ROOT").end().startBlock();
            b.startReturn().string("0").end();
            b.end();
            b.startReturn().string("bytecode.sourceInfo[baseIndex + SOURCE_INFO_OFFSET_START_BCI]").end();
            return ex;
        }

        private CodeExecutableElement createGetEndBytecodeIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getEndBytecodeIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("baseIndex == UNAVAILABLE_ROOT").end().startBlock();
            b.startReturn().string("bytecode.bytecodes.length").end();
            b.end();
            b.startReturn().string("bytecode.sourceInfo[baseIndex + SOURCE_INFO_OFFSET_END_BCI]").end();
            return ex;
        }

        private CodeExecutableElement createGetSourceSection() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformation, "getSourceSection");
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("baseIndex == UNAVAILABLE_ROOT").end().startBlock();
            b.startReturn().string("null").end();
            b.end();
            b.statement("return AbstractBytecodeNode.createSourceSection(bytecode.sources, bytecode.sourceInfo, baseIndex)");
            return ex;
        }

        private CodeExecutableElement createGetChildren() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.SourceInformationTree, "getChildren");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return children");
            return ex;
        }

        private CodeExecutableElement createContains() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE), BytecodeRootNodeElement.this.type(Boolean.TYPE), "contains", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(this.asType(), "other"));
            CodeTreeBuilder b = ex.createBuilder();
            b.startIf().string("baseIndex == UNAVAILABLE_ROOT").end().startBlock();
            b.startReturn().string("true").end();
            b.end();
            b.statement("return this.getStartBytecodeIndex() <= other.getStartBytecodeIndex() && other.getEndBytecodeIndex() <= this.getEndBytecodeIndex()");
            return ex;
        }

        private CodeExecutableElement createParse() {
            CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PRIVATE, Modifier.STATIC), BytecodeRootNodeElement.this.types.SourceInformationTree, "parse", new CodeVariableElement[0]);
            ex.addParameter(new CodeVariableElement(BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration((TypeMirror)ElementHelpers.arrayOf(BytecodeRootNodeElement.this.type(Integer.TYPE)), "sourceInfo", "bytecode.sourceInfo");
            b.startIf().string("sourceInfo.length == 0").end().startBlock();
            b.statement("return null");
            b.end();
            b.lineComment("Create a synthetic root node that contains all other SourceInformationTrees.");
            b.startDeclaration(this.asType(), "root");
            b.startNew(this.asType()).string("bytecode").string("UNAVAILABLE_ROOT").end();
            b.end();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex", "sourceInfo.length");
            b.declaration(this.asType(), "current", "root");
            b.declaration((TypeMirror)ElementHelpers.generic(ArrayDeque.class, this.asType()), "stack", "new ArrayDeque<>()");
            b.startDoBlock();
            b.statement("baseIndex -= SOURCE_INFO_LENGTH");
            b.startDeclaration(this.asType(), "newNode");
            b.startNew(this.asType()).string("bytecode").string("baseIndex").end();
            b.end();
            b.startWhile().string("!current.contains(newNode)").end().startBlock();
            b.statement("current = stack.pop()");
            b.end();
            b.statement("current.children.addFirst(newNode)");
            b.statement("stack.push(current)");
            b.statement("current = newNode");
            b.end().startDoWhile().string("baseIndex > 0").end();
            b.startIf().string("root.getChildren().size() == 1").end().startBlock();
            b.lineComment("If there is an actual root source section, ignore the synthetic root we created.");
            b.statement("return root.getChildren().getFirst()");
            b.end().startElseBlock();
            b.statement("return root");
            b.end();
            return BytecodeRootNodeElement.this.withTruffleBoundary(ex);
        }
    }

    final class LocalVariableImplElement
    extends CodeTypeElement {
        LocalVariableImplElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "LocalVariableImpl");
            this.setSuperClass(BytecodeRootNodeElement.this.types.LocalVariable);
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex"));
            CodeExecutableElement constructor = this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            CodeTree tree = constructor.getBodyTree();
            CodeTreeBuilder b = constructor.createBuilder();
            b.startStatement().startSuperCall().staticReference(BytecodeRootNodeElement.this.bytecodeRootNodesImpl.asType(), "VISIBLE_TOKEN").end().end();
            b.tree(tree);
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                this.add(this.createGetStartIndex());
                this.add(this.createGetEndIndex());
            }
            this.add(this.createGetInfo());
            this.add(this.createGetName());
            this.add(this.createGetLocalIndex());
            this.add(this.createGetLocalOffset());
            this.add(this.createGetTypeProfile());
        }

        private CodeExecutableElement createGetStartIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getStartIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.locals[baseIndex + LOCALS_OFFSET_START_BCI]");
            return ex;
        }

        private CodeExecutableElement createGetEndIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getEndIndex");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.locals[baseIndex + LOCALS_OFFSET_END_BCI]");
            return ex;
        }

        private CodeExecutableElement createGetInfo() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getInfo");
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "infoId", "bytecode.locals[baseIndex + LOCALS_OFFSET_INFO]");
            b.startIf().string("infoId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("infoId", "bytecode.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetName() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getName");
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "nameId", "bytecode.locals[baseIndex + LOCALS_OFFSET_NAME]");
            b.startIf().string("nameId == -1").end().startBlock();
            b.returnNull();
            b.end().startElseBlock();
            b.startReturn().tree(BytecodeRootNodeElement.readConst("nameId", "bytecode.constants")).end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createGetLocalIndex() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getLocalIndex");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("return bytecode.locals[baseIndex + LOCALS_OFFSET_LOCAL_INDEX]");
            } else {
                b.statement("return baseIndex / LOCALS_LENGTH");
            }
            return ex;
        }

        private CodeExecutableElement createGetLocalOffset() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getLocalOffset");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.enableBlockScoping) {
                b.statement("return bytecode.locals[baseIndex + LOCALS_OFFSET_FRAME_INDEX] - USER_LOCALS_START_INDEX");
            } else {
                b.statement("return baseIndex / LOCALS_LENGTH");
            }
            return ex;
        }

        private CodeExecutableElement createGetTypeProfile() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.types.LocalVariable, "getTypeProfile");
            CodeTreeBuilder b = ex.createBuilder();
            if (BytecodeRootNodeElement.this.model.usesBoxingElimination()) {
                b.declaration(BytecodeRootNodeElement.this.type(byte[].class), "localTags", "bytecode.getLocalTags()");
                b.startIf().string("localTags == null").end().startBlock();
                b.returnNull();
                b.end();
                b.statement("return FrameSlotKind.fromTag(localTags[getLocalIndex()])");
            } else {
                b.returnNull();
            }
            return ex;
        }
    }

    final class LocalVariableListElement
    extends CodeTypeElement {
        LocalVariableListElement() {
            super(Set.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), ElementKind.CLASS, null, "LocalVariableList");
            this.setSuperClass(ElementHelpers.generic(BytecodeRootNodeElement.this.type(AbstractList.class), (TypeMirror)BytecodeRootNodeElement.this.types.LocalVariable));
            this.add(new CodeVariableElement(Set.of(Modifier.FINAL), BytecodeRootNodeElement.this.abstractBytecodeNode.asType(), "bytecode"));
            this.add(GeneratorUtils.createConstructorUsingFields(Set.of(), this, null));
            this.add(this.createGet());
            this.add(this.createSize());
        }

        private CodeExecutableElement createGet() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "get", new String[]{"index"}, new TypeMirror[]{BytecodeRootNodeElement.this.type(Integer.TYPE)});
            ex.setReturnType(BytecodeRootNodeElement.this.types.LocalVariable);
            CodeTreeBuilder b = ex.createBuilder();
            b.declaration(BytecodeRootNodeElement.this.type(Integer.TYPE), "baseIndex", "index * LOCALS_LENGTH");
            b.startIf().string("baseIndex < 0 || baseIndex >= bytecode.locals.length").end().startBlock();
            b.startThrow().startNew(BytecodeRootNodeElement.this.type(IndexOutOfBoundsException.class)).string("String.valueOf(index)").end().end();
            b.end();
            b.startReturn();
            b.startNew("LocalVariableImpl").string("bytecode").string("baseIndex").end();
            b.end();
            return ex;
        }

        private CodeExecutableElement createSize() {
            CodeExecutableElement ex = GeneratorUtils.override(BytecodeRootNodeElement.this.declaredType(List.class), "size");
            CodeTreeBuilder b = ex.createBuilder();
            b.statement("return bytecode.locals.length / LOCALS_LENGTH");
            return ex;
        }
    }
}

