/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.compiler.JDTCompiler;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import com.oracle.truffle.dsl.processor.model.Template;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class AbstractRegistrationProcessor
extends AbstractProcessor {
    private final Map<String, Element> registrations = new HashMap<String, Element>();

    AbstractRegistrationProcessor() {
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try (ProcessorContext context = ProcessorContext.enter(this.processingEnv);){
            String providerServiceBinName = this.processingEnv.getElementUtils().getBinaryName(context.getTypeElement(this.getProviderClass())).toString();
            if (roundEnv.processingOver()) {
                AbstractRegistrationProcessor.generateServicesRegistration(providerServiceBinName, this.registrations);
                this.registrations.clear();
                boolean bl = true;
                return bl;
            }
            String[] supportedAnnotations = this.getClass().getAnnotation(SupportedAnnotationTypes.class).value();
            TypeElement supportedAnnotation = this.processingEnv.getElementUtils().getTypeElement(supportedAnnotations[0]);
            if (supportedAnnotation == null) {
                throw new IllegalStateException("Cannot resolve " + supportedAnnotations[0]);
            }
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(supportedAnnotation);
            if (!annotatedElements.isEmpty()) {
                for (Element element : annotatedElements) {
                    AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element, supportedAnnotation.asType());
                    if (mirror == null || element.getKind() != ElementKind.CLASS || !this.accepts(element, mirror) || !this.validateRegistration(element, mirror)) continue;
                    TypeElement annotatedElement = (TypeElement)element;
                    String providerImplBinName = this.generateProvider(annotatedElement);
                    this.registrations.put(providerImplBinName, annotatedElement);
                    if (!AbstractRegistrationProcessor.shouldGenerateProviderFiles(annotatedElement)) continue;
                    AbstractRegistrationProcessor.generateProviderFile(this.processingEnv, providerImplBinName, providerServiceBinName, annotatedElement);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    boolean accepts(Element annotatedElement, AnnotationMirror registrationMirror) {
        return true;
    }

    abstract boolean validateRegistration(Element var1, AnnotationMirror var2);

    abstract DeclaredType getProviderClass();

    abstract Iterable<AnnotationMirror> getProviderAnnotations(TypeElement var1);

    abstract void implementMethod(TypeElement var1, CodeExecutableElement var2);

    static void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(e);
    }

    final void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    final void emitError(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, mirror, value);
    }

    final void emitWarning(String msg, Element e) {
        if (ExpectError.isExpectedError(e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    boolean validateInternalResources(Element annotatedElement, AnnotationMirror mirror, ProcessorContext context) {
        AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "internalResources", true);
        TruffleTypes types = context.getTypes();
        HashMap<String, TypeElement> usedResourceIds = new HashMap<String, TypeElement>();
        for (TypeMirror internalResource : ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "internalResources")) {
            TypeElement internalResourceElement = ElementUtils.fromTypeMirror(internalResource);
            Set<Modifier> modifiers = internalResourceElement.getModifiers();
            if (internalResourceElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !modifiers.contains((Object)Modifier.STATIC)) {
                this.emitError(String.format("The class %s must be a static inner-class or a top-level class. To resolve this, make the %s static or top-level class.", AbstractRegistrationProcessor.getScopedName(internalResourceElement), internalResourceElement.getSimpleName()), annotatedElement, mirror, value);
                return false;
            }
            if (!ElementUtils.isVisible(annotatedElement, internalResourceElement)) {
                PackageElement targetPackage = ElementUtils.findPackageElement(annotatedElement);
                this.emitError(String.format("The class %s must be public or package protected in the %s package. To resolve this, make the %s public or move it to the %s package.", AbstractRegistrationProcessor.getScopedName(internalResourceElement), targetPackage.getQualifiedName(), AbstractRegistrationProcessor.getScopedName(internalResourceElement), targetPackage.getQualifiedName()), annotatedElement, mirror, value);
                return false;
            }
            AnnotationMirror id = ElementUtils.findAnnotationMirror(internalResourceElement.getAnnotationMirrors(), (TypeMirror)types.InternalResource_Id);
            if (id == null) {
                String idSimpleName = ElementUtils.getSimpleName(types.InternalResource_Id);
                this.emitError(String.format("The class %s must be annotated by the @%s annotation. To resolve this, add '@%s(\"resource-id\")' annotation.", AbstractRegistrationProcessor.getScopedName(internalResourceElement), idSimpleName, idSimpleName), annotatedElement, mirror, value);
                return false;
            }
            boolean optional = ElementUtils.getAnnotationValue(Boolean.class, id, "optional");
            if (optional) {
                String resourceClzName = AbstractRegistrationProcessor.getScopedName(internalResourceElement);
                this.emitError(String.format("Optional internal resources must not be registered using '@Registration' annotation. To resolve this, remove the '%s' from 'internalResources' the or make the '%s' non-optional by removing 'optional = true'.", resourceClzName, resourceClzName), annotatedElement, mirror, value);
                return false;
            }
            String resourceComponentId = ElementUtils.getAnnotationValue(String.class, id, "componentId");
            String registrationComponentId = ElementUtils.getAnnotationValue(String.class, mirror, "id");
            if (!resourceComponentId.isEmpty() && !resourceComponentId.equals(registrationComponentId)) {
                String idSimpleName = ElementUtils.getSimpleName(types.InternalResource_Id);
                this.emitError(String.format("The '@%s.componentId' for an required internal resources must be unset or equal to '@Registration.id'. To resolve this, remove the '@%s.componentId = \"%s\"'.", idSimpleName, idSimpleName, resourceComponentId), annotatedElement, mirror, value);
                return false;
            }
            String idValue = ElementUtils.getAnnotationValue(String.class, id, "value");
            TypeElement prev = usedResourceIds.put(idValue, internalResourceElement);
            if (prev != null) {
                String prevResourceClzName = AbstractRegistrationProcessor.getScopedName(prev);
                String newResourceClzName = AbstractRegistrationProcessor.getScopedName(internalResourceElement);
                String idSimpleName = ElementUtils.getSimpleName(types.InternalResource_Id);
                this.emitError(String.format("Internal resources must have unique ids within the component. But %s and %s use the same id %s. To resolve this, change the @%s value on %s or %s.", prevResourceClzName, newResourceClzName, idValue, idSimpleName, prevResourceClzName, newResourceClzName), annotatedElement, mirror, value);
                return false;
            }
            boolean foundConstructor = false;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(internalResourceElement.getEnclosedElements())) {
                if (!ElementUtils.isVisible(annotatedElement, constructor) || !constructor.getParameters().isEmpty()) continue;
                foundConstructor = true;
                break;
            }
            if (foundConstructor) continue;
            this.emitError(String.format("The class %s must have a no argument public constructor. To resolve this, add public %s() constructor.", AbstractRegistrationProcessor.getScopedName(internalResourceElement), ElementUtils.getSimpleName(internalResourceElement)), annotatedElement, mirror, value);
            return false;
        }
        return true;
    }

    static CodeAnnotationMirror copyAnnotations(AnnotationMirror mirror, Predicate<ExecutableElement> filter) {
        CodeAnnotationMirror res = new CodeAnnotationMirror(mirror.getAnnotationType());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            ExecutableElement executable = e.getKey();
            AnnotationValue value = e.getValue();
            if (!filter.test(executable)) continue;
            res.setElementValue(executable, value);
        }
        return res;
    }

    private String generateProvider(TypeElement annotatedElement) {
        ProcessorContext context = ProcessorContext.getInstance();
        Template model = new Template(context, annotatedElement, null){};
        TypeElement providerElement = context.getTypeElement(this.getProviderClass());
        CodeTypeElement providerClass = GeneratorUtils.createClass(model, null, EnumSet.of(Modifier.PUBLIC), AbstractRegistrationProcessor.createProviderSimpleName(annotatedElement), providerElement.asType());
        providerClass.getModifiers().add(Modifier.FINAL);
        for (ExecutableElement method : ElementFilter.methodsIn(providerElement.getEnclosedElements())) {
            CodeExecutableElement implementedMethod = CodeExecutableElement.clone(method);
            implementedMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            this.implementMethod(annotatedElement, implementedMethod);
            providerClass.add(implementedMethod);
        }
        for (AnnotationMirror annotationMirror : this.getProviderAnnotations(annotatedElement)) {
            providerClass.addAnnotationMirror(annotationMirror);
        }
        DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
        providerClass.accept(new GenerateOverrideVisitor(overrideType), null);
        providerClass.accept(new FixWarningsVisitor(overrideType), null);
        providerClass.accept(new CodeWriter(context.getEnvironment(), annotatedElement), null);
        return providerClass.getQualifiedName().toString();
    }

    private static String createProviderSimpleName(TypeElement annotatedElement) {
        StringBuilder nameBuilder = new StringBuilder();
        List<Element> hierarchy = ElementUtils.getElementHierarchy(annotatedElement);
        ListIterator<Element> it = hierarchy.listIterator(hierarchy.size());
        while (it.hasPrevious()) {
            Element enc = it.previous();
            if (!enc.getKind().isClass() && !enc.getKind().isInterface()) continue;
            nameBuilder.append(enc.getSimpleName());
        }
        nameBuilder.append("Provider");
        return nameBuilder.toString();
    }

    static void generateProviderFile(ProcessingEnvironment env, String providerClassName, String serviceClassName, Element ... originatingElements) {
        assert (originatingElements.length > 0);
        String filename = "META-INF/truffle-registrations/" + providerClassName;
        try {
            FileObject file = env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, originatingElements);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), StandardCharsets.UTF_8));
            writer.println(serviceClassName);
            writer.close();
        }
        catch (IOException e) {
            AbstractRegistrationProcessor.handleIOError(e, env, originatingElements[0]);
        }
    }

    static void generateGetServicesClassNames(AnnotationMirror registration, CodeTreeBuilder builder, ProcessorContext context) {
        List<TypeMirror> services = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "services");
        Types types = context.getEnvironment().getTypeUtils();
        builder.startReturn();
        builder.startStaticCall(context.getType(List.class), "of");
        for (TypeMirror service : services) {
            builder.startGroup().doubleQuote(ElementUtils.getBinaryName((TypeElement)((DeclaredType)types.erasure(service)).asElement())).end();
        }
        builder.end(2);
    }

    static void generateGetInternalResourceIds(AnnotationMirror registration, CodeTreeBuilder builder, ProcessorContext context) {
        List<TypeMirror> resources = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "internalResources");
        builder.startReturn();
        builder.startStaticCall(context.getType(List.class), "of");
        Set<String> resourceIds = AbstractRegistrationProcessor.getResourcesById(resources, context).keySet();
        for (String resourceId : resourceIds) {
            builder.doubleQuote(resourceId);
        }
        builder.end(2);
    }

    static void generateCreateInternalResource(AnnotationMirror registration, VariableElement resourceIdParameter, CodeTreeBuilder builder, ProcessorContext context) {
        List<TypeMirror> resources = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "internalResources");
        String resourceIdParameterName = resourceIdParameter.getSimpleName().toString();
        if (resources.isEmpty()) {
            AbstractRegistrationProcessor.generateThrowIllegalArgumentException(builder, context, resourceIdParameterName, Set.of());
        } else {
            builder.startSwitch().string(resourceIdParameterName).end().startBlock();
            Map<String, TypeMirror> resourcesByName = AbstractRegistrationProcessor.getResourcesById(resources, context);
            for (Map.Entry<String, TypeMirror> e : resourcesByName.entrySet()) {
                builder.startCase().doubleQuote(e.getKey()).end();
                builder.startCaseBlock();
                builder.startReturn().startNew(e.getValue()).end(2);
                builder.end();
            }
            builder.caseDefault();
            builder.startCaseBlock();
            AbstractRegistrationProcessor.generateThrowIllegalArgumentException(builder, context, resourceIdParameterName, resourcesByName.keySet());
            builder.end(2);
        }
    }

    private static void generateThrowIllegalArgumentException(CodeTreeBuilder builder, ProcessorContext context, String resourceIdParameterName, Set<String> supportedIds) {
        builder.startThrow().startNew(context.getType(IllegalArgumentException.class)).startStaticCall(context.getType(String.class), "format");
        builder.doubleQuote("Unsupported internal resource id %s, supported ids are " + String.join((CharSequence)", ", supportedIds));
        builder.string(resourceIdParameterName);
        builder.end(3);
    }

    private static Map<String, TypeMirror> getResourcesById(List<TypeMirror> resources, ProcessorContext context) {
        LinkedHashMap<String, TypeMirror> res = new LinkedHashMap<String, TypeMirror>();
        TruffleTypes types = context.getTypes();
        for (TypeMirror resource : resources) {
            AnnotationMirror id = ElementUtils.findAnnotationMirror(ElementUtils.castTypeElement(resource).getAnnotationMirrors(), (TypeMirror)types.InternalResource_Id);
            String idValue = ElementUtils.getAnnotationValue(String.class, id, "value");
            res.put(idValue, resource);
        }
        return res;
    }

    private static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        return t.getCause() != null && AbstractRegistrationProcessor.isBug367599(t.getCause());
    }

    static void generateServicesRegistration(String providerBinName, Map<String, Element> providerRegistrations) {
        ProcessorContext context = ProcessorContext.getInstance();
        ProcessingEnvironment env = context.getEnvironment();
        Elements elements = env.getElementUtils();
        String filename = "META-INF/services/" + providerBinName;
        ArrayList<String> providerClassNames = new ArrayList<String>(providerRegistrations.size());
        for (String providerFqn : providerRegistrations.keySet()) {
            TypeElement te = ElementUtils.getTypeElement(providerFqn);
            if (te == null) {
                providerClassNames.add(providerFqn);
                continue;
            }
            providerClassNames.add(elements.getBinaryName(te).toString());
        }
        Collections.sort(providerClassNames);
        if (!providerClassNames.isEmpty()) {
            try {
                FileObject file = env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, providerRegistrations.values().toArray(new Element[0]));
                try (PrintWriter out = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), StandardCharsets.UTF_8));){
                    for (String providerClassName : providerClassNames) {
                        out.println(providerClassName);
                    }
                }
            }
            catch (IOException e) {
                AbstractRegistrationProcessor.handleIOError(e, env, providerRegistrations.values().iterator().next());
            }
        }
    }

    static String getScopedName(TypeElement element) {
        StringBuilder name = new StringBuilder();
        Element current = element;
        while (current.getKind().isClass() || current.getKind().isInterface()) {
            if (name.length() > 0) {
                name.insert(0, '.');
            }
            name.insert(0, ElementUtils.getSimpleName(current));
            current = current.getEnclosingElement();
        }
        return name.toString();
    }

    private static void handleIOError(IOException e, ProcessingEnvironment env, Element element) {
        if (e instanceof FilerException && (e.getMessage().startsWith("Source file already created") || e.getMessage().startsWith("Resource already created"))) {
            return;
        }
        env.getMessager().printMessage(AbstractRegistrationProcessor.isBug367599(e) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, e.getMessage(), element);
    }

    static boolean shouldGenerateProviderFiles(Element currentElement) {
        return CompilerFactory.getCompiler(currentElement) instanceof JDTCompiler;
    }
}

