/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.compiler.Compiler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.tools.Diagnostic;

public abstract class AbstractCompiler
implements Compiler {
    protected static Object method(Object o, String methodName) throws ReflectiveOperationException {
        Method method = o.getClass().getMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(o, new Object[0]);
    }

    protected static Object method(Object o, String methodName, Class<?>[] paramTypes, Object ... values) throws ReflectiveOperationException {
        Method method = o.getClass().getMethod(methodName, paramTypes);
        method.setAccessible(true);
        return method.invoke(o, values);
    }

    protected static Object staticMethod(Class<?> clz, String methodName, Class<?>[] paramTypes, Object ... values) throws ReflectiveOperationException {
        Method method = clz.getMethod(methodName, paramTypes);
        method.setAccessible(true);
        return method.invoke(null, values);
    }

    protected static Object field(Object o, String fieldName) throws ReflectiveOperationException {
        if (o == null) {
            return null;
        }
        return AbstractCompiler.lookupField(o.getClass(), fieldName).get(o);
    }

    protected static Field lookupField(Class<?> clazz, String fieldName) {
        Map<Class, Map> fieldsCache = ProcessorContext.getInstance().getCacheMap(AbstractCompiler.class);
        Map map = fieldsCache.computeIfAbsent(clazz, c -> new HashMap());
        return map.computeIfAbsent(fieldName, name -> {
            Field field;
            block5: {
                Class currentClass;
                field = null;
                try {
                    field = currentClass.getField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    for (currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
                        try {
                            field = currentClass.getDeclaredField(fieldName);
                            break;
                        }
                        catch (NoSuchFieldException e1) {
                            continue;
                        }
                    }
                    if (field != null) break block5;
                    throw new AssertionError((Object)e);
                }
            }
            field.setAccessible(true);
            return field;
        });
    }

    @Override
    public final void emitDeprecationWarning(ProcessingEnvironment environment, Element element) {
        if (!this.emitDeprecationWarningImpl(environment, element)) {
            ElementKind kind;
            CharSequence ownerQualifiedName = "";
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement != null && ((kind = enclosingElement.getKind()).isClass() || kind.isInterface() || kind == ElementKind.PACKAGE)) {
                ownerQualifiedName = ((QualifiedNameable)enclosingElement).getQualifiedName();
            }
            environment.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("%s in %s has been deprecated", element.getSimpleName(), ownerQualifiedName), element);
        }
    }

    protected abstract boolean emitDeprecationWarningImpl(ProcessingEnvironment var1, Element var2);
}

