/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public final class SpecializationGroup {
    private final List<TypeGuard> typeGuards;
    private final List<GuardExpression> guards;
    private final NodeData node;
    private final SpecializationData specialization;
    private final List<SpecializationGroup> children = new ArrayList<SpecializationGroup>();
    private SpecializationGroup parent;
    private boolean hasFallthrough;

    private SpecializationGroup(SpecializationData data) {
        this.node = data.getNode();
        this.typeGuards = new ArrayList<TypeGuard>();
        this.guards = new ArrayList<GuardExpression>();
        this.specialization = data;
        TemplateMethod.TypeSignature sig = data.getTypeSignature();
        for (int i = 1; i < sig.size(); ++i) {
            this.typeGuards.add(new TypeGuard(this.node.getTypeSystem(), sig.get(i), i - 1));
        }
        this.guards.addAll(data.getGuards());
    }

    private SpecializationGroup(List<SpecializationGroup> children, List<TypeGuard> typeGuardsMatches, List<GuardExpression> guardMatches) {
        assert (!children.isEmpty()) : "children must not be empty";
        this.typeGuards = typeGuardsMatches;
        this.guards = guardMatches;
        this.node = children.get((int)0).node;
        this.specialization = null;
        this.updateChildren(children);
    }

    public boolean isEmpty() {
        return this.typeGuards.isEmpty() && this.guards.isEmpty();
    }

    public List<TypeGuard> getAllGuards() {
        ArrayList<TypeGuard> collectedGuards = new ArrayList<TypeGuard>();
        collectedGuards.addAll(this.typeGuards);
        if (this.parent != null) {
            collectedGuards.addAll(this.parent.getAllGuards());
        }
        return collectedGuards;
    }

    public List<SpecializationData> collectSpecializations() {
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
        if (this.specialization != null) {
            specializations.add(this.specialization);
        }
        for (SpecializationGroup group : this.children) {
            specializations.addAll(group.collectSpecializations());
        }
        return specializations;
    }

    private void updateChildren(List<SpecializationGroup> childs) {
        if (!this.children.isEmpty()) {
            this.children.clear();
        }
        this.children.addAll(childs);
        for (SpecializationGroup child : childs) {
            child.parent = this;
        }
    }

    public SpecializationGroup getParent() {
        return this.parent;
    }

    public List<TypeGuard> getTypeGuards() {
        return this.typeGuards;
    }

    public List<GuardExpression> getGuards() {
        return this.guards;
    }

    public List<SpecializationGroup> getChildren() {
        return this.children;
    }

    public SpecializationData getSpecialization() {
        return this.specialization;
    }

    private static SpecializationGroup combine(List<SpecializationGroup> groups) {
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("empty combinations");
        }
        if (groups.size() == 1) {
            return null;
        }
        ArrayList<TypeGuard> typeGuardsMatches = new ArrayList<TypeGuard>();
        ArrayList<GuardExpression> guardMatches = new ArrayList<GuardExpression>();
        SpecializationGroup first = groups.get(0);
        List<SpecializationGroup> others = groups.subList(1, groups.size());
        block0: for (TypeGuard typeGuard : first.typeGuards) {
            for (SpecializationGroup other : others) {
                if (other.typeGuards.contains(typeGuard)) continue;
                continue block0;
            }
            typeGuardsMatches.add(typeGuard);
        }
        block2: for (GuardExpression guard : first.guards) {
            for (SpecializationGroup other : others) {
                if (other.guards.contains(guard)) continue;
                break block2;
            }
            guardMatches.add(guard);
        }
        Iterator<Object> iterator = guardMatches.iterator();
        while (iterator.hasNext()) {
            GuardExpression guardMatch = (GuardExpression)iterator.next();
            if (guardMatch.getExpression().findBoundVariables().isEmpty()) continue;
            iterator.remove();
        }
        if (typeGuardsMatches.isEmpty() && guardMatches.isEmpty()) {
            return null;
        }
        for (SpecializationGroup group : groups) {
            group.typeGuards.removeAll(typeGuardsMatches);
            group.guards.removeAll(guardMatches);
        }
        ArrayList<SpecializationGroup> newChildren = new ArrayList<SpecializationGroup>(groups);
        return new SpecializationGroup(newChildren, typeGuardsMatches, guardMatches);
    }

    public static SpecializationGroup create(List<SpecializationData> specializations) {
        SpecializationGroup group1;
        ArrayList<SpecializationGroup> groups = new ArrayList<SpecializationGroup>();
        for (SpecializationData specialization : specializations) {
            groups.add(new SpecializationGroup(specialization));
        }
        SpecializationGroup group = group1 = new SpecializationGroup(SpecializationGroup.createCombinationalGroups(groups), Collections.emptyList(), Collections.emptyList());
        while (group.isEmpty() && group.getChildren().size() == 1) {
            group = group.getChildren().iterator().next();
        }
        return group;
    }

    public String toString() {
        return "SpecializationGroup [typeGuards=" + this.typeGuards + ", guards=" + this.guards + "]";
    }

    private static List<SpecializationGroup> createCombinationalGroups(List<SpecializationGroup> groups) {
        if (groups.size() <= 1) {
            return groups;
        }
        ArrayList<SpecializationGroup> newGroups = new ArrayList<SpecializationGroup>();
        int i = 0;
        i = 0;
        while (i < groups.size()) {
            SpecializationGroup newGroup;
            SpecializationGroup combined = null;
            for (int j = groups.size(); j > i + 1 && (combined = SpecializationGroup.combine(groups.subList(i, j))) == null; --j) {
            }
            if (combined == null) {
                newGroup = groups.get(i);
                ++i;
            } else {
                newGroup = combined;
                ArrayList<SpecializationGroup> originalGroups = new ArrayList<SpecializationGroup>(combined.children);
                combined.updateChildren(SpecializationGroup.createCombinationalGroups(originalGroups));
                i += originalGroups.size();
            }
            newGroups.add(newGroup);
        }
        return newGroups;
    }

    public SpecializationGroup getPreviousGroup() {
        if (this.parent == null || this.parent.children.isEmpty()) {
            return null;
        }
        int index = this.parent.children.indexOf(this);
        if (index <= 0) {
            return null;
        }
        return this.parent.children.get(index - 1);
    }

    public int getUncheckedSpecializationIndex() {
        int genericIndex;
        int groupMaxIndex = this.getMaxSpecializationIndex();
        if (groupMaxIndex >= (genericIndex = this.node.getSpecializations().indexOf(this.node.getFallbackSpecialization()))) {
            groupMaxIndex = -1;
        }
        if (groupMaxIndex > -1) {
            int parentMaxIndex = -1;
            if (this.getParent() != null) {
                parentMaxIndex = this.getParent().getMaxSpecializationIndex();
            }
            if (groupMaxIndex == parentMaxIndex) {
                groupMaxIndex = -1;
            }
        }
        return groupMaxIndex;
    }

    public int getMaxSpecializationIndex() {
        if (this.specialization != null) {
            return this.specialization.getNode().getSpecializations().indexOf(this.specialization);
        }
        int max = Integer.MIN_VALUE;
        for (SpecializationGroup childGroup : this.getChildren()) {
            max = Math.max(max, childGroup.getMaxSpecializationIndex());
        }
        return max;
    }

    public SpecializationGroup getPrevious() {
        if (this.getParent() == null) {
            return null;
        }
        List<SpecializationGroup> parentChildren = this.getParent().getChildren();
        int index = parentChildren.indexOf(this);
        if (index <= 0) {
            return null;
        }
        return parentChildren.get(index - 1);
    }

    public List<SpecializationData> getAllSpecializations() {
        SpecializationGroup p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p.collectSpecializations();
    }

    public boolean isLast() {
        SpecializationGroup p = this.getParent();
        if (p == null) {
            return true;
        }
        if (p.getChildren().indexOf(this) == p.getChildren().size() - 1) {
            return p.isLast();
        }
        return false;
    }

    public SpecializationGroup getLast() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public void setFallthrough(boolean hasFallthrough) {
        this.hasFallthrough = hasFallthrough;
    }

    public boolean hasFallthrough() {
        if (this.hasFallthrough) {
            return true;
        }
        SpecializationGroup lastChild = this.getLast();
        if (lastChild != null) {
            return lastChild.hasFallthrough();
        }
        return false;
    }

    public static final class TypeGuard {
        private final TypeSystemData typeSystem;
        private final int signatureIndex;
        private final TypeMirror type;

        public TypeGuard(TypeSystemData typeSystem, TypeMirror type, int signatureIndex) {
            this.typeSystem = typeSystem;
            this.type = type;
            this.signatureIndex = signatureIndex;
        }

        public TypeSystemData getTypeSystem() {
            return this.typeSystem;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.signatureIndex;
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeGuard other = (TypeGuard)obj;
            if (this.signatureIndex != other.signatureIndex) {
                return false;
            }
            return ElementUtils.typeEquals(this.type, other.type);
        }

        public int getSignatureIndex() {
            return this.signatureIndex;
        }

        public TypeMirror getType() {
            return this.type;
        }
    }
}

