/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Timer
implements AutoCloseable {
    private static final Timer DISABLED = new Timer(null, null, null);
    private final String category;
    private final Object key;
    private final long startTime;
    private long endTime;
    private final Timer parent;
    private List<Timer> children;
    private static final ThreadMXBean threadMXBean;

    private Timer(Timer parent, String category, Object key) {
        this.key = key;
        this.category = category;
        this.parent = parent;
        this.startTime = key != null ? Timer.getTimeNS() : 0L;
    }

    long elapsedNS() {
        return this.endTime - this.startTime;
    }

    @Override
    public void close() {
        if (this.key == null) {
            return;
        }
        this.endTime = Timer.getTimeNS();
        if (this.parent != null) {
            if (this.parent.children == null) {
                this.parent.children = new ArrayList<Timer>();
            }
            this.parent.children.add(this);
            ProcessorContext.getInstance().setCurrentTimer(this.parent);
        }
    }

    public void printSummary(PrintStream out, String indent) {
        if (this.key == null) {
            return;
        }
        Timer.printTime(out, indent, this.category, 1, this.elapsedNS());
        Timer.printCategories(out, Arrays.asList(this), indent + "  ");
    }

    private static void printCategories(PrintStream out, List<Timer> all, String indent) {
        HashMap<String, List> categories = new HashMap<String, List>();
        for (Timer timer : all) {
            if (timer.children == null) continue;
            for (Timer timer2 : timer.children) {
                categories.computeIfAbsent(timer2.category, e -> new ArrayList()).add(timer2);
            }
        }
        for (Map.Entry entry : categories.entrySet()) {
            String key = (String)entry.getKey();
            List group = (List)entry.getValue();
            HashSet<Object> element = new HashSet<Object>();
            long elapsedNS = 0L;
            for (Timer timer : group) {
                elapsedNS += timer.elapsedNS();
                element.add(timer.key);
            }
            Timer.printTime(out, indent, key, element.size(), elapsedNS);
            Timer.printCategories(out, group, indent + "  ");
        }
    }

    private static void printTime(PrintStream out, String indent, String key, int count, long elapsedNS) {
        out.printf(String.format("%s %-15s %10.2fms (count %s)%n", indent, key, (double)elapsedNS / 1000000.0, count), new Object[0]);
    }

    public static Timer create(String category, Object key) {
        ProcessorContext context = ProcessorContext.getInstance();
        if (!context.timingsEnabled()) {
            return DISABLED;
        }
        Timer timer = new Timer(context.getCurrentTimer(), category, key);
        context.setCurrentTimer(timer);
        return timer;
    }

    private static long getTimeNS() {
        return threadMXBean != null && threadMXBean.isThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() : System.nanoTime();
    }

    static {
        ThreadMXBean bean = null;
        try {
            bean = ManagementFactory.getThreadMXBean();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        threadMXBean = bean;
    }
}

