/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Template;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class LibraryData
extends Template {
    private final List<LibraryMessage> methods = new ArrayList<LibraryMessage>();
    private final List<LibraryData> superTypes = new ArrayList<LibraryData>();
    private List<TypeMirror> cachedSignature;
    private List<String> cachedSignatureNames;
    private final List<LibraryDefaultExportData> defaultExports = new ArrayList<LibraryDefaultExportData>();
    private TypeMirror signatureReceiverType;
    private TypeMirror exportsReceiverType;
    private TypeMirror assertions;
    private ExportsLibrary objectExports;
    private boolean defaultExportLookupEnabled;
    private boolean dynamicDispatchEnabled = true;
    private boolean pushEncapsulatingNode = true;
    private boolean generateAOT;

    public LibraryData(TypeElement type, AnnotationMirror annotationMirror) {
        super(ProcessorContext.getInstance(), type, annotationMirror);
    }

    public void setGenerateAOT(boolean generateAOT) {
        this.generateAOT = generateAOT;
    }

    public boolean isGenerateAOT() {
        return this.generateAOT;
    }

    public void setPushEncapsulatingNode(boolean pushEncapsulatingNode) {
        this.pushEncapsulatingNode = pushEncapsulatingNode;
    }

    public boolean isPushEncapsulatingNode() {
        return this.pushEncapsulatingNode;
    }

    public void setDynamicDispatchEnabled(boolean dynamicDispatchEnabled) {
        this.dynamicDispatchEnabled = dynamicDispatchEnabled;
    }

    public boolean isDynamicDispatchEnabled() {
        return this.dynamicDispatchEnabled;
    }

    public void setDefaultExportLookupEnabled(boolean defaultExportLookupEnabled) {
        this.defaultExportLookupEnabled = defaultExportLookupEnabled;
    }

    public boolean isDefaultExportLookupEnabled() {
        return this.defaultExportLookupEnabled;
    }

    public void setExportsReceiverType(TypeMirror receiverType) {
        this.exportsReceiverType = receiverType;
    }

    public void setSignatureReceiverType(TypeMirror signatureReceiverType) {
        this.signatureReceiverType = signatureReceiverType;
    }

    public TypeMirror getSignatureReceiverType() {
        return this.signatureReceiverType;
    }

    public TypeMirror getExportsReceiverType() {
        return this.exportsReceiverType;
    }

    public List<LibraryData> getSuperTypes() {
        return this.superTypes;
    }

    public List<LibraryMessage> getMethods() {
        return this.methods;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        return this.methods;
    }

    void setCachedSignatureNames(List<String> cachedSignatureNames) {
        this.cachedSignatureNames = cachedSignatureNames;
    }

    public List<String> getCachedSignatureNames() {
        return this.cachedSignatureNames;
    }

    void setCachedSignature(List<TypeMirror> cachedSignature) {
        this.cachedSignature = cachedSignature;
    }

    public List<TypeMirror> getCachedSignature() {
        return this.cachedSignature;
    }

    public List<LibraryDefaultExportData> getDefaultExports() {
        return this.defaultExports;
    }

    public void setAssertions(TypeMirror assertions) {
        this.assertions = assertions;
    }

    public TypeMirror getAssertions() {
        return this.assertions;
    }

    public boolean isDynamicDispatch() {
        return this.getTemplateType().getSimpleName().toString().equals(this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
    }

    void setObjectExports(ExportsLibrary objectExports) {
        this.objectExports = objectExports;
    }

    public ExportsLibrary getObjectExports() {
        return this.objectExports;
    }

    public LibraryDefaultExportData getBuiltinDefaultExport(TypeMirror receiverType) {
        for (LibraryDefaultExportData export : this.defaultExports) {
            if (export.isDefaultObjectExport()) continue;
            if (ElementUtils.isAssignable(export.getReceiverType(), receiverType)) {
                return export;
            }
            if (!ElementUtils.isAssignable(ProcessorContext.getInstance().getType(Object.class), export.getReceiverType())) continue;
            return export;
        }
        return null;
    }
}

