/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AbstractRegistrationProcessor;
import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleProcessorOptions;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.generator.StaticConstants;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsGenerator;
import com.oracle.truffle.dsl.processor.library.ExportsParser;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryGenerator;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import com.oracle.truffle.dsl.processor.parser.TypeSystemParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class TruffleProcessor
extends AbstractProcessor
implements ProcessorContext.ProcessCallback {
    private final Map<String, Map<String, Element>> serviceRegistrations = new LinkedHashMap<String, Map<String, Element>>();
    private final ThreadLocal<List<AnnotationProcessor<?>>> currentProcessors = new ThreadLocal();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorContext.enter(this.processingEnv, this);
            if (roundEnv.processingOver()) {
                for (Map.Entry<String, Map<String, Element>> element : this.serviceRegistrations.entrySet()) {
                    AbstractRegistrationProcessor.generateServicesRegistration(element.getKey(), element.getValue());
                }
                this.serviceRegistrations.clear();
                boolean bl = true;
                return bl;
            }
            List<AnnotationProcessor<?>> processors = TruffleProcessor.createGenerators();
            this.currentProcessors.set(processors);
            for (AnnotationProcessor<?> generator : processors) {
                Object e22;
                AbstractParser<?> parser = generator.getParser();
                if (parser.getAnnotationType() != null) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(parser.getAnnotationType()))) {
                        TruffleProcessor.processElement(generator, element, false);
                    }
                    DeclaredType repeat = parser.getRepeatAnnotationType();
                    if (repeat != null) {
                        for (Object e22 : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(repeat))) {
                            TruffleProcessor.processElement(generator, (Element)e22, false);
                        }
                    }
                }
                for (DeclaredType declaredType : parser.getTypeDelegatedAnnotationTypes()) {
                    e22 = roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(declaredType)).iterator();
                    while (e22.hasNext()) {
                        Element element = e22.next();
                        Optional<TypeElement> processedType = parser.isDelegateToRootDeclaredType() ? ElementUtils.findRootEnclosingType(element) : ElementUtils.findParentEnclosingType(element);
                        TruffleProcessor.processElement(generator, processedType.orElseThrow(AssertionError::new), false);
                    }
                }
                for (AnnotationProcessor annotationProcessor : processors) {
                    e22 = annotationProcessor.getServiceRegistrations().entrySet().iterator();
                    while (e22.hasNext()) {
                        Map.Entry entry = (Map.Entry)e22.next();
                        Map<String, Element> currentElements = this.serviceRegistrations.get(entry.getKey());
                        if (currentElements == null) {
                            currentElements = new LinkedHashMap<String, Element>((Map)entry.getValue());
                            this.serviceRegistrations.put((String)entry.getKey(), currentElements);
                            continue;
                        }
                        currentElements.putAll((Map)entry.getValue());
                    }
                }
                for (Map.Entry entry : this.serviceRegistrations.entrySet()) {
                    String service = (String)entry.getKey();
                    for (Map.Entry serviceElement : ((Map)entry.getValue()).entrySet()) {
                        if (!AbstractRegistrationProcessor.shouldGenerateProviderFiles((Element)serviceElement.getValue())) continue;
                        AbstractRegistrationProcessor.generateProviderFile(this.processingEnv, (String)serviceElement.getKey(), service, (Element)serviceElement.getValue());
                    }
                }
            }
        }
        finally {
            ProcessorContext.leave();
            this.currentProcessors.set(null);
        }
        return false;
    }

    private static void processElement(AnnotationProcessor<?> generator, Element e, boolean callback) {
        try {
            generator.process(e, callback);
        }
        catch (Throwable e1) {
            TruffleProcessor.handleThrowable(generator, e1, e);
        }
    }

    static void handleThrowable(AnnotationProcessor<?> generator, Throwable t, Element e) {
        String message = "Uncaught error in " + (generator != null ? generator.getClass().getSimpleName() : null) + " while processing " + e + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return TruffleProcessorOptions.getSupportedOptions();
    }

    @Override
    public void callback(TypeElement template) {
        for (AnnotationProcessor<?> generator : this.currentProcessors.get()) {
            AnnotationMirror annotation;
            DeclaredType annotationType = generator.getParser().getAnnotationType();
            if (annotationType == null || (annotation = ElementUtils.findAnnotationMirror((Element)template, (TypeMirror)annotationType)) == null) continue;
            TruffleProcessor.processElement(generator, template, true);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("com.oracle.truffle.api.dsl.Specialization");
        annotations.add("com.oracle.truffle.api.dsl.Fallback");
        annotations.add("com.oracle.truffle.api.dsl.TypeSystemReference");
        annotations.add("com.oracle.truffle.api.dsl.Executed");
        annotations.add("com.oracle.truffle.api.dsl.NodeChild");
        annotations.add("com.oracle.truffle.api.dsl.NodeChildren");
        annotations.add("com.oracle.truffle.api.dsl.TypeSystem");
        annotations.add("com.oracle.truffle.api.library.GenerateLibrary");
        annotations.add("com.oracle.truffle.api.library.ExportLibrary");
        annotations.add("com.oracle.truffle.api.library.ExportMessage");
        annotations.add("com.oracle.truffle.api.library.ExportLibrary.Repeat");
        return annotations;
    }

    private static List<AnnotationProcessor<?>> createGenerators() {
        ArrayList generators = new ArrayList();
        generators.add(new AnnotationProcessor<TypeSystemData>(new TypeSystemParser(), new TypeSystemCodeGenerator()));
        generators.add(new AnnotationProcessor<NodeData>(NodeParser.createDefaultParser(), new NodeCodeGenerator()));
        generators.add(new AnnotationProcessor<LibraryData>(new LibraryParser(), new LibraryGenerator()));
        generators.add(new AnnotationProcessor<ExportsData>(new ExportsParser(), new ExportsGenerator(new StaticConstants())));
        return generators;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        super.init(env);
    }
}

