/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ModuleCache {
    private static final Map<ProcessingEnvironment, Map<String, ModuleElement>> moduleCacheCleaner = new WeakHashMap<ProcessingEnvironment, Map<String, ModuleElement>>();

    private ModuleCache() {
        throw new IllegalStateException("Cannot instantiate.");
    }

    static TypeElement getTypeElement(ProcessingEnvironment processingEnv, CharSequence typeName) {
        String typeNameString;
        if (processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 0) {
            return processingEnv.getElementUtils().getTypeElement(typeName);
        }
        Map<String, ModuleElement> moduleCache = moduleCacheCleaner.computeIfAbsent(processingEnv, new Function<ProcessingEnvironment, Map<String, ModuleElement>>(){

            @Override
            public Map<String, ModuleElement> apply(ProcessingEnvironment t) {
                return new HashMap<String, ModuleElement>();
            }
        });
        ModuleElement moduleElement = moduleCache.get(typeNameString = typeName.toString());
        if (moduleElement == null) {
            TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(typeName);
            if (typeElement != null) {
                moduleElement = processingEnv.getElementUtils().getModuleOf(typeElement);
                moduleCache.put(typeNameString, moduleElement);
            }
            return typeElement;
        }
        return processingEnv.getElementUtils().getTypeElement(moduleElement, typeName);
    }
}

