/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor.model;

import com.oracle.truffle.object.dsl.processor.model.PropertyModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class LayoutModel {
    private final TypeMirror objectTypeSuperclass;
    private final LayoutModel superLayout;
    private final String name;
    private final String packageName;
    private final String interfaceFullName;
    private final boolean hasObjectTypeGuard;
    private final boolean hasObjectGuard;
    private final boolean hasDynamicObjectGuard;
    private final boolean hasBuilder;
    private final List<PropertyModel> properties;
    private final List<VariableElement> implicitCasts;
    private final TypeMirror dispatch;

    public LayoutModel(TypeMirror objectTypeSuperclass, LayoutModel superLayout, String name, String packageName, boolean hasObjectTypeGuard, boolean hasObjectGuard, boolean hasDynamicObjectGuard, boolean hasBuilder, Collection<PropertyModel> properties, String interfaceFullName, Collection<VariableElement> implicitCasts, TypeMirror dispatch) {
        this.objectTypeSuperclass = objectTypeSuperclass;
        this.superLayout = superLayout;
        this.name = name;
        this.packageName = packageName;
        this.interfaceFullName = interfaceFullName;
        this.hasObjectTypeGuard = hasObjectTypeGuard;
        this.hasObjectGuard = hasObjectGuard;
        this.hasDynamicObjectGuard = hasDynamicObjectGuard;
        this.hasBuilder = hasBuilder;
        this.properties = Collections.unmodifiableList(new ArrayList<PropertyModel>(properties));
        this.implicitCasts = Collections.unmodifiableList(new ArrayList<VariableElement>(implicitCasts));
        this.dispatch = dispatch;
    }

    public TypeMirror getObjectTypeSuperclass() {
        return this.objectTypeSuperclass;
    }

    public LayoutModel getSuperLayout() {
        return this.superLayout;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInterfaceFullName() {
        return this.interfaceFullName;
    }

    public boolean hasObjectTypeGuard() {
        return this.hasObjectTypeGuard;
    }

    public boolean hasObjectGuard() {
        return this.hasObjectGuard;
    }

    public boolean hasDynamicObjectGuard() {
        return this.hasDynamicObjectGuard;
    }

    public boolean hasBuilder() {
        return this.hasBuilder;
    }

    public boolean hasInstanceProperties() {
        return !this.getAllInstanceProperties().isEmpty();
    }

    public boolean hasShapeProperties() {
        return !this.getAllShapeProperties().isEmpty();
    }

    public boolean hasProperty(String propertyName) {
        for (PropertyModel property : this.getAllProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public List<PropertyModel> getProperties() {
        return this.selectProperties(true, true, false, true, false);
    }

    public List<PropertyModel> getInstanceProperties() {
        return this.selectProperties(true, false, false, true, false);
    }

    public List<PropertyModel> getShapeProperties() {
        return this.selectProperties(false, true, false, true, false);
    }

    public List<PropertyModel> getAllProperties() {
        return this.selectProperties(true, true, false, true, true);
    }

    public List<PropertyModel> getAllInstanceProperties() {
        return this.selectProperties(true, false, false, true, true);
    }

    public List<PropertyModel> getInheritedShapeProperties() {
        return this.selectProperties(false, true, false, false, true);
    }

    public List<PropertyModel> getAllShapeProperties() {
        return this.selectProperties(false, true, false, true, true);
    }

    public boolean hasVolatileProperties() {
        return !this.selectProperties(true, true, true, true, false).isEmpty();
    }

    public boolean hasNonNullableInstanceProperties() {
        for (PropertyModel property : this.properties) {
            if (property.isNullable() || !property.isInstanceProperty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFinalInstanceProperties() {
        for (PropertyModel property : this.properties) {
            if (!property.isFinal() || !property.isInstanceProperty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGettersOrSetters() {
        for (PropertyModel property : this.properties) {
            if (!property.hasGetter() && !property.hasSetter()) continue;
            return true;
        }
        return false;
    }

    public List<VariableElement> getImplicitCasts() {
        return this.implicitCasts;
    }

    private List<PropertyModel> selectProperties(boolean instance, boolean shape, boolean onlyVolatile, boolean declared, boolean inherited) {
        ArrayList<PropertyModel> selectedProperties = new ArrayList<PropertyModel>();
        if (inherited && this.superLayout != null) {
            selectedProperties.addAll(this.superLayout.selectProperties(instance, shape, onlyVolatile, true, inherited));
        }
        if (declared) {
            for (PropertyModel property : this.properties) {
                if (property.isInstanceProperty() && !instance || property.isShapeProperty() && !shape || !property.isVolatile() && onlyVolatile) continue;
                selectedProperties.add(property);
            }
        }
        return Collections.unmodifiableList(selectedProperties);
    }

    public TypeMirror getDispatch() {
        return this.dispatch;
    }
}

