// CheckStyle: start generated
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.host.HostContext.ToGuestValueNode;
import com.oracle.truffle.host.HostContextFactory.ToGuestValueNodeGen;
import com.oracle.truffle.host.HostExecuteNode.HostMethodProfileNode;
import com.oracle.truffle.host.HostExecuteNode.TypeCheckNode;
import com.oracle.truffle.host.HostMethodDesc.OverloadedMethod;
import com.oracle.truffle.host.HostMethodDesc.SingleMethod;
import com.oracle.truffle.host.HostMethodDesc.SingleMethod.MHBase;
import com.oracle.truffle.host.HostMethodDesc.SingleMethod.ReflectBase;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link HostExecuteNode#doFixed}
 *     Activation probability: 0.32000
 *     With/without class size: 18/21 bytes
 *   Specialization {@link HostExecuteNode#doVarArgs}
 *     Activation probability: 0.26000
 *     With/without class size: 15/22 bytes
 *   Specialization {@link HostExecuteNode#doSingleUncached}
 *     Activation probability: 0.20000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link HostExecuteNode#doOverloadedCached}
 *     Activation probability: 0.14000
 *     With/without class size: 11/34 bytes
 *   Specialization {@link HostExecuteNode#doOverloadedUncached}
 *     Activation probability: 0.08000
 *     With/without class size: 5/0 bytes
 * </pre> */
@GeneratedBy(HostExecuteNode.class)
@SuppressWarnings("javadoc")
final class HostExecuteNodeGen {

    private static final StateField FIXED_HOST_EXECUTE_NODE_FIXED_STATE_0_UPDATER = StateField.create(FixedData.lookup_(), "fixed_state_0_");
    private static final StateField VAR_ARGS_HOST_EXECUTE_NODE_VAR_ARGS_STATE_0_UPDATER = StateField.create(VarArgsData.lookup_(), "varArgs_state_0_");
    private static final StateField OVERLOADED_CACHED_HOST_EXECUTE_NODE_OVERLOADED_CACHED_STATE_0_UPDATER = StateField.create(OverloadedCachedData.lookup_(), "overloadedCached_state_0_");
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException5(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    @NeverDefault
    public static HostExecuteNode getUncached() {
        return HostExecuteNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#toHost_field1_}
     * <li>{@link Inlined#toGuest_field1_}
     * <li>{@link Inlined#cache}
     * <li>{@link Inlined#fixed_cache}
     * <li>{@link Inlined#varArgs_cache}
     * <li>{@link Inlined#overloadedCached_cache}
     * </ul> */
    @NeverDefault
    public static HostExecuteNode inline(@RequiredField(bits = 17, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Object.class, value = ReferenceField.class)@RequiredField(type = Object.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new HostExecuteNodeGen.Inlined(target);
    }

    @GeneratedBy(HostExecuteNode.class)
    @DenyReplace
    private static final class Inlined extends HostExecuteNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link HostExecuteNode#doFixed}
         *   1: SpecializationActive {@link HostExecuteNode#doSingleUncached}
         *   2: SpecializationActive {@link HostExecuteNode#doVarArgs}
         *   3: SpecializationActive {@link HostExecuteNode#doOverloadedCached}
         *   4: SpecializationActive {@link HostExecuteNode#doOverloadedUncached}
         *   5: InlinedCache
         *        Specialization: {@link HostExecuteNode#doFixed}
         *        Parameter: {@link InlinedBranchProfile} errorBranch
         *        Inline method: {@link InlinedBranchProfile#inline}
         *   6: InlinedCache
         *        Specialization: {@link HostExecuteNode#doFixed}
         *        Parameter: {@link InlinedBranchProfile} seenDynamicScope
         *        Inline method: {@link InlinedBranchProfile#inline}
         *   7-8: InlinedCache
         *        Specialization: {@link HostExecuteNode#doSingleUncached}
         *        Parameter: {@link HostToTypeNode} toJavaNode
         *        Inline method: {@link HostToTypeNodeGen#inline}
         *   9-11: InlinedCache
         *        Specialization: {@link HostExecuteNode#doSingleUncached}
         *        Parameter: {@link ToGuestValueNode} toGuest
         *        Inline method: {@link ToGuestValueNodeGen#inline}
         *   12-13: InlinedCache
         *        Specialization: {@link HostExecuteNode#doSingleUncached}
         *        Parameter: {@link InlinedConditionProfile} isVarArgsProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   14-16: InlinedCache
         *        Specialization: {@link HostExecuteNode#doSingleUncached}
         *        Parameter: {@link HostMethodProfileNode} methodProfile
         *        Inline method: {@link HostMethodProfileNodeGen#inline}
         * </pre> */
        private final StateField state_0_;
        private final ReferenceField<Node> toHost_field1_;
        private final ReferenceField<Object> toGuest_field1_;
        private final ReferenceField<GuestToHostCodeCache> cache;
        private final ReferenceField<FixedData> fixed_cache;
        private final ReferenceField<VarArgsData> varArgs_cache;
        private final ReferenceField<OverloadedCachedData> overloadedCached_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedBranchProfile} errorBranch
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile errorBranch;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedBranchProfile} seenDynamicScope
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile seenScope;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doSingleUncached}
         *   Parameter: {@link HostToTypeNode} toJavaNode
         *   Inline method: {@link HostToTypeNodeGen#inline}</pre> */
        private final HostToTypeNode toHost;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doSingleUncached}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}</pre> */
        private final ToGuestValueNode toGuest;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doSingleUncached}
         *   Parameter: {@link InlinedConditionProfile} isVarArgsProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
        private final InlinedConditionProfile varArgsProfile;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doSingleUncached}
         *   Parameter: {@link HostMethodProfileNode} methodProfile
         *   Inline method: {@link HostMethodProfileNodeGen#inline}</pre> */
        private final HostMethodProfileNode hostMethodProfile;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}</pre> */
        private final ToGuestValueNode fixed_toGuest_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}</pre> */
        private final InlinedExactClassProfile fixed_receiverProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedBranchProfile} errorBranch
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile fixed_errorBranch_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedBranchProfile} seenDynamicScope
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile fixed_seenScope_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link HostToTypeNode} toJavaNode
         *   Inline method: {@link HostToTypeNodeGen#inline}</pre> */
        private final HostToTypeNode varArgs_toJavaNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}</pre> */
        private final ToGuestValueNode varArgs_toGuest_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}</pre> */
        private final InlinedExactClassProfile varArgs_receiverProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link InlinedBranchProfile} errorBranch
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile varargs_errorBranch_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link InlinedBranchProfile} seenDynamicScope
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile varargs_seenScope_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link HostToTypeNode} toJavaNode
         *   Inline method: {@link HostToTypeNodeGen#inline}</pre> */
        private final HostToTypeNode overloadedCached_toJavaNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}</pre> */
        private final ToGuestValueNode overloadedCached_toGuest_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}</pre> */
        private final InlinedExactClassProfile overloadedCached_receiverProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link InlinedBranchProfile} errorBranch
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile overloadedcached_errorBranch_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link InlinedBranchProfile} seenVariableScope
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile overloadedcached_seenScope_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(HostExecuteNode.class);
            this.state_0_ = target.getState(0, 17);
            this.toHost_field1_ = target.getReference(1, Node.class);
            this.toGuest_field1_ = target.getReference(2, Object.class);
            this.cache = target.getReference(3, GuestToHostCodeCache.class);
            this.fixed_cache = target.getReference(4, FixedData.class);
            this.varArgs_cache = target.getReference(5, VarArgsData.class);
            this.overloadedCached_cache = target.getReference(6, OverloadedCachedData.class);
            this.errorBranch = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(5, 1)));
            this.seenScope = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(6, 1)));
            this.toHost = HostToTypeNodeGen.inline(InlineTarget.create(HostToTypeNode.class, state_0_.subUpdater(7, 2), toHost_field1_));
            this.toGuest = ToGuestValueNodeGen.inline(InlineTarget.create(ToGuestValueNode.class, state_0_.subUpdater(9, 3), toGuest_field1_));
            this.varArgsProfile = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
            this.hostMethodProfile = HostMethodProfileNodeGen.inline(InlineTarget.create(HostMethodProfileNode.class, state_0_.subUpdater(14, 3)));
            this.fixed_toGuest_ = ToGuestValueNodeGen.inline(InlineTarget.create(ToGuestValueNode.class, FIXED_HOST_EXECUTE_NODE_FIXED_STATE_0_UPDATER.subUpdater(0, 3), ReferenceField.create(FixedData.lookup_(), "fixed_toGuest__field1_", Object.class)));
            this.fixed_receiverProfile_ = InlinedExactClassProfile.inline(InlineTarget.create(InlinedExactClassProfile.class, FIXED_HOST_EXECUTE_NODE_FIXED_STATE_0_UPDATER.subUpdater(3, 2), ReferenceField.create(FixedData.lookup_(), "fixed_receiverProfile__field1_", Class.class)));
            this.fixed_errorBranch_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(5, 1)));
            this.fixed_seenScope_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(6, 1)));
            this.varArgs_toJavaNode_ = HostToTypeNodeGen.inline(InlineTarget.create(HostToTypeNode.class, VAR_ARGS_HOST_EXECUTE_NODE_VAR_ARGS_STATE_0_UPDATER.subUpdater(0, 2), ReferenceField.create(VarArgsData.lookup_(), "varArgs_toJavaNode__field1_", Node.class)));
            this.varArgs_toGuest_ = ToGuestValueNodeGen.inline(InlineTarget.create(ToGuestValueNode.class, VAR_ARGS_HOST_EXECUTE_NODE_VAR_ARGS_STATE_0_UPDATER.subUpdater(2, 3), ReferenceField.create(VarArgsData.lookup_(), "varArgs_toGuest__field1_", Object.class)));
            this.varArgs_receiverProfile_ = InlinedExactClassProfile.inline(InlineTarget.create(InlinedExactClassProfile.class, VAR_ARGS_HOST_EXECUTE_NODE_VAR_ARGS_STATE_0_UPDATER.subUpdater(5, 2), ReferenceField.create(VarArgsData.lookup_(), "varArgs_receiverProfile__field1_", Class.class)));
            this.varargs_errorBranch_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(5, 1)));
            this.varargs_seenScope_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(6, 1)));
            this.overloadedCached_toJavaNode_ = HostToTypeNodeGen.inline(InlineTarget.create(HostToTypeNode.class, OVERLOADED_CACHED_HOST_EXECUTE_NODE_OVERLOADED_CACHED_STATE_0_UPDATER.subUpdater(0, 2), ReferenceField.create(OverloadedCachedData.lookup_(), "overloadedCached_toJavaNode__field1_", Node.class)));
            this.overloadedCached_toGuest_ = ToGuestValueNodeGen.inline(InlineTarget.create(ToGuestValueNode.class, OVERLOADED_CACHED_HOST_EXECUTE_NODE_OVERLOADED_CACHED_STATE_0_UPDATER.subUpdater(2, 3), ReferenceField.create(OverloadedCachedData.lookup_(), "overloadedCached_toGuest__field1_", Object.class)));
            this.overloadedCached_receiverProfile_ = InlinedExactClassProfile.inline(InlineTarget.create(InlinedExactClassProfile.class, OVERLOADED_CACHED_HOST_EXECUTE_NODE_OVERLOADED_CACHED_STATE_0_UPDATER.subUpdater(5, 2), ReferenceField.create(OverloadedCachedData.lookup_(), "overloadedCached_receiverProfile__field1_", Class.class)));
            this.overloadedcached_errorBranch_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(5, 1)));
            this.overloadedcached_seenScope_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(6, 1)));
        }

        @ExplodeLoop
        @Override
        public Object execute(Node arg0Value, HostMethodDesc arg1Value, Object arg2Value, Object[] arg3Value, HostContext arg4Value) throws UnsupportedTypeException, ArityException {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[HostExecuteNode.doFixed(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode[], ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doVarArgs(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode, ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, boolean, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doOverloadedCached(Node, OverloadedMethod, Object, Object[], HostContext, OverloadedMethod, HostToTypeNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doOverloadedUncached(Node, OverloadedMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */) {
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[HostExecuteNode.doFixed(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode[], ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doVarArgs(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode, ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, boolean, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */ && arg1Value instanceof SingleMethod) {
                    SingleMethod arg1Value_ = (SingleMethod) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[HostExecuteNode.doFixed(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode[], ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */ && (!(arg1Value_.isVarArgs()))) {
                        FixedData s0_ = this.fixed_cache.get(arg0Value);
                        while (s0_ != null) {
                            if ((arg1Value_ == s0_.cachedMethod_)) {
                                return HostExecuteNode.doFixed(s0_, arg1Value_, arg2Value, arg3Value, arg4Value, s0_.cachedMethod_, s0_.toJavaNodes_, this.fixed_toGuest_, this.fixed_receiverProfile_, this.fixed_errorBranch_, this.fixed_seenScope_, s0_.cache_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[HostExecuteNode.doVarArgs(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode, ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, boolean, GuestToHostCodeCache)] */ && (arg1Value_.isVarArgs())) {
                        VarArgsData s1_ = this.varArgs_cache.get(arg0Value);
                        while (s1_ != null) {
                            if ((arg1Value_ == s1_.cachedMethod_)) {
                                return HostExecuteNode.doVarArgs(s1_, arg1Value_, arg2Value, arg3Value, arg4Value, s1_.cachedMethod_, this.varArgs_toJavaNode_, this.varArgs_toGuest_, this.varArgs_receiverProfile_, this.varargs_errorBranch_, this.varargs_seenScope_, s1_.asVarArgs_, s1_.cache_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */) {
                        {
                            GuestToHostCodeCache cache_ = this.cache.get(arg0Value);
                            if (cache_ != null) {
                                return HostExecuteNode.doSingleUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.seenScope, cache_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[HostExecuteNode.doOverloadedCached(Node, OverloadedMethod, Object, Object[], HostContext, OverloadedMethod, HostToTypeNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] || SpecializationActive[HostExecuteNode.doOverloadedUncached(Node, OverloadedMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */ && arg1Value instanceof OverloadedMethod) {
                    OverloadedMethod arg1Value_ = (OverloadedMethod) arg1Value;
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[HostExecuteNode.doOverloadedCached(Node, OverloadedMethod, Object, Object[], HostContext, OverloadedMethod, HostToTypeNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */) {
                        OverloadedCachedData s3_ = this.overloadedCached_cache.get(arg0Value);
                        while (s3_ != null) {
                            if ((arg1Value_ == s3_.cachedMethod_) && (HostExecuteNode.checkArgTypes(arg3Value, s3_.cachedArgTypes_, s3_.interop_, arg4Value, s3_.asVarArgs_))) {
                                return HostExecuteNode.doOverloadedCached(s3_, arg1Value_, arg2Value, arg3Value, arg4Value, s3_.cachedMethod_, this.overloadedCached_toJavaNode_, this.overloadedCached_toGuest_, s3_.interop_, s3_.cachedArgTypes_, s3_.overload_, s3_.asVarArgs_, this.overloadedCached_receiverProfile_, this.overloadedcached_errorBranch_, this.overloadedcached_seenScope_, s3_.cache_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[HostExecuteNode.doOverloadedUncached(Node, OverloadedMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */) {
                        {
                            GuestToHostCodeCache cache_1 = this.cache.get(arg0Value);
                            if (cache_1 != null) {
                                return HostExecuteNode.doOverloadedUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.seenScope, cache_1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @SuppressWarnings("unused")
        private Object executeAndSpecialize(Node arg0Value, HostMethodDesc arg1Value, Object arg2Value, Object[] arg3Value, HostContext arg4Value) throws ArityException, UnsupportedTypeException {
            int state_0 = this.state_0_.get(arg0Value);
            int oldState_0 = (state_0 & 0b11111);
            int oldCacheCount = countCaches(arg0Value);
            try {
                if (arg1Value instanceof SingleMethod) {
                    SingleMethod arg1Value_ = (SingleMethod) arg1Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */ && (!(arg1Value_.isVarArgs()))) {
                        while (true) {
                            int count0_ = 0;
                            FixedData s0_ = this.fixed_cache.getVolatile(arg0Value);
                            FixedData s0_original = s0_;
                            while (s0_ != null) {
                                if ((arg1Value_ == s0_.cachedMethod_)) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (arg1Value_ == s0_.cachedMethod_);
                                if (count0_ < (HostExecuteNode.LIMIT)) {
                                    s0_ = arg0Value.insert(new FixedData(s0_original));
                                    s0_.cachedMethod_ = (arg1Value_);
                                    s0_.toJavaNodes_ = s0_.insert((HostExecuteNode.createToHost(arg1Value_.getParameterCount())));
                                    GuestToHostCodeCache cache__ = (arg4Value.getGuestToHostCache());
                                    Objects.requireNonNull(cache__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.cache_ = cache__;
                                    if (!this.fixed_cache.compareAndSet(arg0Value, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[HostExecuteNode.doFixed(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode[], ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                }
                            }
                            if (s0_ != null) {
                                return HostExecuteNode.doFixed(s0_, arg1Value_, arg2Value, arg3Value, arg4Value, s0_.cachedMethod_, s0_.toJavaNodes_, this.fixed_toGuest_, this.fixed_receiverProfile_, this.fixed_errorBranch_, this.fixed_seenScope_, s0_.cache_);
                            }
                            break;
                        }
                    }
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */ && (arg1Value_.isVarArgs())) {
                        while (true) {
                            int count1_ = 0;
                            VarArgsData s1_ = this.varArgs_cache.getVolatile(arg0Value);
                            VarArgsData s1_original = s1_;
                            while (s1_ != null) {
                                if ((arg1Value_ == s1_.cachedMethod_)) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (arg1Value_ == s1_.cachedMethod_);
                                if (count1_ < (HostExecuteNode.LIMIT)) {
                                    s1_ = arg0Value.insert(new VarArgsData(s1_original));
                                    s1_.cachedMethod_ = (arg1Value_);
                                    s1_.asVarArgs_ = (HostExecuteNode.asVarArgs(arg3Value, s1_.cachedMethod_, arg4Value));
                                    GuestToHostCodeCache cache__1 = (arg4Value.getGuestToHostCache());
                                    Objects.requireNonNull(cache__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.cache_ = cache__1;
                                    if (!this.varArgs_cache.compareAndSet(arg0Value, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[HostExecuteNode.doVarArgs(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode, ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, boolean, GuestToHostCodeCache)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                }
                            }
                            if (s1_ != null) {
                                return HostExecuteNode.doVarArgs(s1_, arg1Value_, arg2Value, arg3Value, arg4Value, s1_.cachedMethod_, this.varArgs_toJavaNode_, this.varArgs_toGuest_, this.varArgs_receiverProfile_, this.varargs_errorBranch_, this.varargs_seenScope_, s1_.asVarArgs_, s1_.cache_);
                            }
                            break;
                        }
                    }
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache.get(arg0Value);
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg4Value.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.cache.set(arg0Value, cache_);
                    }
                    this.fixed_cache.set(arg0Value, null);
                    this.varArgs_cache.set(arg0Value, null);
                    state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[HostExecuteNode.doFixed(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode[], ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)], SpecializationActive[HostExecuteNode.doVarArgs(Node, SingleMethod, Object, Object[], HostContext, SingleMethod, HostToTypeNode, ToGuestValueNode, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, boolean, GuestToHostCodeCache)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[HostExecuteNode.doSingleUncached(Node, SingleMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return HostExecuteNode.doSingleUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.seenScope, cache_);
                }
                if (arg1Value instanceof OverloadedMethod) {
                    OverloadedMethod arg1Value_ = (OverloadedMethod) arg1Value;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[HostExecuteNode.doOverloadedUncached(Node, OverloadedMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */) {
                        while (true) {
                            int count3_ = 0;
                            OverloadedCachedData s3_ = this.overloadedCached_cache.getVolatile(arg0Value);
                            OverloadedCachedData s3_original = s3_;
                            while (s3_ != null) {
                                if ((arg1Value_ == s3_.cachedMethod_) && (HostExecuteNode.checkArgTypes(arg3Value, s3_.cachedArgTypes_, s3_.interop_, arg4Value, s3_.asVarArgs_))) {
                                    break;
                                }
                                count3_++;
                                s3_ = s3_.next_;
                            }
                            if (s3_ == null) {
                                {
                                    InteropLibrary interop__ = arg0Value.insert((INTEROP_LIBRARY_.createDispatched(HostExecuteNode.LIMIT)));
                                    TypeCheckNode[] cachedArgTypes__ = arg0Value.insert((HostExecuteNode.createArgTypesArray(arg3Value)));
                                    s3_ = arg0Value.insert(new OverloadedCachedData(s3_original));
                                    SingleMethod overload__ = (HostExecuteNode.selectOverload(s3_, arg1Value_, arg3Value, arg4Value, cachedArgTypes__));
                                    boolean asVarArgs__ = (HostExecuteNode.asVarArgs(arg3Value, overload__, arg4Value));
                                    // assert (arg1Value_ == s3_.cachedMethod_);
                                    if ((HostExecuteNode.checkArgTypes(arg3Value, cachedArgTypes__, interop__, arg4Value, asVarArgs__)) && count3_ < (HostExecuteNode.LIMIT)) {
                                        s3_.cachedMethod_ = (arg1Value_);
                                        Objects.requireNonNull(s3_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s3_.interop_ = interop__;
                                        s3_.cachedArgTypes_ = s3_.insert(cachedArgTypes__);
                                        s3_.overload_ = overload__;
                                        s3_.asVarArgs_ = asVarArgs__;
                                        GuestToHostCodeCache cache__2 = (arg4Value.getGuestToHostCache());
                                        Objects.requireNonNull(cache__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s3_.cache_ = cache__2;
                                        if (!this.overloadedCached_cache.compareAndSet(arg0Value, s3_original, s3_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[HostExecuteNode.doOverloadedCached(Node, OverloadedMethod, Object, Object[], HostContext, OverloadedMethod, HostToTypeNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */;
                                        this.state_0_.set(arg0Value, state_0);
                                    } else {
                                        s3_ = null;
                                    }
                                }
                            }
                            if (s3_ != null) {
                                return HostExecuteNode.doOverloadedCached(s3_, arg1Value_, arg2Value, arg3Value, arg4Value, s3_.cachedMethod_, this.overloadedCached_toJavaNode_, this.overloadedCached_toGuest_, s3_.interop_, s3_.cachedArgTypes_, s3_.overload_, s3_.asVarArgs_, this.overloadedCached_receiverProfile_, this.overloadedcached_errorBranch_, this.overloadedcached_seenScope_, s3_.cache_);
                            }
                            break;
                        }
                    }
                    GuestToHostCodeCache cache_1;
                    GuestToHostCodeCache cache_1_shared = this.cache.get(arg0Value);
                    if (cache_1_shared != null) {
                        cache_1 = cache_1_shared;
                    } else {
                        cache_1 = (arg4Value.getGuestToHostCache());
                        if (cache_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.cache.set(arg0Value, cache_1);
                    }
                    this.overloadedCached_cache.set(arg0Value, null);
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[HostExecuteNode.doOverloadedCached(Node, OverloadedMethod, Object, Object[], HostContext, OverloadedMethod, HostToTypeNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, InlinedExactClassProfile, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[HostExecuteNode.doOverloadedUncached(Node, OverloadedMethod, Object, Object[], HostContext, HostToTypeNode, ToGuestValueNode, InlinedConditionProfile, HostMethodProfileNode, InlinedBranchProfile, InlinedBranchProfile, GuestToHostCodeCache)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return HostExecuteNode.doOverloadedUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.seenScope, cache_1);
                }
                throw newUnsupportedSpecializationException5(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (oldState_0 != 0) {
                    checkForPolymorphicSpecialize(arg0Value, oldState_0, oldCacheCount);
                }
            }
        }

        private void checkForPolymorphicSpecialize(Node arg0Value, int oldState_0, int oldCacheCount) {
            int state_0 = this.state_0_.get(arg0Value);
            int newState_0 = (state_0 & 0b11111);
            if (((oldState_0 ^ newState_0) != 0) || oldCacheCount < countCaches(arg0Value)) {
                arg0Value.reportPolymorphicSpecialize();
            }
        }

        private int countCaches(Node arg0Value) {
            int cacheCount = 0;
            FixedData s0_ = this.fixed_cache.get(arg0Value);
            while (s0_ != null) {
                cacheCount++;
                s0_ = s0_.next_;
            }
            VarArgsData s1_ = this.varArgs_cache.get(arg0Value);
            while (s1_ != null) {
                cacheCount++;
                s1_ = s1_.next_;
            }
            OverloadedCachedData s3_ = this.overloadedCached_cache.get(arg0Value);
            while (s3_ != null) {
                cacheCount++;
                s3_ = s3_.next_;
            }
            return cacheCount;
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    @DenyReplace
    private static final class FixedData extends Node implements SpecializationDataNode {

        @Child FixedData next_;
        /**
         * State Info: <pre>
         *   0-2: InlinedCache
         *        Specialization: {@link HostExecuteNode#doFixed}
         *        Parameter: {@link ToGuestValueNode} toGuest
         *        Inline method: {@link ToGuestValueNodeGen#inline}
         *   3-4: InlinedCache
         *        Specialization: {@link HostExecuteNode#doFixed}
         *        Parameter: {@link InlinedExactClassProfile} receiverProfile
         *        Inline method: {@link InlinedExactClassProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int fixed_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link SingleMethod} cachedMethod</pre> */
        @CompilationFinal SingleMethod cachedMethod_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link HostToTypeNode} toJavaNodes</pre> */
        @Children HostToTypeNode[] toJavaNodes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}
         *   Inline field: {@link Object} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object fixed_toGuest__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}
         *   Inline field: {@link Class} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Class<?> fixed_receiverProfile__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doFixed}
         *   Parameter: {@link GuestToHostCodeCache} cache</pre> */
        @CompilationFinal GuestToHostCodeCache cache_;

        FixedData(FixedData next_) {
            this.next_ = next_;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    @DenyReplace
    private static final class VarArgsData extends Node implements SpecializationDataNode {

        @Child VarArgsData next_;
        /**
         * State Info: <pre>
         *   0-1: InlinedCache
         *        Specialization: {@link HostExecuteNode#doVarArgs}
         *        Parameter: {@link HostToTypeNode} toJavaNode
         *        Inline method: {@link HostToTypeNodeGen#inline}
         *   2-4: InlinedCache
         *        Specialization: {@link HostExecuteNode#doVarArgs}
         *        Parameter: {@link ToGuestValueNode} toGuest
         *        Inline method: {@link ToGuestValueNodeGen#inline}
         *   5-6: InlinedCache
         *        Specialization: {@link HostExecuteNode#doVarArgs}
         *        Parameter: {@link InlinedExactClassProfile} receiverProfile
         *        Inline method: {@link InlinedExactClassProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int varArgs_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link SingleMethod} cachedMethod</pre> */
        @CompilationFinal SingleMethod cachedMethod_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link HostToTypeNode} toJavaNode
         *   Inline method: {@link HostToTypeNodeGen#inline}
         *   Inline field: {@link Node} field1</pre> */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node varArgs_toJavaNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}
         *   Inline field: {@link Object} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object varArgs_toGuest__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}
         *   Inline field: {@link Class} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Class<?> varArgs_receiverProfile__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: boolean asVarArgs</pre> */
        @CompilationFinal boolean asVarArgs_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doVarArgs}
         *   Parameter: {@link GuestToHostCodeCache} cache</pre> */
        @CompilationFinal GuestToHostCodeCache cache_;

        VarArgsData(VarArgsData next_) {
            this.next_ = next_;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    @DenyReplace
    private static final class OverloadedCachedData extends Node implements SpecializationDataNode {

        @Child OverloadedCachedData next_;
        /**
         * State Info: <pre>
         *   0-1: InlinedCache
         *        Specialization: {@link HostExecuteNode#doOverloadedCached}
         *        Parameter: {@link HostToTypeNode} toJavaNode
         *        Inline method: {@link HostToTypeNodeGen#inline}
         *   2-4: InlinedCache
         *        Specialization: {@link HostExecuteNode#doOverloadedCached}
         *        Parameter: {@link ToGuestValueNode} toGuest
         *        Inline method: {@link ToGuestValueNodeGen#inline}
         *   5-6: InlinedCache
         *        Specialization: {@link HostExecuteNode#doOverloadedCached}
         *        Parameter: {@link InlinedExactClassProfile} receiverProfile
         *        Inline method: {@link InlinedExactClassProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int overloadedCached_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link OverloadedMethod} cachedMethod</pre> */
        @CompilationFinal OverloadedMethod cachedMethod_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link HostToTypeNode} toJavaNode
         *   Inline method: {@link HostToTypeNodeGen#inline}
         *   Inline field: {@link Node} field1</pre> */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node overloadedCached_toJavaNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link ToGuestValueNode} toGuest
         *   Inline method: {@link ToGuestValueNodeGen#inline}
         *   Inline field: {@link Object} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object overloadedCached_toGuest__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link InteropLibrary} interop</pre> */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link TypeCheckNode} cachedArgTypes</pre> */
        @Children TypeCheckNode[] cachedArgTypes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link SingleMethod} overload</pre> */
        @CompilationFinal SingleMethod overload_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: boolean asVarArgs</pre> */
        @CompilationFinal boolean asVarArgs_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link InlinedExactClassProfile} receiverProfile
         *   Inline method: {@link InlinedExactClassProfile#inline}
         *   Inline field: {@link Class} field1</pre> */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Class<?> overloadedCached_receiverProfile__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HostExecuteNode#doOverloadedCached}
         *   Parameter: {@link GuestToHostCodeCache} cache</pre> */
        @CompilationFinal GuestToHostCodeCache cache_;

        OverloadedCachedData(OverloadedCachedData next_) {
            this.next_ = next_;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    @DenyReplace
    private static final class Uncached extends HostExecuteNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Node arg0Value, HostMethodDesc arg1Value, Object arg2Value, Object[] arg3Value, HostContext arg4Value) throws UnsupportedTypeException, ArityException {
            if (arg1Value instanceof SingleMethod) {
                SingleMethod arg1Value_ = (SingleMethod) arg1Value;
                return HostExecuteNode.doSingleUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, (HostToTypeNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (HostMethodProfileNodeGen.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedBranchProfile.getUncached()), (arg4Value.getGuestToHostCache()));
            }
            if (arg1Value instanceof OverloadedMethod) {
                OverloadedMethod arg1Value_ = (OverloadedMethod) arg1Value;
                return HostExecuteNode.doOverloadedUncached(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, (HostToTypeNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (HostMethodProfileNodeGen.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedBranchProfile.getUncached()), (arg4Value.getGuestToHostCache()));
            }
            throw newUnsupportedSpecializationException5(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link HostMethodProfileNode#mono(MHBase)}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link HostMethodProfileNode#mono(ReflectBase)}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link HostMethodProfileNode#poly}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(HostMethodProfileNode.class)
    @SuppressWarnings("javadoc")
    static final class HostMethodProfileNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static HostMethodProfileNode getUncached() {
            return HostMethodProfileNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static HostMethodProfileNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
            return new HostMethodProfileNodeGen.Inlined(target);
        }

        @GeneratedBy(HostMethodProfileNode.class)
        @DenyReplace
        private static final class Inlined extends HostMethodProfileNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HostMethodProfileNode#mono(MHBase)}
             *   1: SpecializationActive {@link HostMethodProfileNode#poly}
             *   2: SpecializationActive {@link HostMethodProfileNode#mono(ReflectBase)}
             * </pre> */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(HostMethodProfileNode.class);
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            public SingleMethod execute(Node arg0Value, SingleMethod arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(MHBase)] || SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(ReflectBase)] || SpecializationActive[HostExecuteNode.HostMethodProfileNode.poly(SingleMethod)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(MHBase)] */ && arg1Value instanceof MHBase) {
                        MHBase arg1Value_ = (MHBase) arg1Value;
                        return HostMethodProfileNode.mono(arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(ReflectBase)] */ && arg1Value instanceof ReflectBase) {
                        ReflectBase arg1Value_ = (ReflectBase) arg1Value;
                        return HostMethodProfileNode.mono(arg1Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[HostExecuteNode.HostMethodProfileNode.poly(SingleMethod)] */) {
                        return HostMethodProfileNode.poly(arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private SingleMethod executeAndSpecialize(Node arg0Value, SingleMethod arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HostExecuteNode.HostMethodProfileNode.poly(SingleMethod)] */ && arg1Value instanceof MHBase) {
                    MHBase arg1Value_ = (MHBase) arg1Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(MHBase)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return HostMethodProfileNode.mono(arg1Value_);
                }
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HostExecuteNode.HostMethodProfileNode.poly(SingleMethod)] */ && arg1Value instanceof ReflectBase) {
                    ReflectBase arg1Value_ = (ReflectBase) arg1Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(ReflectBase)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return HostMethodProfileNode.mono(arg1Value_);
                }
                state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(MHBase)], SpecializationActive[HostExecuteNode.HostMethodProfileNode.mono(ReflectBase)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[HostExecuteNode.HostMethodProfileNode.poly(SingleMethod)] */;
                this.state_0_.set(arg0Value, state_0);
                return HostMethodProfileNode.poly(arg1Value);
            }

        }
        @GeneratedBy(HostMethodProfileNode.class)
        @DenyReplace
        private static final class Uncached extends HostMethodProfileNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public SingleMethod execute(Node arg0Value, SingleMethod arg1Value) {
                return HostMethodProfileNode.poly(arg1Value);
            }

        }
    }
}
