/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.instrumentation.provider.TruffleInstrumentProvider;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.ModuleUtils;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.polyglot.SandboxPolicy;

final class InstrumentCache {
    private static final List<InstrumentCache> nativeImageCache = TruffleOptions.AOT ? new ArrayList() : null;
    private static Map<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>> runtimeCaches = new HashMap<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>>();
    private final String className;
    private final String id;
    private final String name;
    private final String version;
    private final String website;
    private final boolean internal;
    private final Set<String> services;
    private final ProviderAdapter providerAdapter;
    private final SandboxPolicy sandboxPolicy;
    private final Map<String, InternalResourceCache> internalResources;

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        nativeImageCache.addAll(InstrumentCache.doLoad(List.of(new EngineAccessor.StrongClassLoaderSupplier(imageClassLoader))));
    }

    private static Set<String> collectInstruments() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        HashSet<String> res = new HashSet<String>();
        for (InstrumentCache instrumentCache : nativeImageCache) {
            res.add(instrumentCache.id);
        }
        return res;
    }

    private static void resetNativeImageState() {
        nativeImageCache.clear();
        runtimeCaches.clear();
    }

    private InstrumentCache(String id, String name, String version, String className, boolean internal, Set<String> services, ProviderAdapter providerAdapter, String website, SandboxPolicy sandboxPolicy, Map<String, InternalResourceCache> internalResources) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.website = website;
        this.className = className;
        this.internal = internal;
        this.services = services;
        this.providerAdapter = providerAdapter;
        this.sandboxPolicy = sandboxPolicy;
        this.internalResources = internalResources;
    }

    boolean isInternal() {
        return this.internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<InstrumentCache> load() {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Class<InstrumentCache> clazz = InstrumentCache.class;
        synchronized (InstrumentCache.class) {
            List<EngineAccessor.AbstractClassLoaderSupplier> classLoaders = EngineAccessor.locatorOrDefaultLoaders();
            List<InstrumentCache> cache = runtimeCaches.get(classLoaders);
            if (cache == null) {
                cache = InstrumentCache.doLoad(classLoaders);
                runtimeCaches.put(classLoaders, cache);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    static Collection<InstrumentCache> internalInstruments() {
        HashSet<InstrumentCache> result = new HashSet<InstrumentCache>();
        for (InstrumentCache i : InstrumentCache.load()) {
            if (!i.isInternal()) continue;
            result.add(i);
        }
        return result;
    }

    static List<InstrumentCache> doLoad(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        ArrayList<InstrumentCache> list = new ArrayList<InstrumentCache>();
        HashSet classNamesUsed = new HashSet();
        ClassLoader truffleClassLoader = InstrumentCache.class.getClassLoader();
        boolean usesTruffleClassLoader = false;
        Map<String, Map<String, Supplier<InternalResourceCache>>> optionalResources = InternalResourceCache.loadOptionalInternalResources(suppliers);
        for (EngineAccessor.AbstractClassLoaderSupplier supplier : suppliers) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            usesTruffleClassLoader |= truffleClassLoader == loader;
            InstrumentCache.loadProviders(loader).filter(p -> supplier.accepts(p.getProviderClass())).forEach(p -> InstrumentCache.loadInstrumentImpl(p, list, classNamesUsed, optionalResources));
            if (!supplier.supportsLegacyProviders()) continue;
            InstrumentCache.loadLegacyProviders(loader).filter(p -> supplier.accepts(p.getProviderClass())).forEach(p -> InstrumentCache.loadInstrumentImpl(p, list, classNamesUsed, optionalResources));
        }
        if (!usesTruffleClassLoader) {
            Module truffleModule = InstrumentCache.class.getModule();
            InstrumentCache.loadProviders(truffleClassLoader).filter(p -> p.getProviderClass().getModule().equals(truffleModule)).forEach(p -> InstrumentCache.loadInstrumentImpl(p, list, classNamesUsed, optionalResources));
        }
        list.sort(Comparator.comparing(InstrumentCache::getId));
        return list;
    }

    private static Stream<? extends ProviderAdapter> loadLegacyProviders(ClassLoader loader) {
        ModuleUtils.exportToUnnamedModuleOf(loader);
        return StreamSupport.stream(ServiceLoader.load(TruffleInstrument.Provider.class, loader).spliterator(), false).map(LegacyProvider::new);
    }

    private static Stream<? extends ProviderAdapter> loadProviders(ClassLoader loader) {
        return StreamSupport.stream(ServiceLoader.load(TruffleInstrumentProvider.class, loader).spliterator(), false).map(ModuleAwareProvider::new);
    }

    private static void loadInstrumentImpl(ProviderAdapter providerAdapter, List<? super InstrumentCache> list, Set<? super String> classNamesUsed, Map<String, Map<String, Supplier<InternalResourceCache>>> optionalResources) {
        Class<?> providerClass = providerAdapter.getProviderClass();
        Module providerModule = providerClass.getModule();
        ModuleUtils.exportTransitivelyTo(providerModule);
        TruffleInstrument.Registration reg = providerClass.getAnnotation(TruffleInstrument.Registration.class);
        if (reg == null) {
            InstrumentCache.emitWarning("Warning Truffle instrument ignored: Provider %s is missing @Registration annotation.", providerClass);
            return;
        }
        String className = providerAdapter.getInstrumentClassName();
        String name = reg.name();
        String id = reg.id();
        if (id == null || id.isEmpty()) {
            int lastIndex = className.lastIndexOf(36);
            if (lastIndex == -1) {
                lastIndex = className.lastIndexOf(46);
            }
            id = className.substring(lastIndex + 1);
        }
        String version = reg.version();
        String website = reg.website();
        SandboxPolicy sandboxPolicy = reg.sandbox();
        boolean internal = reg.internal();
        TreeSet<String> servicesClassNames = new TreeSet<String>(providerAdapter.getServicesClassNames());
        HashMap<String, InternalResourceCache> resources = new HashMap<String, InternalResourceCache>();
        for (String string : providerAdapter.getInternalResourceIds()) {
            resources.put(string, new InternalResourceCache(id, string, () -> providerAdapter.createInternalResource(resourceId)));
        }
        for (Map.Entry entry : optionalResources.getOrDefault(id, Map.of()).entrySet()) {
            InternalResourceCache resource = (InternalResourceCache)((Supplier)entry.getValue()).get();
            InternalResourceCache old = resources.put((String)entry.getKey(), resource);
            if (old == null) continue;
            throw InternalResourceCache.throwDuplicateOptionalResourceException(old, resource);
        }
        if (!classNamesUsed.contains(className)) {
            classNamesUsed.add(className);
            list.add(new InstrumentCache(id, name, version, className, internal, servicesClassNames, providerAdapter, website, sandboxPolicy, Collections.unmodifiableMap(resources)));
        }
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getVersion() {
        return this.version;
    }

    TruffleInstrument loadInstrument() {
        return this.providerAdapter.create();
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    String[] services() {
        return this.services.toArray(new String[0]);
    }

    InternalResourceCache getResourceCache(String resourceId) {
        return this.internalResources.get(resourceId);
    }

    Collection<String> getResourceIds() {
        return this.internalResources.keySet();
    }

    Collection<InternalResourceCache> getResources() {
        return this.internalResources.values();
    }

    String getWebsite() {
        return this.website;
    }

    SandboxPolicy getSandboxPolicy() {
        return this.sandboxPolicy;
    }

    private static void emitWarning(String message, Object ... args) {
        PolyglotEngineImpl.logFallback(String.format(message + "%n", args));
    }

    private static interface ProviderAdapter {
        public Class<?> getProviderClass();

        public TruffleInstrument create();

        public String getInstrumentClassName();

        public Collection<String> getServicesClassNames();

        public List<String> getInternalResourceIds();

        public InternalResource createInternalResource(String var1);
    }

    private static final class ModuleAwareProvider
    implements ProviderAdapter {
        private final TruffleInstrumentProvider provider;

        ModuleAwareProvider(TruffleInstrumentProvider provider) {
            Objects.requireNonNull(provider, "Provider must be non null");
            this.provider = provider;
        }

        @Override
        public Class<?> getProviderClass() {
            return this.provider.getClass();
        }

        @Override
        public TruffleInstrument create() {
            return (TruffleInstrument)EngineAccessor.INSTRUMENT_PROVIDER.create(this.provider);
        }

        @Override
        public String getInstrumentClassName() {
            return EngineAccessor.INSTRUMENT_PROVIDER.getInstrumentClassName(this.provider);
        }

        @Override
        public Collection<String> getServicesClassNames() {
            return EngineAccessor.INSTRUMENT_PROVIDER.getServicesClassNames(this.provider);
        }

        @Override
        public List<String> getInternalResourceIds() {
            return EngineAccessor.INSTRUMENT_PROVIDER.getInternalResourceIds(this.provider);
        }

        @Override
        public InternalResource createInternalResource(String resourceId) {
            return EngineAccessor.INSTRUMENT_PROVIDER.createInternalResource(this.provider, resourceId);
        }
    }

    private static final class LegacyProvider
    implements ProviderAdapter {
        private final TruffleInstrument.Provider provider;

        LegacyProvider(TruffleInstrument.Provider provider) {
            Objects.requireNonNull(provider, "Provider must be non null");
            this.provider = provider;
        }

        @Override
        public Class<?> getProviderClass() {
            return this.provider.getClass();
        }

        @Override
        public TruffleInstrument create() {
            return this.provider.create();
        }

        @Override
        public String getInstrumentClassName() {
            return this.provider.getInstrumentClassName();
        }

        @Override
        public Collection<String> getServicesClassNames() {
            return this.provider.getServicesClassNames();
        }

        @Override
        public List<String> getInternalResourceIds() {
            return List.of();
        }

        @Override
        public InternalResource createInternalResource(String resourceId) {
            throw new UnsupportedOperationException();
        }
    }
}

