// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString.NativePointer;
import com.oracle.truffle.api.strings.MutableTruffleString.CalcLazyAttributesNode;
import com.oracle.truffle.api.strings.MutableTruffleStringFactory.CalcLazyAttributesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodes.ByteLengthOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesInnerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointIndexToRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatEagerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatMaterializeBytesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CreateJavaStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CreateSubstringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseDoubleNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseIntNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseLongNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RawIndexToCodePointIndexNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ReadByteNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RegionEqualsNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.StrideFromCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.SubstringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ToJavaStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeIntlNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ErrorHandling;
import com.oracle.truffle.api.strings.TruffleString.NumberFormatException;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleStringIterator.NextNode;
import com.oracle.truffle.api.strings.TruffleStringIterator.PreviousNode;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TStringInternalNodes.class)
final class TStringInternalNodesFactory {

    @GeneratedBy(GetCodeRangeNode.class)
    static final class GetCodeRangeNodeGen extends GetCodeRangeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CalcLazyAttributesNode mutableCacheMiss_calcLazyAttributesNode_;

        private GetCodeRangeNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is-state_0 immutable(TruffleString) */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return immutable(arg0Value_);
            }
            if ((state_0 & 0b110) != 0 /* is-state_0 mutableCacheHit(MutableTruffleString) || mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */ && arg0Value instanceof MutableTruffleString) {
                MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                if ((state_0 & 0b10) != 0 /* is-state_0 mutableCacheHit(MutableTruffleString) */) {
                    if ((!(TStringGuards.isUnknown(arg0Value_.codeRange())))) {
                        return mutableCacheHit(arg0Value_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */) {
                    if ((TStringGuards.isUnknown(arg0Value_.codeRange()))) {
                        return mutableCacheMiss(arg0Value_, this.mutableCacheMiss_calcLazyAttributesNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 immutable(TruffleString) */;
                    lock.unlock();
                    hasLock = false;
                    return immutable(arg0Value_);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(TStringGuards.isUnknown(arg0Value_.codeRange())))) {
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 mutableCacheHit(MutableTruffleString) */;
                        lock.unlock();
                        hasLock = false;
                        return mutableCacheHit(arg0Value_);
                    }
                    if ((TStringGuards.isUnknown(arg0Value_.codeRange()))) {
                        this.mutableCacheMiss_calcLazyAttributesNode_ = super.insert((CalcLazyAttributesNodeGen.create()));
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */;
                        lock.unlock();
                        hasLock = false;
                        return mutableCacheMiss(arg0Value_, this.mutableCacheMiss_calcLazyAttributesNode_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetCodeRangeNode create() {
            return new GetCodeRangeNodeGen();
        }

        public static GetCodeRangeNode getUncached() {
            return GetCodeRangeNodeGen.UNCACHED;
        }

        @GeneratedBy(GetCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodeRangeNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return immutable(arg0Value_);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(TStringGuards.isUnknown(arg0Value_.codeRange())))) {
                        return mutableCacheHit(arg0Value_);
                    }
                    if ((TStringGuards.isUnknown(arg0Value_.codeRange()))) {
                        return mutableCacheMiss(arg0Value_, (CalcLazyAttributesNodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(GetCodePointLengthNode.class)
    static final class GetCodePointLengthNodeGen extends GetCodePointLengthNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CalcLazyAttributesNode mutableCacheMiss_calcLazyAttributesNode_;

        private GetCodePointLengthNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is-state_0 immutable(TruffleString) */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return immutable(arg0Value_);
            }
            if ((state_0 & 0b110) != 0 /* is-state_0 mutableCacheHit(MutableTruffleString) || mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */ && arg0Value instanceof MutableTruffleString) {
                MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                if ((state_0 & 0b10) != 0 /* is-state_0 mutableCacheHit(MutableTruffleString) */) {
                    if ((arg0Value_.codePointLength() >= 0)) {
                        return mutableCacheHit(arg0Value_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */) {
                    if ((arg0Value_.codePointLength() < 0)) {
                        return mutableCacheMiss(arg0Value_, this.mutableCacheMiss_calcLazyAttributesNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 immutable(TruffleString) */;
                    lock.unlock();
                    hasLock = false;
                    return immutable(arg0Value_);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.codePointLength() >= 0)) {
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 mutableCacheHit(MutableTruffleString) */;
                        lock.unlock();
                        hasLock = false;
                        return mutableCacheHit(arg0Value_);
                    }
                    if ((arg0Value_.codePointLength() < 0)) {
                        this.mutableCacheMiss_calcLazyAttributesNode_ = super.insert((CalcLazyAttributesNodeGen.create()));
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 mutableCacheMiss(MutableTruffleString, CalcLazyAttributesNode) */;
                        lock.unlock();
                        hasLock = false;
                        return mutableCacheMiss(arg0Value_, this.mutableCacheMiss_calcLazyAttributesNode_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetCodePointLengthNode create() {
            return new GetCodePointLengthNodeGen();
        }

        public static GetCodePointLengthNode getUncached() {
            return GetCodePointLengthNodeGen.UNCACHED;
        }

        @GeneratedBy(GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodePointLengthNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return immutable(arg0Value_);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.codePointLength() >= 0)) {
                        return mutableCacheHit(arg0Value_);
                    }
                    if ((arg0Value_.codePointLength() < 0)) {
                        return mutableCacheMiss(arg0Value_, (CalcLazyAttributesNodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CreateSubstringNode.class)
    static final class CreateSubstringNodeGen extends CreateSubstringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private CachedData cached_cache;
        @Child private CalcStringAttributesNode uncached_calcAttributesNode_;

        private CreateSubstringNodeGen() {
        }

        @ExplodeLoop
        @Override
        TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) || doUncached(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if ((arg5Value == s0_.cachedEncoding_) && (arg4Value == s0_.cachedStride_)) {
                            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedEncoding_, s0_.cachedStride_, s0_.calcAttributesNode_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doUncached(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesNode) */) {
                    return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uncached_calcAttributesNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if ((exclude) == 0 /* is-not-exclude doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */) {
                    int count0_ = 0;
                    CachedData s0_ = this.cached_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */) {
                        while (s0_ != null) {
                            if ((arg5Value == s0_.cachedEncoding_) && (arg4Value == s0_.cachedStride_)) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        // assert (arg5Value == s0_.cachedEncoding_);
                        // assert (arg4Value == s0_.cachedStride_);
                        if (count0_ < (6)) {
                            s0_ = super.insert(new CachedData(cached_cache));
                            s0_.cachedEncoding_ = (arg5Value);
                            s0_.cachedStride_ = (arg4Value);
                            s0_.calcAttributesNode_ = s0_.insertAccessor((CalcStringAttributesNodeGen.create()));
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */;
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedEncoding_, s0_.cachedStride_, s0_.calcAttributesNode_);
                    }
                }
                this.uncached_calcAttributesNode_ = super.insert((CalcStringAttributesNodeGen.create()));
                this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */;
                this.cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(AbstractTruffleString, Object, int, int, int, Encoding, int, Encoding, int, CalcStringAttributesNode) */;
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUncached(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesNode) */;
                lock.unlock();
                hasLock = false;
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uncached_calcAttributesNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CreateSubstringNode create() {
            return new CreateSubstringNodeGen();
        }

        public static CreateSubstringNode getUncached() {
            return CreateSubstringNodeGen.UNCACHED;
        }

        @GeneratedBy(CreateSubstringNode.class)
        private static final class CachedData extends Node {

            @Child CachedData next_;
            @CompilationFinal Encoding cachedEncoding_;
            @CompilationFinal int cachedStride_;
            @Child CalcStringAttributesNode calcAttributesNode_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CreateSubstringNode.class)
        @DenyReplace
        private static final class Uncached extends CreateSubstringNode {

            @TruffleBoundary
            @Override
            TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CalcStringAttributesNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromBufferWithStringCompactionNode.class)
    static final class FromBufferWithStringCompactionNodeGen extends FromBufferWithStringCompactionNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private FromBufferWithStringCompactionData fromBufferWithStringCompaction_cache;

        private FromBufferWithStringCompactionNodeGen() {
        }

        @Override
        TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value, boolean arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromBufferWithStringCompaction(Object, int, int, Encoding, boolean, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                FromBufferWithStringCompactionData s0_ = this.fromBufferWithStringCompaction_cache;
                if (s0_ != null) {
                    return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.asciiLatinBytesProfile_, s0_.utf8Profile_, s0_.utf8BrokenProfile_, s0_.utf16Profile_, s0_.utf16CompactProfile_, s0_.utf32Profile_, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private TruffleString executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value, boolean arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                FromBufferWithStringCompactionData s0_ = new FromBufferWithStringCompactionData();
                s0_.asciiLatinBytesProfile_ = (ConditionProfile.create());
                s0_.utf8Profile_ = (ConditionProfile.create());
                s0_.utf8BrokenProfile_ = (ConditionProfile.create());
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16CompactProfile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32Compact0Profile_ = (ConditionProfile.create());
                s0_.utf32Compact1Profile_ = (ConditionProfile.create());
                s0_.exoticValidProfile_ = (ConditionProfile.create());
                s0_.exoticFixedWidthProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.fromBufferWithStringCompaction_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromBufferWithStringCompaction(Object, int, int, Encoding, boolean, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.asciiLatinBytesProfile_, s0_.utf8Profile_, s0_.utf8BrokenProfile_, s0_.utf16Profile_, s0_.utf16CompactProfile_, s0_.utf32Profile_, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromBufferWithStringCompactionNode create() {
            return new FromBufferWithStringCompactionNodeGen();
        }

        public static FromBufferWithStringCompactionNode getUncached() {
            return FromBufferWithStringCompactionNodeGen.UNCACHED;
        }

        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        private static final class FromBufferWithStringCompactionData {

            @CompilationFinal ConditionProfile asciiLatinBytesProfile_;
            @CompilationFinal ConditionProfile utf8Profile_;
            @CompilationFinal ConditionProfile utf8BrokenProfile_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16CompactProfile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32Compact0Profile_;
            @CompilationFinal ConditionProfile utf32Compact1Profile_;
            @CompilationFinal ConditionProfile exoticValidProfile_;
            @CompilationFinal ConditionProfile exoticFixedWidthProfile_;

            FromBufferWithStringCompactionData() {
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value, boolean arg5Value) {
                return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
    static final class FromBufferWithStringCompactionKnownAttributesNodeGen extends FromBufferWithStringCompactionKnownAttributesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private FromBufferWithStringCompactionData fromBufferWithStringCompaction_cache;

        private FromBufferWithStringCompactionKnownAttributesNodeGen() {
        }

        @Override
        TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromBufferWithStringCompaction(Object, int, int, Encoding, int, int, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                FromBufferWithStringCompactionData s0_ = this.fromBufferWithStringCompaction_cache;
                if (s0_ != null) {
                    return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.utf16Profile_, s0_.utf16CompactProfile_, s0_.utf32Profile_, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private TruffleString executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                FromBufferWithStringCompactionData s0_ = new FromBufferWithStringCompactionData();
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16CompactProfile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32Compact0Profile_ = (ConditionProfile.create());
                s0_.utf32Compact1Profile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.fromBufferWithStringCompaction_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromBufferWithStringCompaction(Object, int, int, Encoding, int, int, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.utf16Profile_, s0_.utf16CompactProfile_, s0_.utf32Profile_, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromBufferWithStringCompactionKnownAttributesNode create() {
            return new FromBufferWithStringCompactionKnownAttributesNodeGen();
        }

        public static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return FromBufferWithStringCompactionKnownAttributesNodeGen.UNCACHED;
        }

        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        private static final class FromBufferWithStringCompactionData {

            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16CompactProfile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32Compact0Profile_;
            @CompilationFinal ConditionProfile utf32Compact1Profile_;

            FromBufferWithStringCompactionData() {
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionKnownAttributesNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
                return fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromNativePointerNode.class)
    static final class FromNativePointerNodeGen extends FromNativePointerNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private FromNativePointerInternalData fromNativePointerInternal_cache;

        private FromNativePointerNodeGen() {
        }

        @Override
        TruffleString execute(NativePointer arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromNativePointerInternal(NativePointer, int, int, Encoding, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                FromNativePointerInternalData s0_ = this.fromNativePointerInternal_cache;
                if (s0_ != null) {
                    return fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.asciiLatinBytesProfile_, s0_.utf8Profile_, s0_.utf8BrokenProfile_, s0_.utf16Profile_, s0_.utf32Profile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(NativePointer arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                FromNativePointerInternalData s0_ = new FromNativePointerInternalData();
                s0_.asciiLatinBytesProfile_ = (ConditionProfile.create());
                s0_.utf8Profile_ = (ConditionProfile.create());
                s0_.utf8BrokenProfile_ = (ConditionProfile.create());
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.exoticValidProfile_ = (ConditionProfile.create());
                s0_.exoticFixedWidthProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.fromNativePointerInternal_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromNativePointerInternal(NativePointer, int, int, Encoding, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.asciiLatinBytesProfile_, s0_.utf8Profile_, s0_.utf8BrokenProfile_, s0_.utf16Profile_, s0_.utf32Profile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromNativePointerNode create() {
            return new FromNativePointerNodeGen();
        }

        public static FromNativePointerNode getUncached() {
            return FromNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(FromNativePointerNode.class)
        private static final class FromNativePointerInternalData {

            @CompilationFinal ConditionProfile asciiLatinBytesProfile_;
            @CompilationFinal ConditionProfile utf8Profile_;
            @CompilationFinal ConditionProfile utf8BrokenProfile_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile exoticValidProfile_;
            @CompilationFinal ConditionProfile exoticFixedWidthProfile_;

            FromNativePointerInternalData() {
            }

        }
        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends FromNativePointerNode {

            @TruffleBoundary
            @Override
            TruffleString execute(NativePointer arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ByteLengthOfCodePointNode.class)
    static final class ByteLengthOfCodePointNodeGen extends ByteLengthOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CodePointAtRawNode uTF32BrokenReturnNegative_codePointAtRawNode_;

        private ByteLengthOfCodePointNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || doUTF32BrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode) || utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value)) && (TStringGuards.isBestEffort(arg5Value))) {
                        return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUpToValidFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                        return doFixedValidReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isAscii(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                        return doASCIIBrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 doUTF32BrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode) */) {
                    if ((TStringGuards.isUTF32(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                        return doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value)) && (TStringGuards.isBestEffort(arg5Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return doFixedValidReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return doASCIIBrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF32(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    this.uTF32BrokenReturnNegative_codePointAtRawNode_ = super.insert((CodePointAtRawNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doUTF32BrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode) */;
                    lock.unlock();
                    hasLock = false;
                    return doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10000000 /* add-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    this.state_0_ = state_0 = state_0 | 0b100000000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ByteLengthOfCodePointNode create() {
            return new ByteLengthOfCodePointNodeGen();
        }

        public static ByteLengthOfCodePointNode getUncached() {
            return ByteLengthOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends ByteLengthOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
                if ((TStringGuards.isFixedWidth(arg2Value)) && (TStringGuards.isBestEffort(arg5Value))) {
                    return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    return doFixedValidReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    return doASCIIBrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF32(arg3Value)) && (TStringGuards.isBrokenFixedWidth(arg2Value)) && (TStringGuards.isReturnNegative(arg5Value))) {
                    return doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CodePointAtRawNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawIndexToCodePointIndexNode.class)
    static final class RawIndexToCodePointIndexNodeGen extends RawIndexToCodePointIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile utf8Valid_brokenProfile_;
        @CompilationFinal private ConditionProfile utf8Broken_brokenProfile_;
        @CompilationFinal private ConditionProfile unsupported_validProfile_;
        @CompilationFinal private ConditionProfile unsupported_fixedWidthProfile_;

        private RawIndexToCodePointIndexNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int) || utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) || utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) || utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int) || utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int) || unsupported(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile, ConditionProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8Valid_brokenProfile_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8Broken_brokenProfile_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.unsupported_validProfile_, this.unsupported_fixedWidthProfile_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    this.utf8Valid_brokenProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8Valid_brokenProfile_);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    this.utf8Broken_brokenProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8Broken_brokenProfile_);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    this.unsupported_validProfile_ = (ConditionProfile.create());
                    this.unsupported_fixedWidthProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.unsupported_validProfile_, this.unsupported_fixedWidthProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawIndexToCodePointIndexNode create() {
            return new RawIndexToCodePointIndexNodeGen();
        }

        public static RawIndexToCodePointIndexNode getUncached() {
            return RawIndexToCodePointIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Uncached extends RawIndexToCodePointIndexNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointIndexToRawNode.class)
    static final class CodePointIndexToRawNodeGen extends CodePointIndexToRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private CodePointIndexToRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                        return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                        return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.isFixedWidth(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CodePointIndexToRawNode create() {
            return new CodePointIndexToRawNodeGen();
        }

        public static CodePointIndexToRawNode getUncached() {
            return CodePointIndexToRawNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointIndexToRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isValidMultiByte(arg2Value))) {
                    return utf16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (TStringGuards.isBrokenMultiByte(arg2Value))) {
                    return utf16Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ReadByteNode.class)
    static final class ReadByteNodeGen extends ReadByteNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile uTF16_stride0Profile_;
        @CompilationFinal private ConditionProfile uTF32_stride0Profile_;
        @CompilationFinal private ConditionProfile uTF32_stride1Profile_;

        private ReadByteNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doUTF16(AbstractTruffleString, Object, int, Encoding, ConditionProfile) || doUTF32(AbstractTruffleString, Object, int, Encoding, ConditionProfile, ConditionProfile) || doRest(AbstractTruffleString, Object, int, Encoding) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doUTF16(AbstractTruffleString, Object, int, Encoding, ConditionProfile) */) {
                    if ((TStringGuards.isUTF16(arg3Value))) {
                        return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, this.uTF16_stride0Profile_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doUTF32(AbstractTruffleString, Object, int, Encoding, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF32(arg3Value))) {
                        return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, this.uTF32_stride0Profile_, this.uTF32_stride1Profile_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 doRest(AbstractTruffleString, Object, int, Encoding) */) {
                    if ((!(TStringGuards.isUTF16Or32(arg3Value)))) {
                        return ReadByteNode.doRest(arg0Value, arg1Value, arg2Value, arg3Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isUTF16(arg3Value))) {
                    this.uTF16_stride0Profile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doUTF16(AbstractTruffleString, Object, int, Encoding, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, this.uTF16_stride0Profile_);
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    this.uTF32_stride0Profile_ = (ConditionProfile.create());
                    this.uTF32_stride1Profile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUTF32(AbstractTruffleString, Object, int, Encoding, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, this.uTF32_stride0Profile_, this.uTF32_stride1Profile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doRest(AbstractTruffleString, Object, int, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return ReadByteNode.doRest(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ReadByteNode create() {
            return new ReadByteNodeGen();
        }

        public static ReadByteNode getUncached() {
            return ReadByteNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadByteNode.class)
        @DenyReplace
        private static final class Uncached extends ReadByteNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value) {
                if ((TStringGuards.isUTF16(arg3Value))) {
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value)))) {
                    return ReadByteNode.doRest(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointAtNode.class)
    static final class CodePointAtNodeGen extends CodePointAtNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private Utf16Data utf16_cache;
        @CompilationFinal private ConditionProfile utf32_stride0Profile_;
        @CompilationFinal private ConditionProfile utf32_stride1Profile_;
        @CompilationFinal private ConditionProfile utf8_fixedWidthProfile_;
        @CompilationFinal private ConditionProfile utf8_validProfile_;

        private CodePointAtNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) || utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) || utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) || doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                    Utf16Data s0_ = this.utf16_cache;
                    if (s0_ != null) {
                        if ((TStringGuards.isUTF16(arg3Value))) {
                            return utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.fixedWidthProfile_, s0_.stride0Profile_, s0_.validProfile_);
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF32(arg3Value))) {
                        return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF8(arg3Value))) {
                        return utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                        return CodePointAtNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                        return CodePointAtNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isUTF16(arg3Value))) {
                    Utf16Data s0_ = new Utf16Data();
                    s0_.fixedWidthProfile_ = (ConditionProfile.create());
                    s0_.stride0Profile_ = (ConditionProfile.create());
                    s0_.validProfile_ = (ConditionProfile.create());
                    VarHandle.storeStoreFence();
                    this.utf16_cache = s0_;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.fixedWidthProfile_, s0_.stride0Profile_, s0_.validProfile_);
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    this.utf32_stride0Profile_ = (ConditionProfile.create());
                    this.utf32_stride1Profile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    this.utf8_fixedWidthProfile_ = (ConditionProfile.create());
                    this.utf8_validProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CodePointAtNode create() {
            return new CodePointAtNodeGen();
        }

        public static CodePointAtNode getUncached() {
            return CodePointAtNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointAtNode.class)
        private static final class Utf16Data {

            @CompilationFinal ConditionProfile fixedWidthProfile_;
            @CompilationFinal ConditionProfile stride0Profile_;
            @CompilationFinal ConditionProfile validProfile_;

            Utf16Data() {
            }

        }
        @GeneratedBy(CodePointAtNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
                if ((TStringGuards.isUTF16(arg3Value))) {
                    return utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    return utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                    return CodePointAtNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    return CodePointAtNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointAtRawNode.class)
    static final class CodePointAtRawNodeGen extends CodePointAtRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private Utf16Data utf16_cache;
        @CompilationFinal private ConditionProfile utf32_stride0Profile_;
        @CompilationFinal private ConditionProfile utf32_stride1Profile_;
        @CompilationFinal private ConditionProfile utf8_fixedWidthProfile_;
        @CompilationFinal private ConditionProfile utf8_validProfile_;

        private CodePointAtRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) || utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) || utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) || doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) || unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                    Utf16Data s0_ = this.utf16_cache;
                    if (s0_ != null) {
                        if ((TStringGuards.isUTF16(arg3Value))) {
                            return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.fixedWidthProfile_, s0_.validProfile_, s0_.stride0Profile_);
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF32(arg3Value))) {
                        return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF8(arg3Value))) {
                        return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                        return CodePointAtRawNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                        return CodePointAtRawNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                        return CodePointAtRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isUTF16(arg3Value))) {
                    Utf16Data s0_ = new Utf16Data();
                    s0_.fixedWidthProfile_ = (ConditionProfile.create());
                    s0_.validProfile_ = (ConditionProfile.create());
                    s0_.stride0Profile_ = (ConditionProfile.create());
                    VarHandle.storeStoreFence();
                    this.utf16_cache = s0_;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 utf16(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.fixedWidthProfile_, s0_.validProfile_, s0_.stride0Profile_);
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    this.utf32_stride0Profile_ = (ConditionProfile.create());
                    this.utf32_stride1Profile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf32(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    this.utf8_fixedWidthProfile_ = (ConditionProfile.create());
                    this.utf8_validProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf8(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling) */;
                    lock.unlock();
                    hasLock = false;
                    return CodePointAtRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CodePointAtRawNode create() {
            return new CodePointAtRawNodeGen();
        }

        public static CodePointAtRawNode getUncached() {
            return CodePointAtRawNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointAtRawNode.class)
        private static final class Utf16Data {

            @CompilationFinal ConditionProfile fixedWidthProfile_;
            @CompilationFinal ConditionProfile validProfile_;
            @CompilationFinal ConditionProfile stride0Profile_;

            Utf16Data() {
            }

        }
        @GeneratedBy(CodePointAtRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, ErrorHandling arg5Value) {
                if ((TStringGuards.isUTF16(arg3Value))) {
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg3Value))) && (!(TStringGuards.isUTF8(arg3Value))) && (TStringGuards.isBytes(arg3Value) || TStringGuards.is7Or8Bit(arg2Value))) {
                    return CodePointAtRawNode.doFixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isAscii(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    return CodePointAtRawNode.doAsciiBroken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.is7Or8Bit(arg2Value)))) {
                    return CodePointAtRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfCodePointNode.class)
    static final class IndexOfCodePointNodeGen extends IndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawIndexOfCodePointNode fixedWidth_indexOfNode_;
        @Child private NextNode decode_nextNode_;

        private IndexOfCodePointNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) || decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.fixedWidth_indexOfNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                    if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.decode_nextNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    this.fixedWidth_indexOfNode_ = super.insert((RawIndexOfCodePointNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.fixedWidth_indexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.decode_nextNode_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.decode_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfCodePointNode create() {
            return new IndexOfCodePointNodeGen();
        }

        public static IndexOfCodePointNode getUncached() {
            return IndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfCodePointRawNode.class)
    static final class IndexOfCodePointRawNodeGen extends IndexOfCodePointRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawIndexOfCodePointNode utf8Fixed_indexOfNode_;
        @Child private NextNode unsupported_nextNode_;

        private IndexOfCodePointRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) || utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) || utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) || unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8Fixed_indexOfNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_nextNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    this.utf8Fixed_indexOfNode_ = super.insert((RawIndexOfCodePointNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8Fixed_indexOfNode_);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.unsupported_nextNode_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfCodePointRawNode create() {
            return new IndexOfCodePointRawNodeGen();
        }

        public static IndexOfCodePointRawNode getUncached() {
            return IndexOfCodePointRawNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastIndexOfCodePointNode.class)
    static final class LastIndexOfCodePointNodeGen extends LastIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawLastIndexOfCodePointNode fixedWidth_lastIndexOfNode_;
        @Child private NextNode decode_nextNode_;

        private LastIndexOfCodePointNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) || decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.fixedWidth_lastIndexOfNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */) {
                    if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.decode_nextNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    this.fixedWidth_lastIndexOfNode_ = super.insert((RawLastIndexOfCodePointNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixedWidth(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.fixedWidth_lastIndexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.decode_nextNode_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 decode(AbstractTruffleString, Object, int, Encoding, int, int, int, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.decode_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LastIndexOfCodePointNode create() {
            return new LastIndexOfCodePointNodeGen();
        }

        public static LastIndexOfCodePointNode getUncached() {
            return LastIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastIndexOfCodePointRawNode.class)
    static final class LastIndexOfCodePointRawNodeGen extends LastIndexOfCodePointRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawLastIndexOfCodePointNode lastIndexOfNode;
        @Child private PreviousNode unsupported_prevNode_;

        private LastIndexOfCodePointRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) || utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) || utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) || unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, PreviousNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value))) {
                        return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */) {
                    if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */) {
                    if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, PreviousNode) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_prevNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    this.lastIndexOfNode = super.insert(this.lastIndexOfNode == null ? ((RawLastIndexOfCodePointNodeGen.create())) : this.lastIndexOfNode);
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 utf8Fixed(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.lastIndexOfNode = super.insert(this.lastIndexOfNode == null ? ((RawLastIndexOfCodePointNodeGen.create())) : this.lastIndexOfNode);
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.lastIndexOfNode = super.insert(this.lastIndexOfNode == null ? ((RawLastIndexOfCodePointNodeGen.create())) : this.lastIndexOfNode);
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.unsupported_prevNode_ = super.insert((PreviousNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, Encoding, int, int, int, PreviousNode) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_prevNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LastIndexOfCodePointRawNode create() {
            return new LastIndexOfCodePointRawNodeGen();
        }

        public static LastIndexOfCodePointRawNode getUncached() {
            return LastIndexOfCodePointRawNodeGen.UNCACHED;
        }

        @GeneratedBy(LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isFixedWidth(arg2Value))) {
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (PreviousNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SubstringNode.class)
    static final class SubstringNodeGen extends SubstringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CreateSubstringNode materializeSubstring_createSubstringNode_;
        @Child private CreateLazySubstringData createLazySubstring_cache;

        private SubstringNodeGen() {
        }

        @Override
        TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean) || sameStr(TruffleString, Object, int, Encoding, int, int, boolean) || materializeSubstring(AbstractTruffleString, Object, int, Encoding, int, int, boolean, CreateSubstringNode) || createLazySubstring(TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, ConditionProfile, ConditionProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */) {
                    if ((arg5Value == 0)) {
                        return SubstringNode.lengthZero(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 sameStr(TruffleString, Object, int, Encoding, int, int, boolean) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg4Value == 0) && (arg5Value == TStringGuards.length(arg0Value_))) {
                        return SubstringNode.sameStr(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 materializeSubstring(AbstractTruffleString, Object, int, Encoding, int, int, boolean, CreateSubstringNode) */) {
                    if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value) || arg0Value.isMutable()) && (!(arg6Value))) {
                        return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.materializeSubstring_createSubstringNode_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 createLazySubstring(TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, ConditionProfile, ConditionProfile) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    CreateLazySubstringData s3_ = this.createLazySubstring_cache;
                    if (s3_ != null) {
                        if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value_)) && (arg6Value)) {
                            return createLazySubstring(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s3_.calcAttributesNode_, s3_.stride1MustMaterializeProfile_, s3_.stride2MustMaterializeProfile_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((arg5Value == 0)) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return SubstringNode.lengthZero(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg4Value == 0) && (arg5Value == TStringGuards.length(arg0Value_))) {
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 sameStr(TruffleString, Object, int, Encoding, int, int, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return SubstringNode.sameStr(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value) || arg0Value.isMutable()) && (!(arg6Value))) {
                    this.materializeSubstring_createSubstringNode_ = super.insert((CreateSubstringNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 materializeSubstring(AbstractTruffleString, Object, int, Encoding, int, int, boolean, CreateSubstringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.materializeSubstring_createSubstringNode_);
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value_)) && (arg6Value)) {
                        CreateLazySubstringData s3_ = super.insert(new CreateLazySubstringData());
                        s3_.calcAttributesNode_ = s3_.insertAccessor((CalcStringAttributesNodeGen.create()));
                        s3_.stride1MustMaterializeProfile_ = (ConditionProfile.create());
                        s3_.stride2MustMaterializeProfile_ = (ConditionProfile.create());
                        VarHandle.storeStoreFence();
                        this.createLazySubstring_cache = s3_;
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 createLazySubstring(TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, ConditionProfile, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return createLazySubstring(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s3_.calcAttributesNode_, s3_.stride1MustMaterializeProfile_, s3_.stride2MustMaterializeProfile_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SubstringNode create() {
            return new SubstringNodeGen();
        }

        public static SubstringNode getUncached() {
            return SubstringNodeGen.UNCACHED;
        }

        @GeneratedBy(SubstringNode.class)
        private static final class CreateLazySubstringData extends Node {

            @Child CalcStringAttributesNode calcAttributesNode_;
            @CompilationFinal ConditionProfile stride1MustMaterializeProfile_;
            @CompilationFinal ConditionProfile stride2MustMaterializeProfile_;

            CreateLazySubstringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringNode {

            @TruffleBoundary
            @Override
            TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, boolean arg6Value) {
                if ((arg5Value == 0)) {
                    return SubstringNode.lengthZero(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg4Value == 0) && (arg5Value == TStringGuards.length(arg0Value_))) {
                        return SubstringNode.sameStr(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value) || arg0Value.isMutable()) && (!(arg6Value))) {
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CreateSubstringNodeGen.getUncached()));
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg5Value > 0) && (arg5Value != TStringGuards.length(arg0Value_)) && (arg6Value)) {
                        return createLazySubstring(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CalcStringAttributesNode.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ConcatEagerNode.class)
    static final class ConcatEagerNodeGen extends ConcatEagerNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ConcatData concat_cache;

        private ConcatEagerNodeGen() {
        }

        @Override
        TruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, int arg3Value, int arg4Value, int arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 concat(AbstractTruffleString, AbstractTruffleString, Encoding, int, int, int, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, ConcatMaterializeBytesNode, CalcStringAttributesNode, ConditionProfile) */) {
                ConcatData s0_ = this.concat_cache;
                if (s0_ != null) {
                    return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.materializeBytesNode_, s0_.calculateAttributesNode_, s0_.brokenProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, int arg3Value, int arg4Value, int arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                ConcatData s0_ = super.insert(new ConcatData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthANode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodePointLengthBNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.materializeBytesNode_ = s0_.insertAccessor((ConcatMaterializeBytesNodeGen.create()));
                s0_.calculateAttributesNode_ = s0_.insertAccessor((CalcStringAttributesNodeGen.create()));
                s0_.brokenProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.concat_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 concat(AbstractTruffleString, AbstractTruffleString, Encoding, int, int, int, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, ConcatMaterializeBytesNode, CalcStringAttributesNode, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.materializeBytesNode_, s0_.calculateAttributesNode_, s0_.brokenProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ConcatEagerNode create() {
            return new ConcatEagerNodeGen();
        }

        public static ConcatEagerNode getUncached() {
            return ConcatEagerNodeGen.UNCACHED;
        }

        @GeneratedBy(ConcatEagerNode.class)
        private static final class ConcatData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child GetCodePointLengthNode getCodePointLengthANode_;
            @Child GetCodePointLengthNode getCodePointLengthBNode_;
            @Child ConcatMaterializeBytesNode materializeBytesNode_;
            @Child CalcStringAttributesNode calculateAttributesNode_;
            @CompilationFinal ConditionProfile brokenProfile_;

            ConcatData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ConcatEagerNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatEagerNode {

            @TruffleBoundary
            @Override
            TruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (ConcatMaterializeBytesNodeGen.getUncached()), (CalcStringAttributesNode.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ConcatMaterializeBytesNode.class)
    static final class ConcatMaterializeBytesNodeGen extends ConcatMaterializeBytesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private ConcatMaterializeBytesNodeGen() {
        }

        @Override
        byte[] execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) || doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) */) {
                    if ((TStringGuards.isUTF16(arg4Value) || TStringGuards.isUTF32(arg4Value))) {
                        return doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) */) {
                    if ((!(TStringGuards.isUTF16(arg4Value))) && (!(TStringGuards.isUTF32(arg4Value)))) {
                        return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private byte[] executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.isUTF16(arg4Value) || TStringGuards.isUTF32(arg4Value))) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) */;
                return doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((!(TStringGuards.isUTF16(arg4Value))) && (!(TStringGuards.isUTF32(arg4Value)))) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int) */;
                return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ConcatMaterializeBytesNode create() {
            return new ConcatMaterializeBytesNodeGen();
        }

        public static ConcatMaterializeBytesNode getUncached() {
            return ConcatMaterializeBytesNodeGen.UNCACHED;
        }

        @GeneratedBy(ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatMaterializeBytesNode {

            @TruffleBoundary
            @Override
            byte[] execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isUTF16(arg4Value) || TStringGuards.isUTF32(arg4Value))) {
                    return doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((!(TStringGuards.isUTF16(arg4Value))) && (!(TStringGuards.isUTF32(arg4Value)))) {
                    return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RegionEqualsNode.class)
    static final class RegionEqualsNodeGen extends RegionEqualsNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private NextNode decode_nextNodeA_;
        @Child private NextNode decode_nextNodeB_;

        private RegionEqualsNodeGen() {
        }

        @Override
        boolean execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding) || decode(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value, arg6Value))) {
                        return direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 decode(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */) {
                    if ((!(TStringGuards.isFixedWidth(arg2Value, arg6Value)))) {
                        return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value, arg6Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg6Value)))) {
                    this.decode_nextNodeA_ = super.insert((NextNode.create()));
                    this.decode_nextNodeB_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 decode(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RegionEqualsNode create() {
            return new RegionEqualsNodeGen();
        }

        public static RegionEqualsNode getUncached() {
            return RegionEqualsNodeGen.UNCACHED;
        }

        @GeneratedBy(RegionEqualsNode.class)
        @DenyReplace
        private static final class Uncached extends RegionEqualsNode {

            @TruffleBoundary
            @Override
            boolean execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                if ((TStringGuards.isFixedWidth(arg2Value, arg6Value))) {
                    return direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg6Value)))) {
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (NextNode.getUncached()), (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfStringNode.class)
    static final class IndexOfStringNodeGen extends IndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawIndexOfStringNode direct_indexOfStringNode_;
        @Child private NextNode decode_nextNodeA_;
        @Child private NextNode decode_nextNodeB_;

        private IndexOfStringNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode) || decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                        return IndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.direct_indexOfStringNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */) {
                    if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                        return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                    this.direct_indexOfStringNode_ = super.insert((RawIndexOfStringNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return IndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                    this.decode_nextNodeA_ = super.insert((NextNode.create()));
                    this.decode_nextNodeB_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfStringNode create() {
            return new IndexOfStringNodeGen();
        }

        public static IndexOfStringNode getUncached() {
            return IndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
                if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                    return IndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (NextNode.getUncached()), (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfStringRawNode.class)
    static final class IndexOfStringRawNodeGen extends IndexOfStringRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawIndexOfStringNode supported_indexOfStringNode_;
        @Child private NextNode unsupported_nextNodeA_;
        @Child private NextNode unsupported_nextNodeB_;

        private IndexOfStringRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 supported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode) || unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, NextNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 supported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode) */) {
                    if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                        return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.supported_indexOfStringNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, NextNode) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                        return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                    this.supported_indexOfStringNode_ = super.insert((RawIndexOfStringNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 supported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.supported_indexOfStringNode_);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    this.unsupported_nextNodeA_ = super.insert((NextNode.create()));
                    this.unsupported_nextNodeB_ = super.insert((NextNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfStringRawNode create() {
            return new IndexOfStringRawNodeGen();
        }

        public static IndexOfStringRawNode getUncached() {
            return IndexOfStringRawNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfStringRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
                if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (NextNode.getUncached()), (NextNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastIndexOfStringNode.class)
    static final class LastIndexOfStringNodeGen extends LastIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawLastIndexOfStringNode direct_indexOfStringNode_;
        @Child private DecodeData decode_cache;

        private LastIndexOfStringNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode) || decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, PreviousNode, PreviousNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode) */) {
                    if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                        return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.direct_indexOfStringNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, PreviousNode, PreviousNode) */) {
                    DecodeData s1_ = this.decode_cache;
                    if (s1_ != null) {
                        if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                            return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, s1_.nextNodeA_, s1_.prevNodeA_, s1_.prevNodeB_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                    this.direct_indexOfStringNode_ = super.insert((RawLastIndexOfStringNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 direct(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                    DecodeData s1_ = super.insert(new DecodeData());
                    s1_.nextNodeA_ = s1_.insertAccessor((NextNode.create()));
                    s1_.prevNodeA_ = s1_.insertAccessor((PreviousNode.create()));
                    s1_.prevNodeB_ = s1_.insertAccessor((PreviousNode.create()));
                    VarHandle.storeStoreFence();
                    this.decode_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 decode(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, NextNode, PreviousNode, PreviousNode) */;
                    lock.unlock();
                    hasLock = false;
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, s1_.nextNodeA_, s1_.prevNodeA_, s1_.prevNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LastIndexOfStringNode create() {
            return new LastIndexOfStringNodeGen();
        }

        public static LastIndexOfStringNode getUncached() {
            return LastIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(LastIndexOfStringNode.class)
        private static final class DecodeData extends Node {

            @Child NextNode nextNodeA_;
            @Child PreviousNode prevNodeA_;
            @Child PreviousNode prevNodeB_;

            DecodeData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, Encoding arg8Value) {
                if ((TStringGuards.isFixedWidth(arg2Value, arg5Value))) {
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg2Value, arg5Value)))) {
                    return decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (NextNode.getUncached()), (PreviousNode.getUncached()), (PreviousNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastIndexOfStringRawNode.class)
    static final class LastIndexOfStringRawNodeGen extends LastIndexOfStringRawNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawLastIndexOfStringNode lios8SameEncoding_indexOfStringNode_;
        @Child private UnsupportedData unsupported_cache;

        private LastIndexOfStringRawNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 lios8SameEncoding(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode) || unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, PreviousNode, PreviousNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 lios8SameEncoding(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode) */) {
                    if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                        return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.lios8SameEncoding_indexOfStringNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, PreviousNode, PreviousNode) */) {
                    UnsupportedData s1_ = this.unsupported_cache;
                    if (s1_ != null) {
                        if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                            return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, s1_.nextNodeA_, s1_.prevNodeA_, s1_.prevNodeB_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                    this.lios8SameEncoding_indexOfStringNode_ = super.insert((RawLastIndexOfStringNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 lios8SameEncoding(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.lios8SameEncoding_indexOfStringNode_);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    UnsupportedData s1_ = super.insert(new UnsupportedData());
                    s1_.nextNodeA_ = s1_.insertAccessor((NextNode.create()));
                    s1_.prevNodeA_ = s1_.insertAccessor((PreviousNode.create()));
                    s1_.prevNodeB_ = s1_.insertAccessor((PreviousNode.create()));
                    VarHandle.storeStoreFence();
                    this.unsupported_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 unsupported(AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, NextNode, PreviousNode, PreviousNode) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, s1_.nextNodeA_, s1_.prevNodeA_, s1_.prevNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LastIndexOfStringRawNode create() {
            return new LastIndexOfStringRawNodeGen();
        }

        public static LastIndexOfStringRawNode getUncached() {
            return LastIndexOfStringRawNodeGen.UNCACHED;
        }

        @GeneratedBy(LastIndexOfStringRawNode.class)
        private static final class UnsupportedData extends Node {

            @Child NextNode nextNodeA_;
            @Child PreviousNode prevNodeA_;
            @Child PreviousNode prevNodeB_;

            UnsupportedData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringRawNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value, byte[] arg8Value, Encoding arg9Value) {
                if ((TStringGuards.isSupportedEncoding(arg9Value) || TStringGuards.isFixedWidth(arg2Value))) {
                    return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg9Value)) && (!(TStringGuards.isFixedWidth(arg2Value)))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (NextNode.getUncached()), (PreviousNode.getUncached()), (PreviousNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(StrideFromCodeRangeNode.class)
    static final class StrideFromCodeRangeNodeGen extends StrideFromCodeRangeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private StrideFromCodeRangeNodeGen() {
        }

        @Override
        int execute(int arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doUTF16(int, Encoding) || doUTF32(int, Encoding) || doOther(int, Encoding) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doUTF16(int, Encoding) */) {
                    if ((TStringGuards.isUTF16(arg1Value))) {
                        return doUTF16(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doUTF32(int, Encoding) */) {
                    if ((TStringGuards.isUTF32(arg1Value))) {
                        return doUTF32(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 doOther(int, Encoding) */) {
                    if ((!(TStringGuards.isUTF16(arg1Value))) && (!(TStringGuards.isUTF32(arg1Value)))) {
                        return doOther(arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(int arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.isUTF16(arg1Value))) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doUTF16(int, Encoding) */;
                return doUTF16(arg0Value, arg1Value);
            }
            if ((TStringGuards.isUTF32(arg1Value))) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUTF32(int, Encoding) */;
                return doUTF32(arg0Value, arg1Value);
            }
            if ((!(TStringGuards.isUTF16(arg1Value))) && (!(TStringGuards.isUTF32(arg1Value)))) {
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doOther(int, Encoding) */;
                return doOther(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static StrideFromCodeRangeNode create() {
            return new StrideFromCodeRangeNodeGen();
        }

        public static StrideFromCodeRangeNode getUncached() {
            return StrideFromCodeRangeNodeGen.UNCACHED;
        }

        @GeneratedBy(StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends StrideFromCodeRangeNode {

            @TruffleBoundary
            @Override
            int execute(int arg0Value, Encoding arg1Value) {
                if ((TStringGuards.isUTF16(arg1Value))) {
                    return doUTF16(arg0Value, arg1Value);
                }
                if ((TStringGuards.isUTF32(arg1Value))) {
                    return doUTF32(arg0Value, arg1Value);
                }
                if ((!(TStringGuards.isUTF16(arg1Value))) && (!(TStringGuards.isUTF32(arg1Value)))) {
                    return doOther(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CalcStringAttributesNode.class)
    static final class CalcStringAttributesNodeGen extends CalcStringAttributesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CalcStringAttributesInnerNode notAscii_calcNode_;

        private CalcStringAttributesNodeGen() {
        }

        @Override
        long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 ascii(AbstractTruffleString, Object, int, int, int, Encoding, int) || notAscii(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesInnerNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 ascii(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((TStringGuards.is7Bit(arg6Value))) {
                        return ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 notAscii(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesInnerNode) */) {
                    if ((!(TStringGuards.is7Bit(arg6Value)))) {
                        return notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.notAscii_calcNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private long executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.is7Bit(arg6Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 ascii(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((!(TStringGuards.is7Bit(arg6Value)))) {
                    this.notAscii_calcNode_ = super.insert((CalcStringAttributesInnerNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 notAscii(AbstractTruffleString, Object, int, int, int, Encoding, int, CalcStringAttributesInnerNode) */;
                    lock.unlock();
                    hasLock = false;
                    return notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.notAscii_calcNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CalcStringAttributesNode create() {
            return new CalcStringAttributesNodeGen();
        }

        public static CalcStringAttributesNode getUncached() {
            return CalcStringAttributesNodeGen.UNCACHED;
        }

        @GeneratedBy(CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesNode {

            @TruffleBoundary
            @Override
            long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
                if ((TStringGuards.is7Bit(arg6Value))) {
                    return ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((!(TStringGuards.is7Bit(arg6Value)))) {
                    return notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CalcStringAttributesInnerNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CalcStringAttributesInnerNode.class)
    static final class CalcStringAttributesInnerNodeGen extends CalcStringAttributesInnerNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile uTF8_brokenProfile_;
        @CompilationFinal private ConditionProfile generic_validCharacterProfile_;
        @CompilationFinal private ConditionProfile generic_fixedWidthProfile_;

        private CalcStringAttributesInnerNodeGen() {
        }

        @Override
        long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int) || doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int) || doUTF8(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile) || doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int) || doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int) || doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int) || doGeneric(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile, ConditionProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((TStringGuards.is8Bit(arg6Value) || TStringGuards.isAsciiBytesOrLatin1(arg5Value)) && (arg4Value == 0)) {
                        return doLatin1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((TStringGuards.isUpTo16Bit(arg6Value)) && (arg4Value == 1)) {
                        return doBMP(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 doUTF8(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile) */) {
                    if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg6Value)))) {
                        return doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF8_brokenProfile_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isValidMultiByte(arg6Value))) {
                        return doUTF16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg6Value))) {
                        return doUTF16Unknown(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int) */) {
                    if ((arg4Value == 2)) {
                        return doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 doGeneric(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg5Value))) {
                        return doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private long executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.is8Bit(arg6Value) || TStringGuards.isAsciiBytesOrLatin1(arg5Value)) && (arg4Value == 0)) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doLatin1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUpTo16Bit(arg6Value)) && (arg4Value == 1)) {
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doBMP(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg6Value)))) {
                    this.uTF8_brokenProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doUTF8(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF8_brokenProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isValidMultiByte(arg6Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doUTF16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg6Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doUTF16Unknown(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((arg4Value == 2)) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int) */;
                    lock.unlock();
                    hasLock = false;
                    return doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg5Value))) {
                    this.generic_validCharacterProfile_ = (ConditionProfile.create());
                    this.generic_fixedWidthProfile_ = (ConditionProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 doGeneric(AbstractTruffleString, Object, int, int, int, Encoding, int, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CalcStringAttributesInnerNode create() {
            return new CalcStringAttributesInnerNodeGen();
        }

        public static CalcStringAttributesInnerNode getUncached() {
            return CalcStringAttributesInnerNodeGen.UNCACHED;
        }

        @GeneratedBy(CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesInnerNode {

            @TruffleBoundary
            @Override
            long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) {
                if ((TStringGuards.is8Bit(arg6Value) || TStringGuards.isAsciiBytesOrLatin1(arg5Value)) && (arg4Value == 0)) {
                    return doLatin1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUpTo16Bit(arg6Value)) && (arg4Value == 1)) {
                    return doBMP(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg6Value)))) {
                    return doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (ConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isValidMultiByte(arg6Value))) {
                    return doUTF16Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg6Value))) {
                    return doUTF16Unknown(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((arg4Value == 2)) {
                    return doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg5Value))) {
                    return doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ParseIntNode.class)
    static final class ParseIntNodeGen extends ParseIntNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private Do7BitData do7Bit_cache;
        @Child private NextNode generic_nextNode_;
        @CompilationFinal private BranchProfile generic_errorProfile_;

        private ParseIntNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) || doGeneric(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */ && (TStringGuards.is7Bit(arg2Value))) {
                    Do7BitData s0_ = this.do7Bit_cache;
                    while (s0_ != null) {
                        if ((s0_.cachedStride_ == arg0Value.stride())) {
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStride_, s0_.errorProfile_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doGeneric(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */) {
                    if ((!(TStringGuards.is7Bit(arg2Value)))) {
                        return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_nextNode_, this.generic_errorProfile_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.is7Bit(arg2Value))) {
                    int count0_ = 0;
                    Do7BitData s0_ = this.do7Bit_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */) {
                        while (s0_ != null) {
                            if ((s0_.cachedStride_ == arg0Value.stride())) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        {
                            int cachedStride__ = (arg0Value.stride());
                            if ((cachedStride__ == arg0Value.stride()) && count0_ < (3)) {
                                s0_ = new Do7BitData(do7Bit_cache);
                                s0_.cachedStride_ = cachedStride__;
                                s0_.errorProfile_ = (BranchProfile.create());
                                VarHandle.storeStoreFence();
                                this.do7Bit_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */;
                            }
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStride_, s0_.errorProfile_);
                    }
                }
                if ((!(TStringGuards.is7Bit(arg2Value)))) {
                    this.generic_nextNode_ = super.insert((NextNode.create()));
                    this.generic_errorProfile_ = (BranchProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doGeneric(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_nextNode_, this.generic_errorProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    Do7BitData s0_ = this.do7Bit_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ParseIntNode create() {
            return new ParseIntNodeGen();
        }

        public static ParseIntNode getUncached() {
            return ParseIntNodeGen.UNCACHED;
        }

        @GeneratedBy(ParseIntNode.class)
        private static final class Do7BitData {

            @CompilationFinal Do7BitData next_;
            @CompilationFinal int cachedStride_;
            @CompilationFinal BranchProfile errorProfile_;

            Do7BitData(Do7BitData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class Uncached extends ParseIntNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg2Value))) {
                    if (((arg0Value.stride()) == arg0Value.stride())) {
                        return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (arg0Value.stride()), (BranchProfile.getUncached()));
                    }
                }
                if ((!(TStringGuards.is7Bit(arg2Value)))) {
                    return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (NextNode.getUncached()), (BranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ParseLongNode.class)
    static final class ParseLongNodeGen extends ParseLongNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private Do7BitData do7Bit_cache;
        @Child private NextNode parseLong_nextNode_;
        @CompilationFinal private BranchProfile parseLong_errorProfile_;

        private ParseLongNodeGen() {
        }

        @ExplodeLoop
        @Override
        long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) || parseLong(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */ && (TStringGuards.is7Bit(arg2Value))) {
                    Do7BitData s0_ = this.do7Bit_cache;
                    while (s0_ != null) {
                        if ((s0_.cachedStride_ == arg0Value.stride())) {
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStride_, s0_.errorProfile_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 parseLong(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */) {
                    if ((!(TStringGuards.is7Bit(arg2Value)))) {
                        return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private long executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.is7Bit(arg2Value))) {
                    int count0_ = 0;
                    Do7BitData s0_ = this.do7Bit_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */) {
                        while (s0_ != null) {
                            if ((s0_.cachedStride_ == arg0Value.stride())) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        {
                            int cachedStride__ = (arg0Value.stride());
                            if ((cachedStride__ == arg0Value.stride()) && count0_ < (3)) {
                                s0_ = new Do7BitData(do7Bit_cache);
                                s0_.cachedStride_ = cachedStride__;
                                s0_.errorProfile_ = (BranchProfile.create());
                                VarHandle.storeStoreFence();
                                this.do7Bit_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 do7Bit(AbstractTruffleString, Object, int, Encoding, int, int, BranchProfile) */;
                            }
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStride_, s0_.errorProfile_);
                    }
                }
                if ((!(TStringGuards.is7Bit(arg2Value)))) {
                    this.parseLong_nextNode_ = super.insert((NextNode.create()));
                    this.parseLong_errorProfile_ = (BranchProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 parseLong(AbstractTruffleString, Object, int, Encoding, int, NextNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    Do7BitData s0_ = this.do7Bit_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ParseLongNode create() {
            return new ParseLongNodeGen();
        }

        public static ParseLongNode getUncached() {
            return ParseLongNodeGen.UNCACHED;
        }

        @GeneratedBy(ParseLongNode.class)
        private static final class Do7BitData {

            @CompilationFinal Do7BitData next_;
            @CompilationFinal int cachedStride_;
            @CompilationFinal BranchProfile errorProfile_;

            Do7BitData(Do7BitData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class Uncached extends ParseLongNode {

            @TruffleBoundary
            @Override
            long execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, Encoding arg3Value, int arg4Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg2Value))) {
                    if (((arg0Value.stride()) == arg0Value.stride())) {
                        return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (arg0Value.stride()), (BranchProfile.getUncached()));
                    }
                }
                if ((!(TStringGuards.is7Bit(arg2Value)))) {
                    return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (NextNode.getUncached()), (BranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ParseDoubleNode.class)
    static final class ParseDoubleNodeGen extends ParseDoubleNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ParseData parse_cache;

        private ParseDoubleNodeGen() {
        }

        @ExplodeLoop
        @Override
        double execute(AbstractTruffleString arg0Value, Object arg1Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doParse(AbstractTruffleString, Object, int, BranchProfile) */) {
                ParseData s0_ = this.parse_cache;
                while (s0_ != null) {
                    if ((s0_.cachedStride_ == arg0Value.stride())) {
                        return doParse(arg0Value, arg1Value, s0_.cachedStride_, s0_.errorProfile_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private double executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                ParseData s0_ = this.parse_cache;
                if (state_0 != 0 /* is-state_0 doParse(AbstractTruffleString, Object, int, BranchProfile) */) {
                    while (s0_ != null) {
                        if ((s0_.cachedStride_ == arg0Value.stride())) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStride__ = (arg0Value.stride());
                        if ((cachedStride__ == arg0Value.stride()) && count0_ < (3)) {
                            s0_ = new ParseData(parse_cache);
                            s0_.cachedStride_ = cachedStride__;
                            s0_.errorProfile_ = (BranchProfile.create());
                            VarHandle.storeStoreFence();
                            this.parse_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doParse(AbstractTruffleString, Object, int, BranchProfile) */;
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return doParse(arg0Value, arg1Value, s0_.cachedStride_, s0_.errorProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    ParseData s0_ = this.parse_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ParseDoubleNode create() {
            return new ParseDoubleNodeGen();
        }

        public static ParseDoubleNode getUncached() {
            return ParseDoubleNodeGen.UNCACHED;
        }

        @GeneratedBy(ParseDoubleNode.class)
        private static final class ParseData {

            @CompilationFinal ParseData next_;
            @CompilationFinal int cachedStride_;
            @CompilationFinal BranchProfile errorProfile_;

            ParseData(ParseData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ParseDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends ParseDoubleNode {

            @TruffleBoundary
            @Override
            double execute(AbstractTruffleString arg0Value, Object arg1Value) throws NumberFormatException {
                if (((arg0Value.stride()) == arg0Value.stride())) {
                    return doParse(arg0Value, arg1Value, (arg0Value.stride()), (BranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromJavaStringUTF16Node.class)
    static final class FromJavaStringUTF16NodeGen extends FromJavaStringUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile utf16CompactProfile_;

        private FromJavaStringUTF16NodeGen() {
        }

        @Override
        TruffleString execute(String arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doNonEmpty(String, int, int, boolean, ConditionProfile) */) {
                return doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16CompactProfile_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private TruffleString executeAndSpecialize(String arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.utf16CompactProfile_ = (ConditionProfile.create());
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doNonEmpty(String, int, int, boolean, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16CompactProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromJavaStringUTF16Node create() {
            return new FromJavaStringUTF16NodeGen();
        }

        public static FromJavaStringUTF16Node getUncached() {
            return FromJavaStringUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends FromJavaStringUTF16Node {

            @TruffleBoundary
            @Override
            TruffleString execute(String arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
                return doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ToJavaStringNode.class)
    static final class ToJavaStringNodeGen extends ToJavaStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CreateJavaStringNode createStringNode;
        @Child private GetCodePointLengthNode generic_getCodePointLengthNode_;
        @Child private GetCodeRangeNode generic_getCodeRangeNode_;
        @Child private TransCodeNode generic_transCodeNode_;

        private ToJavaStringNodeGen() {
        }

        @Override
        TruffleString execute(TruffleString arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doUTF16(TruffleString, Object, CreateJavaStringNode) || doGeneric(TruffleString, Object, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, CreateJavaStringNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doUTF16(TruffleString, Object, CreateJavaStringNode) */) {
                    if ((arg0Value.isCompatibleTo(Encoding.UTF_16))) {
                        return ToJavaStringNode.doUTF16(arg0Value, arg1Value, this.createStringNode);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doGeneric(TruffleString, Object, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, CreateJavaStringNode) */) {
                    if ((!(arg0Value.isCompatibleTo(Encoding.UTF_16)))) {
                        return ToJavaStringNode.doGeneric(arg0Value, arg1Value, this.generic_getCodePointLengthNode_, this.generic_getCodeRangeNode_, this.generic_transCodeNode_, this.createStringNode);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleString executeAndSpecialize(TruffleString arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((arg0Value.isCompatibleTo(Encoding.UTF_16))) {
                    this.createStringNode = super.insert(this.createStringNode == null ? ((CreateJavaStringNodeGen.create())) : this.createStringNode);
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doUTF16(TruffleString, Object, CreateJavaStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ToJavaStringNode.doUTF16(arg0Value, arg1Value, this.createStringNode);
                }
                if ((!(arg0Value.isCompatibleTo(Encoding.UTF_16)))) {
                    this.generic_getCodePointLengthNode_ = super.insert((GetCodePointLengthNodeGen.create()));
                    this.generic_getCodeRangeNode_ = super.insert((GetCodeRangeNodeGen.create()));
                    this.generic_transCodeNode_ = super.insert((TransCodeNodeGen.create()));
                    this.createStringNode = super.insert(this.createStringNode == null ? ((CreateJavaStringNodeGen.create())) : this.createStringNode);
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doGeneric(TruffleString, Object, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, CreateJavaStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ToJavaStringNode.doGeneric(arg0Value, arg1Value, this.generic_getCodePointLengthNode_, this.generic_getCodeRangeNode_, this.generic_transCodeNode_, this.createStringNode);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ToJavaStringNode create() {
            return new ToJavaStringNodeGen();
        }

        public static ToJavaStringNode getUncached() {
            return ToJavaStringNodeGen.UNCACHED;
        }

        @GeneratedBy(ToJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends ToJavaStringNode {

            @TruffleBoundary
            @Override
            TruffleString execute(TruffleString arg0Value, Object arg1Value) {
                if ((arg0Value.isCompatibleTo(Encoding.UTF_16))) {
                    return ToJavaStringNode.doUTF16(arg0Value, arg1Value, (CreateJavaStringNodeGen.getUncached()));
                }
                if ((!(arg0Value.isCompatibleTo(Encoding.UTF_16)))) {
                    return ToJavaStringNode.doGeneric(arg0Value, arg1Value, (GetCodePointLengthNode.getUncached()), (GetCodeRangeNode.getUncached()), (TransCodeNodeGen.getUncached()), (CreateJavaStringNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CreateJavaStringNode.class)
    static final class CreateJavaStringNodeGen extends CreateJavaStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile reuseProfile_;
        @Child private GetCodeRangeNode getCodeRangeNode_;

        private CreateJavaStringNodeGen() {
        }

        @Override
        String execute(AbstractTruffleString arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 createJavaString(AbstractTruffleString, Object, ConditionProfile, GetCodeRangeNode) */) {
                return createJavaString(arg0Value, arg1Value, this.reuseProfile_, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private String executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.reuseProfile_ = (ConditionProfile.create());
                this.getCodeRangeNode_ = super.insert((GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 createJavaString(AbstractTruffleString, Object, ConditionProfile, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return createJavaString(arg0Value, arg1Value, this.reuseProfile_, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CreateJavaStringNode create() {
            return new CreateJavaStringNodeGen();
        }

        public static CreateJavaStringNode getUncached() {
            return CreateJavaStringNodeGen.UNCACHED;
        }

        @GeneratedBy(CreateJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends CreateJavaStringNode {

            @TruffleBoundary
            @Override
            String execute(AbstractTruffleString arg0Value, Object arg1Value) {
                return createJavaString(arg0Value, arg1Value, (ConditionProfile.getUncached()), (GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(TransCodeNode.class)
    static final class TransCodeNodeGen extends TransCodeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile asciiBytesInvalidProfile_;
        @Child private TransCodeIntlNode transCodeIntlNode_;

        private TransCodeNodeGen() {
        }

        @Override
        TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 transcode(AbstractTruffleString, Object, int, int, Encoding, ConditionProfile, TransCodeIntlNode) */) {
                return transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.asciiBytesInvalidProfile_, this.transCodeIntlNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.asciiBytesInvalidProfile_ = (ConditionProfile.create());
                this.transCodeIntlNode_ = super.insert((TransCodeIntlNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 transcode(AbstractTruffleString, Object, int, int, Encoding, ConditionProfile, TransCodeIntlNode) */;
                lock.unlock();
                hasLock = false;
                return transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.asciiBytesInvalidProfile_, this.transCodeIntlNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static TransCodeNode create() {
            return new TransCodeNodeGen();
        }

        public static TransCodeNode getUncached() {
            return TransCodeNodeGen.UNCACHED;
        }

        @GeneratedBy(TransCodeNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeNode {

            @TruffleBoundary
            @Override
            TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ConditionProfile.getUncached()), (TransCodeIntlNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(TransCodeIntlNode.class)
    static final class TransCodeIntlNodeGen extends TransCodeIntlNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private NextNode iteratorNextNode;
        @CompilationFinal private ConditionProfile brokenProfile;
        @CompilationFinal private BranchProfile outOfMemoryProfile;
        @Child private UnsupportedData unsupported_cache;

        private TransCodeIntlNodeGen() {
        }

        @Override
        TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 targetAscii(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) || latin1Transcode(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) || utf8TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) || utf8TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) || utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding) || utf16TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) || utf16TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) || utf32TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) || utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding) || utf32TranscodeUTF16(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) || unsupported(AbstractTruffleString, Object, int, int, Encoding, Encoding, BranchProfile, ConditionProfile, FromBufferWithStringCompactionNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 targetAscii(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isAscii(arg5Value) || TStringGuards.isBytes(arg5Value))) {
                        return targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 latin1Transcode(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isLatin1(arg5Value))) {
                        return latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf8TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF8(arg5Value))) {
                        return utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 utf8TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF8(arg5Value))) {
                        return utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding) */) {
                    if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isUTF16(arg5Value))) {
                        return utf16Fixed32Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 utf16TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF16(arg5Value))) {
                        return utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.outOfMemoryProfile);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 utf16TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF16(arg5Value))) {
                        return utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.outOfMemoryProfile);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is-state_0 utf32TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */) {
                    if ((!(TStringGuards.isUTF16(arg4Value))) && (TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                        return utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is-state_0 utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding) */) {
                    if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF32(arg5Value))) {
                        return TransCodeIntlNode.utf32TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is-state_0 utf32TranscodeUTF16(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */) {
                    if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                        return utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is-state_0 unsupported(AbstractTruffleString, Object, int, int, Encoding, Encoding, BranchProfile, ConditionProfile, FromBufferWithStringCompactionNode) */) {
                    UnsupportedData s10_ = this.unsupported_cache;
                    if (s10_ != null) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value) || TStringGuards.isUnsupportedEncoding(arg5Value))) {
                            return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s10_.outOfMemoryProfile_, s10_.nativeProfile_, s10_.fromBufferWithStringCompactionNode_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isAscii(arg5Value) || TStringGuards.isBytes(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 targetAscii(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isLatin1(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 latin1Transcode(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF8(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.brokenProfile = this.brokenProfile == null ? ((ConditionProfile.create())) : this.brokenProfile;
                    this.outOfMemoryProfile = this.outOfMemoryProfile == null ? ((BranchProfile.create())) : this.outOfMemoryProfile;
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf8TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF8(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.brokenProfile = this.brokenProfile == null ? ((ConditionProfile.create())) : this.brokenProfile;
                    this.outOfMemoryProfile = this.outOfMemoryProfile == null ? ((BranchProfile.create())) : this.outOfMemoryProfile;
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 utf8TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isUTF16(arg5Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16Fixed32Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF16(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.outOfMemoryProfile = this.outOfMemoryProfile == null ? ((BranchProfile.create())) : this.outOfMemoryProfile;
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 utf16TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF16(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.outOfMemoryProfile = this.outOfMemoryProfile == null ? ((BranchProfile.create())) : this.outOfMemoryProfile;
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 utf16TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if ((!(TStringGuards.isUTF16(arg4Value))) && (TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.state_0_ = state_0 = state_0 | 0b10000000 /* add-state_0 utf32TranscodeRegular(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF32(arg5Value))) {
                    this.state_0_ = state_0 = state_0 | 0b100000000 /* add-state_0 utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return TransCodeIntlNode.utf32TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                    this.iteratorNextNode = super.insert(this.iteratorNextNode == null ? ((NextNode.create())) : this.iteratorNextNode);
                    this.state_0_ = state_0 = state_0 | 0b1000000000 /* add-state_0 utf32TranscodeUTF16(AbstractTruffleString, Object, int, int, Encoding, Encoding, NextNode) */;
                    lock.unlock();
                    hasLock = false;
                    return utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value) || TStringGuards.isUnsupportedEncoding(arg5Value))) {
                    UnsupportedData s10_ = super.insert(new UnsupportedData());
                    s10_.outOfMemoryProfile_ = (BranchProfile.create());
                    s10_.nativeProfile_ = (ConditionProfile.create());
                    s10_.fromBufferWithStringCompactionNode_ = s10_.insertAccessor((FromBufferWithStringCompactionNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.unsupported_cache = s10_;
                    this.state_0_ = state_0 = state_0 | 0b10000000000 /* add-state_0 unsupported(AbstractTruffleString, Object, int, int, Encoding, Encoding, BranchProfile, ConditionProfile, FromBufferWithStringCompactionNode) */;
                    lock.unlock();
                    hasLock = false;
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s10_.outOfMemoryProfile_, s10_.nativeProfile_, s10_.fromBufferWithStringCompactionNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static TransCodeIntlNode create() {
            return new TransCodeIntlNodeGen();
        }

        public static TransCodeIntlNode getUncached() {
            return TransCodeIntlNodeGen.UNCACHED;
        }

        @GeneratedBy(TransCodeIntlNode.class)
        private static final class UnsupportedData extends Node {

            @CompilationFinal BranchProfile outOfMemoryProfile_;
            @CompilationFinal ConditionProfile nativeProfile_;
            @Child FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode_;

            UnsupportedData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(TransCodeIntlNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeIntlNode {

            @TruffleBoundary
            @Override
            TruffleString execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, Encoding arg5Value) {
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isAscii(arg5Value) || TStringGuards.isBytes(arg5Value))) {
                    return targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TStringGuards.isLatin1(arg5Value))) {
                    return latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF8(arg5Value))) {
                    return utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF8(arg5Value))) {
                    return utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isUTF16(arg5Value))) {
                    return utf16Fixed32Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF16(arg5Value))) {
                    return utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()), (BranchProfile.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF16(arg5Value))) {
                    return utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()), (BranchProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16(arg4Value))) && (TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                    return utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (TransCodeIntlNode.isLarge(arg2Value)) && (TStringGuards.isUTF32(arg5Value))) {
                    return TransCodeIntlNode.utf32TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value))) && (!(TransCodeIntlNode.isLarge(arg2Value))) && (TStringGuards.isUTF32(arg5Value))) {
                    return utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (NextNode.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value) || TStringGuards.isUnsupportedEncoding(arg5Value))) {
                    return unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (BranchProfile.getUncached()), (ConditionProfile.getUncached()), (FromBufferWithStringCompactionNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
