/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;

class ReadOnlyFrame
implements Frame {
    private final Frame delegate;

    ReadOnlyFrame(Frame delegate) {
        this.delegate = delegate;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public FrameDescriptor getFrameDescriptor() {
        return this.delegate.getFrameDescriptor();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object[] getArguments() {
        return (Object[])this.delegate.getArguments().clone();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getObject(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getObject(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setObject(FrameSlot slot, Object value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByte(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getByte(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setByte(FrameSlot slot, byte value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean getBoolean(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getBoolean(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setBoolean(FrameSlot slot, boolean value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getInt(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getInt(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setInt(FrameSlot slot, int value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    private static AssertionError newReadonlyAssertionError() {
        return new AssertionError((Object)"Unexpected write access.");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getLong(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getLong(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setLong(FrameSlot slot, long value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float getFloat(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getFloat(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setFloat(FrameSlot slot, float value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double getDouble(FrameSlot slot) throws FrameSlotTypeException {
        return this.delegate.getDouble(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setDouble(FrameSlot slot, double value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getValue(FrameSlot slot) {
        return this.delegate.getValue(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public MaterializedFrame materialize() {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isObject(FrameSlot slot) {
        return this.delegate.isObject(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isByte(FrameSlot slot) {
        return this.delegate.isByte(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isBoolean(FrameSlot slot) {
        return this.delegate.isBoolean(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isInt(FrameSlot slot) {
        return this.delegate.isInt(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isLong(FrameSlot slot) {
        return this.delegate.isLong(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isFloat(FrameSlot slot) {
        return this.delegate.isFloat(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isDouble(FrameSlot slot) {
        return this.delegate.isDouble(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void clear(FrameSlot slot) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getObject(int slot) throws FrameSlotTypeException {
        return this.delegate.getObject(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setObject(int slot, Object value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByte(int slot) throws FrameSlotTypeException {
        return this.delegate.getByte(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setByte(int slot, byte value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean getBoolean(int slot) throws FrameSlotTypeException {
        return this.delegate.getBoolean(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setBoolean(int slot, boolean value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getInt(int slot) throws FrameSlotTypeException {
        return this.delegate.getInt(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setInt(int slot, int value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getLong(int slot) throws FrameSlotTypeException {
        return this.delegate.getLong(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setLong(int slot, long value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float getFloat(int slot) throws FrameSlotTypeException {
        return this.delegate.getFloat(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setFloat(int slot, float value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double getDouble(int slot) throws FrameSlotTypeException {
        return this.delegate.getDouble(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setDouble(int slot, double value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getValue(int slot) {
        return this.delegate.getValue(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void copy(int srcSlot, int destSlot) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getTag(int slot) {
        return this.delegate.getTag(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isObject(int slot) {
        return this.delegate.isObject(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isByte(int slot) {
        return this.delegate.isByte(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isBoolean(int slot) {
        return this.delegate.isBoolean(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isInt(int slot) {
        return this.delegate.isInt(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isLong(int slot) {
        return this.delegate.isLong(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isFloat(int slot) {
        return this.delegate.isFloat(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isDouble(int slot) {
        return this.delegate.isDouble(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void clear(int slot) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getAuxiliarySlot(int slot) {
        return this.delegate.getAuxiliarySlot(slot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setAuxiliarySlot(int slot, Object value) {
        throw ReadOnlyFrame.newReadonlyAssertionError();
    }
}

