/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;

final class PolyglotThreadLocalActions {
    private static final ThreadLocalHandshake TL_HANDSHAKE = EngineAccessor.ACCESSOR.runtimeSupport().getThreadLocalHandshake();
    private final PolyglotContextImpl context;
    private final Map<AbstractTLHandshake, Void> activeEvents = new LinkedHashMap<AbstractTLHandshake, Void>();
    private final TruffleLogger logger;
    private long idCounter;
    private final boolean traceActions;
    private final List<PolyglotStatisticsAction> statistics;
    private final Timer intervalTimer;

    PolyglotThreadLocalActions(PolyglotContextImpl context) {
        this.context = context;
        OptionValuesImpl options = this.context.engine.getEngineOptionValues();
        this.statistics = options.get(PolyglotEngineOptions.SafepointALot) != false ? new ArrayList<PolyglotStatisticsAction>() : null;
        this.traceActions = options.get(PolyglotEngineOptions.TraceThreadLocalActions);
        long interval = options.get(PolyglotEngineOptions.TraceStackTraceInterval);
        if (interval > 0L) {
            this.intervalTimer = new Timer(true);
            this.setupIntervalTimer(interval);
        } else {
            this.intervalTimer = null;
        }
        this.logger = this.statistics != null || this.traceActions || interval > 0L ? this.context.engine.getEngineLogger() : null;
    }

    private void setupIntervalTimer(long interval) {
        this.intervalTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PolyglotThreadLocalActions.this.submit(null, "engine", new PrintStackTraceAction(false, false), true);
            }
        }, interval, interval);
    }

    void notifyEnterCreatedThread() {
        assert (Thread.holdsLock(this.context));
        TL_HANDSHAKE.ensureThreadInitialized();
        if (this.statistics != null) {
            PolyglotStatisticsAction collector = new PolyglotStatisticsAction(this, Thread.currentThread());
            this.statistics.add(collector);
            this.submit(new Thread[]{Thread.currentThread()}, "engine", collector, false);
        }
    }

    void notifyContextClosed() {
        assert (Thread.holdsLock(this.context));
        assert (!this.context.isActive()) : "context is still active, cannot flush safepoints";
        if (this.intervalTimer != null) {
            this.intervalTimer.cancel();
        }
        if (!this.activeEvents.isEmpty()) {
            ArrayList<AbstractTLHandshake> activeEventsList = new ArrayList<AbstractTLHandshake>(this.activeEvents.keySet());
            for (AbstractTLHandshake handshake : activeEventsList) {
                Future<Void> future = handshake.future;
                if (future.isDone()) continue;
                if (this.context.invalid || this.context.cancelled) {
                    future.cancel(true);
                    continue;
                }
                throw new AssertionError((Object)("Pending thread local actions found. Did the actions not process on last leave? Pending action: " + handshake.action));
            }
            this.activeEvents.clear();
        }
        if (this.statistics != null) {
            this.logStatistics();
        }
    }

    private void logStatistics() {
        LongSummaryStatistics all = new LongSummaryStatistics();
        StringBuilder s = new StringBuilder();
        s.append(String.format("Safepoint Statistics %n", new Object[0]));
        s.append(String.format("  -------------------------------------------------------------------------------------- %n", new Object[0]));
        s.append(String.format("   Thread Name         Safepoints | Interval     Avg              Min              Max %n", new Object[0]));
        s.append(String.format("  -------------------------------------------------------------------------------------- %n", new Object[0]));
        for (PolyglotStatisticsAction statistic : this.statistics) {
            all.combine(statistic.intervalStatistics);
            PolyglotThreadLocalActions.formatStatisticLine(s, "  " + statistic.threadName, statistic.intervalStatistics);
        }
        s.append(String.format("  ------------------------------------------------------------------------------------- %n", new Object[0]));
        PolyglotThreadLocalActions.formatStatisticLine(s, "  All threads", all);
        this.logger.log(Level.INFO, s.toString());
        this.statistics.clear();
    }

    private static void formatStatisticLine(StringBuilder s, String label, LongSummaryStatistics statistics) {
        s.append(String.format(" %-20s  %10d | %16.3f us  %12.1f us  %12.1f us%n", label, statistics.getCount() + 1L, statistics.getAverage() / 1000.0, (double)statistics.getMin() / 1000.0, (double)statistics.getMax() / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Void> submit(Thread[] threads, String originId, ThreadLocalAction action, boolean needsEnter) {
        TL_HANDSHAKE.testSupport();
        Objects.requireNonNull(action);
        if (threads != null) {
            for (int i = 0; i < threads.length; ++i) {
                Objects.requireNonNull(threads[i]);
            }
        }
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.context.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            if (this.context.closed) {
                throw new IllegalStateException("Thread local actions can no longer be submitted for this context as it is already closed.");
            }
            HashSet<Thread> filterThreads = null;
            if (threads != null) {
                filterThreads = new HashSet<Thread>(Arrays.asList(threads));
            }
            boolean sync = EngineAccessor.LANGUAGE.isSynchronousTLAction(action);
            boolean sideEffect = EngineAccessor.LANGUAGE.isSideEffectingTLAction(action);
            ArrayList<Thread> activePolyglotThreads = new ArrayList<Thread>();
            for (PolyglotThreadInfo info : this.context.getSeenThreads().values()) {
                Thread t = info.getThread();
                if (!info.isActiveNotCancelled() || filterThreads != null && !filterThreads.contains(t)) continue;
                if (info.isCurrent() && sync && info.isSafepointActive()) {
                    throw new IllegalStateException("Recursive synchronous thread local action detected. They are disallowed as they may cause deadlocks. Schedule an asynchronous thread local action instead.");
                }
                activePolyglotThreads.add(t);
            }
            Thread[] activeThreads = activePolyglotThreads.toArray(new Thread[0]);
            AbstractTLHandshake handshake = sync ? new SyncEvent(this.context, threads, originId, action, needsEnter) : new AsyncEvent(this.context, threads, originId, action, needsEnter);
            if (this.traceActions) {
                String threadLabel = threads == null ? "all-threads" : (threads.length == 1 ? "single-thread" : "multiple-threads-" + threads.length);
                threadLabel = threadLabel + "[alive=" + activePolyglotThreads.size() + "]";
                String sideEffectLabel = sideEffect ? "side-effecting  " : "side-effect-free";
                String syncLabel = sync ? "synchronous " : "asynchronous";
                handshake.debugId = this.idCounter++;
                this.log("submit", handshake, String.format("%-25s  %s  %s", threadLabel, sideEffectLabel, syncLabel));
            }
            if (activeThreads.length > 0) {
                handshake.future = TL_HANDSHAKE.runThreadLocal(activeThreads, handshake, AbstractTLHandshake::notifyDone, EngineAccessor.LANGUAGE.isSideEffectingTLAction(action), sync);
                Future<Void> future = handshake.future;
                this.activeEvents.put(handshake, null);
                return future;
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private void log(String action, AbstractTLHandshake handshake, String details) {
        if (this.traceActions) {
            this.logger.log(Level.INFO, String.format("[tl] %-18s %8d  %-30s %-10s %-30s %s", action, handshake.debugId, "thread[" + Thread.currentThread().getName() + "]", handshake.originId, "action[" + handshake.action.toString() + "]", details));
        }
    }

    void notifyThreadActivation(PolyglotThreadInfo info, boolean active) {
        assert (info.getEnteredCount() == (active ? 1 : 0)) : "must be currently entered successfully";
        assert (Thread.holdsLock(this.context));
        if (this.activeEvents.isEmpty()) {
            return;
        }
        TruffleSafepoint s = TruffleSafepoint.getCurrent();
        ArrayList<AbstractTLHandshake> activeEventsList = new ArrayList<AbstractTLHandshake>(this.activeEvents.keySet());
        for (AbstractTLHandshake handshake : activeEventsList) {
            if (!handshake.isEnabledForThread(Thread.currentThread())) continue;
            if (active) {
                TL_HANDSHAKE.activateThread(s, handshake.future);
                continue;
            }
            TL_HANDSHAKE.deactivateThread(s, handshake.future);
        }
    }

    void notifyLastDone(AbstractTLHandshake handshake) {
        assert (Thread.holdsLock(this.context));
        if (this.activeEvents.remove(handshake, null) && this.traceActions) {
            if (handshake.future.isCancelled()) {
                this.log("cancelled", handshake, "");
            } else {
                this.log("done", handshake, "");
            }
        }
    }

    private static final class PolyglotStatisticsAction
    extends ThreadLocalAction {
        private static volatile ThreadMXBean threadBean;
        private final PolyglotThreadLocalActions actions;
        private long prevTime = 0L;
        private final LongSummaryStatistics intervalStatistics = new LongSummaryStatistics();
        private final String threadName;

        PolyglotStatisticsAction(PolyglotThreadLocalActions actions, Thread thread) {
            super(false, false);
            this.actions = actions;
            this.threadName = thread.getName();
        }

        @Override
        protected void perform(ThreadLocalAction.Access access) {
            long prev = this.prevTime;
            if (prev != 0L) {
                long now = System.nanoTime();
                this.intervalStatistics.accept(now - prev);
            }
            this.actions.submit(new Thread[]{access.getThread()}, "engine", this, false);
            this.prevTime = System.nanoTime();
        }

        @CompilerDirectives.TruffleBoundary
        static long getCurrentCPUTime() {
            ThreadMXBean bean = threadBean;
            if (bean == null) {
                threadBean = bean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
            }
            return bean.getCurrentThreadCpuTime();
        }

        public String toString() {
            return "PolyglotStatisticsAction@" + Integer.toHexString(this.hashCode());
        }
    }

    private static final class SyncEvent
    extends AbstractTLHandshake {
        SyncEvent(PolyglotContextImpl context, Thread[] filterThreads, String originId, ThreadLocalAction action, boolean needsEnter) {
            super(context, filterThreads, originId, action, needsEnter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void acceptImpl(PolyglotTLAccess access) {
            PolyglotThreadInfo thread;
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                thread = this.context.getCachedThreadInfo();
            }
            thread.setSafepointActive(true);
            try {
                EngineAccessor.LANGUAGE.performTLAction(this.action, access);
            }
            finally {
                thread.setSafepointActive(false);
            }
        }
    }

    private static final class AsyncEvent
    extends AbstractTLHandshake {
        AsyncEvent(PolyglotContextImpl context, Thread[] filerThreads, String originId, ThreadLocalAction action, boolean needsEnter) {
            super(context, filerThreads, originId, action, needsEnter);
        }

        @Override
        protected void acceptImpl(PolyglotTLAccess access) {
            EngineAccessor.LANGUAGE.performTLAction(this.action, access);
        }
    }

    static abstract class AbstractTLHandshake
    implements Consumer<Node> {
        private final String originId;
        final ThreadLocalAction action;
        long debugId;
        protected final PolyglotContextImpl context;
        private final boolean needsEnter;
        final Thread[] filterThreads;
        Future<Void> future;

        AbstractTLHandshake(PolyglotContextImpl context, Thread[] filterThreads, String originId, ThreadLocalAction action, boolean needsEnter) {
            this.action = action;
            this.originId = originId;
            this.context = context;
            this.needsEnter = needsEnter;
            this.filterThreads = filterThreads;
        }

        final boolean isEnabledForThread(Thread currentThread) {
            if (this.filterThreads == null) {
                return true;
            }
            for (Thread filterThread : this.filterThreads) {
                if (filterThread != currentThread) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void notifyDone() {
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                this.context.threadLocalActions.notifyLastDone(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void accept(Node location) {
            if (this.context.closed) {
                return;
            }
            Object prev = null;
            if (this.needsEnter) {
                prev = this.context.engine.enterIfNeeded(this.context, false);
            }
            try {
                this.notifyStart();
                PolyglotTLAccess access = new PolyglotTLAccess(Thread.currentThread(), location);
                try {
                    this.acceptImpl(access);
                }
                finally {
                    access.invalid = true;
                }
                this.notifySuccess();
            }
            catch (Throwable t) {
                if (!EngineAccessor.LANGUAGE.isSideEffectingTLAction(this.action) && InteropLibrary.getUncached().isException(t)) {
                    AssertionError e = new AssertionError("Throwing Truffle exception is disallowed in non-side-effecting thread local actions.", t);
                    this.notifyFailed((Throwable)((Object)e));
                    throw e;
                }
                this.notifyFailed(t);
                throw t;
            }
            finally {
                if (this.needsEnter) {
                    this.context.engine.leaveIfNeeded(prev, this.context);
                }
            }
        }

        private void notifyStart() {
            this.context.threadLocalActions.log("  perform-start", this, "");
        }

        private void notifySuccess() {
            this.context.threadLocalActions.log("  perform-done", this, "");
        }

        private void notifyFailed(Throwable t) {
            if (this.context.threadLocalActions.traceActions) {
                this.context.threadLocalActions.log("  perform-failed", this, " exception: " + t.toString());
            }
        }

        protected abstract void acceptImpl(PolyglotTLAccess var1);
    }

    static final class PolyglotTLAccess
    extends ThreadLocalAction.Access {
        final Thread thread;
        final Node location;
        volatile boolean invalid;

        PolyglotTLAccess(Thread thread, Node location) {
            super(PolyglotImpl.getInstance());
            this.thread = thread;
            this.location = location;
        }

        @Override
        public Node getLocation() {
            this.checkInvalid();
            return this.location;
        }

        @Override
        public Thread getThread() {
            this.checkInvalid();
            return Thread.currentThread();
        }

        private void checkInvalid() {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("ThreadLocalAccess used on the wrong thread.");
            }
            if (this.invalid) {
                throw new IllegalStateException("ThreadLocalAccess is no longer valid.");
            }
        }
    }

    private final class PrintStackTraceAction
    extends ThreadLocalAction {
        PrintStackTraceAction(boolean hasSideEffects, boolean synchronous) {
            super(hasSideEffects, synchronous);
        }

        @Override
        protected void perform(ThreadLocalAction.Access access) {
            PolyglotThreadLocalActions.this.logger.log(Level.INFO, String.format("Stack Trace Thread %s: %s", Thread.currentThread().getName(), PolyglotExceptionImpl.printStackToString(PolyglotThreadLocalActions.this.context.getHostContext(), access.getLocation())));
        }
    }
}

