// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.polyglot.HostMethodDesc.OverloadedMethod;
import com.oracle.truffle.polyglot.HostMethodDesc.SingleMethod;
import com.oracle.truffle.polyglot.HostMethodDesc.SingleMethod.MHBase;
import com.oracle.truffle.polyglot.HostMethodDesc.SingleMethod.ReflectBase;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory.ToGuestValueNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(HostExecuteNode.class)
final class HostExecuteNodeGen extends HostExecuteNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private volatile int state_0_;
    @CompilationFinal private volatile int exclude_;
    @Child private ToHostNode toHost;
    @Child private ToGuestValueNode toGuest;
    @CompilationFinal private ConditionProfile varArgsProfile;
    @Child private HostMethodProfileNode hostMethodProfile;
    @CompilationFinal private BranchProfile errorBranch;
    @CompilationFinal private PolyglotEngineImpl engine;
    @Child private FixedData fixed_cache;
    @Child private VarArgsData varArgs_cache;
    @Child private OverloadedCachedData overloadedCached_cache;

    private HostExecuteNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(HostMethodDesc arg0Value, Object arg1Value, Object[] arg2Value, PolyglotLanguageContext arg3Value) throws UnsupportedTypeException, ArityException {
        int state_0 = state_0_;
        if (state_0 != 0 /* is-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) || doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) || doSingleUncached(SingleMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) || doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) || doOverloadedUncached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */) {
            if ((state_0 & 0b111) != 0 /* is-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) || doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) || doSingleUncached(SingleMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */ && arg0Value instanceof SingleMethod) {
                SingleMethod arg0Value_ = (SingleMethod) arg0Value;
                if ((state_0 & 0b1) != 0 /* is-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */ && (!(arg0Value_.isVarArgs()))) {
                    FixedData s1_ = this.fixed_cache;
                    while (s1_ != null) {
                        if ((arg0Value_ == s1_.cachedMethod_)) {
                            return doFixed(arg0Value_, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.toJavaNodes_, s1_.toGuest_, s1_.receiverProfile_, s1_.errorBranch_, s1_.engine_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */ && (arg0Value_.isVarArgs())) {
                    VarArgsData s2_ = this.varArgs_cache;
                    while (s2_ != null) {
                        if ((arg0Value_ == s2_.cachedMethod_)) {
                            return doVarArgs(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.cachedMethod_, s2_.toJavaNode_, s2_.toGuest_, s2_.receiverProfile_, s2_.errorBranch_, s2_.engine_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 doSingleUncached(SingleMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */) {
                    return HostExecuteNode.doSingleUncached(arg0Value_, arg1Value, arg2Value, arg3Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.engine);
                }
            }
            if ((state_0 & 0b11000) != 0 /* is-state_0 doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) || doOverloadedUncached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */ && arg0Value instanceof OverloadedMethod) {
                OverloadedMethod arg0Value_ = (OverloadedMethod) arg0Value;
                if ((state_0 & 0b1000) != 0 /* is-state_0 doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */) {
                    OverloadedCachedData s4_ = this.overloadedCached_cache;
                    while (s4_ != null) {
                        if ((arg0Value_ == s4_.cachedMethod_) && (HostExecuteNode.checkArgTypes(arg2Value, s4_.cachedArgTypes_, s4_.interop_, arg3Value, s4_.asVarArgs_))) {
                            return doOverloadedCached(arg0Value_, arg1Value, arg2Value, arg3Value, s4_.cachedMethod_, s4_.toJavaNode_, s4_.toGuest_, s4_.interop_, s4_.cachedArgTypes_, s4_.overload_, s4_.asVarArgs_, s4_.receiverProfile_, s4_.errorBranch_, s4_.engine_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 doOverloadedUncached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */) {
                    return doOverloadedUncached(arg0Value_, arg1Value, arg2Value, arg3Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.engine);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(HostMethodDesc arg0Value, Object arg1Value, Object[] arg2Value, PolyglotLanguageContext arg3Value) throws ArityException, UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = state_0_;
        int exclude = exclude_;
        int oldState_0 = state_0;
        int oldExclude = exclude;
        int oldCacheCount = countCaches();
        try {
            if (arg0Value instanceof SingleMethod) {
                SingleMethod arg0Value_ = (SingleMethod) arg0Value;
                if (((exclude & 0b1)) == 0 /* is-not-exclude doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */ && (!(arg0Value_.isVarArgs()))) {
                    int count1_ = 0;
                    FixedData s1_ = this.fixed_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */) {
                        while (s1_ != null) {
                            if ((arg0Value_ == s1_.cachedMethod_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value_ == s1_.cachedMethod_);
                        if (count1_ < (HostExecuteNode.LIMIT)) {
                            s1_ = super.insert(new FixedData(fixed_cache));
                            s1_.cachedMethod_ = (arg0Value_);
                            s1_.toJavaNodes_ = s1_.insertAccessor((HostExecuteNode.createToHost(arg0Value_.getParameterCount())));
                            s1_.toGuest_ = s1_.insertAccessor((ToGuestValueNodeGen.create()));
                            s1_.receiverProfile_ = (ValueProfile.createClassProfile());
                            s1_.errorBranch_ = (BranchProfile.create());
                            s1_.engine_ = (arg3Value.context.engine);
                            this.fixed_cache = s1_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doFixed(arg0Value_, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.toJavaNodes_, s1_.toGuest_, s1_.receiverProfile_, s1_.errorBranch_, s1_.engine_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-exclude doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */ && (arg0Value_.isVarArgs())) {
                    int count2_ = 0;
                    VarArgsData s2_ = this.varArgs_cache;
                    if ((state_0 & 0b10) != 0 /* is-state_0 doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */) {
                        while (s2_ != null) {
                            if ((arg0Value_ == s2_.cachedMethod_)) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        // assert (arg0Value_ == s2_.cachedMethod_);
                        if (count2_ < (HostExecuteNode.LIMIT)) {
                            s2_ = super.insert(new VarArgsData(varArgs_cache));
                            s2_.cachedMethod_ = (arg0Value_);
                            s2_.toJavaNode_ = s2_.insertAccessor((ToHostNodeGen.create()));
                            s2_.toGuest_ = s2_.insertAccessor((ToGuestValueNodeGen.create()));
                            s2_.receiverProfile_ = (ValueProfile.createClassProfile());
                            s2_.errorBranch_ = (BranchProfile.create());
                            s2_.engine_ = (arg3Value.context.engine);
                            this.varArgs_cache = s2_;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doVarArgs(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.cachedMethod_, s2_.toJavaNode_, s2_.toGuest_, s2_.receiverProfile_, s2_.errorBranch_, s2_.engine_);
                    }
                }
                if (this.toHost == null) {
                    this.toHost = super.insert((ToHostNodeGen.create()));
                }
                if (this.toGuest == null) {
                    this.toGuest = super.insert((ToGuestValueNodeGen.create()));
                }
                if (this.varArgsProfile == null) {
                    this.varArgsProfile = (ConditionProfile.create());
                }
                if (this.hostMethodProfile == null) {
                    this.hostMethodProfile = super.insert((HostMethodProfileNodeGen.create()));
                }
                if (this.errorBranch == null) {
                    this.errorBranch = (BranchProfile.create());
                }
                if (this.engine == null) {
                    this.engine = (arg3Value.context.engine);
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-exclude doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl), doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                this.fixed_cache = null;
                this.varArgs_cache = null;
                state_0 = state_0 & 0xfffffffc /* remove-state_0 doFixed(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode[], ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl), doVarArgs(SingleMethod, Object, Object[], PolyglotLanguageContext, SingleMethod, ToHostNode, ToGuestValueNode, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doSingleUncached(SingleMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */;
                lock.unlock();
                hasLock = false;
                return HostExecuteNode.doSingleUncached(arg0Value_, arg1Value, arg2Value, arg3Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.engine);
            }
            if (arg0Value instanceof OverloadedMethod) {
                OverloadedMethod arg0Value_ = (OverloadedMethod) arg0Value;
                if (((exclude & 0b100)) == 0 /* is-not-exclude doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */) {
                    int count4_ = 0;
                    OverloadedCachedData s4_ = this.overloadedCached_cache;
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */) {
                        while (s4_ != null) {
                            if ((arg0Value_ == s4_.cachedMethod_) && (HostExecuteNode.checkArgTypes(arg2Value, s4_.cachedArgTypes_, s4_.interop_, arg3Value, s4_.asVarArgs_))) {
                                break;
                            }
                            s4_ = s4_.next_;
                            count4_++;
                        }
                    }
                    if (s4_ == null) {
                        {
                            InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.createDispatched(HostExecuteNode.LIMIT)));
                            TypeCheckNode[] cachedArgTypes__ = super.insert((HostExecuteNode.createArgTypesArray(arg2Value)));
                            SingleMethod overload__ = (selectOverload(arg0Value_, arg2Value, arg3Value, cachedArgTypes__));
                            boolean asVarArgs__ = (HostExecuteNode.asVarArgs(arg2Value, overload__, arg3Value));
                            // assert (arg0Value_ == s4_.cachedMethod_);
                            if ((HostExecuteNode.checkArgTypes(arg2Value, cachedArgTypes__, interop__, arg3Value, asVarArgs__)) && count4_ < (HostExecuteNode.LIMIT)) {
                                s4_ = super.insert(new OverloadedCachedData(overloadedCached_cache));
                                s4_.cachedMethod_ = (arg0Value_);
                                s4_.toJavaNode_ = s4_.insertAccessor((ToHostNodeGen.create()));
                                s4_.toGuest_ = s4_.insertAccessor((ToGuestValueNodeGen.create()));
                                s4_.interop_ = s4_.insertAccessor(interop__);
                                s4_.cachedArgTypes_ = s4_.insertAccessor(cachedArgTypes__);
                                s4_.overload_ = overload__;
                                s4_.asVarArgs_ = asVarArgs__;
                                s4_.receiverProfile_ = (ValueProfile.createClassProfile());
                                s4_.errorBranch_ = (BranchProfile.create());
                                s4_.engine_ = (arg3Value.context.engine);
                                this.overloadedCached_cache = s4_;
                                this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                            }
                        }
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doOverloadedCached(arg0Value_, arg1Value, arg2Value, arg3Value, s4_.cachedMethod_, s4_.toJavaNode_, s4_.toGuest_, s4_.interop_, s4_.cachedArgTypes_, s4_.overload_, s4_.asVarArgs_, s4_.receiverProfile_, s4_.errorBranch_, s4_.engine_);
                    }
                }
                if (this.toHost == null) {
                    this.toHost = super.insert((ToHostNodeGen.create()));
                }
                if (this.toGuest == null) {
                    this.toGuest = super.insert((ToGuestValueNodeGen.create()));
                }
                if (this.varArgsProfile == null) {
                    this.varArgsProfile = (ConditionProfile.create());
                }
                if (this.hostMethodProfile == null) {
                    this.hostMethodProfile = super.insert((HostMethodProfileNodeGen.create()));
                }
                if (this.errorBranch == null) {
                    this.errorBranch = (BranchProfile.create());
                }
                if (this.engine == null) {
                    this.engine = (arg3Value.context.engine);
                }
                this.exclude_ = exclude = exclude | 0b100 /* add-exclude doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                this.overloadedCached_cache = null;
                state_0 = state_0 & 0xfffffff7 /* remove-state_0 doOverloadedCached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, OverloadedMethod, ToHostNode, ToGuestValueNode, InteropLibrary, TypeCheckNode[], SingleMethod, boolean, ValueProfile, BranchProfile, PolyglotEngineImpl) */;
                this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doOverloadedUncached(OverloadedMethod, Object, Object[], PolyglotLanguageContext, ToHostNode, ToGuestValueNode, ConditionProfile, HostMethodProfileNode, BranchProfile, PolyglotEngineImpl) */;
                lock.unlock();
                hasLock = false;
                return doOverloadedUncached(arg0Value_, arg1Value, arg2Value, arg3Value, this.toHost, this.toGuest, this.varArgsProfile, this.hostMethodProfile, this.errorBranch, this.engine);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        } finally {
            if (oldState_0 != 0 || oldExclude != 0) {
                checkForPolymorphicSpecialize(oldState_0, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState_0, int oldExclude, int oldCacheCount) {
        int newState_0 = this.state_0_;
        int newExclude = this.exclude_;
        if (((oldState_0 ^ newState_0) != 0) || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        FixedData s1_ = this.fixed_cache;
        while (s1_ != null) {
            cacheCount++;
            s1_= s1_.next_;
        }
        VarArgsData s2_ = this.varArgs_cache;
        while (s2_ != null) {
            cacheCount++;
            s2_= s2_.next_;
        }
        OverloadedCachedData s4_ = this.overloadedCached_cache;
        while (s4_ != null) {
            cacheCount++;
            s4_= s4_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        int state_0 = state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                FixedData s1_ = this.fixed_cache;
                VarArgsData s2_ = this.varArgs_cache;
                OverloadedCachedData s4_ = this.overloadedCached_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static HostExecuteNode create() {
        return new HostExecuteNodeGen();
    }

    public static HostExecuteNode getUncached() {
        return HostExecuteNodeGen.UNCACHED;
    }

    @GeneratedBy(HostExecuteNode.class)
    private static final class FixedData extends Node {

        @Child FixedData next_;
        @CompilationFinal SingleMethod cachedMethod_;
        @Children ToHostNode[] toJavaNodes_;
        @Child ToGuestValueNode toGuest_;
        @CompilationFinal ValueProfile receiverProfile_;
        @CompilationFinal BranchProfile errorBranch_;
        @CompilationFinal PolyglotEngineImpl engine_;

        FixedData(FixedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    private static final class VarArgsData extends Node {

        @Child VarArgsData next_;
        @CompilationFinal SingleMethod cachedMethod_;
        @Child ToHostNode toJavaNode_;
        @Child ToGuestValueNode toGuest_;
        @CompilationFinal ValueProfile receiverProfile_;
        @CompilationFinal BranchProfile errorBranch_;
        @CompilationFinal PolyglotEngineImpl engine_;

        VarArgsData(VarArgsData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    private static final class OverloadedCachedData extends Node {

        @Child OverloadedCachedData next_;
        @CompilationFinal OverloadedMethod cachedMethod_;
        @Child ToHostNode toJavaNode_;
        @Child ToGuestValueNode toGuest_;
        @Child InteropLibrary interop_;
        @Children TypeCheckNode[] cachedArgTypes_;
        @CompilationFinal SingleMethod overload_;
        @CompilationFinal boolean asVarArgs_;
        @CompilationFinal ValueProfile receiverProfile_;
        @CompilationFinal BranchProfile errorBranch_;
        @CompilationFinal PolyglotEngineImpl engine_;

        OverloadedCachedData(OverloadedCachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(HostExecuteNode.class)
    private static final class Uncached extends HostExecuteNode {

        @TruffleBoundary
        @Override
        public Object execute(HostMethodDesc arg0Value, Object arg1Value, Object[] arg2Value, PolyglotLanguageContext arg3Value) throws UnsupportedTypeException, ArityException {
            if (arg0Value instanceof SingleMethod) {
                SingleMethod arg0Value_ = (SingleMethod) arg0Value;
                return HostExecuteNode.doSingleUncached(arg0Value_, arg1Value, arg2Value, arg3Value, (ToHostNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (ConditionProfile.getUncached()), (HostMethodProfileNodeGen.getUncached()), (BranchProfile.getUncached()), (arg3Value.context.engine));
            }
            if (arg0Value instanceof OverloadedMethod) {
                OverloadedMethod arg0Value_ = (OverloadedMethod) arg0Value;
                return doOverloadedUncached(arg0Value_, arg1Value, arg2Value, arg3Value, (ToHostNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (ConditionProfile.getUncached()), (HostMethodProfileNodeGen.getUncached()), (BranchProfile.getUncached()), (arg3Value.context.engine));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(HostMethodProfileNode.class)
    static final class HostMethodProfileNodeGen extends HostMethodProfileNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;
        @CompilationFinal private int exclude_;

        private HostMethodProfileNodeGen() {
        }

        @Override
        public SingleMethod execute(SingleMethod arg0Value) {
            int state_0 = state_0_;
            if ((state_0 & 0b1) != 0 /* is-state_0 mono(MHBase) */ && arg0Value instanceof MHBase) {
                MHBase arg0Value_ = (MHBase) arg0Value;
                return HostMethodProfileNode.mono(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is-state_0 mono(ReflectBase) */ && arg0Value instanceof ReflectBase) {
                ReflectBase arg0Value_ = (ReflectBase) arg0Value;
                return HostMethodProfileNode.mono(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is-state_0 poly(SingleMethod) */) {
                return HostMethodProfileNode.poly(arg0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private SingleMethod executeAndSpecialize(SingleMethod arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-exclude mono(MHBase) */ && arg0Value instanceof MHBase) {
                    MHBase arg0Value_ = (MHBase) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 mono(MHBase) */;
                    lock.unlock();
                    hasLock = false;
                    return HostMethodProfileNode.mono(arg0Value_);
                }
                if (((exclude & 0b10)) == 0 /* is-not-exclude mono(ReflectBase) */ && arg0Value instanceof ReflectBase) {
                    ReflectBase arg0Value_ = (ReflectBase) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 mono(ReflectBase) */;
                    lock.unlock();
                    hasLock = false;
                    return HostMethodProfileNode.mono(arg0Value_);
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-exclude mono(MHBase), mono(ReflectBase) */;
                state_0 = state_0 & 0xfffffffc /* remove-state_0 mono(MHBase), mono(ReflectBase) */;
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 poly(SingleMethod) */;
                lock.unlock();
                hasLock = false;
                return HostMethodProfileNode.poly(arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static HostMethodProfileNode create() {
            return new HostMethodProfileNodeGen();
        }

        public static HostMethodProfileNode getUncached() {
            return HostMethodProfileNodeGen.UNCACHED;
        }

        @GeneratedBy(HostMethodProfileNode.class)
        private static final class Uncached extends HostMethodProfileNode {

            @TruffleBoundary
            @Override
            public SingleMethod execute(SingleMethod arg0Value) {
                return HostMethodProfileNode.poly(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
