// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.PolyglotProxy;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotProxy.class)
final class PolyglotProxyGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(PolyglotProxy.class, new InteropLibraryExports());
    }

    private PolyglotProxyGen() {
    }

    @GeneratedBy(PolyglotProxy.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, PolyglotProxy.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof PolyglotProxy;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof PolyglotProxy;
            return new Cached();
        }

        @GeneratedBy(PolyglotProxy.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private int state_;
            @Child private InteropLibrary executables;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotProxy'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isInstantiable();
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.instantiate(arg1Value, (this));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.execute(arg1Value, (this));
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isPointer();
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asPointer((this));
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasArrayElements();
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readArrayElement(arg1Value, (this));
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeArrayElement(arg1Value, arg2Value, (this));
                return;
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeArrayElement(arg1Value, (this));
                return;
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getArraySize((this));
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementInsertable(arg1Value, (this));
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getMembers(arg1Value, (this));
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readMember(arg1Value, (this));
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this));
                return;
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active invokeMember(PolyglotProxy, String, Object[], InteropLibrary, InteropLibrary) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, (this), this.executables);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.executables == null) {
                        this.executables = super.insert((INTEROP_LIBRARY_.createDispatched(PolyglotProxy.LIMIT)));
                    }
                    this.state_ = state = state | 0b1 /* add-active invokeMember(PolyglotProxy, String, Object[], InteropLibrary, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, (this), this.executables);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active isMemberInvocable(PolyglotProxy, String, InteropLibrary, InteropLibrary) */) {
                    return arg0Value.isMemberInvocable(arg1Value, (this), this.executables);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.executables == null) {
                        this.executables = super.insert((INTEROP_LIBRARY_.createDispatched(PolyglotProxy.LIMIT)));
                    }
                    this.state_ = state = state | 0b10 /* add-active isMemberInvocable(PolyglotProxy, String, InteropLibrary, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberInvocable(arg1Value, (this), this.executables);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeMember(arg1Value, (this));
                return;
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, (this));
            }

            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTimeZone((this));
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDate((this));
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTime((this));
            }

            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asInstant((this));
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isDuration();
            }

            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDuration((this));
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).getMetaObject();
            }

        }
        @GeneratedBy(PolyglotProxy.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotProxy'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isInstantiable();
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.instantiate(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.execute(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asPointer((this));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasArrayElements();
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readArrayElement(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeArrayElement(arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeArrayElement(arg1Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getArraySize((this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementInsertable(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getMembers(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readMember(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, (this), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeMember(arg1Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isDate();
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isTime();
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isTimeZone();
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTimeZone((this));
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDate((this));
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTime((this));
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asInstant((this));
            }

            @TruffleBoundary
            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isDuration();
            }

            @TruffleBoundary
            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDuration((this));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .getMetaObject();
            }

        }
    }
}
