// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotExecuteNode.class)
@SuppressWarnings("unused")
final class PolyglotExecuteNodeGen extends PolyglotExecuteNode {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private Cached0Data cached0_cache;
    @Child private Cached1Data cached1_cache;

    private PolyglotExecuteNodeGen() {
    }

    @ExplodeLoop
    @Override
    protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value, Class<?> arg3Value, Type arg4Value) {
        int state = state_;
        if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */) {
            if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                Cached0Data s1_ = this.cached0_cache;
                while (s1_ != null) {
                    if ((s1_.interop_.accepts(arg1Value))) {
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.toHost_, s1_.executableCondition_, s1_.instantiableCondition_, s1_.unsupportedError_, s1_.arityError_, s1_.unsupportedArgumentError_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                Cached1Data s2_ = this.cached1_cache;
                if (s2_ != null) {
                    return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    @TruffleBoundary
    private Object cached1Boundary(int state, Cached1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value, Class<?> arg3Value, Type arg4Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.executableCondition_, s2_.instantiableCondition_, s2_.unsupportedError_, s2_.arityError_, s2_.unsupportedArgumentError_);
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value, Class<?> arg3Value, Type arg4Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                int count1_ = 0;
                Cached0Data s1_ = this.cached0_cache;
                if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg1Value))) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (s1_.interop_.accepts(arg1Value));
                    if (count1_ < (5)) {
                        s1_ = super.insert(new Cached0Data(cached0_cache));
                        s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                        s1_.toHost_ = s1_.insertAccessor((ToHostNodeGen.create()));
                        s1_.executableCondition_ = (ConditionProfile.createBinaryProfile());
                        s1_.instantiableCondition_ = (ConditionProfile.createBinaryProfile());
                        s1_.unsupportedError_ = (BranchProfile.create());
                        s1_.arityError_ = (BranchProfile.create());
                        s1_.unsupportedArgumentError_ = (BranchProfile.create());
                        this.cached0_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.toHost_, s1_.executableCondition_, s1_.instantiableCondition_, s1_.unsupportedError_, s1_.arityError_, s1_.unsupportedArgumentError_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    Cached1Data s2_ = super.insert(new Cached1Data());
                    s2_.toHost_ = s2_.insertAccessor((ToHostNodeGen.create()));
                    s2_.executableCondition_ = (ConditionProfile.createBinaryProfile());
                    s2_.instantiableCondition_ = (ConditionProfile.createBinaryProfile());
                    s2_.unsupportedError_ = (BranchProfile.create());
                    s2_.arityError_ = (BranchProfile.create());
                    s2_.unsupportedArgumentError_ = (BranchProfile.create());
                    this.cached1_cache = s2_;
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */;
                    this.cached0_cache = null;
                    state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */;
                    this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], Class<>, Type, InteropLibrary, ToHostNode, ConditionProfile, ConditionProfile, BranchProfile, BranchProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.executableCondition_, s2_.instantiableCondition_, s2_.unsupportedError_, s2_.arityError_, s2_.unsupportedArgumentError_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            Cached0Data s1_ = this.cached0_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static PolyglotExecuteNode create() {
        return new PolyglotExecuteNodeGen();
    }

    @GeneratedBy(PolyglotExecuteNode.class)
    private static final class Cached0Data extends Node {

        @Child Cached0Data next_;
        @Child InteropLibrary interop_;
        @Child ToHostNode toHost_;
        @CompilationFinal ConditionProfile executableCondition_;
        @CompilationFinal ConditionProfile instantiableCondition_;
        @CompilationFinal BranchProfile unsupportedError_;
        @CompilationFinal BranchProfile arityError_;
        @CompilationFinal BranchProfile unsupportedArgumentError_;

        Cached0Data(Cached0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(PolyglotExecuteNode.class)
    private static final class Cached1Data extends Node {

        @Child ToHostNode toHost_;
        @CompilationFinal ConditionProfile executableCondition_;
        @CompilationFinal ConditionProfile instantiableCondition_;
        @CompilationFinal BranchProfile unsupportedError_;
        @CompilationFinal BranchProfile arityError_;
        @CompilationFinal BranchProfile unsupportedArgumentError_;

        Cached1Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
