// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory.ToGuestValueNodeGen;
import com.oracle.truffle.polyglot.PolyglotList.Cache;
import com.oracle.truffle.polyglot.PolyglotList.Cache.GetNode;
import com.oracle.truffle.polyglot.PolyglotList.Cache.PolyglotListNode;
import com.oracle.truffle.polyglot.PolyglotList.Cache.RemoveNode;
import com.oracle.truffle.polyglot.PolyglotList.Cache.SetNode;
import com.oracle.truffle.polyglot.PolyglotList.Cache.SizeNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotList.class)
@SuppressWarnings("unused")
final class PolyglotListFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(Cache.class)
    static final class CacheFactory {

        @GeneratedBy(SizeNode.class)
        static final class SizeNodeGen extends SizeNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private SizeNodeGen(Cache cache) {
                super(cache);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (PolyglotListNode.LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static SizeNode create(Cache cache) {
                return new SizeNodeGen(cache);
            }

            @GeneratedBy(SizeNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary interop_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(GetNode.class)
        static final class GetNodeGen extends GetNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private ToHostNode cached1_toHost_;

            private GetNodeGen(Cache cache) {
                super(cache);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.toHost_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toHost_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (PolyglotListNode.LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toHost_ = s1_.insertAccessor((ToHostNodeGen.create()));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.toHost_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_toHost_ = super.insert((ToHostNodeGen.create()));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostNode) */;
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toHost_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static GetNode create(Cache cache) {
                return new GetNodeGen(cache);
            }

            @GeneratedBy(GetNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary interop_;
                @Child ToHostNode toHost_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(SetNode.class)
        static final class SetNodeGen extends SetNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private ToGuestValueNode cached1_toGuest_;

            private SetNodeGen(Cache cache) {
                super(cache);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.toGuest_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toGuest_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (PolyglotListNode.LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toGuest_ = s1_.insertAccessor((ToGuestValueNodeGen.create()));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.toGuest_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_toGuest_ = super.insert((ToGuestValueNodeGen.create()));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode) */;
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toGuest_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static SetNode create(Cache cache) {
                return new SetNodeGen(cache);
            }

            @GeneratedBy(SetNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary interop_;
                @Child ToGuestValueNode toGuest_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(RemoveNode.class)
        static final class RemoveNodeGen extends RemoveNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private RemoveNodeGen(Cache cache) {
                super(cache);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (PolyglotListNode.LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, s1_.interop_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static RemoveNode create(Cache cache) {
                return new RemoveNodeGen(cache);
            }

            @GeneratedBy(RemoveNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary interop_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
    }
}
