/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotReferences;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    private final PolyglotSourceCache sourceCache;
    final Map<Class<?>, PolyglotValue.InteropCodeCache> valueCodeCache;
    final Map<Object, Object> hostInteropCodeCache;
    private volatile OptionValuesImpl firstOptionValues;
    private volatile boolean needsInitializeMultiContext;
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> directLanguageSupplier;
    private final TruffleLanguage.ContextReference<Object> directContextSupplier;
    final Assumption singleContext;

    PolyglotLanguageInstance(PolyglotLanguage language) {
        this.language = language;
        this.sourceCache = new PolyglotSourceCache();
        this.valueCodeCache = new ConcurrentHashMap();
        this.hostInteropCodeCache = new ConcurrentHashMap<Object, Object>();
        this.singleContext = Truffle.getRuntime().createAssumption("Single context per language instance.");
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, this);
            if (!language.engine.singleContext.isValid()) {
                this.initializeMultiContext();
            } else {
                this.needsInitializeMultiContext = !language.engine.boundEngine && language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        this.directContextSupplier = PolyglotReferences.createAssumeSingleContext(language, this.singleContext, language.engine.noInnerContexts, language.getContextReference());
        this.directLanguageSupplier = PolyglotReferences.createAlwaysSingleLanguage(language, this);
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    boolean areOptionsCompatible(OptionValuesImpl newOptionValues) {
        OptionValuesImpl firstOptions = this.firstOptionValues;
        if (this.firstOptionValues == null) {
            return true;
        }
        return EngineAccessor.LANGUAGE.areOptionsCompatible(this.spi, firstOptions, newOptionValues);
    }

    void claim(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine));
        if (this.firstOptionValues == null) {
            this.firstOptionValues = optionValues;
        }
    }

    void patchFirstOptions(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine));
        this.firstOptionValues = optionValues;
    }

    void ensureMultiContextInitialized() {
        assert (Thread.holdsLock(this.language.engine));
        if (this.needsInitializeMultiContext) {
            this.needsInitializeMultiContext = false;
            this.language.engine.initializeMultiContext(null);
            this.initializeMultiContext();
        }
    }

    void initializeMultiContext() {
        assert (!this.language.engine.singleContext.isValid());
        if (this.language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE) {
            this.singleContext.invalidate();
            EngineAccessor.LANGUAGE.initializeMultiContext(this.spi);
        }
    }

    PolyglotSourceCache getSourceCache() {
        return this.sourceCache;
    }

    TruffleLanguage.ContextReference<Object> getDirectContextSupplier() {
        return this.directContextSupplier;
    }

    TruffleLanguage.ContextReference<Object> lookupContextSupplier(PolyglotLanguageInstance sourceLanguage) {
        TruffleLanguage.ContextReference<Object> ref;
        assert (this != sourceLanguage);
        switch (this.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                ref = PolyglotReferences.createAssumeSingleContext(this.language, this.language.engine.noInnerContexts, null, this.language.getContextReference());
                break;
            }
            case REUSE: 
            case SHARED: {
                ref = this.language.getContextReference();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return ref;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getDirectLanguageReference() {
        return this.directLanguageSupplier;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> lookupLanguageSupplier(PolyglotLanguageInstance sourceLanguage) {
        assert (this != sourceLanguage);
        switch (this.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                return PolyglotReferences.createAssumeSingleLanguage(this.language, this, this.language.singleInstance, this.language.getLanguageReference());
            }
            case REUSE: 
            case SHARED: {
                return this.language.getLanguageReference();
            }
        }
        throw new AssertionError();
    }

    TruffleLanguage.ContextPolicy getEffectiveContextPolicy(PolyglotLanguageInstance sourceRootLanguage) {
        TruffleLanguage.ContextPolicy sourcePolicy = this.language.engine.boundEngine ? TruffleLanguage.ContextPolicy.EXCLUSIVE : (sourceRootLanguage != null ? sourceRootLanguage.language.cache.getPolicy() : TruffleLanguage.ContextPolicy.SHARED);
        return sourcePolicy;
    }
}

