/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.impl.HomeFinder;
import com.oracle.truffle.api.impl.TruffleLocator;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotArrayIndexOutOfBoundsException;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotExecutionListener;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotIllegalStateException;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLogHandler;
import com.oracle.truffle.polyglot.PolyglotNullPointerException;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotSource;
import com.oracle.truffle.polyglot.PolyglotSourceSection;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import com.oracle.truffle.polyglot.PolyglotUnsupportedException;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.proxy.Proxy;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    private static final HostException STACKOVERFLOW_ERROR = new HostException(new StackOverflowError(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    });
    private final PolyglotSource sourceImpl = new PolyglotSource(this);
    private final PolyglotSourceSection sourceSectionImpl = new PolyglotSourceSection(this);
    private final PolyglotExecutionListener executionListenerImpl = new PolyglotExecutionListener(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    final Map<Class<?>, PolyglotValue> primitiveValues = new HashMap();
    Value hostNull;
    PolyglotValue disconnectedHostValue;

    protected void initialize() {
        this.hostNull = this.getAPIAccess().newValue((Object)HostObject.NULL, (AbstractPolyglotImpl.AbstractValueImpl)PolyglotValue.createHostNull(this));
        PolyglotValue.createDefaultValues(this, null, this.primitiveValues);
        this.disconnectedHostValue = new PolyglotValue.HostValue(this);
    }

    public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
        return this.sourceImpl;
    }

    public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
        return this.sourceSectionImpl;
    }

    public AbstractPolyglotImpl.AbstractExecutionListenerImpl getExecutionListenerImpl() {
        return this.executionListenerImpl;
    }

    public Context getCurrentContext() {
        PolyglotContextImpl context = PolyglotContextImpl.current();
        if (context == null) {
            return super.getCurrentContext();
        }
        return context.currentApi;
    }

    public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> options, long timeout, TimeUnit timeoutUnit, boolean sandbox, long maximumAllowedAllocationBytes, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, HostAccess conf) {
        Engine engine;
        PolyglotEngineImpl impl;
        if (TruffleOptions.AOT) {
            EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
        }
        OutputStream resolvedOut = out == null ? System.out : out;
        OutputStream resolvedErr = err == null ? System.err : err;
        InputStream resolvedIn = in == null ? System.in : in;
        DispatchOutputStream dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
        DispatchOutputStream dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
        Handler logHandler = PolyglotLogHandler.asHandler(logHandlerOrStream);
        logHandler = logHandler != null ? logHandler : PolyglotLogHandler.createStreamHandler(resolvedErr, false, true);
        ClassLoader contextClassLoader = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
        PolyglotEngineImpl polyglotEngineImpl = impl = boundEngine ? (PolyglotEngineImpl)this.preInitializedEngineRef.getAndSet(null) : null;
        if (impl != null && !impl.patch(dispatchOut, dispatchErr, resolvedIn, options, useSystemProperties, allowExperimentalOptions, contextClassLoader, boundEngine, logHandler)) {
            impl.ensureClosed(false, true);
            impl = null;
        }
        if (impl == null) {
            impl = new PolyglotEngineImpl(this, dispatchOut, dispatchErr, resolvedIn, options, allowExperimentalOptions, useSystemProperties, contextClassLoader, boundEngine, messageInterceptor, logHandler);
        }
        impl.creatorApi = engine = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
        impl.currentApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
        return engine;
    }

    public void preInitializeEngine() {
        Handler logHandler = PolyglotLogHandler.createStreamHandler(System.err, false, true);
        try {
            PolyglotEngineImpl preInitializedEngine = PolyglotEngineImpl.preInitialize(this, EngineAccessor.INSTRUMENT.createDispatchOutput(System.out), EngineAccessor.INSTRUMENT.createDispatchOutput(System.err), System.in, TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader(), logHandler);
            this.preInitializedEngineRef.set(preInitializedEngine);
        }
        finally {
            logHandler.flush();
        }
    }

    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
        PolyglotEngineImpl.resetPreInitializedEngine();
    }

    public Class<?> loadLanguageClass(String className) {
        for (ClassLoader loader : TruffleLocator.loaders()) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public Collection<Engine> findActiveEngines() {
        return PolyglotEngineImpl.findActiveEngines();
    }

    public Path findHome() {
        HomeFinder homeFinder = HomeFinder.getInstance();
        return homeFinder == null ? null : homeFinder.getHomeFolder();
    }

    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue) {
        return new PolyglotTargetMapping(sourceType, targetType, acceptsValue, convertValue);
    }

    @CompilerDirectives.TruffleBoundary
    public Value asValue(Object hostValue) {
        PolyglotContextImpl currentContext = PolyglotContextImpl.current();
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!(hostValue instanceof Value));
        PolyglotContextImpl valueContext = null;
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue(hostValue, (AbstractPolyglotImpl.AbstractValueImpl)this.primitiveValues.get(hostValue.getClass()));
        }
        if (HostWrapper.isInstance(hostValue)) {
            HostWrapper hostWrapper = HostWrapper.asInstance(hostValue);
            guestValue = hostWrapper.getGuestObject();
            valueContext = hostWrapper.getContext();
            return valueContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (hostValue instanceof Proxy ? PolyglotProxy.toProxyGuestObject(null, (Proxy)hostValue) : (hostValue instanceof Class ? HostObject.forClass((Class)hostValue, null) : HostObject.forObject(hostValue, null)));
        return this.getAPIAccess().newValue(guestValue, (AbstractPolyglotImpl.AbstractValueImpl)this.disconnectedHostValue);
    }

    org.graalvm.polyglot.Source getPolyglotSource(Source source) {
        org.graalvm.polyglot.Source polyglotSource = EngineAccessor.SOURCE.getPolyglotSource(source);
        if (polyglotSource == null) {
            polyglotSource = this.getAPIAccess().newSource(source.getLanguage(), (Object)source);
            EngineAccessor.SOURCE.setPolyglotSource(source, polyglotSource);
        }
        return polyglotSource;
    }

    org.graalvm.polyglot.SourceSection getPolyglotSourceSection(SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        org.graalvm.polyglot.Source polyglotSource = this.getPolyglotSource(sourceSection.getSource());
        return this.getAPIAccess().newSourceSection(polyglotSource, (Object)sourceSection);
    }

    static RuntimeException engineError(RuntimeException e) {
        throw new EngineException(e);
    }

    static <T extends Throwable> RuntimeException wrapHostException(PolyglotLanguageContext context, T e) {
        return PolyglotImpl.wrapHostException(context.context, e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException wrapHostException(PolyglotContextImpl context, T e) {
        if (e instanceof ThreadDeath) {
            throw (ThreadDeath)e;
        }
        if (e instanceof PolyglotException) {
            PolyglotException polyglot = (PolyglotException)e;
            if (context != null) {
                PolyglotExceptionImpl exceptionImpl = (PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl(polyglot);
                if (exceptionImpl.context == context || exceptionImpl.context == null || exceptionImpl.isHostException()) {
                    Throwable original = ((PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl((PolyglotException)polyglot)).exception;
                    if (original instanceof RuntimeException) {
                        throw (RuntimeException)original;
                    }
                    if (original instanceof Error) {
                        throw (Error)original;
                    }
                }
            }
        } else {
            if (e instanceof EngineException) {
                return ((EngineException)e).e;
            }
            if (e instanceof HostException) {
                return (HostException)e;
            }
            if (e instanceof InteropException) {
                throw ((InteropException)e).raise();
            }
        }
        try {
            return new HostException(e);
        }
        catch (StackOverflowError stack) {
            return STACKOVERFLOW_ERROR;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException wrapGuestException(PolyglotLanguageContext context, T e) {
        if (e instanceof PolyglotException) {
            return (PolyglotException)e;
        }
        PolyglotImpl.doRethrowPolyglotVariants(e);
        AbstractPolyglotImpl.APIAccess access = context.getEngine().impl.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(context, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException wrapGuestException(PolyglotEngineImpl engine, T e) {
        if (e instanceof PolyglotException) {
            return (PolyglotException)e;
        }
        PolyglotImpl.doRethrowPolyglotVariants(e);
        AbstractPolyglotImpl.APIAccess access = engine.impl.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    private static void doRethrowPolyglotVariants(Throwable e) {
        if (e instanceof EngineException) {
            throw ((EngineException)e).e;
        }
        if (e instanceof PolyglotUnsupportedException) {
            throw (PolyglotUnsupportedException)e;
        }
        if (e instanceof PolyglotClassCastException) {
            throw (PolyglotClassCastException)e;
        }
        if (e instanceof PolyglotIllegalStateException) {
            throw (PolyglotIllegalStateException)e;
        }
        if (e instanceof PolyglotNullPointerException) {
            throw (PolyglotNullPointerException)e;
        }
        if (e instanceof PolyglotIllegalArgumentException) {
            throw (PolyglotIllegalArgumentException)e;
        }
        if (e instanceof PolyglotArrayIndexOutOfBoundsException) {
            throw (PolyglotArrayIndexOutOfBoundsException)e;
        }
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String;
    }

    private static class EngineException
    extends RuntimeException {
        final RuntimeException e;

        EngineException(RuntimeException e) {
            this.e = e;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

