/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.StringJoiner;

abstract class HostMethodDesc {
    HostMethodDesc() {
    }

    abstract String getName();

    abstract HostMethodDesc[] getOverloads();

    boolean isInternal() {
        return false;
    }

    abstract boolean isMethod();

    abstract boolean isConstructor();

    static final class OverloadedMethod
    extends HostMethodDesc {
        private final SingleMethod[] overloads;

        OverloadedMethod(SingleMethod[] overloads) {
            this.overloads = overloads;
            assert (overloads.length >= 2);
        }

        public SingleMethod[] getOverloads() {
            return this.overloads;
        }

        @Override
        public String getName() {
            return this.getOverloads()[0].getName();
        }

        @Override
        public boolean isMethod() {
            return this.getOverloads()[0].isMethod();
        }

        @Override
        public boolean isConstructor() {
            return this.getOverloads()[0].isConstructor();
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(", ", "Method[", "]");
            for (SingleMethod overload : this.getOverloads()) {
                sj.add(overload.getReflectionMethod().toString());
            }
            return sj.toString();
        }

        @Override
        public boolean isInternal() {
            for (SingleMethod overload : this.overloads) {
                if (overload.isInternal()) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class SingleMethod
    extends HostMethodDesc {
        private final boolean varArgs;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Class<?>[] parameterTypes;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Type[] genericParameterTypes;

        protected SingleMethod(Executable executable) {
            this.varArgs = executable.isVarArgs();
            this.parameterTypes = executable.getParameterTypes();
            this.genericParameterTypes = executable.getGenericParameterTypes();
        }

        public abstract Executable getReflectionMethod();

        public final boolean isVarArgs() {
            return this.varArgs;
        }

        public abstract Class<?> getReturnType();

        public final Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public final int getParameterCount() {
            return this.parameterTypes.length;
        }

        public Type[] getGenericParameterTypes() {
            return this.genericParameterTypes;
        }

        @Override
        public String getName() {
            return this.getReflectionMethod().getName();
        }

        @Override
        public HostMethodDesc[] getOverloads() {
            return new HostMethodDesc[]{this};
        }

        public abstract Object invoke(Object var1, Object[] var2) throws Throwable;

        @Override
        public boolean isMethod() {
            return this.getReflectionMethod() instanceof Method;
        }

        @Override
        public boolean isConstructor() {
            return this.getReflectionMethod() instanceof Constructor;
        }

        static SingleMethod unreflect(Method reflectionMethod) {
            assert (SingleMethod.isAccessible(reflectionMethod));
            if (TruffleOptions.AOT || SingleMethod.isCallerSensitive(reflectionMethod)) {
                return new MethodReflectImpl(reflectionMethod);
            }
            return new MethodMHImpl(reflectionMethod);
        }

        static SingleMethod unreflect(Constructor<?> reflectionConstructor) {
            assert (SingleMethod.isAccessible(reflectionConstructor));
            if (TruffleOptions.AOT || SingleMethod.isCallerSensitive(reflectionConstructor)) {
                return new ConstructorReflectImpl(reflectionConstructor);
            }
            return new ConstructorMHImpl(reflectionConstructor);
        }

        static boolean isAccessible(Executable method) {
            return Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers());
        }

        static boolean isCallerSensitive(Executable method) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                switch (annotation.annotationType().getName()) {
                    case "sun.reflect.CallerSensitive": 
                    case "jdk.internal.reflect.CallerSensitive": {
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return "Method[" + this.getReflectionMethod().toString() + "]";
        }

        private static final class ConstructorMHImpl
        extends MHBase {
            private final Constructor<?> reflectionConstructor;

            ConstructorMHImpl(Constructor<?> reflectionConstructor) {
                super(reflectionConstructor);
                this.reflectionConstructor = reflectionConstructor;
            }

            @Override
            public Constructor<?> getReflectionMethod() {
                CompilerAsserts.neverPartOfCompilation();
                return this.reflectionConstructor;
            }

            @Override
            public Class<?> getReturnType() {
                return ((Constructor)this.getReflectionMethod()).getDeclaringClass();
            }

            @Override
            protected MethodHandle makeMethodHandle() {
                CompilerAsserts.neverPartOfCompilation();
                try {
                    MethodHandle methodHandle = MethodHandles.publicLookup().unreflectConstructor(this.reflectionConstructor);
                    return ConstructorMHImpl.adaptSignature(methodHandle, true, this.getParameterCount());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private static final class MethodMHImpl
        extends MHBase {
            private final Method reflectionMethod;

            MethodMHImpl(Method reflectionMethod) {
                super(reflectionMethod);
                this.reflectionMethod = reflectionMethod;
            }

            @Override
            public Method getReflectionMethod() {
                CompilerAsserts.neverPartOfCompilation();
                return this.reflectionMethod;
            }

            @Override
            public Class<?> getReturnType() {
                return this.getReflectionMethod().getReturnType();
            }

            @Override
            public boolean isInternal() {
                return this.getReflectionMethod().getDeclaringClass() == Object.class;
            }

            @Override
            protected MethodHandle makeMethodHandle() {
                CompilerAsserts.neverPartOfCompilation();
                try {
                    MethodHandle methodHandle = MethodHandles.publicLookup().unreflect(this.reflectionMethod);
                    return MethodMHImpl.adaptSignature(methodHandle, Modifier.isStatic(this.reflectionMethod.getModifiers()), this.reflectionMethod.getParameterCount());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private static abstract class MHBase
        extends SingleMethod {
            @CompilerDirectives.CompilationFinal
            private MethodHandle methodHandle;

            MHBase(Executable executable) {
                super(executable);
            }

            @Override
            public final Object invoke(Object receiver, Object[] arguments) throws Throwable {
                if (this.methodHandle == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.methodHandle = this.makeMethodHandle();
                }
                try {
                    return MHBase.invokeHandle(this.methodHandle, receiver, arguments);
                }
                catch (ClassCastException ex) {
                    throw UnsupportedTypeException.create(arguments);
                }
            }

            @CompilerDirectives.TruffleBoundary(allowInlining=true)
            private static Object invokeHandle(MethodHandle invokeHandle, Object receiver, Object[] arguments) throws Throwable {
                return invokeHandle.invokeExact(receiver, arguments);
            }

            protected abstract MethodHandle makeMethodHandle();

            protected static MethodHandle adaptSignature(MethodHandle originalHandle, boolean isStatic, int parameterCount) {
                MethodHandle adaptedHandle = originalHandle;
                adaptedHandle = adaptedHandle.asType(adaptedHandle.type().changeReturnType(Object.class));
                adaptedHandle = isStatic ? MethodHandles.dropArguments(adaptedHandle, 0, new Class[]{Object.class}) : adaptedHandle.asType(adaptedHandle.type().changeParameterType(0, Object.class));
                adaptedHandle = adaptedHandle.asSpreader(Object[].class, parameterCount);
                return adaptedHandle;
            }
        }

        private static final class ConstructorReflectImpl
        extends SingleMethod {
            private final Constructor<?> reflectionConstructor;

            ConstructorReflectImpl(Constructor<?> reflectionConstructor) {
                super(reflectionConstructor);
                this.reflectionConstructor = reflectionConstructor;
            }

            @Override
            public Constructor<?> getReflectionMethod() {
                CompilerAsserts.neverPartOfCompilation();
                return this.reflectionConstructor;
            }

            @Override
            public Object invoke(Object receiver, Object[] arguments) throws Throwable {
                try {
                    return ConstructorReflectImpl.reflectNewInstance(this.reflectionConstructor, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
                    throw UnsupportedTypeException.create(arguments);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            @CompilerDirectives.TruffleBoundary
            private static Object reflectNewInstance(Constructor<?> reflectionConstructor, Object[] arguments) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                return reflectionConstructor.newInstance(arguments);
            }

            @Override
            public Class<?> getReturnType() {
                return ((Constructor)this.getReflectionMethod()).getDeclaringClass();
            }
        }

        private static final class MethodReflectImpl
        extends SingleMethod {
            private final Method reflectionMethod;

            MethodReflectImpl(Method reflectionMethod) {
                super(reflectionMethod);
                this.reflectionMethod = reflectionMethod;
            }

            @Override
            public Method getReflectionMethod() {
                CompilerAsserts.neverPartOfCompilation();
                return this.reflectionMethod;
            }

            @Override
            public Object invoke(Object receiver, Object[] arguments) throws Throwable {
                try {
                    return MethodReflectImpl.reflectInvoke(this.reflectionMethod, receiver, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw UnsupportedTypeException.create(arguments);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            @CompilerDirectives.TruffleBoundary
            private static Object reflectInvoke(Method reflectionMethod, Object receiver, Object[] arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                return reflectionMethod.invoke(receiver, arguments);
            }

            @Override
            public Class<?> getReturnType() {
                return this.getReflectionMethod().getReturnType();
            }

            @Override
            public boolean isInternal() {
                return this.getReflectionMethod().getDeclaringClass() == Object.class;
            }
        }
    }
}

