/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import java.util.ArrayList;

final class TextMap {
    private final int[] nlOffsets;
    private final int textLength;
    final boolean finalNL;

    TextMap(int[] nlOffsets, int textLength, boolean finalNL) {
        this.nlOffsets = nlOffsets;
        this.textLength = textLength;
        this.finalNL = finalNL;
    }

    public static TextMap fromCharSequence(CharSequence text) {
        int nlIndex;
        int textLength = text.length();
        ArrayList<Integer> lines = new ArrayList<Integer>();
        lines.add(0);
        int offset = 0;
        while (offset < textLength && (nlIndex = TextMap.indexOf(text, 10, offset)) >= 0) {
            offset = nlIndex + 1;
            lines.add(offset);
        }
        lines.add(Integer.MAX_VALUE);
        int[] nlOffsets = new int[lines.size()];
        for (int line = 0; line < lines.size(); ++line) {
            nlOffsets[line] = (Integer)lines.get(line);
        }
        boolean finalNL = textLength > 0 && textLength == nlOffsets[nlOffsets.length - 2];
        return new TextMap(nlOffsets, textLength, finalNL);
    }

    private static int indexOf(CharSequence seq, int ch, int fromIndex) {
        if (seq instanceof String) {
            return ((String)seq).indexOf(ch, fromIndex);
        }
        int max = seq.length();
        int localFromIndex = fromIndex;
        if (localFromIndex < 0) {
            localFromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        if (ch >= 65536) {
            throw new UnsupportedOperationException();
        }
        for (int i = localFromIndex; i < max; ++i) {
            if (seq.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int offsetToLine(int offset) throws IllegalArgumentException {
        if (offset < 0 || offset > this.textLength) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        return TextMap.binarySearchLine(this.nlOffsets, offset) + 1;
    }

    private static int binarySearchLine(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            high = mid;
            break;
        }
        return high;
    }

    public int offsetToCol(int offset) throws IllegalArgumentException {
        return 1 + offset - this.nlOffsets[this.offsetToLine(offset) - 1];
    }

    public int length() {
        return this.textLength;
    }

    public int lineCount() {
        if (this.textLength == 0) {
            return 0;
        }
        return this.finalNL ? this.nlOffsets.length - 2 : this.nlOffsets.length - 1;
    }

    public int lineStartOffset(int line) throws IllegalArgumentException {
        if (this.lineOutOfRange(line)) {
            throw new IllegalArgumentException("line out of bounds");
        }
        return this.nlOffsets[line - 1];
    }

    public int lineLength(int line) throws IllegalArgumentException {
        if (this.lineOutOfRange(line)) {
            throw new IllegalArgumentException("line out of bounds");
        }
        if (line == this.nlOffsets.length - 1) {
            return this.textLength - this.nlOffsets[line - 1];
        }
        return this.nlOffsets[line] - this.nlOffsets[line - 1] - 1;
    }

    public int lineColumnToOffset(int line, int column) {
        int lineStartOffset = this.lineStartOffset(line);
        if (column > this.lineLength(line) + 1) {
            throw new IllegalArgumentException("column out of range");
        }
        int charIndex = lineStartOffset + column - 1;
        return charIndex;
    }

    private boolean lineOutOfRange(int line) {
        return line <= 0 || line >= this.nlOffsets.length;
    }
}

