package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject}.
 */
final class ClassNamesMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new ClassNamesMessageResolutionForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new ClassNamesMessageResolutionForeign(), null); }

    private ClassNamesMessageResolutionForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(ClassNamesHasSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ClassNamesGetSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ClassNamesReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesReadNode}.
     */
    abstract static class ClassNamesReadSubNode extends com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesReadNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject varNames, int index) {
            return access(varNames, index);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private ClassNamesReadSubNode node = com.oracle.truffle.polyglot.ClassNamesMessageResolutionForeignFactory.ClassNamesReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ClassNamesReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesGetSizeNode}.
     */
    abstract static class ClassNamesGetSizeSubNode extends com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesGetSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject varNames) {
            return access(varNames);
        }
        private static final class GET_SIZERootNode extends RootNode {
            protected GET_SIZERootNode() {
                super(null);
            }

            @Child private ClassNamesGetSizeSubNode node = com.oracle.truffle.polyglot.ClassNamesMessageResolutionForeignFactory.ClassNamesGetSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ClassNamesGetSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesHasSizeNode}.
     */
    abstract static class ClassNamesHasSizeSubNode extends com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.ClassNamesMessageResolution.ClassNamesHasSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject varNames) {
            return access(varNames);
        }
        private static final class HAS_SIZERootNode extends RootNode {
            protected HAS_SIZERootNode() {
                super(null);
            }

            @Child private ClassNamesHasSizeSubNode node = com.oracle.truffle.polyglot.ClassNamesMessageResolutionForeignFactory.ClassNamesHasSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_SIZE::" + com.oracle.truffle.polyglot.HostLanguage.ClassNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ClassNamesHasSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_SIZERootNode();
        }
    }
}
