package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.HostObjectMR}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.HostObject}.
 */
@GeneratedBy(com.oracle.truffle.polyglot.HostObjectMR.class)
final class HostObjectMRForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.createAccess(new HostObjectMRForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.createAccess(new HostObjectMRForeign(), null); }

    private HostObjectMRForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.HostObject.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(NullCheckSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(IsExecutableObjectSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(IsInstantiableObjectSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(BoxedCheckSubNode.createRoot());
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(HasKeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(ArrayHasSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ArrayGetSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessUnbox() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(UnboxSubNode.createRoot());
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(WriteSubNode.createRoot());
    }
    @Override
    public CallTarget accessRemove() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(RemoveSubNode.createRoot());
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ExecuteObjectSubNode.createRoot());
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(InvokeSubNode.createRoot());
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(NewSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(KeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(KeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.ExecuteObjectNode}.
     */
    abstract static class ExecuteObjectSubNode extends com.oracle.truffle.polyglot.HostObjectMR.ExecuteObjectNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.Object[] args) {
            return access(receiver, args);
        }
        private static final class EXECUTERootNode extends RootNode {
            protected EXECUTERootNode() {
                super(null);
            }

            @Child private ExecuteObjectSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.ExecuteObjectSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::EXECUTE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object[] args = new Object[arguments.length - 1];
                for (int i = 0; i < arguments.length - 1; i++) {
                    args[i] = arguments[i + 1];
                }
                try {
                    return node.executeWithTarget(frame, receiver, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ExecuteObjectSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new EXECUTERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.WriteNode}.
     */
    abstract static class WriteSubNode extends com.oracle.truffle.polyglot.HostObjectMR.WriteNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.Number index, java.lang.Object value) {
            return access(receiver, index, value);
        }
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.String name, java.lang.Object value) {
            return access(receiver, name, value);
        }
        private static final class WRITERootNode extends RootNode {
            protected WRITERootNode() {
                super(null);
            }

            @Child private WriteSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.WriteSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::WRITE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object identifier = arguments[1];
                Object value = arguments[2];
                try {
                    return node.executeWithTarget(frame, receiver, identifier, value);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof WriteSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new WRITERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.NewNode}.
     */
    abstract static class NewSubNode extends com.oracle.truffle.polyglot.HostObjectMR.NewNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.Object[] args) {
            return access(receiver, args);
        }
        private static final class NEWRootNode extends RootNode {
            protected NEWRootNode() {
                super(null);
            }

            @Child private NewSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.NewSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::NEW::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object[] args = new Object[arguments.length - 1];
                for (int i = 0; i < arguments.length - 1; i++) {
                    args[i] = arguments[i + 1];
                }
                try {
                    return node.executeWithTarget(frame, receiver, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NewSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new NEWRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.InvokeNode}.
     */
    abstract static class InvokeSubNode extends com.oracle.truffle.polyglot.HostObjectMR.InvokeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object, java.lang.String name, java.lang.Object[] args) {
            return access(object, name, args);
        }
        private static final class INVOKERootNode extends RootNode {
            protected INVOKERootNode() {
                super(null);
            }

            @Child private InvokeSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.InvokeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::INVOKE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object identifier = arguments[1];
                Object[] args = new Object[arguments.length - 2];
                for (int i = 0; i < arguments.length - 2; i++) {
                    args[i] = arguments[i + 2];
                }
                try {
                    return node.executeWithTarget(frame, receiver, identifier, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof InvokeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.ReadNode}.
     */
    abstract static class ReadSubNode extends com.oracle.truffle.polyglot.HostObjectMR.ReadNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object, java.lang.Number index) {
            return access(object, index);
        }
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object, java.lang.String name) {
            return access(object, name);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private ReadSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.ReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.KeysNode}.
     */
    abstract static class KeysSubNode extends com.oracle.truffle.polyglot.HostObjectMR.KeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, boolean includeInternal) {
            return access(receiver, includeInternal);
        }
        private static final class KEYSRootNode extends RootNode {
            protected KEYSRootNode() {
                super(null);
            }

            @Child private KeysSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.KeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEYS::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object internal = (arguments.length < 2) ? false : arguments[1];
                try {
                    return node.executeWithTarget(frame, receiver, internal);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEYSRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.NullCheckNode}.
     */
    abstract static class NullCheckSubNode extends com.oracle.truffle.polyglot.HostObjectMR.NullCheckNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object) {
            return access(object);
        }
        private static final class IS_NULLRootNode extends RootNode {
            protected IS_NULLRootNode() {
                super(null);
            }

            @Child private NullCheckSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.NullCheckSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_NULL::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NullCheckSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.UnboxNode}.
     */
    abstract static class UnboxSubNode extends com.oracle.truffle.polyglot.HostObjectMR.UnboxNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object) {
            return access(object);
        }
        private static final class UNBOXRootNode extends RootNode {
            protected UNBOXRootNode() {
                super(null);
            }

            @Child private UnboxSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.UnboxSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::UNBOX::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof UnboxSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new UNBOXRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.BoxedCheckNode}.
     */
    abstract static class BoxedCheckSubNode extends com.oracle.truffle.polyglot.HostObjectMR.BoxedCheckNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject object) {
            return access(object);
        }
        private static final class IS_BOXEDRootNode extends RootNode {
            protected IS_BOXEDRootNode() {
                super(null);
            }

            @Child private BoxedCheckSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.BoxedCheckSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_BOXED::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof BoxedCheckSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_BOXEDRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.IsExecutableObjectNode}.
     */
    abstract static class IsExecutableObjectSubNode extends com.oracle.truffle.polyglot.HostObjectMR.IsExecutableObjectNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver) {
            return access(receiver);
        }
        private static final class IS_EXECUTABLERootNode extends RootNode {
            protected IS_EXECUTABLERootNode() {
                super(null);
            }

            @Child private IsExecutableObjectSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.IsExecutableObjectSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_EXECUTABLE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsExecutableObjectSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_EXECUTABLERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.ArrayGetSizeNode}.
     */
    abstract static class ArrayGetSizeSubNode extends com.oracle.truffle.polyglot.HostObjectMR.ArrayGetSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver) {
            return access(receiver);
        }
        private static final class GET_SIZERootNode extends RootNode {
            protected GET_SIZERootNode() {
                super(null);
            }

            @Child private ArrayGetSizeSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.ArrayGetSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArrayGetSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.ArrayHasSizeNode}.
     */
    abstract static class ArrayHasSizeSubNode extends com.oracle.truffle.polyglot.HostObjectMR.ArrayHasSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver) {
            return access(receiver);
        }
        private static final class HAS_SIZERootNode extends RootNode {
            protected HAS_SIZERootNode() {
                super(null);
            }

            @Child private ArrayHasSizeSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.ArrayHasSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_SIZE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArrayHasSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_SIZERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.IsInstantiableObjectNode}.
     */
    abstract static class IsInstantiableObjectSubNode extends com.oracle.truffle.polyglot.HostObjectMR.IsInstantiableObjectNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver) {
            return access(receiver);
        }
        private static final class IS_INSTANTIABLERootNode extends RootNode {
            protected IS_INSTANTIABLERootNode() {
                super(null);
            }

            @Child private IsInstantiableObjectSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.IsInstantiableObjectSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_INSTANTIABLE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsInstantiableObjectSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_INSTANTIABLERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.RemoveNode}.
     */
    abstract static class RemoveSubNode extends com.oracle.truffle.polyglot.HostObjectMR.RemoveNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.Number index) {
            return access(receiver, index);
        }
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.String name) {
            return access(receiver, name);
        }
        private static final class REMOVERootNode extends RootNode {
            protected REMOVERootNode() {
                super(null);
            }

            @Child private RemoveSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.RemoveSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::REMOVE::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof RemoveSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new REMOVERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.KeyInfoNode}.
     */
    abstract static class KeyInfoSubNode extends com.oracle.truffle.polyglot.HostObjectMR.KeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, int index) {
            return access(receiver, index);
        }
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.Number index) {
            return access(receiver, index);
        }
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver, java.lang.String name) {
            return access(receiver, name);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private KeyInfoSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.KeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostObjectMR.HasKeysNode}.
     */
    abstract static class HasKeysSubNode extends com.oracle.truffle.polyglot.HostObjectMR.HasKeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostObject receiver) {
            return access(receiver);
        }
        private static final class HAS_KEYSRootNode extends RootNode {
            protected HAS_KEYSRootNode() {
                super(null);
            }

            @Child private HasKeysSubNode node = com.oracle.truffle.polyglot.HostObjectMRForeignFactory.HasKeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_KEYS::" + com.oracle.truffle.polyglot.HostObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof HasKeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_KEYSRootNode();
        }
    }
}
