package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.HostFunctionMR}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.HostFunction}.
 */
@GeneratedBy(com.oracle.truffle.polyglot.HostFunctionMR.class)
final class HostFunctionMRForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.createAccess(new HostFunctionMRForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.createAccess(new HostFunctionMRForeign(), null); }

    private HostFunctionMRForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.HostFunction.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(IsExecutableSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ExecuteSubNode.createRoot());
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostFunctionMR.ExecuteNode}.
     */
    abstract static class ExecuteSubNode extends com.oracle.truffle.polyglot.HostFunctionMR.ExecuteNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostFunction function, java.lang.Object[] args) {
            return access(function, args);
        }
        private static final class EXECUTERootNode extends RootNode {
            protected EXECUTERootNode() {
                super(null);
            }

            @Child private ExecuteSubNode node = com.oracle.truffle.polyglot.HostFunctionMRForeignFactory.ExecuteSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::EXECUTE::" + com.oracle.truffle.polyglot.HostFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object[] args = new Object[arguments.length - 1];
                for (int i = 0; i < arguments.length - 1; i++) {
                    args[i] = arguments[i + 1];
                }
                try {
                    return node.executeWithTarget(frame, receiver, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ExecuteSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new EXECUTERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.HostFunctionMR.IsExecutableNode}.
     */
    abstract static class IsExecutableSubNode extends com.oracle.truffle.polyglot.HostFunctionMR.IsExecutableNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.HostFunction receiver) {
            return access(receiver);
        }
        private static final class IS_EXECUTABLERootNode extends RootNode {
            protected IS_EXECUTABLERootNode() {
                super(null);
            }

            @Child private IsExecutableSubNode node = com.oracle.truffle.polyglot.HostFunctionMRForeignFactory.IsExecutableSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_EXECUTABLE::" + com.oracle.truffle.polyglot.HostFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsExecutableSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_EXECUTABLERootNode();
        }
    }
}
