package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject}.
 */
@GeneratedBy(com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.class)
final class ArguentsArrayMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.createAccess(new ArguentsArrayMessageResolutionForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.createAccess(new ArguentsArrayMessageResolutionForeign(), null); }

    private ArguentsArrayMessageResolutionForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(ArgsArrHasSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ArgsArrGetSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ArgsArrReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ArgsArrWriteSubNode.createRoot());
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrWriteNode}.
     */
    abstract static class ArgsArrWriteSubNode extends com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrWriteNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject argsArr, int index, java.lang.Object value) {
            return access(argsArr, index, value);
        }
        private static final class WRITERootNode extends RootNode {
            protected WRITERootNode() {
                super(null);
            }

            @Child private ArgsArrWriteSubNode node = com.oracle.truffle.polyglot.ArguentsArrayMessageResolutionForeignFactory.ArgsArrWriteSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::WRITE::" + com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object identifier = arguments[1];
                Object value = arguments[2];
                try {
                    return node.executeWithTarget(frame, receiver, identifier, value);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArgsArrWriteSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new WRITERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrReadNode}.
     */
    abstract static class ArgsArrReadSubNode extends com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrReadNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject argsArr, int index) {
            return access(argsArr, index);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private ArgsArrReadSubNode node = com.oracle.truffle.polyglot.ArguentsArrayMessageResolutionForeignFactory.ArgsArrReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArgsArrReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrGetSizeNode}.
     */
    abstract static class ArgsArrGetSizeSubNode extends com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrGetSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject argsArr) {
            return access(argsArr);
        }
        private static final class GET_SIZERootNode extends RootNode {
            protected GET_SIZERootNode() {
                super(null);
            }

            @Child private ArgsArrGetSizeSubNode node = com.oracle.truffle.polyglot.ArguentsArrayMessageResolutionForeignFactory.ArgsArrGetSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArgsArrGetSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrHasSizeNode}.
     */
    abstract static class ArgsArrHasSizeSubNode extends com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.ArguentsArrayMessageResolution.ArgsArrHasSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject argsArr) {
            return access(argsArr);
        }
        private static final class HAS_SIZERootNode extends RootNode {
            protected HAS_SIZERootNode() {
                super(null);
            }

            @Child private ArgsArrHasSizeSubNode node = com.oracle.truffle.polyglot.ArguentsArrayMessageResolutionForeignFactory.ArgsArrHasSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_SIZE::" + com.oracle.truffle.polyglot.DefaultScope.ArgumentsArrayObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ArgsArrHasSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_SIZERootNode();
        }
    }
}
